/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.MatDimensionHelper;

public class PurPriceMaterialNoSetPrice
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(PurPriceMaterialNoSetPrice.class);

    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        List<ConfigBomInfo> configBomInfoList = standCostCalcParam.getConfigBomInfoList();
        HashSet<String> purKeycols = new HashSet<String>(10);
        HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            if (configBomInfo.isPurPrice().booleanValue()) {
                purKeycols.add(configBomInfo.getKeycol());
            }
            Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                pids.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        purKeycols.addAll(standCostCalcParam.getCalcPurMaterials());
        logger.info("standCostCalcParam.getPruPriceObjIds():{}", standCostCalcParam.getPruPriceObjIds());
        Map<Long, List<DynamicObject>> materialKeyColObjMap = this.getMaterialKeyColObjMap(new ArrayList<String>(purKeycols));
        Map dimensionByMatIds = MatDimensionHelper.getDimensionByMatIds((Long)standCostCalcParam.getCostTypeId(), materialKeyColObjMap.keySet());
        Map<String, String> actualKeycolMap = BomRuleSettingStdCalcHelper.getActualKeycolMap(materialKeyColObjMap, dimensionByMatIds);
        logger.info("considerCalcDimen1 actualKeycolMap:{},{},{}", new Object[]{actualKeycolMap, actualKeycolMap.keySet(), actualKeycolMap.values()});
        Set<String> purPriceKeycols = this.getPurPriceSetting(standCostCalcParam.getPruPriceObjIds(), new HashSet<String>(actualKeycolMap.values()));
        logger.info("considerCalcDimen1 purPriceKeycols:{}", purPriceKeycols);
        HashSet nofoundKeycols = Sets.newHashSetWithExpectedSize((int)8);
        for (String purKeycol : purKeycols) {
            String actualKey = actualKeycolMap.get(purKeycol);
            if (purPriceKeycols.contains(actualKey)) continue;
            nofoundKeycols.add(actualKey);
        }
        if (CadEmptyUtils.isEmpty(nofoundKeycols)) {
            return;
        }
        Set<String> purMatCostInfoKeyCols = this.getPurPriceSettingKeyCols(standCostCalcParam.getPurMatCostInfoMap(), nofoundKeycols);
        nofoundKeycols.removeAll(purMatCostInfoKeyCols);
        if (nofoundKeycols.isEmpty()) {
            return;
        }
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(nofoundKeycols);
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        DataSet cpDataSet = bomMatDataSetByKeyCol.copy();
        while (cpDataSet.hasNext()) {
            Row row = cpDataSet.next();
            Long auxpty = row.getLong("auxproperty");
            if (CadEmptyUtils.isEmpty(auxpty)) continue;
            auxptyIds.add(auxpty);
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        while (bomMatDataSetByKeyCol.hasNext()) {
            StringBuilder auxStr;
            JSONObject value;
            String auxValueStr;
            Row row = bomMatDataSetByKeyCol.next();
            String keycol = row.getString("keycol");
            Long material = row.getLong("material");
            Long auxpropId = row.getLong("auxproperty");
            Long configuredCode = row.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(material)) continue;
            String error = "";
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            if (!CadEmptyUtils.isEmpty(auxpropId) && !CadEmptyUtils.isEmpty(configuredCode)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\u201d\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u6210\u672c\u3002", (String)"PurPriceMaterialNoSetPrice_5", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")), row.getString("configuredcodenum"));
            } else if (!CadEmptyUtils.isEmpty(auxpropId)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\u201d\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u6210\u672c\u3002", (String)"PurPriceMaterialNoSetPrice_6", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")));
            } else {
                error = !CadEmptyUtils.isEmpty(configuredCode) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%3$s\u201d\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u6210\u672c\u3002", (String)"PurPriceMaterialNoSetPrice_7", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), row.getString("configuredcodenum")) : String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u6210\u672c\u3002", (String)"PurPriceMaterialNoSetPrice_8", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"));
            }
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
            StringBuilder path = new StringBuilder();
            StringBuilder tempPath = new StringBuilder(keycol);
            StandCalcCheckHelper.getCalcTopLevelMat(keycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
        }
        logger.info("considerCalcDimen1 purMatCostInfoKeyCols:{}", purMatCostInfoKeyCols);
        purPriceKeycols.addAll(purMatCostInfoKeyCols);
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"PurPriceMaterialNoSetPrice_4", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }

    private Set<String> getPurPriceSetting(List<Long> purPriceObjIds, Set<String> purPriceKeyCols) {
        HashSet purPriceKeycols = Sets.newHashSet();
        for (List purPriceObjIdList : Lists.partition(purPriceObjIds, (int)200000)) {
            QFilter filter = new QFilter("id", "in", (Object)purPriceObjIdList);
            filter.and(new QFilter("keycol", "in", purPriceKeyCols));
            DynamicObjectCollection purPriceObjs = StdCalculateHelper.getPurPriceObjsOnlyKeycol(filter.toArray());
            for (DynamicObject priceObj : purPriceObjs) {
                String keycol = priceObj.getString("keycol");
                purPriceKeycols.add(keycol);
            }
        }
        return purPriceKeycols;
    }

    private Set<String> getPurPriceSettingKeyCols(Map<String, Long> purMatCostInfoMap, Set<String> notFoundSet) {
        HashSet purPriceKeycols = Sets.newHashSet();
        QFilter filter = new QFilter("id", "in", (Object)Sets.newHashSet(purMatCostInfoMap.values()));
        filter.and(new QFilter("keycol", "in", notFoundSet));
        DynamicObjectCollection purPriceObjs = StdCalculateHelper.getMatCostInfoObjsOnlyKeycol(filter.toArray());
        for (DynamicObject priceObj : purPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceKeycols.add(keycol);
        }
        return purPriceKeycols;
    }

    private Map<Long, List<DynamicObject>> getMaterialKeyColObjMap(List<String> keyCols) {
        QFilter filter = new QFilter("keycol", "in", keyCols);
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"keycol,material,matvers,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{filter});
        HashMap<Long, List<DynamicObject>> materialKeyColObjMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dyKeyCol : dyKeyCols) {
            materialKeyColObjMap.computeIfAbsent(dyKeyCol.getLong("material"), p -> new ArrayList()).add(dyKeyCol);
        }
        return materialKeyColObjMap;
    }
}

