/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import org.apache.commons.lang3.StringUtils;

public class ResourceOutSettingChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        DynamicObject dynamicObject;
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        Map<Object, DynamicObject> routerIdAndRouterObjMap = standCostCalcParam.getRouterIdAndRouterObjMap();
        if (CadEmptyUtils.isEmpty(routerIdAndRouterObjMap)) {
            return;
        }
        List<ConfigBomInfo> configBomInfoList = standCostCalcParam.getConfigBomInfoList();
        HashSet<Long> proOutSourceMaterialIds = new HashSet<Long>();
        if (!CadEmptyUtils.isEmpty(configBomInfoList)) {
            for (ConfigBomInfo configBomInfo : configBomInfoList) {
                if (!configBomInfo.isProduce().booleanValue() && !configBomInfo.isOutSource().booleanValue() && (configBomInfo.getPid() != 0L || !configBomInfo.isVirtual().booleanValue())) continue;
                proOutSourceMaterialIds.add(configBomInfo.getMaterial());
            }
        }
        if (CadEmptyUtils.isEmpty(proOutSourceMaterialIds)) {
            return;
        }
        HashMap<Long, Set<Long>> configBomKeycolPidsMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getMaterial(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                pids.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        ArrayList<Long> routeIds = new ArrayList<Long>(200);
        ArrayList<Long> processEntryIds = new ArrayList<Long>(200);
        for (Map.Entry entry : routerIdAndRouterObjMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (value == null) continue;
            routeIds.add(value.getLong("id"));
            DynamicObjectCollection processEntrys = value.getDynamicObjectCollection("processentry");
            for (DynamicObject processEntry : processEntrys) {
                processEntryIds.add(processEntry.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(processEntryIds)) {
            return;
        }
        String srcEntity = "cad_router";
        if (standCostCalcParam.isTrackCalc().booleanValue() || standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            srcEntity = "pdm_route";
        } else if (standCostCalcParam.isStartRouteRuleCalc().booleanValue() && (dynamicObject = StdCalculateHelper.getRouteRuleSettingObj(standCostCalcParam.getRouteRuleSetting())) != null) {
            srcEntity = dynamicObject.getString("srcroute");
        }
        DataSet dataSet2 = BomRuleSettingStdCalcHelper.getWxRouteDataSet(srcEntity, routeIds);
        dataSet2 = dataSet2.filter("processentryid in (" + StringUtils.join(processEntryIds, (String)",") + ")");
        if (dataSet2.isEmpty()) {
            return;
        }
        DataSet[] dataSets = dataSet2.splitByFilter(new String[]{"processtype='A'", "processtype='B'"}, Boolean.FALSE.booleanValue());
        DataSet matWxRouteDataSet = dataSets[0];
        DataSet matGroupWxRouteDataSet = dataSets[1];
        matGroupWxRouteDataSet = this.dealMatGroupWxRouteDataSet(matGroupWxRouteDataSet, standCostCalcParam.getCostTypeId(), standCostCalcParam.isStartRouteRuleCalc());
        DataSet matWxRouteDataSetNew = matWxRouteDataSet.union(matGroupWxRouteDataSet);
        DataSet outResourcePriceDataSet = this.getOutResourcePriceDataSet(standCostCalcParam.getOutSourceObjIds());
        DataSet dataSet3 = matWxRouteDataSetNew.join(outResourcePriceDataSet, JoinType.LEFT).on("id", "route").on("processseq", "processseq").on("operationno", "operationno").select(matWxRouteDataSetNew.getRowMeta().getFieldNames(), new String[]{"resid"}).finish();
        if ((dataSet3 = dataSet3.filter("resid is null").distinct()).isEmpty()) {
            return;
        }
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        DataSet copy = dataSet3.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long material = row.getLong("material");
            Long auxproperty = row.getLong("auxproperty");
            if (!CadEmptyUtils.isEmpty(material)) {
                materialIds.add(material);
            }
            if (CadEmptyUtils.isEmpty(auxproperty)) continue;
            auxptyIds.add(auxproperty);
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        DataSet matdataSet = QueryServiceHelper.queryDataSet((String)"doCheck", (String)"bd_material", (String)"id,number matnumber,name matname", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)}, null);
        dataSet3 = dataSet3.join(matdataSet, JoinType.INNER).on("material", "id").select(dataSet3.getRowMeta().getFieldNames(), new String[]{"matnumber", "matname"}).finish();
        while (dataSet3.hasNext()) {
            Row row = dataSet3.next();
            String matNumber = row.getString("matnumber");
            String matName = row.getString("matname");
            String number = row.getString("number");
            String name = row.getString("name");
            String processSeq = row.getString("processseq");
            String operationNo = row.getString("operationno");
            Long material = row.getLong("material");
            Long auxproperty = row.getLong("auxproperty");
            String key = material + "@" + auxproperty;
            if (!proOutSourceMaterialIds.contains(material)) continue;
            String error = "";
            if (!CadEmptyUtils.isEmpty(auxproperty)) {
                String auxValueStr = (String)auxptyMap.get(auxproperty);
                JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                StringBuilder auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%4$s\uff1b\u540d\u79f0\uff1a%5$s\u201d\u3001\u5e8f\u5217\u53f7\u201c%6$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%7$s\u201d\u6309\u53d6\u4ef7\u89c4\u5219\u672a\u627e\u5230\u6709\u6548\u7684\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u3002", (String)"ResourceOutSettingChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]), matNumber, matName, auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")), number, name, processSeq, operationNo);
            } else {
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%3$s\uff1b\u540d\u79f0\uff1a%4$s\u201d\u3001\u5e8f\u5217\u53f7\u201c%5$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%6$s\u201d\u6309\u53d6\u4ef7\u89c4\u5219\u672a\u627e\u5230\u6709\u6548\u7684\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u3002", (String)"ResourceOutSettingChecker_1", (String)"macc-cad-algox", (Object[])new Object[0]), matNumber, matName, number, name, processSeq, operationNo);
            }
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
            StringBuilder path = new StringBuilder();
            StringBuilder tempPath = new StringBuilder(String.valueOf(material));
            StandCalcCheckHelper.getCalcTopLevelMat(material, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ResourceOutSettingChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }

    public DataSet getOutResourcePriceDataSet(List<Long> outResourceObjIds) {
        QFilter filter = new QFilter("id", "in", outResourceObjIds);
        return QueryServiceHelper.queryDataSet((String)"getOutResourcePriceDataSet", (String)"cad_resourceout", (String)"id as resid,manuorg,route,processseq,operationno", (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet dealMatGroupWxRouteDataSet(DataSet matGroupWxRouteDataSet, Long costTypeId, Boolean startRouteRule) {
        if (startRouteRule.booleanValue()) {
            DataSet copyMatGroupWxRouteDataSet = matGroupWxRouteDataSet.copy();
            ArrayList<Long> matGroupIds = new ArrayList<Long>(10);
            while (copyMatGroupWxRouteDataSet.hasNext()) {
                Row row = copyMatGroupWxRouteDataSet.next();
                matGroupIds.add(row.getLong("materialgroup"));
            }
            QFilter mftFilter = new QFilter("mftcontrolentry.materialcontrol.id", "in", matGroupIds);
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            DataSet materialMftInfoDataSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)"bd_materialmftinfo", (String)"masterid,0L auxpty,mftcontrolentry.materialcontrol materialcontrol", (QFilter[])new QFilter[]{mftFilter, status, enable}, null);
            matGroupWxRouteDataSet = matGroupWxRouteDataSet.join(materialMftInfoDataSet, JoinType.INNER).on("materialgroup", "materialcontrol").select(matGroupWxRouteDataSet.getRowMeta().getFieldNames(), new String[]{"masterid", "auxpty"}).finish();
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("routertype", "=", (Object)"B"));
            filter.and("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            DataSet processRouteDataSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)"cad_routersetting", (String)"materialentry.material masterid,materialentry.auxpty auxpty,router", (QFilter[])new QFilter[]{filter}, null);
            matGroupWxRouteDataSet = matGroupWxRouteDataSet.join(processRouteDataSet, JoinType.INNER).on("id", "router").select(matGroupWxRouteDataSet.getRowMeta().getFieldNames(), new String[]{"masterid", "auxpty"}).finish();
        }
        return matGroupWxRouteDataSet.select("id,number,name,createorg,processtype,materialgroup,masterid as material,auxpty as auxproperty,machiningtype,productionorg,processseq,operationno,operation,operationdesc,workstation,processentryid,sourceid,manuorg");
    }
}

