/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;

public class ResourceRateSettingChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        StringBuilder tempPath;
        StringBuilder path;
        String error;
        CalcCheckDetailResultInfo detailinfo;
        String[] infos;
        Set<Long> matIds;
        String routerId;
        DynamicObject routeRuleSettingObj;
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        Map<Object, DynamicObject> routerIdAndRouterObjMap = standCostCalcParam.getRouterIdAndRouterObjMap();
        if (CadEmptyUtils.isEmpty(routerIdAndRouterObjMap)) {
            return;
        }
        List<ConfigBomInfo> configBomInfoList = standCostCalcParam.getConfigBomInfoList();
        ArrayList<String> matKeycols = new ArrayList<String>(10);
        HashSet<Long> proOutSourceMaterialIds = new HashSet<Long>();
        if (!CadEmptyUtils.isEmpty(configBomInfoList)) {
            for (ConfigBomInfo configBomInfo : configBomInfoList) {
                if (!configBomInfo.isProduce().booleanValue() && !configBomInfo.isOutSource().booleanValue() && (configBomInfo.getPid() != 0L || !configBomInfo.isVirtual().booleanValue())) continue;
                proOutSourceMaterialIds.add(configBomInfo.getMaterial());
                matKeycols.add(configBomInfo.getKeycol());
            }
        }
        if (CadEmptyUtils.isEmpty(proOutSourceMaterialIds)) {
            return;
        }
        ArrayList<String> notSetResourceRouters = new ArrayList<String>(10);
        ArrayList<String> notSetResourceRates = new ArrayList<String>(10);
        ArrayList<Long> processEntryIds = new ArrayList<Long>(200);
        for (Map.Entry<Object, DynamicObject> routerIdAndRouterObj : routerIdAndRouterObjMap.entrySet()) {
            DynamicObject value = routerIdAndRouterObj.getValue();
            if (value == null) continue;
            DynamicObjectCollection processEntrys = value.getDynamicObjectCollection("processentry");
            for (DynamicObject processEntry : processEntrys) {
                processEntryIds.add(processEntry.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(processEntryIds)) {
            return;
        }
        String srcEntity = "cad_router";
        if (standCostCalcParam.isTrackCalc().booleanValue() || standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            srcEntity = "pdm_route";
        } else if (standCostCalcParam.isStartRouteRuleCalc().booleanValue() && (routeRuleSettingObj = StdCalculateHelper.getRouteRuleSettingObj(standCostCalcParam.getRouteRuleSetting())) != null) {
            srcEntity = routeRuleSettingObj.getString("srcroute");
        }
        DynamicObjectCollection resuorceCollection = this.getRouterResources(srcEntity, processEntryIds);
        if (CadEmptyUtils.isEmpty(resuorceCollection)) {
            return;
        }
        HashSet<String> calMatInfos = new HashSet<String>(200);
        HashMap<Long, String[]> matInfoMap = new HashMap<Long, String[]>(16);
        DataSet matInfoDataSet = ResourceRateSettingChecker.getBomMatDataSetByKeyCol(matKeycols, proOutSourceMaterialIds);
        while (matInfoDataSet.hasNext()) {
            Row row = matInfoDataSet.next();
            Long material = row.getLong("material");
            String matStr = material + "@" + row.getLong("auxproperty");
            calMatInfos.add(matStr);
            if (matInfoMap.containsKey(material)) continue;
            matInfoMap.put(material, new String[]{row.getString("matnumber"), row.getString("matname")});
        }
        this.getNoSetResourceRouter(resuorceCollection, standCostCalcParam.getInSourceObjIds(), notSetResourceRouters, notSetResourceRates, calMatInfos, standCostCalcParam.getProcessSeqOutSourceMap(), standCostCalcParam.getProOrgCostTypeMap(), standCostCalcParam.getMnHsCostTypeMap());
        Map<Long, Set<Long>> routerMatMap = this.getRouterMatMap(resuorceCollection, proOutSourceMaterialIds);
        HashMap<Long, Set<Long>> configBomKeycolPidsMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : configBomInfoList) {
            Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getMaterial(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                pids.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        for (String routerInfo : notSetResourceRouters) {
            String[] routerInfos = routerInfo.split("@");
            routerId = routerInfos[4];
            matIds = routerMatMap.get(Long.parseLong(routerId));
            if (CadEmptyUtils.isEmpty(matIds)) continue;
            for (Long matId : matIds) {
                infos = (String[])matInfoMap.get(matId);
                if (infos == null) continue;
                detailinfo = new CalcCheckDetailResultInfo();
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%3$s\uff1b\u540d\u79f0\uff1a%4$s\u201d\u5728\u5de5\u5e8f\u53f7\u201c%5$s\u201d\u5bf9\u5e94\u7684\u5de5\u5e8f\u6d3b\u52a8\u4e2d\u672a\u8bbe\u7f6e\u8d44\u6e90\u3002", (String)"ResourceRateSettingChecker_7", (String)"macc-cad-algox", (Object[])new Object[0]), infos[0], infos[1], routerInfos[0], routerInfos[1], routerInfos[2], routerInfos[3]);
                detailinfo.setCheckDetailResult(error);
                this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
                if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
                path = new StringBuilder();
                tempPath = new StringBuilder(String.valueOf(matId));
                StandCalcCheckHelper.getCalcTopLevelMat(matId, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
            }
        }
        for (String notSetResourceRate : notSetResourceRates) {
            String[] resourceInfos = notSetResourceRate.split("@");
            routerId = resourceInfos[4];
            matIds = routerMatMap.get(Long.parseLong(routerId));
            if (CadEmptyUtils.isEmpty(matIds)) continue;
            for (Long matId : matIds) {
                infos = (String[])matInfoMap.get(matId);
                if (infos == null) continue;
                detailinfo = new CalcCheckDetailResultInfo();
                error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u201c\u7f16\u7801\uff1a%3$s\uff1b\u540d\u79f0\uff1a%4$s\u201d\u5728\u5de5\u5e8f\u53f7\u201c%5$s\u201d\u5bf9\u5e94\u7684\u5de5\u5e8f\u6d3b\u52a8\u4e2d\u8bbe\u7f6e\u7684\u81ea\u5236\u8d44\u6e90\u201c\u7f16\u7801\uff1a%6$s\uff1b\u540d\u79f0\uff1a%7$s\u201d\u6ca1\u6709\u8bbe\u7f6e\u6807\u51c6\u5de5\u65f6\u8d39\u7387\u3002", (String)"ResourceRateSettingChecker_8", (String)"macc-cad-algox", (Object[])new Object[0]), infos[0], infos[1], resourceInfos[0], resourceInfos[1], resourceInfos[2], resourceInfos[3], resourceInfos[5], resourceInfos[6]);
                detailinfo.setCheckDetailResult(error);
                this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
                if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
                path = new StringBuilder();
                tempPath = new StringBuilder(String.valueOf(matId));
                StandCalcCheckHelper.getCalcTopLevelMat(matId, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
            }
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ResourceRateSettingChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }

    private Map<Long, Set<Long>> getRouterMatMap(DynamicObjectCollection resuorceCollection, Set<Long> proOutSourceMaterialIds) {
        HashMap<Long, Set<Long>> matRouterMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> materialGroups = new HashSet<Long>(10);
        HashMap<Long, DynamicObject> matGroupRouterMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject commonRouter = null;
        for (DynamicObject dynamicObject : resuorceCollection) {
            long id = dynamicObject.getLong("id");
            long material = dynamicObject.getLong("material");
            long materialGroup = dynamicObject.getLong("materialgroup");
            if (!CadEmptyUtils.isEmpty(material)) {
                matRouterMap.computeIfAbsent(id, p -> new HashSet()).add(material);
            }
            if (!CadEmptyUtils.isEmpty(materialGroup)) {
                materialGroups.add(materialGroup);
                matGroupRouterMap.put(materialGroup, dynamicObject);
            }
            if (commonRouter != null || !"C".equals(dynamicObject.getString("processtype"))) continue;
            commonRouter = dynamicObject;
        }
        if (!CadEmptyUtils.isEmpty(matGroupRouterMap)) {
            QFilter filter = new QFilter("mftcontrolentry.materialcontrol", "in", materialGroups);
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection infos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"mftcontrolentry.materialcontrol materialcontrol,masterid", (QFilter[])new QFilter[]{filter, status, enable});
            HashMap<Long, List> materialGroupMap = new HashMap<Long, List>(10);
            for (DynamicObject info : infos) {
                long material = info.getLong("masterid");
                if (matRouterMap.containsKey(material)) continue;
                materialGroupMap.computeIfAbsent(info.getLong("materialcontrol"), p -> new ArrayList()).add(material);
            }
            for (Map.Entry entry : materialGroupMap.entrySet()) {
                Long matGroup = (Long)entry.getKey();
                List matIds = (List)entry.getValue();
                DynamicObject router = (DynamicObject)matGroupRouterMap.get(matGroup);
                if (router == null) continue;
                for (Long matId : matIds) {
                    matRouterMap.computeIfAbsent(router.getLong("id"), p -> new HashSet()).add(matId);
                }
            }
        }
        proOutSourceMaterialIds.removeAll(matRouterMap.keySet());
        if (commonRouter != null) {
            for (Long proOutSourceMaterialId : proOutSourceMaterialIds) {
                matRouterMap.computeIfAbsent(commonRouter.getLong("id"), p -> new HashSet()).add(proOutSourceMaterialId);
            }
        }
        return matRouterMap;
    }

    public static DataSet getBomMatDataSetByKeyCol(List<String> specifyMaterialKeycols, Set<Long> proOutSourceMaterialIds) {
        QFilter kcFilter = new QFilter("keycol", "in", specifyMaterialKeycols);
        kcFilter.and(new QFilter("material", "in", proOutSourceMaterialIds));
        DataSet keyColsDataSet = QueryServiceHelper.queryDataSet((String)"getBomMatFilterByKeyCol", (String)"cad_keycol", (String)"keycol,material,material.number matnumber,material.name matname,auxproperty", (QFilter[])new QFilter[]{kcFilter}, null);
        return keyColsDataSet;
    }

    private DynamicObjectCollection getRouterResources(String entity, List<Long> processEntryIds) {
        if (CadEmptyUtils.isEmpty(processEntryIds)) {
            return new DynamicObjectCollection();
        }
        QFilter routeFilter = new QFilter("processentry.id", "in", processEntryIds);
        QFilter machiningtypeFilter = new QFilter("processentry.machiningtype", "!=", (Object)"1002");
        String fields = "manuorg,";
        if ("pdm_route".equals(entity)) {
            fields = "createorg as manuorg,";
        }
        DynamicObjectCollection resuorceCollection = QueryServiceHelper.query((String)entity, (String)("id,number,name,material,materialgroup,auxproperty,processtype," + fields + "processentry.workcenter workcenter,processentry.workcenter.name workcenterName,processentry.parent processseq,processentry.operationno operationno,processentry.machiningtype machiningtype,processentry.productionorg productionorg,processentry.actentryentity.processstage processstage,processentry.actentryentity.actresource.id resourceId,processentry.actentryentity.actresource.number resourceNum,processentry.actentryentity.actresource.name resourceName"), (QFilter[])new QFilter[]{routeFilter, machiningtypeFilter});
        return resuorceCollection;
    }

    private void getNoSetResourceRouter(DynamicObjectCollection resuorceCollection, List<Long> inResourceObjIds, List<String> notSetResourceRouters, List<String> notSetResourceRates, Set<String> calMatInfos, Map<String, Boolean> processSeqOutSourceMap, Map<Long, Long> proOrgCostTypeMap, Map<Long, Long> mnHsCostTypeMap) {
        Map<Long, Map<String, DynamicObject>> costTypeResourceIdAndObjMap = this.getResourceAndObjMap(inResourceObjIds);
        ArrayList<Long> matIds = new ArrayList<Long>(10);
        for (String calMatInfo : calMatInfos) {
            String[] split = calMatInfo.split("@");
            String matId = split[0];
            matIds.add(Long.parseLong(matId));
        }
        Set<Long> matGroupIds = this.getMatGroupIds(resuorceCollection, matIds);
        for (DynamicObject resuorce : resuorceCollection) {
            long materialGroup;
            String isOutSourcekey = resuorce.getString("id") + "@" + resuorce.getString("processseq") + "@" + resuorce.getString("operationno");
            Boolean isOutSource = processSeqOutSourceMap.get(isOutSourcekey);
            if (isOutSource != null && isOutSource.booleanValue()) continue;
            DynamicObject resourceObj = null;
            Long manuOrg = resuorce.getLong("manuorg");
            Long materialId = resuorce.getLong("material");
            Long auxptyId = resuorce.getLong("auxproperty");
            String key = materialId + "@" + auxptyId;
            if ("A".equals(resuorce.getString("processtype")) && !CadEmptyUtils.isEmpty(calMatInfos) && !calMatInfos.contains(key) || "B".equals(resuorce.getString("processtype")) && !matGroupIds.contains(materialGroup = resuorce.getLong("materialgroup"))) continue;
            Long resourceId = resuorce.getLong("resourceId");
            if (CadEmptyUtils.isEmpty(resourceId)) {
                String routerNumber = resuorce.getString("number");
                String routerName = resuorce.getString("name");
                String processSeq = resuorce.getString("processseq");
                String operationNo = resuorce.getString("operationno");
                String routerInfos = routerNumber + "@" + routerName + "@" + processSeq + "@" + operationNo + "@" + resuorce.getLong("id");
                if (notSetResourceRouters.contains(routerInfos)) continue;
                notSetResourceRouters.add(routerInfos);
                continue;
            }
            String machiningType = resuorce.getString("machiningtype");
            long workCenterId = resuorce.getLong("workcenter");
            Long prodOrg = resuorce.getLong("productionorg");
            Long costType = 0L;
            costType = "1003".equals(machiningType) ? proOrgCostTypeMap.get(prodOrg) : proOrgCostTypeMap.get(manuOrg);
            if (CadEmptyUtils.isEmpty(costType)) continue;
            Map<String, DynamicObject> resourceIdAndObjMap = costTypeResourceIdAndObjMap.get(costType);
            if (mnHsCostTypeMap.containsKey(costType)) {
                Map<String, DynamicObject> subResourceIdAndObjMap = costTypeResourceIdAndObjMap.get(mnHsCostTypeMap.get(costType));
                if (resourceIdAndObjMap == null) {
                    resourceIdAndObjMap = subResourceIdAndObjMap;
                } else if (subResourceIdAndObjMap != null) {
                    resourceIdAndObjMap.putAll(subResourceIdAndObjMap);
                }
            }
            if (!CadEmptyUtils.isEmpty(resourceIdAndObjMap) && (resourceObj = resourceIdAndObjMap.get("1@" + workCenterId + "@" + resourceId)) == null) {
                resourceObj = resourceIdAndObjMap.get("1@0@" + resourceId);
            }
            if (resourceObj != null) continue;
            String routerNumber = resuorce.getString("number");
            String routerName = resuorce.getString("name");
            String processSeq = resuorce.getString("processseq");
            String operationNo = resuorce.getString("operationno");
            String resourceNum = resuorce.getString("resourceNum");
            String resourceName = resuorce.getString("resourceName");
            String routerInfos = routerNumber + "@" + routerName + "@" + processSeq + "@" + operationNo + "@" + resuorce.getLong("id") + "@" + resourceNum + "@" + resourceName;
            if (notSetResourceRates.contains(routerInfos)) continue;
            notSetResourceRates.add(routerInfos);
        }
    }

    private Set<Long> getMatGroupIds(DynamicObjectCollection resuorceCollection, List<Long> matIds) {
        HashSet<Long> matGroupIds = new HashSet<Long>(10);
        HashSet<Long> manuOrgs = new HashSet<Long>(10);
        for (DynamicObject object : resuorceCollection) {
            long manuorg = object.getLong("manuorg");
            if (CadEmptyUtils.isEmpty(manuorg)) continue;
            manuOrgs.add(manuorg);
        }
        QFilter filter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList(manuOrgs), (String)"bd_materialmftinfo");
        QFilter matFilter = new QFilter("masterid", "in", matIds);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection materialMftInfos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id,masterid,materialattr,mftcontrolentry.materialcontrol materialcontrol", (QFilter[])new QFilter[]{filter, matFilter, status, enable});
        for (DynamicObject materialMftInfo : materialMftInfos) {
            long materialcontrol = materialMftInfo.getLong("materialcontrol");
            if (CadEmptyUtils.isEmpty(materialcontrol)) continue;
            matGroupIds.add(materialcontrol);
        }
        return matGroupIds;
    }

    public Map<Long, Map<String, DynamicObject>> getResourceAndObjMap(List<Long> inResourceObjIds) {
        HashMap<Long, Map<String, DynamicObject>> resourceAndObjMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        QFilter filter = new QFilter("id", "in", inResourceObjIds);
        DynamicObjectCollection resourceObjs = StdCalculateHelper.getInResourceObjs(filter.toArray());
        for (DynamicObject resourcePriceObj : resourceObjs) {
            Long workCenterId = resourcePriceObj.get("workcenter.id") == null ? 0L : resourcePriceObj.getLong("workcenter.id");
            Long resourceId = resourcePriceObj.getLong("resource.id");
            Long costtype = resourcePriceObj.getLong("costtype");
            String key = "1@" + workCenterId + "@" + resourceId;
            Map map = resourceAndObjMap.computeIfAbsent(costtype, p -> new HashMap());
            if (map.containsKey(key)) continue;
            map.put(key, resourcePriceObj);
        }
        return resourceAndObjMap;
    }
}

