/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.checker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StandCalcCheckHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class StdCalcRecordCaseChecker
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        if (context.getParams().get("standCostCalcParam") == null) {
            return;
        }
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)this.getContext().getParams().get("standCostCalcParam");
        if (!standCostCalcParam.isSaveRecord().booleanValue()) {
            return;
        }
        if (standCostCalcParam.isAutoReplaceRecord().booleanValue()) {
            return;
        }
        HashMap<String, Set<Long>> configBomKeycolPidsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, ConfigBomInfo> idConfigBomMap = new HashMap<Long, ConfigBomInfo>(16);
        for (ConfigBomInfo configBomInfo : standCostCalcParam.getConfigBomInfoList()) {
            Set pids = configBomKeycolPidsMap.computeIfAbsent(configBomInfo.getKeycol(), p -> new HashSet());
            if (configBomInfo.getPid() != 0L) {
                pids.add(configBomInfo.getPid());
            }
            if (configBomInfo.getPid() != 0L) continue;
            idConfigBomMap.put(configBomInfo.getId(), configBomInfo);
        }
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        if (!CadEmptyUtils.isEmpty(configBomKeycolPidsMap)) {
            filter.and(new QFilter("keycol", "in", configBomKeycolPidsMap.keySet()));
        }
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"StdCalcRecordCaseChecker.doCheck", (String)"cad_stdcalcrecord", (String)"name,material,material.number materialnumber,material.name materialname,auxpty,configuredcode.number configuredcode,tracknumber.number tracknumber,project.number project,lot,keycol", (QFilter[])new QFilter[]{filter}, null);
        DataSet dataSet = recordDataSet.groupBy(new String[]{"material", "materialnumber", "materialname", "auxpty", "configuredcode", "tracknumber", "project", "lot", "keycol"}).count("name").finish();
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        DataSet cpDataSet = dataSet.copy();
        while (cpDataSet.hasNext()) {
            Row row = cpDataSet.next();
            Long auxpty = row.getLong("auxpty");
            auxptyIds.add(auxpty);
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Integer recordCount = row.getInteger("name");
            if (recordCount < standCostCalcParam.getRecordCount()) continue;
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            String errorInfo = this.getErrorInfo(row, auxptyMap, typeNameMap, auxpValueMap);
            String error = String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5b58\u5728%2$s\u5957\u6863\u6848\uff0c\u8bf7\u5220\u9664\u540e\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"StdCalcRecordCaseChecker_2", (String)"macc-cad-algox", (Object[])new Object[0]), errorInfo, standCostCalcParam.getRecordCount());
            String keycol = row.getString("keycol");
            detailinfo.setCheckDetailResult(error);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            if (!standCostCalcParam.isCalcCurLevel() || !"2".equals(this.getSingleCheckContext().getCheckLevel())) continue;
            StringBuilder path = new StringBuilder();
            StringBuilder tempPath = new StringBuilder(keycol);
            StandCalcCheckHelper.getCalcTopLevelMat(keycol, configBomKeycolPidsMap, idConfigBomMap, (Set<String>)this.getContext().getFailProductKeycols(), path, tempPath);
        }
        if (CadEmptyUtils.isEmpty(this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String result = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"StdCalcRecordCaseChecker_1", (String)"macc-cad-algox", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(result);
        this.getSingleCheckContext().setPass(false);
    }

    private Set<String> getAllKeyCols(Long costType) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"keycol", (QFilter[])new QFilter[]{filter});
        HashSet<String> keycols = new HashSet<String>(200);
        for (DynamicObject bomSetting : bomSettings) {
            keycols.add(bomSetting.getString("keycol"));
        }
        return keycols;
    }

    private String getErrorInfo(Row record, Map<Long, String> auxptyMap, Map<String, String> typeNameMap, Map<Long, String> auxpValueMap) {
        Long material = record.getLong("material");
        String number = record.getString("materialnumber");
        String name = record.getString("materialname");
        Long auxproperty = record.getLong("auxpty");
        String projectnum = record.getString("project");
        String tracknumbernum = record.getString("tracknumber");
        String configuredcodenum = record.getString("configuredcode");
        String lot = record.getString("lot");
        String error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s", (String)"StdCalcRecordCaseChecker_3", (String)"macc-cad-algox", (Object[])new Object[0]), number, name);
        if (!CadEmptyUtils.isEmpty(auxproperty)) {
            String auxValueStr = auxptyMap.get(auxproperty);
            JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
            StringBuilder auxStr = new StringBuilder();
            if (value != null) {
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append(typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append(auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
            }
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%s", (String)"StdCalcRecordCaseChecker_4", (String)"macc-cad-algox", (Object[])new Object[0]), auxStr);
        }
        if (!CadEmptyUtils.isEmpty(configuredcodenum)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u914d\u7f6e\u53f7\uff1a%s", (String)"StdCalcRecordCaseChecker_5", (String)"macc-cad-algox", (Object[])new Object[0]), configuredcodenum);
        }
        if (!CadEmptyUtils.isEmpty(tracknumbernum)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u8ddf\u8e2a\u53f7\uff1a%s", (String)"StdCalcRecordCaseChecker_6", (String)"macc-cad-algox", (Object[])new Object[0]), tracknumbernum);
        }
        if (!CadEmptyUtils.isEmpty(projectnum)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u9879\u76ee\u53f7\uff1a%s", (String)"StdCalcRecordCaseChecker_7", (String)"macc-cad-algox", (Object[])new Object[0]), projectnum);
        }
        if (!CadEmptyUtils.isEmpty(lot)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u6279\u53f7\uff1a%s", (String)"StdCalcRecordCaseChecker_8", (String)"macc-cad-algox", (Object[])new Object[0]), lot);
        }
        error = error + "\u201d";
        return error;
    }
}

