/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class AnalysisBOMStructHelper {
    private static final Log logger = LogFactory.getLog(AnalysisBOMStructHelper.class);

    public static List<Object[]> analysisBOMResultExt(StandCostCalcParam standCostCalcParam, String configBomInfoJsStr) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        if (CadEmptyUtils.isEmpty(configBomInfoJsStr)) {
            return objectList;
        }
        String noUseMatToIdForBom = CadBgParamUtils.getCadBgParamForString((String)"nousemattoidforbom", (String)"1");
        HashSet<Long> configBillIds = new HashSet<Long>(200);
        ArrayList<Long> configBillEntryIds = new ArrayList<Long>(200);
        JSONObject configBomInfoJSONObject = (JSONObject)JSON.parse((String)configBomInfoJsStr);
        for (Map.Entry configBomInfoEntry : configBomInfoJSONObject.entrySet()) {
            JSONObject value = (JSONObject)configBomInfoEntry.getValue();
            JSONArray treeEntryEntity = value.getJSONArray("treeentryentity");
            if (treeEntryEntity == null) {
                logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u53f7{}\u5bf9\u5e94\u7684\u914d\u7f6e\u6e05\u5355\u7684\u5206\u5f55treeentryentity\u6ca1\u6709\u6570\u636e\u3002\u8ba1\u7b97\u7ed3\u675f", configBomInfoEntry.getKey());
                continue;
            }
            for (Object treeEntry : treeEntryEntity) {
                JSONObject entry = (JSONObject)treeEntry;
                configBillIds.add(entry.getLong("configlistid"));
                configBillEntryIds.add(entry.getLong("id"));
                HashMap<String, Long> values = new HashMap<String, Long>(5);
                values.put("material", entry.getLong("entrymaterial_id"));
                values.put("auxproperty", entry.getLong("entryauxproperty"));
                String calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true).getKeycol();
                if (!CadEmptyUtils.isEmpty(entry.getLong("routeId"))) {
                    Long pid = entry.getLong("pid");
                    if (pid != 0L) {
                        String materialAttr = entry.getString("entrymaterialattr");
                        if (!"10040".equals(materialAttr) && !"10020".equals(materialAttr)) {
                            standCostCalcParam.getConfigBomKeycolRouteMap().put(calcKey, entry.getLong("routeId"));
                        }
                    } else {
                        standCostCalcParam.getConfigBomKeycolRouteMap().put(calcKey, entry.getLong("routeId"));
                    }
                    logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u7269\u6599keycol\uff1a{}\uff0c\u5de5\u827a\u8def\u7ebfid\uff1a{}", (Object)calcKey, (Object)entry.getLong("routeId"));
                }
                Object[] object = new Object[AnalysisBOMStructHelper.getConfigBomRowMeta().getFieldCount()];
                if ("1".equals(noUseMatToIdForBom)) {
                    object[0] = entry.getLong("id");
                    object[1] = entry.getLong("pid");
                    object[2] = entry.getLong("pid");
                } else {
                    object[0] = entry.getLong("entrymaterial_id");
                    object[1] = entry.getLong("pid") == null ? Long.valueOf(0L) : entry.getLong("pmaterial");
                    object[2] = entry.getLong("pid") == null ? Long.valueOf(0L) : entry.getLong("pmaterial");
                }
                object[3] = 0L;
                object[4] = 1L;
                object[5] = entry.getLong("entrymaterial_id");
                object[6] = 0L;
                object[7] = entry.getLong("entryunit");
                object[8] = entry.getLong("entryversion");
                object[9] = entry.getLong("entryauxproperty");
                object[10] = entry.getString("entryqtytype");
                object[11] = entry.getBigDecimal("entryqtynumerator");
                object[12] = entry.getBigDecimal("entryqtydenominator");
                object[13] = entry.getBigDecimal("entryfixscrap");
                object[14] = entry.getBigDecimal("entryscraprate");
                object[15] = entry.getDate("entryvaliddate");
                object[16] = entry.getDate("entryinvaliddate");
                object[17] = entry.getBigDecimal("entryqty");
                object[18] = calcKey;
                object[19] = " ";
                objectList.add(object);
            }
        }
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u6e05\u5355id\uff1a" + SerializationUtils.toJsonString(configBillIds));
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u6e05\u5355\u5206\u5f55id\uff1a" + SerializationUtils.toJsonString(configBillEntryIds));
        return objectList;
    }

    public static List<Object[]> analysisBOMResult(StandCostCalcParam calcParam, String configBomInfoJsStr, Set<Long> materialIds, Set<Long> productOrgs, List<Long> configCodeIds) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        if (CadEmptyUtils.isEmpty(configBomInfoJsStr)) {
            return objectList;
        }
        HashSet<Long> configBillIds = new HashSet<Long>(200);
        ArrayList<Long> configBillEntryIds = new ArrayList<Long>(200);
        JSONObject configBomInfoJSONObject = (JSONObject)JSON.parse((String)configBomInfoJsStr);
        for (Map.Entry configBomInfoEntry : configBomInfoJSONObject.entrySet()) {
            JSONObject value = (JSONObject)configBomInfoEntry.getValue();
            JSONArray treeEntryEntity = value.getJSONArray("treeentryentity");
            if (treeEntryEntity == null) {
                logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u53f7{}\u5bf9\u5e94\u7684\u914d\u7f6e\u6e05\u5355\u7684\u5206\u5f55treeentryentity\u6ca1\u6709\u6570\u636e\u3002\u8ba1\u7b97\u7ed3\u675f", configBomInfoEntry.getKey());
                continue;
            }
            for (Object treeEntry : treeEntryEntity) {
                JSONObject entry = (JSONObject)treeEntry;
                configBillIds.add(entry.getLong("configlistid"));
                configBillEntryIds.add(entry.getLong("id"));
                materialIds.add(entry.getLong("entrymaterial_id"));
                productOrgs.add(entry.getLong("prodorgid"));
                HashMap<String, Long> values = new HashMap<String, Long>(5);
                values.put("material", entry.getLong("entrymaterial_id"));
                values.put("auxproperty", entry.getLong("entryauxproperty"));
                values.put("configuredcode", entry.getLong("configcode"));
                String calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true).getKeycol();
                if (!CadEmptyUtils.isEmpty(entry.getLong("routeId"))) {
                    Long pid = entry.getLong("pid");
                    if (pid != 0L) {
                        String materialAttr = entry.getString("entrymaterialattr");
                        if (!"10040".equals(materialAttr) && !"10020".equals(materialAttr)) {
                            calcParam.getConfigBomKeycolRouteMap().put(calcKey, entry.getLong("routeId"));
                        }
                    } else {
                        calcParam.getConfigBomKeycolRouteMap().put(calcKey, entry.getLong("routeId"));
                    }
                    logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u7269\u6599keycol\uff1a{}\uff0c\u5de5\u827a\u8def\u7ebfid\uff1a{}", (Object)calcKey, (Object)entry.getLong("routeId"));
                }
                if (!CadEmptyUtils.isEmpty(entry.getLong("configcode"))) {
                    configCodeIds.add(entry.getLong("configcode"));
                }
                Object[] object = new Object[AnalysisBOMStructHelper.getConfigBomRowMeta().getFieldCount()];
                object[0] = entry.getLong("id");
                object[1] = entry.getLong("pid");
                object[2] = entry.getLong("pid");
                object[3] = 0L;
                object[4] = 1L;
                object[5] = entry.getLong("entrymaterial_id");
                object[6] = entry.getLong("configcode");
                object[7] = entry.getLong("entryunit");
                object[8] = entry.getLong("entryversion");
                object[9] = entry.getLong("entryauxproperty");
                object[10] = entry.getString("entryqtytype");
                object[11] = entry.getBigDecimal("entryqtynumerator");
                object[12] = entry.getBigDecimal("entryqtydenominator");
                object[13] = entry.getBigDecimal("entryfixscrap");
                object[14] = entry.getBigDecimal("entryscraprate");
                object[15] = entry.getDate("entryvaliddate");
                object[16] = entry.getDate("entryinvaliddate");
                object[17] = entry.getBigDecimal("entryqty");
                object[18] = calcKey;
                object[19] = " ";
                objectList.add(object);
            }
        }
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u6e05\u5355id\uff1a" + SerializationUtils.toJsonString(configBillIds));
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u6e05\u5355\u5206\u5f55id\uff1a" + SerializationUtils.toJsonString(configBillEntryIds));
        logger.info("\u89e3\u6790\u5916\u90e8\u4f20\u5165\u7684BOM\u7ed3\u6784\uff0c\u914d\u7f6e\u6e05\u5355\u5206\u5f55\u7269\u6599\u4e2a\u6570\uff1a" + materialIds.size());
        return objectList;
    }

    public static DataSet creatConfigBomDataSet(List<Object[]> objectList) {
        return Algo.create((String)"macc-cad-algox").createDataSet(objectList.iterator(), AnalysisBOMStructHelper.getConfigBomRowMeta());
    }

    private static RowMeta getConfigBomRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("pid", (DataType)DataType.LongType));
        field.add(new Field("bomId", (DataType)DataType.LongType));
        field.add(new Field("bomSettingId", (DataType)DataType.LongType));
        field.add(new Field("yieldrate", (DataType)DataType.LongType));
        field.add(new Field("MaterialId", (DataType)DataType.LongType));
        field.add(new Field("configuredcode", (DataType)DataType.LongType));
        field.add(new Field("unitId", (DataType)DataType.LongType));
        field.add(new Field("MaterialVer", (DataType)DataType.LongType));
        field.add(new Field("AuxPropId", (DataType)DataType.LongType));
        field.add(new Field("entryqtytype", (DataType)DataType.StringType));
        field.add(new Field("entryqtynumerator", (DataType)DataType.BigDecimalType));
        field.add(new Field("entryqtydenominator", (DataType)DataType.BigDecimalType));
        field.add(new Field("entryfixscrap", (DataType)DataType.BigDecimalType));
        field.add(new Field("entryscraprate", (DataType)DataType.BigDecimalType));
        field.add(new Field("entryvaliddate", (DataType)DataType.DateType));
        field.add(new Field("entryinvaliddate", (DataType)DataType.DateType));
        field.add(new Field("entryqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("keycol", (DataType)DataType.StringType));
        field.add(new Field("ownertype", (DataType)DataType.StringType));
        return new RowMeta(field.toArray(new Field[0]));
    }
}

