/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.CostProcessRouteDyo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.DateUtils;

public class BomRuleSettingStdCalcHelper {
    private static final Log logger = LogFactory.getLog(BomRuleSettingStdCalcHelper.class);

    public static Map<String, Long> getMatBomIdMap(String entity, DynamicObject bomRuleSettingObj, Set<Long> productOrgs, Map<String, Long> notQueryBomIdMap) {
        HashMap<String, Long> matBomIdMap = new HashMap<String, Long>(16);
        if (bomRuleSettingObj == null) {
            return matBomIdMap;
        }
        String filterStr = bomRuleSettingObj.getString("filter_tag");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            filterList.add(filterBuilder.getQFilter());
        }
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), (String)entity);
        filterList.add(orgFilter);
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty(notQueryBomIdMap)) {
            filterList.add(new QFilter("id", "not in", notQueryBomIdMap.values()));
            matBomIdMap.putAll(notQueryBomIdMap);
        }
        DynamicObjectCollection entryEntitys = bomRuleSettingObj.getDynamicObjectCollection("entryentity");
        StringBuilder orderStr = new StringBuilder();
        orderStr.append("ctrlstrategy desc");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntitys.get(0);
            String srcfield = dynamicObject.getString("srcfield");
            String sequence = dynamicObject.getString("sequence");
            if (CadEmptyUtils.isEmpty(srcfield)) continue;
            if (CadEmptyUtils.isEmpty(orderStr.toString())) {
                orderStr.append(srcfield);
                orderStr.append(" ");
                orderStr.append(sequence);
                continue;
            }
            orderStr.append(",");
            orderStr.append(srcfield);
            orderStr.append(" ");
            orderStr.append(sequence);
        }
        String matFields = "material.masterid material";
        if ("pdm_mftbom".equals(entity)) {
            matFields = "material.masterid.masterid material";
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"getMatBomIdMap", (String)entity, (String)("id,auxproperty,configuredcode," + matFields), (QFilter[])filterList.toArray(new QFilter[0]), (String)orderStr.toString());
        DataSet copy = bomDataSet.copy();
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (copy.hasNext()) {
            Row row = copy.next();
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty(material)) continue;
            matIds.add(material);
        }
        Set<Long> purMatIdsByProduceInfo = BomRuleSettingStdCalcHelper.getPurMatIdsByProduceInfo(productOrgs, matIds);
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            if (row == null || row.get("material") == null) continue;
            long material = row.getLong("material");
            if (purMatIdsByProduceInfo.contains(material)) {
                logger.info("\u7269\u6599id\uff1a{},\u5bf9\u5e94BOM\u4e3a\u5916\u8d2d\u7269\u6599\u7684BOM\uff0c\u6392\u9664\u3002", (Object)material);
                continue;
            }
            long auxproperty = row.getLong("auxproperty");
            long configuredcode = row.getLong("configuredcode");
            String key = material + "@" + auxproperty + "@" + configuredcode;
            if (matBomIdMap.containsKey(key)) continue;
            matBomIdMap.put(key, row.getLong("id"));
        }
        purMatIdsByProduceInfo.clear();
        return matBomIdMap;
    }

    public static Map<String, Long> getMatProduceVerBomIdMap(DynamicObject bomRuleSettingObj, Set<Long> productOrgs, Date calcDate, Map<String, Long> notQueryBomIdMap) {
        HashMap<String, Long> matBomIdMap = new HashMap<String, Long>(16);
        if (bomRuleSettingObj == null) {
            return matBomIdMap;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), (String)"pdm_manuversion");
        filterList.add(orgFilter);
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        String dateStr = DateUtils.formatDate((Date)calcDate, null);
        Date date = DateUtils.parseShortDate((String)dateStr);
        QFilter timeFilter = new QFilter("begindate", "<=", (Object)date);
        timeFilter.and(new QFilter("enddate", ">", (Object)date));
        filterList.add(timeFilter);
        if (!CadEmptyUtils.isEmpty(notQueryBomIdMap)) {
            filterList.add(new QFilter("bom", "not in", notQueryBomIdMap.values()));
            matBomIdMap.putAll(notQueryBomIdMap);
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"getMatProduceVersionBomIdMap", (String)"pdm_manuversion", (String)"createorg,material.masterid material", (QFilter[])filterList.toArray(new QFilter[0]), (String)"audittime desc");
        bomDataSet = bomDataSet.distinct();
        ArrayList<Object> params = new ArrayList<Object>(16);
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            Long createOrg = row.getLong("createorg");
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty(createOrg) || CadEmptyUtils.isEmpty(material)) continue;
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(16);
            map.put("bizorg", createOrg);
            map.put("material", material);
            map.put("bomdate", calcDate);
            map.put("qty", new BigDecimal(1));
            params.add(map);
            matIds.add(material);
        }
        Map resMap = null;
        try {
            logger.info("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3-\u5f00\u59cb");
            resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        if (CadEmptyUtils.isEmpty(resMap)) {
            logger.info("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3\uff0c\u672a\u83b7\u53d6\u5230\u751f\u4ea7\u7248\u672c");
            return matBomIdMap;
        }
        HashMap<String, Long> proMatRouteIdMap = new HashMap<String, Long>(16);
        Set<Long> purMatIdsByProduceInfo = BomRuleSettingStdCalcHelper.getPurMatIdsByProduceInfo(productOrgs, matIds);
        for (Map.Entry entry : resMap.entrySet()) {
            Map value = (Map)entry.getValue();
            if (CadEmptyUtils.isEmpty(value)) continue;
            for (Map.Entry entry2 : value.entrySet()) {
                DynamicObject dynamicObject;
                Long material = Long.parseLong(entry2.getKey().toString());
                Set produceVers = (Set)entry2.getValue();
                if (CadEmptyUtils.isEmpty(produceVers)) continue;
                ArrayList<DynamicObject> produceVerList = new ArrayList<DynamicObject>(produceVers);
                produceVerList.sort(Comparator.comparing(o -> o.getLong("audittime")));
                if (purMatIdsByProduceInfo.contains(material)) {
                    logger.info("\u7269\u6599id\uff1a{},\u5bf9\u5e94BOM\u4e3a\u5916\u8d2d\u7269\u6599\u7684BOM\uff0c\u6392\u9664\u3002", (Object)material);
                    continue;
                }
                String key = material + "@0@0";
                if (proMatRouteIdMap.containsKey(key) || (dynamicObject = (DynamicObject)produceVerList.get(0)) == null) continue;
                proMatRouteIdMap.put(key, dynamicObject.getLong("bom"));
            }
        }
        purMatIdsByProduceInfo.clear();
        bomDataSet = QueryServiceHelper.queryDataSet((String)"getMatProduceVersionBomIdMap", (String)"pdm_mftbom", (String)"id,auxproperty,configuredcode,material.masterid.masterid material", (QFilter[])new QFilter[]{new QFilter("id", "in", proMatRouteIdMap.values())}, null);
        proMatRouteIdMap.clear();
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            if (row == null || row.get("material") == null) continue;
            long l = row.getLong("material");
            long auxproperty = row.getLong("auxproperty");
            long configuredcode = row.getLong("configuredcode");
            String key = l + "@" + auxproperty + "@" + configuredcode;
            if (matBomIdMap.containsKey(key)) continue;
            matBomIdMap.put(key, row.getLong("id"));
        }
        return matBomIdMap;
    }

    public static Map<String, Long> getMatBomIdMap(String entity, Map<String, Long> matBomIdMap, StandCostCalcParam standCostCalcParam) {
        HashMap<String, Long> calMatBomIdMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty(matBomIdMap)) {
            return calMatBomIdMap;
        }
        String matFields = "material.masterid material";
        if ("pdm_mftbom".equals(entity)) {
            matFields = "material.masterid.masterid material";
        }
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"getMatBomIdMap", (String)entity, (String)("id,auxproperty,configuredcode," + matFields), (QFilter[])new QFilter[]{new QFilter("id", "in", matBomIdMap.values())}, null);
        DataSet keyColDataSetBySpecifyMat = BomRuleSettingStdCalcHelper.getKeyColDataSetBySpecifyMat(entity, matBomIdMap, standCostCalcParam);
        resultDataSet = resultDataSet.join(keyColDataSetBySpecifyMat, JoinType.INNER).on("material", "material").on("auxproperty", "auxproperty").on("configuredcode", "configuredcode").select(resultDataSet.getRowMeta().getFieldNames()).finish();
        HashSet<Long> bomIds = new HashSet<Long>(200);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            long material = row.getLong("material");
            long auxproperty = row.getLong("auxproperty");
            long configuredcode = row.getLong("configuredcode");
            String key = material + "@" + auxproperty + "@" + configuredcode;
            if (calMatBomIdMap.containsKey(key)) continue;
            calMatBomIdMap.put(key, row.getLong("id"));
            bomIds.add(row.getLong("id"));
        }
        standCostCalcParam.setBomIdSet(bomIds);
        matBomIdMap.clear();
        return calMatBomIdMap;
    }

    public static DataSet getKeyColDataSetBySpecifyMat(String srcEntity, Map<String, Long> matBomIdMap, StandCostCalcParam standCostCalcParam) {
        if (standCostCalcParam.getScopetype() == 0) {
            return BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(new HashSet<String>());
        }
        HashSet<Long> bomIds = new HashSet<Long>(200);
        bomIds.addAll(matBomIdMap.values());
        if (standCostCalcParam.isCalcCurLevel()) {
            HashSet<String> calcKeycols = new HashSet<String>(100);
            calcKeycols.addAll(standCostCalcParam.getKeycols());
            calcKeycols.removeAll(standCostCalcParam.getCalcPurMaterials());
            if (standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
                calcKeycols.removeAll(standCostCalcParam.getDefaultConfigKeycols());
            }
            BomRuleSettingStdCalcHelper.getCalcKeyColsNew(srcEntity, new HashSet<String>(calcKeycols), calcKeycols, bomIds, 0);
            return BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(new HashSet<String>(calcKeycols));
        }
        HashSet<String> upLevelMatIds = new HashSet<String>(standCostCalcParam.getKeycols());
        BomRuleSettingStdCalcHelper.getMostHightLevelMaterialBySpeciMatNew(srcEntity, new HashSet<String>(upLevelMatIds), upLevelMatIds, bomIds, 0);
        HashSet<String> calcKeycols = new HashSet<String>(100);
        calcKeycols.addAll(upLevelMatIds);
        BomRuleSettingStdCalcHelper.getCalcKeyColsNew(srcEntity, upLevelMatIds, calcKeycols, bomIds, 0);
        standCostCalcParam.getKeycols().addAll(calcKeycols);
        return BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(new HashSet<String>(calcKeycols));
    }

    public static void getMostHightLevelMaterialBySpeciMatNew(String srcEntity, Set<String> specifyMaterialKeycols, Set<String> upLevelMatKeycols, Set<Long> bomIds, int count) {
        if (CadEmptyUtils.isEmpty(specifyMaterialKeycols)) {
            return;
        }
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(specifyMaterialKeycols);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : bomMatDataSetByKeyCol.copy()) {
            materialIds.add(row.getLong("material"));
        }
        QFilter filter = new QFilter("id", "in", bomIds);
        String matFields = "material,entry.entrymaterial entrymaterial";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "material.masterid material,entry.entrymaterial.masterid entrymaterial";
            filter.and(new QFilter("entry.entrymaterial.masterid", "in", (Object)materialIds));
        } else {
            filter.and(new QFilter("entry.entrymaterial", "in", (Object)materialIds));
        }
        DataSet bomsDataSet = QueryServiceHelper.queryDataSet((String)"getMostHightLevelMaterialBySpeciMatNew", (String)srcEntity, (String)("id,auxproperty,configuredcode,entry.entryauxproperty entryauxproperty,entry.entryconfiguredcode entryconfiguredcode," + matFields), (QFilter[])new QFilter[]{filter}, null);
        bomsDataSet = bomsDataSet.join(bomMatDataSetByKeyCol, JoinType.INNER).on("entrymaterial", "material").on("entryauxproperty", "auxproperty").on("entryconfiguredcode", "configuredcode").select(bomsDataSet.getRowMeta().getFieldNames()).finish();
        specifyMaterialKeycols.clear();
        while (bomsDataSet.hasNext()) {
            Row row = bomsDataSet.next();
            HashMap<String, Long> keycolMap = new HashMap<String, Long>(16);
            keycolMap.put("material", row.getLong("material"));
            keycolMap.put("auxproperty", row.getLong("auxproperty"));
            keycolMap.put("configuredcode", row.getLong("configuredcode"));
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            HashMap<String, Long> coKeycolMap = new HashMap<String, Long>(16);
            coKeycolMap.put("material", row.getLong("entrymaterial"));
            coKeycolMap.put("auxproperty", row.getLong("entryauxproperty"));
            coKeycolMap.put("configuredcode", row.getLong("entryconfiguredcode"));
            String entryKeycol = CalcKeyHelper.getCalcKey(coKeycolMap, new ArrayList(), (boolean)true).getKeycol();
            upLevelMatKeycols.remove(entryKeycol);
            specifyMaterialKeycols.add(keycol);
        }
        upLevelMatKeycols.addAll(specifyMaterialKeycols);
        if (count > 20) {
            return;
        }
        BomRuleSettingStdCalcHelper.getMostHightLevelMaterialBySpeciMatNew(srcEntity, specifyMaterialKeycols, upLevelMatKeycols, bomIds, ++count);
    }

    public static void getCalcKeyColsNew(String srcEntity, Set<String> specifyKeycols, Set<String> calcKeycols, Set<Long> bomIds, int count) {
        if (CadEmptyUtils.isEmpty(specifyKeycols)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", bomIds);
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(specifyKeycols);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : bomMatDataSetByKeyCol.copy()) {
            materialIds.add(row.getLong("material"));
        }
        String matFields = "material,entry.entrymaterial entrymaterial";
        if ("pdm_mftbom".equals(srcEntity)) {
            matFields = "material.masterid material,entry.entrymaterial.masterid entrymaterial";
            filter.and(new QFilter("material.masterid", "in", (Object)materialIds));
        } else {
            filter.and(new QFilter("material", "in", (Object)materialIds));
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"getCalcKeyColsNew", (String)srcEntity, (String)("auxproperty,configuredcode,entry.entryauxproperty entryauxproperty,entry.entryconfiguredcode entryconfiguredcode," + matFields), (QFilter[])new QFilter[]{filter}, null);
        bomDataSet = bomDataSet.join(bomMatDataSetByKeyCol, JoinType.INNER).on("material", "material").on("auxproperty", "auxproperty").on("configuredcode", "configuredcode").select(bomDataSet.getRowMeta().getFieldNames()).finish();
        specifyKeycols.clear();
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            HashMap<String, Long> coKeycolMap = new HashMap<String, Long>(16);
            coKeycolMap.put("material", row.getLong("entrymaterial"));
            coKeycolMap.put("auxproperty", row.getLong("entryauxproperty"));
            coKeycolMap.put("configuredcode", row.getLong("entryconfiguredcode"));
            String entryKeycol = CalcKeyHelper.getCalcKey(coKeycolMap, new ArrayList(), (boolean)true).getKeycol();
            specifyKeycols.add(entryKeycol);
            calcKeycols.add(entryKeycol);
        }
        if (count > 20) {
            return;
        }
        BomRuleSettingStdCalcHelper.getCalcKeyColsNew(srcEntity, specifyKeycols, calcKeycols, bomIds, ++count);
    }

    public static DataSet getBomMatDataSetByKeyCol(Set<String> specifyMaterialKeycols) {
        QFilter kcFilter = new QFilter("keycol", "in", specifyMaterialKeycols);
        DataSet keyColsDataSet = QueryServiceHelper.queryDataSet((String)"getBomMatFilterByKeyCol", (String)"cad_keycol", (String)"id,keycol,material,material.number matnumber,material.name matname,matvers,auxproperty,project,project.number projectnum,tracknumber,tracknumber.number tracknumbernum,configuredcode,configuredcode.number configuredcodenum,lot", (QFilter[])new QFilter[]{kcFilter}, null);
        return keyColsDataSet;
    }

    public static Map<String, String> getActualKeycolMap(Map<Long, List<DynamicObject>> materialKeyColObjMap, Map<Long, DynamicObject> dimensionByMatIdMap) {
        HashMap<String, String> materialPriceKeycolMap = new HashMap<String, String>(16);
        for (Map.Entry<Long, List<DynamicObject>> materialKeyColObj : materialKeyColObjMap.entrySet()) {
            Long material = materialKeyColObj.getKey();
            HashMap<String, Object> keyColMap = new HashMap<String, Object>(10);
            keyColMap.put("material", material);
            List<DynamicObject> keycolList = materialKeyColObj.getValue();
            if (dimensionByMatIdMap.containsKey(material)) {
                DynamicObject dimObj = dimensionByMatIdMap.get(material);
                ArrayList<String> extColList = new ArrayList<String>(10);
                Set<String> dimensionsFields = BomRuleSettingStdCalcHelper.getDimensions(dimObj.getString("dimension"));
                boolean flag = true;
                for (DynamicObject keycolObj : keycolList) {
                    String string;
                    for (String string2 : dimensionsFields) {
                        Object value = keycolObj.get(string2);
                        if (CadEmptyUtils.isEmpty(value.toString())) {
                            logger.info("\u5f53\u524d\u7269\u6599==>{},\u5bf9\u5e94\u7684\u5377\u7b97\u7ef4\u5ea6\u503c\u4e3a\u7a7a==>{}", (Object)material, (Object)string2);
                            flag = false;
                            break;
                        }
                        if ("assist".equals(string2)) {
                            keyColMap.put("auxproperty", value);
                            continue;
                        }
                        keyColMap.put(string2, value);
                    }
                    DynamicObjectCollection entryEntity = dimObj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject obj : entryEntity) {
                        String field3 = obj.getString("field");
                        extColList.add(field3);
                        keyColMap.put(field3, keycolObj.get(field3));
                    }
                    if (!flag || materialPriceKeycolMap.containsKey(string = keycolObj.getString("keycol"))) continue;
                    String keyCol = CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)true).getKeycol();
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u5f53\u524d\u7269\u6599==>{},\u83b7\u53d6\u5230keyCol\u4e3a ==>{}", (Object)material, (Object)keyCol);
                    }
                    materialPriceKeycolMap.put(string, keyCol);
                }
                continue;
            }
            if (keycolList.size() <= 0) continue;
            String keyCol = CalcKeyHelper.getCalcKey(keyColMap, new ArrayList(), (boolean)true).getKeycol();
            for (DynamicObject dynamicObject : keycolList) {
                String matKeycol = dynamicObject.getString("keycol");
                if (materialPriceKeycolMap.containsKey(matKeycol)) continue;
                materialPriceKeycolMap.put(matKeycol, keyCol);
            }
        }
        return materialPriceKeycolMap;
    }

    private static Set<String> getDimensions(String dimension) {
        dimension = dimension.substring(1, dimension.length() - 1);
        String[] split = dimension.split(",");
        HashSet<String> set = new HashSet<String>(split.length + 3);
        for (String item : split) {
            set.add(item);
        }
        return set;
    }

    public static Set<Long> getProcessRouteNew(DynamicObject routeRuleSettingObj, String srcEntity, Set<Long> bomIds, Set<String> matKeyCols, Long costTypeId, Date calcDate, String appNum) {
        HashSet<Long> routeIds = new HashSet<Long>(200);
        if (routeRuleSettingObj == null || CadEmptyUtils.isEmpty(matKeyCols)) {
            return routeIds;
        }
        HashSet<Long> productOrgs = new HashSet<Long>(10);
        if ("aca".equals(appNum)) {
            DynamicObject costType = CostTypeHelper.getCostType((Long)costTypeId, (String)"createorg");
            productOrgs.addAll(ImportServiceHelper.getUserHasPermOrgs((Long)(costType == null ? 0L : costType.getLong("createorg.id")), (String)"04"));
        } else {
            productOrgs.addAll(StdCalculateHelper.getProductOrgsByImitateCostType(costTypeId, calcDate));
        }
        logger.info("\u5de5\u827a\u8def\u7ebf\u89c4\u5219-\u83b7\u53d6\u5de5\u827a\u8def\u7ebf\uff0c\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", productOrgs);
        String routePrio = routeRuleSettingObj.getString("routeprioritisation");
        Map<String, Long> matRouteIdMap = null;
        if ("1".equals(routePrio)) {
            Map<String, Long> matProduceVerRouteIdMap = BomRuleSettingStdCalcHelper.getMatProduceVerRouteIdMap(bomIds, productOrgs, matKeyCols, calcDate, null);
            matRouteIdMap = BomRuleSettingStdCalcHelper.getMatRouteIdMap(srcEntity, routeRuleSettingObj, productOrgs, matKeyCols, matProduceVerRouteIdMap);
        } else if ("2".equals(routePrio)) {
            Map<String, Long> proMatRouteIdMap = BomRuleSettingStdCalcHelper.getMatRouteIdMap(srcEntity, routeRuleSettingObj, productOrgs, matKeyCols, null);
            matRouteIdMap = BomRuleSettingStdCalcHelper.getMatProduceVerRouteIdMap(bomIds, productOrgs, matKeyCols, calcDate, proMatRouteIdMap);
        } else {
            matRouteIdMap = "3".equals(routePrio) ? BomRuleSettingStdCalcHelper.getMatProduceVerRouteIdMap(bomIds, productOrgs, matKeyCols, calcDate, null) : BomRuleSettingStdCalcHelper.getMatRouteIdMap(srcEntity, routeRuleSettingObj, productOrgs, matKeyCols, null);
        }
        if (!CadEmptyUtils.isEmpty(matRouteIdMap)) {
            routeIds.addAll(matRouteIdMap.values());
        }
        return routeIds;
    }

    public static Map<String, Long> getMatRouteIdMap(String entity, DynamicObject routeRuleSettingObj, Set<Long> productOrgs, Set<String> specifyMaterialKcs, Map<String, Long> notQueryRouteIdMap) {
        HashMap<String, Long> matRouteIdMap = new HashMap<String, Long>(16);
        if (routeRuleSettingObj == null) {
            return matRouteIdMap;
        }
        String filterStr = routeRuleSettingObj.getString("filter_tag");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            filterList.add(filterBuilder.getQFilter());
        }
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), (String)entity);
        filterList.add(orgFilter);
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty(notQueryRouteIdMap)) {
            filterList.add(new QFilter("id", "not in", notQueryRouteIdMap.values()));
            matRouteIdMap.putAll(notQueryRouteIdMap);
        }
        StringBuilder orderStr = new StringBuilder();
        orderStr.append("ctrlstrategy desc");
        if (CadEmptyUtils.isEmpty(orderStr.toString())) {
            orderStr.append("ismainprocess desc");
        } else {
            orderStr.append(",").append("ismainprocess desc");
        }
        DynamicObjectCollection entryEntitys = routeRuleSettingObj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntitys.get(0);
            String srcfield = dynamicObject.getString("srcfield");
            String sequence = dynamicObject.getString("sequence");
            if (CadEmptyUtils.isEmpty(srcfield)) continue;
            if (CadEmptyUtils.isEmpty(orderStr.toString())) {
                orderStr.append(srcfield);
                orderStr.append(" ");
                orderStr.append(sequence);
                continue;
            }
            orderStr.append(",");
            orderStr.append(srcfield);
            orderStr.append(" ");
            orderStr.append(sequence);
        }
        DataSet routeDataSet = QueryServiceHelper.queryDataSet((String)"getMatRouteIdMap", (String)entity, (String)"id,processtype,materialgroup,material,auxproperty", (QFilter[])filterList.toArray(new QFilter[0]), (String)orderStr.toString());
        if (routeDataSet.isEmpty()) {
            return matRouteIdMap;
        }
        if (!CadEmptyUtils.isEmpty(specifyMaterialKcs)) {
            DataSet keyColDataSetBySpecifyMat = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(specifyMaterialKcs);
            keyColDataSetBySpecifyMat = keyColDataSetBySpecifyMat.filter("configuredcode!=0 or tracknumber!=0 or project!=0 or lot!=' '");
            routeDataSet = routeDataSet.join(keyColDataSetBySpecifyMat, JoinType.LEFT).on("material", "material").on("auxproperty", "auxproperty").select(routeDataSet.getRowMeta().getFieldNames(), new String[]{"id as keycolid"}).finish();
            DataSet matDataSet = routeDataSet.filter("processtype='A' and keycolid is not null").select(routeDataSet.getRowMeta().getFieldNames());
            DataSet matGroupDataSet = routeDataSet.filter("processtype='B'").select(routeDataSet.getRowMeta().getFieldNames());
            DataSet commonDataSet = routeDataSet.filter("processtype='C'").select(routeDataSet.getRowMeta().getFieldNames());
            routeDataSet = matDataSet.union(matGroupDataSet).union(commonDataSet);
        }
        while (routeDataSet.hasNext()) {
            Row row = routeDataSet.next();
            if (row == null) continue;
            String processtype = row.getString("processtype");
            long materialgroup = row.getLong("materialgroup");
            long material = row.getLong("material");
            long auxproperty = row.getLong("auxproperty");
            String key = processtype + "@" + material + "@" + auxproperty + "@" + materialgroup;
            if (matRouteIdMap.containsKey(key)) continue;
            matRouteIdMap.put(key, row.getLong("id"));
        }
        return matRouteIdMap;
    }

    public static Map<String, Long> getMatProduceVerRouteIdMap(Set<Long> bomIds, Set<Long> productOrgs, Set<String> specifyMaterialKcs, Date calcDate, Map<String, Long> notQueryRouteIdMap) {
        String key;
        HashMap<String, Long> matRouteIdMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty(bomIds)) {
            return matRouteIdMap;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), (String)"pdm_manuversion");
        filterList.add(orgFilter);
        QFilter filter = new QFilter("bom", "in", bomIds);
        filterList.add(filter);
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        String dateStr = DateUtils.formatDate((Date)calcDate, null);
        Date date = calcDate;
        if (!CadEmptyUtils.isEmpty(dateStr)) {
            date = DateUtils.parseShortDate((String)dateStr);
        }
        QFilter timeFilter = new QFilter("begindate", "<=", (Object)date);
        timeFilter.and(new QFilter("enddate", ">", (Object)date));
        filterList.add(timeFilter);
        if (notQueryRouteIdMap != null && !CadEmptyUtils.isEmpty(notQueryRouteIdMap)) {
            filterList.add(new QFilter("processroute", "not in", notQueryRouteIdMap.values()));
            matRouteIdMap.putAll(notQueryRouteIdMap);
        }
        HashSet<Long> materialIds = new HashSet<Long>(10);
        if (!CadEmptyUtils.isEmpty(specifyMaterialKcs)) {
            DataSet keyColDataSetBySpecifyMat = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(specifyMaterialKcs);
            while (keyColDataSetBySpecifyMat.hasNext()) {
                Row row = keyColDataSetBySpecifyMat.next();
                if (row == null) continue;
                materialIds.add(row.getLong("material"));
            }
        }
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            filterList.add(new QFilter("material.masterid", "in", materialIds));
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"getMatProduceVerRouteIdMap", (String)"pdm_manuversion", (String)"createorg,material.masterid material", (QFilter[])filterList.toArray(new QFilter[0]), (String)"audittime desc");
        bomDataSet = bomDataSet.distinct();
        ArrayList params = new ArrayList(16);
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            Long createOrg = row.getLong("createorg");
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty(createOrg) || CadEmptyUtils.isEmpty(material)) continue;
            HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>(16);
            hashMap.put("bizorg", createOrg);
            hashMap.put("material", material);
            hashMap.put("bomdate", calcDate);
            hashMap.put("qty", new BigDecimal(1));
            params.add(hashMap);
        }
        Map resMap = null;
        try {
            logger.info("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3-\u5f00\u59cb");
            resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        if (CadEmptyUtils.isEmpty(resMap)) {
            logger.info("\u8c03\u7528\u5236\u9020\u751f\u4ea7\u7248\u672c\u53d6\u503c\u63a5\u53e3\uff0c\u672a\u83b7\u53d6\u5230\u751f\u4ea7\u7248\u672c");
            return matRouteIdMap;
        }
        HashMap<String, Long> proMatRouteIdMap = new HashMap<String, Long>(16);
        for (Map.Entry entry : resMap.entrySet()) {
            Map value = (Map)entry.getValue();
            if (CadEmptyUtils.isEmpty(value)) continue;
            for (Map.Entry entry2 : value.entrySet()) {
                DynamicObject dynamicObject;
                Long material = Long.parseLong(entry2.getKey().toString());
                Set produceVers = (Set)entry2.getValue();
                if (CadEmptyUtils.isEmpty(produceVers)) continue;
                ArrayList<DynamicObject> produceVerList = new ArrayList<DynamicObject>(produceVers);
                produceVerList.sort(Comparator.comparing(o -> o.getLong("audittime")));
                key = material + "@0@0";
                if (proMatRouteIdMap.containsKey(key) || (dynamicObject = (DynamicObject)produceVerList.get(0)) == null) continue;
                proMatRouteIdMap.put(key, dynamicObject.getLong("processroute"));
            }
        }
        filter = new QFilter("id", "in", proMatRouteIdMap.values());
        filter.and(new QFilter("processtype", "=", (Object)"A"));
        bomDataSet = QueryServiceHelper.queryDataSet((String)"getMatProduceVerRouteIdMap", (String)"pdm_route", (String)"id,processtype,materialgroup,material,auxproperty", (QFilter[])new QFilter[]{filter}, null);
        proMatRouteIdMap.clear();
        while (bomDataSet.hasNext()) {
            Row row = bomDataSet.next();
            if (row == null) continue;
            String string = row.getString("processtype");
            long materialgroup = row.getLong("materialgroup");
            long material = row.getLong("material");
            long auxproperty = row.getLong("auxproperty");
            key = string + "@" + material + "@" + auxproperty + "@" + materialgroup;
            if (matRouteIdMap.containsKey(key)) continue;
            matRouteIdMap.put(key, row.getLong("id"));
        }
        return matRouteIdMap;
    }

    private static Map<String, Long> getCommonRoute(String entity, DynamicObject routeRuleSettingObj, Set<Long> productOrgs) {
        HashMap<String, Long> matRouteIdMap = new HashMap<String, Long>(16);
        if (routeRuleSettingObj == null) {
            return matRouteIdMap;
        }
        String filterStr = routeRuleSettingObj.getString("filter_tag");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            filterList.addAll(filterBuilder.getQFilters());
        }
        String orgField = "cad_router".equals(entity) ? "manuorg" : "createorg";
        filterList.add(new QFilter(orgField, "in", productOrgs));
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        StringBuilder orderStr = new StringBuilder();
        filterList.add(new QFilter("processtype", "in", (Object)new String[]{"B", "C"}));
        DynamicObjectCollection entryEntitys = routeRuleSettingObj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntitys.get(0);
            String srcfield = dynamicObject.getString("srcfield");
            String sequence = dynamicObject.getString("sequence");
            if (CadEmptyUtils.isEmpty(srcfield)) continue;
            if (CadEmptyUtils.isEmpty(orderStr.toString())) {
                orderStr.append(srcfield);
                orderStr.append(" ");
                orderStr.append(sequence);
                continue;
            }
            orderStr.append(",");
            orderStr.append(srcfield);
            orderStr.append(" ");
            orderStr.append(sequence);
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)entity, (String)"id,processtype,materialgroup,material,auxproperty", (QFilter[])filterList.toArray(new QFilter[0]), (String)orderStr.toString());
        for (DynamicObject res : results) {
            String processtype = res.getString("processtype");
            long materialgroup = res.getLong("materialgroup");
            long material = res.getLong("material");
            long auxproperty = res.getLong("auxproperty");
            String key = processtype + "@" + material + "@" + auxproperty + "@" + materialgroup;
            if (matRouteIdMap.containsKey(key)) continue;
            matRouteIdMap.put(key, res.getLong("id"));
        }
        return matRouteIdMap;
    }

    public static Map<Object, DynamicObject> getRouterIdAndRouterObjMap(Set<Long> routeIds, String srcEntity, Date calcDate, List<QFilter> filterList) {
        if (CadEmptyUtils.isEmpty(routeIds)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        QFilter idFilter = new QFilter("id", "in", routeIds);
        filterList.add(idFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)srcEntity, (String)"processentry.id processentryid", (QFilter[])filterList.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(dynamicObjects)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        Set processEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)dynamicObjects, (String)"processentryid");
        Object[] cadRouters = BusinessDataServiceHelper.load((String)srcEntity, (String)BomRuleSettingStdCalcHelper.getRouteFields(srcEntity), (QFilter[])new QFilter[]{idFilter});
        if (CadEmptyUtils.isEmpty(cadRouters)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        HashMap<Object, DynamicObject> cadRouterMap = new HashMap<Object, DynamicObject>(16);
        for (Object cadRouter : cadRouters) {
            Object routerId = cadRouter.getPkValue();
            DynamicObjectCollection processEntrys = cadRouter.getDynamicObjectCollection("processentry");
            if (CadEmptyUtils.isEmpty(processEntrys)) continue;
            Iterator iterator = processEntrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject processEntry = (DynamicObject)iterator.next();
                long id = processEntry.getLong("id");
                if (!processEntryIds.contains(id)) {
                    iterator.remove();
                    continue;
                }
                Date entryValiddate = processEntry.getDate("entryvaliddate");
                Date entryInvaliddate = processEntry.getDate("entryinvaliddate");
                if (entryValiddate != null && entryInvaliddate != null && entryValiddate.getTime() <= calcDate.getTime() && entryInvaliddate.getTime() >= calcDate.getTime()) continue;
                iterator.remove();
            }
            cadRouterMap.put(routerId, (DynamicObject)cadRouter);
        }
        return cadRouterMap;
    }

    public static Set<Long> getProcessRoutes(Long costTypeId, Set<String> calcRouteMaterials) {
        HashSet<Long> processRouteIds = new HashSet(10);
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        QFilter matFilter = new QFilter("materialentry.keycol", "in", calcRouteMaterials);
        matFilter.or(new QFilter("routertype", "in", (Object)new String[]{"B", "C"}));
        DynamicObjectCollection processRoutes = QueryServiceHelper.query((String)"cad_routersetting", (String)"router", (QFilter[])new QFilter[]{filter, matFilter}, null);
        processRouteIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)processRoutes, (String)"router");
        return processRouteIds;
    }

    public static Map<Object, DynamicObject> getRouterIdAndRouterObjMapForStruct(Map<String, Long> configBomKeycolRouteMap) {
        if (CadEmptyUtils.isEmpty(configBomKeycolRouteMap)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        ArrayList<Long> routerIds = new ArrayList<Long>(10);
        for (Map.Entry<String, Long> entry : configBomKeycolRouteMap.entrySet()) {
            Long value = entry.getValue();
            routerIds.add(value);
        }
        if (CadEmptyUtils.isEmpty(routerIds)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        Object[] processRoutes = BusinessDataServiceHelper.load((String)"pdm_route", (String)BomRuleSettingStdCalcHelper.getRouteFields("pdm_route"), (QFilter[])new QFilter[]{new QFilter("id", "in", routerIds)});
        if (CadEmptyUtils.isEmpty(processRoutes)) {
            return new HashMap<Object, DynamicObject>(16);
        }
        HashMap<Object, DynamicObject> cadRouterMap = new HashMap<Object, DynamicObject>(16);
        for (Object processRoute : processRoutes) {
            Object routerId = processRoute.getPkValue();
            cadRouterMap.put(routerId, (DynamicObject)processRoute);
        }
        return cadRouterMap;
    }

    public static Set<Long> dealRoute(Map<Object, DynamicObject> routerMap, StandCostCalcParam standCostCalcParam) {
        HashSet<Long> resourceIds = new HashSet<Long>(10);
        logger.info("\u5de5\u827a\u8def\u7ebf\u5904\u7406-\u662f\u5426\u5f00\u542f\u591a\u5de5\u5382\uff1a{}", (Object)standCostCalcParam.isEnableMulFactory());
        if (CadEmptyUtils.isEmpty(routerMap)) {
            return resourceIds;
        }
        HashMap<Long, Long> manuCalcOrgMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Object, DynamicObject> route : routerMap.entrySet()) {
            DynamicObject routeObject = route.getValue();
            if (routeObject == null) continue;
            CostProcessRouteDyo costProcessRoute = null;
            String name = routeObject.getDataEntityType().getName();
            costProcessRoute = "sfc_manftech".equals(name) || "om_mfttechnics".equals(name) ? BomRuleSettingStdCalcHelper.getCostProcessRouteByWork(routeObject) : BomRuleSettingStdCalcHelper.getCostProcessRoute(routeObject, standCostCalcParam.getConfigBomKeycolRouteMap());
            long id = costProcessRoute.getId();
            long manuOrg = costProcessRoute.getManuOrg();
            if (!manuCalcOrgMap.containsKey(manuOrg)) {
                Map org = OrgUnitServiceHelper.getCompanyByOrg((Long)manuOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                logger.info("method\uff1adealRoute\u3002result\uff1amanuOrg\uff1a{}\uff0corg\uff1aid:{}", (Object)manuOrg, org.get("id"));
                Long calOrg = org.get("id") == null ? 0L : Long.parseLong(org.get("id").toString());
                manuCalcOrgMap.put(manuOrg, calOrg);
            }
            List<CostProcessRouteDyo.processEntryRow> processEntryRows = costProcessRoute.getProcessEntryRows();
            for (CostProcessRouteDyo.processEntryRow process : processEntryRows) {
                Boolean isOutSource;
                String processSeq = process.getParent();
                String operationNo = process.getOperationNo();
                long productionOrg = process.getProductionOrg();
                String machiningType = process.getMachiningType();
                if (!manuCalcOrgMap.containsKey(productionOrg)) {
                    Map entryOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)productionOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                    logger.info("method\uff1adealRoute\u3002result\uff1aproductionOrg\uff1a{}\uff0centryOrg\uff1aid:{}", (Object)productionOrg, entryOrg.get("id"));
                    Long calOrg = entryOrg.get("id") == null ? 0L : Long.parseLong(entryOrg.get("id").toString());
                    manuCalcOrgMap.put(productionOrg, calOrg);
                }
                String key = id + "@" + processSeq + "@" + operationNo;
                if (standCostCalcParam.isEnableMulFactory().booleanValue()) {
                    if ("1002".equals(machiningType) || "1003".equals(machiningType) && !BomRuleSettingStdCalcHelper.isEqualForManuProOrg(manuCalcOrgMap, manuOrg, productionOrg).booleanValue()) {
                        standCostCalcParam.getProcessSeqOutSourceMap().put(key, true);
                    } else {
                        standCostCalcParam.getProcessSeqOutSourceMap().put(key, false);
                    }
                    isOutSource = standCostCalcParam.getProcessSeqOutSourceMap().get(key);
                    if (isOutSource != null && isOutSource.booleanValue() && !standCostCalcParam.getProOrgCostTypeMap().containsKey(manuOrg)) {
                        standCostCalcParam.getProOrgCostTypeMap().put(manuOrg, BomRuleSettingStdCalcHelper.getHsCostType(manuOrg, standCostCalcParam.getCalcDate(), standCostCalcParam.isPlanCost(), manuCalcOrgMap));
                    } else if (!standCostCalcParam.getProOrgCostTypeMap().containsKey(productionOrg)) {
                        standCostCalcParam.getProOrgCostTypeMap().put(productionOrg, BomRuleSettingStdCalcHelper.getHsCostType(productionOrg, standCostCalcParam.getCalcDate(), standCostCalcParam.isPlanCost(), manuCalcOrgMap));
                    }
                } else {
                    if ("1002".equals(machiningType)) {
                        standCostCalcParam.getProcessSeqOutSourceMap().put(key, true);
                    } else if ("1003".equals(machiningType)) {
                        if (CadEmptyUtils.isEmpty(manuOrg) && !OrgHelper.getProOrgIdsByCalcOrg((Long)costProcessRoute.getCreateOrg()).contains(productionOrg)) {
                            standCostCalcParam.getProcessSeqOutSourceMap().put(key, true);
                        } else if (!BomRuleSettingStdCalcHelper.isEqualForManuProOrg(manuCalcOrgMap, manuOrg, productionOrg).booleanValue()) {
                            standCostCalcParam.getProcessSeqOutSourceMap().put(key, true);
                        } else {
                            standCostCalcParam.getProcessSeqOutSourceMap().put(key, false);
                        }
                    } else {
                        standCostCalcParam.getProcessSeqOutSourceMap().put(key, false);
                    }
                    isOutSource = standCostCalcParam.getProcessSeqOutSourceMap().get(key);
                    if (isOutSource != null && isOutSource.booleanValue() && !standCostCalcParam.getProOrgCostTypeMap().containsKey(manuOrg)) {
                        standCostCalcParam.getProOrgCostTypeMap().put(manuOrg, standCostCalcParam.getCostTypeId());
                    } else if (!standCostCalcParam.getProOrgCostTypeMap().containsKey(productionOrg)) {
                        standCostCalcParam.getProOrgCostTypeMap().put(productionOrg, standCostCalcParam.getCostTypeId());
                    }
                }
                if (standCostCalcParam.getProcessSeqOutSourceMap().get(key).booleanValue()) continue;
                List<CostProcessRouteDyo.processEntryRow.ActEntryRow> actEntryRows = process.getActEntryRows();
                for (CostProcessRouteDyo.processEntryRow.ActEntryRow actentry : actEntryRows) {
                    long actResource = actentry.getActResource();
                    if (CadEmptyUtils.isEmpty(actResource)) continue;
                    resourceIds.add(actResource);
                }
            }
        }
        return resourceIds;
    }

    public static CostProcessRouteDyo getCostProcessRouteByWork(DynamicObject dynamicObject) {
        CostProcessRouteDyo costProcessRouteDyo = new CostProcessRouteDyo();
        costProcessRouteDyo.setId(dynamicObject.getLong("id"));
        costProcessRouteDyo.setProcessRouteId(dynamicObject.getLong("processroute.id"));
        costProcessRouteDyo.setNumber(dynamicObject.getString("billno"));
        costProcessRouteDyo.setMaterial(dynamicObject.getLong("material.id"));
        costProcessRouteDyo.setAuxpty(dynamicObject.getLong("mftentryseq.auxproperty.id"));
        costProcessRouteDyo.setCreateOrg(dynamicObject.getLong("org.id"));
        costProcessRouteDyo.setManuOrg(dynamicObject.getLong("org.id"));
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("proentryentity");
        for (DynamicObject entry : entryEntity) {
            CostProcessRouteDyo.EntryRow entryRow = costProcessRouteDyo.addNewEntryRow();
            entryRow.setProcessSeq(entry.getString("processseq"));
            entryRow.setProcessseqtype(entry.getString("processseqtype"));
        }
        DynamicObjectCollection processEntryEntity = dynamicObject.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject processEntry : processEntryEntity) {
            CostProcessRouteDyo.processEntryRow processEntryRow2 = costProcessRouteDyo.addNewProcessEntryRow();
            processEntryRow2.setParent(processEntry.getString("oprparent"));
            processEntryRow2.setBaseBatchQty(processEntry.getBigDecimal("basebatchqty"));
            processEntryRow2.setOperation(processEntry.getLong("oproperation.id"));
            processEntryRow2.setMachiningType(processEntry.getString("machiningtype"));
            processEntryRow2.setWorkCenterId(processEntry.getLong("oprworkcenter.id"));
            processEntryRow2.setProductionOrg(processEntry.getLong("oprorg.id"));
            processEntryRow2.setOperationNo(processEntry.getString("oprno"));
            processEntryRow2.setOprSourceEntryId(processEntry.getString("oprsourceentryid"));
            DynamicObjectCollection actEntryEntity = processEntry.getDynamicObjectCollection("actsubentryentity");
            for (DynamicObject actEntry : actEntryEntity) {
                CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow = processEntryRow2.addNewActEntryRow();
                actEntryRow.setProcessStage(actEntry.getString("processstage"));
                actEntryRow.setActivity(actEntry.getLong("actactivity.id"));
                actEntryRow.setActivityUnit(actEntry.getLong("actactivity.unit.id"));
                actEntryRow.setBaseQty(actEntry.getBigDecimal("actqty"));
                actEntryRow.setActResource(actEntry.getLong("actresources.id"));
            }
        }
        return costProcessRouteDyo;
    }

    public static CostProcessRouteDyo getCostProcessRoute(DynamicObject processRoute, Map<String, Long> configBomKeycolRouteMap) {
        String name = processRoute.getDataEntityType().getName();
        CostProcessRouteDyo costProcessRouteDyo = new CostProcessRouteDyo();
        costProcessRouteDyo.setId(processRoute.getLong("id"));
        costProcessRouteDyo.setNumber(processRoute.getString("number"));
        costProcessRouteDyo.setName(processRoute.getString("name"));
        costProcessRouteDyo.setMainProcess(processRoute.getBoolean("ismainprocess"));
        costProcessRouteDyo.setMaterial(processRoute.getLong("material.id"));
        costProcessRouteDyo.setAuxpty(processRoute.getLong("auxproperty.id"));
        if (processRoute.containsProperty("keycol")) {
            costProcessRouteDyo.setKeycol(processRoute.getString("keycol"));
        } else {
            String keycol = "";
            if (!CadEmptyUtils.isEmpty(configBomKeycolRouteMap)) {
                for (Map.Entry<String, Long> entry : configBomKeycolRouteMap.entrySet()) {
                    Long value = entry.getValue();
                    long id = processRoute.getLong("id");
                    if (id != value) continue;
                    keycol = entry.getKey();
                    break;
                }
            }
            if (CadEmptyUtils.isEmpty(keycol)) {
                HashMap<String, Long> keycolMap = new HashMap<String, Long>(16);
                keycolMap.put("material", costProcessRouteDyo.getMaterial());
                keycolMap.put("auxproperty", costProcessRouteDyo.getAuxpty());
                keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            }
            costProcessRouteDyo.setKeycol(keycol);
        }
        costProcessRouteDyo.setCreateOrg(processRoute.getLong("createorg.id"));
        if ("pdm_route".equals(name)) {
            costProcessRouteDyo.setManuOrg(processRoute.getLong("createorg.id"));
        } else {
            costProcessRouteDyo.setManuOrg(processRoute.getLong("manuorg.id"));
        }
        costProcessRouteDyo.setVersion(processRoute.getLong("version.id"));
        DynamicObjectCollection entryEntity = processRoute.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            CostProcessRouteDyo.EntryRow entryRow = costProcessRouteDyo.addNewEntryRow();
            entryRow.setProcessSeq(dynamicObject.getString("processseq"));
            entryRow.setProcessseqtype(dynamicObject.getString("processseqtype"));
        }
        DynamicObjectCollection processEntryEntity = processRoute.getDynamicObjectCollection("processentry");
        for (DynamicObject processEntry : processEntryEntity) {
            CostProcessRouteDyo.processEntryRow processEntryRow2 = costProcessRouteDyo.addNewProcessEntryRow();
            processEntryRow2.setParent(processEntry.getString("parent"));
            processEntryRow2.setBaseBatchQty(processEntry.getBigDecimal("basebatchqty"));
            processEntryRow2.setOperation(processEntry.getLong("operation.id"));
            processEntryRow2.setOperationDesc(processEntry.getString("operationdesc"));
            processEntryRow2.setMachiningType(processEntry.getString("machiningtype"));
            processEntryRow2.setWorkCenterId(processEntry.getLong("workcenter.id"));
            processEntryRow2.setProductionOrg(processEntry.getLong("productionorg.id"));
            processEntryRow2.setOperationNo(processEntry.getString("operationno"));
            DynamicObjectCollection actEntryEntity = processEntry.getDynamicObjectCollection("actentryentity");
            for (DynamicObject actEntry : actEntryEntity) {
                CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow = processEntryRow2.addNewActEntryRow();
                if ("pdm_route".equals(name)) {
                    actEntryRow.setProcessStage(actEntry.getString("activity.processstage"));
                } else {
                    actEntryRow.setProcessStage(actEntry.getString("processstage"));
                }
                actEntryRow.setActivity(actEntry.getLong("activity.id"));
                actEntryRow.setActivityUnit(actEntry.getLong("activity.unit.id"));
                actEntryRow.setBaseQty(actEntry.getBigDecimal("baseqty"));
                actEntryRow.setActResource(actEntry.getLong("actresource.id"));
            }
        }
        return costProcessRouteDyo;
    }

    private static Long getHsCostType(Long manuOrg, Date calcDate, boolean isPlanCost, Map<Long, Long> manuCalcOrgMap) {
        logger.info("method\uff1agetHsCostType\uff0cparam\uff1amanuorg:{}", (Object)manuOrg);
        if (!manuCalcOrgMap.containsKey(manuOrg)) {
            return 0L;
        }
        Long org = manuCalcOrgMap.get(manuOrg);
        logger.info("method\uff1agetHsCostType\uff0cparam\uff1amanuorg:{}\uff1borg:{}", (Object)manuOrg, (Object)org);
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
        if (isEnableMultiFactory) {
            QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
            filter.and("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)calcDate);
            filter.and("invaliddate", ">", (Object)calcDate);
            OrgRelationParam param = new OrgRelationParam();
            param.setFromViewType("04");
            param.setToViewType("05");
            param.setOrgId(manuOrg.longValue());
            param.setIncludeSelf(true);
            param.setDirectViewType("toorg");
            List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (!kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((List)allToOrg) && allToOrg.contains(manuOrg)) {
                filter.and("storageorgunit", "=", (Object)manuOrg);
            } else {
                filter.and("storageorgunit", "=", (Object)(CadEmptyUtils.isEmpty(allToOrg) ? Long.valueOf(0L) : (Long)allToOrg.get(0)));
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(dynamicObjects)) {
                logger.info("\u5de5\u827a\u8def\u7ebf\u5904\u7406-\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7{}\u548c\u5377\u7b97\u65f6\u95f4{}\uff0c\u672a\u627e\u5230\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u7684\u5bf9\u5e94\u5173\u7cfb\u3002", (Object)manuOrg, (Object)calcDate);
                return 0L;
            }
            if (isPlanCost) {
                long costType = ((DynamicObject)dynamicObjects.get(0)).getLong("costType");
                logger.info("\u8ba1\u5212\u6210\u672c\u5904\u7406-\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u83b7\u53d6\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff0c\u751f\u4ea7\u7ec4\u7ec7==>{},\u6838\u7b97\u6210\u672c\u7c7b\u578b==>{}\u3002", (Object)manuOrg, (Object)costType);
                return costType;
            }
            QFilter costTypeFilter = new QFilter("id", "=", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("costType"));
            costTypeFilter.and("enable", "=", (Object)"1");
            costTypeFilter.and("costtypeentry.costtypeattr", "=", (Object)"1");
            DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype.id as costtype", (QFilter[])new QFilter[]{costTypeFilter});
            if (CadEmptyUtils.isEmpty(costTypeObjs)) {
                logger.info("\u5de5\u827a\u8def\u7ebf\u5904\u7406-\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b{}\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u62df\u6210\u672c\u7c7b\u578b\u3002", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("costType"));
                return 0L;
            }
            logger.info("\u5de5\u827a\u8def\u7ebf\u5904\u7406-\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7{}\u548c\u5377\u7b97\u65f6\u95f4{}\uff0c\u627e\u5230\u6a21\u62df\u6210\u672c\u7c7b\u578b{}\u3002", new Object[]{manuOrg, calcDate, ((DynamicObject)costTypeObjs.get(0)).getLong("costtype")});
            return ((DynamicObject)costTypeObjs.get(0)).getLong("costtype");
        }
        QFilter costTypeFilter = new QFilter("createorg", "=", (Object)org);
        costTypeFilter.and("enable", "=", (Object)"1");
        costTypeFilter.and("type", "=", (Object)"1");
        DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cad_costtype", (String)"id", (QFilter[])new QFilter[]{costTypeFilter});
        if (CadEmptyUtils.isEmpty(costTypeObjs)) {
            return 0L;
        }
        return ((DynamicObject)costTypeObjs.get(0)).getLong("id");
    }

    private static Boolean isEqualForManuProOrg(Map<Long, Long> manuCalcOrgMap, Long manuOrg, Long prodOrg) {
        if (CadEmptyUtils.isEmpty(manuCalcOrgMap)) {
            return Boolean.FALSE;
        }
        if (manuCalcOrgMap.get(manuOrg) != null && manuCalcOrgMap.get(prodOrg) != null && manuCalcOrgMap.get(manuOrg).equals(manuCalcOrgMap.get(prodOrg))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void mergeMap(Map<Long, Map<String, DynamicObject>> map1, Map<Long, Map<String, DynamicObject>> map2) {
        if (CadEmptyUtils.isEmpty(map2)) {
            return;
        }
        if (map1 == null) {
            map1 = new HashMap<Long, Map<String, DynamicObject>>(16);
        }
        for (Map.Entry<Long, Map<String, DynamicObject>> mapEntry : map2.entrySet()) {
            Long key = mapEntry.getKey();
            Map<String, DynamicObject> value = mapEntry.getValue();
            if (map1.containsKey(key)) {
                map1.get(key).putAll(value);
                continue;
            }
            map1.put(key, value);
        }
    }

    public static String getRouteFields(String entity) {
        String selectFields = "id,createorg,number,name,ismainprocess,material,auxproperty,version,processtype,materialgroup,entryentity.processseq,entryentity.processseqtype,processentry.id,processentry.parent,processentry.basebatchqty,processentry.operation,processentry.operationdesc,processentry.machiningtype,processentry.workcenter,processentry.productionorg,processentry.operationno,processentry.productionorg,processentry.entryvaliddate,processentry.entryinvaliddate,actentryentity.activity,actentryentity.baseqty,actentryentity.actresource";
        if ("cad_router".equals(entity)) {
            selectFields = selectFields + ",keycol,manuorg,actentryentity.processstage";
        }
        return selectFields;
    }

    public static String getGxRouteFields() {
        return "id,billno,material,mftentryseq.auxproperty,org,processroute,mftentryseq,proentryentity.processseq,proentryentity.processseqtype,oprentryentity.id,oprentryentity.oprparent,oprentryentity.basebatchqty,oprentryentity.oproperation,oprentryentity.machiningtype,oprentryentity.oprworkcenter,oprentryentity.oprorg,oprentryentity.oprno,oprentryentity.oprsourceentryid,actsubentryentity.processstage,actsubentryentity.actactivity,actsubentryentity.actqty,actsubentryentity.actresources";
    }

    public static Set<Long> getPurMatIdsByProduceInfo(Set<Long> productOrgs, Set<Long> materialIds) {
        DataSet matProduceInfo = BomRuleSettingStdCalcHelper.getMatProduceInfo(productOrgs, materialIds);
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (matProduceInfo.hasNext()) {
            String materialAttr;
            Row row = matProduceInfo.next();
            if (row == null || !"10040".equals(materialAttr = row.getString("materialattr"))) continue;
            matIds.add(row.getLong("masterid"));
        }
        return matIds;
    }

    public static DataSet getMatInfo(Set<Long> materialIds) {
        QFilter matInfoFilter = new QFilter("masterid", "in", materialIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMatInfo", (String)"bd_material", (String)"masterid material,number,name,enableproduct,enableoutsource,isuseauxpty,auxptyentry.isaffectprice isaffectprice,isenablematerialversion", (QFilter[])new QFilter[]{matInfoFilter}, null);
        dataSet = dataSet.select("material,number,name,enableproduct,enableoutsource,isuseauxpty,isaffectprice,isenablematerialversion,case when isaffectprice =" + Boolean.TRUE + " then 1L else 0L end affectprice");
        return dataSet.groupBy(new String[]{"material", "number", "name", "enableproduct", "enableoutsource", "isuseauxpty", "isenablematerialversion"}).maxP("affectprice", "isaffectprice").finish();
    }

    public static DataSet getMatProduceInfo(Set<Long> productOrgs, Set<Long> materialIds) {
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), (String)"bd_materialmftinfo");
        QFilter matInfoFilter = new QFilter("masterid", "in", materialIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DataSet materialmftinfos = QueryServiceHelper.queryDataSet((String)"getMatProduceInfo#1", (String)"bd_materialmftinfo", (String)"id,masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter}, null);
        materialmftinfos = materialmftinfos.select("id,masterid,materialattr,ctrlstrategy,level").orderBy(new String[]{"ctrlstrategy desc", "level asc"});
        ArrayList<Long> existMat = new ArrayList<Long>(10);
        ArrayList<Long> matInfoIds = new ArrayList<Long>(10);
        while (materialmftinfos.hasNext()) {
            Row row = materialmftinfos.next();
            Long material = row.getLong("masterid");
            if (existMat.contains(material)) continue;
            existMat.add(material);
            matInfoIds.add(row.getLong("id"));
        }
        return BomRuleSettingStdCalcHelper.getMatProduceInfo(matInfoIds);
    }

    public static DataSet getMatProduceInfo(List<Long> matInfoIds) {
        QFilter filter = new QFilter("id", "in", matInfoIds);
        return QueryServiceHelper.queryDataSet((String)"getMatProduceInfo", (String)"bd_materialmftinfo", (String)"createorg,masterid,materialattr,case when materialattr=='10050' then '1' else '0' end isoutsource", (QFilter[])new QFilter[]{filter}, null);
    }

    public static void getMatAuxptyInfo(Set<Long> auxptyIds, Map<Long, String> auxptyMap, Map<String, String> typeNameMap, Map<Long, String> auxpValueMap) {
        if (CadEmptyUtils.isEmpty(auxptyIds)) {
            return;
        }
        if (auxptyMap == null || typeNameMap == null || auxpValueMap == null) {
            return;
        }
        DynamicObjectCollection auxPropObj = QueryServiceHelper.query((String)"bd_flexauxprop", (String)"id,value", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIds)});
        HashSet auxptyTypes = new HashSet(16);
        HashSet auxptyValue = new HashSet(16);
        auxPropObj.forEach(aux -> {
            if (CadEmptyUtils.isEmpty(aux.getString("value"))) {
                return;
            }
            JSONObject value = (JSONObject)JSON.parse((String)aux.getString("value"));
            for (Map.Entry val : value.entrySet()) {
                Object valValue = val.getValue();
                if (valValue == null) continue;
                auxptyTypes.add(val.getKey());
                if (!String.valueOf(valValue).matches("[0-9]+")) continue;
                Long auxValueId = Long.parseLong(String.valueOf(valValue));
                auxptyValue.add(auxValueId);
            }
            auxptyMap.put(aux.getLong("id"), aux.getString("value"));
        });
        DynamicObjectCollection auxProptys = QueryServiceHelper.query((String)"bd_auxproperty", (String)"flexfield,name", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", auxptyTypes)});
        auxProptys.forEach(aux -> typeNameMap.put(aux.getString("flexfield"), aux.getString("name")));
        DynamicObjectCollection auxProptyValues = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyValue)});
        auxProptyValues.forEach(aux -> auxpValueMap.put(aux.getLong("id"), aux.getString("name")));
    }

    public static DataSet getWxRouteDataSet(String srcRoute, List<Long> routeIds) {
        String otherFields = ",id as sourceid,createorg manuorg";
        if ("cad_router".equals(srcRoute)) {
            otherFields = ",sourceid,manuorg";
        }
        QFilter filter = new QFilter("id", "in", routeIds);
        filter.and(new QFilter("processtype", "in", (Object)new String[]{"A", "B"}));
        filter.and(new QFilter("processentry.machiningtype", "in", (Object)new String[]{"1002", "1003"}));
        String selectFields = "id,number,name,createorg,processtype,materialgroup,material,auxproperty,processentry.machiningtype machiningtype,processentry.productionorg productionorg,processentry.parent processseq,processentry.operationno operationno,processentry.operation operation,processentry.operationdesc operationdesc,processentry.workstation workstation,processentry.id as processentryid" + otherFields;
        DataSet routeDatSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)srcRoute, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        DataSet wwDataSet = routeDatSet.filter("machiningtype='1002'");
        DataSet nxDataSet = routeDatSet.filter("machiningtype='1003' and manuorg!=productionorg");
        HashMap<Long, List> createProOrgMap = new HashMap<Long, List>(10);
        HashMap<Long, Long> manuCalcOrgMap = new HashMap<Long, Long>(16);
        ArrayList<Long> wwProcessEntryIds = new ArrayList<Long>(10);
        while (nxDataSet.hasNext()) {
            Long calOrg;
            Row row = nxDataSet.next();
            Long createOrg = row.getLong("createorg");
            Long manuOrg = row.getLong("manuorg");
            Long productionOrg = row.getLong("productionorg");
            if (CadEmptyUtils.isEmpty(manuOrg)) {
                if (!createProOrgMap.containsKey(createOrg)) {
                    List proOrgIds = OrgHelper.getProOrgIdsByCalcOrg((Long)createOrg);
                    createProOrgMap.put(createOrg, proOrgIds);
                }
                if (((List)createProOrgMap.get(createOrg)).contains(productionOrg)) continue;
                wwProcessEntryIds.add(row.getLong("processentryid"));
                continue;
            }
            if (!manuCalcOrgMap.containsKey(manuOrg)) {
                Map org = OrgUnitServiceHelper.getCompanyByOrg((Long)manuOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                calOrg = org.get("id") == null ? 0L : Long.parseLong(org.get("id").toString());
                manuCalcOrgMap.put(manuOrg, calOrg);
            }
            if (!manuCalcOrgMap.containsKey(productionOrg)) {
                Map entryOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)productionOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                calOrg = entryOrg.get("id") == null ? 0L : Long.parseLong(entryOrg.get("id").toString());
                manuCalcOrgMap.put(productionOrg, calOrg);
            }
            if (((Long)manuCalcOrgMap.get(manuOrg)).equals(manuCalcOrgMap.get(productionOrg))) continue;
            wwProcessEntryIds.add(row.getLong("processentryid"));
        }
        if (!CadEmptyUtils.isEmpty(wwProcessEntryIds)) {
            filter = new QFilter("processentry.id", "in", wwProcessEntryIds);
            nxDataSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)srcRoute, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
            wwDataSet = wwDataSet.union(nxDataSet);
        }
        return wwDataSet;
    }
}

