/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;

public class CalcCheckerHelper {
    private static final Log logger = LogFactory.getLog(CalcCheckerHelper.class);

    public static void createCyclePathCheck(StandCostCalcParam standCostCalcParam, String cyclePath) {
        if (cyclePath == null || cyclePath.length() < 1) {
            return;
        }
        ArrayList<String> cyclePaths = new ArrayList<String>();
        cyclePaths.add(cyclePath);
        CalcCheckerHelper.createCyclePathCheckRs(standCostCalcParam, cyclePaths);
    }

    public static void createCyclePathCheckRs(StandCostCalcParam standCostCalcParam, List<String> contentList) {
        if (CadEmptyUtils.isEmpty(contentList)) {
            return;
        }
        ArrayList<CalcCheckDetailResultInfo> infos = new ArrayList<CalcCheckDetailResultInfo>(10);
        for (int index = 0; index < contentList.size(); ++index) {
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            String cyclePath = contentList.get(index);
            String cycleMessage = CalcCheckerHelper.buidCycleMessage(cyclePath);
            if (CadEmptyUtils.isEmpty(cycleMessage)) continue;
            String error = String.format(ResManager.loadKDString((String)"\u9886\u7528\u5173\u7cfb%s\u5b58\u5728\u5d4c\u5957\u3002", (String)"CalcCheckerHelper_5", (String)"macc-cad-algox", (Object[])new Object[0]), cycleMessage);
            detailinfo.setCheckDetailResult(error);
            infos.add(detailinfo);
        }
        standCostCalcParam.getParams().put("cycleCheckResult", infos);
    }

    public static String getNoPassCheckItem(Long costTypeId, Long checkTaskId, List<Long> affectAllCheckItems) {
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        if (!CadEmptyUtils.isEmpty(affectAllCheckItems)) {
            costTypeFilter.and(new QFilter("checkitem", "in", affectAllCheckItems));
        }
        QFilter taskFilter = new QFilter("calctaskrecord", "=", (Object)checkTaskId);
        QFilter resFilter = new QFilter("checkresult", "=", (Object)String.valueOf(2));
        Object[] calcCheckResults = BusinessDataServiceHelper.load((String)"cad_calccheckresult", (String)"checkitem", (QFilter[])new QFilter[]{costTypeFilter, taskFilter, resFilter});
        StringBuilder checkItemForNoPass = new StringBuilder();
        if (CadEmptyUtils.isEmpty(calcCheckResults)) {
            return checkItemForNoPass.toString();
        }
        for (Object calcCheckResult : calcCheckResults) {
            String itemName = calcCheckResult.getDynamicObject("checkitem").getLocaleString("name").getLocaleValue();
            checkItemForNoPass.append(itemName).append("\uff1b");
        }
        return checkItemForNoPass.toString().substring(0, checkItemForNoPass.lastIndexOf("\uff1b"));
    }

    public static Boolean isExistNoPassCheckItem(Long costTypeId, Long checkTaskId) {
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter taskFilter = new QFilter("calctaskrecord", "=", (Object)checkTaskId);
        QFilter resFilter = new QFilter("checkresult", "=", (Object)String.valueOf(2));
        return QueryServiceHelper.exists((String)"cad_calccheckresult", (QFilter[])new QFilter[]{costTypeFilter, taskFilter, resFilter});
    }

    private static String buidCycleMessage(String cyclePath) {
        String[] nodes = cyclePath.split("@");
        StringBuilder content = new StringBuilder();
        for (int nodeIndex = 0; nodeIndex < nodes.length; ++nodeIndex) {
            String matAuxPro;
            String matVer;
            String node = nodes[nodeIndex];
            DynamicObject matInfo = CalcCheckerHelper.getMatInfo(node);
            if (matInfo == null) continue;
            content.append(String.format(ResManager.loadKDString((String)"%1$s\u7269\u6599\u7f16\u7801\uff1a%2$s", (String)"CalcCheckerHelper_12", (String)"macc-cad-algox", (Object[])new Object[0]), "\u201c", matInfo.getString("number")));
            if (matInfo.getBoolean("isenablematerialversion") && !"".equals(matVer = CalcCheckerHelper.getMatVer(node))) {
                content.append(String.format(ResManager.loadKDString((String)"%1$s\u7248\u672c\u7f16\u53f7\uff1a%2$s", (String)"CalcCheckerHelper_10", (String)"macc-cad-algox", (Object[])new Object[0]), "\uff1b", matVer));
            }
            if (matInfo.getBoolean("isuseauxpty") && !"".equals(matAuxPro = CalcCheckerHelper.getAuxPro(node))) {
                content.append(String.format(ResManager.loadKDString((String)"%1$s\u8f85\u52a9\u5c5e\u6027\uff1a%2$s", (String)"CalcCheckerHelper_11", (String)"macc-cad-algox", (Object[])new Object[0]), "\uff1b", matAuxPro));
            }
            content.append("\u201d");
            if (nodeIndex == nodes.length - 1) continue;
            content.append("\u2014>");
        }
        return content.substring(0, content.length());
    }

    private static DynamicObject getMatInfo(String matid) {
        QFilter filter = new QFilter("masterid", "=", (Object)Long.parseLong(matid));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject materialMftInfo = QueryServiceHelper.queryOne((String)"cad_costbom", (String)"material.masterid material", (QFilter[])new QFilter[]{filter, enableFilter});
        if (materialMftInfo == null) {
            materialMftInfo = QueryServiceHelper.queryOne((String)"pdm_mftbom", (String)"material.masterid.masterid material", (QFilter[])new QFilter[]{filter, enableFilter});
        }
        if (materialMftInfo == null) {
            return null;
        }
        QFilter materialFilter = new QFilter("masterid", "=", (Object)materialMftInfo.getLong("material"));
        DynamicObject materialInfo = QueryServiceHelper.queryOne((String)"bd_material", (String)"number,isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[]{materialFilter});
        return materialInfo;
    }

    private static String getMatVer(String bomid) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(bomid));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject materialMftInfo = QueryServiceHelper.queryOne((String)"cad_costbom", (String)"version.name", (QFilter[])new QFilter[]{filter, enableFilter});
        if (materialMftInfo == null) {
            return "";
        }
        return materialMftInfo.getString("version.name");
    }

    private static String getAuxPro(String matVerId) {
        return "";
    }
}

