/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CostTypeHelper;

public class CalcMutexHelper {
    private static final Log logger = LogFactory.getLog(CalcMutexHelper.class);
    public static final String ENTITY_SCA_WIPCALWIZARDS = "sca_wipcalwizards";
    public static final String ENTITY_SCA_FINISHCALWIZARDS = "sca_finishcalwizards";
    public static final String ENTITY_CAD_STDCALCNEW = "cad_stdcalcnew";
    public static final String ENTITY_CAD_COSTUPDATEESTABLISHED = "cad_costupdateestablished";
    public static final String ENTITY_CAD_PURPRICES = "cad_purprices";
    public static final String ENTITY_CAD_RESOURCERATE = "cad_resourcerate";
    public static final String ENTITY_CAD_ROUTERSETTING = "cad_routersetting";
    public static final String ENTITY_CAD_BOMSETTING = "cad_bomsetting";
    public static final String ENTITY_SCA_DIFFCALWIZARDS = "sca_differencecalcwizards";
    public static final String ENTITY_SCA_FACTCOSTREDUCT = "sca_factcostreduction";
    public static final String ENTITY_SCA_MATALLOC = "sca_matalloc";
    public static final String ENTITY_MFGFEEALLOC = "sca_mfgfeealloc";
    private static final Map<String, List<String>> typeMap = new HashMap<String, List<String>>();
    public static final String PDEND = "pdend";
    public static final String FINISH = "finish";
    public static final String STDCALC = "stdcalc";
    public static final String UPDATE = "update";
    public static final String PRICING = "pricing";
    public static final String PRICING_RES = "pricing_res";
    public static final String REFRESH_ROUTE = "refreshroute";
    public static final String REFRESH_BOM = "refreshbom";
    public static final String DIFFCALC = "diffcalc";
    public static final String REDUCTCALC = "reductcalc";
    public static final String MATDIST = "matdist";
    public static final String MANDIST = "mandist";

    private static synchronized String requireXMutex(String type, Set<Long> ids) {
        String failName = null;
        boolean allLock = true;
        for (Long id : ids) {
            allLock = MutexHelper.require((String)typeMap.get(type).get(0), (Object)id, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)new StringBuilder());
            if (allLock) continue;
            failName = CalcMutexHelper.getName(id);
            logger.error(String.format("%s\uff0c%s\uff0c%s \u52a0\u9501\u4e0d\u6210\u529f", typeMap.get(type).get(0), typeMap.get(type).get(1), failName));
            break;
        }
        if (!allLock) {
            CalcMutexHelper.releaseXMutex(type, ids);
        }
        return failName;
    }

    public static synchronized boolean releaseXMutex(String type, Set<Long> ids) {
        boolean allUnLock = true;
        for (Long id : ids) {
            allUnLock = MutexHelper.release((String)typeMap.get(type).get(0), (String)typeMap.get(type).get(1), (String)id.toString());
            if (allUnLock) continue;
            logger.error(String.format("%s\uff0c%s\uff0c%s \u91ca\u653e\u9501\u4e0d\u6210\u529f", typeMap.get(type).get(0), typeMap.get(type).get(1), CalcMutexHelper.getName(id)));
            break;
        }
        return allUnLock;
    }

    public static String checkXMutex(String type, Set<Long> costTypeIds) {
        String checkErr = null;
        switch (type) {
            case "pdend": {
                checkErr = CalcMutexHelper.enableReentrant(PDEND, costTypeIds);
                break;
            }
            case "finish": {
                checkErr = CalcMutexHelper.enableReentrant(FINISH, costTypeIds);
                break;
            }
            case "stdcalc": {
                checkErr = CalcMutexHelper.enableReentrant(STDCALC, costTypeIds);
                break;
            }
            case "update": {
                checkErr = CalcMutexHelper.enableReentrant(UPDATE, costTypeIds);
                break;
            }
            case "pricing": {
                checkErr = CalcMutexHelper.enableReentrant(PRICING, costTypeIds);
                break;
            }
            case "pricing_res": {
                checkErr = CalcMutexHelper.enableReentrant(PRICING_RES, costTypeIds);
            }
        }
        if (StringUtils.isNotEmpty(checkErr)) {
            return checkErr;
        }
        return null;
    }

    public static String checkAndRequireXMutex(String type, Set<Long> costTypeIds) {
        String checkErr = null;
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String typeKey;
            switch (typeKey = iterator.next()) {
                case "pdend": {
                    checkErr = CalcMutexHelper.enableReentrant(PDEND, costTypeIds);
                    break;
                }
                case "finish": {
                    checkErr = CalcMutexHelper.enableReentrant(FINISH, costTypeIds);
                    break;
                }
                case "stdcalc": {
                    checkErr = CalcMutexHelper.enableReentrant(STDCALC, costTypeIds);
                    break;
                }
                case "update": {
                    checkErr = CalcMutexHelper.enableReentrant(UPDATE, costTypeIds);
                    break;
                }
                case "pricing": {
                    checkErr = CalcMutexHelper.enableReentrant(PRICING, costTypeIds);
                    break;
                }
                case "pricing_res": {
                    checkErr = CalcMutexHelper.enableReentrant(PRICING_RES, costTypeIds);
                }
            }
            if (!StringUtils.isNotEmpty(checkErr)) continue;
            return checkErr;
        }
        String requireErr = CalcMutexHelper.requireXMutex(type, costTypeIds);
        if (StringUtils.isNotEmpty((String)requireErr)) {
            return String.format(CalcMutexHelper.getErrTips(type), requireErr);
        }
        return null;
    }

    public static synchronized String enableReentrant(String type, Set<Long> costTypeIds) {
        for (Long costTypeId : costTypeIds) {
            if (MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1))) continue;
            String tips = CalcMutexHelper.getErrTips(type);
            return String.format(tips, CalcMutexHelper.getName(Long.parseLong(((Object)costTypeId).toString())));
        }
        return null;
    }

    private static String getName(Long id) {
        DynamicObject dy = CostTypeHelper.getCostType(id, "name");
        if (dy == null) {
            QFilter filter = new QFilter("id", "=", (Object)id);
            dy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{filter});
        }
        return dy.getLocaleString("name").getLocaleValue();
    }

    public static String getErrTips(String type) {
        switch (type) {
            case "pdend": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u671f\u672b\u5728\u4ea7\u54c1\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
            case "finish": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5b8c\u4ea7\u54c1\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_2", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
            case "stdcalc": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5377\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_3", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
            case "update": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u6210\u672c\u66f4\u65b0\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_4", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
            case "pricing": 
            case "pricing_res": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_5", (String)"macc-cad-algox", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String checkAndRequireXMutexAll(String type, Set<Long> costAcctIds) {
        String checkErr = null;
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String typeKey;
            switch (typeKey = iterator.next()) {
                case "pdend": {
                    checkErr = CalcMutexHelper.enableReentrantAll(PDEND, costAcctIds);
                    break;
                }
                case "finish": {
                    checkErr = CalcMutexHelper.enableReentrantAll(FINISH, costAcctIds);
                    break;
                }
                case "stdcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(STDCALC, costAcctIds);
                    break;
                }
                case "update": {
                    checkErr = CalcMutexHelper.enableReentrantAll(UPDATE, costAcctIds);
                    break;
                }
                case "pricing": {
                    checkErr = CalcMutexHelper.enableReentrantAll(PRICING, costAcctIds);
                    break;
                }
                case "pricing_res": {
                    checkErr = CalcMutexHelper.enableReentrantAll(PRICING_RES, costAcctIds);
                    break;
                }
                case "diffcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(DIFFCALC, costAcctIds);
                    break;
                }
                case "reductcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(REDUCTCALC, costAcctIds);
                    break;
                }
                case "matdist": {
                    checkErr = CalcMutexHelper.enableReentrantAll(MATDIST, costAcctIds);
                    break;
                }
                case "mandist": {
                    checkErr = CalcMutexHelper.enableReentrantAll(MANDIST, costAcctIds);
                }
            }
            if (!StringUtils.isNotEmpty(checkErr)) continue;
            return checkErr;
        }
        String requireErr = CalcMutexHelper.requireXMutex(type, costAcctIds);
        if (StringUtils.isNotEmpty((String)requireErr)) {
            return String.format(CalcMutexHelper.getErrTips(type), requireErr);
        }
        return null;
    }

    public static synchronized String enableReentrantAll(String type, Set<Long> costAcctIds) {
        for (Long costAcctId : costAcctIds) {
            if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costAcctId, (String)typeMap.get(type).get(1))) {
                String tips = CalcMutexHelper.getErrTips(type);
                if (tips == null) {
                    return null;
                }
                return String.format(tips, CalcMutexHelper.getName(Long.parseLong(costAcctId.toString())));
            }
            if (MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)String.valueOf(costAcctId).hashCode(), (String)typeMap.get(type).get(1))) continue;
            String tips = CalcMutexHelper.getErrTips(type);
            if (tips == null) {
                return null;
            }
            return String.format(tips, CalcMutexHelper.getName(Long.parseLong(costAcctId.toString())));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkMutexAndLock(String type, boolean enableMulFactory, Long acctId, Set<Long> orgSet) {
        boolean releaseFlag = true;
        boolean cancelFlag = false;
        HashSet<Long> cancelOrgSet = new HashSet<Long>(8);
        String lockErr = CalcMutexHelper.checkAndRequireXMutex(type, acctId);
        try {
            if (StringUtils.isNotEmpty((String)lockErr)) {
                releaseFlag = false;
                String string = lockErr;
                return string;
            }
            if (enableMulFactory) {
                Iterator<Long> ite = orgSet.iterator();
                String lockStr = "";
                while (ite.hasNext()) {
                    Long orgId = ite.next();
                    lockStr = String.valueOf(acctId) + orgId;
                    lockErr = CalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                    if (StringUtils.isNotEmpty((String)lockErr)) {
                        cancelFlag = true;
                        String string = lockErr;
                        return string;
                    }
                    cancelOrgSet.add(orgId);
                }
            }
        }
        finally {
            if (enableMulFactory && releaseFlag) {
                CalcMutexHelper.releaseXMutex(type, acctId);
            }
            if (cancelFlag && cancelOrgSet.size() > 0) {
                for (Long orgId : cancelOrgSet) {
                    CalcMutexHelper.releaseXMutex(type, (String.valueOf(acctId) + orgId).hashCode());
                }
            }
        }
        return null;
    }

    public static String checkAndRequireXMutex(String type, Object costTypeId) {
        return CalcMutexHelper.checkAndRequireXMutex(type, costTypeId, true);
    }

    public static String checkAndRequireXMutex(String type, Object costTypeId, boolean ischeckOther) {
        String checkErr = null;
        if (ischeckOther) {
            Iterator<String> iterator = typeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String typeKey;
                switch (typeKey = iterator.next()) {
                    case "pdend": {
                        checkErr = CalcMutexHelper.enableReentrant(PDEND, costTypeId);
                        break;
                    }
                    case "finish": {
                        checkErr = CalcMutexHelper.enableReentrant(FINISH, costTypeId);
                        break;
                    }
                    case "stdcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(STDCALC, costTypeId);
                        break;
                    }
                    case "update": {
                        checkErr = CalcMutexHelper.enableReentrant(UPDATE, costTypeId);
                        break;
                    }
                    case "diffcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(DIFFCALC, costTypeId);
                        break;
                    }
                    case "reductcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(REDUCTCALC, costTypeId);
                        break;
                    }
                    case "matdist": {
                        checkErr = CalcMutexHelper.enableReentrant(MATDIST, costTypeId);
                        break;
                    }
                    case "mandist": {
                        checkErr = CalcMutexHelper.enableReentrant(MANDIST, costTypeId);
                    }
                }
                if (!StringUtils.isNotEmpty(checkErr)) continue;
                return checkErr;
            }
        }
        if (!CalcMutexHelper.requireXMutex(type, costTypeId)) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static synchronized String enableReentrant(String type, Object costTypeId) {
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1))) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    private static synchronized boolean requireXMutex(String type, Object costTypeId) {
        StringBuilder errMsg = new StringBuilder();
        return MutexHelper.require((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)errMsg);
    }

    public static synchronized boolean releaseXMutex(String type, Object costTypeId) {
        return MutexHelper.release((String)typeMap.get(type).get(0), (String)typeMap.get(type).get(1), (String)String.valueOf(costTypeId));
    }

    static {
        typeMap.put(PDEND, Arrays.asList(ENTITY_SCA_WIPCALWIZARDS, "calculate"));
        typeMap.put(FINISH, Arrays.asList(ENTITY_SCA_FINISHCALWIZARDS, "calc"));
        typeMap.put(STDCALC, Arrays.asList(ENTITY_CAD_STDCALCNEW, "calculate"));
        typeMap.put(UPDATE, Arrays.asList(ENTITY_CAD_COSTUPDATEESTABLISHED, "liveupdate"));
        typeMap.put(PRICING, Arrays.asList(ENTITY_CAD_PURPRICES, "purpricing"));
        typeMap.put(PRICING_RES, Arrays.asList(ENTITY_CAD_RESOURCERATE, "purpricing"));
        typeMap.put(DIFFCALC, Arrays.asList(ENTITY_SCA_DIFFCALWIZARDS, DIFFCALC));
        typeMap.put(REDUCTCALC, Arrays.asList(ENTITY_SCA_FACTCOSTREDUCT, REDUCTCALC));
        typeMap.put(MATDIST, Arrays.asList(ENTITY_SCA_MATALLOC, MATDIST));
        typeMap.put(MANDIST, Arrays.asList(ENTITY_MFGFEEALLOC, MANDIST));
    }
}

