/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.common.helper.MatDimensionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcPriceHelper {
    public static Map<String, String> getActualKeycolMap(Long costTypeId, List<String> materialKeyCols) {
        Map<String, String> actualKeycolMap = new HashMap<String, String>(16);
        if (CadEmptyUtils.isEmpty(materialKeyCols)) {
            return actualKeycolMap;
        }
        Map<Long, List<DynamicObject>> materialKeyColObjMap = CalcPriceHelper.getMaterialKeyColObjMap(materialKeyCols);
        Map dimensionByMatIds = MatDimensionHelper.getDimensionByMatIds((Long)costTypeId, materialKeyColObjMap.keySet());
        actualKeycolMap = BomRuleSettingStdCalcHelper.getActualKeycolMap(materialKeyColObjMap, dimensionByMatIds);
        return actualKeycolMap;
    }

    private static Map<Long, List<DynamicObject>> getMaterialKeyColObjMap(List<String> keyCols) {
        QFilter filter = new QFilter("keycol", "in", keyCols);
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"keycol,material,matvers,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{filter});
        HashMap<Long, List<DynamicObject>> materialKeyColObjMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dyKeyCol : dyKeyCols) {
            materialKeyColObjMap.computeIfAbsent(dyKeyCol.getLong("material"), p -> new ArrayList()).add(dyKeyCol);
        }
        return materialKeyColObjMap;
    }
}

