/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.algox.calc.helper.ElementRelationHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;

public class CostTypeHelper {
    public static DynamicObject[] getCostType(int type) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (type != -1) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        }
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        HasPermOrgResult permOrgList = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
        List<Long> orgs = ElementRelationHelper.getOrgRangBy(permOrgList.getHasPermOrgs(), "5");
        if (!CadEmptyUtils.isEmpty(orgs)) {
            qfilters.add(new QFilter("createorg", "in", orgs));
        }
        return BusinessDataServiceHelper.load((String)"cad_costtype", (String)"number,name,id", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"type asc");
    }

    public static boolean isUseMatVersion(Long costTypeId) {
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"isuseversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        if (costType == null) {
            return true;
        }
        return !costType.getBoolean("isuseversion");
    }

    public static void sortByType(List<DynamicObject> costTypeList) {
        Collections.sort(costTypeList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getInt("type") - o1.getInt("type");
            }
        });
    }

    public static DynamicObject getCostType(Long costTypeId, String queryFields) {
        String qFields = "id,number,name,status,enable,createtime,masterid,ctrlstrategy,type,isupdate,issystem,currency,elementtype";
        if (queryFields != null) {
            qFields = queryFields;
        }
        QFilter filter = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject costType = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costtype", (String)qFields, (QFilter[])new QFilter[]{filter});
        return costType;
    }

    public static int getPriceprecision(Long costTypeId) {
        DynamicObject costType = CostTypeHelper.getCostType(costTypeId, "id,currency.priceprecision");
        if (costType == null) {
            return 6;
        }
        return costType.getInt("currency.priceprecision");
    }

    public static List<Long> getCalcOrgByCostType(String costtypeid) {
        QFilter costtypeFilter = new QFilter("id", "=", (Object)Long.valueOf(costtypeid));
        DynamicObjectCollection costtypes = QueryServiceHelper.query((String)"cad_costtype", (String)"masterid,createorg.masterid,ctrlstrategy", (QFilter[])new QFilter[]{costtypeFilter});
        if (costtypes == null || costtypes.size() < 1) {
            return null;
        }
        DynamicObject costtype = (DynamicObject)costtypes.get(0);
        Long orgId = costtype.getLong("createorg.masterid");
        String strategy = costtype.getString("ctrlstrategy");
        List<Long> orgs = ElementRelationHelper.getOrgRangBy(Collections.singletonList(orgId), strategy);
        return orgs;
    }

    public static QFilter getCurrUserUsableCostTypeFilter() {
        DynamicObject[] costType = CostTypeHelper.getCostType(-1);
        if (costType != null && costType.length > 0) {
            List list = Arrays.stream(costType).map(e -> e.getLong("id")).collect(Collectors.toList());
            return new QFilter("id", "in", list);
        }
        return new QFilter("id", "=", (Object)-1);
    }

    public static Set<Long> getMaterialByCostType(String costTypeId) {
        HashSet<Long> mats = new HashSet<Long>();
        QFilter costtypeFilter = new QFilter("id", "=", (Object)Long.valueOf(costTypeId));
        DynamicObjectCollection costtypes = QueryServiceHelper.query((String)"cad_costtype", (String)"masterid,createorg.masterid,ctrlstrategy", (QFilter[])new QFilter[]{costtypeFilter});
        if (costtypes == null || costtypes.size() < 1) {
            return mats;
        }
        DynamicObject costtype = (DynamicObject)costtypes.get(0);
        Long orgId = costtype.getLong("createorg.masterid");
        String strategy = costtype.getString("ctrlstrategy");
        List<Long> orgs = ElementRelationHelper.getOrgRangBy(Collections.singletonList(orgId), strategy);
        if (orgs == null || orgs.size() < 1) {
            return mats;
        }
        for (int index = 0; index < orgs.size(); ++index) {
            QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgs.get(index));
            Set matsSet = (Set)materialFilter.getValue();
            for (Object mat : matsSet) {
                mats.add((Long)mat);
            }
        }
        return mats;
    }
}

