/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Deprecated
public class CostUpdateWipCalServiceHelper {
    private Log logger = LogFactory.getLog(CostUpdateWipCalServiceHelper.class);
    private DynamicObject updateBill;
    private DynamicObjectCollection productEntry;
    private Boolean isFirst;

    public CostUpdateWipCalServiceHelper(DynamicObject updateBill, DynamicObjectCollection productEntry, Boolean isFirst) {
        this.updateBill = updateBill;
        this.productEntry = productEntry;
        this.isFirst = isFirst;
    }

    public void doCalc() {
        try {
            this.logger.info("\u81ea\u52a8\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5f00\u59cb...");
            Set<Long> keyColIds = CostUpdateHelper.getRelatedKeyCols((DynamicObject)this.updateBill).keySet();
            DynamicObject srcCostType = CostTypeHelper.getCostType((Long)this.updateBill.getLong("srccosttype.id"), null);
            Long currencyId = srcCostType.getLong("currency.id");
            DynamicObjectCollection sysCtrlInfos = this.getOrgCostAccPerid(this.updateBill);
            this.dealDynamicObjectCollection(sysCtrlInfos, keyColIds, currencyId);
            this.logger.info("\u81ea\u52a8\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u7ed3\u675f...");
        }
        catch (Exception ex) {
            this.logger.error("\u81ea\u52a8\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff1a" + this.wrapExceptionErrorInfo(ex));
        }
    }

    private String wrapExceptionErrorInfo(Throwable ex) {
        StringBuilder oSB = new StringBuilder();
        oSB.append(String.format(ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38%s", (String)"CostUpdateWipCalServiceHelper_6", (String)"macc-cad-algox", (Object[])new Object[0]), ", s"));
        oSB.append("TraceId\uff1a").append(RequestContext.get().getTraceId()).append(", ");
        oSB.append(ResManager.loadKDString((String)"\u5f02\u5e38\u6d88\u606f\uff1a", (String)"CostUpdateWipCalServiceHelper_4", (String)"macc-cad-algox", (Object[])new Object[0])).append(ex.getMessage()).append("\r\n");
        String stacktrace = ExceptionUtils.getStackTrace((Throwable)ex);
        oSB.append(ResManager.loadKDString((String)"\u8c03\u7528\u5806\u6808\uff1a", (String)"CostUpdateWipCalServiceHelper_5", (String)"macc-cad-algox", (Object[])new Object[0])).append("\r\n");
        oSB.append(stacktrace).append("\r\n");
        return oSB.toString();
    }

    private void dealDynamicObjectCollection(DynamicObjectCollection sysCtrlInfos, Set<Long> keyColIds, Long currencyId) {
        if (sysCtrlInfos == null || sysCtrlInfos.isEmpty()) {
            return;
        }
        this.logger.info("\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u6838\u7b97\u671f\u95f4\u7684\u96c6\u5408\u6570\u636e\uff1a" + sysCtrlInfos.size());
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        for (DynamicObject sysCtrlInfo : sysCtrlInfos) {
            this.dealDynamicObject(sysCtrlInfo, keyColIds, currencyId, cache);
        }
    }

    private void dealCache(DistributeSessionlessCache cache, String joinStrKey, String cachePueKey, String message) {
        cache.put(cachePueKey, (Object)message);
        cache.remove(joinStrKey);
    }

    private void dealDynamicObject(DynamicObject sysCtrlInfo, Set<Long> keyColIds, Long currencyId, DistributeSessionlessCache cache) {
        DynamicObject currPeriodId;
        long orgId = sysCtrlInfo.getLong("orgid");
        long costAccountId = sysCtrlInfo.getLong("costaccountid");
        DynamicObject effectPeriod = this.updateBill.getDynamicObject("period");
        if (effectPeriod != null && Boolean.TRUE.equals(CostUpdateHelper.isUpdateByPeriod((Long)orgId, (Long)costAccountId)) && !(currPeriodId = PeriodHelper.getCurrentPeriod((Long)costAccountId)).getPkValue().equals(effectPeriod.getPkValue())) {
            this.logger.info(String.format("\u6309\u671f\u66f4\u65b0\u4e0b\uff0c\u6838\u7b97\u7ec4\u7ec7%s \u6210\u672c\u8d26\u7c3f%s \u751f\u6548\u671f\u95f4%s \u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4%s\uff0c\u4e0d\u8c03\u7528\u8ba1\u7b97", orgId, costAccountId, effectPeriod.getPkValue(), currPeriodId.getPkValue()));
            return;
        }
        long periodId = sysCtrlInfo.getLong("currentperiod");
        String joinStrKey = String.join((CharSequence)"&", String.valueOf(orgId), String.valueOf(costAccountId), String.valueOf(periodId));
        this.logger.info("\u6838\u7b97\u7ec4\u7ec7&\u6210\u672c\u8d26\u7c3f&\u6838\u7b97\u671f\u95f4\u62fc\u63a5\u7684joinStrKey: " + joinStrKey);
        if (Boolean.TRUE.equals(this.isFirst)) {
            DynamicObjectCollection costObjects;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
            filters.add(new QFilter("org", "=", (Object)orgId));
            List<Long> costObjectIds = this.getCostObjectIds(orgId, keyColIds);
            if (!CadEmptyUtils.isEmpty(keyColIds) && !CadEmptyUtils.isEmpty(costObjectIds)) {
                filters.add(new QFilter("id", "in", costObjectIds));
            }
            if ((costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,manuorg,costcenter", (QFilter[])filters.toArray(new QFilter[0]))).isEmpty()) {
                cache.put(joinStrKey, (Object)"000000");
                return;
            }
            this.doPeriodEndCalc(sysCtrlInfo, (List<DynamicObject>)costObjects, currencyId, cache, joinStrKey);
        } else {
            List<DynamicObject> productEntrys = this.productEntry.stream().filter(p -> p.getLong("org.id") == orgId).filter(p -> p.getLong("costaccountbook.id") == costAccountId).filter(p -> p.getLong("period.id") == periodId).collect(Collectors.toList());
            HashSet ids = new HashSet(productEntrys.size());
            productEntrys.forEach(p -> ids.add(p.getLong("costobject.id")));
            if (ids.isEmpty()) {
                this.logger.info(String.format("\u6838\u7b97\u7ec4\u7ec7%s \u6210\u672c\u8d26\u7c3f%s \u671f\u95f4%s\u4e0b\u65e0\u6210\u672c\u6838\u7b97\u5bf9\u8c61", orgId, costAccountId, periodId));
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("costobject", "in", ids)};
            DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject.id AS id,bizstatus,costobject.manuorg.id AS manuorg,costobject.costcenter.id AS costcenter", (QFilter[])filters);
            if (costObjects.isEmpty()) {
                cache.put(joinStrKey, (Object)"000000");
                return;
            }
            ArrayList<DynamicObject> aCostObjects = new ArrayList<DynamicObject>(16);
            for (DynamicObject costObject : costObjects) {
                if (!"A".equals(costObject.getString("bizstatus"))) continue;
                aCostObjects.add(costObject);
            }
            this.logger.info(String.format("aCostObjects = %s", aCostObjects.size()));
            if (!CadEmptyUtils.isEmpty(aCostObjects)) {
                this.doPeriodEndCalc(sysCtrlInfo, aCostObjects, currencyId, cache, joinStrKey);
            }
        }
    }

    private void updateCalcReportType(JSONObject jsonObj, String reportType) {
        DynamicObject[] calcReports;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)new Long[]{jsonObj.getLong("checkResultId"), jsonObj.getLong("calcReportId")})};
        for (DynamicObject calcReport : calcReports = BusinessDataServiceHelper.load((String)"sca_calcreport", (String)"reporttype", (QFilter[])filters)) {
            calcReport.set("reporttype", (Object)reportType);
        }
        SaveServiceHelper.update((DynamicObject[])calcReports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPeriodEndCalc(DynamicObject sysCtrlInfo, List<DynamicObject> costObjects, Long currencyId, DistributeSessionlessCache cache, String joinStrKey) {
        long orgId = sysCtrlInfo.getLong("orgid");
        long costAccountId = sysCtrlInfo.getLong("costaccountid");
        long periodId = sysCtrlInfo.getLong("currentperiod");
        HashSet costObjSet = new HashSet(costObjects.size());
        HashSet costCenterSet = new HashSet(costObjects.size());
        HashSet manuOrgIds = new HashSet(16);
        HashMap costCenterGroup = new HashMap(8);
        costObjects.forEach(p -> {
            costObjSet.add(p.getLong("id"));
            costCenterSet.add(p.getLong("costcenter"));
            Set longSet = costCenterGroup.computeIfAbsent(p.getLong("costcenter"), r -> new HashSet());
            longSet.add(p.getLong("id"));
            Long manuOrgId = p.getLong("manuorg");
            if (manuOrgId > 0L) {
                manuOrgIds.add(manuOrgId);
            }
        });
        JSONObject json = new JSONObject();
        json.accumulate("orgId", orgId);
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            json.accumulate("manuOrgIds", manuOrgIds);
            json.accumulate("manuOrgId", 0L);
        } else {
            json.accumulate("manuOrgIds", null);
            json.accumulate("manuOrgId", 0L);
        }
        json.accumulate("costAccountId", costAccountId);
        json.accumulate("periodId", periodId);
        json.accumulate("startDate", (Object)sysCtrlInfo.getString("begindate"));
        json.accumulate("endDate", (Object)sysCtrlInfo.getString("enddate"));
        json.accumulate("currencyId", (Object)currencyId);
        json.accumulate("costCenterIds", (Object)Lists.newArrayList(costCenterSet));
        HashMap<String, Integer> ccAndCoInfos = new HashMap<String, Integer>(costCenterGroup.size());
        for (Map.Entry entry : costCenterGroup.entrySet()) {
            ccAndCoInfos.put(String.valueOf(entry.getKey()), ((Set)entry.getValue()).size());
        }
        json.accumulate("ccAndCoInfos", ccAndCoInfos);
        json.accumulate("costObjectIds", costObjSet);
        json.accumulate("checkWay", 1);
        json.accumulate("matCalType", (Object)"1");
        json.accumulate("mfgCalType", (Object)"2");
        json.accumulate("appNum", (Object)"sca");
        json.accumulate("isSourceUpdate", (Object)Boolean.TRUE);
        Object result = null;
        HashSet<Long> costAcctSet = new HashSet<Long>(1);
        costAcctSet.add(costAccountId);
        try {
            String lockErr = CalcMutexHelper.checkAndRequireXMutexAll("pdend", costAcctSet);
            if (StringUtils.isNotEmpty((String)lockErr)) {
                this.logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97(costAccountId=" + costAccountId + ")\u4ecd\u7136\u5728\u9501\u72b6\u6001\u4e2d\uff0c\u8bf7\u7ee7\u7eed\u7b49\u5f85....");
                return;
            }
            result = DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"periodEndCalc", (Object[])new Object[]{json.toString()});
        }
        catch (Exception e) {
            this.dealCache(cache, joinStrKey, joinStrKey + "_calOpErrMsg", e.getMessage());
            this.logger.error("\u81ea\u52a8\u6267\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5f02\u5e38: " + e.getMessage());
        }
        finally {
            CalcMutexHelper.releaseXMutex("pdend", costAcctSet);
        }
        if (result == null) {
            return;
        }
        this.logger.info("\u8c03\u7528\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5fae\u670d\u52a1\u8fd4\u56de\u7ed3\u679cresult=" + result);
        JSONObject jsonObj = (JSONObject)SerializationUtils.fromJsonString((String)String.valueOf(result), JSONObject.class);
        this.dealCache(cache, joinStrKey + "_calOpErrMsg", joinStrKey, jsonObj.getString("checkResultId"));
        this.updateCalcReportType(jsonObj, "4");
    }

    private DynamicObjectCollection getOrgCostAccPerid(DynamicObject updateBill) {
        DynamicObject targetDyn = updateBill.getDynamicObject("targetcosttype");
        ArrayList costAccPkIdList = new ArrayList(16);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", targetDyn.getPkValue()), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection costAccount = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costaccount.id costaccount", (QFilter[])filters);
        costAccount.forEach(p -> costAccPkIdList.add(p.getLong("costaccount")));
        QFilter costaccountFilter = new QFilter("entryentity.costaccount", "in", costAccPkIdList);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)"1");
        DynamicObjectCollection startstdcosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.masterid orgid,entryentity.costaccount.id costaccountid", (QFilter[])new QFilter[]{costaccountFilter, isInitFilter});
        QFilter filter = null;
        for (DynamicObject startstdcost : startstdcosts) {
            QFilter itemFilter = new QFilter("org", "=", startstdcost.get("orgid"));
            itemFilter.and("entry.costaccount", "=", startstdcost.get("costaccountid"));
            if (filter == null) {
                filter = itemFilter;
                continue;
            }
            filter.or(itemFilter);
        }
        return QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,org.id orgid,entry.costaccount.id costaccountid, entry.currentperiod currentperiod,entry.currentperiod.begindate begindate,entry.currentperiod.enddate enddate", (QFilter[])new QFilter[]{filter});
    }

    public DynamicObject getUpdateBill() {
        return this.updateBill;
    }

    public void setUpdateBill(DynamicObject updateBill) {
        this.updateBill = updateBill;
    }

    private List<Long> getCostObjectIds(Long orgId, Set<Long> keyColIds) {
        ArrayList<Long> costObjectIds = new ArrayList<Long>(keyColIds.size());
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DataSet costObjects = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"id,material,bomversion,auxpty,configuredcode,tracknumber,projectnumber,lot", (QFilter[])filters, null);
        HashMap<String, Object> values = null;
        for (Row costObject : costObjects) {
            values = new HashMap<String, Object>(7);
            values.put("material", costObject.getLong("material"));
            values.put("matvers", costObject.getLong("bomversion"));
            values.put("auxproperty", costObject.getLong("auxpty"));
            values.put("project", costObject.getLong("projectnumber"));
            values.put("tracknumber", costObject.getLong("tracknumber"));
            values.put("configuredcode", costObject.getLong("configuredcode"));
            values.put("lot", costObject.getString("lot"));
            Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)false).getId();
            if (!keyColIds.contains(keyColId)) continue;
            costObjectIds.add(costObject.getLong("id"));
        }
        return costObjectIds;
    }
}

