/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.algox.BizLogger;
import kd.macc.cad.algox.calc.checker.CheckerConstant;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.CalcCheckerHelper;
import kd.macc.cad.algox.calc.helper.CostTypeHelper;
import kd.macc.cad.algox.calc.helper.DownCalculateHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.CoByMatInfoClassification;
import kd.macc.cad.algox.calc.pojo.CoByMaterialInfo;
import kd.macc.cad.algox.constants.MatCostInfoDataSourceEnum;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.DataSetUtils;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import net.sf.json.JSONObject;

public class NewStdCalculateHelper {
    private static String ALGOKEY = "kd.macc.cad.algox.calc.helper.StdCalculateHelper";
    private static final String ENTITY_BD_MATCOSTINFO = "cad_matcostinfo";
    private static final Log logger = LogFactory.getLog(NewStdCalculateHelper.class);

    public static void clearCalcResult(StandCostCalcParam standCostCalcParam) {
        QFilter costtypeFilter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter srcFilter = new QFilter("datasource", "=", (Object)"stdcostcalculate");
        QFilter recordFilter = null;
        if (standCostCalcParam.isSaveRecord().booleanValue()) {
            recordFilter = new QFilter("calcrecord.name", "=", (Object)standCostCalcParam.getRecordName());
        } else {
            recordFilter = new QFilter("calcrecord", "is null", null);
            recordFilter.or(new QFilter("calcrecord", "<=", (Object)0L));
        }
        if (standCostCalcParam.getScopetype() == 0) {
            DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{costtypeFilter, recordFilter});
            if (standCostCalcParam.isSaveRecord().booleanValue()) {
                recordFilter = new QFilter("name", "=", (Object)standCostCalcParam.getRecordName());
                DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{costtypeFilter, recordFilter});
            } else {
                DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{costtypeFilter, srcFilter});
            }
        } else {
            QFilter matFilter = new QFilter("keycol", "in", standCostCalcParam.getKeycols());
            if (standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
                matFilter = new QFilter("keycol", "in", standCostCalcParam.getDefaultConfigKeycols());
            }
            if (standCostCalcParam.isCalcCurLevel() || standCostCalcParam.isSaveRecord().booleanValue()) {
                DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{costtypeFilter, recordFilter, matFilter});
            } else {
                Set<String> isNotDownCalcMatIds = DownCalculateHelper.getIsNotDownCalcMatKeycols(standCostCalcParam.getCostTypeId(), standCostCalcParam.getBizLogger());
                HashSet<String> rootNodes = new HashSet<String>(10);
                DataSet resultColl = QueryServiceHelper.queryDataSet((String)"clearCalcResult#1", (String)"cad_calcsimulationresult", (String)"treeentry.subroot subroot", (QFilter[])new QFilter[]{matFilter}, null);
                resultColl = resultColl.distinct();
                while (resultColl.hasNext()) {
                    Row row = resultColl.next();
                    String subroot = row.getString("subroot");
                    if (CadEmptyUtils.isEmpty(subroot)) continue;
                    rootNodes.add(subroot);
                }
                if (CadEmptyUtils.isEmpty(rootNodes)) {
                    return;
                }
                QFilter rootFilter = new QFilter("treeentry.subroot", "in", rootNodes);
                DataSet calResults = QueryServiceHelper.queryDataSet((String)"clearCalcResult#2", (String)"cad_calcsimulationresult", (String)"keycol,treeentry.subroot subroot,treeentry.subtreepath subtreepath", (QFilter[])new QFilter[]{rootFilter, costtypeFilter}, null);
                if ((calResults = calResults.distinct()).isEmpty()) {
                    return;
                }
                HashSet isNotDownCalcMatRoots = Sets.newHashSetWithExpectedSize((int)16);
                DataSet copyCalResults = calResults.copy();
                while (copyCalResults.hasNext()) {
                    Row row = copyCalResults.next();
                    String keycol = row.getString("keycol");
                    String subroot = row.getString("subroot");
                    String subtreepath = row.getString("subtreepath");
                    if (!isNotDownCalcMatIds.contains(keycol) || subroot == null || !subroot.equals(subtreepath)) continue;
                    isNotDownCalcMatRoots.add(subroot);
                }
                HashSet<String> root = new HashSet<String>(10);
                block2: while (calResults.hasNext()) {
                    Row row = calResults.next();
                    String treepath = row.getString("subtreepath");
                    String[] strs = treepath.split("@");
                    for (int i = 0; i < strs.length; ++i) {
                        if (isNotDownCalcMatRoots.contains(strs[i])) {
                            root.add(strs[i]);
                            continue block2;
                        }
                        root.add(strs[i]);
                        if (root.size() <= 5000) continue;
                        NewStdCalculateHelper.deleteTreeEntry(root, standCostCalcParam.getCostTypeId());
                        root.clear();
                    }
                }
                if (!CadEmptyUtils.isEmpty(root)) {
                    NewStdCalculateHelper.deleteTreeEntry(root, standCostCalcParam.getCostTypeId());
                }
            }
            if (standCostCalcParam.isSaveRecord().booleanValue()) {
                recordFilter = new QFilter("name", "=", (Object)standCostCalcParam.getRecordName());
                DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{costtypeFilter, recordFilter, matFilter});
            } else {
                DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{costtypeFilter, matFilter, srcFilter});
            }
        }
    }

    private static void deleteTreeEntry(Set<String> roots, Long costType) {
        DBRoute dbRoute = new DBRoute("cal");
        String str = "";
        for (String root : roots) {
            if (CadEmptyUtils.isEmpty(root)) continue;
            if (CadEmptyUtils.isEmpty(str)) {
                str = "'" + root + "'";
                continue;
            }
            str = str + ",'" + root + "'";
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cad_calcsimulars", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)costType)});){
            String deleteSql = "delete from t_cad_calcsimtreeentry where fsubroot in (" + str + ") and fsubcosttypeid=" + costType;
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)dbRoute, (String)deleteSql);
            }
            DataSet effectDs = DB.queryDataSet((String)(ALGOKEY + ".getEffectIds"), (DBRoute)dbRoute, (String)("select fid from t_cad_calcsimulars t1 where not exists (select 1 from t_cad_calcsimtreeentry t2 where t1.fid=t2.fid) and fcalcrecordid <= 0 and fcosttypeid=" + costType));
            HashSet effIdSet = Sets.newHashSetWithExpectedSize((int)16);
            for (Row row : effectDs) {
                effIdSet.add(row.getLong("fid"));
            }
            if (effIdSet.size() > 0) {
                DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)effIdSet)});
            }
        }
    }

    public static void clearCalcResultForStruct(StandCostCalcParam standCostCalcParam) {
        Map<String, Set<Long>> matConfigCodeTrackNumMap = standCostCalcParam.getMatConfigCodeTrackNumMap();
        if (CadEmptyUtils.isEmpty(matConfigCodeTrackNumMap)) {
            return;
        }
        HashSet<Long> trackNumIds = new HashSet<Long>(200);
        HashSet<String> keycols = new HashSet<String>(200);
        for (Map.Entry<String, Set<Long>> entry : matConfigCodeTrackNumMap.entrySet()) {
            Set<Long> trackNums = entry.getValue();
            if (CadEmptyUtils.isEmpty(trackNums)) continue;
            trackNumIds.addAll(trackNums);
            keycols.add(entry.getKey());
        }
        if (CadEmptyUtils.isEmpty(trackNumIds)) {
            return;
        }
        QFilter kcFilter = new QFilter("keycol", "in", keycols);
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"material,matvers mversion,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{kcFilter});
        keycols.clear();
        HashMap<String, Object> values = new HashMap<String, Object>(7);
        for (Long trackNumId : trackNumIds) {
            for (DynamicObject entry : dyKeyCols) {
                values.clear();
                values.put("material", entry.getLong("material"));
                values.put("auxproperty", entry.getLong("assist"));
                values.put("project", entry.getLong("project"));
                values.put("tracknumber", trackNumId);
                values.put("configuredcode", entry.getLong("configuredcode"));
                values.put("lot", entry.getString("lot"));
                String keycol = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getKeycol();
                keycols.add(keycol);
            }
        }
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        filter.and(new QFilter("tracknumber", "in", trackNumIds));
        filter.and(new QFilter("keycol", "in", keycols));
        QFilter dateFilter = new QFilter("effectdate", "is null", null);
        dateFilter.and(new QFilter("expdate", "is null", null));
        DeleteServiceHelper.delete((String)"cad_trackstdcalcresult", (QFilter[])new QFilter[]{filter, dateFilter});
        QFilter deleteFilter = new QFilter("keycol", "in", keycols);
        DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, deleteFilter});
    }

    public static void afterCalc(CalcStandCostCalcParam standCostCalcParam) {
        if (standCostCalcParam == null) {
            return;
        }
        BizLogger bizLogger = standCostCalcParam.getBizLogger();
        if (standCostCalcParam.isTrackCalc().booleanValue()) {
            NewStdCalculateHelper.updateMatCostInfoByTrackNumCalcRs(standCostCalcParam);
        } else {
            NewStdCalculateHelper.updateMatCostInfoByCalcRs(standCostCalcParam);
        }
        if (bizLogger != null) {
            bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97\u540e\u7eed\u5904\u7406", (String)"NewStdCalculateHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\u6210\u529f\u3002", (String)"NewStdCalculateHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
    }

    public static void updateMainData(StandCostCalcParam standCostCalcParam) {
        if (!standCostCalcParam.isLastBatchCalculate()) {
            return;
        }
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getCostTypeId())) {
            return;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        DataSet calcResultDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.calc.helper.StdCalculateHelper.updateMainData", (String)"cad_calcsimulationresult", (String)"id,material.masterid materialid,auxproperty,matvers", (QFilter[])new QFilter[]{filter, new QFilter("task", "=", (Object)standCostCalcParam.getTaskId())}, (String)"calcdate desc");
        if (calcResultDataSet == null) {
            return;
        }
        HashMap<String, Long> matCalcResultIdsMap = new HashMap<String, Long>();
        HashSet<Long> materials = new HashSet<Long>(10);
        String split = "@";
        for (Row row : calcResultDataSet) {
            String key = row.getLong("materialid") + split + row.getLong("auxproperty") + split + row.getLong("matvers");
            if (!matCalcResultIdsMap.containsKey(key)) {
                matCalcResultIdsMap.put(key, row.getLong("id"));
            }
            materials.add(row.getLong("materialid"));
        }
        ArrayList calcResultMats = new ArrayList(matCalcResultIdsMap.keySet());
        Lists.partition(calcResultMats, (int)10000).forEach(list -> {
            DynamicObject[] calcResults;
            QFilter matFilter = new QFilter("material", "in", (Object)materials);
            for (DynamicObject calcResult : calcResults = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)"id,ismaindata", (QFilter[])new QFilter[]{matFilter, filter})) {
                calcResult.set("ismaindata", (Object)0);
            }
            SaveServiceHelper.update((DynamicObject[])calcResults);
        });
        ArrayList calcResultIds = new ArrayList(matCalcResultIdsMap.values());
        Lists.partition(calcResultIds, (int)10000).forEach(list -> {
            DynamicObject[] calcResultInfos;
            QFilter idFilter = new QFilter("id", "in", matCalcResultIdsMap.values());
            for (DynamicObject calcResultInfo : calcResultInfos = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)"id,ismaindata", (QFilter[])new QFilter[]{idFilter})) {
                calcResultInfo.set("ismaindata", (Object)1);
            }
            SaveServiceHelper.save((DynamicObject[])calcResultInfos);
        });
    }

    public static Set<String> deductCoByProductCost(CalcStandCostCalcParam standCostCalcParam, Set<String> calMatWithCopProByLessZero) {
        if (!standCostCalcParam.isLastBatchCalculate()) {
            return calMatWithCopProByLessZero;
        }
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getCostTypeId())) {
            return calMatWithCopProByLessZero;
        }
        HashSet<String> keycols = new HashSet<String>(standCostCalcParam.getMainAndCoByProductWithOutBomMap().keySet());
        keycols.addAll(standCostCalcParam.getMainAndCoByProductWithBomMap().keySet());
        keycols.addAll(standCostCalcParam.getMainAndCoByProductWithPurPriceMap().keySet());
        if (CadEmptyUtils.isEmpty(keycols)) {
            return calMatWithCopProByLessZero;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter taskFilter = new QFilter("task", "=", (Object)standCostCalcParam.getTaskId());
        QFilter matFilter = new QFilter("keycol", "in", keycols);
        QFilter ismaindata = new QFilter("ismaindata", "=", (Object)1);
        DynamicObjectCollection mainMaterialResults = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"id", (QFilter[])new QFilter[]{matFilter, filter, taskFilter, ismaindata});
        List resulIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)mainMaterialResults, (String)"id");
        int deductCoByProductCostBatch = CadBgParamUtils.getCadParamForInt((String)"deductCoByProductCostBatch", (int)1000);
        for (List ids : Lists.partition((List)resulIds, (int)deductCoByProductCostBatch)) {
            HashSet<String> subCalMatWithCopProByLessZero = new HashSet<String>(10);
            String selectPropertiesForMainMaterial = "id,calcdate,costtype,task,keycol,material.masterid,auxproperty,configuredcode,tracknumber,project,lot,rootnode,treepath,iscalccurlevel,priceplan,entryentity.resource,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.subkeycol,entryentity.subkeycolid,entryentity.qty,entryentity.stdprice,entryentity.price,entryentity.activity,entryentity.datatype,entryentity.calcbasis,calcrecord,entryentity.resourcetype,entryentity.pricerule,entryentity.priceid,entryentity.operation,entryentity.operationdesc,entryentity.workcenter,entryentity.processseq,entryentity.operationno,treeentry.subcosttype,treeentry.subroot,treeentry.subtreepath,treeentry.subcalcdate";
            Object[] mainMaterialCostInfoList = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)selectPropertiesForMainMaterial, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            if (CadEmptyUtils.isEmpty(mainMaterialCostInfoList)) continue;
            for (Object mainMaterialCost : mainMaterialCostInfoList) {
                DynamicObjectCollection mainEntrys = mainMaterialCost.getDynamicObjectCollection("entryentity");
                BigDecimal subTotal = BigDecimal.ZERO;
                for (DynamicObject mainEntry : mainEntrys) {
                    if (!mainEntry.getString("datatype").equals("1")) continue;
                    subTotal = subTotal.add(mainEntry.getBigDecimal("stdprice"));
                }
                if (subTotal.compareTo(BigDecimal.ZERO) >= 0) continue;
                subCalMatWithCopProByLessZero.add(mainMaterialCost.getString("keycol"));
                standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"NewStdCalculateHelper_2", (String)"macc-cad-algox", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u542b\u6709\u8054\u526f\u4ea7\u54c1\u7684\u4e3b\u4ea7\u54c1\u6807\u51c6\u6210\u672c\u5c0f\u4e8e0\uff0c\u7269\u6599%s\u5377\u7b97\u5931\u8d25\u3002", (String)"NewStdCalculateHelper_3", (String)"macc-cad-algox", (Object[])new Object[0]), mainMaterialCost.getString("material.number")));
            }
            ArrayList<DynamicObject> copMaterialCosts = new ArrayList<DynamicObject>(10);
            for (Object mainMaterialCost : mainMaterialCostInfoList) {
                Map<String, BigDecimal> mainAndCoByProductWithOutBomMap = standCostCalcParam.getMainAndCoByProductWithOutBomMap().get(mainMaterialCost.getString("keycol"));
                if (CadEmptyUtils.isEmpty(mainAndCoByProductWithOutBomMap)) continue;
                Map<String, Object[]> keycolMatMap = NewStdCalculateHelper.getKeycolMatMap(mainAndCoByProductWithOutBomMap.keySet());
                for (Map.Entry<String, BigDecimal> entry : mainAndCoByProductWithOutBomMap.entrySet()) {
                    String coByProductKeycol = entry.getKey();
                    Object[] coByProductInfo = keycolMatMap.get(coByProductKeycol);
                    if (CadEmptyUtils.isEmpty(coByProductInfo)) continue;
                    BigDecimal qty = entry.getValue();
                    DynamicObject coByProductCosts = NewStdCalculateHelper.createCoByProductCosts(coByProductInfo, qty, (DynamicObject)mainMaterialCost, standCostCalcParam.getPriceprecision());
                    copMaterialCosts.add(coByProductCosts);
                }
            }
            if (!CadEmptyUtils.isEmpty(copMaterialCosts)) {
                SaveServiceHelper.save((DynamicObject[])copMaterialCosts.toArray(new DynamicObject[0]));
            }
            String stdCalcCheckLevel = NewStdCalculateHelper.getStdCalcCheckLevel("sca".equals(standCostCalcParam.getAppNum()) ? CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME : CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME);
            if (standCostCalcParam.isExecutByProductsStdCostChecker() && !CadEmptyUtils.isEmpty(subCalMatWithCopProByLessZero) && "2".equals(stdCalcCheckLevel)) {
                QFilter copMatfilter = new QFilter("keycol", "in", subCalMatWithCopProByLessZero);
                DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{filter, taskFilter, copMatfilter});
                DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, copMatfilter});
            }
            calMatWithCopProByLessZero.addAll(subCalMatWithCopProByLessZero);
        }
        return calMatWithCopProByLessZero;
    }

    private static Map<String, Object[]> getKeycolMatMap(Set<String> keycols) {
        QFilter filter = new QFilter("keycol", "in", keycols);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"cad_keycol", (String)"id,keycol,material,auxproperty", (QFilter[])new QFilter[]{filter});
        HashMap<String, Object[]> keycolMatMap = new HashMap<String, Object[]>(16);
        for (DynamicObject dyo : dyos) {
            Object[] value = new Object[]{dyo.getLong("material"), dyo.getLong("auxproperty")};
            keycolMatMap.put(dyo.getString("keycol"), value);
        }
        return keycolMatMap;
    }

    private static DynamicObject createCoByProductCosts(Object[] coByProductInfo, BigDecimal qty, DynamicObject mainMaterialCost, int priceprecision) {
        DynamicObject copMaterialCost = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcsimulationresult");
        copMaterialCost.set("task", (Object)mainMaterialCost.getLong("task"));
        copMaterialCost.set("calcdate", (Object)mainMaterialCost.getDate("calcdate"));
        copMaterialCost.set("costtype", (Object)mainMaterialCost.getLong("costtype.id"));
        copMaterialCost.set("material", coByProductInfo[0]);
        copMaterialCost.set("auxproperty", coByProductInfo[1]);
        copMaterialCost.set("configuredcode", (Object)mainMaterialCost.getLong("configuredcode.id"));
        copMaterialCost.set("tracknumber", (Object)mainMaterialCost.getLong("tracknumber.id"));
        copMaterialCost.set("lot", (Object)mainMaterialCost.getString("lot"));
        copMaterialCost.set("project", (Object)mainMaterialCost.getLong("project.id"));
        copMaterialCost.set("rootnode", (Object)mainMaterialCost.getString("rootnode"));
        copMaterialCost.set("treepath", (Object)mainMaterialCost.getString("treepath"));
        copMaterialCost.set("iscalccurlevel", mainMaterialCost.get("iscalccurlevel"));
        copMaterialCost.set("ismaindata", (Object)1);
        copMaterialCost.set("isleaf", (Object)"0");
        copMaterialCost.set("calcrecord", (Object)mainMaterialCost.getLong("calcrecord.id"));
        Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)copMaterialCost, (boolean)true);
        copMaterialCost.set("keycol", (Object)calcKey.getKeycol());
        copMaterialCost.set("keycolid", (Object)calcKey.getId());
        copMaterialCost.set("priceplan", (Object)mainMaterialCost.getLong("priceplan.id"));
        DynamicObjectCollection mainEntrys = mainMaterialCost.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entrys = copMaterialCost.getDynamicObjectCollection("entryentity");
        BigDecimal subImteTotal = BigDecimal.ZERO;
        BigDecimal subSumTotal = BigDecimal.ZERO;
        int maxIndex = 0;
        BigDecimal maxStdPrice = BigDecimal.ZERO;
        for (DynamicObject mainEntry : mainEntrys) {
            DynamicObject entry = entrys.addNew();
            entry.set("resource", (Object)mainEntry.getLong("resource.id"));
            entry.set("element", (Object)mainEntry.getLong("element.id"));
            entry.set("subelement", (Object)mainEntry.getLong("subelement.id"));
            entry.set("submaterial", (Object)mainEntry.getLong("submaterial.id"));
            entry.set("submatvers", (Object)mainEntry.getLong("submatvers.id"));
            entry.set("subauxproperty", (Object)mainEntry.getLong("subauxproperty.id"));
            entry.set("datatype", (Object)mainEntry.getString("datatype"));
            entry.set("activity", (Object)mainEntry.getString("activity"));
            entry.set("calcbasis", (Object)mainEntry.getString("calcbasis"));
            entry.set("subkeycol", (Object)mainEntry.getString("subkeycol"));
            entry.set("subkeycolid", (Object)mainEntry.getLong("subkeycolid.id"));
            entry.set("resourcetype", (Object)mainEntry.getString("resourcetype"));
            entry.set("pricerule", (Object)mainEntry.getLong("pricerule.id"));
            entry.set("priceid", (Object)mainEntry.getLong("priceid"));
            entry.set("operation", (Object)mainEntry.getLong("operation.id"));
            entry.set("operationdesc", (Object)mainEntry.getString("operationdesc"));
            entry.set("workcenter", (Object)mainEntry.getLong("workcenter.id"));
            BigDecimal newQty = BigDecimal.ZERO;
            if (mainEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) < 0 || mainEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) > 0) {
                newQty = mainEntry.getBigDecimal("qty").multiply(BigDecimal.ONE.divide(qty, 10, 4));
                entry.set("qty", (Object)newQty.setScale(priceprecision, 4));
            }
            entry.set("price", (Object)mainEntry.getBigDecimal("price"));
            if (mainEntry.getBigDecimal("stdPrice").compareTo(BigDecimal.ZERO) < 0 || mainEntry.getBigDecimal("stdPrice").compareTo(BigDecimal.ZERO) > 0) {
                entry.set("stdPrice", (Object)entry.getBigDecimal("qty").multiply(entry.getBigDecimal("price")).setScale(priceprecision, 4));
            }
            if ("4".equals(entry.getString("datatype"))) {
                subSumTotal = subSumTotal.add(entry.getBigDecimal("stdPrice"));
            }
            if ("3".equals(entry.getString("datatype"))) {
                subImteTotal = subImteTotal.add(entry.getBigDecimal("stdPrice"));
            }
            if (maxStdPrice.compareTo(entry.getBigDecimal("stdPrice")) >= 0 || !"3".equals(entry.getString("datatype"))) continue;
            maxStdPrice = entry.getBigDecimal("stdPrice");
            maxIndex = entrys.size() - 1;
        }
        if (subImteTotal.compareTo(subSumTotal) != 0) {
            DynamicObject needAdjDiff = (DynamicObject)entrys.get(maxIndex);
            BigDecimal diffAmt = subSumTotal.subtract(subImteTotal);
            BigDecimal entryQty = needAdjDiff.getBigDecimal("qty");
            BigDecimal stdPrice = needAdjDiff.getBigDecimal("stdprice").add(diffAmt);
            if (stdPrice.compareTo(BigDecimal.ZERO) > 0 && entryQty.compareTo(BigDecimal.ZERO) != 0) {
                needAdjDiff.set("stdprice", (Object)stdPrice);
                needAdjDiff.set("price", (Object)stdPrice.divide(entryQty, priceprecision, 4));
            }
        }
        DynamicObjectCollection mainTreeEntrys = mainMaterialCost.getDynamicObjectCollection("treeentry");
        DynamicObjectCollection treeEntrys = copMaterialCost.getDynamicObjectCollection("treeentry");
        for (DynamicObject mainTreeEntry : mainTreeEntrys) {
            DynamicObject treeEntry = treeEntrys.addNew();
            treeEntry.set("subcosttype", (Object)mainTreeEntry.getLong("subcosttype.id"));
            treeEntry.set("subroot", (Object)mainTreeEntry.getString("subroot"));
            treeEntry.set("subtreepath", (Object)mainTreeEntry.getString("subtreepath"));
            treeEntry.set("subcalcdate", (Object)mainTreeEntry.getDate("subcalcdate"));
        }
        return copMaterialCost;
    }

    public static void dealByProductCost(CalcStandCostCalcParam standCostCalcParam) {
        if (!standCostCalcParam.isLastBatchCalculate()) {
            return;
        }
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithPurPriceMap = standCostCalcParam.getMainAndCoByProductWithPurPriceMap();
        if (CadEmptyUtils.isEmpty(mainAndCoByProductWithPurPriceMap)) {
            return;
        }
        HashSet<String> byProducts = new HashSet<String>(10);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithPurPriceMap.entrySet()) {
            Map<String, BigDecimal> value = entry.getValue();
            byProducts.addAll(value.keySet());
        }
        if (CadEmptyUtils.isEmpty(byProducts)) {
            return;
        }
        HashMap<String, Long> keycolPurIdMap = new HashMap<String, Long>(16);
        int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
        for (List pruPriceObjIds : Lists.partition(standCostCalcParam.getPruPriceObjIds(), (int)calcPurPriceBatchSize)) {
            QFilter idFilter = new QFilter("id", "in", (Object)pruPriceObjIds);
            DataSet purprices = QueryServiceHelper.queryDataSet((String)"", (String)"cad_purprices", (String)"id,keycol", (QFilter[])new QFilter[]{idFilter}, null);
            while (purprices.hasNext()) {
                Row row = purprices.next();
                String keycol = row.getString("keycol");
                if (CadEmptyUtils.isEmpty(keycol) || !byProducts.contains(keycol)) continue;
                keycolPurIdMap.put(keycol, row.getLong("id"));
            }
        }
        byProducts.clear();
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter taskFilter = new QFilter("task", "=", (Object)standCostCalcParam.getTaskId());
        QFilter ismaindata = new QFilter("ismaindata", "=", (Object)1);
        int dealByProductCostBatch = CadBgParamUtils.getCadParamForInt((String)"dealByProductCostBatch", (int)1000);
        for (List mainMatKeycols : Lists.partition(new ArrayList<String>(mainAndCoByProductWithPurPriceMap.keySet()), (int)dealByProductCostBatch)) {
            QFilter mainFilter = new QFilter("keycol", "in", (Object)mainMatKeycols);
            String selectPropertiesForMainMaterial = "id,calcdate,costtype,task,keycol,material,auxproperty,configuredcode,tracknumber,project,lot,rootnode,treepath,iscalccurlevel,calcrecord,treeentry.subcosttype,treeentry.subroot,treeentry.subtreepath,treeentry.subcalcdate";
            DynamicObject[] mainMaterialCostInfoList = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)selectPropertiesForMainMaterial, (QFilter[])new QFilter[]{filter, mainFilter, taskFilter, ismaindata});
            HashMap<String, DynamicObject> mainMatResultInfoMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dynamicObject : mainMaterialCostInfoList) {
                String keycol = dynamicObject.getString("keycol");
                mainMatResultInfoMap.put(keycol, dynamicObject);
            }
            HashSet<String> byProductSet = new HashSet<String>(10);
            for (String mainMatKeycol : mainMatKeycols) {
                Map<String, BigDecimal> byProductMap = mainAndCoByProductWithPurPriceMap.get(mainMatKeycol);
                if (byProductMap == null) continue;
                byProductSet.addAll(byProductMap.keySet());
            }
            HashSet<Long> pruPriceObjIds = new HashSet<Long>(10);
            for (String byProduct : byProductSet) {
                Long purId;
                if (!keycolPurIdMap.containsKey(byProduct) || CadEmptyUtils.isEmpty(purId = (Long)keycolPurIdMap.get(byProduct))) continue;
                pruPriceObjIds.add(purId);
            }
            QFilter idFilter = new QFilter("id", "in", pruPriceObjIds);
            Object[] purprices = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"id,keycol,material,auxpty,matversion,configuredcode,tracknumber,project,lot,entryentity.element,entryentity.subelement,entryentity.price", (QFilter[])new QFilter[]{idFilter});
            if (CadEmptyUtils.isEmpty(purprices)) continue;
            HashMap<String, Object> purPriceObjMap = new HashMap<String, Object>(16);
            for (Object purPrice : purprices) {
                String keycol = purPrice.getString("keycol");
                purPriceObjMap.put(keycol, purPrice);
            }
            ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(10);
            for (String mainMatKeycol : mainMatKeycols) {
                Map<String, BigDecimal> purPriceObj;
                DynamicObject mainMaterialCost = (DynamicObject)mainMatResultInfoMap.get(mainMatKeycol);
                if (mainMaterialCost == null || (purPriceObj = mainAndCoByProductWithPurPriceMap.remove(mainMatKeycol)) == null) continue;
                for (Map.Entry<String, BigDecimal> purpriceInfo : purPriceObj.entrySet()) {
                    String purkey = purpriceInfo.getKey();
                    DynamicObject purprice = (DynamicObject)purPriceObjMap.get(purkey);
                    if (purprice == null) continue;
                    long material = purprice.getLong("material.id");
                    long auxpty = purprice.getLong("auxpty.id");
                    DynamicObject copMaterialCost = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcsimulationresult");
                    copMaterialCost.set("task", (Object)standCostCalcParam.getTaskId());
                    copMaterialCost.set("calcdate", (Object)mainMaterialCost.getDate("calcdate"));
                    copMaterialCost.set("costtype", (Object)mainMaterialCost.getLong("costtype.id"));
                    copMaterialCost.set("material", (Object)material);
                    copMaterialCost.set("auxproperty", (Object)auxpty);
                    copMaterialCost.set("configuredcode", (Object)purprice.getLong("configuredcode.id"));
                    copMaterialCost.set("tracknumber", (Object)purprice.getLong("tracknumber.id"));
                    copMaterialCost.set("lot", (Object)purprice.getString("lot"));
                    copMaterialCost.set("project", (Object)purprice.getLong("project.id"));
                    copMaterialCost.set("rootnode", (Object)mainMaterialCost.getString("rootnode"));
                    copMaterialCost.set("treepath", (Object)mainMaterialCost.getString("treepath"));
                    copMaterialCost.set("iscalccurlevel", mainMaterialCost.get("iscalccurlevel"));
                    copMaterialCost.set("ismaindata", (Object)1);
                    copMaterialCost.set("isleaf", (Object)"0");
                    copMaterialCost.set("calcrecord", (Object)mainMaterialCost.getLong("calcrecord.id"));
                    Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)copMaterialCost, (boolean)true);
                    copMaterialCost.set("keycol", (Object)calcKey.getKeycol());
                    copMaterialCost.set("keycolid", (Object)calcKey.getId());
                    DynamicObjectCollection entryEntitys = purprice.getDynamicObjectCollection("entryentity");
                    DynamicObjectCollection entrys = copMaterialCost.getDynamicObjectCollection("entryentity");
                    BigDecimal sumPrice = BigDecimal.ZERO;
                    for (DynamicObject entryEntity : entryEntitys) {
                        DynamicObject entry = entrys.addNew();
                        entry.set("element", (Object)entryEntity.getLong("element.id"));
                        entry.set("subelement", (Object)entryEntity.getLong("subelement.id"));
                        entry.set("submaterial", (Object)material);
                        entry.set("submatvers", (Object)purprice.getLong("matversion.id"));
                        entry.set("subauxproperty", (Object)auxpty);
                        entry.set("datatype", (Object)"2");
                        entry.set("subkeycol", (Object)calcKey.getKeycol());
                        entry.set("subkeycolid", (Object)calcKey.getId());
                        entry.set("qty", (Object)BigDecimal.ONE);
                        entry.set("price", (Object)entryEntity.getBigDecimal("price"));
                        BigDecimal stdPrice = entryEntity.getBigDecimal("price").setScale(standCostCalcParam.getPriceprecision(), 4);
                        entry.set("stdPrice", (Object)stdPrice);
                        sumPrice = sumPrice.add(entry.getBigDecimal("stdPrice"));
                    }
                    DynamicObject sumentry = entrys.addNew();
                    sumentry.set("element", (Object)773126985240072192L);
                    sumentry.set("subelement", (Object)773175233367685120L);
                    sumentry.set("datatype", (Object)"1");
                    sumentry.set("qty", (Object)1L);
                    sumentry.set("price", (Object)sumPrice);
                    sumentry.set("stdPrice", (Object)sumPrice);
                    DynamicObjectCollection mainTreeEntrys = mainMaterialCost.getDynamicObjectCollection("treeentry");
                    DynamicObjectCollection treeEntrys = copMaterialCost.getDynamicObjectCollection("treeentry");
                    for (DynamicObject mainTreeEntry : mainTreeEntrys) {
                        DynamicObject treeEntry = treeEntrys.addNew();
                        treeEntry.set("subcosttype", (Object)mainTreeEntry.getLong("subcosttype.id"));
                        treeEntry.set("subroot", (Object)mainTreeEntry.getString("subroot"));
                        treeEntry.set("subtreepath", (Object)mainTreeEntry.getString("subtreepath"));
                        treeEntry.set("subcalcdate", (Object)mainTreeEntry.getDate("subcalcdate"));
                    }
                    results.add(copMaterialCost);
                }
            }
            if (CadEmptyUtils.isEmpty(results)) continue;
            SaveServiceHelper.save((DynamicObject[])results.toArray(new DynamicObject[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMatCostInfoByCalcRs(CalcStandCostCalcParam standCostCalcParam) {
        DataSet dealedDateSet;
        DataSet calcResultDateSet;
        block20: {
            DataSet purPriceDataSet;
            Map<String, String> ruteSetRelatParam;
            Map<String, String> bomSetRelatParam;
            DynamicObject costType;
            boolean iscalccurlevel;
            block21: {
                DataSet cpDateSet;
                QFilter tarcostTypeFilter;
                String costtypeAtrr;
                Long costTypeId;
                block19: {
                    GroupbyDataSet groupbyDataSet;
                    block18: {
                        block17: {
                            if (standCostCalcParam == null) {
                                return;
                            }
                            costTypeId = standCostCalcParam.getCostTypeId();
                            Date effectDate = standCostCalcParam.getCalcDate();
                            iscalccurlevel = standCostCalcParam.isCalcCurLevel();
                            costType = CostTypeHelper.getCostType(costTypeId, null);
                            costtypeAtrr = costType.getString("type");
                            if ("0".equals(costtypeAtrr) || costtypeAtrr == null) {
                                return;
                            }
                            calcResultDateSet = null;
                            groupbyDataSet = null;
                            dealedDateSet = null;
                            if (standCostCalcParam.isLastBatchCalculate()) {
                                NewStdCalculateHelper.updateCostInfoForSpecificMatCalc(standCostCalcParam, costTypeId, costType);
                            }
                            tarcostTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
                            QFilter datatype = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
                            datatype.and(new QFilter("ismaindata", "=", (Object)1));
                            QFilter isLeaf = new QFilter("isleaf", "=", (Object)"0");
                            QFilter taskFilter = new QFilter("task", "=", (Object)standCostCalcParam.getTaskId());
                            if (standCostCalcParam.isCalcCurLevel()) {
                                taskFilter.and("iscalccurlevel", "=", (Object)1);
                            }
                            if ((calcResultDateSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_calcsimulationresult", (String)"calcdate,costtype,costtype.currency,level,keycol,keycolid,ismaindata,material,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,processroute,treepath,isleaf,rootnode,entryentity.calcbasis,entryentity.resource,entryentity.element,entryentity.subelement,entryentity.qty,entryentity.price,entryentity.stdprice,entryentity.subkeycol,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.subproject,entryentity.subtracknumber,entryentity.subconfiguredcode,entryentity.sublot,entryentity.datatype", (QFilter[])new QFilter[]{tarcostTypeFilter, taskFilter, datatype, isLeaf}, null)) != null && !calcResultDateSet.isEmpty()) break block17;
                            DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                            return;
                        }
                        groupbyDataSet = calcResultDateSet.groupBy("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,entryentity.element,entryentity.subelement".split(","));
                        if (groupbyDataSet != null) break block18;
                        DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                        return;
                    }
                    groupbyDataSet.sum("case when entryentity.datatype in ('2','3') then entryentity.stdprice else 0 end", "stdprice");
                    groupbyDataSet.sum("case when entryentity.datatype in ('2','3') then entryentity.qty else 0 end", "qty");
                    groupbyDataSet.sum("case when entryentity.datatype in ('2','4') then entryentity.stdprice else 0 end", "stepamt");
                    dealedDateSet = groupbyDataSet.finish().select("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,entryentity.element,entryentity.subelement,stdprice,stepamt").orderBy("material,auxproperty,matvers".split(","));
                    cpDateSet = dealedDateSet.copy();
                    if (!dealedDateSet.isEmpty()) break block19;
                    DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                    return;
                }
                try {
                    ArrayList<String> keycolForDelete = new ArrayList<String>(10);
                    while (cpDateSet.hasNext()) {
                        Row row = cpDateSet.next();
                        String keycol = row.getString("keycol");
                        if (!StringUtils.isNotEmpty((String)keycol)) continue;
                        keycolForDelete.add(keycol);
                    }
                    QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
                    for (List keycols : Lists.partition(keycolForDelete, (int)10000)) {
                        QFilter deleteFilter = new QFilter("keycol", "in", (Object)keycols);
                        DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, deleteFilter});
                    }
                    if (standCostCalcParam.getScopetype() == 0) {
                        DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter});
                    }
                    bomSetRelatParam = NewStdCalculateHelper.getBomSetRelatPara(costTypeId);
                    ruteSetRelatParam = NewStdCalculateHelper.getRuteSetRelatPara(costTypeId);
                    NewStdCalculateHelper.saveMatCostInfo(dealedDateSet, bomSetRelatParam, ruteSetRelatParam, costType, false, new Date(), iscalccurlevel, false);
                    if (!standCostCalcParam.isLastBatchCalculate()) break block20;
                    if (standCostCalcParam.getScopetype() == 1) {
                        NewStdCalculateHelper.deletePurPriceMatCostInfo(standCostCalcParam, costTypeId, costtypeAtrr, tarcostTypeFilter, filter);
                    }
                    QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
                    if (standCostCalcParam.isCalcCurLevel()) {
                        statusFilter.and("keycol", "in", standCostCalcParam.getKeycols());
                    }
                    int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
                    purPriceDataSet = null;
                    for (List pruPriceObjIds : Lists.partition(standCostCalcParam.getPruPriceObjIds(), (int)calcPurPriceBatchSize)) {
                        QFilter idFilter = new QFilter("id", "in", (Object)pruPriceObjIds);
                        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_purprices", (String)"costtype,costtype.currency,material,keycol,keycolid,matversion matvers,auxpty auxproperty,project,tracknumber,configuredcode,lot,entryentity.element,entryentity.subelement,entryentity.price stdprice,entryentity.price as stepamt", (QFilter[])new QFilter[]{idFilter, statusFilter}, (String)"material,auxpty,matversion");
                        if (purPriceDataSet == null) {
                            purPriceDataSet = resultDataSet;
                            continue;
                        }
                        purPriceDataSet = purPriceDataSet.union(resultDataSet);
                    }
                    if (purPriceDataSet != null) break block21;
                }
                catch (Throwable throwable) {
                    DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                    throw throwable;
                }
                DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                return;
            }
            NewStdCalculateHelper.saveMatCostInfo(purPriceDataSet, bomSetRelatParam, ruteSetRelatParam, costType, true, new Date(), iscalccurlevel, false);
        }
        DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMatCostInfoByTrackNumCalcRs(CalcStandCostCalcParam standCostCalcParam) {
        DataSet dealedDateSet;
        DataSet calcResultDateSet;
        DynamicObject costType;
        boolean iscalccurlevel;
        Long costTypeId;
        block13: {
            GroupbyDataSet groupbyDataSet;
            block12: {
                block11: {
                    if (standCostCalcParam == null) {
                        return;
                    }
                    costTypeId = standCostCalcParam.getCostTypeId();
                    Date effectDate = standCostCalcParam.getCalcDate();
                    iscalccurlevel = standCostCalcParam.isCalcCurLevel();
                    costType = CostTypeHelper.getCostType(costTypeId, null);
                    String costtypeAtrr = costType.getString("type");
                    if ("0".equals(costtypeAtrr) || costtypeAtrr == null) {
                        return;
                    }
                    calcResultDateSet = null;
                    groupbyDataSet = null;
                    dealedDateSet = null;
                    QFilter tarcostTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
                    QFilter datatype = new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
                    QFilter levelFilter = new QFilter("entryentity.entrylevel", "=", (Object)0);
                    QFilter taskFilter = new QFilter("task", "=", (Object)standCostCalcParam.getTaskId());
                    logger.info("\u8ddf\u8e2a\u53f7\u5377\u7b97-\u7269\u6599\u6210\u672c\u4fe1\u606f\u5904\u7406\uff0c\u67e5\u8be2\u8ddf\u8e2a\u53f7\u7ed3\u679c\u8868\u3002");
                    calcResultDateSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_trackstdcalcresult", (String)"calcdate,costtype,costtype.currency,entryentity.entrykeycol keycol,entryentity.entrykeycolid keycolid,entryentity.entryismaindata ismaindata,entryentity.entrymaterial material,entryentity.entryauxproperty auxproperty,entryentity.entrymatvers matvers,entryentity.entryproject project,entryentity.entrytracknumber tracknumber,entryentity.entryconfiguredcode configuredcode,entryentity.entrylot lot,entryentity.entrybomid bom,entryentity.entryprocessrouteid processroute,entryentity.entrytreepath treepath,entryentity.entryisleaf isleaf,entryentity.entryrootnode rootnode,entryentity.subentryentity.calcbasis,entryentity.subentryentity.resource,entryentity.subentryentity.element entryentity.element,entryentity.subentryentity.subelement entryentity.subelement,entryentity.subentryentity.qty,entryentity.subentryentity.price,entryentity.subentryentity.stdprice,entryentity.subentryentity.subkeycol,entryentity.subentryentity.submaterial,entryentity.subentryentity.submatvers,entryentity.subentryentity.subauxproperty,entryentity.subentryentity.subproject,entryentity.subentryentity.subtracknumber,entryentity.subentryentity.subconfiguredcode,entryentity.subentryentity.sublot,entryentity.subentryentity.datatype", (QFilter[])new QFilter[]{tarcostTypeFilter, datatype, levelFilter, taskFilter}, null);
                    if (calcResultDateSet != null && !calcResultDateSet.isEmpty()) break block11;
                    DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                    return;
                }
                groupbyDataSet = calcResultDateSet.groupBy("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,processroute,entryentity.element,entryentity.subelement".split(","));
                if (groupbyDataSet != null) break block12;
                DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
                return;
            }
            groupbyDataSet.sum("case when entryentity.subentryentity.datatype in ('2','3') then entryentity.subentryentity.stdprice else 0 end", "stdprice");
            groupbyDataSet.sum("case when entryentity.subentryentity.datatype in ('2','3') then entryentity.subentryentity.qty else 0 end", "qty");
            groupbyDataSet.sum("case when entryentity.subentryentity.datatype in ('2','4') then entryentity.subentryentity.stdprice else 0 end", "stepamt");
            dealedDateSet = groupbyDataSet.finish().select("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,processroute,entryentity.element,entryentity.subelement,stdprice,stepamt").orderBy("material,auxproperty,matvers".split(","));
            if (dealedDateSet != null && !dealedDateSet.isEmpty()) break block13;
            DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
            return;
        }
        try {
            HashMap<String, String> bomSetRelatParam = new HashMap<String, String>(16);
            HashMap<String, String> ruteSetRelatParam = new HashMap<String, String>(16);
            ArrayList<String> keycolForDelete = new ArrayList<String>(10);
            for (Row row : dealedDateSet.copy()) {
                String keycol = row.getString("keycol");
                if (StringUtils.isNotEmpty((String)keycol)) {
                    keycolForDelete.add(keycol);
                }
                if (!bomSetRelatParam.containsKey(keycol)) {
                    String matVal = "1@1@1@0@" + row.getString("bom");
                    bomSetRelatParam.put(keycol, matVal);
                }
                if (ruteSetRelatParam.containsKey(keycol)) continue;
                ruteSetRelatParam.put(keycol, "1@" + row.getString("processroute"));
            }
            logger.info("\u8ddf\u8e2a\u53f7\u5377\u7b97-\u7269\u6599\u6210\u672c\u4fe1\u606f\u5904\u7406\uff0c\u6e05\u9664\u539f\u6709\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002");
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            for (List keycols : Lists.partition(keycolForDelete, (int)10000)) {
                QFilter deleteFilter = new QFilter("keycol", "in", (Object)keycols);
                DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, deleteFilter});
            }
            logger.info("\u8ddf\u8e2a\u53f7\u5377\u7b97-\u7269\u6599\u6210\u672c\u4fe1\u606f\u5904\u7406\uff0c\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002");
            NewStdCalculateHelper.saveMatCostInfo(dealedDateSet, bomSetRelatParam, ruteSetRelatParam, costType, false, new Date(), iscalccurlevel, false);
        }
        catch (Throwable throwable) {
            DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
            throw throwable;
        }
        DataSetUtils.colse(new DataSet[]{dealedDateSet, calcResultDateSet});
    }

    private static void updateCostInfoForSpecificMatCalc(CalcStandCostCalcParam standCostCalcParam, Long costTypeId, DynamicObject costType) {
        if (standCostCalcParam.getScopetype() == 1 || standCostCalcParam.getScopetype() == 2) {
            Set<String> isNotDownCalcMaterialIds = DownCalculateHelper.getIsNotDownCalcMatKeycols(standCostCalcParam.getCostTypeId(), standCostCalcParam.getBizLogger());
            List<String> matKeycols = standCostCalcParam.getKeycols();
            isNotDownCalcMaterialIds.retainAll(matKeycols);
            if (CadEmptyUtils.isEmpty(isNotDownCalcMaterialIds)) {
                return;
            }
            QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
            QFilter materialIdFilter = new QFilter("keycol", "in", isNotDownCalcMaterialIds);
            if (standCostCalcParam.isCalcCurLevel()) {
                materialIdFilter.and("keycol", "in", standCostCalcParam.getKeycols());
            }
            DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{costTypeFilter, materialIdFilter});
            Map<String, String> bomSetRelatParam = NewStdCalculateHelper.getBomSetRelatPara(costTypeId);
            Map<String, String> ruteSetRelatParam = NewStdCalculateHelper.getRuteSetRelatPara(costTypeId);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter matIdsFilter = new QFilter("keycol", "in", isNotDownCalcMaterialIds);
            if (standCostCalcParam.isCalcCurLevel()) {
                matIdsFilter.and("keycol", "in", standCostCalcParam.getKeycols());
            }
            String selectFields = "costtype,costtype.currency,keycol,keycolid,material,matversion matvers,auxpty auxproperty,project,tracknumber,configuredcode,lot,entryentity.element,entryentity.subelement,entryentity.price stdprice,0 as stepamt";
            boolean iscalccurlevel = standCostCalcParam.isCalcCurLevel();
            DataSet purPriceDataSet = null;
            int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
            for (List pruPriceObjIds : Lists.partition(standCostCalcParam.getPruPriceObjIds(), (int)calcPurPriceBatchSize)) {
                QFilter idFilter = new QFilter("id", "in", (Object)pruPriceObjIds);
                DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_purprices", (String)selectFields, (QFilter[])new QFilter[]{idFilter, statusFilter, matIdsFilter}, null);
                if (purPriceDataSet == null) {
                    purPriceDataSet = resultDataSet;
                    continue;
                }
                purPriceDataSet = purPriceDataSet.union(resultDataSet);
            }
            if (purPriceDataSet == null) {
                return;
            }
            NewStdCalculateHelper.saveMatCostInfo(purPriceDataSet, bomSetRelatParam, ruteSetRelatParam, costType, true, new Date(), iscalccurlevel, false);
        }
    }

    private static void deletePurPriceMatCostInfo(CalcStandCostCalcParam standCostCalcParam, Long costTypeId, String costtypeAtrr, QFilter tarcostTypeFilter, QFilter filter) {
        logger.info("\u6307\u5b9a\u7269\u6599\u5377\u7b97-\u5220\u9664\u5916\u8d2d\u7269\u6599\u7684\u6210\u672c\u4fe1\u606f-\u5f00\u59cb");
        boolean isUpdateBySimulated = "1".equals(costtypeAtrr);
        Set<Object> matIdBitSet = new HashSet(2000);
        if (isUpdateBySimulated) {
            matIdBitSet = NewStdCalculateHelper.getMatIdForSimulatedResult(costTypeId);
        }
        logger.info("\u6307\u5b9a\u7269\u6599\u5377\u7b97-\u5220\u9664\u5916\u8d2d\u7269\u6599\u7684\u6210\u672c\u4fe1\u606f-\u6a21\u62df\u8868\u4e2d\u5b58\u5728\u7684\u7269\u6599\uff1a" + matIdBitSet.toString());
        QFilter matFilter = null;
        if (standCostCalcParam.isCalcCurLevel()) {
            matFilter = new QFilter("keycol", "in", standCostCalcParam.getKeycols());
        }
        DataSet purPriceDataSet = null;
        int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
        for (List pruPriceObjIds : Lists.partition(standCostCalcParam.getPruPriceObjIds(), (int)calcPurPriceBatchSize)) {
            QFilter idFilter = new QFilter("id", "in", (Object)pruPriceObjIds);
            DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_purprices", (String)"keycol", (QFilter[])new QFilter[]{idFilter, matFilter}, null);
            if (purPriceDataSet == null) {
                purPriceDataSet = resultDataSet;
                continue;
            }
            purPriceDataSet = purPriceDataSet.union(resultDataSet);
        }
        if (purPriceDataSet == null) {
            return;
        }
        ArrayList<String> purPriceMatIdsForDelete = new ArrayList<String>(10);
        for (Row row : purPriceDataSet) {
            String materialId = row.getString("keycol");
            boolean isExist = matIdBitSet.contains(row.getString("keycol"));
            if (isExist) continue;
            purPriceMatIdsForDelete.add(materialId);
        }
        logger.info("\u6307\u5b9a\u7269\u6599\u5377\u7b97-\u5220\u9664\u5916\u8d2d\u7269\u6599\u7684\u6210\u672c\u4fe1\u606f-\u9700\u8981\u5220\u9664\u7684\u5916\u8d2d\u7269\u6599\uff1a" + ((Object)purPriceMatIdsForDelete).toString());
        for (List materialKeycols : Lists.partition(purPriceMatIdsForDelete, (int)10000)) {
            QFilter materialIdFilter = new QFilter("keycol", "in", (Object)materialKeycols);
            DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, materialIdFilter});
        }
        logger.info("\u6307\u5b9a\u7269\u6599\u5377\u7b97-\u5220\u9664\u5916\u8d2d\u7269\u6599\u7684\u6210\u672c\u4fe1\u606f-\u7ed3\u675f");
    }

    public static Map<String, Long> saveMatCostInfo(DataSet matcostDataSet, Map<String, String> bomSetRelatParam, Map<String, String> ruteSetRelatParam, DynamicObject costType, boolean isOutSource, Date effectedDate, boolean isCalcCurLevel, boolean isUpdateExecute) {
        HashMap<String, Long> matCostInfo = new HashMap<String, Long>(10);
        String costTypeAttr = costType.getString("type");
        Long costTypeId = Long.valueOf(costType.getPkValue().toString());
        Long executorId = RequestContext.getOrCreate().getCurrUserId();
        boolean isUpdateOutSourceBySimulated = "1".equals(costTypeAttr) && isOutSource;
        Set<Object> matIdBitSet = new HashSet(2000);
        if (isUpdateOutSourceBySimulated) {
            matIdBitSet = NewStdCalculateHelper.getMatIdForSimulatedResult(costTypeId);
        }
        int priceprecision = CostTypeHelper.getPriceprecision(costTypeId);
        String lastkey = "";
        String currkey = "";
        ArrayList<DynamicObject> materialCostinfolist = new ArrayList<DynamicObject>();
        DynamicObject materialCostInfo = null;
        int index = 1;
        boolean useMatVersion = CostTypeHelper.isUseMatVersion(costTypeId);
        Map<Object, Object> existExpdates = new HashMap(16);
        HashSet<Long> calcKeyColIds = new HashSet<Long>(16);
        if ("0".equals(costTypeAttr)) {
            DataSet keyColIdDataSet = matcostDataSet.copy().select("keycolid");
            for (Row row : keyColIdDataSet) {
                calcKeyColIds.add(row.getLong("keycolid"));
            }
            existExpdates = NewStdCalculateHelper.getExistMaxExpdate(ENTITY_BD_MATCOSTINFO, costTypeId, calcKeyColIds);
        }
        Set<String> curCostTypeKeycolSet = NewStdCalculateHelper.getMatCostInfoByCostType(costTypeId, calcKeyColIds);
        for (Row row : matcostDataSet) {
            boolean isExist;
            if (isUpdateOutSourceBySimulated && (isExist = matIdBitSet.contains(row.getString("keycol")))) continue;
            String materialid = row.getString("material");
            String matvers = row.getString("matvers");
            String auxproperty = row.getString("auxproperty");
            currkey = row.getString("keycol");
            if ("".equals(lastkey) || !lastkey.equals(currkey)) {
                String comRuteSetParaInfo;
                String ruteSetRelatParamInfo;
                if (!"".equals(lastkey) && !lastkey.equals(currkey)) {
                    materialCostinfolist.add(materialCostInfo);
                }
                materialCostInfo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BD_MATCOSTINFO);
                NewStdCalculateHelper.setMaterialCostInfoDataSource(isOutSource, materialCostInfo, costTypeAttr, row, isUpdateExecute);
                index = 1;
                Long id = DBServiceHelper.genGlobalLongId();
                materialCostInfo.set("id", (Object)id);
                materialCostInfo.set("masterid", (Object)id);
                materialCostInfo.set("material", (Object)Long.parseLong(materialid));
                materialCostInfo.set("costtype", (Object)costTypeId);
                materialCostInfo.set("currency", (Object)row.getLong("costtype.currency"));
                if (useMatVersion) {
                    materialCostInfo.set("matversion", (Object)Long.parseLong(matvers));
                }
                materialCostInfo.set("auxpty", (Object)Long.parseLong(auxproperty));
                materialCostInfo.set("project", row.get("project"));
                materialCostInfo.set("tracknumber", row.get("tracknumber"));
                materialCostInfo.set("configuredcode", row.get("configuredcode"));
                materialCostInfo.set("lot", row.get("lot"));
                Long keycolId = 0L;
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)currkey)) {
                    Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)materialCostInfo, (boolean)true);
                    keycolId = calcKey.getId();
                    materialCostInfo.set("keycol", (Object)calcKey.getKeycol());
                    materialCostInfo.set("keycolid", (Object)keycolId);
                } else {
                    keycolId = row.getLong("keycolid");
                    materialCostInfo.set("keycol", (Object)currkey);
                    materialCostInfo.set("keycolid", (Object)keycolId);
                }
                materialCostInfo.set("status", (Object)"C");
                materialCostInfo.set("enable", (Object)"1");
                materialCostInfo.set("creator", (Object)executorId);
                materialCostInfo.set("auditor", (Object)executorId);
                materialCostInfo.set("source", (Object)"1");
                materialCostInfo.set("createtime", (Object)new Date());
                materialCostInfo.set("audittime", (Object)new Date());
                Date effectDate = null;
                effectDate = curCostTypeKeycolSet.contains(currkey) ? (existExpdates.get(keycolId) == null ? effectedDate : (Date)existExpdates.get(keycolId)) : TimeUtils.getDefaultEffectDate();
                materialCostInfo.set("effectdate", (Object)effectDate);
                materialCostInfo.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                if (isCalcCurLevel) {
                    materialCostInfo.set("iscalccurlevel", (Object)1);
                }
                String bomRelatParams = bomSetRelatParam.get(currkey);
                if (isOutSource == Boolean.FALSE && bomRelatParams != null && bomRelatParams.length() > 1) {
                    String[] bomRelatParamInfos = bomRelatParams.split("@");
                    materialCostInfo.set("consideryieldrate", (Object)bomRelatParamInfos[0]);
                    materialCostInfo.set("considersubmaterialloss", (Object)bomRelatParamInfos[1]);
                    materialCostInfo.set("considervalidperiod", (Object)bomRelatParamInfos[2]);
                    materialCostInfo.set("bomtype", (Object)(bomRelatParamInfos[3].equals("null") ? 0L : Long.parseLong(bomRelatParamInfos[3])));
                    materialCostInfo.set("bom", (Object)(bomRelatParamInfos[4].equals("null") ? 0L : Long.parseLong(bomRelatParamInfos[4])));
                }
                String string = ruteSetRelatParamInfo = (comRuteSetParaInfo = ruteSetRelatParam.get("0")) != null && comRuteSetParaInfo.length() > 1 ? comRuteSetParaInfo : ruteSetRelatParam.get(currkey);
                if (isOutSource == Boolean.FALSE && ruteSetRelatParamInfo != null && ruteSetRelatParamInfo.length() > 1) {
                    String[] routerInfos = ruteSetRelatParamInfo.split("@");
                    materialCostInfo.set("considerpreparetime", (Object)routerInfos[0]);
                    materialCostInfo.set("processroute", (Object)(routerInfos[1].equals("null") ? 0L : Long.parseLong(routerInfos[1])));
                }
                matCostInfo.put(costTypeId + "@" + currkey, id);
            }
            if (materialCostInfo == null) continue;
            DynamicObjectCollection matGroupColl = materialCostInfo.getDynamicObjectCollection("entryentity");
            DynamicObject advconap = matGroupColl.addNew();
            advconap.set("seq", (Object)index++);
            advconap.set("element", (Object)row.getLong("entryentity.element"));
            advconap.set("subelement", (Object)row.getLong("entryentity.subelement"));
            BigDecimal stdprice = row.getBigDecimal("stdprice");
            advconap.set("standardcost", (Object)(stdprice != null ? stdprice.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal stepamt = row.getBigDecimal("stepamt");
            advconap.set("stepamt", (Object)(stepamt != null ? stepamt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            lastkey = currkey;
        }
        if (materialCostInfo != null) {
            materialCostinfolist.add(materialCostInfo);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_BD_MATCOSTINFO);
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])materialCostinfolist.toArray(new DynamicObject[0]));
        }
        logger.info("\u8ddf\u8e2a\u53f7\u5377\u7b97-\u7269\u6599\u6210\u672c\u4fe1\u606f\u5904\u7406\uff0c\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f\u6210\u529f\u3002\u6761\u6570\uff1a{}", (Object)materialCostinfolist.size());
        return matCostInfo;
    }

    private static Set<String> getMatIdForSimulatedResult(Long costTypeId) {
        HashSet<String> matIdBitSet = new HashSet<String>(2000);
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter isLeaf = new QFilter("isleaf", "=", (Object)"0");
        DataSet rows = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.calc.helper.StdCalculateHelper.getMatIdForSimulatedResult", (String)"cad_calcsimulationresult", (String)"material,keycol", (QFilter[])new QFilter[]{costTypeFilter, isLeaf}, null);
        if (rows != null) {
            for (Row row : rows) {
                matIdBitSet.add(row.getString("keycol"));
            }
        }
        return matIdBitSet;
    }

    private static void setMaterialCostInfoDataSource(boolean isOutSource, DynamicObject materialCostInfo, String costTypeAttr, Row row, boolean isUpdateExecute) {
        if (isOutSource) {
            if (isUpdateExecute) {
                materialCostInfo.set("datasource", (Object)MatCostInfoDataSourceEnum.MANUAL_OUTSOURCE.getValue());
            } else {
                materialCostInfo.set("datasource", (Object)MatCostInfoDataSourceEnum.STDCOSTCALCULATE.getValue());
            }
        } else {
            Boolean isLeaf = row.getBoolean("isleaf");
            if (!isLeaf.booleanValue() && "1".equals(costTypeAttr)) {
                materialCostInfo.set("datasource", (Object)MatCostInfoDataSourceEnum.STDCOSTCALCULATE.getValue());
            }
            if (!isLeaf.booleanValue() && "0".equals(costTypeAttr)) {
                materialCostInfo.set("datasource", (Object)MatCostInfoDataSourceEnum.COSTUPDATE.getValue());
            }
        }
    }

    private static Set<String> getMatCostInfoByCostType(Long costTypeId, Set<Long> calcKeyColIds) {
        HashSet<String> matInfo = new HashSet<String>(16);
        String algoKey = "kd.macc.cad.algox.calc.helper.getMatCostInfoByCostType";
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter qfType = new QFilter("costtype.type", "=", (Object)"0");
        QFilter keyColIds = new QFilter("keycolid", "in", calcKeyColIds);
        String selectFields = "material,matversion,auxpty,keycol";
        DataSet matCostInfo = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_BD_MATCOSTINFO, (String)selectFields, (QFilter[])new QFilter[]{qfCostType, qfType, keyColIds}, null);
        for (Row row : matCostInfo) {
            matInfo.add(row.getString("keycol"));
        }
        return matInfo;
    }

    public static Set<Long> deductByProductCost(StandCostCalcParam standCostCalcParam) {
        DynamicObject[] mainMaterialCostInfoList;
        HashSet<Long> calCopProCostLqMat = new HashSet<Long>(10);
        if (!standCostCalcParam.isLastBatchCalculate()) {
            return calCopProCostLqMat;
        }
        if (CadEmptyUtils.isEmpty(standCostCalcParam.getCostTypeId())) {
            return calCopProCostLqMat;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter bomFilter = new QFilter("bom.iscoproduct", "=", (Object)"1");
        bomFilter.and("status", "=", (Object)"C");
        String selectFields = "material.masterid materialid,bom,bom.copentry.copentrymaterial.masterid copentrymaterialid, bom.copentry.copentryqty copentryqty";
        DynamicObjectCollection bomSettingInfoLists = QueryServiceHelper.query((String)"cad_bomsetting", (String)selectFields, (QFilter[])new QFilter[]{filter, bomFilter});
        HashSet boms = new HashSet(10);
        bomSettingInfoLists.forEach(p -> boms.add(p.getLong("bom")));
        DynamicObjectCollection bomSettingInfoList = QueryServiceHelper.query((String)"cad_costbom", (String)"material.masterid materialid,copentry.copentrymaterial.masterid copentrymaterialid, copentry.copentryqty copentryqty", (QFilter[])new QFilter[]{new QFilter("id", "in", boms)});
        HashSet<Long> coByMaterialIds = new HashSet<Long>();
        HashMap<Long, CoByMatInfoClassification> mainMatAndCoByMatClassificationMap = new HashMap<Long, CoByMatInfoClassification>();
        Set<Long> materialIdsWithBom = NewStdCalculateHelper.getMaterialIdsWithBom(filter, bomSettingInfoList);
        NewStdCalculateHelper.assembleClassificationMap(bomSettingInfoList, mainMatAndCoByMatClassificationMap, materialIdsWithBom);
        for (Map.Entry entrySet : mainMatAndCoByMatClassificationMap.entrySet()) {
            CoByMatInfoClassification coByMatInfoClassification = (CoByMatInfoClassification)entrySet.getValue();
            coByMaterialIds.addAll(coByMatInfoClassification.getTotalCoByMaterialIds());
        }
        NewStdCalculateHelper.setCostInfoForCoByMaterials(filter, coByMaterialIds, mainMatAndCoByMatClassificationMap);
        for (DynamicObject mainMaterialCost : mainMaterialCostInfoList = NewStdCalculateHelper.getMainMaterialsCostInfo(filter, mainMatAndCoByMatClassificationMap)) {
            CoByMatInfoClassification coByMatInfoClassification = (CoByMatInfoClassification)mainMatAndCoByMatClassificationMap.get(mainMaterialCost.getLong("material.masterid"));
            Set<Long> copProCostLqMat = NewStdCalculateHelper.deductCost(filter, mainMaterialCost, coByMatInfoClassification, standCostCalcParam.getBizLogger());
            calCopProCostLqMat.addAll(copProCostLqMat);
        }
        return calCopProCostLqMat;
    }

    private static Set<Long> deductCost(QFilter filter, DynamicObject mainMaterialCost, CoByMatInfoClassification coByMatInfoClassification, BizLogger bizLogger) {
        Object cqty;
        DynamicObjectCollection mianEntrys = mainMaterialCost.getDynamicObjectCollection("entryentity");
        ArrayList copMaterialCosts = new ArrayList(10);
        HashSet<DynamicObject> addMainEntrys = new HashSet<DynamicObject>();
        HashSet<DynamicObject> deductedCopEntrys = new HashSet<DynamicObject>();
        HashSet<Long> calMatWithCopProByLessZero = new HashSet<Long>(10);
        HashSet<Long> calCopProCostLqMat = new HashSet<Long>(10);
        BigDecimal mutipleQty = BigDecimal.ONE;
        BigDecimal totalCount = BigDecimal.ONE;
        if (!coByMatInfoClassification.getCoByMaterialWithoutBomIdAndQtyMap().isEmpty()) {
            for (Map.Entry<Long, BigDecimal> bomIdAndQty : coByMatInfoClassification.getCoByMaterialWithoutBomIdAndQtyMap().entrySet()) {
                cqty = bomIdAndQty.getValue();
                mutipleQty = mutipleQty.multiply((BigDecimal)cqty);
            }
            totalCount = mutipleQty;
            for (Map.Entry<Long, BigDecimal> bomIdAndQty : coByMatInfoClassification.getCoByMaterialWithoutBomIdAndQtyMap().entrySet()) {
                cqty = BigDecimal.ONE.divide(bomIdAndQty.getValue(), 10, 4);
                totalCount = totalCount.add(mutipleQty.multiply((BigDecimal)cqty));
            }
        }
        for (DynamicObject mainEntry : mianEntrys) {
            DynamicObject copProductCostInfo;
            cqty = coByMatInfoClassification.getCostInfoSetForCoByMaterialWithBom().iterator();
            while (cqty.hasNext() && (copProductCostInfo = (DynamicObject)cqty.next()) != null) {
                Long coByMaterialId = copProductCostInfo.getLong("material_id");
                BigDecimal coByMaterialQty = coByMatInfoClassification.getCoByMaterialWithBomIdAndQtyMap().get(coByMaterialId);
                DynamicObjectCollection copEntrys = copProductCostInfo.getDynamicObjectCollection("entryentity");
                for (DynamicObject copEntry : copEntrys) {
                    if (NewStdCalculateHelper.isEqualEntry(mainEntry, copEntry)) {
                        mainEntry.set("qty", (Object)mainEntry.getBigDecimal("qty").subtract(copEntry.getBigDecimal("qty").multiply(coByMaterialQty)));
                        mainEntry.set("stdprice", (Object)mainEntry.getBigDecimal("stdprice").subtract(copEntry.getBigDecimal("stdprice").multiply(coByMaterialQty)));
                        if (mainEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) < 0 || mainEntry.getBigDecimal("stdprice").compareTo(BigDecimal.ZERO) < 0) {
                            calMatWithCopProByLessZero.add(mainMaterialCost.getLong("material_id"));
                            calCopProCostLqMat.add(coByMaterialId);
                        }
                        deductedCopEntrys.add(copEntry);
                        addMainEntrys.remove(copEntry);
                        continue;
                    }
                    if (deductedCopEntrys.contains(copEntry)) continue;
                    addMainEntrys.add(copEntry);
                }
            }
            if (coByMatInfoClassification.getCoByMaterialWithoutBomIdAndQtyMap().isEmpty()) continue;
            BigDecimal qty = mainEntry.getBigDecimal("qty");
            BigDecimal stdPrice = mainEntry.getBigDecimal("stdprice");
            if (qty.compareTo(BigDecimal.ZERO) < 0 || qty.compareTo(BigDecimal.ZERO) > 0) {
                mainEntry.set("qty", (Object)qty.multiply(mutipleQty).divide(totalCount, 10, 4));
            }
            if (stdPrice.compareTo(BigDecimal.ZERO) >= 0 && stdPrice.compareTo(BigDecimal.ZERO) <= 0) continue;
            mainEntry.set("stdprice", (Object)stdPrice.multiply(mutipleQty).divide(totalCount, 10, 4));
        }
        if (!coByMatInfoClassification.getCoByMaterialWithoutBomIdAndQtyMap().isEmpty()) {
            Set<DynamicObject> copProductCosts = NewStdCalculateHelper.getCopProductCosts(mainMaterialCost, coByMatInfoClassification);
            copMaterialCosts.addAll(copProductCosts);
        }
        for (DynamicObject addMainEntry : addMainEntrys) {
            DynamicObject newMainEntry = mianEntrys.addNew();
            List<String> fields = Arrays.asList("element.id", "subelement.id", "submaterial.masterid", "submatvers.id", "subauxproperty.id", "datatype", "calcbasis");
            for (String field : fields) {
                newMainEntry.set(field.replaceAll(".id", "").replaceAll(".maste", ""), addMainEntry.get(field));
            }
            newMainEntry.set("qty", (Object)BigDecimal.ZERO.subtract(addMainEntry.getBigDecimal("qty")));
            newMainEntry.set("stdprice", (Object)BigDecimal.ZERO.subtract(addMainEntry.getBigDecimal("stdprice")));
            newMainEntry.set("price", (Object)addMainEntry.getBigDecimal("stdprice"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainMaterialCost});
        SaveServiceHelper.save((DynamicObject[])copMaterialCosts.toArray(new DynamicObject[0]));
        if (!CadEmptyUtils.isEmpty(calMatWithCopProByLessZero)) {
            bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"NewStdCalculateHelper_2", (String)"macc-cad-algox", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u542b\u6709\u8054\u526f\u4ea7\u54c1\u7684\u4e3b\u4ea7\u54c1\u6807\u51c6\u6210\u672c\u5c0f\u4e8e0\uff0c\u7269\u6599%s\u5377\u7b97\u5931\u8d25\u3002", (String)"NewStdCalculateHelper_3", (String)"macc-cad-algox", (Object[])new Object[0]), mainMaterialCost.getString("material.number")));
            QFilter matFilter = new QFilter("material", "in", calMatWithCopProByLessZero);
            DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{filter, matFilter});
            DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{filter, matFilter});
        }
        return calCopProCostLqMat;
    }

    public static void dealCheckResultInfo(String srcEntity, Long checkTaskId, Set<String> materialKcs, CalcStandCostCalcParam standCostCalcParam, String appNum) {
        QFilter taskFilter;
        QFilter checkItmeFilter;
        DynamicObject checkResult;
        if (CadEmptyUtils.isEmpty(materialKcs)) {
            return;
        }
        ArrayList<CalcCheckDetailResultInfo> infos = new ArrayList<CalcCheckDetailResultInfo>(10);
        HashSet<String> upperMats = new HashSet<String>(10);
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(materialKcs);
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        DataSet cpDataSet = bomMatDataSetByKeyCol.copy();
        while (cpDataSet.hasNext()) {
            Row row = cpDataSet.next();
            Long auxpty = row.getLong("auxproperty");
            if (CadEmptyUtils.isEmpty(auxpty)) continue;
            auxptyIds.add(auxpty);
        }
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        while (bomMatDataSetByKeyCol.hasNext()) {
            StringBuilder auxStr;
            com.alibaba.fastjson.JSONObject value;
            String auxValueStr;
            Row row = bomMatDataSetByKeyCol.next();
            String keycol = row.getString("keycol");
            Long material = row.getLong("material");
            Long auxpropId = row.getLong("auxproperty");
            Long configuredCode = row.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(material)) continue;
            String error = "";
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            if (!CadEmptyUtils.isEmpty(auxpropId) && !CadEmptyUtils.isEmpty(configuredCode)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (com.alibaba.fastjson.JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\u201d\u5bf9\u5e94BOM\u7684\u8054\u526f\u4ea7\u54c1\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"NewStdCalculateHelper_10", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")), row.getString("configuredcodenum"));
            } else if (!CadEmptyUtils.isEmpty(auxpropId)) {
                auxValueStr = (String)auxptyMap.get(auxpropId);
                value = (com.alibaba.fastjson.JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                error = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\u201d\u5bf9\u5e94BOM\u7684\u8054\u526f\u4ea7\u54c1\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"NewStdCalculateHelper_11", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), auxStr.toString().substring(0, auxStr.toString().lastIndexOf(";")));
            } else {
                error = !CadEmptyUtils.isEmpty(configuredCode) ? String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%3$s\u201d\u5bf9\u5e94BOM\u7684\u8054\u526f\u4ea7\u54c1\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"NewStdCalculateHelper_12", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"), row.getString("configuredcodenum")) : String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u201c\u7f16\u7801\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u201d\u5bf9\u5e94BOM\u7684\u8054\u526f\u4ea7\u54c1\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"NewStdCalculateHelper_13", (String)"macc-cad-algox", (Object[])new Object[0]), row.getString("matnumber"), row.getString("matname"));
            }
            detailinfo.setCheckDetailResult(error);
            infos.add(detailinfo);
            upperMats.add(keycol);
        }
        if (standCostCalcParam.isCalcCurLevel() && !CadEmptyUtils.isEmpty(upperMats)) {
            BomRuleSettingStdCalcHelper.getMostHightLevelMaterialBySpeciMatNew(srcEntity, new HashSet<String>(upperMats), upperMats, standCostCalcParam.getBomIdSet(), 0);
            standCostCalcParam.getCheckSuccessProducts().removeAll(upperMats);
        }
        if ((checkResult = BusinessDataServiceHelper.loadSingle((String)"cad_calccheckresult", (String)"checkitem,calctaskrecord,checkresult,checkresultdesc,entryentity.seq,entryentity.errordesc,entryentity.suggest", (QFilter[])new QFilter[]{checkItmeFilter = new QFilter("checkitem", "in", (Object)new Long[]{CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME, CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME}), taskFilter = new QFilter("calctaskrecord", "=", (Object)checkTaskId)})) == null) {
            checkResult = BusinessDataServiceHelper.newDynamicObject((String)"cad_calccheckresult");
        }
        checkResult.set("checkitem", (Object)("sca".equals(appNum) ? CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME : CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME));
        checkResult.set("calctaskrecord", (Object)checkTaskId);
        DynamicObjectCollection checkRsDetails = checkResult.getDynamicObjectCollection("entryentity");
        int index = 0;
        for (CalcCheckDetailResultInfo info : infos) {
            DynamicObject detailInfo = checkRsDetails.addNew();
            detailInfo.set("seq", (Object)(index + 1));
            detailInfo.set("errordesc", (Object)info.getCheckDetailResult());
            detailInfo.set("suggest", (Object)ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e3b\u8054\u526f\u4ea7\u54c1\u5bf9\u5e94\u7684\u201cBOM\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"NewStdCalculateHelper_14", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        checkResult.set("checkresultdesc", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"NewStdCalculateHelper_6", (String)"macc-cad-algox", (Object[])new Object[0]));
        checkResult.set("checkresult", (Object)NewStdCalculateHelper.getStdCalcCheckLevel("sca".equals(appNum) ? CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME : CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    private static String getStdCalcCheckLevel(Long id) {
        QFilter filter = new QFilter("caltype", "=", (Object)"cad_stdcalcnew");
        filter.and(new QFilter("entryentity.checkitem", "=", (Object)id));
        DynamicObject checkTask = QueryServiceHelper.queryOne((String)"cad_checktask", (String)"entryentity.level level", (QFilter[])new QFilter[]{filter});
        if (checkTask == null) {
            return "";
        }
        return checkTask.getString("level");
    }

    private static Set<DynamicObject> getCopProductCosts(DynamicObject mainMaterialCost, CoByMatInfoClassification coByMatInfoClassification) {
        List<CoByMaterialInfo> coByMaterialInfoListWithoutBom = coByMatInfoClassification.getCoByMaterialInfoListWithoutBom();
        HashSet<DynamicObject> copMaterialCosts = new HashSet<DynamicObject>(10);
        for (CoByMaterialInfo coByMaterialInfo : coByMaterialInfoListWithoutBom) {
            DynamicObject copMaterialCost = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcsimulationresult");
            copMaterialCost.set("task", (Object)mainMaterialCost.getLong("task"));
            copMaterialCost.set("calcdate", (Object)mainMaterialCost.getDate("calcdate"));
            copMaterialCost.set("costtype", (Object)mainMaterialCost.getLong("costtype.id"));
            copMaterialCost.set("material", (Object)coByMaterialInfo.getId());
            copMaterialCost.set("rootnode", (Object)mainMaterialCost.getString("rootnode"));
            copMaterialCost.set("treepath", (Object)mainMaterialCost.getString("treepath"));
            copMaterialCost.set("iscalccurlevel", mainMaterialCost.get("iscalccurlevel"));
            copMaterialCost.set("ismaindata", (Object)1);
            copMaterialCost.set("isleaf", (Object)"0");
            DynamicObjectCollection mainEntrys = mainMaterialCost.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entrys = copMaterialCost.getDynamicObjectCollection("entryentity");
            for (DynamicObject mainEntry : mainEntrys) {
                DynamicObject entry = entrys.addNew();
                entry.set("resource", (Object)mainEntry.getLong("resource.id"));
                entry.set("element", (Object)mainEntry.getLong("element.id"));
                entry.set("subelement", (Object)mainEntry.getLong("subelement.id"));
                entry.set("datatype", (Object)mainEntry.getString("datatype"));
                entry.set("activity", (Object)mainEntry.getString("activity"));
                entry.set("calcbasis", (Object)mainEntry.getString("calcbasis"));
                if (mainEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) < 0 || mainEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) > 0) {
                    entry.set("qty", (Object)mainEntry.getBigDecimal("qty").multiply(BigDecimal.ONE.divide(coByMaterialInfo.getQty(), 10, 4)));
                }
                entry.set("price", (Object)mainEntry.getBigDecimal("price"));
                if (mainEntry.getBigDecimal("stdPrice").compareTo(BigDecimal.ZERO) >= 0 && mainEntry.getBigDecimal("stdPrice").compareTo(BigDecimal.ZERO) <= 0) continue;
                entry.set("stdPrice", (Object)mainEntry.getBigDecimal("stdPrice").multiply(BigDecimal.ONE.divide(coByMaterialInfo.getQty(), 10, 4)));
            }
            copMaterialCosts.add(copMaterialCost);
        }
        return copMaterialCosts;
    }

    private static boolean isEqualEntry(DynamicObject mainEntry, DynamicObject copEntry) {
        List<String> fields = Arrays.asList("element.id", "subelement.id", "submaterial.masterid", "submatvers.id", "subauxproperty.id", "datatype", "calcbasis");
        for (String field : fields) {
            String copEntryValue;
            String mainEntryValue = mainEntry.getString(field) == null ? "0" : mainEntry.getString(field);
            if (mainEntryValue.equals(copEntryValue = copEntry.getString(field) == null ? "0" : copEntry.getString(field))) continue;
            return false;
        }
        return true;
    }

    private static DynamicObject[] getMainMaterialsCostInfo(QFilter filter, Map<Long, CoByMatInfoClassification> mainMatAndCoByMatClassificationMap) {
        QFilter matFilter = new QFilter("material", "in", mainMatAndCoByMatClassificationMap.keySet());
        String selectPropertiesForMainMaterial = "id,calcdate,costtype,task,material.masterid materialId,rootnode,treepath,iscalccurlevel,entryentity.resource,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.qty,entryentity.stdprice,entryentity.price,entryentity.activity,entryentity.datatype,entryentity.calcbasis";
        return BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)selectPropertiesForMainMaterial, (QFilter[])new QFilter[]{matFilter, filter});
    }

    private static void setCostInfoForCoByMaterials(QFilter filter, Set<Long> coByMaterialIds, Map<Long, CoByMatInfoClassification> mainMatAndCoByMatClassificationMap) {
        QFilter coByMaterialIdsFilter = new QFilter("material", "in", coByMaterialIds);
        coByMaterialIdsFilter.and(new QFilter("ismaindata", "=", (Object)1));
        String selectProperties = "id,material.masterid copmaterialid,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.qty,entryentity.stdprice,entryentity.price,entryentity.datatype,entryentity.calcbasis";
        DynamicObject[] coByMaterialCostInfoList = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)selectProperties, (QFilter[])new QFilter[]{coByMaterialIdsFilter, filter});
        for (Map.Entry<Long, CoByMatInfoClassification> entrySet : mainMatAndCoByMatClassificationMap.entrySet()) {
            CoByMatInfoClassification coByMatInfoClassification = entrySet.getValue();
            for (CoByMaterialInfo coByMaterialInfo : coByMatInfoClassification.getCoByMaterialInfoListWithBom()) {
                for (DynamicObject coByMaterialCostInfo : coByMaterialCostInfoList) {
                    if (!coByMaterialCostInfo.getString("material.masterid").equals(String.valueOf(coByMaterialInfo.getId()))) continue;
                    coByMaterialInfo.setCostInfo(coByMaterialCostInfo);
                }
            }
        }
    }

    private static void assembleClassificationMap(DynamicObjectCollection bomSettingInfoList, Map<Long, CoByMatInfoClassification> mainMatAndCoByMatClassificationMap, Set<Long> materialIdsWithBom) {
        for (DynamicObject bomSettingInfo : bomSettingInfoList) {
            Long mainMaterialId = bomSettingInfo.getLong("materialid");
            Long coByMaterialId = bomSettingInfo.getLong("copentrymaterialid");
            BigDecimal coByMaterialQty = bomSettingInfo.getBigDecimal("copentryqty");
            CoByMaterialInfo coByMaterialInfo = new CoByMaterialInfo();
            coByMaterialInfo.setId(coByMaterialId);
            coByMaterialInfo.setQty(coByMaterialQty);
            CoByMatInfoClassification coByMatInfoClassification = mainMatAndCoByMatClassificationMap.get(mainMaterialId);
            if (coByMatInfoClassification == null) {
                coByMatInfoClassification = new CoByMatInfoClassification();
                mainMatAndCoByMatClassificationMap.put(mainMaterialId, coByMatInfoClassification);
            }
            if (materialIdsWithBom.contains(coByMaterialId)) {
                coByMatInfoClassification.getCoByMaterialInfoListWithBom().add(coByMaterialInfo);
            } else {
                coByMatInfoClassification.getCoByMaterialInfoListWithoutBom().add(coByMaterialInfo);
            }
            coByMatInfoClassification.getTotalCoByMaterialIds().add(coByMaterialId);
            coByMatInfoClassification.getTotalCoByMaterialInfoList().add(coByMaterialInfo);
        }
    }

    private static Set<Long> getMaterialIdsWithBom(QFilter filter, DynamicObjectCollection bomSettingInfoList) {
        HashSet<Long> totalCoByMaterialBomSettings = new HashSet<Long>();
        for (DynamicObject bomSettingInfo : bomSettingInfoList) {
            Long coByMaterialId = bomSettingInfo.getLong("copentrymaterialid");
            totalCoByMaterialBomSettings.add(coByMaterialId);
        }
        QFilter matFilter = new QFilter("material", "in", totalCoByMaterialBomSettings);
        matFilter.and("status", "=", (Object)"C");
        matFilter.and("enable", "=", (Object)"1");
        matFilter.and("isdowncalc", "=", (Object)"1");
        DynamicObjectCollection bomSettingList = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{filter, matFilter});
        HashSet<Long> totalCoByMaterialBomList = new HashSet<Long>();
        for (DynamicObject bomSettingInfo : bomSettingList) {
            Long coByMaterialId = bomSettingInfo.getLong("bom");
            totalCoByMaterialBomList.add(coByMaterialId);
        }
        DynamicObjectCollection coByMaterialIdListWithBom = QueryServiceHelper.query((String)"cad_costbom", (String)"material.masterid material", (QFilter[])new QFilter[]{new QFilter("id", "in", totalCoByMaterialBomList)});
        return coByMaterialIdListWithBom.stream().map(item -> item.getLong("material")).collect(Collectors.toSet());
    }

    public static Map<String, String> getBomSetRelatPara(Long costTypeId) {
        HashMap<String, String> relatedParams = new HashMap<String, String>(10);
        if (costTypeId == null || costTypeId == 0L) {
            return relatedParams;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"keycol,material,bomversion,auxprop,consideryieldrate,considersubmaterialloss,considervalidperiod,bomtype,bom", (QFilter[])new QFilter[]{filter});
        if (!CadEmptyUtils.isEmpty(bomSettings)) {
            for (DynamicObject bomSetting : bomSettings) {
                String matkey = bomSetting.getString("keycol");
                if (relatedParams.containsKey(matkey)) continue;
                StringBuilder matVal = new StringBuilder();
                matVal.append(bomSetting.getString("consideryieldrate")).append("@");
                matVal.append(bomSetting.getString("considersubmaterialloss")).append("@");
                matVal.append(bomSetting.getString("considervalidperiod")).append("@");
                matVal.append(bomSetting.getString("bomtype")).append("@");
                matVal.append(bomSetting.getString("bom"));
                relatedParams.put(matkey, matVal.toString());
            }
        }
        return relatedParams;
    }

    public static Map<String, String> getRuteSetRelatPara(Long costTypeId) {
        HashMap<String, String> relatedParams = new HashMap<String, String>(10);
        if (costTypeId == null || costTypeId == 0L) {
            return relatedParams;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection ruteSettings = QueryServiceHelper.query((String)"cad_routersetting", (String)"materialentry.material.masterid matid,materialentry.auxpty auxpty,materialentry.keycol keycol,considerpreparetime,routertype,router", (QFilter[])new QFilter[]{filter});
        if (!CadEmptyUtils.isEmpty(ruteSettings)) {
            for (DynamicObject ruteSetting : ruteSettings) {
                if ("C".equals(ruteSetting.getString("routertype"))) {
                    relatedParams.put("0", ruteSetting.getString("considerpreparetime") + "@" + ruteSetting.getString("router.id"));
                    continue;
                }
                if (relatedParams.containsKey(ruteSetting.getString("matid"))) continue;
                relatedParams.put(ruteSetting.getString("keycol"), ruteSetting.getString("considerpreparetime") + "@" + ruteSetting.getString("router"));
            }
        }
        return relatedParams;
    }

    public static String dealCheckResultForAfterCalc(CalcStandCostCalcParam standCostCalcParam, Set<String> byProductCostUvaliSet) {
        String noPassCheckItem = null;
        if (standCostCalcParam.isExecutByProductsStdCostChecker() && !CadEmptyUtils.isEmpty(byProductCostUvaliSet)) {
            DynamicObject bomRuleSettingObj = StdCalculateHelper.getBomRuleSettingObj(standCostCalcParam.getBomRuleSetting());
            String srcEntity = "cad_costbom";
            if (bomRuleSettingObj != null) {
                srcEntity = bomRuleSettingObj.getString("srcbom");
            }
            NewStdCalculateHelper.dealCheckResultInfo(srcEntity, standCostCalcParam.getCheckTaskId(), byProductCostUvaliSet, standCostCalcParam, standCostCalcParam.getAppNum());
        }
        if (standCostCalcParam.isExecutByProductsStdCostChecker()) {
            noPassCheckItem = CalcCheckerHelper.getNoPassCheckItem(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), null);
            if (CadEmptyUtils.isEmpty(noPassCheckItem)) {
                return noPassCheckItem;
            }
            QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
            if (standCostCalcParam.isCalcCurLevel()) {
                filter.and(new QFilter("keycol", "not in", standCostCalcParam.getCheckSuccessProducts()));
            }
            QFilter taskFilter = new QFilter("task", "=", (Object)standCostCalcParam.getTaskId());
            DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{filter, taskFilter});
            DeleteServiceHelper.delete((String)"cad_trackstdcalcresult", (QFilter[])new QFilter[]{filter, taskFilter});
            if (standCostCalcParam.isSaveRecord().booleanValue()) {
                QFilter recordFilter = new QFilter("name", "=", (Object)standCostCalcParam.getRecordName());
                DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{filter, recordFilter});
            }
            DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{filter, taskFilter});
        }
        return noPassCheckItem;
    }

    public static void updateRecord(Long taskId, Long checkTaskId, Long successCount, Long failMatCount, int[] failCheckCount) {
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(taskId, checkTaskId));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,starttime,time,status,nextpagepara", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"successCount", (Object)successCount);
            jsonObject.put((Object)"failMatCount", (Object)failMatCount);
            jsonObject.put((Object)"failCheckCount", (Object)failCheckCount[0]);
            jsonObject.put((Object)"remaindCheckCount", (Object)failCheckCount[1]);
            for (Object record : records) {
                long time = TimeUtils.getSecond(record.getDate("starttime"), new Date());
                if (taskId.equals(record.getLong("id"))) {
                    record.set("time", (Object)(time == 0L ? 1L : time));
                    record.set("nextpagepara", (Object)jsonObject.toString());
                } else {
                    int custime = failCheckCount[2];
                    long sec = custime / 1000;
                    long submsec = custime % 1000;
                    if (sec == 0L || submsec != 0L) {
                        ++sec;
                    }
                    record.set("time", (Object)sec);
                }
                if (failCheckCount[0] > 0) {
                    record.set("status", (Object)"2");
                    continue;
                }
                if (failCheckCount[1] > 0) {
                    record.set("status", (Object)"4");
                    continue;
                }
                record.set("status", (Object)"3");
            }
            SaveServiceHelper.update((DynamicObject[])records);
        }
    }

    public static Map<Long, Date> getMatCostMaxEffectDate(Long tarCostTypeId, Set<Long> keyColIds) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(16);
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return result;
        }
        HashSet<String> colIds = new HashSet<String>(keyColIds.size());
        for (Long keyColId : keyColIds) {
            colIds.add(String.valueOf(keyColId));
        }
        for (List colIdList : Lists.partition(new ArrayList(colIds), (int)10000)) {
            String sql = "SELECT FKEYCOLID,MAX(FEFFECTDATE) FEFFECTDATE FROM T_BD_MATCOSTINFO WHERE FCOSTTYPEID = ? AND FKEYCOLID IN (" + String.join((CharSequence)",", colIdList) + ") GROUP BY FKEYCOLID;";
            Object[] params = new Object[]{new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId)};
            String algoKey = "NewStdCalculateHelper.getMatCostMaxEffectDate.T_BD_MATCOSTINFO";
            DBRoute route = DBRoute.of((String)"cal");
            DataSet datas = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sql, (Object[])params);
            if (datas == null || datas.isEmpty()) continue;
            for (Row row : datas) {
                result.put(row.getLong("FKEYCOLID"), row.getDate("FEFFECTDATE"));
            }
            DataSetUtils.colse(datas);
        }
        return result;
    }

    public static Map<Long, Date> getExistMaxExpdate(String entityName, Long tarCostTypeId, Set<Long> keyColIds) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(16);
        if (CadEmptyUtils.isEmpty(entityName) || CadEmptyUtils.isEmpty(keyColIds)) {
            return result;
        }
        String tableName = null;
        switch (entityName) {
            case "cad_matcostinfo": {
                tableName = "T_BD_MATCOSTINFO";
                break;
            }
            case "cad_calceffectiveresult": {
                tableName = "T_CAD_CALCEFFECTIVERESULT";
                break;
            }
            case "cad_trackstdcalcresult": {
                tableName = "T_CAD_TRACKCALCRESUT";
                break;
            }
            case "cad_bomsetting": {
                tableName = "T_CAD_BOMSETTING";
                break;
            }
            case "cad_calcpurprices": {
                tableName = "T_CAD_PURPRICES";
                break;
            }
            case "cad_outsourceprice": {
                tableName = "T_CAD_OUTSOURCEPRICE";
                break;
            }
        }
        if (CadEmptyUtils.isEmpty(tableName)) {
            return result;
        }
        String algoKey = "NewStdCalculateHelper.getExistMaxExpdate." + tableName;
        DBRoute route = DBRoute.of((String)"cal");
        HashSet<String> colIds = new HashSet<String>(keyColIds.size());
        for (Long keyColId : keyColIds) {
            colIds.add(String.valueOf(keyColId));
        }
        for (List colIdList : Lists.partition(new ArrayList(colIds), (int)10000)) {
            Object[] params;
            String sql = "SELECT FKEYCOLID,MAX(FEXPDATE) FEXPDATE  FROM " + tableName + " WHERE FCOSTTYPEID = ? AND FKEYCOLID IN (" + String.join((CharSequence)",", colIdList) + ") AND FEXPDATE<'2999-12-31 23:59:59'  GROUP BY FKEYCOLID;";
            DataSet datas = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sql, (Object[])(params = new Object[]{new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId)}));
            if (datas == null || datas.isEmpty()) continue;
            for (Row row : datas) {
                result.put(row.getLong("FKEYCOLID"), row.getDate("FEXPDATE"));
            }
            DataSetUtils.colse(datas);
        }
        return result;
    }

    public static Map<String, Date> getExistMaxExpdateByResource(String entityName, Long tarCostTypeId) {
        Object[] params;
        DBRoute route;
        HashMap<String, Date> result = new HashMap<String, Date>(16);
        if (CadEmptyUtils.isEmpty(entityName)) {
            return result;
        }
        if (!"cad_resourcerate".equals(entityName) && !"cad_resourceout".equals(entityName)) {
            return result;
        }
        String tableName = null;
        String sql = "";
        String fields = "";
        switch (entityName) {
            case "cad_resourceout": {
                tableName = "T_CAD_RESOURCEOUT";
                fields = "fmaterialid,fauxptyid,fresourceid";
                sql = "SELECT " + fields + ",MAX(fexpdate) FEXPDATE FROM " + tableName + " WHERE FCOSTTYPEID = ? GROUP BY " + fields;
                break;
            }
            case "cad_resourcerate": {
                tableName = "T_CAD_RESOURCERATE";
                fields = "fworkcenterid,fresourceid";
                sql = "SELECT " + fields + ",MAX(fexpdate) FEXPDATE FROM " + tableName + " WHERE FCOSTTYPEID = ? GROUP BY " + fields;
                break;
            }
        }
        if (CadEmptyUtils.isEmpty(tableName)) {
            return result;
        }
        String algoKey = "NewStdCalculateHelper.getExistMaxExpdateByResource." + tableName;
        DataSet datas = DB.queryDataSet((String)algoKey, (DBRoute)(route = DBRoute.of((String)"cal")), (String)sql, (Object[])(params = new Object[]{new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId)}));
        if (datas == null || datas.isEmpty()) {
            return result;
        }
        for (Row row : datas) {
            result.put(NewStdCalculateHelper.getKey(fields.split(","), row), row.getDate("FEXPDATE"));
        }
        DataSetUtils.colse(datas);
        return result;
    }

    private static String getKey(String[] fields, Row row) {
        StringBuilder sg = new StringBuilder();
        for (String field : fields) {
            sg.append(row.get(field) != null ? row.getString(field) : "0");
            sg.append("#");
        }
        return sg.toString();
    }
}

