/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.checker.CheckerConstant;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.calc.pojo.ConfigBomInfo;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;

public class StandCalcCheckHelper {
    private static final Log logger = LogFactory.getLog(StandCalcCheckHelper.class);

    public static void doCheck(StandCostCalcParam standCostCalcParam) {
        String calType = "cad_stdcalcnew";
        DynamicObjectCollection checkItems = CalcCheckHelper.getCheckItems((String)calType, new ArrayList<Long>(standCostCalcParam.getCheckItemIdSet()), (String)standCostCalcParam.getAppNum());
        for (DynamicObject checkItem : checkItems) {
            if (!CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME.equals(checkItem.getLong("checkitemid")) && !CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME.equals(checkItem.getLong("checkitemid"))) continue;
            standCostCalcParam.setExecutByProductsStdCostChecker(true);
            break;
        }
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckResultId(Long.valueOf(standCostCalcParam.getCheckTaskId()));
        calcCheckContext.setTaskId(Long.valueOf(standCostCalcParam.getTaskId()));
        calcCheckContext.setTaskType(calType);
        calcCheckContext.setGlobalId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        calcCheckContext.setCheckMode(standCostCalcParam.getCheckType() == 2 ? 1 : 2);
        calcCheckContext.setCostTypeId(standCostCalcParam.getCostTypeId());
        calcCheckContext.setAppNum(standCostCalcParam.getAppNum());
        calcCheckContext.getParams().put("calcDate", standCostCalcParam.getCalcDate());
        calcCheckContext.getParams().put("standCostCalcParam", standCostCalcParam);
        ArrayList checkActionList = new ArrayList(10);
        if (standCostCalcParam.isTrackCalc().booleanValue()) {
            List saleCheckActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, new ArrayList<Long>(standCostCalcParam.getCheckItemIdSet()), (String)(calType + "_sale"), (String)standCostCalcParam.getAppNum());
            checkActionList.addAll(saleCheckActionList);
        } else {
            List comCheckActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, new ArrayList<Long>(standCostCalcParam.getCheckItemIdSet()), (String)calType, (String)standCostCalcParam.getAppNum());
            checkActionList.addAll(comCheckActionList);
        }
        for (AbstractCalcCheckAction action : checkActionList) {
            action.execute();
        }
        Long failCount = 0L;
        Long remindCount = 0L;
        if (!CadEmptyUtils.isEmpty(checkActionList)) {
            failCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailCount();
            remindCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getRemindCount();
            standCostCalcParam.getCheckSuccessProducts().removeAll(((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailProductKeycols());
            standCostCalcParam.setCheckFailMaterials(((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailProductKeycols());
        }
        standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"StandCalcCheckHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u529f", (String)"StandCalcCheckHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]));
        Long latestTimeStamp = StandCalcCheckHelper.getLatestTimeStamp(standCostCalcParam.getTaskId());
        standCostCalcParam.getParams().put("checkLogTimeStamp", latestTimeStamp);
        if (failCount > 0L) {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 2);
        } else if (remindCount > 0L) {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 5);
        } else {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 3);
        }
    }

    private static Long getLatestTimeStamp(Long taskId) {
        QFilter filter = new QFilter("task", "=", (Object)taskId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_taskexecutelog", (String)"timestamp", (QFilter[])new QFilter[]{filter}, (String)"timestamp desc");
        if (CadEmptyUtils.isEmpty(dynamicObjects)) {
            return 0L;
        }
        return ((DynamicObject)dynamicObjects.get(0)).getLong("timestamp");
    }

    public static void doCheckForStruct(StandCostCalcParam standCostCalcParam) {
        String calType = "cad_stdcalcnew_sale";
        DynamicObjectCollection checkItems = CalcCheckHelper.getCheckItems((String)calType, new ArrayList<Long>(standCostCalcParam.getCheckItemIdSet()), (String)standCostCalcParam.getAppNum());
        for (DynamicObject checkItem : checkItems) {
            if (!CheckerConstant.ACA_BYPRODUCTSSTDCOSTINVALI_ITME.equals(checkItem.getLong("checkitemid")) && !CheckerConstant.SCA_BYPRODUCTSSTDCOSTINVALI_ITME.equals(checkItem.getLong("checkitemid"))) continue;
            standCostCalcParam.setExecutByProductsStdCostChecker(true);
            break;
        }
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckResultId(Long.valueOf(standCostCalcParam.getCheckTaskId()));
        calcCheckContext.setTaskId(Long.valueOf(standCostCalcParam.getTaskId()));
        calcCheckContext.setTaskType("cad_stdcalcnew");
        calcCheckContext.setGlobalId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        calcCheckContext.setCheckMode(standCostCalcParam.getCheckType() == 2 ? 1 : 2);
        calcCheckContext.setCostTypeId(standCostCalcParam.getCostTypeId());
        calcCheckContext.setAppNum(standCostCalcParam.getAppNum());
        calcCheckContext.getParams().put("calcDate", standCostCalcParam.getCalcDate());
        calcCheckContext.getParams().put("standCostCalcParam", standCostCalcParam);
        List checkActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, new ArrayList<Long>(standCostCalcParam.getCheckItemIdSet()), (String)calType, (String)standCostCalcParam.getAppNum());
        for (AbstractCalcCheckAction action : checkActionList) {
            action.execute();
        }
        Long failCount = 0L;
        Long remindCount = 0L;
        if (!CadEmptyUtils.isEmpty(checkActionList)) {
            failCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailCount();
            remindCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getRemindCount();
            standCostCalcParam.getCheckSuccessProducts().removeAll(((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailProductKeycols());
            standCostCalcParam.setCheckFailMaterials(((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailProductKeycols());
        }
        standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"StandCalcCheckHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u529f", (String)"StandCalcCheckHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]));
        Long latestTimeStamp = StandCalcCheckHelper.getLatestTimeStamp(standCostCalcParam.getTaskId());
        standCostCalcParam.getParams().put("checkLogTimeStamp", latestTimeStamp);
        if (failCount > 0L) {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 2);
        } else if (remindCount > 0L) {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 5);
        } else {
            TaskServiceHelper.updateProgress(standCostCalcParam.getCostTypeId(), standCostCalcParam.getCheckTaskId(), 100, 3);
        }
    }

    public static void getCalcTopLevelMat(String keycol, Map<String, Set<Long>> configBomKeycolPidsMap, Map<Long, ConfigBomInfo> idConfigBomInfoMap, Set<String> calcLevelMats, StringBuilder path, StringBuilder tempPath) {
        if (CadEmptyUtils.isEmpty(configBomKeycolPidsMap)) {
            return;
        }
        Set<Long> pids = configBomKeycolPidsMap.get(keycol);
        if (CadEmptyUtils.isEmpty(pids)) {
            calcLevelMats.add(keycol);
            path.append((CharSequence)tempPath).append('\uff1b');
            if (!CadEmptyUtils.isEmpty(tempPath.toString()) && tempPath.toString().split("->").length > 1) {
                tempPath.delete(tempPath.toString().lastIndexOf("->"), tempPath.toString().length() - 1);
            }
            return;
        }
        for (Long pid : pids) {
            ConfigBomInfo configBomInfo = idConfigBomInfoMap.get(pid);
            if (configBomInfo == null) continue;
            if (CadEmptyUtils.isEmpty(configBomInfo.getPid())) {
                calcLevelMats.add(configBomInfo.getKeycol());
            }
            if (keycol.equals(configBomInfo.getKeycol())) continue;
            tempPath.append("->").append(configBomInfo.getKeycol());
            StandCalcCheckHelper.getCalcTopLevelMat(configBomInfo.getKeycol(), configBomKeycolPidsMap, idConfigBomInfoMap, calcLevelMats, path, tempPath);
        }
    }

    public static void getCalcTopLevelMat(Long materialId, Map<Long, Set<Long>> configBomKeycolPidsMap, Map<Long, ConfigBomInfo> idConfigBomInfoMap, Set<String> calcLevelMats, StringBuilder path, StringBuilder tempPath) {
        if (CadEmptyUtils.isEmpty(configBomKeycolPidsMap)) {
            return;
        }
        Set<Long> pids = configBomKeycolPidsMap.get(materialId);
        if (CadEmptyUtils.isEmpty(pids)) {
            for (Map.Entry<Long, ConfigBomInfo> entry : idConfigBomInfoMap.entrySet()) {
                ConfigBomInfo value = entry.getValue();
                if (!materialId.equals(value.getMaterial())) continue;
                calcLevelMats.add(value.getKeycol());
                path.append((CharSequence)tempPath).append('\uff1b');
                if (CadEmptyUtils.isEmpty(tempPath.toString()) || tempPath.toString().split("->").length <= 1) continue;
                tempPath.delete(tempPath.toString().lastIndexOf("->"), tempPath.toString().length() - 1);
            }
            return;
        }
        for (Long pid : pids) {
            ConfigBomInfo configBomInfo = idConfigBomInfoMap.get(pid);
            if (configBomInfo == null) continue;
            if (CadEmptyUtils.isEmpty(configBomInfo.getPid())) {
                calcLevelMats.add(configBomInfo.getKeycol());
            }
            if (materialId.equals(configBomInfo.getMaterial())) continue;
            tempPath.append("->").append(configBomInfo.getKeycol());
            StandCalcCheckHelper.getCalcTopLevelMat(configBomInfo.getMaterial(), configBomKeycolPidsMap, idConfigBomInfoMap, calcLevelMats, path, tempPath);
        }
    }

    public static Set<String> getAppointMat(List<String> wizardMatScopInfos, List<String> matCalcProps) {
        HashSet<String> appointMats = new HashSet<String>(10);
        if (CadEmptyUtils.isEmpty(wizardMatScopInfos)) {
            return appointMats;
        }
        for (String wizardMatScopInfo : wizardMatScopInfos) {
            String[] split = wizardMatScopInfo.split("@");
            Long trackNumId = Long.parseLong(split[3]);
            if (CadEmptyUtils.isEmpty(matCalcProps)) {
                if (CadEmptyUtils.isEmpty(trackNumId)) {
                    appointMats.add(split[7]);
                    continue;
                }
                appointMats.add(split[8]);
                continue;
            }
            if (!matCalcProps.contains(split[6])) continue;
            if (CadEmptyUtils.isEmpty(trackNumId)) {
                appointMats.add(split[7]);
                continue;
            }
            appointMats.add(split[8]);
        }
        return appointMats;
    }
}

