/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.BizLogger;
import kd.macc.cad.algox.Data.CheckResult;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.EntityUtil;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import net.sf.json.JSONObject;

public class StdCalculateHelper {
    private static String ALGOKEY = "kd.macc.cad.algox.calc.helper.StdCalculateHelper";
    private static final String ENTITY_BD_MATCOSTINFO = "cad_matcostinfo";
    private static final Log logger = LogFactory.getLog(StdCalculateHelper.class);

    public static void createReport(StandCostCalcParam standCostCalcParam, String checkName, String calcName) {
        Long checkTaskId = standCostCalcParam.getCheckTaskId();
        if (checkTaskId == 0L) {
            checkTaskId = TaskServiceHelper.createTask(standCostCalcParam, checkName);
            standCostCalcParam.setCheckTaskId(checkTaskId);
        }
        if (standCostCalcParam.getCheckType() == 2) {
            return;
        }
        Long taskId = standCostCalcParam.getTaskId();
        if (taskId == 0L) {
            taskId = TaskServiceHelper.createTask(standCostCalcParam, calcName);
            standCostCalcParam.setTaskId(taskId);
        }
    }

    public static void updateReport(StandCostCalcParam standCostCalcParam) {
        DynamicObjectCollection results;
        int[] failAndWarnCheckCount = StdCalculateHelper.getFailAndWarnCheckCount(standCostCalcParam.getCheckTaskId());
        if (2 == standCostCalcParam.getCheckType()) {
            StdCalculateHelper.updateRecord(standCostCalcParam, (Long)1L, (Long)0L, failAndWarnCheckCount, standCostCalcParam.getCheckSuccessProducts());
            return;
        }
        QFilter costtype = new QFilter("costtype.id", "=", (Object)standCostCalcParam.getCostTypeId());
        costtype.and(new QFilter("task", "=", (Object)standCostCalcParam.getTaskId()));
        QFilter mainType = new QFilter("ismaindata", "=", (Object)1);
        long totalMatCount = 0L;
        long successCount = 0L;
        long failMatCount = 0L;
        ArrayList<String> hasResultKeycols = new ArrayList<String>(10);
        if (standCostCalcParam.isTrackCalc().booleanValue()) {
            results = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"id,keycol", (QFilter[])new QFilter[]{costtype, mainType});
            results.forEach(p -> hasResultKeycols.add(p.getString("keycol")));
            totalMatCount = standCostCalcParam.getMatConfigCodeTrackNumMap().size();
            successCount = results.size();
            failMatCount = totalMatCount - successCount < 0L ? 0L : totalMatCount - successCount;
        } else {
            results = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"id,keycol", (QFilter[])new QFilter[]{costtype, mainType});
            DynamicObjectCollection purResults = QueryServiceHelper.query((String)"cad_calcpurprices", (String)"id,keycol", (QFilter[])new QFilter[]{costtype});
            results.addAll((Collection)purResults);
            results.forEach(p -> hasResultKeycols.add(p.getString("keycol")));
            totalMatCount = StdCalculateHelper.getCalcMatCount(standCostCalcParam.getTaskId(), standCostCalcParam.getCostTypeId()) + (long)standCostCalcParam.getCalcPurMaterials().size();
            successCount = results.size();
            failMatCount = totalMatCount - successCount < 0L ? 0L : totalMatCount - successCount;
        }
        StdCalculateHelper.updateRecord(standCostCalcParam, (Long)successCount, (Long)failMatCount, failAndWarnCheckCount, hasResultKeycols);
        Object checkLogTimeStamp = standCostCalcParam.getParams().get("checkLogTimeStamp");
        StdCalculateHelper.updateCheckLog(standCostCalcParam.getTaskId(), checkLogTimeStamp == null ? 0L : Long.parseLong(String.valueOf(checkLogTimeStamp)), failAndWarnCheckCount);
    }

    public static void updateRecord(Long taskId, Long checkTaskId, Long successCount, Long failMatCount, int[] failCheckCount) {
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(taskId, checkTaskId));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,starttime,time,status,nextpagepara", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"successCount", (Object)successCount);
            jsonObject.put((Object)"failMatCount", (Object)failMatCount);
            jsonObject.put((Object)"failCheckCount", (Object)failCheckCount[0]);
            jsonObject.put((Object)"remaindCheckCount", (Object)failCheckCount[1]);
            for (Object record : records) {
                long time = TimeUtils.getSecond(record.getDate("starttime"), new Date());
                if (taskId.equals(record.getLong("id"))) {
                    record.set("time", (Object)(time == 0L ? 1L : time));
                    record.set("nextpagepara", (Object)jsonObject.toString());
                } else {
                    int custime = failCheckCount[2];
                    long sec = custime / 1000;
                    long submsec = custime % 1000;
                    if (sec == 0L || submsec != 0L) {
                        ++sec;
                    }
                    record.set("time", (Object)sec);
                }
                if (failCheckCount[0] > 0) {
                    record.set("status", (Object)"2");
                } else if (failCheckCount[1] > 0) {
                    record.set("status", (Object)"4");
                } else {
                    record.set("status", (Object)"3");
                }
                if (!taskId.equals(record.getLong("id")) || taskId.equals(checkTaskId) || successCount > 0L && failMatCount <= 0L) continue;
                record.set("status", (Object)"2");
            }
            SaveServiceHelper.update((DynamicObject[])records);
        }
    }

    public static void updateRecordStatus(Long taskId, String status) {
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "=", (Object)taskId);
            DynamicObject records = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"status", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            records.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)records);
        }
    }

    public static void updateRecord(StandCostCalcParam standCostCalcParam, Long successCount, Long failMatCount, int[] failCheckCount, List<String> hasResultKeycols) {
        StdCalculateHelper.updateRecord(standCostCalcParam.getTaskId(), (Long)standCostCalcParam.getCheckTaskId(), successCount, failMatCount, failCheckCount);
        if (standCostCalcParam.getScopetype() == 0) {
            return;
        }
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(standCostCalcParam.getTaskId(), standCostCalcParam.getCheckTaskId()));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,status,matentryentity.keycol,matentryentity.matstatus", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            for (Object record : records) {
                ArrayList<String> matStatus = new ArrayList<String>(2);
                DynamicObjectCollection matEntryEntity = record.getDynamicObjectCollection("matentryentity");
                if (CadEmptyUtils.isEmpty(matEntryEntity)) continue;
                for (DynamicObject row : matEntryEntity) {
                    String matStatu;
                    String keycol = row.getString("keycol");
                    if (hasResultKeycols.contains(keycol)) {
                        row.set("matstatus", (Object)"1");
                    } else {
                        row.set("matstatus", (Object)"2");
                    }
                    if (matStatus.contains(matStatu = row.getString("matstatus"))) continue;
                    matStatus.add(matStatu);
                }
                if (!standCostCalcParam.isCalcCurLevel() || standCostCalcParam.getCheckType() != 1 || standCostCalcParam.getTaskId() != record.getLong("id")) continue;
                if (matStatus.size() > 1) {
                    record.set("status", (Object)"5");
                    continue;
                }
                if ("1".equals(matStatus.get(0)) && failCheckCount[1] == 0) {
                    record.set("status", (Object)"3");
                    continue;
                }
                if ("1".equals(matStatus.get(0)) && failCheckCount[1] > 0) {
                    record.set("status", (Object)"4");
                    continue;
                }
                if (!"2".equals(matStatus.get(0))) continue;
                record.set("status", (Object)"2");
            }
            SaveServiceHelper.save((DynamicObject[])records);
        }
    }

    public static void updateRecordMatInfoBeforeCalc(Long taskId, Long checkTaskId, int scopeType, Set<String> matScopInfos) {
        if (scopeType == 0 || CadEmptyUtils.isEmpty(matScopInfos)) {
            return;
        }
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(taskId, checkTaskId));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,status,matentryentity.material,matentryentity.auxpty,matentryentity.configuredcode,matentryentity.tracknumber,matentryentity.lot,matentryentity.project,matentryentity.matcalcprop,matentryentity.matgroup,matentryentity.keycol", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            for (Object record : records) {
                DynamicObjectCollection matentryentity = record.getDynamicObjectCollection("matentryentity");
                if (!CadEmptyUtils.isEmpty(matentryentity)) continue;
                for (String matScopInfo : matScopInfos) {
                    String[] split = matScopInfo.split("@");
                    DynamicObject row = matentryentity.addNew();
                    row.set("material", (Object)Long.parseLong(split[0]));
                    row.set("auxpty", (Object)Long.parseLong(split[1]));
                    row.set("configuredcode", (Object)Long.parseLong(split[2]));
                    row.set("tracknumber", (Object)Long.parseLong(split[3]));
                    row.set("lot", (Object)("null".equals(split[4]) ? " " : split[4]));
                    row.set("project", (Object)Long.parseLong(split[5]));
                    row.set("matcalcprop", (Object)split[6]);
                    row.set("keycol", (Object)split[7]);
                }
            }
            SaveServiceHelper.save((DynamicObject[])records);
        }
    }

    public static void updateRecord(DynamicObject updateBill, Long taskId, Long checkTaskId, Long successCount, Long failMatCount, int[] failCheckCount) {
        StdCalculateHelper.updateRecord(checkTaskId, (Long)0L, successCount, failMatCount, failCheckCount);
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(taskId, checkTaskId));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,checktaskid,updatebillno,srccosttype,targetcosttype,attachtargetcosttype,isspecifymaterial,isupdatecurlevel,isquickupdate", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            for (Object record : records) {
                record.set("updatebillno", (Object)updateBill.getString("billno"));
                record.set("srccosttype", updateBill.get("srccosttype"));
                DynamicObjectCollection attachtargetcosttypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
                if (attachtargetcosttypes != null && !attachtargetcosttypes.isEmpty()) {
                    Object[] costtypeIds = new Object[attachtargetcosttypes.size()];
                    for (int index = 0; index < attachtargetcosttypes.size(); ++index) {
                        DynamicObject costtype = ((DynamicObject)attachtargetcosttypes.get(index)).getDynamicObject("fbasedataid");
                        costtypeIds[index] = costtype.getLong("masterid");
                    }
                    StdCalculateHelper.setMulControlVal((DynamicObject)record, "attachtargetcosttype", costtypeIds);
                }
                record.set("isspecifymaterial", updateBill.get("isspecifymaterial"));
                record.set("isupdatecurlevel", updateBill.get("iscalccurlevel"));
                record.set("isquickupdate", updateBill.get("isquickupdate"));
                record.set("checktaskid", (Object)checkTaskId);
            }
            SaveServiceHelper.save((DynamicObject[])records);
        }
    }

    public static void updateRecordInfo(DynamicObject updateBill, Set<Long> failKeycolIds, Long taskId, Long checkTaskId, Boolean isAllFail, Boolean isUpdateSuccess) {
        if (CadEmptyUtils.isEmpty(failKeycolIds)) {
            return;
        }
        try (TXHandle h = TX.notSupported();){
            QFilter filter = new QFilter("id", "in", Arrays.asList(taskId, checkTaskId));
            Object[] records = BusinessDataServiceHelper.load((String)"cad_calctaskrecord", (String)"id,checktaskid,updatebillno,srccosttype,targetcosttype,attachtargetcosttype,isspecifymaterial,isupdatecurlevel,isquickupdate,status,matentryentity.material,matentryentity.auxpty,matentryentity.configuredcode,matentryentity.tracknumber,matentryentity.lot,matentryentity.project,matentryentity.matcalcprop,matentryentity.matgroup,matentryentity.keycol,matentryentity.matstatus", (QFilter[])new QFilter[]{filter});
            if (CadEmptyUtils.isEmpty(records)) {
                return;
            }
            if (isUpdateSuccess.booleanValue()) {
                QFilter kcFilter = new QFilter("id", "in", failKeycolIds);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"updateReportForFailKeycolId", (String)"cad_keycol", (String)"id,keycol,material,matvers,auxproperty,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{kcFilter}, null);
                for (Object record : records) {
                    DynamicObjectCollection matentryentity = record.getDynamicObjectCollection("matentryentity");
                    if (!CadEmptyUtils.isEmpty(matentryentity)) continue;
                    DataSet copy = dataSet.copy();
                    while (copy.hasNext()) {
                        Row row = copy.next();
                        DynamicObject object = matentryentity.addNew();
                        object.set("material", (Object)row.getLong("material"));
                        object.set("auxpty", (Object)row.getLong("auxproperty"));
                        object.set("configuredcode", (Object)row.getLong("configuredcode"));
                        object.set("tracknumber", (Object)row.getLong("tracknumber"));
                        object.set("lot", (Object)row.getString("lot"));
                        object.set("project", (Object)row.getLong("project"));
                        object.set("keycol", (Object)row.getString("keycol"));
                        object.set("matstatus", (Object)"2");
                    }
                    if (taskId.longValue() != record.getLong("id") || isAllFail.booleanValue()) continue;
                    record.set("status", (Object)"5");
                }
                dataSet.close();
                SaveServiceHelper.save((DynamicObject[])records);
            } else {
                for (Object record : records) {
                    DynamicObjectCollection matentryentity = record.getDynamicObjectCollection("matentryentity");
                    if (!CadEmptyUtils.isEmpty(matentryentity)) {
                        return;
                    }
                    DynamicObjectCollection entryEntity = updateBill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryEntity) {
                        DynamicObject object = matentryentity.addNew();
                        object.set("material", (Object)entry.getLong("material.id"));
                        object.set("auxpty", (Object)entry.getLong("auxprop.id"));
                        object.set("configuredcode", (Object)entry.getLong("configuredcode.id"));
                        object.set("tracknumber", (Object)entry.getLong("tracknumber.id"));
                        object.set("lot", (Object)entry.getString("lot"));
                        object.set("project", (Object)entry.getLong("project.id"));
                        object.set("matstatus", (Object)"2");
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])records);
        }
    }

    private static void setMulControlVal(DynamicObject calcReport, String key, Object[] ids) {
        DynamicObject[] costcentersParam;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"cad_calctaskrecord");
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty(key);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)calcReport);
        for (DynamicObject cc : costcentersParam = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType())) {
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            basedataProp.setValue((Object)newRow, (Object)cc);
        }
    }

    public static void updateCheckLog(Long taskId, Long checkLogTimeStamp, int[] failCheckCount) {
        QFilter filter = new QFilter("task", "=", (Object)taskId);
        filter.and("timestamp", "=", (Object)checkLogTimeStamp);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_taskexecutelog", (String)"status,errlog,content", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return;
        }
        if (failCheckCount[0] > 0) {
            dynamicObject.set("status", (Object)"2");
            dynamicObject.set("errlog", (Object)ResManager.loadKDString((String)"\u8054\u67e5\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"StdCalculateHelper_15", (String)"macc-cad-algox", (Object[])new Object[0]));
            dynamicObject.set("content", (Object)String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5b58\u5728%s\u9879\u9519\u8bef\u3002", (String)"StdCalculateHelper_18", (String)"macc-cad-algox", (Object[])new Object[0]), failCheckCount[0]));
        } else if (failCheckCount[1] > 0) {
            dynamicObject.set("status", (Object)"5");
            dynamicObject.set("errlog", (Object)ResManager.loadKDString((String)"\u8054\u67e5\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"StdCalculateHelper_15", (String)"macc-cad-algox", (Object[])new Object[0]));
            dynamicObject.set("content", (Object)String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5b58\u5728%s\u9879\u8b66\u544a", (String)"StdCalculateHelper_17", (String)"macc-cad-algox", (Object[])new Object[0]), failCheckCount[1]));
        } else {
            dynamicObject.set("status", (Object)"3");
        }
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    public static int[] getFailAndWarnCheckCount(Long taskId) {
        int[] failAndWarnCheckCountAndTime = new int[]{0, 0, 0};
        QFilter taskFilter = new QFilter("calctaskrecord.id", "=", (Object)taskId);
        Object[] checkResults = BusinessDataServiceHelper.load((String)"cad_calccheckresult", (String)"id,checkresult,cnsmtime", (QFilter[])new QFilter[]{taskFilter});
        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Object[])checkResults)) {
            return failAndWarnCheckCountAndTime;
        }
        int failCount = 0;
        int warnCount = 0;
        int time = 0;
        for (Object checkResult : checkResults) {
            String cs = checkResult.getString("checkresult");
            if ("1".equals(cs)) {
                ++warnCount;
            } else if ("2".equals(cs)) {
                ++failCount;
            }
            time += checkResult.getInt("cnsmtime");
        }
        failAndWarnCheckCountAndTime[0] = failCount;
        failAndWarnCheckCountAndTime[1] = warnCount;
        failAndWarnCheckCountAndTime[2] = time;
        return failAndWarnCheckCountAndTime;
    }

    public static Long getCalcMatCount(Long taskId, Long costType) {
        QFilter taskIdFilter = new QFilter("calctask", "=", (Object)taskId);
        Object[] matExpandRecords = BusinessDataServiceHelper.load((String)"cad_calcmatexpandrecord", (String)"successmatexpandcount", (QFilter[])new QFilter[]{taskIdFilter});
        if (!CadEmptyUtils.isEmpty(matExpandRecords)) {
            Object matExpandRecord = matExpandRecords[0];
            return matExpandRecord == null ? 0L : matExpandRecord.getLong("successmatexpandcount");
        }
        return 0L;
    }

    public static List<Long> getCalcRulePlanIds(String entity, Long schemeId) {
        ArrayList<Long> calcRulePlanIds = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(entity)) {
            return calcRulePlanIds;
        }
        String selectFileds = "";
        String orderByFileds = "";
        switch (entity) {
            case "cad_purprices": {
                selectFileds = "purpricesentry.purlevel level,purpricesentry.purrule rule";
                orderByFileds = "purpricesentry.purlevel";
                break;
            }
            case "cad_outsourceprice": {
                selectFileds = "outpriceentry.outprilevel level,outpriceentry.outprirule rule";
                orderByFileds = "outpriceentry.outprilevel";
                break;
            }
            case "cad_resourcerate": {
                selectFileds = "selfresourceentry.sereslevel level,selfresourceentry.seresrule rule";
                orderByFileds = "selfresourceentry.sereslevel";
                break;
            }
            case "cad_resourceout": {
                selectFileds = "outresourceentry.outreslevel level,outresourceentry.outresrule rule";
                orderByFileds = "outresourceentry.outreslevel";
            }
        }
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"cad_calcruleplan", (String)selectFileds, (QFilter[])new QFilter[]{filter}, (String)(orderByFileds + " asc"));
        for (DynamicObject scheme : schemes) {
            long rule = scheme.getLong("rule");
            if (CadEmptyUtils.isEmpty(rule)) continue;
            calcRulePlanIds.add(rule);
        }
        return calcRulePlanIds;
    }

    public static DynamicObjectCollection getOutPriceObjs(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id,costtype,keycol,pricerule,element.id elementId,subelement.id subelementId,material.id,auxpty.id,matversion.id,price,bat,entryentity.extelement extelementId,entryentity.extsubelement extsubelementId,entryentity.amount amount", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getPurPriceObjs(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_purprices", (String)"id,costtype,keycol,pricerule,material.id,auxpty.id,matversion.id,entryentity.element.id elementId,entryentity.subelement.id subelementId,entryentity.price price", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getMatCostInfoObjs(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)ENTITY_BD_MATCOSTINFO, (String)"id,costtype,keycol,0L pricerule,material.id,auxpty.id,matversion.id,entryentity.element.id elementId,entryentity.subelement.id subelementId,entryentity.standardcost price", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getMatCostInfoObjsOnlyKeycol(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)ENTITY_BD_MATCOSTINFO, (String)"keycol", (QFilter[])qFilters);
    }

    public static List<Long> getOutPriceObjIds(Long costTypeId, Long hsCostTypeId, Set<String> customSuppliedMaterials, Long priceRuleScheme, Date calcDate) {
        ArrayList<Long> outPriceIds = new ArrayList<Long>(10);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter costTypeFilter = new QFilter("costtype.id", "=", (Object)costTypeId);
        qFilterList.add(costTypeFilter);
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        List<Long> calcRulePlanIds = StdCalculateHelper.getCalcRulePlanIds("cad_outsourceprice", priceRuleScheme);
        HashSet<String> existPriceKeycols = new HashSet<String>(16);
        QFilter calcRuleFilter = null;
        for (Long calcRulePlanId : calcRulePlanIds) {
            if (PriceRuleConstants.OUTPRI_STDCOST_ID.equals(calcRulePlanId)) {
                ArrayList<QFilter> stdQFilterList = new ArrayList<QFilter>(qFilterList);
                stdQFilterList.remove(costTypeFilter);
                if (stdQFilterList.contains(calcRuleFilter)) {
                    stdQFilterList.remove(calcRuleFilter);
                }
                stdQFilterList.add(new QFilter("costtype.id", "=", (Object)hsCostTypeId));
                DynamicObjectCollection outPriceObjs = StdCalculateHelper.getOutPriceObjs(stdQFilterList.toArray(new QFilter[0]));
                for (DynamicObject priceObj : outPriceObjs) {
                    String keycol = priceObj.getString("keycol");
                    if (existPriceKeycols.contains(keycol)) continue;
                    existPriceKeycols.add(keycol);
                    outPriceIds.add(priceObj.getLong("id"));
                }
                continue;
            }
            if (qFilterList.contains(calcRuleFilter)) {
                qFilterList.remove(calcRuleFilter);
            }
            calcRuleFilter = new QFilter("pricerule", "=", (Object)calcRulePlanId);
            qFilterList.add(calcRuleFilter);
            DynamicObjectCollection outPriceObjs = StdCalculateHelper.getOutPriceObjs(qFilterList.toArray(new QFilter[0]));
            for (DynamicObject priceObj : outPriceObjs) {
                String keycol = priceObj.getString("keycol");
                if (existPriceKeycols.contains(keycol)) continue;
                existPriceKeycols.add(keycol);
                outPriceIds.add(priceObj.getLong("id"));
            }
        }
        logger.info("\u59d4\u5916 existPriceKeycols:{}", existPriceKeycols);
        logger.info("\u59d4\u5916 outPriceIds:{}", outPriceIds);
        return outPriceIds;
    }

    public static List<Long> getPurPriceObjIds(Long costTypeId, Long hsCostTypeId, Set<String> customSuppliedMaterials, Long priceRuleScheme, Date calcDate, Map<String, Long> purMatCostInfoMap) {
        ArrayList<Long> purPriceIds = new ArrayList<Long>(10);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype.id", "=", (Object)costTypeId));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        List<Long> calcRulePlanIds = StdCalculateHelper.getCalcRulePlanIds("cad_purprices", priceRuleScheme);
        HashSet<String> existPriceKeycols = new HashSet<String>(16);
        QFilter calcRuleFilter = null;
        Map<Object, Object> purMatCostInfo = new HashMap(16);
        for (Long calcRulePlanId : calcRulePlanIds) {
            if (PriceRuleConstants.PUR_STDCOST_ID.equals(calcRulePlanId)) {
                purMatCostInfo = StdCalculateHelper.getPurMatCostInfo(hsCostTypeId, calcDate, existPriceKeycols);
                purMatCostInfoMap.putAll(purMatCostInfo);
                continue;
            }
            if (qFilterList.contains(calcRuleFilter)) {
                qFilterList.remove(calcRuleFilter);
            }
            calcRuleFilter = new QFilter("pricerule", "=", (Object)calcRulePlanId);
            qFilterList.add(calcRuleFilter);
            DynamicObjectCollection purPriceObjs = StdCalculateHelper.getPurPriceObjs(qFilterList.toArray(new QFilter[0]));
            Set<Object> tmpKeySet = purMatCostInfo.keySet();
            for (DynamicObject priceObj : purPriceObjs) {
                String keycol = priceObj.getString("keycol");
                if (tmpKeySet.contains(keycol) || existPriceKeycols.contains(keycol)) continue;
                existPriceKeycols.add(keycol);
                purPriceIds.add(priceObj.getLong("id"));
            }
        }
        logger.info("\u5916\u8d2d existPriceKeycols:{}", existPriceKeycols);
        logger.info("\u5916\u8d2d purPriceIds:{}", purPriceIds);
        return purPriceIds;
    }

    public static List<Long> getInResourcObjIds(Long costTypeId, Long priceRuleScheme, Date calcDate, Set<Long> resourceIds, Map<Long, Long> mnHsCostMapByMn) {
        ArrayList<Long> inResourcpurPriceIds = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(resourceIds)) {
            return inResourcpurPriceIds;
        }
        HashSet<String> existKey = new HashSet<String>(16);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter costTypeFilter = new QFilter("costtype.id", "=", (Object)costTypeId);
        qFilterList.add(costTypeFilter);
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("resource", "in", resourceIds));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        List<Long> calcRulePlanIds = StdCalculateHelper.getCalcRulePlanIds("cad_resourcerate", priceRuleScheme);
        QFilter calcRuleFilter = null;
        for (Long calcRulePlanId : calcRulePlanIds) {
            if (PriceRuleConstants.SELFRES_STDCOST_ID.equals(calcRulePlanId) && mnHsCostMapByMn != null) {
                ArrayList<QFilter> stdQFilterList = new ArrayList<QFilter>(qFilterList);
                stdQFilterList.remove(costTypeFilter);
                if (stdQFilterList.contains(calcRuleFilter)) {
                    stdQFilterList.remove(calcRuleFilter);
                }
                stdQFilterList.add(new QFilter("costtype.id", "=", (Object)mnHsCostMapByMn.get(costTypeId)));
                DynamicObjectCollection resourceObjs = StdCalculateHelper.getInResourceObjs(stdQFilterList.toArray(new QFilter[0]));
                for (DynamicObject resourcePriceObj : resourceObjs) {
                    Long workCenterId = resourcePriceObj.get("workcenter.id") == null ? 0L : resourcePriceObj.getLong("workcenter.id");
                    Long resourceId = resourcePriceObj.getLong("resource.id");
                    String key = "1@" + workCenterId + "@" + resourceId;
                    if (existKey.contains(key)) continue;
                    existKey.add(key);
                    inResourcpurPriceIds.add(resourcePriceObj.getLong("id"));
                }
                continue;
            }
            if (qFilterList.contains(calcRuleFilter)) {
                qFilterList.remove(calcRuleFilter);
            }
            calcRuleFilter = new QFilter("pricerule", "=", (Object)calcRulePlanId);
            qFilterList.add(calcRuleFilter);
            DynamicObjectCollection resourceObjs = StdCalculateHelper.getInResourceObjs(qFilterList.toArray(new QFilter[0]));
            for (DynamicObject resourcePriceObj : resourceObjs) {
                Long workCenterId = resourcePriceObj.get("workcenter.id") == null ? 0L : resourcePriceObj.getLong("workcenter.id");
                Long resourceId = resourcePriceObj.getLong("resource.id");
                String key = "1@" + workCenterId + "@" + resourceId;
                if (existKey.contains(key)) continue;
                existKey.add(key);
                inResourcpurPriceIds.add(resourcePriceObj.getLong("id"));
            }
        }
        return inResourcpurPriceIds;
    }

    public static List<Long> getOutResourcObjIds(Long costTypeId, Long priceRuleScheme, Date calcDate, Set<Object> routeIds, Map<Long, Long> mnHsCostMapByMn) {
        ArrayList<Long> outResourcpurPriceIds = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(routeIds)) {
            return outResourcpurPriceIds;
        }
        HashSet<String> existKey = new HashSet<String>(16);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter costTypeFilter = new QFilter("costtype.id", "=", (Object)costTypeId);
        qFilterList.add(costTypeFilter);
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("route", "in", routeIds));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        List<Long> calcRulePlanIds = StdCalculateHelper.getCalcRulePlanIds("cad_resourceout", priceRuleScheme);
        QFilter calcRuleFilter = null;
        for (Long calcRulePlanId : calcRulePlanIds) {
            if (PriceRuleConstants.OUTRES_STDCOST_ID.equals(calcRulePlanId) && mnHsCostMapByMn != null) {
                ArrayList<QFilter> stdQFilterList = new ArrayList<QFilter>(qFilterList);
                stdQFilterList.remove(costTypeFilter);
                if (stdQFilterList.contains(calcRuleFilter)) {
                    stdQFilterList.remove(calcRuleFilter);
                }
                stdQFilterList.add(new QFilter("costtype.id", "=", (Object)mnHsCostMapByMn.get(costTypeId)));
                DynamicObjectCollection resourceObjs = StdCalculateHelper.getOutResourceObjs(stdQFilterList.toArray(new QFilter[0]));
                for (DynamicObject resourcePriceObj : resourceObjs) {
                    Long manuorg = resourcePriceObj.get("manuorg.id") == null ? 0L : resourcePriceObj.getLong("manuorg.id");
                    Long route = resourcePriceObj.get("route.id") == null ? 0L : resourcePriceObj.getLong("route.id");
                    Long resourceId = resourcePriceObj.getLong("resource.id");
                    String key = "2@" + manuorg + "@" + route + "@" + resourcePriceObj.getString("processseq") + "@" + resourcePriceObj.getString("operationno") + "@" + resourceId;
                    if (existKey.contains(key)) continue;
                    existKey.add(key);
                    outResourcpurPriceIds.add(resourcePriceObj.getLong("id"));
                }
                continue;
            }
            if (qFilterList.contains(calcRuleFilter)) {
                qFilterList.remove(calcRuleFilter);
            }
            calcRuleFilter = new QFilter("pricerule", "=", (Object)calcRulePlanId);
            qFilterList.add(calcRuleFilter);
            DynamicObjectCollection resourceObjs = StdCalculateHelper.getOutResourceObjs(qFilterList.toArray(new QFilter[0]));
            for (DynamicObject resourcePriceObj : resourceObjs) {
                Long manuorg = resourcePriceObj.get("manuorg.id") == null ? 0L : resourcePriceObj.getLong("manuorg.id");
                Long route = resourcePriceObj.get("route.id") == null ? 0L : resourcePriceObj.getLong("route.id");
                Long resourceId = resourcePriceObj.getLong("resource.id");
                String key = "2@" + manuorg + "@" + route + "@" + resourcePriceObj.getString("processseq") + "@" + resourcePriceObj.getString("operationno") + "@" + resourceId;
                if (existKey.contains(key)) continue;
                existKey.add(key);
                outResourcpurPriceIds.add(resourcePriceObj.getLong("id"));
            }
        }
        return outResourcpurPriceIds;
    }

    public static DynamicObjectCollection getInResourceObjs(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_resourcerate", (String)"id,costtype,pricerule,workcenter.id,element.id,subelement.id,subelement.type,resource.id ,calcbasis,amount,qty,resourceunit.id", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getOutResourceObjs(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_resourceout", (String)"id,costtype,pricerule,material.id,auxpty.id,manuorg.id,route.id,processseq,operationno,element.id,subelement.id,subelement.type,resource.id ,calcbasis,amount,qty,resourceunit.id", (QFilter[])qFilters);
    }

    public static Map<String, List<DynamicObject>> getMatKeycolOutPriceMap(StandCostCalcParam standCostCalcParam) {
        QFilter filter = new QFilter("id", "in", standCostCalcParam.getOutPriceObjIds());
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getOutPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
        }
        return purPriceMap;
    }

    public static Map<String, List<DynamicObject>> getMatKeycolPurPriceMap(StandCostCalcParam standCostCalcParam) {
        QFilter filter = new QFilter("id", "in", standCostCalcParam.getPruPriceObjIds());
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getPurPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
        }
        return purPriceMap;
    }

    public static Map<String, Long> getPurMatCostInfo(Long hsCostTypeId, Date calcDate, Set<String> existPriceKeycols) {
        HashMap<String, Long> purMatCostInfoMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty(hsCostTypeId)) {
            return purMatCostInfoMap;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype.id", "=", (Object)hsCostTypeId));
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)ENTITY_BD_MATCOSTINFO, (String)"id,keycol", (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return purMatCostInfoMap;
        }
        for (DynamicObject matCostInfo : matCostInfos) {
            String keycol = matCostInfo.getString("keycol");
            if (existPriceKeycols.contains(keycol) || purMatCostInfoMap.containsKey(keycol)) continue;
            purMatCostInfoMap.put(keycol, matCostInfo.getLong("id"));
        }
        return purMatCostInfoMap;
    }

    public static List<Long> getMatCostIds(Long hsCostTypeId, List<String> keycols, Date calcDate) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype.id", "=", (Object)hsCostTypeId));
        qFilterList.add(new QFilter("keycol", "in", keycols));
        qFilterList.add(new QFilter("status", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)ENTITY_BD_MATCOSTINFO, (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)matCostInfos, (String)"id");
    }

    public static List<Long> getOutPriceIds(List<Long> costTypeIds, List<String> keycols, Date calcDate) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype.id", "in", costTypeIds));
        qFilterList.add(new QFilter("keycol", "in", keycols));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)objs, (String)"id");
    }

    public static List<Long> getPurPriceIds(List<Long> costTypeIds, List<String> keycols, Date calcDate) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype.id", "in", costTypeIds));
        qFilterList.add(new QFilter("keycol", "in", keycols));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"cad_purprices", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)objs, (String)"id");
    }

    public static Object getParamValue(String fieldKey) {
        QFilter filter = new QFilter("key", "=", (Object)fieldKey);
        DynamicObject param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return null;
        }
        return param.get("value");
    }

    public static DynamicObjectCollection getOutPriceObjsOnlyKeycol(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_outsourceprice", (String)"keycol", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getPurPriceObjsOnlyKeycol(QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"cad_purprices", (String)"keycol", (QFilter[])qFilters);
    }

    public static DynamicObject getBomRuleSettingObj(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cad_bomrulesetting", (String)"id,srcbom,consideryieldrate,considersubmaterialloss,considervalidperiod,isjumplevel,ispurprices,bomprioritisation,byproductpricerule,lossrateformula,filter,filter_tag,entryentity.srcfield,entryentity.sequence", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getRouteRuleSettingObj(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cad_routerulesetting", (String)"id,srcroute,considerpreparetime,routeprioritisation,productroute,mainroute,commonroute,filter,filter_tag,entryentity.srcfield,entryentity.sequence", (QFilter[])new QFilter[]{filter});
    }

    public static Set<Long> getProductOrgsByImitateCostType(Long costTypeId, Date calcDate) {
        long org;
        HashSet<Long> fromOrgs = new HashSet<Long>(10);
        QFilter qFilter = new QFilter("id", "in", (Object)costTypeId);
        qFilter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObject objs = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{qFilter});
        logger.info("\u5377\u7b97\uff1a\u6839\u636e\u6a21\u62df\u6210\u672c\u7c7b\u578b\u627e\u5230\u7684\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff1a{}", (Object)(objs == null ? 0L : objs.getLong("costtype")));
        if (objs == null) {
            return fromOrgs;
        }
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", (Object)objs.getLong("costtype")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)calcDate), new QFilter("invaliddate", ">", (Object)calcDate)};
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit", (QFilter[])filters);
        logger.info("\u5377\u7b97\uff1a\u67e5\u8be2\u5230\u7684\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u4e2a\u6570\uff1a{}", (Object)results.size());
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject result : results) {
            org = result.getLong("calorg");
            if (orgMap.containsKey(org)) continue;
            boolean enableFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
            orgMap.put(org, enableFactory);
        }
        for (DynamicObject result : results) {
            org = result.getLong("calorg");
            if (orgMap.containsKey(org) && ((Boolean)orgMap.get(org)).booleanValue()) {
                fromOrgs.add(result.getLong("storageorgunit"));
                continue;
            }
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(org);
            param.setToViewType("04");
            param.setFromViewType("10");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (CadEmptyUtils.isEmpty(bizRelationOrgIds)) continue;
            fromOrgs.addAll(bizRelationOrgIds);
        }
        orgMap.clear();
        return fromOrgs;
    }

    public static void writeToCalcPurPrices(StandCostCalcParam standCostCalcParam, DynamicObject[] purPrices) {
        Map<Object, Object> calcRecord = new HashMap(16);
        ArrayList<DynamicObject> purPricesList = new ArrayList<DynamicObject>(10);
        if (standCostCalcParam.isSaveRecord().booleanValue()) {
            calcRecord = StdCalculateHelper.getCalcRecord(Arrays.asList(purPrices), standCostCalcParam);
        }
        for (DynamicObject purPrice : purPrices) {
            DynamicObject calcPurPrices = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcpurprices");
            EntityUtil.copyPropertiesWithOutId(calcPurPrices, purPrice);
            calcPurPrices.set("calcdate", (Object)standCostCalcParam.getCalcDate());
            calcPurPrices.set("billstatus", (Object)"C");
            calcPurPrices.set("task", (Object)standCostCalcParam.getTaskId());
            calcPurPrices.set("priceid", (Object)purPrice.getLong("id"));
            calcPurPrices.set("creator", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("createtime", (Object)TimeServiceHelper.now());
            calcPurPrices.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("modifytime", (Object)TimeServiceHelper.now());
            calcPurPrices.set("auditor", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("auditdate", (Object)TimeServiceHelper.now());
            Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)calcPurPrices, (boolean)true);
            calcPurPrices.set("keycol", (Object)calcKey.getKeycol());
            calcPurPrices.set("keycolid", (Object)calcKey.getId());
            calcPurPrices.set("keycolid_id", (Object)calcKey.getId());
            if (calcRecord.containsKey(calcPurPrices.getString("keycol"))) {
                calcPurPrices.set("calcrecord", calcRecord.get(calcPurPrices.getString("keycol")));
            }
            purPricesList.add(calcPurPrices);
        }
        if (!CadEmptyUtils.isEmpty(purPricesList)) {
            SaveServiceHelper.save((DynamicObject[])purPricesList.toArray(new DynamicObject[0]));
        }
    }

    public static void beforeCalc(StandCostCalcParam standCostCalcParam, BizLogger bizLogger) {
        if (bizLogger == null) {
            bizLogger = new BizLogger();
        }
        bizLogger.setTaskId(standCostCalcParam.getTaskId());
        bizLogger.setCostTypeId(standCostCalcParam.getCostTypeId());
        standCostCalcParam.setBizLogger(bizLogger);
        standCostCalcParam.setExecutorId(Long.parseLong(RequestContext.getOrCreate().getUserId()));
        bizLogger.writeInfo(ResManager.loadKDString((String)"\u5377\u7b97", (String)"StdCalculateHelper_6", (String)"macc-cad-algox", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5377\u7b97\u9884\u5904\u7406", (String)"StdCalculateHelper_19", (String)"macc-cad-algox", (Object[])new Object[0]));
        if (standCostCalcParam.getCheckResult() != null) {
            return;
        }
        StandCostCalculateService service = new StandCostCalculateService();
        CheckResult checkResult = service.checkData(standCostCalcParam);
        standCostCalcParam.setCheckResult(checkResult);
    }

    public static void clearCalcPurPricesResult(Long costTypeId, List<String> purPricesMatKc) {
        if (CadEmptyUtils.isEmpty(purPricesMatKc)) {
            return;
        }
        QFilter delFilter = new QFilter("costtype", "=", (Object)costTypeId);
        delFilter.and(new QFilter("keycol", "in", purPricesMatKc));
        delFilter.and(new QFilter("calcrecord", "=", (Object)0L));
        DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{delFilter});
    }

    public static void writeToCalcPurPrices(Date calcDate, Long taskId, DynamicObject[] purPrices) {
        if (CadEmptyUtils.isEmpty(purPrices)) {
            return;
        }
        ArrayList<DynamicObject> purPricesList = new ArrayList<DynamicObject>(10);
        for (DynamicObject purPrice : purPrices) {
            DynamicObject calcPurPrices = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcpurprices");
            EntityUtil.copyPropertiesWithOutId(calcPurPrices, purPrice);
            calcPurPrices.set("calcdate", (Object)calcDate);
            calcPurPrices.set("task", (Object)taskId);
            calcPurPrices.set("billstatus", (Object)"C");
            calcPurPrices.set("priceid", (Object)purPrice.getLong("id"));
            calcPurPrices.set("creator", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("createtime", (Object)TimeServiceHelper.now());
            calcPurPrices.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("modifytime", (Object)TimeServiceHelper.now());
            calcPurPrices.set("auditor", (Object)RequestContext.get().getCurrUserId());
            calcPurPrices.set("auditdate", (Object)TimeServiceHelper.now());
            Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)calcPurPrices, (boolean)true);
            calcPurPrices.set("keycol", (Object)calcKey.getKeycol());
            calcPurPrices.set("keycolid", (Object)calcKey.getId());
            calcPurPrices.set("keycolid_id", (Object)calcKey.getId());
            purPricesList.add(calcPurPrices);
        }
        if (!CadEmptyUtils.isEmpty(purPricesList)) {
            SaveServiceHelper.save((DynamicObject[])purPricesList.toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, DynamicObject> getCalcRecord(List<DynamicObject> dyos, StandCostCalcParam standCostCalcParam) {
        Object[] oldCalcRecords;
        HashMap<String, DynamicObject> calcRecordDyoMap = new HashMap<String, DynamicObject>(16);
        if (CadEmptyUtils.isEmpty(dyos)) {
            return calcRecordDyoMap;
        }
        HashSet<String> keycols = new HashSet<String>(200);
        dyos.forEach(p -> keycols.add(p.getString("keycol")));
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter kcFilter = new QFilter("keycol", "in", keycols);
        DataSet calcRecordDataSet = QueryServiceHelper.queryDataSet((String)"getCalcRecord", (String)"cad_stdcalcrecord", (String)"keycol,name", (QFilter[])new QFilter[]{filter, kcFilter}, null).distinct();
        calcRecordDataSet = calcRecordDataSet.groupBy(new String[]{"keycol"}).countDistinct(new String[]{"name"}, "count").finish();
        calcRecordDataSet = calcRecordDataSet.filter("count >= " + standCostCalcParam.getRecordCount() + "");
        keycols.clear();
        while (calcRecordDataSet.hasNext()) {
            Row row = calcRecordDataSet.next();
            keycols.add(row.getString("keycol"));
        }
        HashMap<String, Object> keyColRecordMap = new HashMap<String, Object>(16);
        if (standCostCalcParam.isAutoReplaceRecord().booleanValue() && !CadEmptyUtils.isEmpty(keycols) && !CadEmptyUtils.isEmpty(oldCalcRecords = BusinessDataServiceHelper.load((String)"cad_stdcalcrecord", (String)"id,number,name,costtype,createtime,creator,material,keycol", (QFilter[])new QFilter[]{filter, kcFilter = new QFilter("keycol", "in", keycols)}, (String)"createtime asc"))) {
            for (Object oldCalcRecord : oldCalcRecords) {
                String key = oldCalcRecord.getString("keycol");
                keyColRecordMap.putIfAbsent(key, oldCalcRecord);
            }
        }
        ArrayList<Long> recordIds = new ArrayList<Long>(10);
        for (Map.Entry entry : keyColRecordMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            long id = value.getLong("id");
            recordIds.add(id);
        }
        for (DynamicObject dyo : dyos) {
            String key = dyo.getString("keycol");
            DynamicObject dynamicObject = (DynamicObject)calcRecordDyoMap.get(key);
            if (dynamicObject != null) continue;
            DynamicObject record = StdCalculateHelper.generateStdCalcRecord(dyo, standCostCalcParam.getCostTypeId(), standCostCalcParam.getRecordName(), standCostCalcParam.getCalcDate());
            calcRecordDyoMap.put(key, record);
        }
        if (!CadEmptyUtils.isEmpty(recordIds)) {
            QFilter idFilter = new QFilter("id", "in", recordIds);
            QFilter reckFilter = new QFilter("calcrecord", "in", recordIds);
            DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{reckFilter});
            DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{idFilter});
        }
        return calcRecordDyoMap;
    }

    public static DynamicObject generateStdCalcRecord(DynamicObject dyo, Long costType, String recordName, Date calcDate) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"cad_stdcalcrecord");
        record.set("id", (Object)DB.genLongId((String)"t_cad_stdcalcrecord"));
        record.set("number", record.get("id"));
        record.set("name", (Object)recordName);
        record.set("costtype", (Object)costType);
        record.set("calcdate", (Object)calcDate);
        record.set("creator", (Object)RequestContext.get().getCurrUserId());
        record.set("material", dyo.get("material"));
        if (dyo.containsProperty("auxproperty")) {
            record.set("auxpty", dyo.get("auxproperty"));
        } else if (dyo.containsProperty("auxpty")) {
            record.set("auxpty", dyo.get("auxpty"));
        }
        record.set("project", dyo.get("project"));
        record.set("tracknumber", dyo.get("tracknumber"));
        record.set("configuredcode", dyo.get("configuredcode"));
        record.set("lot", dyo.get("lot"));
        record.set("keycol", dyo.get("keycol"));
        return record;
    }

    public static void writeToMatCostInfo(Long costTypeId, List<String> purPricesMatKc, DynamicObject[] purPrices, Boolean isUpdate) {
        if (CadEmptyUtils.isEmpty(purPricesMatKc)) {
            return;
        }
        QFilter delFilter = new QFilter("costtype", "=", (Object)costTypeId);
        delFilter.and(new QFilter("keycol", "in", purPricesMatKc));
        DeleteServiceHelper.delete((String)ENTITY_BD_MATCOSTINFO, (QFilter[])new QFilter[]{delFilter});
        ArrayList<DynamicObject> matInfoList = new ArrayList<DynamicObject>(10);
        HashSet exists = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject purPrice : purPrices) {
            DynamicObject matInfo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BD_MATCOSTINFO);
            if (isUpdate.booleanValue()) {
                matInfo.set("datasource", (Object)"manual");
            } else {
                matInfo.set("datasource", (Object)"stdcostcalculate");
            }
            matInfo.set("material", (Object)purPrice.getLong("material.id"));
            matInfo.set("costtype", (Object)costTypeId);
            matInfo.set("currency", (Object)purPrice.getLong("currency.id"));
            matInfo.set("auxpty", (Object)purPrice.getLong("auxpty.id"));
            matInfo.set("project", (Object)purPrice.getLong("project.id"));
            matInfo.set("tracknumber", (Object)purPrice.getLong("tracknumber.id"));
            matInfo.set("configuredcode", (Object)purPrice.getLong("configuredcode.id"));
            matInfo.set("lot", (Object)purPrice.getString("lot"));
            Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)matInfo, (boolean)true);
            matInfo.set("keycol", (Object)calcKey.getKeycol());
            matInfo.set("keycolid", (Object)calcKey.getId());
            matInfo.set("status", (Object)"C");
            matInfo.set("enable", (Object)"1");
            matInfo.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
            matInfo.set("auditor", (Object)RequestContext.getOrCreate().getCurrUserId());
            matInfo.set("createtime", (Object)new Date());
            matInfo.set("audittime", (Object)new Date());
            matInfo.set("effectdate", (Object)TimeUtils.getDefaultEffectDate());
            matInfo.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            DynamicObjectCollection matGroupColl = matInfo.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity = purPrice.getDynamicObjectCollection("entryentity");
            int priceprecision = purPrice.getInt("currency.priceprecision");
            if (purPrice.getLong("currency.id") == 0L) {
                priceprecision = 4;
            }
            for (DynamicObject entry : entryentity) {
                DynamicObject advconap = matGroupColl.addNew();
                advconap.set("element", (Object)entry.getLong("element.id"));
                advconap.set("subelement", (Object)entry.getLong("subelement.id"));
                BigDecimal stdprice = entry.getBigDecimal("price");
                advconap.set("standardcost", (Object)(stdprice != null ? stdprice.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
                BigDecimal stepamt = entry.getBigDecimal("price");
                advconap.set("stepamt", (Object)(stepamt != null ? stepamt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            }
            String uniqueKey = costTypeId + "@" + calcKey.getKeycol();
            if (exists.contains(uniqueKey)) {
                throw new KDBizException("keycol more then one");
            }
            exists.add(uniqueKey);
            matInfoList.add(matInfo);
        }
        if (!CadEmptyUtils.isEmpty(matInfoList)) {
            SaveServiceHelper.save((DynamicObject[])matInfoList.toArray(new DynamicObject[0]));
        }
    }
}

