/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.calc.helper;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.algox.input.StandCostCalcParam;

public class TaskServiceHelper {
    public static void addProgress(Long costTypeId, Long taskid, int mdProgress) {
        try (TXHandle h = TX.notSupported();){
            DynamicObject taskInfo = TaskServiceHelper.isHaveTaskInfo(costTypeId, taskid);
            if (taskInfo == null) {
                return;
            }
            long totalProgress = taskInfo.getLong("progress") + (long)mdProgress;
            long time = TimeUtils.getSecond(taskInfo.getDate("starttime"), new Date());
            if (totalProgress >= 100L) {
                DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_calctaskrecord set fprogress = 95,fstatus = '1',ftime = " + time + " where Fid = " + taskid));
            } else {
                DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_calctaskrecord set fprogress = fprogress+" + mdProgress + ",ftime = " + time + " where Fid = " + taskid));
            }
        }
    }

    public static void updateProgress(Long costTypeId, Long taskid, int progress, int status) {
        try (TXHandle h = TX.notSupported();){
            taskid = TaskServiceHelper.isHaveTask(costTypeId, taskid);
            QFilter idFilter = new QFilter("id", "=", (Object)taskid);
            DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"id,progress,status,masterid,starttime,time", (QFilter[])new QFilter[]{idFilter});
            if (progress >= 100) {
                taskInfo.set("progress", (Object)100);
            } else if (progress < 0) {
                taskInfo.set("progress", (Object)0);
            } else {
                taskInfo.set("progress", (Object)progress);
            }
            taskInfo.set("status", (Object)status);
            long time = TimeUtils.getSecond(taskInfo.getDate("starttime"), new Date());
            taskInfo.set("time", (Object)(time <= 0L ? 1L : time));
            SaveServiceHelper.update((DynamicObject)taskInfo);
            h.commit();
        }
    }

    public static void updateProgress(Long costTypeId, Long taskid, int progress) {
        try (TXHandle h = TX.notSupported();){
            taskid = TaskServiceHelper.isHaveTask(costTypeId, taskid);
            QFilter idFilter = new QFilter("id", "=", (Object)taskid);
            DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"id,progress,status,masterid,starttime,time", (QFilter[])new QFilter[]{idFilter});
            if (progress >= 100) {
                taskInfo.set("progress", (Object)100);
                taskInfo.set("status", (Object)3);
            } else if (progress < 0) {
                taskInfo.set("progress", (Object)0);
            } else {
                taskInfo.set("progress", (Object)progress);
            }
            long time = TimeUtils.getSecond(taskInfo.getDate("starttime"), new Date());
            taskInfo.set("time", (Object)(time <= 0L ? 1L : time));
            SaveServiceHelper.update((DynamicObject)taskInfo);
        }
    }

    public static void addTaskDetail(Long costTypeId, Long taskid, Date startTime, long time, int status, String name, String desc) {
        try (TXHandle h = TX.notSupported();){
            boolean isErr;
            taskid = TaskServiceHelper.isHaveTask(costTypeId, taskid);
            DynamicObject tasklog = BusinessDataServiceHelper.newDynamicObject((String)"cad_taskexecutelog");
            if (name != null && name.length() > 199) {
                tasklog.set("name", (Object)name.substring(0, 199));
            } else {
                tasklog.set("name", (Object)name);
            }
            tasklog.set("task", (Object)taskid);
            if (startTime != null) {
                tasklog.set("starttime", (Object)startTime);
                tasklog.set("timestamp", (Object)startTime.getTime());
            }
            tasklog.set("time", (Object)(time <= 0L ? 1L : time));
            boolean bl = isErr = status == 2;
            if (desc != null && desc.length() > 1999) {
                tasklog.set(isErr ? "errlog" : "content", (Object)desc.substring(0, 1999));
            } else {
                tasklog.set(isErr ? "errlog" : "content", (Object)desc);
            }
            tasklog.set("status", (Object)String.valueOf(status));
            tasklog.set("createtime", (Object)new Date());
            tasklog.set("creator", (Object)RequestContext.get().getUserId());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_taskexecutelog");
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{tasklog});
        }
    }

    public static int getTaskPorgress(Long taskid) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskid);
        DynamicObject taskInfo = QueryServiceHelper.queryOne((String)"cad_calctaskrecord", (String)"id,progress", (QFilter[])new QFilter[]{idFilter});
        if (taskInfo == null) {
            return 0;
        }
        return taskInfo.getInt("progress");
    }

    public static Long createTask(Long costTypeId, String name) {
        DynamicObject taskInfo = TaskServiceHelper.createTaskInfo(costTypeId, null, name);
        if (taskInfo != null) {
            return taskInfo.getLong("id");
        }
        return 0L;
    }

    public static Long createTask(StandCostCalcParam standCostCalcParam, String name) {
        DynamicObject taskInfo = TaskServiceHelper.createTaskInfo(standCostCalcParam, null, name);
        if (taskInfo != null) {
            return taskInfo.getLong("id");
        }
        return 0L;
    }

    public static DynamicObject createTaskInfo(Long costTypeId, Long taskid, String name) {
        try (TXHandle h = TX.notSupported();){
            DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_calctaskrecord");
            if (taskid != null && taskid != 0L) {
                taskrecord.set("id", (Object)taskid);
                taskrecord.set("masterid", (Object)taskid);
            }
            taskrecord.set("costtype", (Object)costTypeId);
            taskrecord.set("taskname", (Object)name);
            taskrecord.set("starttime", (Object)new Date());
            taskrecord.set("time", (Object)0);
            taskrecord.set("status", (Object)"1");
            taskrecord.set("finishedsteps", (Object)0);
            taskrecord.set("totalsteps", (Object)10);
            taskrecord.set("progress", (Object)0);
            taskrecord.set("executor", (Object)RequestContext.get().getCurrUserId());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_calctaskrecord");
            Object[] rs = SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{taskrecord});
            if (rs != null && rs.length > 0) {
                DynamicObject dynamicObject = (DynamicObject)rs[0];
                return dynamicObject;
            }
            DynamicObject dynamicObject = null;
            return dynamicObject;
        }
    }

    public static DynamicObject createTaskInfo(StandCostCalcParam standCostCalcParam, Long taskid, String name) {
        try (TXHandle h = TX.notSupported();){
            DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_calctaskrecord");
            if (taskid != null && taskid != 0L) {
                taskrecord.set("id", (Object)taskid);
                taskrecord.set("masterid", (Object)taskid);
            }
            taskrecord.set("costtype", (Object)standCostCalcParam.getCostTypeId());
            taskrecord.set("taskname", (Object)name);
            taskrecord.set("starttime", (Object)new Date());
            taskrecord.set("time", (Object)0);
            taskrecord.set("status", (Object)"1");
            taskrecord.set("finishedsteps", (Object)0);
            taskrecord.set("totalsteps", (Object)10);
            taskrecord.set("progress", (Object)0);
            taskrecord.set("executor", (Object)RequestContext.get().getCurrUserId());
            taskrecord.set("calcdate", (Object)standCostCalcParam.getCalcDate());
            taskrecord.set("scopetype", (Object)standCostCalcParam.getScopetype());
            taskrecord.set("matgroupstd", (Object)standCostCalcParam.getMatGroupStd());
            taskrecord.set("ruleplan", (Object)standCostCalcParam.getPriceRuleScheme());
            taskrecord.set("bomrule", (Object)standCostCalcParam.getBomRuleSetting());
            taskrecord.set("routerule", (Object)standCostCalcParam.getRouteRuleSetting());
            taskrecord.set("iscalccurlevel", (Object)standCostCalcParam.isCalcCurLevel());
            taskrecord.set("issaverecord", (Object)standCostCalcParam.isSaveRecord());
            taskrecord.set("recordname", (Object)standCostCalcParam.getRecordName());
            taskrecord.set("isautoreplacerecord", (Object)standCostCalcParam.isAutoReplaceRecord());
            taskrecord.set("isconfigcalc", (Object)standCostCalcParam.isTrackCalc());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_calctaskrecord");
            Object[] rs = SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{taskrecord});
            if (rs != null && rs.length > 0) {
                DynamicObject dynamicObject = (DynamicObject)rs[0];
                return dynamicObject;
            }
            DynamicObject dynamicObject = null;
            return dynamicObject;
        }
    }

    public static Long createTask(Long costTypeId, Long taskid, String name) {
        DynamicObject taskInfo = TaskServiceHelper.createTaskInfo(costTypeId, taskid, name);
        if (taskInfo != null) {
            return taskInfo.getLong("id");
        }
        return 0L;
    }

    private static Long isHaveTask(Long costTypeId, Long taskid) {
        if (!QueryServiceHelper.exists((String)"cad_calctaskrecord", (Object)taskid)) {
            taskid = TaskServiceHelper.createTask(costTypeId, taskid, ResManager.loadKDString((String)"\u6210\u672c\u5377\u7b97", (String)"TaskServiceHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        return taskid;
    }

    private static DynamicObject isHaveTaskInfo(Long costTypeId, Long taskid) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskid);
        DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"id,progress,status,starttime", (QFilter[])new QFilter[]{idFilter});
        if (taskInfo == null) {
            taskInfo = TaskServiceHelper.createTaskInfo(costTypeId, taskid, ResManager.loadKDString((String)"\u6210\u672c\u5377\u7b97", (String)"TaskServiceHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        return taskInfo;
    }
}

