/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.Data.AuxAllocData;

public class AuxProdToBasicProdBillImportFun
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});
    private static final String BASIC_ALLOC_ENTITY = "cad_basicalloc";

    public AuxProdToBasicProdBillImportFun(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        ArrayList<RowX> rowsList = new ArrayList<RowX>();
        for (RowX row : rows) {
            rowsList.add(row);
        }
        HashMap<Long, Set> expBillIdMap = new HashMap<Long, Set>();
        HashMap<Long, Set> expComSubIdMap = new HashMap<Long, Set>();
        String entityType = this.paramMap.get("entitytype").toString();
        for (RowX row : rowsList) {
            if (!StringUtils.equals((CharSequence)"comprehensive", (CharSequence)row.getString(this.rowMeta.getFieldIndex("type")))) continue;
            Long expenseItem = row.getLong(this.rowMeta.getFieldIndex("expenseitem"));
            Long id = row.getLong(this.rowMeta.getFieldIndex("id"));
            Long comsubentryid = row.getLong(this.rowMeta.getFieldIndex("comsubentryid"));
            expBillIdMap.computeIfAbsent(expenseItem, t -> new HashSet()).add(id);
            expComSubIdMap.computeIfAbsent(expenseItem, t -> new HashSet()).add(comsubentryid);
        }
        HashMap expRowMap = new HashMap(16);
        for (Map.Entry expBillElement : expBillIdMap.entrySet()) {
            Set idSet = (Set)expBillElement.getValue();
            ArrayList<RowX> rowList = new ArrayList<RowX>();
            for (Long id : idSet) {
                for (RowX rowX : rowsList) {
                    if (!rowX.getLong(this.rowMeta.getFieldIndex("id")).equals(id)) continue;
                    rowList.add(rowX);
                }
            }
            expRowMap.put(expBillElement.getKey(), rowList);
        }
        for (Map.Entry expRowEle : expRowMap.entrySet()) {
            DynamicObject billObject;
            List rowList = (List)expRowEle.getValue();
            HashSet<Long> srcBillIds = new HashSet<Long>(16);
            HashMap<Long, AuxAllocData> comMap = new HashMap<Long, AuxAllocData>();
            HashMap<Long, AuxAllocData> parMap = new HashMap<Long, AuxAllocData>();
            RowX rowX = null;
            for (RowX row : rowList) {
                if (rowX == null) {
                    rowX = row;
                }
                srcBillIds.add(row.getLong(this.rowMeta.getFieldIndex("id")));
                if (StringUtils.equals((CharSequence)"comprehensive", (CharSequence)row.getString(this.rowMeta.getFieldIndex("type")))) {
                    if (!((Long)expRowEle.getKey()).equals(row.getLong(this.rowMeta.getFieldIndex("expenseitem")))) continue;
                    this.mergeBill(comMap, row);
                    continue;
                }
                if (!((Set)expComSubIdMap.get(expRowEle.getKey())).contains(row.getLong(this.rowMeta.getFieldIndex("comsubentryid")))) continue;
                this.mergeParBill(parMap, row);
            }
            RowX rowX2 = new RowX(1);
            rowX2.set(0, (Object)1);
            collector.collect(rowX2);
            if (rowX == null || (billObject = this.instanceBasicAllocBill(rowX, comMap, parMap, srcBillIds, (Long)expRowEle.getKey(), entityType)).getBigDecimal("amount") == null || billObject.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObject});
        }
    }

    private DynamicObject instanceBasicAllocBill(RowX row, Map<Long, AuxAllocData> comMap, Map<Long, AuxAllocData> parMap, Set<Long> srcBillIds, Long expenseItem, String entityType) {
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getAccountId());
        DynamicObject basicAllocObject = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)entityType, (DynamicObject)basicAllocObject, (String)RequestContext.get().getLoginOrg(), (int)1);
        BigDecimal amount = BigDecimal.ZERO;
        for (Map.Entry<Long, AuxAllocData> entry : comMap.entrySet()) {
            amount = amount.add(entry.getValue().getAmount());
        }
        if (batchNumber != null && batchNumber.length > 0) {
            basicAllocObject.set("billno", (Object)batchNumber[0]);
        } else {
            basicAllocObject.set("billno", (Object)ID.genStringId());
        }
        basicAllocObject.set("org", (Object)row.getLong(this.rowMeta.getFieldIndex("org")));
        basicAllocObject.set("costaccount", (Object)row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        basicAllocObject.set("manuorg", (Object)row.getLong(this.rowMeta.getFieldIndex("manuorg")));
        basicAllocObject.set("period", (Object)row.getLong(this.rowMeta.getFieldIndex("period")));
        basicAllocObject.set("allocmold", (Object)"C");
        basicAllocObject.set("costcenter", (Object)row.getLong(this.rowMeta.getFieldIndex("benefcostcenter")));
        basicAllocObject.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        basicAllocObject.set("amount", (Object)amount);
        basicAllocObject.set("srcbilltype", (Object)"B");
        basicAllocObject.set("expenseitem", (Object)expenseItem);
        basicAllocObject.set("billstatus", (Object)"A");
        basicAllocObject.set("allocstatus", (Object)"0");
        basicAllocObject.set("creator", (Object)userId);
        basicAllocObject.set("createtime", (Object)date);
        basicAllocObject.set("modifier", (Object)userId);
        basicAllocObject.set("modifytime", (Object)date);
        basicAllocObject.set("sourcetype", (Object)"D");
        basicAllocObject.set("appnum", this.paramMap.get("appNum"));
        basicAllocObject.set("planscheme", this.paramMap.get("planscheme"));
        DynamicObjectCollection comEntity = basicAllocObject.getDynamicObjectCollection("comentity");
        int i = 1;
        for (Map.Entry<Long, AuxAllocData> entry : comMap.entrySet()) {
            DynamicObject dynamicObject = comEntity.addNew();
            AuxAllocData value = entry.getValue();
            dynamicObject.set("seq", (Object)i);
            dynamicObject.set("comexpenseitem", (Object)value.getExpenseitem());
            dynamicObject.set("comcostdriver", (Object)value.getCostdriver());
            basicAllocObject.set("costdriver", (Object)value.getCostdriver());
            dynamicObject.set("allocamount", (Object)value.getAmount());
            dynamicObject.set("baseunit", (Object)value.getBaseUnit());
            ++i;
        }
        i = 1;
        DynamicObjectCollection parEntity = basicAllocObject.getDynamicObjectCollection("parallelentity");
        for (Map.Entry<Long, AuxAllocData> entry : parMap.entrySet()) {
            DynamicObject dynamicObject = parEntity.addNew();
            AuxAllocData value = entry.getValue();
            dynamicObject.set("seq", (Object)i);
            dynamicObject.set("parexpenseitem", (Object)value.getExpenseitem());
            dynamicObject.set("parcostdriver", (Object)value.getCostdriver());
            dynamicObject.set("parallocamount", (Object)value.getAmount());
            dynamicObject.set("parbaseunit", (Object)value.getBaseUnit());
            dynamicObject.set("comparexpitem", (Object)value.getComExpenseitem());
            ++i;
        }
        DynamicObjectCollection dynamicObjectCollection = basicAllocObject.getDynamicObjectCollection("srcbillentry");
        i = 1;
        for (Long id : srcBillIds) {
            DynamicObject obj = dynamicObjectCollection.addNew();
            obj.set("seq", (Object)i++);
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"C");
        }
        return basicAllocObject;
    }

    private void mergeBill(Map<Long, AuxAllocData> comMap, RowX row) {
        Long expenSeitem = row.getLong(this.rowMeta.getFieldIndex("expenseitem"));
        Long costDriver = row.getLong(this.rowMeta.getFieldIndex("costdriver"));
        Long baseUnit = row.getLong(this.rowMeta.getFieldIndex("baseunit"));
        BigDecimal amount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
        AuxAllocData auxAllocData = comMap.get(expenSeitem);
        if (auxAllocData != null) {
            auxAllocData.setAmount(auxAllocData.getAmount().add(amount));
        } else {
            AuxAllocData data = new AuxAllocData();
            data.setAmount(amount);
            data.setCostdriver(costDriver);
            data.setExpenseitem(expenSeitem);
            data.setBaseUnit(baseUnit);
            comMap.put(expenSeitem, data);
        }
    }

    private void mergeParBill(Map<Long, AuxAllocData> parMap, RowX row) {
        String costDriverAndBaseUnit = (String)this.paramMap.get(row.getString(this.rowMeta.getFieldIndex("id")) + row.getString(this.rowMeta.getFieldIndex("benefcostcenter")));
        String[] split = costDriverAndBaseUnit.split("@");
        Long comExpenSeitem = Long.valueOf(split[0]);
        Long costDriver = Long.valueOf(split[1]);
        Long baseUnit = Long.valueOf(split[2]);
        Long expenSeitem = row.getLong(this.rowMeta.getFieldIndex("expenseitem"));
        BigDecimal amount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
        AuxAllocData auxAllocData = parMap.get(expenSeitem + costDriver);
        if (auxAllocData != null) {
            auxAllocData.setAmount(auxAllocData.getAmount().add(amount));
        } else {
            AuxAllocData data = new AuxAllocData();
            data.setAmount(amount);
            data.setCostdriver(costDriver);
            data.setExpenseitem(expenSeitem);
            data.setBaseUnit(baseUnit);
            data.setComExpenseitem(comExpenSeitem);
            parMap.put(expenSeitem + costDriver, data);
        }
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

