/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.Data.BOMExpandDataSet;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.calc.helper.AnalysisBOMStructHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.CalcCheckerHelper;
import kd.macc.cad.algox.calc.helper.DownCalculateHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StdCalculateHelper;
import kd.macc.cad.common.lock.RedisBatchLock;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class BOMExpand
implements Serializable {
    private static final long serialVersionUID = -3574110484172899332L;
    private static final Log logger = LogFactory.getLog(BOMExpand.class);
    private BOMExpandDataSet fullBomExpandDataSet = new BOMExpandDataSet();
    private BOMExpandDataSet bomExpandResult = new BOMExpandDataSet();
    private Set<String> isNotDownCalcMaterialIdsWithBom = Sets.newHashSet();
    private StandCostCalcParam standCostCalcParam = null;

    public void setStandCostCalcParam(StandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public void prepareData() {
        this.fullBomExpandDataSet.setCalcParam(this.standCostCalcParam);
        this.bomExpandResult.setCalcParam(this.standCostCalcParam);
        HashSet<Long> productOrgs = new HashSet<Long>(10);
        if ("aca".equals(this.standCostCalcParam.getAppNum())) {
            DynamicObject costType = CostTypeHelper.getCostType((Long)this.standCostCalcParam.getCostTypeId(), (String)"createorg");
            productOrgs.addAll(ImportServiceHelper.getUserHasPermOrgs((Long)(costType == null ? 0L : costType.getLong("createorg.id")), (String)"04"));
        } else {
            productOrgs.addAll(kd.macc.cad.algox.calc.helper.StdCalculateHelper.getProductOrgsByImitateCostType(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getCalcDate()));
        }
        this.standCostCalcParam.setProductOrgs(productOrgs);
        this.preDealCalcData(this.standCostCalcParam);
        Long calOrg = OrgHelper.getCalcOrgByCostType((Long)this.standCostCalcParam.getCostTypeId(), (Long)this.standCostCalcParam.getHsCostTypeId(), (String)this.standCostCalcParam.getAppNum());
        if (!CadEmptyUtils.isEmpty(calOrg)) {
            this.standCostCalcParam.setEnableMulFactory(OrgHelper.isOrgEnableMultiFactory((Long)calOrg));
        }
        logger.info("\u5377\u7b97-\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u662f\u5426\u5f00\u542f\u591a\u5de5\u5382\uff1a{}", (Object)calOrg, (Object)this.standCostCalcParam.isEnableMulFactory());
    }

    public void preparePriceData(StandCostCalcParam standCostCalcParam) {
        List<Long> purPriceObjIds = kd.macc.cad.algox.calc.helper.StdCalculateHelper.getPurPriceObjIds(standCostCalcParam.getCostTypeId(), standCostCalcParam.getHsCostTypeId(), standCostCalcParam.getCustomSuppliedMaterials(), standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate(), standCostCalcParam.getPurMatCostInfoMap());
        List<Long> outPriceObjIds = kd.macc.cad.algox.calc.helper.StdCalculateHelper.getOutPriceObjIds(standCostCalcParam.getCostTypeId(), standCostCalcParam.getHsCostTypeId(), standCostCalcParam.getCustomSuppliedMaterials(), standCostCalcParam.getPriceRuleScheme(), standCostCalcParam.getCalcDate());
        standCostCalcParam.setPruPriceObjIds(purPriceObjIds);
        standCostCalcParam.setOutPriceObjIds(outPriceObjIds);
        this.write2Log(ResManager.loadKDString((String)"\u51c6\u5907\u4ef7\u76ee\u8868\u6570\u636e", (String)"BOMExpand_17", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    public void prepareBomData(StandCostCalcParam standCostCalcParam) {
        if (this.fullBomExpandDataSet == null) {
            this.fullBomExpandDataSet = new BOMExpandDataSet();
        }
        if (this.bomExpandResult == null) {
            this.bomExpandResult = new BOMExpandDataSet();
        }
        this.fullBomExpandDataSet.setCalcParam(standCostCalcParam);
        this.bomExpandResult.setCalcParam(standCostCalcParam);
        this.fullBomExpandDataSet.prepareBOMData(standCostCalcParam);
        if (!standCostCalcParam.isStartBomRuleCalc().booleanValue()) {
            this.isNotDownCalcMaterialIdsWithBom = DownCalculateHelper.getIsNotDownCalcMatKeycols(standCostCalcParam.getCostTypeId(), standCostCalcParam.getBizLogger());
        }
        this.write2Log(ResManager.loadKDString((String)"\u51c6\u5907BOM\u6570\u636e", (String)"BOMExpand_0", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    public void prepareRouteData(StandCostCalcParam standCostCalcParam) {
        if (this.fullBomExpandDataSet == null) {
            this.fullBomExpandDataSet = new BOMExpandDataSet();
        }
        this.fullBomExpandDataSet.setCalcParam(standCostCalcParam);
        this.fullBomExpandDataSet.prepareRouteData(standCostCalcParam);
        standCostCalcParam.getMaterials().clear();
        standCostCalcParam.getBomIdSet().clear();
        this.write2Log(ResManager.loadKDString((String)"\u51c6\u5907\u5de5\u827a\u8def\u7ebf\u6570\u636e", (String)"BOMExpand_18", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    public void prepareDataForStruct() {
        Long calOrg;
        this.fullBomExpandDataSet.setCalcParam(this.standCostCalcParam);
        this.bomExpandResult.setCalcParam(this.standCostCalcParam);
        List hsCostTypes = CostTypeHelper.getHsCostByMn((Long)this.standCostCalcParam.getCostTypeId());
        if (!CadEmptyUtils.isEmpty(hsCostTypes)) {
            this.standCostCalcParam.setHsCostTypeId((Long)hsCostTypes.get(0));
        }
        if (!CadEmptyUtils.isEmpty(calOrg = OrgHelper.getCalcOrgByCostType((Long)this.standCostCalcParam.getCostTypeId(), (Long)this.standCostCalcParam.getHsCostTypeId(), (String)this.standCostCalcParam.getAppNum()))) {
            this.standCostCalcParam.setEnableMulFactory(OrgHelper.isOrgEnableMultiFactory((Long)calOrg));
        }
        logger.info("\u5377\u7b97-\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u662f\u5426\u5f00\u542f\u591a\u5de5\u5382\uff1a{}", (Object)calOrg, (Object)this.standCostCalcParam.isEnableMulFactory());
        this.fullBomExpandDataSet.prepareBomDataForStruct(this.standCostCalcParam);
        this.fullBomExpandDataSet.preparePriceData(this.standCostCalcParam);
        this.fullBomExpandDataSet.prepareRouteDataForStruct(this.standCostCalcParam);
        this.write2Log(ResManager.loadKDString((String)"\u51c6\u5907BOM\u6570\u636e", (String)"BOMExpand_0", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    public void expand() {
        List<Material> calcMaterials = this.fullBomExpandDataSet.getCalculateMaterials();
        logger.info("BOM\u5c55\u5f00\uff0ccalcMaterials\u4e2a\u6570\uff1a{}", (Object)calcMaterials.size());
        this.fullBomExpandDataSet.setCalcMap();
        int count = 0;
        Iterator<Material> iterator = calcMaterials.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            List<BOMExpandNode> roots = this.fullBomExpandDataSet.findRoots(material);
            for (BOMExpandNode root : roots) {
                if (this.bomExpandResult.contained(root) || this.materailIsExpanded(material) && this.bomExpandResult.contained(root) && !this.isNotDownCalcMaterialIdsWithBom.contains(material.getKeycol())) continue;
                this.buildTreeNode(null, root, 0);
                this.bomDownExpand(root, 0, count);
            }
            iterator.remove();
        }
        logger.info("\u5171\u8017\u6570\u91cf\uff1a{}", (Object)count);
        this.clearMap();
        this.bomExpandResult.partInPart();
        if (this.standCostCalcParam.isDebug()) {
            this.write2Log(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u7ed3\u679c", (String)"BOMExpand_1", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
            this.bomExpandResult.writeDebugLog();
        }
        this.write2Log(ResManager.loadKDString((String)"BOM\u5c55\u5f00", (String)"BOMExpand_2", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
        this.saveCalcMatExpandRecord();
    }

    public void clear() {
        this.fullBomExpandDataSet = null;
        this.bomExpandResult = null;
    }

    private void bomDownExpand(BOMExpandNode currentNode, int level, int count) {
        this.bomExpandResult.addNode(currentNode, true);
        List<BOMExpandNode> subItems = this.fullBomExpandDataSet.findSubNodes(currentNode);
        boolean isNotDownCalcSemiProduct = this.isNotDownCalcMaterialIdsWithBom.contains(currentNode.getMaterial().getKeycol());
        if (subItems.isEmpty() || isNotDownCalcSemiProduct) {
            if (currentNode.getExpandBomId() != 0L) {
                this.write2Log(String.format(ResManager.loadKDString((String)"\u6210\u672cBOM\u201c%s\u201d\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u9879\uff0c\u5377\u7b97\u65e5\u671f\u5185\u65e0\u6709\u6548\u65e5\u671f\u3002", (String)"BOMExpand_3", (String)"macc-cad-algox", (Object[])new Object[0]), currentNode.getExpandBomId()), new Boolean[0]);
            }
            currentNode.setLeaf(true);
            currentNode.getMaterial().setPurPrice(true);
        } else {
            boolean ok;
            BOMExpandNode subNode;
            for (int i = 0; i < subItems.size(); ++i) {
                subNode = subItems.get(i);
                if (!this.bomExpandResult.contained(subNode)) continue;
                BOMExpandNode subNodeCopy = subNode.copy();
                subNodeCopy.setParentBomExpandNodeId(currentNode.getNodeId());
                subItems.set(i, subNodeCopy);
                ++count;
            }
            ++level;
            Iterator<BOMExpandNode> iterator = subItems.iterator();
            while (iterator.hasNext() && (ok = this.buildTreeNode(currentNode, subNode = iterator.next(), level))) {
                subNode.setParentBomExpandNodeId(currentNode.getNodeId());
                this.bomDownExpand(subNode, level, count);
            }
        }
    }

    private void changePartTree(BOMExpandNode partNode, BOMExpandNode currentNode) {
        Set<Object> treeRootIdSet;
        String oldBomTreePath = partNode.getBomTreePath();
        if (BOMExpand.isNest(oldBomTreePath)) {
            this.reportBomNest(oldBomTreePath);
            return;
        }
        BOMExpandNode partRoot = this.fullBomExpandDataSet.findNodeByBOM(partNode.getExpandBomId());
        long oldTreeId = currentNode.getBomTreeRootId();
        String oldTreePath = partNode.getBomTreePath();
        partRoot.setPart(true);
        partRoot.setLeaf(false);
        partRoot.setNodeType(10);
        this.bomExpandResult.addNode(partRoot, false);
        this.buildTreeNode(null, partRoot, 0);
        if (this.bomExpandResult.getPartBomInTrees().containsKey(partRoot.getBomTreeRootId())) {
            treeRootIdSet = this.bomExpandResult.getPartBomInTrees().get(partRoot.getBomTreeRootId());
        } else {
            treeRootIdSet = new HashSet();
            this.bomExpandResult.getPartBomInTrees().put(partRoot.getBomTreeRootId(), treeRootIdSet);
        }
        treeRootIdSet.add(partNode.getBomTreeRootId());
        treeRootIdSet.add(oldTreeId);
        long bomTreeRootId = partRoot.getBomId();
        String oldBomTreePathPrex = oldBomTreePath + "@";
        String newBomTreePathPrex = partRoot.getBomId() + "@";
        List<BOMExpandNode> nodes = this.bomExpandResult.findNodeByTreePath(oldBomTreePathPrex);
        for (BOMExpandNode node : nodes) {
            String treePath = node.getBomTreePath();
            treePath = treePath.replace(oldBomTreePathPrex, newBomTreePathPrex);
            String[] children = treePath.split("@");
            node.setPart(true);
            node.setNodeType(11);
            node.setBomTreeRootId(bomTreeRootId);
            node.setBomTreePath(treePath);
            node.setLevel(children.length - 1);
        }
    }

    private boolean buildTreeNode(BOMExpandNode parentNode, BOMExpandNode node, int level) {
        if (parentNode == null) {
            node.setBomTreeRootId(node.getBomId());
            node.setBomTreePath(String.valueOf(node.getBomId()));
            node.setLevel(level);
            return true;
        }
        node.appendToParent(parentNode, level);
        if (BOMExpand.isNest(node.getBomTreePath())) {
            this.reportBomNest(node.getBomTreePath());
            node.setBomTreePath(null);
            node.setBomTreeRootId(0L);
            return false;
        }
        return true;
    }

    private void reportBomNest(String bomTreePath) {
        CalcCheckerHelper.createCyclePathCheck(this.standCostCalcParam, bomTreePath);
    }

    public static boolean isNest(String bomTreePath) {
        String[] bomIds = bomTreePath.split("@");
        if (bomIds.length > 1) {
            HashSet<String> bomSet = new HashSet<String>(16);
            for (String bomId : bomIds) {
                if (bomSet.contains(bomId)) {
                    return true;
                }
                bomSet.add(bomId);
            }
        }
        return false;
    }

    public boolean materailIsExpanded(Material material) {
        return this.bomExpandResult.bomContainsMaterial(material.getMaterialId());
    }

    public BOMExpandDataSet getBomExpandResult() {
        return this.bomExpandResult;
    }

    private void write2Log(String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("BOM\u5c55\u5f00:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"BOM\u5c55\u5f00", (String)"BOMExpand_2", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    private void write2LogCustom(String catalog, String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format(catalog, desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(catalog, desc);
        }
    }

    private void clearMap() {
        this.fullBomExpandDataSet.setCalculateMaterials(null);
        this.fullBomExpandDataSet.setBomIdAndNodeMap(null);
        this.fullBomExpandDataSet.setMatKeycolAndNodeMap(null);
        this.fullBomExpandDataSet.setParentBomIdAndNodeMap(null);
        this.fullBomExpandDataSet = null;
    }

    private void saveCalcMatExpandRecord() {
        try {
            boolean exists = QueryServiceHelper.exists((String)"cad_calcmatexpandrecord", (Object)this.standCostCalcParam.getTaskId());
            if (!exists) {
                DynamicObject successRecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcmatexpandrecord");
                successRecord.set("calctask", (Object)this.standCostCalcParam.getTaskId());
                Set materialIds = this.bomExpandResult.getNodeList().stream().filter(item -> !item.isLeaf()).map(item -> item.getMaterial().getMaterialId()).collect(Collectors.toSet());
                successRecord.set("successmatexpandcount", (Object)materialIds.size());
                if (this.standCostCalcParam.isCalcCurLevel()) {
                    HashSet<Long> removeDuplicate = new HashSet<Long>(10);
                    for (Material material : this.standCostCalcParam.getMaterials()) {
                        if (material.isPurPrice()) continue;
                        removeDuplicate.add(material.getMaterialId());
                    }
                    successRecord.set("successmatexpandcount", (Object)removeDuplicate.size());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{successRecord});
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u6210\u672c\u7c7b\u578b%s\u4fdd\u5b58\u5377\u7b97bom\u5c55\u5f00\u7269\u6599\u6570\u91cf\u5931\u8d25\u3002", this.standCostCalcParam.getCostTypeId()), (Throwable)e);
        }
    }

    private void preDealCalcData(StandCostCalcParam calcParam) {
        int calcLimitSize = CadBgParamUtils.getCadParamForInt((String)"calcLimitSize", (int)100000);
        if (this.isExceedLimitMat(calcParam.getMatEntryInfos().size(), calcLimitSize).booleanValue() || this.isExceedLimitMat(calcParam.getMaterials().size(), calcLimitSize).booleanValue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6307\u5b9a\u5377\u7b97\u7684\u7269\u6599\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BOMExpand_4", (String)"macc-cad-algox", (Object[])new Object[0]), calcLimitSize));
        }
        if (CadEmptyUtils.isEmpty(calcParam.getMaterials())) {
            List<String> updateMatInfos = this.getUpdateMatInfos(calcParam.getCostTypeId(), calcParam.getProductOrgs(), calcParam.getMatEntryInfos(), calcParam.isStartBomRuleCalc());
            calcParam.setMatEntryInfos(updateMatInfos);
            Map<Integer, List<Material>> scopeTypeAndMaterials = this.getScopeTypeAndMaterials(calcParam.getCostTypeId(), calcParam.getScopetype(), calcParam.getMatEntryInfos(), calcParam.getMatGroupStd(), calcParam.isConfigMat(), calcParam.getCalcDate(), calcParam.isStartBomRuleCalc());
            for (Map.Entry<Integer, List<Material>> entry : scopeTypeAndMaterials.entrySet()) {
                calcParam.setScopetype(entry.getKey());
                calcParam.setMaterials(entry.getValue());
            }
        }
        if (calcParam.getAppNum() == null) {
            calcParam.setAppNum("sca");
        }
        HashMap<Long, List<Long>> matConfigCodeIdMap = new HashMap<Long, List<Long>>(16);
        ArrayList<String> wizardMatScopInfos = new ArrayList<String>(10);
        this.setCalcMaterialInfos(calcParam.getMaterials(), calcParam.getKeycols(), calcParam.getMatConfigCodeTrackNumMap(), wizardMatScopInfos, matConfigCodeIdMap, calcParam.isConfigMat());
        calcParam.setWizardMatScopInfos(wizardMatScopInfos);
        calcParam.setCheckSuccessProducts(this.getCalcMatKeycols(calcParam.getMaterials()));
        if (calcParam.getCheckType() == 1) {
            this.checkLock(calcParam.getCostTypeId(), calcParam.getKeycols(), calcParam.getScopetype(), calcParam.isCalcCurLevel(), calcParam.isTrackCalc(), calcParam.getAppNum());
        }
        kd.macc.cad.algox.calc.helper.StdCalculateHelper.updateRecordMatInfoBeforeCalc(calcParam.getTaskId(), calcParam.getCheckTaskId(), calcParam.getScopetype(), new HashSet<String>(wizardMatScopInfos));
        int getDefaultConmfig = CadBgParamUtils.getCadParamForInt((String)"getDefaultConfig", (int)0);
        calcParam.setDefaultConfigCalc(getDefaultConmfig == 1 && calcParam.isTrackCalc() == false && calcParam.isConfigMat() != false);
        if (!calcParam.isTrackCalc().booleanValue()) {
            Iterator<Material> materialList = calcParam.getMaterials().iterator();
            while (materialList.hasNext()) {
                Material material = materialList.next();
                if (!material.isPurPrice()) continue;
                calcParam.getCalcPurMaterials().add(material.getKeycol());
                materialList.remove();
            }
        }
        List<String> copEntryMaterialKeycols = this.getCoMaterialKeycols(calcParam);
        calcParam.setCoByMaterialKeycols(copEntryMaterialKeycols);
        calcParam.getKeycols().addAll(copEntryMaterialKeycols);
        List hsCostTypes = CostTypeHelper.getHsCostByMn((Long)this.standCostCalcParam.getCostTypeId());
        if (!CadEmptyUtils.isEmpty(hsCostTypes)) {
            calcParam.setHsCostTypeId((Long)hsCostTypes.get(0));
        }
        if (!calcParam.isTrackCalc().booleanValue() && !calcParam.isDefaultConfigCalc().booleanValue()) {
            return;
        }
        Map<Long, List<Long>> manuOrgMatMap = this.getManuOrgMatsByBom(this.standCostCalcParam.getBomRuleSetting(), this.standCostCalcParam.getProductOrgs(), matConfigCodeIdMap);
        Map<Long, List<Long>> manuOrgConfigCodeMap = this.getManuOrgConfigCodeMap(matConfigCodeIdMap, manuOrgMatMap);
        this.dealConfigBomStruct(calcParam, manuOrgMatMap, manuOrgConfigCodeMap);
    }

    private Boolean isExceedLimitMat(int count, int calcLimitSize) {
        if (count > calcLimitSize) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<String> getUpdateMatInfos(Long costTypeId, Set<Long> productOrgs, List<String> matEntryInfos, Boolean isStartBomRuleCalc) {
        String updateMatInfo = CadBgParamUtils.getCadBgParamForString((String)"calcUpdateMatInfo", (String)"0");
        if (!"1".equals(updateMatInfo)) {
            return matEntryInfos;
        }
        if (CadEmptyUtils.isEmpty(matEntryInfos)) {
            return matEntryInfos;
        }
        HashSet<Long> matIds = new HashSet<Long>(10);
        for (String matEntryInfo : matEntryInfos) {
            String[] split = matEntryInfo.split("@");
            if (CadEmptyUtils.isEmpty(split[0])) continue;
            matIds.add(Long.parseLong(split[0]));
        }
        if (CadEmptyUtils.isEmpty(matIds)) {
            return matEntryInfos;
        }
        ArrayList<String> matEntryInfoList = new ArrayList<String>(10);
        HashMap<String, String> matInfoMap = new HashMap<String, String>(16);
        if (isStartBomRuleCalc.booleanValue()) {
            if (CadEmptyUtils.isEmpty(productOrgs)) {
                return matEntryInfoList;
            }
            DataSet matProduceInfo = BomRuleSettingStdCalcHelper.getMatProduceInfo(productOrgs, matIds);
            while (matProduceInfo.hasNext()) {
                Row row = matProduceInfo.next();
                String material = row.getString("masterid");
                if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((String)material) || matInfoMap.containsKey(material)) continue;
                String materialAttr = row.getString("materialattr");
                if ("10030".equals(materialAttr)) {
                    matInfoMap.put(material, "A");
                    continue;
                }
                if ("10040".equals(materialAttr)) {
                    matInfoMap.put(material, "B");
                    continue;
                }
                if ("10050".equals(materialAttr)) {
                    matInfoMap.put(material, "C");
                    continue;
                }
                if (!"10020".equals(materialAttr)) continue;
                matInfoMap.put(material, "D");
            }
            Iterator<String> iterator = matEntryInfos.iterator();
            while (iterator.hasNext()) {
                String matEntryInfo = iterator.next();
                String[] split = matEntryInfo.split("@");
                if (CadEmptyUtils.isEmpty(split[0])) continue;
                String matAttr = matInfoMap.getOrDefault(split[0], "B");
                matEntryInfo = split[0] + "@" + split[1] + "@" + split[2] + "@" + split[3] + "@" + split[4] + "@" + split[5] + "@" + matAttr + "@" + split[7];
                iterator.remove();
                matEntryInfoList.add(matEntryInfo);
            }
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("material", "in", matIds));
            filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("status", "=", (Object)"C"));
            DataSet matCalcProp = QueryServiceHelper.queryDataSet((String)"updateMatInfo", (String)"cad_bomsetting", (String)"material,auxprop,configuredcode,tracknumber,project,lot,matcalcprop", (QFilter[])new QFilter[]{filter}, null);
            while (matCalcProp.hasNext()) {
                Row row = matCalcProp.next();
                String material = row.getString("material");
                if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((String)material)) continue;
                String auxprop = row.getString("auxprop");
                String configuredcode = row.getString("configuredcode");
                String tracknumber = row.getString("tracknumber");
                String project = row.getString("project");
                String lot = row.getString("lot");
                String materialAttr = row.getString("matcalcprop");
                String key = material + "@" + auxprop + "@" + configuredcode + "@" + tracknumber + "@" + project + "@" + lot;
                if (matInfoMap.containsKey(key)) continue;
                matInfoMap.put(key, materialAttr);
            }
            Iterator<String> iterator = matEntryInfos.iterator();
            while (iterator.hasNext()) {
                String matEntryInfo = iterator.next();
                String[] split = matEntryInfo.split("@");
                if (CadEmptyUtils.isEmpty(split[0])) continue;
                String key = split[0] + "@" + split[1] + "@" + split[2] + "@" + split[3] + "@" + split[4] + "@" + split[5];
                String matAttr = matInfoMap.getOrDefault(key, "B");
                matEntryInfo = split[0] + "@" + split[1] + "@" + split[2] + "@" + split[3] + "@" + split[4] + "@" + split[5] + "@" + matAttr + "@" + split[7];
                iterator.remove();
                matEntryInfoList.add(matEntryInfo);
            }
        }
        return matEntryInfoList;
    }

    private Map<Long, List<Long>> getManuOrgConfigCodeMap(Map<Long, List<Long>> matConfigCodeIdMap, Map<Long, List<Long>> manuOrgMatMap) {
        HashMap<Long, List<Long>> manuOrgConfigCodeMap = new HashMap<Long, List<Long>>(16);
        if (CadEmptyUtils.isEmpty(matConfigCodeIdMap) || CadEmptyUtils.isEmpty(manuOrgMatMap)) {
            return manuOrgConfigCodeMap;
        }
        for (Map.Entry<Long, List<Long>> entry : manuOrgMatMap.entrySet()) {
            Long manuOrg = entry.getKey();
            List<Long> matIds = entry.getValue();
            for (Long matId : matIds) {
                if (!matConfigCodeIdMap.containsKey(matId)) continue;
                manuOrgConfigCodeMap.computeIfAbsent(manuOrg, p -> new ArrayList()).addAll((Collection)matConfigCodeIdMap.get(matId));
            }
        }
        return manuOrgConfigCodeMap;
    }

    private Map<Long, List<Long>> getManuOrgMatsByBom(Long bomRuleSettingId, Set<Long> productOrgs, Map<Long, List<Long>> matConfigCodeIdMap) {
        HashMap<Long, List<Long>> manuOrgMatMap = new HashMap<Long, List<Long>>(16);
        if (CadEmptyUtils.isEmpty(bomRuleSettingId)) {
            return manuOrgMatMap;
        }
        DynamicObject bomRuleSettingObj = kd.macc.cad.algox.calc.helper.StdCalculateHelper.getBomRuleSettingObj(bomRuleSettingId);
        String entity = bomRuleSettingObj.getString("srcbom");
        String filterStr = bomRuleSettingObj.getString("filter_tag");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            filterList.add(filterBuilder.getQFilter());
        }
        String orgField = "manuorg";
        String matField = "material";
        if ("pdm_mftbom".equals(entity)) {
            orgField = "createorg";
            matField = "material.masterid";
        }
        QFilter orgFilter = new QFilter(orgField, "in", productOrgs);
        filterList.add(orgFilter);
        filterList.add(new QFilter(matField, "in", matConfigCodeIdMap.keySet()));
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection entryEntitys = bomRuleSettingObj.getDynamicObjectCollection("entryentity");
        StringBuilder orderStr = new StringBuilder();
        orderStr.append("ctrlstrategy desc");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntitys.get(0);
            String srcfield = dynamicObject.getString("srcfield");
            String sequence = dynamicObject.getString("sequence");
            if (CadEmptyUtils.isEmpty(srcfield)) continue;
            if (CadEmptyUtils.isEmpty(orderStr.toString())) {
                orderStr.append(srcfield);
                orderStr.append(" ");
                orderStr.append(sequence);
                continue;
            }
            orderStr.append(",");
            orderStr.append(srcfield);
            orderStr.append(" ");
            orderStr.append(sequence);
        }
        DataSet bomDataSet = QueryServiceHelper.queryDataSet((String)"getManuOrgByBom", (String)entity, (String)(orgField + ",auxproperty,configuredcode," + matField), (QFilter[])filterList.toArray(new QFilter[0]), (String)orderStr.toString());
        HashSet<Long> existMats = new HashSet<Long>(100);
        while (bomDataSet.hasNext()) {
            long material;
            Row row = bomDataSet.next();
            Long org = row.getLong(orgField);
            if (CadEmptyUtils.isEmpty(org) || existMats.contains(material = row.getLong(matField).longValue())) continue;
            existMats.add(material);
            manuOrgMatMap.computeIfAbsent(org, p -> new ArrayList()).add(row.getLong(matField));
        }
        return manuOrgMatMap;
    }

    private void checkLock(Long costTypeId, List<String> keycols, int scopType, Boolean calcCurLevel, Boolean trackCalc, String appNum) {
        if (scopType == 0) {
            return;
        }
        if (!calcCurLevel.booleanValue() && !trackCalc.booleanValue()) {
            return;
        }
        RedisBatchLock redisBatchLock = new RedisBatchLock("stdcalc", costTypeId, new HashSet<String>(keycols), appNum);
        redisBatchLock.lock();
        Set lockFailedKeys = redisBatchLock.getLockFailedKeys();
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(lockFailedKeys);
        String lockMsg = "";
        while (bomMatDataSetByKeyCol.hasNext()) {
            Row row = bomMatDataSetByKeyCol.next();
            String matnumber = row.getString("matnumber");
            String matname = row.getString("matname");
            String auxproperty = row.getString("auxproperty");
            String configuredcodenum = row.getString("configuredcodenum");
            String msg = "";
            msg = !CadEmptyUtils.isEmpty(auxproperty) && !CadEmptyUtils.isEmpty(configuredcodenum) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010\u7f16\u53f7\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027id\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\u3011", (String)"BOMExpand_5", (String)"macc-cad-algox", (Object[])new Object[0]), matnumber, matname, auxproperty, configuredcodenum) : (!CadEmptyUtils.isEmpty(auxproperty) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010\u7f16\u53f7\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027id\uff1a%3$s\u3011", (String)"BOMExpand_6", (String)"macc-cad-algox", (Object[])new Object[0]), matnumber, matname, auxproperty) : (!CadEmptyUtils.isEmpty(configuredcodenum) ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010\u7f16\u53f7\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%3$s\u3011", (String)"BOMExpand_7", (String)"macc-cad-algox", (Object[])new Object[0]), matnumber, matname, configuredcodenum) : String.format(ResManager.loadKDString((String)"\u7269\u6599\u3010\u7f16\u53f7\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s\u3011", (String)"BOMExpand_8", (String)"macc-cad-algox", (Object[])new Object[0]), matnumber, matname)));
            if (CadEmptyUtils.isEmpty(lockMsg)) {
                lockMsg = msg;
                continue;
            }
            lockMsg = lockMsg + "\u3001" + msg;
        }
        if (!CadEmptyUtils.isEmpty(lockMsg)) {
            String errorMsg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u8fdb\u884c\u5377\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u6267\u884c\u3002", (String)"BOMExpand_9", (String)"macc-cad-algox", (Object[])new Object[0]);
            redisBatchLock.unlock();
            logger.info(String.format(errorMsg, lockMsg));
            throw new KDBizException(String.format(errorMsg, lockMsg));
        }
    }

    private void dealConfigBomStruct(StandCostCalcParam calcParam, Map<Long, List<Long>> manuOrgMatMap, Map<Long, List<Long>> manuOrgConfigCodeMap) {
        if (calcParam.isDefaultConfigCalc().booleanValue()) {
            for (Map.Entry<Long, List<Long>> entry : manuOrgMatMap.entrySet()) {
                Long manuOrg = entry.getKey();
                List<Long> materialIds = entry.getValue();
                ArrayList<String> defaultConfigKeycols = new ArrayList<String>(10);
                for (Long materialId : materialIds) {
                    HashMap<String, Long> values = new HashMap<String, Long>(5);
                    values.put("material", materialId);
                    String calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true).getKeycol();
                    defaultConfigKeycols.add(calcKey);
                }
                calcParam.getDefaultConfigKeycols().addAll(defaultConfigKeycols);
                if (CadEmptyUtils.isEmpty(calcParam.getDefaultConfigKeycols())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u914d\u7f6e\u4ef6\u3002 ", (String)"BOMExpand_11", (String)"macc-cad-algox", (Object[])new Object[0]));
                }
                defaultConfigKeycols.forEach(calcParam.getCalcPurMaterials()::remove);
                this.getConfigBomInfoJsStrExt(calcParam, manuOrg, new HashSet<Long>(materialIds), calcParam.getCalcDate());
            }
        } else if (calcParam.isTrackCalc().booleanValue()) {
            HashSet failMatIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry<Long, List<Long>> entry : manuOrgConfigCodeMap.entrySet()) {
                Long manuOrg = entry.getKey();
                List<Long> configCodeIds = entry.getValue();
                List configBomInfoJsStr = StdCalculateHelper.getConfigBomInfoJsStrNew((Long)manuOrg, configCodeIds, (Date)calcParam.getCalcDate(), (boolean)false, (Set)failMatIds);
                calcParam.getManuOrgConfigBomInfoJsStrList().put(manuOrg, configBomInfoJsStr);
            }
            if (failMatIds.size() > 0) {
                this.logErrorMaterialInfoForConfig(failMatIds, ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u6ca1\u6709\u83b7\u53d6\u5230\u9009\u914d\u6e05\u5355\u3002", (String)"BOMExpand_12", (String)"macc-cad-algox", (Object[])new Object[0]));
            }
        }
    }

    private List<String> getCalcMatKeycols(List<Material> materials) {
        if (CadEmptyUtils.isEmpty(materials)) {
            return new ArrayList<String>();
        }
        ArrayList<String> calcMatKeycols = new ArrayList<String>(10);
        for (Material material : materials) {
            long tracknumber = material.getTracknumber();
            if (CadEmptyUtils.isEmpty(tracknumber)) {
                calcMatKeycols.add(material.getKeycol());
                continue;
            }
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", material.getMaterialId());
            keycolMap.put("configuredcode", material.getConfiguredcode());
            keycolMap.put("lot", material.getLot());
            if (material.isIsuseauxpty() && material.isAffectPrice()) {
                keycolMap.put("auxproperty", material.getMaterialAuxPropId());
            }
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            calcMatKeycols.add(keycol);
        }
        return calcMatKeycols;
    }

    private void setCalcMaterialInfos(List<Material> materials, List<String> keycols, Map<String, Set<Long>> matConfigCodeTrackNumMap, List<String> wizardMatScopInfos, Map<Long, List<Long>> matConfigCodeIdMap, Boolean configMat) {
        if (CadEmptyUtils.isEmpty(materials)) {
            return;
        }
        for (Material material : materials) {
            Long matId = material.getMaterialId();
            Long auxpty = material.getMaterialAuxPropId();
            Long configuredCodeId = material.getConfiguredcode();
            Long trackNumberId = material.getTracknumber();
            Long projectId = material.getProject();
            String lot = material.getLot();
            String matcalcprop = material.getMaterialAttr();
            String configKeycolForTrack = " ";
            if (!CadEmptyUtils.isEmpty(trackNumberId)) {
                HashMap<String, Long> values = new HashMap<String, Long>(16);
                values.put("material", material.getMaterialId());
                values.put("configuredcode", material.getConfiguredcode());
                Keycol calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true);
                configKeycolForTrack = calcKey.getKeycol();
                keycols.add(configKeycolForTrack);
            } else {
                keycols.add(material.getKeycol());
            }
            if (!CadEmptyUtils.isEmpty(trackNumberId)) {
                matConfigCodeTrackNumMap.computeIfAbsent(configKeycolForTrack, p -> new HashSet()).add(trackNumberId);
            } else if (!CadEmptyUtils.isEmpty(configuredCodeId)) {
                matConfigCodeTrackNumMap.computeIfAbsent(material.getKeycol(), p -> new HashSet()).add(trackNumberId);
            }
            if (configMat.booleanValue()) {
                matConfigCodeIdMap.computeIfAbsent(matId, p -> new ArrayList()).add(configuredCodeId);
            }
            String matInfoStr = matId + "@" + auxpty + "@" + configuredCodeId + "@" + trackNumberId + "@" + lot + "@" + projectId + "@" + matcalcprop + "@" + material.getKeycol() + "@" + configKeycolForTrack;
            wizardMatScopInfos.add(matInfoStr);
        }
    }

    private Set<Long> getMaterialIds(List<String> keycols) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        QFilter filter = new QFilter("keycol", "in", keycols);
        DynamicObjectCollection keycolObjs = QueryServiceHelper.query((String)"cad_keycol", (String)"material", (QFilter[])new QFilter[]{filter});
        for (DynamicObject keycolObj : keycolObjs) {
            long material = keycolObj.getLong("material");
            materialIds.add(material);
        }
        return materialIds;
    }

    private List<String> getCoMaterialKeycols(StandCostCalcParam calcParam) {
        QFilter filter = new QFilter("costtype", "=", (Object)calcParam.getCostTypeId());
        filter.and(new QFilter("keycol", "in", calcParam.getKeycols()));
        QFilter bomFilter = new QFilter("bom.iscoproduct", "=", (Object)"1");
        bomFilter.and("status", "=", (Object)"C");
        bomFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection bomSettingInfoList = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{filter, bomFilter});
        List bomIds = DynamicObjectHelper.getFieldList((DynamicObjectCollection)bomSettingInfoList, (String)"bom");
        bomFilter = new QFilter("id", "in", (Object)bomIds);
        ArrayList<String> coMaterialKeycols = new ArrayList<String>(10);
        DynamicObjectCollection bomInfoList = QueryServiceHelper.query((String)"cad_costbom", (String)"copentry.copentrykeycol copentrykeycol", (QFilter[])new QFilter[]{bomFilter});
        for (DynamicObject dynamicObject : bomInfoList) {
            coMaterialKeycols.add(dynamicObject.getString("copentrykeycol"));
        }
        return coMaterialKeycols;
    }

    private void getConfigBomInfoJsStrExt(StandCostCalcParam calcParam, Long manuOrg, Set<Long> materialIds, Date calcDate) {
        if (CadEmptyUtils.isEmpty(materialIds)) {
            return;
        }
        JSONArray array = new JSONArray();
        for (Long materialId : materialIds) {
            JSONObject json = new JSONObject();
            json.put("material", (Object)materialId);
            json.put("org", (Object)manuOrg);
            array.add((Object)json);
        }
        HashSet hasConfigMaterialId = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList<Long> configCodeIds = new ArrayList<Long>();
        try {
            logger.info("\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u5f00\u59cb\u3002\u53c2\u6570\uff1a\u751f\u4ea7\u7ec4\u7ec7\uff1a{}\uff0c\u7269\u6599\uff1a{}\u3002", (Object)manuOrg, materialIds);
            String jsonObjectString = (String)DispatchServiceHelper.invokeService((String)"zhny.mmc.pdm.servicehelper", (String)"pdm", (String)"ConfigCodeSearchService", (String)"getDefaultConfigCode", (Object[])new Object[]{array.toString()});
            logger.info("\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u7ed3\u675f\u3002\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)jsonObjectString);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonObjectString);
            JSONArray configList = (JSONArray)jsonObject.get((Object)"data");
            if (configList == null) {
                return;
            }
            for (int i = 0; i < configList.size(); ++i) {
                JSONObject config = (JSONObject)configList.get(i);
                Long configId = (Long)config.get((Object)"id");
                hasConfigMaterialId.add(config.getLong("material"));
                if (CadEmptyUtils.isEmpty(configId)) continue;
                configCodeIds.add(configId);
            }
            logger.info("\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u5b8c\u6210\u3002\u914d\u7f6e\u53f7\uff1a{}", configCodeIds);
        }
        catch (NumberFormatException e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u5931\u8d25\u3002", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u63a5\u53e3\u5931\u8d25\u3002", (String)"BOMExpand_13", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        materialIds.removeAll(hasConfigMaterialId);
        logger.info("BOMExpand hasConfigMaterialId:{}", (Object)hasConfigMaterialId);
        logger.info("BOMExpand materialIds:{}", materialIds);
        if (!materialIds.isEmpty()) {
            this.logErrorMaterialInfoForConfig(materialIds, ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u6ca1\u6709\u83b7\u53d6\u5230\u9ed8\u8ba4\u914d\u7f6e\u53f7\u3002", (String)"BOMExpand_14", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        if (CadEmptyUtils.isEmpty(configCodeIds)) {
            return;
        }
        int size = CadBgParamUtils.getCadParamForInt((String)"configBomMaxSize", (int)20000);
        if (configCodeIds.size() > size) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5377\u7b97\u7269\u6599\u83b7\u53d6\u9ed8\u8ba4\u7684\u914d\u7f6e\u53f7\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BOMExpand_15", (String)"macc-cad-algox", (Object[])new Object[]{size}));
        }
        logger.info("\u83b7\u53d6\u914d\u7f6ebom\u603b\u6570\u91cf,{}", (Object)configCodeIds.size());
        HashSet failMatId = Sets.newHashSetWithExpectedSize((int)16);
        int[] count = new int[]{1};
        calcParam.getManuOrgConfigBomInfoDataSet().put(manuOrg, null);
        int partitionSize = CadBgParamUtils.getCadParamForInt((String)"configBomPartitionSize", (int)200);
        Lists.partition(configCodeIds, (int)partitionSize).forEach(configCodeIdSubList -> {
            logger.info("\u89e3\u6790\u7b2c{}\u6279bom\u7ed3\u6784\u5f00\u59cb\u3002", (Object)count[0]);
            List configBomInfoJsStrExts = StdCalculateHelper.getConfigBomInfoJsStrNew((Long)manuOrg, (List)configCodeIdSubList, (Date)calcDate, (boolean)false, (Set)failMatId);
            for (String configBomInfoJsStrExt : configBomInfoJsStrExts) {
                if (CadEmptyUtils.isEmpty(configBomInfoJsStrExt)) continue;
                List<Object[]> objects = AnalysisBOMStructHelper.analysisBOMResultExt(calcParam, configBomInfoJsStrExt);
                DataSet configBomDataSet = AnalysisBOMStructHelper.creatConfigBomDataSet(objects);
                if (calcParam.getManuOrgConfigBomInfoDataSet().get(manuOrg) == null) {
                    calcParam.getManuOrgConfigBomInfoDataSet().put(manuOrg, configBomDataSet.distinct());
                    continue;
                }
                DataSet dataSet = calcParam.getManuOrgConfigBomInfoDataSet().get(manuOrg).union(configBomDataSet);
                calcParam.getManuOrgConfigBomInfoDataSet().put(manuOrg, dataSet);
            }
            logger.info("\u89e3\u6790\u7b2c{}\u6279bom\u7ed3\u6784\u7ed3\u675f\u3002", (Object)count[0]);
            count[0] = count[0] + 1;
        });
        if (failMatId.size() > 0) {
            this.logErrorMaterialInfoForConfig(failMatId, ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u6ca1\u6709\u83b7\u53d6\u5230\u9009\u914d\u6e05\u5355\u3002", (String)"BOMExpand_12", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
    }

    private void logErrorMaterialInfoForConfig(Set<Long> materialIds, String msg) {
        QFilter qf = new QFilter("id", "in", materialIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"macc-cad.BOMExpand", (String)"bd_material", (String)"number,name", (QFilter[])qf.toArray(), null);
        StringBuilder matMsg = new StringBuilder();
        while (ds.hasNext()) {
            Row row = ds.next();
            String number = row.getString("number");
            String name = row.getString("name");
            if (CadEmptyUtils.isEmpty(Collections.singleton(matMsg))) {
                matMsg.append(number).append('/').append(name);
                continue;
            }
            matMsg.append('\u3001').append(number).append('/').append(name);
        }
        logger.info("\u8c03\u7528\u63a5\u53e3\uff0c\u83b7\u53d6\u9ed8\u8ba4\u914d\u7f6e\u53f7\u5b8c\u6210\u3002\u7269\u6599\uff1a{}\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u9009\u914d\u6e05\u5355\u3002", (Object)matMsg);
        this.write2LogCustom(ResManager.loadKDString((String)"\u9ed8\u8ba4\u914d\u7f6e\u53f7\u5377\u7b97", (String)"BOMExpand_16", (String)"macc-cad-algox", (Object[])new Object[0]), String.format(msg, matMsg), Boolean.TRUE);
    }

    private Map<Integer, List<Material>> getScopeTypeAndMaterials(Long costTypeId, int scopeType, List<String> matEntryInfos, Long matGroupStd, Boolean configMat, Date calcDate, Boolean startRuleCalc) {
        HashMap<Integer, List<Material>> scopeTypeAndMaterials = new HashMap<Integer, List<Material>>(16);
        ArrayList<Material> materials = new ArrayList<Material>(200);
        if (scopeType == 1) {
            materials.addAll(this.getMaterials(matEntryInfos));
            materials.addAll(this.getMaterialByGroupIds(costTypeId, matEntryInfos, matGroupStd, configMat, calcDate, startRuleCalc));
        }
        scopeTypeAndMaterials.put(scopeType, materials);
        return scopeTypeAndMaterials;
    }

    private List<Material> getMaterials(List<String> matEntryInfos) {
        ArrayList<Material> materials = new ArrayList<Material>(matEntryInfos.size());
        if (CadEmptyUtils.isEmpty(matEntryInfos)) {
            return materials;
        }
        for (String matEntryInfo : matEntryInfos) {
            String matcalcprop;
            String[] split = matEntryInfo.split("@");
            if (CadEmptyUtils.isEmpty(split[0])) continue;
            Material material = new Material();
            material.setMaterialId(Long.parseLong(split[0]));
            if (!CadEmptyUtils.isEmpty(split[1])) {
                material.setIsuseauxpty(true);
                material.setAffectPrice(true);
                material.setMaterialAuxPropId(Long.parseLong(split[1]));
            }
            if (!CadEmptyUtils.isEmpty(split[2])) {
                material.setConfiguredcode(Long.parseLong(split[2]));
            }
            if (!CadEmptyUtils.isEmpty(split[3])) {
                material.setTracknumber(Long.parseLong(split[3]));
            }
            if (!CadEmptyUtils.isEmpty(split[4])) {
                material.setProject(Long.parseLong(split[4]));
            }
            if (!CadEmptyUtils.isEmpty(split[5])) {
                material.setLot(split[5]);
            }
            if ("B".equals(matcalcprop = split[6])) {
                material.setPurPrice(Boolean.TRUE);
            }
            material.setMaterialAttr(matcalcprop);
            material.setKeycol();
            materials.add(material);
        }
        return materials;
    }

    private List<Material> getMaterialByGroupIds(Long costTypeId, List<String> matEntryInfos, Long matGroupStdId, Boolean configMat, Date calcDate, Boolean startRuleCalc) {
        ArrayList<Material> materials = new ArrayList<Material>();
        if (CadEmptyUtils.isEmpty(matEntryInfos)) {
            return materials;
        }
        DynamicObject matGroupStd = BusinessDataServiceHelper.loadSingleFromCache((Object)matGroupStdId, (String)"bd_materialgroupstandard");
        DynamicObjectCollection matGroupItems = new DynamicObjectCollection();
        ArrayList<Long> matGroupIds = new ArrayList<Long>(10);
        for (String matEntryInfo : matEntryInfos) {
            String[] split = matEntryInfo.split("@");
            if (CadEmptyUtils.isEmpty(split[7])) continue;
            matGroupIds.add(Long.parseLong(split[7]));
        }
        DynamicObject[] dyos = BusinessDataServiceHelper.load((Object[])matGroupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_materialgroup"));
        matGroupItems.addAll(Arrays.asList(dyos));
        if (CadEmptyUtils.isEmpty(matGroupItems)) {
            return materials;
        }
        Set<Long> classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)matGroupItems, (boolean)false, (DynamicObject)matGroupStd);
        classifiedMaterialIds = this.getDetailMatIds(classifiedMaterialIds, configMat);
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("status", "=", (Object)"C");
        QFilter matFilter = new QFilter("material", "in", classifiedMaterialIds);
        Set<Long> productOrgs = kd.macc.cad.algox.calc.helper.StdCalculateHelper.getProductOrgsByImitateCostType(costTypeId, calcDate);
        Map<Long, String> matInfoMap = this.getMatInfoMap(productOrgs, classifiedMaterialIds);
        if (startRuleCalc.booleanValue()) {
            for (Long classifiedMaterialId : classifiedMaterialIds) {
                Material material = new Material();
                material.setMaterialId(classifiedMaterialId);
                material.setMaterialAttr(matInfoMap.get(classifiedMaterialId) == null ? "B" : matInfoMap.get(classifiedMaterialId));
                if ("B".equals(material.getMaterialAttr())) {
                    material.setPurPrice(Boolean.TRUE);
                }
                material.setKeycol();
                materials.add(material);
            }
        } else {
            DynamicObjectCollection bomSettingInfoList = QueryServiceHelper.query((String)"cad_bomsetting", (String)"material.id material,bomversion.id matversion,auxprop.id auxpty,configuredcode,tracknumber,project,lot,matcalcprop,material.isuseauxpty isuseauxpty,material.auxptyentry.isaffectprice isaffectprice,material.isenablematerialversion isenablematerialversion", (QFilter[])new QFilter[]{filter, matFilter});
            for (DynamicObject dynamicObject : bomSettingInfoList) {
                Material material = this.toMaterial(dynamicObject);
                String matcalcprop = dynamicObject.getString("matcalcprop");
                material.setMaterialAttr(matcalcprop);
                if ("B".equals(matcalcprop)) {
                    material.setPurPrice(Boolean.TRUE);
                }
                materials.add(material);
            }
        }
        return materials;
    }

    private Set<Long> getDetailMatIds(Set<Long> classifiedMaterialIds, Boolean configMat) {
        QFilter idFilter = new QFilter("id", "in", classifiedMaterialIds);
        if (configMat.booleanValue()) {
            idFilter.and(new QFilter("configproperties", "=", (Object)"2"));
        } else {
            idFilter.and(new QFilter("configproperties", "in", (Object)new String[]{"1", "3"}));
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bd_material", (String)"masterid", (QFilter[])new QFilter[]{idFilter});
        HashSet<Long> matIds = new HashSet<Long>(200);
        for (DynamicObject result : results) {
            matIds.add(result.getLong("masterid"));
        }
        return matIds;
    }

    private Map<Long, String> getMatInfoMap(Set<Long> productOrgs, Set<Long> ids) {
        QFilter orgFilter = new QFilter("createorg", "in", productOrgs);
        orgFilter.or(new QFilter("ctrlstrategy", "=", (Object)"5"));
        QFilter matInfoFilter = new QFilter("masterid", "in", ids);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"masterid,materialattr", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter});
        HashMap<Long, String> matInfoMap = new HashMap<Long, String>(16);
        for (DynamicObject result : results) {
            String materialAttr = result.getString("materialattr");
            if ("10030".equals(materialAttr)) {
                matInfoMap.put(result.getLong("masterid"), "A");
                continue;
            }
            if ("10040".equals(materialAttr)) {
                matInfoMap.put(result.getLong("masterid"), "B");
                continue;
            }
            if ("10050".equals(materialAttr)) {
                matInfoMap.put(result.getLong("masterid"), "C");
                continue;
            }
            if ("10020".equals(materialAttr)) {
                matInfoMap.put(result.getLong("masterid"), "D");
                continue;
            }
            matInfoMap.put(result.getLong("masterid"), "B");
        }
        return matInfoMap;
    }

    private Material toMaterial(DynamicObject dyo) {
        Material material = new Material();
        material.setMaterialId(dyo.getLong("material"));
        material.setConfiguredcode(dyo.getLong("configuredcode"));
        material.setIsuseauxpty(dyo.getBoolean("isuseauxpty"));
        material.setAffectPrice(dyo.getBoolean("isaffectprice"));
        if (material.isIsuseauxpty() && material.isAffectPrice()) {
            material.setMaterialAuxPropId(dyo.getLong("auxpty"));
        }
        material.setTracknumber(dyo.getLong("tracknumber"));
        material.setLot(dyo.getString("lot"));
        material.setProject(dyo.getLong("project"));
        material.setKeycol();
        return material;
    }
}

