/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.Data.BOMExpandNode;
import kd.macc.cad.algox.Data.CalculationNode;
import kd.macc.cad.algox.Data.CalculationNodeSubElement;
import kd.macc.cad.algox.Data.CalculationTree;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;

public class CalculationTreeInitial {
    private static final Log LOGGER = LogFactory.getLog(CalculationTreeInitial.class);
    private CalcStandCostCalcParam standCostCalcParam = null;

    public CalcStandCostCalcParam getStandCostCalcParam() {
        return this.standCostCalcParam;
    }

    public void setStandCostCalcParam(CalcStandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public CalculationTree init(Iterable<RowX> rowXIterable) {
        HashMap<String, CalculationTree> treeMap = new HashMap<String, CalculationTree>();
        CalculationTree tree1 = null;
        BOMExpandNode node = null;
        int count = 0;
        HashSet<Long> bomSettingSet = new HashSet<Long>();
        for (RowX rowX : rowXIterable) {
            long nodeId = rowX.getLong(0);
            if (node == null || node.getNodeId() != nodeId) {
                node = CalculationNode.fromRowX(rowX, this.standCostCalcParam == null || this.standCostCalcParam.isUseMatVersion());
                String[] pathArr = node.getBomTreePath().split("@");
                String rootId = pathArr[0];
                if (treeMap.containsKey(rootId)) {
                    tree1 = (CalculationTree)treeMap.get(rootId);
                } else {
                    tree1 = new CalculationTree();
                    treeMap.put(rootId, tree1);
                }
                node.setBomTreeRootId(Long.parseLong(rootId));
                tree1.appendRow((CalculationNode)node);
            }
            int i = 28;
            if (node.getNodeType() == 20) {
                CalculationNodeSubElement subElement = new CalculationNodeSubElement();
                subElement.setElement(rowX.getLong(i++));
                subElement.setSubElement(rowX.getLong(i++));
                subElement.setQty(rowX.getBigDecimal(i++));
                subElement.setPrice(rowX.getBigDecimal(i++));
                subElement.setCost(rowX.getBigDecimal(i++));
                subElement.setType(rowX.getInteger(i++));
                subElement.setActivityId(rowX.getLong(i++));
                subElement.setCalcbasis(rowX.getString(i++));
                long materialId = rowX.getLong(i++);
                if (materialId != 0L) {
                    Material m2 = new Material();
                    m2.setMaterialId(materialId);
                    m2.setMaterialAuxPropId(rowX.getLong(i++));
                    m2.setMaterialVer(rowX.getLong(i));
                    if (this.standCostCalcParam != null && !this.standCostCalcParam.isUseMatVersion()) {
                        m2.setMaterialVer(0L);
                    }
                    subElement.setMaterial(m2);
                }
                ((CalculationNode)node).getSubElementList().add(subElement);
            } else if (node.getBomSettingID() > 0L) {
                bomSettingSet.add(node.getBomSettingID());
            }
            ++count;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u8f93\u5165bom\u6570\u636e%s\u884c", (String)"CalculationTreeInitial_0", (String)"macc-cad-algox", (Object[])new Object[0]), count), new Boolean[0]);
        CalculationTree mainTree = null;
        HashSet<CalculationTree> partTreeSet = new HashSet<CalculationTree>();
        for (CalculationTree tree : treeMap.values()) {
            tree.buildTree();
            if (tree.getRoot() == null) {
                return null;
            }
            if (!tree.getRoot().isPart()) {
                mainTree = tree;
                continue;
            }
            partTreeSet.add(tree);
        }
        if (mainTree != null) {
            if (partTreeSet.size() > 0) {
                this.mergePartTree(mainTree, partTreeSet);
                this.write2Log(String.format(ResManager.loadKDString((String)"\u975e\u516c\u5171\u4ef6\u6811\u6784\u5efa,\u516c\u5171\u4ef6%s\u4e2a", (String)"CalculationTreeInitial_1", (String)"macc-cad-algox", (Object[])new Object[0]), partTreeSet.size()), new Boolean[0]);
            } else {
                this.write2Log(ResManager.loadKDString((String)"\u975e\u516c\u5171\u4ef6\u6811\u6784\u5efa,\u65e0\u516c\u5171\u4ef6", (String)"CalculationTreeInitial_2", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
            }
        } else {
            Iterator<Object> iterator = partTreeSet.iterator();
            while (iterator.hasNext()) {
                CalculationTree tree;
                mainTree = tree = (CalculationTree)iterator.next();
            }
            this.write2Log(ResManager.loadKDString((String)"\u516c\u5171\u4ef6\u6811\u6784\u5efa", (String)"CalculationTreeInitial_3", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
        }
        if (mainTree != null) {
            mainTree.getBomSetting(bomSettingSet);
            this.write2Log(ResManager.loadKDString((String)"\u83b7\u53d6bom\u8bbe\u7f6e\u4fe1\u606f", (String)"CalculationTreeInitial_4", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
        }
        return mainTree;
    }

    private void mergePartTree(CalculationTree mainTree, Set<CalculationTree> partTrees) {
        for (CalculationTree partTree : partTrees) {
            for (CalculationNode node : mainTree.getNodeList()) {
                if (node.getExpandBomId() == 0L || node.getExpandBomId() != partTree.getRoot().getBomId()) continue;
                this.copySubNodes(partTree.getRoot(), node);
                for (CalculationNodeSubElement subElement : partTree.getRoot().getSubElementList()) {
                    node.getSubElementList().add(subElement.copy());
                }
            }
        }
    }

    private void copySubNodes(CalculationNode fromNode, CalculationNode toNode) {
        toNode.setCalculated(true);
        List<CalculationNode> subNodes = fromNode.getSubNodes();
        for (CalculationNode subNode : subNodes) {
            CalculationNode copyNode = subNode.copy();
            toNode.getSubNodes().add(copyNode);
            copyNode.setBomTreeRootId(toNode.getBomTreeRootId());
            copyNode.appendToParent(toNode, toNode.getLevel() + 1);
            this.copySubNodes(subNode, copyNode);
        }
    }

    private void write2Log(String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            LOGGER.info(String.format("\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u8d39\u6210\u672c:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u8d39\u6210\u672c", (String)"CalculationTreeInitial_6", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }
}

