/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.DatSetXUtils;

public class CostCenterCalculateFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String OPERATOR = "+-*/()";
    private static final String DIGITAL = "DIGITAL";
    private static final String FIRST_MUL_VALUE = "(case when (firstValue * value) != null then (firstValue * value) else 0 end) as value";
    private static final String FIRST_DIV_VALUE = "(case when value != 0 and (firstValue / value) != null then (firstValue / value) else 0 end) as value";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;

    public CostCenterCalculateFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, null, this.rowMeta);
        List postfixExp = (List)this.paramMap.get("exp");
        boolean enableMulFactory = (Boolean)this.paramMap.get("enableMulFactory");
        Stack<DataSet> opDsStack = new Stack<DataSet>();
        Stack opTypeAndNumberStack = new Stack();
        DataSet opResult = null;
        for (String number : postfixExp) {
            if (OPERATOR.indexOf(number) >= 0) {
                DataSet secondDs = (DataSet)opDsStack.pop();
                Map secondTypeMap = (Map)opTypeAndNumberStack.pop();
                String secondType = "";
                double secondValue = 0.0;
                for (Map.Entry entry : secondTypeMap.entrySet()) {
                    secondType = (String)entry.getKey();
                    secondValue = (Double)entry.getValue();
                }
                DataSet firstDs = (DataSet)opDsStack.pop();
                Map firstTypeMap = (Map)opTypeAndNumberStack.pop();
                String firstType = "";
                double firstValue = 0.0;
                for (Map.Entry entry : firstTypeMap.entrySet()) {
                    firstType = (String)entry.getKey();
                    firstValue = (Double)entry.getValue();
                }
                firstDs = firstDs.executeSql("select org,manuorg,costcenter,benefcostcenter,value as firstValue");
                HashMap opResultTypeMap = new HashMap(16);
                switch (number) {
                    case "+": {
                        opResult = CostCenterCalculateFunction.doAddOnCostCenter(firstDs, secondDs, enableMulFactory);
                        break;
                    }
                    case "-": {
                        opResult = CostCenterCalculateFunction.doSubtractOnCostCenter(firstDs, secondDs, enableMulFactory);
                        break;
                    }
                    case "*": {
                        if (firstType.equals(DIGITAL)) {
                            opResult = this.doMultiplyOnDigToCostCenter(secondDs, firstValue, false);
                            break;
                        }
                        if (secondType.equals(DIGITAL)) {
                            opResult = this.doMultiplyOnDigToCostCenter(firstDs, secondValue, true);
                            break;
                        }
                        opResult = CostCenterCalculateFunction.doMultiplyOnCostCenter(firstDs, secondDs, enableMulFactory);
                        break;
                    }
                    case "/": {
                        if (secondType.equals(DIGITAL)) {
                            opResult = this.doDivideOnDigToCostCenter(firstDs, secondValue);
                            break;
                        }
                        opResult = CostCenterCalculateFunction.doDivideOnCostCenter(firstDs, secondDs, enableMulFactory);
                        break;
                    }
                }
                if (opResult == null) continue;
                opDsStack.push(opResult);
                opTypeAndNumberStack.add(opResultTypeMap);
                continue;
            }
            DataSet diyCostDriverDs = ds.copy().filter("costdriver = " + number);
            boolean isExist = false;
            if (CostCenterCalculateFunction.isInteger(number)) {
                isExist = QueryServiceHelper.exists((String)"cad_costdriver", (Object)Long.parseLong(number));
            }
            HashMap<String, Double> typeMap = new HashMap<String, Double>(16);
            if (!isExist && CostCenterCalculateFunction.isNumeric(number)) {
                typeMap.put(DIGITAL, Double.parseDouble(number));
            }
            opTypeAndNumberStack.push(typeMap);
            opDsStack.push(diyCostDriverDs);
        }
        if (opResult != null) {
            for (Row row : opResult) {
                RowX targetRow = new RowX(this.rowMeta.getFieldCount());
                targetRow.set(this.rowMeta.getFieldIndex("org"), row.get("org"));
                if (enableMulFactory) {
                    targetRow.set(this.rowMeta.getFieldIndex("manuorg"), row.get("manuorg"));
                }
                targetRow.set(this.rowMeta.getFieldIndex("costcenter"), row.get("costcenter"));
                targetRow.set(this.rowMeta.getFieldIndex("benefcostcenter"), row.get("benefcostcenter"));
                targetRow.set(this.rowMeta.getFieldIndex("value"), (Object)(row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value")));
                collector.collect(targetRow);
            }
        }
    }

    public static boolean isInteger(String str) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    private DataSet doDivideOnDigToCostCenter(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, manuorg, costcenter, benefcostcenter,firstValue / " + opValue + " as value") : opDs.executeSql("select org, manuorg, costcenter, benefcostcenter,0 as value");
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostCenter(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, manuorg, costcenter, benefcostcenter," + opValue + " * firstValue as value" : "select org, manuorg, costcenter, benefcostcenter," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private static DataSet doSubtractOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish() : firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doAddOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet rightDs;
        DataSet leftDs;
        if (enableMulFactory) {
            leftDs = secondDs.leftJoin(firstDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "firstValue + value  as value"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "firstValue + value as value"}).finish();
        } else {
            leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0 as manuorg", "costcenter", "benefcostcenter", "firstValue + value  as value"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0 as manuorg", "costcenter", "benefcostcenter", "firstValue + value as value"}).finish();
        }
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMultiplyOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet rightDs;
        DataSet leftDs;
        if (enableMulFactory) {
            leftDs = secondDs.leftJoin(firstDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        } else {
            leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0 as manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0 as manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        }
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doDivideOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", FIRST_DIV_VALUE}).finish() : firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0 as manuorg", "costcenter", "benefcostcenter", FIRST_DIV_VALUE}).finish();
        return opResult;
    }
}

