/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.DatSetXUtils;
import kd.macc.cad.algox.utils.FormulaUtil;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectCalculateFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String OPERATOR = "+-*/()";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIAL = "MATERIAL";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String DIGITAL = "DIGITAL";
    private static final String ENTITY_DIYCOSTDRIVER = "sca_diycostdriver";
    private static final String FIRST_MUL_VALUE = "(case when (firstvalue * value) != null then (firstvalue * value) else 0 end) as value";
    private static final String FIRST_DIV_VALUE = "(case when value != 0 and (firstvalue / value) != null then (firstvalue / value) else 0 end) as value";
    private static final String DIV_VALUE = "(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;
    private boolean isMatGroupCal = true;

    public CostObjectCalculateFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, null, this.rowMeta);
        List postfixExp = (List)this.paramMap.get("exp");
        List materialGroup = (List)this.paramMap.get("materialGroup");
        List materials = (List)this.paramMap.get("material");
        Set costTypeIds = (Set)this.paramMap.get("costTypeIds");
        long simulCostTypeId = this.paramMap.get("simulCostTypeId") == null ? 0L : (Long)this.paramMap.get("simulCostTypeId");
        long orgId = (Long)this.paramMap.get("orgId");
        long costAccountId = (Long)this.paramMap.get("costAccountId");
        long periodId = (Long)this.paramMap.get("periodId");
        String appId = (String)this.paramMap.get("appId");
        Map hsCostTypeByOrg = (Map)this.paramMap.get("hsCostTypeByOrg");
        boolean enableMulFactory = (Boolean)this.paramMap.get("enableMulFactory");
        Set costObjectIdSet = (Set)this.paramMap.get("costObjectId");
        Stack<DataSet> opDsStack = new Stack<DataSet>();
        Stack opTypeAndNumberStack = new Stack();
        DataSet opResult = null;
        for (String number : postfixExp) {
            DataSet diyCostDriverDs;
            if (OPERATOR.indexOf(number) >= 0) {
                String firstType = "";
                String secondType = "";
                DataSet secondDs = (DataSet)opDsStack.pop();
                Map secondTypeMap = (Map)opTypeAndNumberStack.pop();
                double secondValue = 0.0;
                for (Map.Entry entry : secondTypeMap.entrySet()) {
                    secondType = (String)entry.getKey();
                    secondValue = (Double)entry.getValue();
                }
                DataSet firstDs = (DataSet)opDsStack.pop();
                Map firstTypeMap = (Map)opTypeAndNumberStack.pop();
                double firstvalue = 0.0;
                for (Map.Entry entry : firstTypeMap.entrySet()) {
                    firstType = (String)entry.getKey();
                    firstvalue = (Double)entry.getValue();
                    switch (firstType) {
                        case "COSTCENTER": {
                            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,benefcostcenter,value as firstvalue,billtypenum");
                            break;
                        }
                        case "COSTOBJECT": {
                            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value as firstvalue,billtypenum");
                            break;
                        }
                        case "MATERIAL": {
                            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,value as firstvalue,billtypenum");
                            break;
                        }
                        case "MATERIALGROUP": {
                            firstDs = firstDs.executeSql("select id,billno,org,costcenter,materialgroup,value as firstvalue,billtypenum");
                            break;
                        }
                    }
                }
                Map<Object, Object> opResultTypeMap = new HashMap(16);
                block18 : switch (number) {
                    case "+": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = this.doAddOnCostCenter(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(COSTCENTER);
                                break block18;
                            }
                            case "COSTOBJECT": {
                                opResult = this.doAddOnCostObject(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break block18;
                            }
                            case "MATERIAL": {
                                opResult = this.doAddOnMaterial(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(MATERIAL);
                                break block18;
                            }
                        }
                        break;
                    }
                    case "-": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = this.doSubtractOnCostCenter(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(COSTCENTER);
                                break block18;
                            }
                            case "COSTOBJECT": {
                                opResult = this.doSubtractOnCostObject(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break block18;
                            }
                            case "MATERIAL": {
                                opResult = this.doSubtractOnMaterial(firstDs, secondDs, enableMulFactory);
                                opResultTypeMap = this.buildResultType(MATERIAL);
                                break block18;
                            }
                        }
                        break;
                    }
                    case "*": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = this.doMultiplyOnCostCenter(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTCENTER);
                                    break block18;
                                }
                                case "COSTOBJECT": {
                                    opResult = this.doMultiplyOnCostObject(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                    break block18;
                                }
                                case "MATERIAL": {
                                    opResult = this.doMultiplyOnMaterial(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(MATERIAL);
                                    break block18;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToCenter(secondDs, firstDs, true, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostCenter(firstDs, secondValue, true);
                                opResultTypeMap = this.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToCenter(firstDs, secondDs, false, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToMaterial(firstDs, secondDs, enableMulFactory, false);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (MATERIALGROUP.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToMaterialGroup(firstDs, secondDs, false);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostObject(firstDs, secondValue, true);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doMulOnCostObjectToMaterial(secondDs, firstDs, enableMulFactory, true);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(firstDs, secondValue, true);
                                opResultTypeMap = this.buildResultType(MATERIAL);
                                break;
                            }
                            case "MATERIALGROUP": {
                                if (!COSTOBJECT.equals(secondType)) break;
                                opResult = this.doMulOnCostObjectToMaterialGroup(secondDs, firstDs, true);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "DIGITAL": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostCenter(secondDs, firstvalue, false);
                                    opResultTypeMap = this.buildResultType(COSTCENTER);
                                }
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostObject(secondDs, firstvalue, false);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!MATERIAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(secondDs, firstvalue, false);
                                opResultTypeMap = this.buildResultType(MATERIAL);
                                break;
                            }
                        }
                        break;
                    }
                    case "/": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = this.doDivideOnCostCenter(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTCENTER);
                                    break block18;
                                }
                                case "COSTOBJECT": {
                                    opResult = this.doDivisideOnCostObject(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                    break block18;
                                }
                                case "MATERIAL": {
                                    opResult = this.doDivisideOnMaterial(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(MATERIAL);
                                    break block18;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doDivOnCostCenterToObject(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToCostCenter(firstDs, secondValue);
                                opResultTypeMap = this.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = this.doDivOnCostObjectToCenter(firstDs, secondDs, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = this.doDivOnCostObjectToMaterial(firstDs, secondDs, false, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (DIGITAL.equals(secondType)) {
                                    opResult = this.doDivideOnDigToCostObject(firstDs, secondValue);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!MATERIALGROUP.equals(secondType)) break;
                                opResult = this.doDivOnCostObjectToMaterialGroup(firstDs, secondDs, false);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doDivOnCostObjectToMaterial(secondDs, firstDs, true, enableMulFactory);
                                    opResultTypeMap = this.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToMaterial(firstDs, secondValue);
                                opResultTypeMap = this.buildResultType(MATERIAL);
                                break;
                            }
                            case "MATERIALGROUP": {
                                if (!COSTOBJECT.equals(secondType)) break;
                                opResult = this.doDivOnCostObjectToMaterialGroup(secondDs, firstDs, true);
                                opResultTypeMap = this.buildResultType(COSTOBJECT);
                                break;
                            }
                        }
                        break;
                    }
                }
                if (opResult == null) continue;
                opDsStack.push(opResult);
                opTypeAndNumberStack.add(opResultTypeMap);
                continue;
            }
            Map<String, Double> typeMap = new HashMap<String, Double>(16);
            if (this.isInteger(number) && materials.contains(Long.valueOf(number))) {
                QFilter dateFilter;
                QFilter costTypeFilter;
                if (String.valueOf(CostDriverIdConstant.STANDARD_COST_SCA).equals(number)) {
                    costTypeFilter = new QFilter("costtype", "in", (Object)costTypeIds);
                    dateFilter = FormulaUtil.getEffectDateFilter(periodId);
                    diyCostDriverDs = QueryServiceHelper.queryDataSet((String)"getmatcostinfo", (String)"cad_matcostinfo", (String)"id,costtype,material,configuredcode,tracknumber,auxpty as materialauxpty,entryentity.standardcost value", (QFilter[])new QFilter[]{costTypeFilter, dateFilter}, null);
                    if (enableMulFactory) {
                        ArrayList lists = Lists.newArrayList();
                        hsCostTypeByOrg.forEach((x, y) -> lists.add(new Object[]{x, y}));
                        DataSet manuCostTypeDs = Algo.create((String)"CostObjectCalculateFunction.CreateMat").createDataSet(lists.iterator(), new RowMeta(new Field[]{new Field("manuorg", (DataType)DataType.LongType), new Field("costtype", (DataType)DataType.LongType)}));
                        diyCostDriverDs = diyCostDriverDs.join(manuCostTypeDs, JoinType.INNER).on("costtype", "costtype").select(new String[]{"id", "material", "configuredcode", "tracknumber", "materialauxpty", "value"}, new String[]{"manuorg"}).finish();
                    } else {
                        diyCostDriverDs = diyCostDriverDs.addField("0L", "manuorg");
                    }
                    diyCostDriverDs = diyCostDriverDs.select(CostDriverIdConstant.STANDARD_COST_SCA + " as costdriver,id,'' as billno," + orgId + " as org,manuorg,0L as costcenter,material,materialauxpty,configuredcode,tracknumber,value,'cad_matcostinfo' as billtypenum");
                } else if (String.valueOf(CostDriverIdConstant.STANDARD_COST_ACA).equals(number)) {
                    costTypeFilter = new QFilter("costtype", "in", (Object)simulCostTypeId);
                    dateFilter = FormulaUtil.getEffectDateFilter(periodId);
                    diyCostDriverDs = QueryServiceHelper.queryDataSet((String)"getmatcostinfo", (String)"cad_matcostinfo", (String)"id,material,configuredcode,tracknumber,auxpty as materialauxpty,entryentity.standardcost value", (QFilter[])new QFilter[]{costTypeFilter, dateFilter}, null);
                    diyCostDriverDs = diyCostDriverDs.select(CostDriverIdConstant.STANDARD_COST_ACA + " as costdriver,id,'' as billno," + orgId + " as org,0L as manuorg,0L as costcenter,material,materialauxpty,configuredcode,tracknumber,value,'cad_matcostinfo' as billtypenum");
                } else {
                    String algoKey = "kd.macc.cad.algox.function.CostObjectCalculateFunction#reduce";
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    filters.add(orgFilter);
                    filters.add(new QFilter("appnum", "=", (Object)appId));
                    filters.add(new QFilter("costdriver.id", "=", (Object)Long.parseLong(number)));
                    filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                    filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                    filters.add(FormulaUtil.getEffectDateFilter(periodId));
                    String selectFields = "aca".equals(appId) ? "costdriver,id,billno,org,manuorg,costcenter,entryentity.matnum as material,entryentity.matauxpty as materialauxpty,0L as configuredcode,0L as tracknumber,entryentity.entryqty as value" : "costdriver,id,billno,org,manuorg,costcenter,entryentity.matnum as material,entryentity.matauxpty as materialauxpty,entryentity.configuredcode as configuredcode,entryentity.tracknumber as tracknumber,entryentity.entryqty as value";
                    diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_DIYCOSTDRIVER, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
                    diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber").addField("'sca_diycostdriver'", "billtypenum");
                }
                typeMap = this.buildResultType(MATERIAL);
            } else if (this.isInteger(number) && materialGroup.contains(number)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("org", "=", (Object)orgId));
                filters.add(new QFilter("appnum", "=", (Object)appId));
                filters.add(new QFilter("costdriver.id", "=", (Object)Long.parseLong(number)));
                filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                filters.add(FormulaUtil.getEffectDateFilter(periodId));
                diyCostDriverDs = QueryServiceHelper.queryDataSet((String)"CostObjectCalculateFunction#getMatGroup", (String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.materialgroup as materialgroup,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,id,billno,org,manuorg,costcenter,materialgroup,sum(value) value group by costdriver,org,id,billno,org,manuorg,costcenter,materialgroup").addField("'sca_diycostdriver'", "billtypenum");
                if (this.paramMap.get(number) != null) {
                    this.isMatGroupCal = (Boolean)this.paramMap.get(number);
                }
                typeMap = this.buildResultType(MATERIALGROUP);
            } else {
                diyCostDriverDs = ds.copy().filter("costdriver = " + number);
                boolean isExist = false;
                if (this.isInteger(number)) {
                    isExist = QueryServiceHelper.exists((String)"cad_costdriver", (Object)Long.parseLong(number));
                }
                if (isExist) {
                    if (!CadEmptyUtils.isEmpty(costObjectIdSet) && costObjectIdSet.contains(Long.parseLong(number))) {
                        typeMap = this.buildResultType(COSTOBJECT);
                    } else {
                        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(number));
                        DynamicObject costDriverObject = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"allocclass", (QFilter[])qFilter.toArray());
                        if (costDriverObject != null) {
                            String allocClass = costDriverObject.getString("allocclass");
                            typeMap = this.buildResultType(allocClass);
                        }
                    }
                } else if (this.isNumeric(number)) {
                    typeMap.put(DIGITAL, Double.parseDouble(number));
                }
            }
            opTypeAndNumberStack.push(typeMap);
            opDsStack.push(diyCostDriverDs);
        }
        if (opResult != null) {
            for (Row row : opResult) {
                RowX targetRow = new RowX(this.rowMeta.getFieldCount());
                targetRow.set(this.rowMeta.getFieldIndex("org"), row.get("org"));
                if (enableMulFactory) {
                    targetRow.set(this.rowMeta.getFieldIndex("manuorg"), row.get("manuorg"));
                }
                targetRow.set(this.rowMeta.getFieldIndex("costcenter"), row.get("costcenter"));
                targetRow.set(this.rowMeta.getFieldIndex("costobject"), row.get("costobject"));
                targetRow.set(this.rowMeta.getFieldIndex("material"), row.get("material"));
                targetRow.set(this.rowMeta.getFieldIndex("value"), (Object)(row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value")));
                collector.collect(targetRow);
            }
        }
    }

    private boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean isSameType(String firstType, String secondType) {
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{firstType, secondType})) {
            return StringUtils.equals((CharSequence)firstType, (CharSequence)secondType);
        }
        return false;
    }

    private Map<String, Double> buildResultType(String type) {
        HashMap<String, Double> resultType = new HashMap<String, Double>();
        switch (type) {
            case "COSTCENTER": {
                resultType.put(COSTCENTER, 0.0);
                break;
            }
            case "COSTOBJECT": {
                resultType.put(COSTOBJECT, 0.0);
                break;
            }
            case "MATERIALGROUP": {
                resultType.put(MATERIALGROUP, 0.0);
                break;
            }
            case "MATERIAL": {
                resultType.put(MATERIAL, 0.0);
                break;
            }
        }
        return resultType;
    }

    private void saveMaterialGroupFormulaCalcReport(DataSet opResult, String exp) {
        boolean isDisableAllocCalcReport = (Boolean)this.paramMap.get("isDisableAllocCalcReport");
        if (!isDisableAllocCalcReport) {
            return;
        }
        long allocCalcReportId = (Long)this.paramMap.get("allocCalcReportId");
        DynamicObject reportEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)allocCalcReportId, (String)"cad_alloccalcreport");
        DynamicObjectCollection entryEntity = reportEntity.getDynamicObjectCollection("entryentity");
        int seq = entryEntity.size();
        for (Row row : opResult.copy()) {
            DynamicObject entity;
            boolean isInterSectData;
            Long firstId = row.getLong("firid");
            Long secondId = row.getLong("secid");
            boolean isFirstData = firstId != null && firstId != 0L;
            boolean isSecondData = secondId != null && secondId != 0L;
            boolean bl = isInterSectData = isFirstData && isSecondData;
            if (isFirstData && firstId != -1L) {
                entity = entryEntity.addNew();
                entity.set("costobject", (Object)row.getLong("costobject"));
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("bizbillid", (Object)firstId);
                entity.set("billnumber", (Object)row.getString("firbillno"));
                entity.set("allocvalue", (Object)row.getBigDecimal("firvalue"));
                entity.set("billtypenum", (Object)row.getString("firbilltypenum"));
                entity.set("calcresult", (Object)String.format("%s / %s = %s", this.dealScale(row.getBigDecimal("origfirstvalue")), this.dealScale(row.getBigDecimal("totalvalue")), this.dealScale(row.getBigDecimal("firvalue"))));
                entity.set("seq", (Object)seq++);
            }
            if (isSecondData && secondId != -1L) {
                entity = entryEntity.addNew();
                entity.set("costobject", (Object)row.getLong("costobject"));
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("bizbillid", (Object)secondId);
                entity.set("billnumber", (Object)row.getString("secbillno"));
                entity.set("allocvalue", (Object)row.getBigDecimal("secvalue"));
                entity.set("billtypenum", (Object)row.getString("secbilltypenum"));
                entity.set("seq", (Object)seq++);
            }
            if (!isInterSectData) continue;
            entity = entryEntity.addNew();
            entity.set("costobject", (Object)row.getLong("costobject"));
            entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
            entity.set("allocvalue", (Object)row.getBigDecimal("value"));
            entity.set("calcresult", (Object)String.format("%s %s %s = %s", this.dealScale(row.getBigDecimal("firvalue")), exp, this.dealScale(row.getBigDecimal("secvalue")), this.dealScale(row.getBigDecimal("value"))));
            entity.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportEntity});
    }

    private void saveDivFormulaCalcReport(DataSet opResult, String exp) {
        boolean isDisableAllocCalcReport = (Boolean)this.paramMap.get("isDisableAllocCalcReport");
        if (!isDisableAllocCalcReport) {
            return;
        }
        long allocCalcReportId = (Long)this.paramMap.get("allocCalcReportId");
        DynamicObject reportEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)allocCalcReportId, (String)"cad_alloccalcreport");
        DynamicObjectCollection entryEntity = reportEntity.getDynamicObjectCollection("entryentity");
        int seq = entryEntity.size();
        HashSet<String> hasAddEntryKey = new HashSet<String>(256);
        StringBuilder sb = new StringBuilder();
        long preCostObject = 0L;
        HashMap<Long, BigDecimal> firstValueMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> secondValueMap = new HashMap<Long, BigDecimal>(16);
        long costCenterId = 0L;
        for (Row row : opResult.copy()) {
            Long firstId = row.getLong("firid");
            Long secondId = row.getLong("secid");
            boolean isFirstData = firstId != null && firstId != 0L;
            boolean isSecondData = secondId != null && secondId != 0L;
            long costObjectId = row.getLong("costobject");
            if (preCostObject == 0L) {
                preCostObject = costObjectId;
            }
            if (preCostObject != costObjectId && !CadEmptyUtils.isEmpty(firstValueMap) && !CadEmptyUtils.isEmpty(secondValueMap)) {
                long finalCostObjectId = (Long)firstValueMap.keySet().iterator().next();
                BigDecimal firstValue = (BigDecimal)firstValueMap.values().iterator().next();
                BigDecimal secondValue = (BigDecimal)secondValueMap.values().iterator().next();
                BigDecimal allocValue = secondValue == null || secondValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : firstValue.divide(secondValue, RoundingMode.HALF_UP);
                DynamicObject entity = entryEntity.addNew();
                entity.set("costobject", (Object)finalCostObjectId);
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("allocvalue", (Object)allocValue);
                entity.set("calcresult", (Object)String.format("%s %s %s = %s", this.dealScale(firstValue), exp, this.dealScale(secondValue), this.dealScale(allocValue)));
                entity.set("seq", (Object)seq++);
                firstValueMap.clear();
                secondValueMap.clear();
                preCostObject = costObjectId;
            }
            if (isFirstData && firstId != -1L) {
                sb.append(row.getLong("costobject")).append("@").append(firstId);
                if (!hasAddEntryKey.contains(sb.toString())) {
                    DynamicObject entity = entryEntity.addNew();
                    entity.set("costobject", (Object)row.getLong("costobject"));
                    entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                    entity.set("bizbillid", (Object)firstId);
                    entity.set("billnumber", (Object)row.getString("firbillno"));
                    entity.set("allocvalue", (Object)row.getBigDecimal("firvalue"));
                    entity.set("billtypenum", (Object)row.getString("firbilltypenum"));
                    entity.set("seq", (Object)seq++);
                    hasAddEntryKey.add(sb.toString());
                    if (preCostObject == costObjectId) {
                        if (firstValueMap.get(costObjectId) != null) {
                            firstValueMap.put(costObjectId, ((BigDecimal)firstValueMap.get(costObjectId)).add(row.getBigDecimal("firvalue")));
                        } else {
                            firstValueMap.put(costObjectId, row.getBigDecimal("firvalue"));
                        }
                    }
                }
                sb.setLength(0);
            }
            if (!isSecondData || secondId == -1L) continue;
            sb.append(row.getLong("costobject")).append("@").append(secondId);
            if (!hasAddEntryKey.contains(sb.toString())) {
                costCenterId = row.getLong("costcenter");
                DynamicObject entity = entryEntity.addNew();
                entity.set("costobject", (Object)row.getLong("costobject"));
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("bizbillid", (Object)secondId);
                entity.set("billnumber", (Object)row.getString("secbillno"));
                entity.set("allocvalue", (Object)row.getBigDecimal("secvalue"));
                entity.set("billtypenum", (Object)row.getString("secbilltypenum"));
                entity.set("seq", (Object)seq++);
                hasAddEntryKey.add(sb.toString());
                if (preCostObject == costObjectId) {
                    if (secondValueMap.get(costObjectId) != null) {
                        secondValueMap.put(costObjectId, ((BigDecimal)secondValueMap.get(costObjectId)).add(row.getBigDecimal("secvalue")));
                    } else {
                        secondValueMap.put(costObjectId, row.getBigDecimal("secvalue"));
                    }
                }
            }
            sb.setLength(0);
        }
        if (!CadEmptyUtils.isEmpty(firstValueMap) && !CadEmptyUtils.isEmpty(secondValueMap)) {
            long finalCostObjectId = (Long)firstValueMap.keySet().iterator().next();
            BigDecimal firstValue = (BigDecimal)firstValueMap.values().iterator().next();
            BigDecimal secondValue = (BigDecimal)secondValueMap.values().iterator().next();
            BigDecimal allocValue = secondValue == null || secondValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : firstValue.divide(secondValue, RoundingMode.HALF_UP);
            DynamicObject entity = entryEntity.addNew();
            entity.set("costobject", (Object)finalCostObjectId);
            entity.set("benefcostcenter", (Object)costCenterId);
            entity.set("allocvalue", (Object)allocValue);
            entity.set("calcresult", (Object)String.format("%s %s %s = %s", this.dealScale(firstValue), exp, this.dealScale(secondValue), this.dealScale(allocValue)));
            entity.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportEntity});
    }

    private void saveFormulaCalcReport(DataSet opResult, String exp, boolean isNumeric) {
        boolean isDisableAllocCalcReport = (Boolean)this.paramMap.get("isDisableAllocCalcReport");
        if (!isDisableAllocCalcReport) {
            return;
        }
        long allocCalcReportId = (Long)this.paramMap.get("allocCalcReportId");
        DynamicObject reportEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)allocCalcReportId, (String)"cad_alloccalcreport");
        DynamicObjectCollection entryEntity = reportEntity.getDynamicObjectCollection("entryentity");
        int seq = entryEntity.size();
        for (Row row : opResult.copy()) {
            DynamicObject entity;
            boolean isInterSectData;
            if (isNumeric) {
                DynamicObject entity2 = entryEntity.addNew();
                entity2.set("costobject", (Object)row.getLong("costobject"));
                entity2.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity2.set("bizbillid", (Object)row.getLong("id"));
                entity2.set("billnumber", (Object)row.getString("billno"));
                entity2.set("allocvalue", (Object)row.getBigDecimal("value"));
                entity2.set("billtypenum", (Object)row.getString("billtypenum"));
                entity2.set("seq", (Object)seq++);
                continue;
            }
            Long firstId = row.getLong("firid");
            Long secondId = row.getLong("secid");
            boolean isFirstData = firstId != null && firstId != 0L;
            boolean isSecondData = secondId != null && secondId != 0L;
            boolean bl = isInterSectData = isFirstData && isSecondData;
            if (isFirstData && firstId != -1L) {
                entity = entryEntity.addNew();
                entity.set("costobject", (Object)row.getLong("costobject"));
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("bizbillid", (Object)firstId);
                entity.set("billnumber", (Object)row.getString("firbillno"));
                entity.set("allocvalue", (Object)row.getBigDecimal("firvalue"));
                entity.set("billtypenum", (Object)row.getString("firbilltypenum"));
                entity.set("seq", (Object)seq++);
            }
            if (isSecondData && secondId != -1L) {
                entity = entryEntity.addNew();
                entity.set("costobject", (Object)row.getLong("costobject"));
                entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
                entity.set("bizbillid", (Object)secondId);
                entity.set("billnumber", (Object)row.getString("secbillno"));
                entity.set("allocvalue", (Object)row.getBigDecimal("secvalue"));
                entity.set("billtypenum", (Object)row.getString("secbilltypenum"));
                entity.set("seq", (Object)seq++);
            }
            if (!isInterSectData) continue;
            entity = entryEntity.addNew();
            entity.set("costobject", (Object)row.getLong("costobject"));
            entity.set("benefcostcenter", (Object)row.getLong("costcenter"));
            entity.set("allocvalue", (Object)row.getBigDecimal("value"));
            entity.set("calcresult", (Object)String.format("%s %s %s = %s", this.dealScale(row.getBigDecimal("firvalue")), exp, this.dealScale(row.getBigDecimal("secvalue")), this.dealScale(row.getBigDecimal("value"))));
            entity.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportEntity});
    }

    private String dealScale(BigDecimal value) {
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
            return "0";
        }
        return String.valueOf(value.setScale(10, RoundingMode.HALF_UP));
    }

    private DataSet doDivideOnDigToMaterial(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select id,billno,org, manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,firstvalue / " + opValue + " as value,billtypenum") : opDs.executeSql("select id,billno,org, manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,0 as value,billtypenum");
        return opResult;
    }

    private DataSet doDivideOnDigToCostObject(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select id,billno,org, manuorg, costcenter, costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,firstvalue / " + opValue + " as value,billtypenum") : opDs.executeSql("select id,billno,org, manuorg, costcenter, costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,0 as value,billtypenum");
        this.saveFormulaCalcReport(opResult, "/", true);
        return opResult;
    }

    private DataSet doDivideOnDigToCostCenter(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select id,billno,org, manuorg, costcenter, benefcostcenter,firstvalue / " + opValue + " as value,billtypenum") : opDs.executeSql("select id,billno,org, manuorg, costcenter, benefcostcenter,0 as value,billtypenum");
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostCenter(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select id,billno,org, manuorg, costcenter, benefcostcenter," + opValue + " * firstvalue as value,billtypenum" : "select id,billno,org, manuorg, costcenter, benefcostcenter," + opValue + " * value as value,billtypenum";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostObject(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select id,billno,org, manuorg, costcenter, costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber," + opValue + " * firstvalue as value,billtypenum" : "select id,billno,org, manuorg, costcenter, costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber," + opValue + " * value as value,billtypenum";
        DataSet opResult = opDs.executeSql(sql);
        this.saveFormulaCalcReport(opResult, "*", true);
        return opResult;
    }

    private DataSet doMulOnDigToMaterial(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select id,billno,org, manuorg, material,materialauxpty,configuredcode,tracknumber," + opValue + " * firstvalue as value,billtypenum" : "select id,billno,org, manuorg, material,materialauxpty,configuredcode,tracknumber," + opValue + " * value as value,billtypenum";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnMaterial(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "*", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doMultiplyOnCostObject(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "*", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doSubtractOnMaterial(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "-", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doSubtractOnCostObject(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "-", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doAddOnMaterial(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet rightDs;
        DataSet leftDs;
        if (enableMulFactory) {
            leftDs = secondDs.leftJoin(firstDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        } else {
            leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        }
        DataSet opResult = DataSetUtils.union((DataSet)leftDs, (DataSet)rightDs).distinct();
        this.saveFormulaCalcReport(opResult, "+", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doAddOnCostObject(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet rightDs;
        DataSet leftDs;
        if (enableMulFactory) {
            leftDs = secondDs.leftJoin(firstDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        } else {
            leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        }
        DataSet opResult = DataSetUtils.union((DataSet)leftDs, (DataSet)rightDs).distinct();
        this.saveFormulaCalcReport(opResult, "+", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doMulOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs, boolean enableMulFactory, boolean isReverse) {
        DataSet opResult;
        String value = "(case when (value * firstvalue) != null then (value * firstvalue) else 0 end) as value";
        if (isReverse) {
            firstDs = firstDs.select("id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value as firstvalue,billtypenum");
            secondDs = secondDs.select("id,billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,firstvalue as value,billtypenum");
        }
        boolean isNewAllocType = MfgfeeAllocHelper.isNewAllocType();
        if (enableMulFactory) {
            if (isNewAllocType) {
                DataSet notCostCenterDs = secondDs.copy().filter("costcenter is null or costcenter = 0");
                if (notCostCenterDs.isEmpty()) {
                    opResult = firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                } else {
                    DataSet costCenterResult = firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                    firstDs = firstDs.leftJoin(costCenterResult).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish();
                    DataSet materialDealDs = firstDs.filter("diycostcenter is null or diycostcenter = 0");
                    DataSet materialResult = materialDealDs.join(notCostCenterDs, JoinType.INNER).on("manuorg", "manuorg").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                    opResult = costCenterResult.union(materialResult);
                }
            } else {
                DataSet dealDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish().distinct();
                DataSet costCenterDealDs = dealDs.filter("diycostcenter is not null and diycostcenter != 0");
                DataSet materialDealDs = dealDs.filter("diycostcenter is null or diycostcenter = 0");
                DataSet costCenterResult = costCenterDealDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                DataSet emptyCostCenterDiyDs = secondDs.filter("costcenter is null or costcenter = 0");
                DataSet materialResult = materialDealDs.join(emptyCostCenterDiyDs, JoinType.INNER).on("manuorg", "manuorg").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                opResult = costCenterResult.union(materialResult);
            }
        } else if (isNewAllocType) {
            DataSet notCostCenterDs = secondDs.copy().filter("costcenter is null or costcenter = 0");
            if (notCostCenterDs.isEmpty()) {
                opResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
            } else {
                DataSet costCenterResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                firstDs = firstDs.leftJoin(costCenterResult).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish();
                DataSet materialDealDs = firstDs.filter("diycostcenter is null or diycostcenter = 0");
                DataSet materialResult = materialDealDs.join(notCostCenterDs, JoinType.INNER).on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
                opResult = costCenterResult.union(materialResult);
            }
        } else {
            DataSet dealDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").select(firstDs.getRowMeta().getFieldNames(), new String[]{"costcenter as diycostcenter"}).finish().distinct();
            DataSet costCenterDealDs = dealDs.filter("diycostcenter is not null and diycostcenter != 0");
            DataSet materialDealDs = dealDs.filter("diycostcenter is null or diycostcenter = 0");
            DataSet costCenterResult = costCenterDealDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
            DataSet emptyCostCenterDiyDs = secondDs.filter("costcenter is null or costcenter = 0");
            DataSet materialResult = materialDealDs.join(emptyCostCenterDiyDs, JoinType.INNER).on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", value, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
            opResult = costCenterResult.union(materialResult);
        }
        this.saveFormulaCalcReport(opResult, "*", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doMulOnCostObjectToMaterialGroup(DataSet firstDs, DataSet secondDs, boolean isReverse) {
        DataSet opResult;
        if (isReverse) {
            firstDs = firstDs.select("id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value as firstvalue,billtypenum");
            secondDs = secondDs.select("id,billno,org,costcenter,materialgroup,firstvalue as value,billtypenum");
        }
        if (this.isMatGroupCal) {
            DataSet totalDs = firstDs.groupBy(new String[]{"org", "costcenter", "materialgroup"}).sum("firstvalue").finish();
            totalDs = totalDs.select("org,costcenter,materialgroup,firstvalue as totalvalue");
            firstDs = firstDs.join(totalDs, JoinType.INNER).on("materialgroup", "materialgroup").select(new String[]{"id", "billno", "billtypenum", "org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (totalvalue != 0) and (firstvalue / totalvalue) != null then (firstvalue / totalvalue) else 0 end) as firstvalue", "firstvalue origfirstvalue", "totalvalue"}).finish();
            opResult = firstDs.leftJoin(secondDs).on("materialgroup", "materialgroup").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value", "origfirstvalue", "totalvalue", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
            this.saveMaterialGroupFormulaCalcReport(opResult, "*");
        } else {
            opResult = firstDs.leftJoin(secondDs).on("materialgroup", "materialgroup").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
            this.saveFormulaCalcReport(opResult, "*", false);
        }
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doMulOnCostObjectToCenter(DataSet firstDs, DataSet secondDs, boolean isReverse, boolean enableMulFactory) {
        String value = "(case when (value * firstvalue) != null then (value * firstvalue) else 0 end) as value";
        if (isReverse) {
            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value as firstvalue,billtypenum");
            secondDs = secondDs.executeSql("select id,billno,org,manuorg,costcenter,benefcostcenter,firstvalue as value,billtypenum");
        }
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno", value}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno", value}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "*", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doDivOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs, boolean isReverse, boolean enableMulFactory) {
        if (isReverse) {
            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value,billtypenum");
        } else {
            secondDs = secondDs.executeSql("select id,billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value,billtypenum");
        }
        return this.doMulOnCostObjectToMaterial(firstDs, secondDs, enableMulFactory, isReverse);
    }

    private DataSet doDivOnCostObjectToMaterialGroup(DataSet firstDs, DataSet secondDs, boolean isReverse) {
        if (isReverse) {
            firstDs = firstDs.executeSql("select id,billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,billtypenum,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        } else {
            secondDs = secondDs.executeSql("select id,billno,org,materialgroup,billtypenum,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        }
        return this.doMulOnCostObjectToMaterialGroup(firstDs, secondDs, isReverse);
    }

    private DataSet doDivOnCostObjectToCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        secondDs = secondDs.executeSql("select id,billno,org,manuorg,costcenter,benefcostcenter,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value,billtypenum");
        return this.doMulOnCostObjectToCenter(firstDs, secondDs, false, enableMulFactory);
    }

    private DataSet doDivOnCostCenterToObject(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        secondDs = secondDs.executeSql("select org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        return this.doMulOnCostObjectToCenter(secondDs, firstDs, true, enableMulFactory);
    }

    private DataSet doDivisideOnMaterial(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_DIV_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("material", "material").on("materialauxpty", "materialauxpty").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").select(new String[]{"org", "0L manuorg", "costcenter", "material", "materialauxpty", "configuredcode", "tracknumber", FIRST_DIV_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "/", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum");
        return opResult;
    }

    private DataSet doDivisideOnCostObject(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult;
        String divValue = "(case when totalvalue != 0 and (totalfirstvalue / totalvalue) != null then (totalfirstvalue / totalvalue) else 0 end) as value";
        if (enableMulFactory) {
            DataSet firstCostObjectGroupDs = firstDs.groupBy(new String[]{"costcenter", "costObject"}).sum("firstvalue").finish();
            firstCostObjectGroupDs = firstCostObjectGroupDs.select("costcenter,costObject,firstvalue as totalfirstvalue");
            firstDs = firstDs.leftJoin(firstCostObjectGroupDs).on("costcenter", "costcenter").on("costObject", "costObject").select(firstDs.getRowMeta().getFieldNames(), new String[]{"totalfirstvalue"}).finish();
            DataSet costObjectGroupDs = secondDs.groupBy(new String[]{"costcenter", "costObject"}).sum("value").finish();
            costObjectGroupDs = costObjectGroupDs.select("costcenter,costObject,value as totalvalue");
            secondDs = secondDs.leftJoin(costObjectGroupDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costObject", "costObject").select(secondDs.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
            opResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", divValue, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        } else {
            DataSet firstCostObjectGroupDs = firstDs.groupBy(new String[]{"costcenter", "costObject"}).sum("firstvalue").finish();
            firstCostObjectGroupDs = firstCostObjectGroupDs.select("costcenter,costObject,firstvalue as totalfirstvalue");
            firstDs = firstDs.leftJoin(firstCostObjectGroupDs).on("costcenter", "costcenter").on("costObject", "costObject").select(firstDs.getRowMeta().getFieldNames(), new String[]{"totalfirstvalue"}).finish();
            DataSet costObjectGroupDs = secondDs.groupBy(new String[]{"costcenter", "costObject"}).sum("value").finish();
            costObjectGroupDs = costObjectGroupDs.select("costcenter,costObject,value as totalvalue");
            secondDs = secondDs.leftJoin(costObjectGroupDs).on("costcenter", "costcenter").on("costObject", "costObject").select(secondDs.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
            opResult = firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "0L as manuorg", "costcenter", "costobject", "materialgroup", "material", "materialauxpty", "configuredcode", "tracknumber", divValue, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        }
        this.saveDivFormulaCalcReport(opResult, "/");
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,costobject,materialgroup,material,materialauxpty,configuredcode,tracknumber,value,'' billtypenum").distinct();
        return opResult;
    }

    private DataSet doSubtractOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", "(case when (firstvalue - value) != null then (firstvalue - value) else firstvalue end) as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "-", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,benefcostcenter,value,'' billtypenum");
        return opResult;
    }

    private DataSet doAddOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet rightDs;
        DataSet leftDs;
        if (enableMulFactory) {
            leftDs = secondDs.leftJoin(firstDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "firstvalue + value  as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        } else {
            leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", "firstvalue + value  as value", "value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}, new String[]{"firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}).finish();
            rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", "firstvalue + value as value", "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        }
        DataSet opResult = DataSetUtils.union((DataSet)leftDs, (DataSet)rightDs).distinct();
        this.saveFormulaCalcReport(opResult, "+", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,benefcostcenter,value,'' billtypenum");
        return opResult;
    }

    private DataSet doMultiplyOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", FIRST_MUL_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "*", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,benefcostcenter,value,'' billtypenum");
        return opResult;
    }

    private DataSet doDivideOnCostCenter(DataSet firstDs, DataSet secondDs, boolean enableMulFactory) {
        DataSet opResult = enableMulFactory ? firstDs.join(secondDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "manuorg", "costcenter", "benefcostcenter", FIRST_DIV_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish() : firstDs.join(secondDs, JoinType.INNER).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "0L as manuorg", "costcenter", "benefcostcenter", FIRST_DIV_VALUE, "firstvalue as firvalue", "id as firid", "billtypenum as firbilltypenum", "billno as firbillno"}, new String[]{"value as secvalue", "id as secid", "billtypenum as secbilltypenum", "billno as secbillno"}).finish();
        this.saveFormulaCalcReport(opResult, "/", false);
        opResult = opResult.select("-1L as id,'' billno,org,manuorg,costcenter,benefcostcenter,value,'' billtypenum");
        return opResult;
    }
}

