/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.utils.CadEmptyUtils;

public class DealStdCalcResultFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public DealStdCalcResultFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        String treepath;
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        ArrayList<RowX> dealTargetRows = new ArrayList<RowX>(10);
        int idIndex = this.rowMeta.getFieldIndex("id");
        int keycolIndex = this.rowMeta.getFieldIndex("keycol");
        int materialattrIndex = this.rowMeta.getFieldIndex("materialattr");
        int subKeycolIndex = this.rowMeta.getFieldIndex("subkeycol1");
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype1");
        int qtyIndex = this.rowMeta.getFieldIndex("qty1");
        int entrybomidIndex = this.rowMeta.getFieldIndex("entrybomid1");
        int entrylevelIndex = this.rowMeta.getFieldIndex("entrylevel1");
        int entrytreepathIndex = this.rowMeta.getFieldIndex("entrytreepath1");
        HashMap<String, List<RowX>> virtualResultMap = new HashMap<String, List<RowX>>(16);
        HashSet<Long> virtualMatBomIds = new HashSet<Long>(10);
        for (RowX rowX : iter) {
            int level = rowX.getInteger(entrylevelIndex);
            if (level != 0) {
                treepath = rowX.getString(entrytreepathIndex);
                if (treepath.contains("@")) {
                    treepath = treepath.substring(0, treepath.lastIndexOf("@"));
                }
                String keycol = rowX.getString(keycolIndex);
                String materialAttr = rowX.getString(materialattrIndex);
                if ("D".equals(materialAttr) && "4".equals(rowX.getString(datatypeIndex))) {
                    virtualMatBomIds.add(rowX.getLong(entrybomidIndex));
                    virtualResultMap.computeIfAbsent(treepath + keycol, p -> new ArrayList()).add(rowX);
                }
            }
            dealTargetRows.add(rowX);
        }
        if (CadEmptyUtils.isEmpty(virtualResultMap)) {
            for (RowX rowX : dealTargetRows) {
                collector.collect(rowX);
            }
            return;
        }
        for (RowX rowX : dealTargetRows) {
            Long id = rowX.getLong(idIndex);
            treepath = rowX.getString(entrytreepathIndex);
            String subKeycol = rowX.getString(subKeycolIndex);
            BigDecimal qty = rowX.getBigDecimal(qtyIndex);
            String key = treepath + subKeycol;
            if (virtualResultMap.containsKey(key)) {
                this.eliminateVirtualMat(key, id, targetRows, virtualResultMap);
                continue;
            }
            targetRows.add(rowX);
        }
        for (RowX targetRow : targetRows) {
            String path = targetRow.getString(entrytreepathIndex);
            if (this.isContainsVirtualBomid(path, virtualMatBomIds).booleanValue()) {
                this.resetPathLevel(targetRow, path, virtualMatBomIds);
            }
            collector.collect(targetRow);
        }
    }

    private void resetPathLevel(RowX rowX, String path, Set<Long> virtualMatBomIds) {
        if (CadEmptyUtils.isEmpty(path)) {
            return;
        }
        int entrytreepathIndex = this.rowMeta.getFieldIndex("entrytreepath1");
        int entrylevelIndex = this.rowMeta.getFieldIndex("entrylevel1");
        int level = rowX.getInteger(entrylevelIndex);
        String[] split = path.split("@");
        String newPath = "";
        for (String s : split) {
            if (!virtualMatBomIds.contains(Long.parseLong(s))) {
                if (CadEmptyUtils.isEmpty(newPath)) {
                    newPath = s;
                    continue;
                }
                newPath = newPath + "@" + s;
                continue;
            }
            --level;
        }
        rowX.set(entrytreepathIndex, (Object)newPath);
        rowX.set(entrylevelIndex, (Object)level);
    }

    private Boolean isContainsVirtualBomid(String path, Set<Long> virtualMatBomIds) {
        if (CadEmptyUtils.isEmpty(virtualMatBomIds)) {
            return Boolean.FALSE;
        }
        for (Long virtualMatBomId : virtualMatBomIds) {
            if (!path.contains(String.valueOf(virtualMatBomId))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void eliminateVirtualMat(String treepathKeycolStr, Long id, List<RowX> targetRows, Map<String, List<RowX>> virtualResultMap) {
        List<RowX> rowXs = virtualResultMap.get(treepathKeycolStr);
        if (CadEmptyUtils.isEmpty(rowXs)) {
            return;
        }
        int idIndex = this.rowMeta.getFieldIndex("id");
        int subKeycolIndex = this.rowMeta.getFieldIndex("subkeycol1");
        int qtyIndex = this.rowMeta.getFieldIndex("qty1");
        int stdpriceIndex = this.rowMeta.getFieldIndex("stdprice1");
        int entrystdqtyIndex = this.rowMeta.getFieldIndex("entrystdqty1");
        int entrytreepathIndex = this.rowMeta.getFieldIndex("entrytreepath1");
        for (RowX rowX : rowXs) {
            String treepath = rowX.getString(entrytreepathIndex);
            String subKeycol = rowX.getString(subKeycolIndex);
            BigDecimal stdQty = rowX.getBigDecimal(entrystdqtyIndex);
            BigDecimal oldQty = rowX.getBigDecimal(qtyIndex);
            BigDecimal oldPrice = rowX.getBigDecimal(stdpriceIndex);
            String key = treepath + subKeycol;
            if (virtualResultMap.containsKey(key) && !CadEmptyUtils.isEmpty(virtualResultMap.get(key))) {
                this.eliminateVirtualMat(key, id, targetRows, virtualResultMap);
                continue;
            }
            RowX newRowx = rowX.copy();
            newRowx.set(idIndex, (Object)id);
            newRowx.set(qtyIndex, (Object)stdQty.multiply(oldQty));
            newRowx.set(stdpriceIndex, (Object)stdQty.multiply(oldPrice));
            targetRows.add(newRowx);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

