/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.algox.Data.CalculationNode;
import kd.macc.cad.algox.calc.helper.CalcCheckerHelper;
import kd.macc.cad.algox.calc.helper.NewStdCalculateHelper;
import kd.macc.cad.algox.calc.helper.StdCalcEliminateVirtualMatHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.EntityUtil;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadUtils;

public class NewFinishFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(NewFinishFunction.class);
    private CalcStandCostCalcParam standCostCalcParam = null;

    public CalcStandCostCalcParam getStandCostCalcParam() {
        return this.standCostCalcParam;
    }

    public void setStandCostCalcParam(CalcStandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try {
            int cout = 0;
            for (RowX rowX : iterable) {
                ++cout;
            }
            HashSet<String> calMatWithCopProByLessZero = new HashSet<String>(10);
            if (!this.standCostCalcParam.isTrackCalc().booleanValue()) {
                this.dealCalcSimulaResult(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.isSaveRecord(), this.standCostCalcParam.getRecordName());
                NewStdCalculateHelper.deductCoByProductCost(this.standCostCalcParam, calMatWithCopProByLessZero);
                NewStdCalculateHelper.dealByProductCost(this.standCostCalcParam);
            }
            String noPassCheckItems = NewStdCalculateHelper.dealCheckResultForAfterCalc(this.standCostCalcParam, calMatWithCopProByLessZero);
            if (this.standCostCalcParam.isCalcCurLevel()) {
                if (!CadEmptyUtils.isEmpty(noPassCheckItems) && CadEmptyUtils.isEmpty(this.standCostCalcParam.getCheckSuccessProducts())) {
                    this.standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"NewFinishFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]), (Exception)new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u9519\u8bef\uff0c\u68c0\u67e5\u9879\uff1a%s\u3002", (String)"NewFinishFunction_1", (String)"macc-cad-algox", (Object[])new Object[0]), noPassCheckItems)));
                    return;
                }
            } else if (!CadEmptyUtils.isEmpty(noPassCheckItems)) {
                this.standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u5377\u7b97\u5931\u8d25", (String)"NewFinishFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]), (Exception)new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u9519\u8bef\uff0c\u68c0\u67e5\u9879\uff1a%s\u3002", (String)"NewFinishFunction_1", (String)"macc-cad-algox", (Object[])new Object[0]), noPassCheckItems)));
                return;
            }
            this.write2Log(String.format(ResManager.loadKDString((String)"\u5377\u7b97\u7ed3\u675f\uff0cBOM\u6811%1$s\u4e2a\u603b\u8017\u65f6%2$s(ms)\u3002", (String)"NewFinishFunction_2", (String)"macc-cad-algox", (Object[])new Object[0]), cout, this.standCostCalcParam.getBizLogger().getTotalTime()));
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5377\u7b97\u540e\u7eed\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25\u3002", (Throwable)e);
            this.standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u6267\u884c\u5377\u7b97\u540e\u7eed\u66f4\u65b0", (String)"NewFinishFunction_3", (String)"macc-cad-algox", (Object[])new Object[0]), e);
        }
    }

    public void dealFinalResult() {
        if (CalcCheckerHelper.isExistNoPassCheckItem(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getCheckTaskId()).booleanValue()) {
            return;
        }
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            long startTime = TimeServiceHelper.now().getTime();
            StdCalcEliminateVirtualMatHelper.dealElimiVirtualMatResultForTrackCalc(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.getPriceprecision(), this.standCostCalcParam.getCalcDate());
            this.write2LogNew(ResManager.loadKDString((String)"\u5904\u7406\u865a\u62df\u4ef6\u7ed3\u679c\u4fe1\u606f", (String)"NewFinishFunction_5", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
            int deleteTrackCalcSubItemResult = CadBgParamUtils.getCadParamForInt((String)"deleteTrackCalcSubItemResult", (int)0);
            if (deleteTrackCalcSubItemResult == 1) {
                try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)this.standCostCalcParam.getCostTypeId()), new HintCondition("fcalcdate", "=", (Object)this.standCostCalcParam.getCalcDate())});){
                    QFilter filter = new QFilter("costtype", "=", (Object)this.standCostCalcParam.getCostTypeId());
                    filter.and(new QFilter("calcdate", "=", (Object)this.standCostCalcParam.getCalcDate()));
                    filter.and(new QFilter("task", "=", (Object)this.standCostCalcParam.getTaskId()));
                    filter.and(new QFilter("origentryentity.origentrylevel", ">", (Object)0));
                    DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"origentryentity.id origentryid", (QFilter[])new QFilter[]{filter});
                    Set origEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)results, (String)"origentryid");
                    DBRoute dbRoute = new DBRoute("cal");
                    String deleteSubSql = "delete from t_cad_trackcalcsubentryal where fentryid in " + CadUtils.setToSql((Set)origEntryIds) + " and forigdatatype='3'";
                    DB.execute((DBRoute)dbRoute, (String)deleteSubSql);
                }
            }
            startTime = TimeServiceHelper.now().getTime();
            this.copyCalcResultForTrackNum(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.getMatConfigCodeTrackNumMap());
            this.write2LogNew(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u5377\u7b97\u7ed3\u679c\u540e\u5904\u7406", (String)"NewFinishFunction_6", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
        try (TXHandle tx = TX.requiresNew();){
            if (!this.standCostCalcParam.isTrackCalc().booleanValue()) {
                this.dealCalcSimulaResult(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.isSaveRecord(), this.standCostCalcParam.getRecordName());
                this.dealCalcRecordResult(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.isSaveRecord(), this.standCostCalcParam.getRecordName());
                if (!this.standCostCalcParam.isCalcCurLevel()) {
                    if (this.standCostCalcParam.getScopetype() == 1) {
                        this.writeToCalcPurPrices(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.getCalcDate());
                    } else {
                        this.writeToCalcPurPrices(this.standCostCalcParam.getCostTypeId(), this.standCostCalcParam.getTaskId(), this.standCostCalcParam.getCalcDate(), this.standCostCalcParam.getPruPriceObjIds());
                    }
                }
            }
            if (!this.standCostCalcParam.isSaveRecord().booleanValue()) {
                long startTime = TimeServiceHelper.now().getTime();
                NewStdCalculateHelper.afterCalc(this.standCostCalcParam);
                this.write2LogNew(ResManager.loadKDString((String)"\u66f4\u65b0\u5230\u7269\u6599\u6210\u672c\u4fe1\u606f", (String)"NewFinishFunction_7", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
            }
        }
        catch (Exception e) {
            logger.error("\u5377\u7b97\u6267\u884c\u540e\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    private void writeToCalcPurPrices(Long costTypeId, Long taskId, Date calcDate, List<Long> purPriceObjIds) {
        if (CadEmptyUtils.isEmpty(purPriceObjIds)) {
            return;
        }
        try {
            int count = 1;
            int writeToCalcPurPricesBatch = CadBgParamUtils.getCadParamForInt((String)"writeToCalcPurPricesBatch", (int)200000);
            for (List purPriceObjIdList : Lists.partition(purPriceObjIds, (int)writeToCalcPurPricesBatch)) {
                logger.info("\u7b2c{}\u6279\uff0c\u5199\u5377\u7b97\u7ed3\u679c\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (Object)count);
                String selectPurFields = "id,costtype,billno,datasrc,currency,material,auxpty,lot,configuredcode,tracknumber,project,pricerule,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate";
                Object[] purPrices = BusinessDataServiceHelper.load((String)"cad_purprices", (String)selectPurFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)purPriceObjIdList)});
                if (CadEmptyUtils.isEmpty(purPrices)) {
                    return;
                }
                ArrayList<String> purPricesMatKc = new ArrayList<String>(10);
                for (Object purPrice : purPrices) {
                    purPricesMatKc.add(purPrice.getString("keycol"));
                }
                StdCalculateHelper.clearCalcPurPricesResult(costTypeId, purPricesMatKc);
                StdCalculateHelper.writeToCalcPurPrices(calcDate, taskId, (DynamicObject[])purPrices);
                ++count;
            }
        }
        catch (Exception exp) {
            logger.error("\u5199\u5377\u7b97\u7ed3\u679c\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u51fa\u9519:", (Throwable)exp);
            throw exp;
        }
    }

    private void writeToCalcPurPrices(Long costTypeId, Long taskId, Date calcDate) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("task", "=", (Object)taskId));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"entryentity.subkeycol subkeycol,entryentity.pricerule pricerule,entryentity.priceid priceid", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(results)) {
            return;
        }
        HashSet<Long> priceIds = new HashSet<Long>(200);
        HashSet<String> purMatKeycols = new HashSet<String>(200);
        for (DynamicObject result : results) {
            long priceid = result.getLong("priceid");
            long pricerule = result.getLong("pricerule");
            if (CadEmptyUtils.isEmpty(priceid)) continue;
            if (!PriceRuleConstants.PUR_STDCOST_ID.equals(pricerule)) {
                priceIds.add(priceid);
            }
            purMatKeycols.add(result.getString("subkeycol"));
        }
        filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("keycol", "in", purMatKeycols));
        filter.and(new QFilter("calcrecord", "=", (Object)0L));
        DeleteServiceHelper.delete((String)"cad_calcpurprices", (QFilter[])new QFilter[]{filter});
        String selectPurFields = "id,costtype,billno,currency,datasrc,material,matversion,auxpty,lot,configuredcode,tracknumber,project,pricerule,amount,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate";
        String selectMatCostInfoFields = "id,costtype,currency,material,matversion,auxpty,lot,configuredcode,tracknumber,project,stdprice,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.standardcost";
        ArrayList purPricesList = new ArrayList(10);
        Lists.partition(new ArrayList(priceIds), (int)10000).forEach(list -> {
            DynamicObject[] purPrices;
            for (DynamicObject purPrice : purPrices = BusinessDataServiceHelper.load((String)"cad_purprices", (String)selectPurFields, (QFilter[])new QFilter[]{new QFilter("id", "in", list)})) {
                DynamicObject calcPurPrices = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcpurprices");
                EntityUtil.copyPropertiesWithOutId(calcPurPrices, purPrice);
                calcPurPrices.set("calcdate", (Object)calcDate);
                calcPurPrices.set("task", (Object)taskId);
                calcPurPrices.set("billstatus", (Object)"C");
                calcPurPrices.set("priceid", (Object)purPrice.getLong("id"));
                calcPurPrices.set("creator", (Object)RequestContext.get().getCurrUserId());
                calcPurPrices.set("createtime", (Object)TimeServiceHelper.now());
                calcPurPrices.set("modifier", (Object)RequestContext.get().getCurrUserId());
                calcPurPrices.set("modifytime", (Object)TimeServiceHelper.now());
                calcPurPrices.set("auditor", (Object)RequestContext.get().getCurrUserId());
                calcPurPrices.set("auditdate", (Object)TimeServiceHelper.now());
                Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)calcPurPrices, (boolean)true);
                calcPurPrices.set("keycol", (Object)calcKey.getKeycol());
                calcPurPrices.set("keycolid", (Object)calcKey.getId());
                calcPurPrices.set("keycolid_id", (Object)calcKey.getId());
                purPricesList.add(calcPurPrices);
            }
        });
        if (!CadEmptyUtils.isEmpty(purPricesList)) {
            SaveServiceHelper.save((DynamicObject[])purPricesList.toArray(new DynamicObject[0]));
        }
    }

    private void dealCalcSimulaResult(Long costType, Long taskId, Boolean isSaveRecord, String recordName) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("task", "=", (Object)taskId));
        filter.and(new QFilter("ismaindata", "=", (Object)1));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dealCalcSimulaResult", (String)"cad_calcsimulationresult", (String)"id,keycol", (QFilter[])filter.toArray(), null);
        dataSet = dataSet.groupBy(new String[]{"keycol"}).count("id").finish();
        dataSet = dataSet.filter("id>1");
        HashSet<String> keyCols = new HashSet<String>(200);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (CadEmptyUtils.isEmpty(row.getString("keycol"))) continue;
            keyCols.add(row.getString("keycol"));
        }
        if (CadEmptyUtils.isEmpty(keyCols)) {
            return;
        }
        int dealCalcSimulaResultBatch = CadBgParamUtils.getCadParamForInt((String)"dealCalcSimulaResultBatch", (int)1000);
        for (List keyColList : Lists.partition(new ArrayList(keyCols), (int)dealCalcSimulaResultBatch)) {
            QFilter kcFilter = new QFilter("keycol", "in", (Object)keyColList);
            DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)"id,keycol,calcrecord,treeentry.subcosttype,treeentry.subroot,treeentry.subtreepath,treeentry.subcalcdate", (QFilter[])new QFilter[]{filter, kcFilter});
            HashMap<String, List> resMap = new HashMap<String, List>(16);
            for (DynamicObject dyo : dyos) {
                resMap.computeIfAbsent(dyo.getString("keycol"), p -> new ArrayList()).add(dyo);
            }
            HashSet<Long> needDeleteIds = new HashSet<Long>(100);
            HashSet<Long> needDeleteRecordIds = new HashSet<Long>(100);
            ArrayList<Object[]> params = new ArrayList<Object[]>(200);
            for (Map.Entry res : resMap.entrySet()) {
                DynamicObject mainDyo;
                List values = (List)res.getValue();
                if (values.size() == 1 || (mainDyo = (DynamicObject)values.get(0)) == null) continue;
                Long pid = mainDyo.getLong("id");
                values.remove(mainDyo);
                for (DynamicObject value : values) {
                    long id = value.getLong("id");
                    DynamicObjectCollection treeEntry = value.getDynamicObjectCollection("treeentry");
                    for (DynamicObject tree : treeEntry) {
                        Object[] obj = new Object[]{pid, ID.genLongId(), tree.getLong("subcosttype.id"), tree.getString("subroot"), tree.getString("subtreepath"), tree.getDate("subcalcdate")};
                        params.add(obj);
                        if (params.size() <= 5000) continue;
                        this.insertCalcSimTreeEntry(costType, params);
                        params.clear();
                    }
                    needDeleteIds.add(id);
                    needDeleteRecordIds.add(value.getLong("calcrecord.id"));
                    if (needDeleteIds.size() > 5000) {
                        this.deleteCalcMulars(costType, taskId, needDeleteIds);
                        needDeleteIds.clear();
                    }
                    if (needDeleteRecordIds.size() <= 5000) continue;
                    this.deleteStdCalcRecod(costType, isSaveRecord, needDeleteRecordIds);
                    needDeleteRecordIds.clear();
                }
            }
            if (!CadEmptyUtils.isEmpty(params)) {
                this.insertCalcSimTreeEntry(costType, params);
            }
            if (!CadEmptyUtils.isEmpty(needDeleteIds)) {
                this.deleteCalcMulars(costType, taskId, needDeleteIds);
            }
            if (!isSaveRecord.booleanValue() || CadEmptyUtils.isEmpty(needDeleteRecordIds)) continue;
            this.deleteStdCalcRecod(costType, isSaveRecord, needDeleteRecordIds);
        }
    }

    private void insertCalcSimTreeEntry(Long costType, List<Object[]> params) {
        try (ShardingHintContext ct = ShardingHintContext.createAndSet((String)"t_cad_calcsimtreeentry", (HintCondition[])new HintCondition[]{new HintCondition("fsubcosttypeid", "=", (Object)costType)});
             TXHandle tx = TX.requiresNew();){
            String sql = "INSERT INTO t_cad_calcsimtreeentry (FID, FENTRYID, FSUBCOSTTYPEID, FSUBROOT, FSUBTREEPATH, FSUBCALCDATE) VALUES (?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
        }
    }

    private void deleteStdCalcRecod(Long costType, Boolean isSaveRecord, Set<Long> needDeleteRecordIds) {
        if (isSaveRecord.booleanValue() && !CadEmptyUtils.isEmpty(needDeleteRecordIds)) {
            try (ShardingHintContext ct = ShardingHintContext.createAndSet((String)"t_cad_stdcalcrecord", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)costType)});){
                String sql = "DELETE FROM t_cad_stdcalcrecord WHERE FID IN " + NewFinishFunction.setToSql(needDeleteRecordIds);
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
            }
        }
    }

    private void deleteCalcMulars(Long costType, Long taskId, Set<Long> needDeleteIds) {
        try (ShardingHintContext ct = ShardingHintContext.createAndSet((String)"t_cad_calcsimulars", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)costType)});){
            String sql = "DELETE FROM t_cad_calcsimulars WHERE FID IN " + NewFinishFunction.setToSql(needDeleteIds);
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("DELETE FROM t_cad_calcsimulars WHERE fismaindata=0 and fcosttypeid=" + costType + " and ftaskid=" + taskId));
        }
    }

    public static String setToSql(Set<Long> ids) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return "(-1)";
        }
        StringBuilder sql = new StringBuilder();
        sql.append('(');
        for (Long id : ids) {
            sql.append(id).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        return sql.toString();
    }

    private void dealCalcRecordResult(Long costType, Boolean isSaveRecord, String recordName) {
        if (!isSaveRecord.booleanValue()) {
            return;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("calcrecord.name", "=", (Object)recordName));
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"calcrecord", (QFilter[])filter.toArray());
        ArrayList<Long> recordIds = new ArrayList<Long>(10);
        for (DynamicObject dyo : dyos) {
            recordIds.add(dyo.getLong("calcrecord"));
        }
        if (!CadEmptyUtils.isEmpty(recordIds)) {
            QFilter ctFilter = new QFilter("costtype", "=", (Object)costType);
            QFilter idFilter = new QFilter("id", "not in", recordIds);
            QFilter nameFilter = new QFilter("name", "=", (Object)recordName);
            DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{ctFilter, nameFilter, idFilter});
        }
    }

    private void copyCalcResultForTrackNum(Long costTypeId, Long taskId, Map<String, Set<Long>> matConfigCodeTrackNumMap) {
        if (CadEmptyUtils.isEmpty(matConfigCodeTrackNumMap)) {
            return;
        }
        for (String keycoltmp : matConfigCodeTrackNumMap.keySet()) {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("task", "=", (Object)taskId));
            filter.and(new QFilter("keycol", "=", (Object)keycoltmp));
            this.copyCalcResultForTrackNumSingle(matConfigCodeTrackNumMap, filter);
        }
    }

    private void copyCalcResultForTrackNumSingle(Map<String, Set<Long>> matConfigCodeTrackNumMap, QFilter filter) {
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList ids = new ArrayList(10);
        results.forEach(p -> ids.add(p.getLong("id")));
        DynamicObject[] trackStdCalcResults = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_trackstdcalcresult"));
        HashMap<String, DynamicObject> materialMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : trackStdCalcResults) {
            String keycol = dynamicObject.getString("keycol");
            if (materialMap.containsKey(keycol)) continue;
            materialMap.put(keycol, dynamicObject);
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(200);
        HashMap<Long, DynamicObject> trackNumMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<String, Set<Long>> entry : matConfigCodeTrackNumMap.entrySet()) {
            String key = entry.getKey();
            Set<Long> trackNums = entry.getValue();
            DynamicObject dynamicObject = (DynamicObject)materialMap.get(key);
            if (dynamicObject == null) continue;
            int count = 1;
            for (Long trackNum : trackNums) {
                if (count == 1) {
                    trackNumMap.put(trackNum, dynamicObject);
                } else {
                    DynamicObject newDataEntity = BusinessDataServiceHelper.newDynamicObject((String)"cad_trackstdcalcresult");
                    EntityUtil.copyPropertiesWithOutId(newDataEntity, dynamicObject);
                    trackNumMap.put(trackNum, newDataEntity);
                }
                ++count;
            }
        }
        for (Map.Entry<String, Set<Long>> entry : trackNumMap.entrySet()) {
            Long trackNum = (Long)((Object)entry.getKey());
            DynamicObject value = (DynamicObject)entry.getValue();
            value.set("tracknumber", (Object)trackNum);
            HashMap<String, Long> keycolMap = new HashMap<String, Long>(16);
            Long matId = 0L;
            matId = value.get("material") instanceof DynamicObject ? Long.valueOf(value.getLong("material.masterid")) : Long.valueOf(value.getLong("material"));
            Long auxproperty = 0L;
            auxproperty = value.get("auxproperty") instanceof DynamicObject ? Long.valueOf(value.getLong("auxproperty.id")) : Long.valueOf(value.getLong("auxproperty"));
            Long configuredcode = 0L;
            configuredcode = value.get("configuredcode") instanceof DynamicObject ? Long.valueOf(value.getLong("configuredcode.id")) : Long.valueOf(value.getLong("configuredcode"));
            Long tracknumber = 0L;
            tracknumber = value.get("tracknumber") instanceof DynamicObject ? Long.valueOf(value.getLong("tracknumber.id")) : Long.valueOf(value.getLong("tracknumber"));
            keycolMap.put("material", matId);
            keycolMap.put("auxproperty", auxproperty);
            keycolMap.put("configuredcode", configuredcode);
            keycolMap.put("tracknumber", tracknumber);
            Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true);
            value.set("keycol", (Object)calcKey.getKeycol());
            value.set("keycolid", (Object)calcKey.getId());
            value.set("keycolid_id", (Object)calcKey.getId());
            this.standCostCalcParam.getKeycols().add(calcKey.getKeycol());
            DynamicObjectCollection entryentity = value.getDynamicObjectCollection("origentryentity");
            for (DynamicObject object : entryentity) {
                int entrylevel = object.getInt("origentrylevel");
                if (entrylevel != 0) continue;
                object.set("origentrytracknumber", value.get("tracknumber"));
                object.set("origentrykeycol", value.get("keycol"));
                object.set("origentrykeycolid", value.get("keycolid"));
                object.set("origentrykeycolid_id", value.get("keycolid"));
            }
            DynamicObjectCollection entryEntity = value.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryEntity) {
                int entrylevel = object.getInt("entrylevel");
                if (entrylevel != 0) continue;
                object.set("entrytracknumber", value.get("tracknumber"));
                object.set("entrykeycol", value.get("keycol"));
                object.set("entrykeycolid", value.get("keycolid"));
                object.set("entrykeycolid_id", value.get("keycolid"));
            }
            resultList.add(value);
        }
        if (!CadEmptyUtils.isEmpty(resultList)) {
            SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
        }
    }

    private void write2Log(String desc) {
        if (this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().finish(ResManager.loadKDString((String)"\u5377\u7b97", (String)"NewFinishFunction_4", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    private void write2LogNew(String desc, long startTime, long endTime, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("\u5377\u7b97\uff08BOM\u6811\uff09:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfoNew(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"NewFinishFunction_8", (String)"macc-cad-algox", (Object[])new Object[0]), desc, startTime, endTime);
        }
    }

    public RowMeta getResultRowMeta() {
        return CalculationNode.getRowMeta();
    }
}

