/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class NonProAndPoolToBasImpFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String MFG_REFER_UPDATE_SQL = "update %s set freferidentity=? where fid = ?";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});

    public NonProAndPoolToBasImpFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        HashSet<Long> nonPrdIds = new HashSet<Long>(16);
        String entityType = this.paramMap.get("entitytype").toString();
        RowX rowX = null;
        for (RowX row : rows) {
            if (rowX == null) {
                rowX = row;
            }
            if ("feebill".equals(row.getString(this.rowMeta.getFieldIndex("type")))) {
                srcBillIds.add(row.getLong(this.rowMeta.getFieldIndex("id")));
            } else {
                nonPrdIds.add(row.getLong(this.rowMeta.getFieldIndex("id")));
            }
            totalAmount = totalAmount.add(row.getBigDecimal(this.rowMeta.getFieldIndex("totalamount")));
        }
        if (!"cad_planbasicalloc".equals(entityType) && BigDecimal.ZERO.compareTo(totalAmount) == 0) {
            this.updateMfgFeeBillReferIndentity(srcBillIds, "cad_mfgfeebill");
            return;
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        if (rowX != null) {
            DynamicObject billObject = this.instanceBasicAllocBill(rowX, totalAmount, srcBillIds, nonPrdIds, entityType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObject});
        }
    }

    protected void updateMfgFeeBillReferIndentity(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("freferidentity", 1, (Object)Character.valueOf('1')), new SqlParameter("fid", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(MFG_REFER_UPDATE_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    private DynamicObject instanceBasicAllocBill(RowX row, BigDecimal totalAmount, Set<Long> srcBillIds, Set<Long> nonPrdIds, String entityType) {
        DynamicObject obj;
        String[] split;
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getAccountId());
        DynamicObject basicAllocObject = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)entityType, (DynamicObject)basicAllocObject, (String)RequestContext.get().getLoginOrg(), (int)1);
        if (batchNumber != null && batchNumber.length > 0) {
            basicAllocObject.set("billno", (Object)batchNumber[0]);
        } else {
            basicAllocObject.set("billno", (Object)ID.genStringId());
        }
        basicAllocObject.set("org", (Object)row.getLong(this.rowMeta.getFieldIndex("org")));
        basicAllocObject.set("costaccount", (Object)row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        basicAllocObject.set("manuorg", (Object)row.getLong(this.rowMeta.getFieldIndex("manuorg")));
        basicAllocObject.set("period", (Object)row.getLong(this.rowMeta.getFieldIndex("period")));
        basicAllocObject.set("allocmold", (Object)"C");
        basicAllocObject.set("costcenter", (Object)row.getLong(this.rowMeta.getFieldIndex("costcenter")));
        basicAllocObject.set("productgroup", (Object)row.getLong(this.rowMeta.getFieldIndex("productgroup")));
        basicAllocObject.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        basicAllocObject.set("amount", (Object)totalAmount);
        basicAllocObject.set("expenseitem", (Object)row.getLong(this.rowMeta.getFieldIndex("expenseitem")));
        String allocDim = row.getString(this.rowMeta.getFieldIndex("allocdim"));
        if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
            for (String arr : split) {
                if (CadEmptyUtils.isEmpty((String)arr)) continue;
                basicAllocObject.set(arr, row.get(this.rowMeta.getFieldIndex(arr)));
            }
        }
        basicAllocObject.set("costdriver", (Object)row.getLong(this.rowMeta.getFieldIndex("costdriver")));
        basicAllocObject.set("srcbilltype", (Object)"A");
        basicAllocObject.set("sourcetype", this.paramMap.get("sourceType"));
        basicAllocObject.set("appnum", this.paramMap.get("appNum"));
        basicAllocObject.set("planscheme", this.paramMap.get("planscheme"));
        basicAllocObject.set("billstatus", (Object)"A");
        basicAllocObject.set("allocstatus", (Object)"0");
        basicAllocObject.set("creator", (Object)userId);
        basicAllocObject.set("createtime", (Object)date);
        basicAllocObject.set("modifier", (Object)userId);
        basicAllocObject.set("modifytime", (Object)date);
        DynamicObjectCollection srcBillEntry = basicAllocObject.getDynamicObjectCollection("srcbillentry");
        int i = 1;
        for (Long id : srcBillIds) {
            obj = srcBillEntry.addNew();
            obj.set("seq", (Object)i++);
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"A");
        }
        i = 1;
        for (Long id : nonPrdIds) {
            obj = srcBillEntry.addNew();
            obj.set("seq", (Object)i++);
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"B");
        }
        return basicAllocObject;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

