/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class PlanResourceRatePublishFunction
extends GroupReduceFunction {
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});
    public RowMeta rowMeta;
    public Long costType;
    public List<String> existRes;
    public Long planSchemeId;
    public Map<String, HashSet<Long>> groupPeriodMap;
    public Map<Long, Date[]> periodDateMap;

    public PlanResourceRatePublishFunction(RowMeta rowMeta, Long costType, List<String> existRes, Long planSchemeId, Map<String, HashSet<Long>> groupPeriodMap, Map<Long, Date[]> periodDateMap) {
        this.rowMeta = rowMeta;
        this.costType = costType;
        this.existRes = existRes;
        this.planSchemeId = planSchemeId;
        this.groupPeriodMap = groupPeriodMap;
        this.periodDateMap = periodDateMap;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        ArrayList periodIdList = null;
        for (RowX row : rows) {
            if (periodIdList == null) {
                Long workCenterId = row.getLong(this.rowMeta.getFieldIndex("workcenter"));
                Long resourceId = row.getLong(this.rowMeta.getFieldIndex("resource"));
                String key = workCenterId + "@" + resourceId;
                Set periodIdSet = this.groupPeriodMap.get(key);
                periodIdList = new ArrayList(periodIdSet);
                periodIdList.sort(Long::compareTo);
            }
            if (!this.instanceResourceBill(row, periodIdList)) continue;
            RowX colRow = new RowX(1);
            colRow.set(0, (Object)1);
            collector.collect(colRow);
        }
    }

    private boolean instanceResourceBill(RowX row, List<Long> periodIdList) {
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        Long workCenterId = row.getLong(this.rowMeta.getFieldIndex("workcenter"));
        Long resourceId = row.getLong(this.rowMeta.getFieldIndex("resource"));
        Long periodId = row.getLong(this.rowMeta.getFieldIndex("period"));
        String resStr = workCenterId + "@" + resourceId + "@" + periodId;
        if (this.existRes.contains(resStr)) {
            return false;
        }
        DynamicObject resource = BusinessDataServiceHelper.newDynamicObject((String)"cad_resourcerate");
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourcerate", (DynamicObject)resource, (String)RequestContext.get().getLoginOrg(), (int)1);
        resource.set("costtype", (Object)this.costType);
        if (batchNumber != null && batchNumber.length > 0) {
            resource.set("billno", (Object)batchNumber[0]);
        } else {
            resource.set("billno", (Object)ID.genStringId());
        }
        Date effectDate = this.periodDateMap.get(row.getLong(this.rowMeta.getFieldIndex("period")))[0];
        resource.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        resource.set("planscheme", (Object)this.planSchemeId);
        resource.set("datasrc", (Object)"planrate");
        resource.set("effectdate", (Object)effectDate);
        this.keepDateContinuous(resource, row, userId, periodIdList);
        resource.set("workcenter", (Object)workCenterId);
        resource.set("resource", (Object)resourceId);
        resource.set("element", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
        resource.set("subelement", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
        resource.set("calcbasis", (Object)"001");
        resource.set("resourceunit", (Object)9L);
        resource.set("qty", (Object)row.getBigDecimal(this.rowMeta.getFieldIndex("planrate")));
        resource.set("pricerule", (Object)row.getLong(this.rowMeta.getFieldIndex("calcruleid")));
        resource.set("billstatus", (Object)"C");
        resource.set("createtime", (Object)date);
        resource.set("modifytime", (Object)date);
        resource.set("auditdate", (Object)date);
        resource.set("creator", (Object)userId);
        resource.set("creator_id", (Object)userId);
        resource.set("modifier", (Object)userId);
        resource.set("modifier_id", (Object)userId);
        resource.set("auditor", (Object)userId);
        resource.set("auditor_id", (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resource});
        this.existRes.add(resStr);
        return true;
    }

    private void keepDateContinuous(DynamicObject resource, RowX row, Long userId, List<Long> periodIdList) {
        if (periodIdList != null && periodIdList.size() > 0) {
            if (periodIdList.size() == 1) {
                this.invalidateBillBeforePeriod(userId, periodIdList.get(0), row.getLong(this.rowMeta.getFieldIndex("workcenter")), row.getLong(this.rowMeta.getFieldIndex("calcruleid")), row.getLong(this.rowMeta.getFieldIndex("resource")), row.getLong(this.rowMeta.getFieldIndex("element")), row.getLong(this.rowMeta.getFieldIndex("subelement")));
                Date expDate = this.invalidateBillAfterPeriod(periodIdList.get(0), row.getLong(this.rowMeta.getFieldIndex("workcenter")), row.getLong(this.rowMeta.getFieldIndex("calcruleid")), row.getLong(this.rowMeta.getFieldIndex("resource")), row.getLong(this.rowMeta.getFieldIndex("element")), row.getLong(this.rowMeta.getFieldIndex("subelement")));
                if (expDate == null) {
                    expDate = DateUtils.getDeFaultExpDate();
                }
                resource.set("expdate", (Object)expDate);
            } else if (Objects.equals(row.getLong(this.rowMeta.getFieldIndex("period")), periodIdList.get(0))) {
                this.invalidateBillBeforePeriod(userId, periodIdList.get(0), row.getLong(this.rowMeta.getFieldIndex("workcenter")), row.getLong(this.rowMeta.getFieldIndex("calcruleid")), row.getLong(this.rowMeta.getFieldIndex("resource")), row.getLong(this.rowMeta.getFieldIndex("element")), row.getLong(this.rowMeta.getFieldIndex("subelement")));
                Long currentPeriodId = row.getLong(this.rowMeta.getFieldIndex("period"));
                Long nextPeriodId = null;
                for (int i = 0; i < periodIdList.size(); ++i) {
                    if (periodIdList.get(i) <= currentPeriodId) continue;
                    nextPeriodId = periodIdList.get(i);
                    break;
                }
                if (nextPeriodId != null) {
                    resource.set("expdate", (Object)this.periodDateMap.get(nextPeriodId)[0]);
                }
            } else if (Objects.equals(row.getLong(this.rowMeta.getFieldIndex("period")), periodIdList.get(periodIdList.size() - 1))) {
                Date expDate = this.invalidateBillAfterPeriod(periodIdList.get(periodIdList.size() - 1), row.getLong(this.rowMeta.getFieldIndex("workcenter")), row.getLong(this.rowMeta.getFieldIndex("calcruleid")), row.getLong(this.rowMeta.getFieldIndex("resource")), row.getLong(this.rowMeta.getFieldIndex("element")), row.getLong(this.rowMeta.getFieldIndex("subelement")));
                if (expDate == null) {
                    expDate = DateUtils.getDeFaultExpDate();
                }
                resource.set("expdate", (Object)expDate);
            } else {
                Long currentPeriodId = row.getLong(this.rowMeta.getFieldIndex("period"));
                Long nextPeriodId = null;
                for (int i = 0; i < periodIdList.size(); ++i) {
                    if (periodIdList.get(i) <= currentPeriodId) continue;
                    nextPeriodId = periodIdList.get(i);
                    break;
                }
                if (nextPeriodId != null) {
                    resource.set("expdate", (Object)this.periodDateMap.get(nextPeriodId)[0]);
                }
            }
        }
    }

    private void invalidateBillBeforePeriod(Long userId, Long periodId, Long workCenter, Long calcRuleId, Long resource, Long element, Long subElement) {
        Date date = TimeServiceHelper.now();
        QFilter filter = new QFilter("costtype", "=", (Object)this.costType);
        filter.and("effectdate", "<", (Object)this.periodDateMap.get(periodId)[0]);
        filter.and("workcenter", "=", (Object)workCenter);
        filter.and("pricerule", "=", (Object)calcRuleId);
        filter.and("resource", "=", (Object)resource);
        filter.and("element", "=", (Object)element);
        filter.and("subelement", "=", (Object)subElement);
        Object[] load = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"modifier,modifytime,expdate", (QFilter[])new QFilter[]{filter}, (String)"effectdate desc", (int)1);
        if (CadEmptyUtils.isEmpty((Object[])load)) {
            return;
        }
        for (Object object : load) {
            object.set("modifier", (Object)userId);
            object.set("modifier_id", (Object)userId);
            object.set("modifytime", (Object)date);
            object.set("expdate", (Object)this.periodDateMap.get(periodId)[0]);
            SaveServiceHelper.update((DynamicObject)object);
        }
    }

    private Date invalidateBillAfterPeriod(Long periodId, Long workCenter, Long calcRuleId, Long resource, Long element, Long subElement) {
        Date date = null;
        QFilter filter = new QFilter("costtype", "=", (Object)this.costType);
        filter.and("effectdate", ">", (Object)this.periodDateMap.get(periodId)[0]);
        filter.and("workcenter", "=", (Object)workCenter);
        filter.and("pricerule", "=", (Object)calcRuleId);
        filter.and("resource", "=", (Object)resource);
        filter.and("element", "=", (Object)element);
        filter.and("subelement", "=", (Object)subElement);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"id,effectdate", (QFilter[])new QFilter[]{filter}, (String)"effectdate asc", (int)1);
        if (load != null && load.length > 0) {
            date = load[0].getDate("effectdate");
        }
        return date;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

