/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanResourceRatePublishMfgFunction
extends GroupReduceFunction {
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});
    public RowMeta rowMeta;
    public Long costType;
    public Long planSchemeId;
    public Map<Long, Date[]> periodDateMap;

    public PlanResourceRatePublishMfgFunction(RowMeta rowMeta, Long costType, Long planSchemeId, Map<Long, Date[]> periodDateMap) {
        this.rowMeta = rowMeta;
        this.costType = costType;
        this.planSchemeId = planSchemeId;
        this.periodDateMap = periodDateMap;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        for (RowX row : rows) {
            this.updateResourceBill(row, row.getLong(this.rowMeta.getFieldIndex("calcruleid")));
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
    }

    private void updateResourceBill(RowX row, long calcRuleId) {
        Long resourceId = row.getLong(this.rowMeta.getFieldIndex("resource"));
        Long workCenterId = row.getLong(this.rowMeta.getFieldIndex("workcenter"));
        QFilter filter = new QFilter("costtype", "=", (Object)this.costType);
        filter.and("planscheme", "=", (Object)this.planSchemeId);
        filter.and("resource", "=", (Object)resourceId);
        filter.and("workcenter", "=", (Object)workCenterId);
        filter.and("pricerule", "=", (Object)calcRuleId);
        Date effectDate = this.periodDateMap.get(row.getLong(this.rowMeta.getFieldIndex("period")))[0];
        filter.and("effectdate", "=", (Object)effectDate);
        Object[] resRates = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"id,entryentity.attaelement,entryentity.attasubelement,entryentity.attaqty", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((Object[])resRates)) {
            return;
        }
        for (Object resRate : resRates) {
            DynamicObjectCollection entryEntity = resRate.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryEntity.addNew();
            entry.set("attaelement", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
            entry.set("attasubelement", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
            entry.set("attaqty", (Object)row.getBigDecimal(this.rowMeta.getFieldIndex("planrate")));
        }
        SaveServiceHelper.save((DynamicObject[])resRates);
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

