/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.Data.CalculationNodeSubElement;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.CostProcessRouteDyo;
import kd.macc.cad.algox.function.NumberUtils;
import kd.macc.cad.algox.function.TimeConverter;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CalcKeyHelper;

public class ProcessRouteCost
implements Serializable {
    private static final Log logger = LogFactory.getLog(ProcessRouteCost.class);
    private List<String> resourceAndOutSourcingProcess = new ArrayList<String>(10){
        {
            this.add("004");
            this.add("005");
        }
    };
    private static final long serialVersionUID = 1L;
    private StandCostCalcParam standCostCalcParam;
    private Map<String, String> materialKeycolRouteMap = new HashMap<String, String>();
    private Map<String, List<CalculationNodeSubElement>> processRouteCost = new HashMap<String, List<CalculationNodeSubElement>>();
    private long commonProcessRouteId = 0L;

    public StandCostCalcParam getStandCostCalcParam() {
        return this.standCostCalcParam;
    }

    public void setStandCostCalcParam(StandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public String findProcessRoute(String materialKeycol) {
        return this.materialKeycolRouteMap.getOrDefault(materialKeycol, this.commonProcessRouteId + "@" + 0L + "@" + 0L);
    }

    public List<CalculationNodeSubElement> findProcessRouteCost(String routeKey) {
        return this.processRouteCost.get(routeKey);
    }

    public List<CalculationNodeSubElement> findProcessRouteCostNew(String routeKey) {
        ArrayList<CalculationNodeSubElement> calculationNodeSubElementList = new ArrayList<CalculationNodeSubElement>(10);
        if (CadEmptyUtils.isEmpty(routeKey)) {
            return calculationNodeSubElementList;
        }
        if (this.processRouteCost.containsKey(routeKey)) {
            calculationNodeSubElementList.addAll((Collection<CalculationNodeSubElement>)this.processRouteCost.get(routeKey));
        }
        String nrouteKey = "";
        Object[] split = routeKey.split("@");
        if (!CadEmptyUtils.isEmpty(split)) {
            nrouteKey = (String)split[0] + "@0@0";
        }
        if (routeKey.equals(nrouteKey)) {
            return calculationNodeSubElementList;
        }
        if (this.processRouteCost.containsKey(nrouteKey)) {
            calculationNodeSubElementList.addAll((Collection<CalculationNodeSubElement>)this.processRouteCost.get(nrouteKey));
        }
        return calculationNodeSubElementList;
    }

    public void calcAllProcessRouteCostForStruct() {
        this.write2Log(ResManager.loadKDString((String)"\u7ed3\u6784\u4f20\u5165-\u5f00\u59cb\u8ba1\u7b97\u6210\u672c\u5de5\u827a\u8def\u7ebf\u7684\u6210\u672c", (String)"ProcessRouteCost_29", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
        Map<Object, DynamicObject> routerIdAndRouterObjMapForStruct = this.standCostCalcParam.getRouterIdAndRouterObjMap();
        if (CadEmptyUtils.isEmpty(routerIdAndRouterObjMapForStruct)) {
            this.write2Log(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u6210\u672c\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteCost_33", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
            return;
        }
        Map<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap = this.getResourceRateIdAndAttachCostMap();
        Map<Long, Map<String, DynamicObject>> resourceIdAndObjMap = this.getResourceAndObjMap();
        Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap = this.getOutResourceAndObjMap();
        HashMap<Long, List> routeIdKeyColMap = new HashMap<Long, List>(16);
        for (Map.Entry<String, Long> entry : this.standCostCalcParam.getConfigBomKeycolRouteMap().entrySet()) {
            routeIdKeyColMap.computeIfAbsent(entry.getValue(), p -> new ArrayList()).add(entry.getKey());
        }
        for (Map.Entry<Object, Long> entry : routerIdAndRouterObjMapForStruct.entrySet()) {
            DynamicObject processRoute = (DynamicObject)entry.getValue();
            CostProcessRouteDyo costProcessRoute = this.getCostProcessRoute(processRoute);
            if (routeIdKeyColMap.containsKey(costProcessRoute.getId())) {
                List matKeyCols = (List)routeIdKeyColMap.get(costProcessRoute.getId());
                for (String matKeyCol : matKeyCols) {
                    this.materialKeycolRouteMap.put(matKeyCol, costProcessRoute.getId() + "@" + costProcessRoute.getMaterial() + "@" + costProcessRoute.getAuxpty());
                }
            }
            this.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, null);
        }
        this.write2Log(ResManager.loadKDString((String)"\u7ed3\u6784\u4f20\u5165-\u7ed3\u675f\u8ba1\u7b97\u6210\u672c\u5de5\u827a\u8def\u7ebf\u7684\u6210\u672c", (String)"ProcessRouteCost_30", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    public void calcAllProcessRouteCost() {
        this.write2Log(ResManager.loadKDString((String)"\u5f00\u59cb\u8ba1\u7b97\u6210\u672c\u5de5\u827a\u8def\u7ebf\u7684\u6210\u672c", (String)"ProcessRouteCost_0", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
        Map<Object, DynamicObject> routerMap = this.standCostCalcParam.getRouterIdAndRouterObjMap();
        if (CadEmptyUtils.isEmpty(routerMap)) {
            this.write2Log(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u8ba1\u7b97\u7684\u6210\u672c\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteCost_33", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
            return;
        }
        Map<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap = this.getResourceRateIdAndAttachCostMap();
        Map<Long, Map<String, DynamicObject>> resourceIdAndObjMap = this.getResourceAndObjMap();
        Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap = this.getOutResourceAndObjMap();
        if (!this.standCostCalcParam.isTrackCalc().booleanValue() && !this.standCostCalcParam.isDefaultConfigCalc().booleanValue()) {
            if (this.standCostCalcParam.isStartRouteRuleCalc().booleanValue()) {
                this.calcRouteForRule(this.standCostCalcParam, routerMap, resourceRateIdAndAttachCostMap, resourceIdAndObjMap, outResourceAndObjMap);
            } else {
                this.calcRouteForSetting(this.standCostCalcParam, routerMap, resourceRateIdAndAttachCostMap, resourceIdAndObjMap, outResourceAndObjMap);
            }
        } else {
            HashMap<Long, List> routeIdKeyColMap = new HashMap<Long, List>(16);
            for (Map.Entry<String, Long> entry : this.standCostCalcParam.getConfigBomKeycolRouteMap().entrySet()) {
                routeIdKeyColMap.computeIfAbsent(entry.getValue(), p -> new ArrayList()).add(entry.getKey());
            }
            for (Map.Entry<Object, Long> entry : routerMap.entrySet()) {
                DynamicObject processRoute = (DynamicObject)entry.getValue();
                CostProcessRouteDyo costProcessRoute = this.getCostProcessRoute(processRoute);
                if (routeIdKeyColMap.containsKey(costProcessRoute.getId())) {
                    List matKeyCols = (List)routeIdKeyColMap.get(costProcessRoute.getId());
                    for (String matKeyCol : matKeyCols) {
                        this.materialKeycolRouteMap.put(matKeyCol, costProcessRoute.getId() + "@" + costProcessRoute.getMaterial() + "@" + costProcessRoute.getAuxpty());
                    }
                }
                this.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, null);
            }
        }
        this.write2Log(ResManager.loadKDString((String)"\u7ed3\u675f\u8ba1\u7b97\u6210\u672c\u5de5\u827a\u8def\u7ebf\u7684\u6210\u672c", (String)"ProcessRouteCost_3", (String)"macc-cad-algox", (Object[])new Object[0]), Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     */
    private void calcRouteForSetting(StandCostCalcParam standCostCalcParam, Map<Object, DynamicObject> cadRouterMap, Map<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap, Map<Long, Map<String, DynamicObject>> resourceIdAndObjMap, Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap) {
        void var12_14;
        if (CadEmptyUtils.isEmpty(cadRouterMap)) {
            return;
        }
        DynamicObject[] routesSetting = this.getProcessRoute(standCostCalcParam.getCostTypeId(), cadRouterMap.keySet());
        HashMap<Long, Set<String>> matGroupCommonRouteKeycolsMap = new HashMap<Long, Set<String>>(16);
        Set<String> calcRouteMaterials = standCostCalcParam.getCalcRouteMaterials();
        Long commonRoute = 0L;
        DynamicObject[] dynamicObjectArray = routesSetting;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var12_14 < n) {
            DynamicObject routeSet = dynamicObjectArray[var12_14];
            if ("B".equals(routeSet.getString("routertype"))) {
                DynamicObjectCollection materialEntry = routeSet.getDynamicObjectCollection("materialentry");
                for (Object matObj : materialEntry) {
                    matGroupCommonRouteKeycolsMap.computeIfAbsent(routeSet.getLong("router.id"), p -> new HashSet()).add(matObj.getString("keycol"));
                    this.materialKeycolRouteMap.put(matObj.getString("keycol"), routeSet.getLong("router.id") + "@" + matObj.getLong("material.id") + "@" + matObj.getLong("auxpty.id"));
                }
            }
            if ("C".equals(routeSet.getString("routertype"))) {
                commonRoute = routeSet.getLong("router.id");
            }
            ++var12_14;
        }
        HashSet<String> matRouteKeycol = new HashSet<String>(10);
        for (DynamicObject routeSet : routesSetting) {
            if ("B".equals(routeSet.getString("routertype")) || "C".equals(routeSet.getString("routertype"))) continue;
            DynamicObjectCollection materialEntry = routeSet.getDynamicObjectCollection("materialentry");
            for (DynamicObject matObj : materialEntry) {
                matRouteKeycol.add(matObj.getString("keycol"));
                this.materialKeycolRouteMap.put(matObj.getString("keycol"), routeSet.getLong("router.id") + "@" + matObj.getLong("material.id") + "@" + matObj.getLong("auxpty.id"));
            }
        }
        calcRouteMaterials.removeAll(matRouteKeycol);
        for (Map.Entry entry : matGroupCommonRouteKeycolsMap.entrySet()) {
            Set value = (Set)entry.getValue();
            value.removeAll(matRouteKeycol);
            calcRouteMaterials.removeAll(value);
        }
        matGroupCommonRouteKeycolsMap.put(commonRoute, calcRouteMaterials);
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(calcRouteMaterials);
        while (bomMatDataSetByKeyCol.hasNext()) {
            Row row = bomMatDataSetByKeyCol.next();
            if (row == null) continue;
            this.materialKeycolRouteMap.put(row.getString("keycol"), commonRoute + "@" + row.getString("material") + "@" + row.getString("auxproperty"));
        }
        for (DynamicObject routeSet : routesSetting) {
            boolean includePrepareTime = routeSet.getBoolean("considerpreparetime");
            DynamicObject processRoute = cadRouterMap.get(routeSet.get("router.id"));
            if (processRoute == null) continue;
            if ("C".equals(routeSet.getString("routertype"))) {
                if (this.commonProcessRouteId == 0L) {
                    this.commonProcessRouteId = processRoute.getLong("id");
                } else {
                    this.write2Log(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u901a\u7528\u5de5\u827a\u8def\u7ebf", (String)"ProcessRouteCost_1", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
                }
            }
            CostProcessRouteDyo costProcessRoute = this.getCostProcessRoute(processRoute);
            costProcessRoute.setIncludePrepareTime(includePrepareTime);
            this.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, matGroupCommonRouteKeycolsMap);
        }
        if (this.commonProcessRouteId == 0L) {
            this.write2Log(ResManager.loadKDString((String)"\u6ca1\u6709\u901a\u7528\u5de5\u827a\u8def\u7ebf", (String)"ProcessRouteCost_2", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
        }
        matGroupCommonRouteKeycolsMap.clear();
    }

    private void calcRouteForRule(StandCostCalcParam standCostCalcParam, Map<Object, DynamicObject> routerMap, Map<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap, Map<Long, Map<String, DynamicObject>> resourceIdAndObjMap, Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap) {
        Object value;
        if (CadEmptyUtils.isEmpty(routerMap)) {
            return;
        }
        DynamicObject routeRuleSettingObj = StdCalculateHelper.getRouteRuleSettingObj(standCostCalcParam.getRouteRuleSetting());
        if (routeRuleSettingObj == null) {
            return;
        }
        Set<String> calcRouteMaterials = standCostCalcParam.getCalcRouteMaterials();
        HashMap<Long, Set<String>> matGroupCommonRouteKeycolsMap = new HashMap<Long, Set<String>>(16);
        boolean includePrepareTime = routeRuleSettingObj.getBoolean("considerpreparetime");
        Long commonRoute = 0L;
        HashMap<Object, Long> routeMatGroupMap = new HashMap<Object, Long>(16);
        for (Map.Entry<Object, DynamicObject> entry : routerMap.entrySet()) {
            DynamicObject dynamicObject = entry.getValue();
            if ("B".equals(dynamicObject.getString("processtype"))) {
                routeMatGroupMap.put(entry.getKey(), dynamicObject.getLong("materialgroup.id"));
            }
            if (!"C".equals(dynamicObject.getString("processtype"))) continue;
            commonRoute = Long.parseLong(entry.getKey().toString());
        }
        this.setMatKeyColRouteMap(routeMatGroupMap, matGroupCommonRouteKeycolsMap, calcRouteMaterials);
        HashSet<String> matRouteKeycol = new HashSet<String>(10);
        for (Map.Entry<Object, DynamicObject> entry : routerMap.entrySet()) {
            value = entry.getValue();
            if ("B".equals(value.getString("processtype")) || "C".equals(value.getString("processtype"))) continue;
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", value.get("material.masterid"));
            keycolMap.put("auxproperty", value.get("auxproperty.id"));
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            matRouteKeycol.add(keycol);
            this.materialKeycolRouteMap.put(keycol, value.getLong("id") + "@" + value.get("material.masterid") + "@" + value.get("auxproperty.id"));
        }
        calcRouteMaterials.removeAll(matRouteKeycol);
        for (Map.Entry entry : matGroupCommonRouteKeycolsMap.entrySet()) {
            value = (Set)entry.getValue();
            value.removeAll(matRouteKeycol);
            calcRouteMaterials.removeAll((Collection<?>)value);
        }
        matGroupCommonRouteKeycolsMap.put(commonRoute, calcRouteMaterials);
        DataSet dataSet = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(calcRouteMaterials);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            this.materialKeycolRouteMap.put(row.getString("keycol"), commonRoute + "@" + row.getString("material") + "@" + row.getString("auxproperty"));
        }
        for (Map.Entry<Object, DynamicObject> route : routerMap.entrySet()) {
            DynamicObject processRoute = route.getValue();
            if (processRoute == null) continue;
            if ("C".equals(processRoute.getString("processtype"))) {
                if (this.commonProcessRouteId == 0L) {
                    this.commonProcessRouteId = processRoute.getLong("id");
                } else {
                    this.write2Log(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u901a\u7528\u5de5\u827a\u8def\u7ebf", (String)"ProcessRouteCost_1", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
                }
            }
            CostProcessRouteDyo costProcessRoute = this.getCostProcessRoute(processRoute);
            costProcessRoute.setIncludePrepareTime(includePrepareTime);
            this.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, matGroupCommonRouteKeycolsMap);
        }
        if (this.commonProcessRouteId == 0L) {
            this.write2Log(ResManager.loadKDString((String)"\u6ca1\u6709\u901a\u7528\u5de5\u827a\u8def\u7ebf", (String)"ProcessRouteCost_2", (String)"macc-cad-algox", (Object[])new Object[0]), new Boolean[0]);
        }
        matGroupCommonRouteKeycolsMap.clear();
    }

    private void setMatKeyColRouteMap(Map<Object, Long> routeMatGroupMap, Map<Long, Set<String>> matGroupCommonRouteKeycolsMap, Set<String> calcRouteMaterials) {
        if (CadEmptyUtils.isEmpty(routeMatGroupMap)) {
            return;
        }
        HashMap<Long, Map> groupIdMats = new HashMap<Long, Map>(16);
        QFilter mftFilter = new QFilter("mftcontrolentry.materialcontrol.id", "in", routeMatGroupMap.values());
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection materialMftInfos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id,masterid,materialattr,mftcontrolentry.materialcontrol materialcontrol", (QFilter[])new QFilter[]{mftFilter, status, enable});
        for (DynamicObject materialMftInfo : materialMftInfos) {
            long material = materialMftInfo.getLong("masterid");
            HashMap<String, Long> keycolMap = new HashMap<String, Long>(16);
            keycolMap.put("material", material);
            String keycol = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol();
            if (!calcRouteMaterials.contains(keycol)) continue;
            groupIdMats.computeIfAbsent(materialMftInfo.getLong("materialcontrol"), p -> new HashMap()).put(keycol, material);
        }
        for (Map.Entry<Object, Long> entry : routeMatGroupMap.entrySet()) {
            Object key = entry.getKey();
            Long value = entry.getValue();
            Map matInfos = (Map)groupIdMats.get(value);
            if (CadEmptyUtils.isEmpty(matInfos)) {
                logger.info("routeMatGroupMap\u7684key\uff1a{}\uff0cvalue\uff1a{}\uff0c\u7269\u6599\u7ec4id\u96c6\u5408\uff1a{}\uff0c\u8be5\u7269\u6599\u7ec4\u5de5\u827a\u8def\u7ebf\u5904\u7406\u7ed3\u675f\u3002", new Object[]{key, value, matInfos});
                continue;
            }
            for (Map.Entry matInfo : matInfos.entrySet()) {
                String keycol = (String)matInfo.getKey();
                Long material = (Long)matInfo.getValue();
                Long auxpty = 0L;
                if (this.materialKeycolRouteMap.containsKey(keycol)) continue;
                this.materialKeycolRouteMap.put(keycol, Long.parseLong(key.toString()) + "@" + material + "@" + auxpty);
            }
            matGroupCommonRouteKeycolsMap.put(Long.parseLong(key.toString()), matInfos.keySet());
        }
    }

    public CostProcessRouteDyo getCostProcessRoute(DynamicObject processRoute) {
        CostProcessRouteDyo costProcessRoute = BomRuleSettingStdCalcHelper.getCostProcessRoute(processRoute, this.standCostCalcParam.getConfigBomKeycolRouteMap());
        this.materialKeycolRouteMap.put(costProcessRoute.getKeycol(), costProcessRoute.getId() + "@" + costProcessRoute.getMaterial() + "@" + costProcessRoute.getAuxpty());
        return costProcessRoute;
    }

    public void calcProcessRouteCost(CostProcessRouteDyo costProcessRoute, Map<Long, Map<String, DynamicObject>> resourceIdAndObjMap, Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap, Map<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap, Map<Long, Set<String>> matGroupCommonRouteKeycolsMap) {
        ArrayList<CalculationNodeSubElement> listCost = new ArrayList<CalculationNodeSubElement>();
        List<CostProcessRouteDyo.processEntryRow> processEntryRows = costProcessRoute.getProcessEntryRows();
        logger.info("\u5de5\u827a\u8def\u7ebfid\uff1a{}\uff0c\u5de5\u5e8f\u4e2a\u6570\uff1a{}", (Object)costProcessRoute.getId(), (Object)processEntryRows.size());
        if (CadEmptyUtils.isEmpty(processEntryRows)) {
            return;
        }
        Long manuOrg = costProcessRoute.getManuOrg();
        Long materialId = costProcessRoute.getMaterial();
        Long auxptyId = costProcessRoute.getAuxpty();
        Long id = costProcessRoute.getId();
        Long processRouteId = costProcessRoute.getProcessRouteId();
        for (CostProcessRouteDyo.processEntryRow processEntryRow2 : processEntryRows) {
            String parent = processEntryRow2.getParent();
            String operationNo = processEntryRow2.getOperationNo();
            Boolean isOutSource = this.standCostCalcParam.getProcessSeqOutSourceMap().get(id + "@" + parent + "@" + operationNo);
            if (isOutSource != null && isOutSource.booleanValue()) {
                this.calcOutSourceOperation(id, processRouteId, manuOrg, materialId, auxptyId, processEntryRow2, outResourceAndObjMap, resourceRateIdAndAttachCostMap, listCost);
                continue;
            }
            List<CostProcessRouteDyo.processEntryRow.ActEntryRow> actEntryRows = processEntryRow2.getActEntryRows();
            Map<String, BigDecimal> activityTimeMap = this.calcOperationTime(actEntryRows, costProcessRoute.getIncludePrepareTime());
            this.write2Log(String.format(ResManager.loadKDString((String)"\u6d3b\u52a8\u5de5\u65f6\u4fe1\u606f\uff1a%s", (String)"ProcessRouteCost_21", (String)"macc-cad-algox", (Object[])new Object[0]), activityTimeMap), new Boolean[0]);
            this.calcOperation(id, manuOrg, materialId, auxptyId, processEntryRow2, resourceIdAndObjMap, resourceRateIdAndAttachCostMap, activityTimeMap, listCost);
        }
        this.saveProcessRouteCosts(costProcessRoute.getId(), listCost);
        this.write2Log(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf[%s]", (String)"ProcessRouteCost_22", (String)"macc-cad-algox", (Object[])new Object[0]), costProcessRoute.getId()), new Boolean[0]);
    }

    private void calcOperation(Long id, Long manuOrg, Long materialId, Long auxptyId, CostProcessRouteDyo.processEntryRow processEntryRow2, Map<Long, Map<String, DynamicObject>> costTypeResourceIdAndObjMap, Map<Long, Map<Long, List<DynamicObject>>> costTypeResourceRateIdAndAttachCostMap, Map<String, BigDecimal> activityTimeMap, List<CalculationNodeSubElement> listCost) {
        BigDecimal batchQty = processEntryRow2.getBaseBatchQty();
        String machiningType = processEntryRow2.getMachiningType();
        if ("1004".equals(machiningType)) {
            logger.info("\u5de5\u827a\u8def\u7ebfid\uff1a{}\uff0c\u5de5\u5e8f\u53f7\uff1a{}\uff0c\u5de5\u5e8f\u52a0\u5de5\u7c7b\u578b\u4e3a\u4e0d\u9650\u5236\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (Object)id, (Object)processEntryRow2.getOperationNo());
            return;
        }
        Long workCenterId = processEntryRow2.getWorkCenterId();
        Long productionOrg = processEntryRow2.getProductionOrg();
        HashMap<String, CostProcessRouteDyo.processEntryRow.ActEntryRow> activityMap = new HashMap<String, CostProcessRouteDyo.processEntryRow.ActEntryRow>(16);
        List<CostProcessRouteDyo.processEntryRow.ActEntryRow> actEntryRows = processEntryRow2.getActEntryRows();
        for (CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow : actEntryRows) {
            activityMap.put(actEntryRow.getActivity() + "@" + actEntryRow.getActResource(), actEntryRow);
        }
        if (CadEmptyUtils.isEmpty(activityMap)) {
            return;
        }
        String outSourceKey = id + "@" + processEntryRow2.getParent() + "@" + processEntryRow2.getOperationNo();
        Boolean isOutSource = this.standCostCalcParam.getProcessSeqOutSourceMap().getOrDefault(outSourceKey, Boolean.TRUE);
        Long costType = 0L;
        costType = isOutSource != false ? this.standCostCalcParam.getProOrgCostTypeMap().get(manuOrg) : this.standCostCalcParam.getProOrgCostTypeMap().get(productionOrg);
        logger.info("\u5de5\u827a\u8def\u7ebfid\uff1a{}\uff0c\u5de5\u5e8f\uff1a{}\uff0c\u6210\u672c\u7c7b\u578bid\uff1a{}", new Object[]{id, processEntryRow2.getOperationNo(), costType});
        if (CadEmptyUtils.isEmpty(costType)) {
            logger.info("\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf-\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7{}\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u7ed3\u675f\u8ba1\u7b97\u3002", (Object)(isOutSource != false ? manuOrg : productionOrg));
            return;
        }
        Map<String, DynamicObject> resourceIdAndObjMap = costTypeResourceIdAndObjMap.get(costType);
        Map<Long, List<DynamicObject>> resourceRateIdAndAttachCostMap = costTypeResourceRateIdAndAttachCostMap.get(costType);
        Map<Long, Long> mnHsCostTypeMap = this.standCostCalcParam.getMnHsCostTypeMap();
        if (mnHsCostTypeMap.containsKey(costType)) {
            Map<String, DynamicObject> subResourceIdAndObjMap = costTypeResourceIdAndObjMap.get(mnHsCostTypeMap.get(costType));
            if (resourceIdAndObjMap == null) {
                resourceIdAndObjMap = subResourceIdAndObjMap;
            } else if (subResourceIdAndObjMap != null) {
                resourceIdAndObjMap.putAll(subResourceIdAndObjMap);
            }
            Map<Long, List<DynamicObject>> subResourceRateIdAndAttachCostMap = costTypeResourceRateIdAndAttachCostMap.get(mnHsCostTypeMap.get(costType));
            if (resourceRateIdAndAttachCostMap == null) {
                resourceRateIdAndAttachCostMap = subResourceRateIdAndAttachCostMap;
            } else if (subResourceRateIdAndAttachCostMap != null) {
                resourceRateIdAndAttachCostMap.putAll(subResourceRateIdAndAttachCostMap);
            }
        }
        for (Map.Entry activity : activityMap.entrySet()) {
            CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow = (CostProcessRouteDyo.processEntryRow.ActEntryRow)activity.getValue();
            long resourceId = actEntryRow.getActResource();
            String processStage = actEntryRow.getProcessStage();
            DynamicObject resourcePriceObj = this.findResourcePrice(workCenterId, resourceId, resourceIdAndObjMap);
            this.write2Log(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u8d44\u6e90\u83b7\u53d6\u7684\u4ef7\u76ee\u8868\u6570\u636e\uff1a%s", (String)"ProcessRouteCost_7", (String)"macc-cad-algox", (Object[])new Object[0]), resourcePriceObj), new Boolean[0]);
            if (resourcePriceObj != null) {
                CalculationNodeSubElement subElement;
                BigDecimal resourceQty = BigDecimal.ZERO;
                this.write2Log(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u8d44\u6e90\u83b7\u53d6\u7684\u8ba1\u7b97\u4f9d\u636e\uff1a%s\u3002", (String)"ProcessRouteCost_8", (String)"macc-cad-algox", (Object[])new Object[0]), resourcePriceObj.getString("calcbasis")), new Boolean[0]);
                if ("001".equals(resourcePriceObj.getString("calcbasis").trim())) {
                    resourceQty = resourcePriceObj.getBigDecimal("qty");
                    this.write2Log(String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u4e3a\u3010\u8d44\u6e90\u5de5\u65f6\u3011\u65f6\uff0c\u8d44\u6e90\u3010%1$s\u3011\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u7684\u5355\u4ef7\uff1a%2$s", (String)"ProcessRouteCost_23", (String)"macc-cad-algox", (Object[])new Object[0]), resourceId, resourceQty), new Boolean[0]);
                    this.calActitityCost(resourcePriceObj, activityTimeMap, resourceQty, resourcePriceObj.getLong("element.id"), resourcePriceObj.getLong("subelement.id"), listCost, processEntryRow2, actEntryRow, "1", workCenterId, materialId, auxptyId);
                } else if ("002".equals(resourcePriceObj.getString("calcbasis").trim())) {
                    resourceQty = resourcePriceObj.getBigDecimal("amount");
                    subElement = new CalculationNodeSubElement();
                    subElement.setResourceId(resourcePriceObj.getLong("resource.id"));
                    subElement.setResourceType("1");
                    subElement.setElement(resourcePriceObj.getLong("element.id"));
                    subElement.setSubElement(resourcePriceObj.getLong("subelement.id"));
                    subElement.setQty(BigDecimal.ONE);
                    subElement.setPrice(resourceQty);
                    subElement.setCost(resourceQty);
                    subElement.setProcessStage(processStage);
                    subElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
                    this.setResourceInfo(subElement, workCenterId, materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
                    listCost.add(subElement);
                } else if ("003".equals(resourcePriceObj.getString("calcbasis").trim())) {
                    resourceQty = resourcePriceObj.getBigDecimal("amount");
                    subElement = new CalculationNodeSubElement();
                    subElement.setResourceId(resourcePriceObj.getLong("resource.id"));
                    subElement.setResourceType("1");
                    subElement.setElement(resourcePriceObj.getLong("element.id"));
                    subElement.setSubElement(resourcePriceObj.getLong("subelement.id"));
                    subElement.setQty(BigDecimal.ONE);
                    resourceQty = NumberUtils.divide(resourceQty, batchQty, this.standCostCalcParam.getBizLogger(), String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u201c%s\u201d\u57fa\u672c\u6279\u91cf\u4e3a0\u3002", (String)"ProcessRouteCost_10", (String)"macc-cad-algox", (Object[])new Object[0]), processEntryRow2.getOperation()), this.standCostCalcParam.getPriceprecision());
                    subElement.setPrice(resourceQty);
                    subElement.setCost(resourceQty);
                    subElement.setProcessStage(processStage);
                    subElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
                    this.setResourceInfo(subElement, workCenterId, materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
                    listCost.add(subElement);
                }
                this.calcAttachCost(resourcePriceObj, resourceRateIdAndAttachCostMap, activityTimeMap, listCost, processEntryRow2, actEntryRow, "1", workCenterId, materialId, auxptyId);
                continue;
            }
            this.write2Log(String.format(ResManager.loadKDString((String)"\u8d44\u6e90%s\u6ca1\u6709\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u3002", (String)"ProcessRouteCost_11", (String)"macc-cad-algox", (Object[])new Object[0]), resourceId), new Boolean[0]);
        }
    }

    private void calcOutSourceOperation(Long id, Long processRouteId, Long manuOrg, Long materialId, Long auxptyId, CostProcessRouteDyo.processEntryRow processEntryRow2, Map<Long, Map<String, List<DynamicObject>>> outResourceAndObjMap, Map<Long, Map<Long, List<DynamicObject>>> costTypeResourceRateIdAndAttachCostMap, List<CalculationNodeSubElement> listCost) {
        Long costType;
        String machiningType = processEntryRow2.getMachiningType();
        if ("1004".equals(machiningType)) {
            logger.info("\u5de5\u827a\u8def\u7ebfid\uff1a{}\uff0c\u5de5\u5e8f\u53f7\uff1a{}\uff0c\u5de5\u5e8f\u52a0\u5de5\u7c7b\u578b\u4e3a\u4e0d\u9650\u5236\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (Object)id, (Object)processEntryRow2.getOperationNo());
            return;
        }
        String outSourceKey = id + "@" + processEntryRow2.getParent() + "@" + processEntryRow2.getOperationNo();
        String oprSourceEntryId = processEntryRow2.getOprSourceEntryId();
        if (!CadEmptyUtils.isEmpty(oprSourceEntryId)) {
            outSourceKey = processRouteId + "@" + processEntryRow2.getParent() + "@" + processEntryRow2.getOperationNo();
        }
        if (CadEmptyUtils.isEmpty(costType = this.standCostCalcParam.getProOrgCostTypeMap().get(manuOrg))) {
            logger.info("\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf\u5916\u534f\u8d44\u6e90-\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7{}\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u7ed3\u675f\u8ba1\u7b97\u3002", (Object)manuOrg);
            return;
        }
        logger.info("\u5de5\u827a\u8def\u7ebfid\uff1a{}\uff0c\u5de5\u5e8f\uff1a{}\uff0c\u6210\u672c\u7c7b\u578bid\uff1a{}", new Object[]{id, processEntryRow2.getOperationNo(), costType});
        Map<String, List<DynamicObject>> resourceKeyAndObjMap = outResourceAndObjMap.get(costType);
        Map<Long, List<DynamicObject>> resourceRateIdAndAttachCostMap = costTypeResourceRateIdAndAttachCostMap.get(costType);
        Map<Long, Long> mnHsCostTypeMap = this.standCostCalcParam.getMnHsCostTypeMap();
        if (mnHsCostTypeMap.containsKey(costType)) {
            Map<String, List<DynamicObject>> subResourceIdAndObjMap = outResourceAndObjMap.get(mnHsCostTypeMap.get(costType));
            if (resourceKeyAndObjMap == null) {
                resourceKeyAndObjMap = subResourceIdAndObjMap;
            } else if (subResourceIdAndObjMap != null) {
                resourceKeyAndObjMap.putAll(subResourceIdAndObjMap);
            }
            Map<Long, List<DynamicObject>> subResourceRateIdAndAttachCostMap = costTypeResourceRateIdAndAttachCostMap.get(mnHsCostTypeMap.get(costType));
            if (resourceRateIdAndAttachCostMap == null) {
                resourceRateIdAndAttachCostMap = subResourceRateIdAndAttachCostMap;
            } else if (subResourceRateIdAndAttachCostMap != null) {
                resourceRateIdAndAttachCostMap.putAll(subResourceRateIdAndAttachCostMap);
            }
        }
        if (CadEmptyUtils.isEmpty(resourceKeyAndObjMap)) {
            return;
        }
        List<DynamicObject> dynamicObjects = resourceKeyAndObjMap.get(outSourceKey);
        if (!CadEmptyUtils.isEmpty(dynamicObjects)) {
            for (DynamicObject resourcePriceObj : dynamicObjects) {
                CalculationNodeSubElement subElement = new CalculationNodeSubElement();
                subElement.setResourceId(resourcePriceObj.getLong("resource.id"));
                subElement.setResourceType("2");
                subElement.setElement(resourcePriceObj.getLong("element.id"));
                subElement.setSubElement(resourcePriceObj.getLong("subelement.id"));
                subElement.setQty(BigDecimal.ONE);
                subElement.setPrice(resourcePriceObj.getBigDecimal("amount"));
                subElement.setCost(resourcePriceObj.getBigDecimal("amount"));
                subElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
                this.setResourceInfo(subElement, processEntryRow2.getWorkCenterId(), materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
                listCost.add(subElement);
                long recId = resourcePriceObj.getLong("id");
                List<DynamicObject> attachList = resourceRateIdAndAttachCostMap == null ? null : resourceRateIdAndAttachCostMap.get(recId);
                if (attachList == null || CadEmptyUtils.isEmpty(attachList)) continue;
                for (DynamicObject obj : attachList) {
                    long subElementId = obj.getLong("entryentity.attasubelement.id");
                    long elementId = obj.getLong("entryentity.attaelement.id");
                    BigDecimal value = obj.getBigDecimal("entryentity.attaamt");
                    CalculationNodeSubElement attSubElement = new CalculationNodeSubElement();
                    attSubElement.setResourceId(resourcePriceObj.getLong("resource.id"));
                    attSubElement.setResourceType("2");
                    attSubElement.setElement(elementId);
                    attSubElement.setSubElement(subElementId);
                    attSubElement.setQty(BigDecimal.ONE);
                    attSubElement.setPrice(value);
                    attSubElement.setCost(value);
                    attSubElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
                    this.setResourceInfo(attSubElement, processEntryRow2.getWorkCenterId(), materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
                    listCost.add(attSubElement);
                    this.write2Log(String.format(ResManager.loadKDString((String)"\u6309\u7269\u6599\u8ba1\u7b97\u6d3b\u52a8\u6210\u672c\u56e0\u5b50\u2014>\u6210\u672c\u8981\u7d20\uff1a%1$s\u6210\u672c\u5b50\u8981\u7d20\uff1a%2$s\u5355\u4ef7\uff1a%3$s\u6570\u91cf\uff1a%4$s", (String)"ProcessRouteCost_34", (String)"macc-cad-algox", (Object[])new Object[0]), elementId, subElementId, value, 1), new Boolean[0]);
                }
            }
        }
    }

    private void setResourceInfo(CalculationNodeSubElement subElement, Long workCenterId, Long materialId, Long auxptyId, Long operation, String operationDesc, String processSeq, String operationNo) {
        subElement.setResMaterialId(materialId);
        subElement.setResMaterialAuxptyId(auxptyId);
        subElement.setResWorkCenterId(workCenterId);
        subElement.setOperationId(operation);
        subElement.setOperationDesc(operationDesc);
        subElement.setProcessSeq(processSeq);
        subElement.setOperationNo(operationNo);
    }

    private Map<String, DynamicObject> getUnRepeatedActivities(DynamicObject processEntryObj) {
        DynamicObjectCollection actEntryEntity = processEntryObj.getDynamicObjectCollection("actentryentity");
        if (CadEmptyUtils.isEmpty(actEntryEntity)) {
            return new HashMap<String, DynamicObject>(16);
        }
        Map<String, DynamicObject> activityMap = actEntryEntity.stream().collect(Collectors.toMap(item -> item.getLong("activity.id") + "@" + item.getLong("actresource.id"), item -> item, (v1, v2) -> v1));
        return activityMap;
    }

    private void calcAttachCost(DynamicObject resourcePriceObj, Map<Long, List<DynamicObject>> resourceRateIdAndAttachCostMap, Map<String, BigDecimal> activityTimeMap, List<CalculationNodeSubElement> listCost, CostProcessRouteDyo.processEntryRow processEntryRow2, CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow, String resourceType, Long workCenterId, Long materialId, Long auxptyId) {
        List<DynamicObject> attachList;
        long recId = resourcePriceObj.getLong("id");
        List<DynamicObject> list = attachList = resourceRateIdAndAttachCostMap == null ? null : resourceRateIdAndAttachCostMap.get(recId);
        if (attachList == null || attachList.isEmpty()) {
            return;
        }
        for (DynamicObject obj : attachList) {
            long subElementId = obj.getLong("entryentity.attasubelement.id");
            long elementId = obj.getLong("entryentity.attaelement.id");
            BigDecimal value = BigDecimal.ZERO;
            if ("001".equals(obj.getString("calcbasis").trim())) {
                value = obj.getBigDecimal("entryentity.attaqty");
            } else if ("003".equals(obj.getString("calcbasis").trim())) {
                BigDecimal batchQty = processEntryRow2.getBaseBatchQty();
                value = obj.getBigDecimal("entryentity.attaamt");
                value = NumberUtils.divide(value, batchQty, this.standCostCalcParam.getBizLogger(), String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u201c%s\u201d\u57fa\u672c\u6279\u91cf\u4e3a0\u3002", (String)"ProcessRouteCost_10", (String)"macc-cad-algox", (Object[])new Object[0]), processEntryRow2.getOperation()), this.standCostCalcParam.getPriceprecision());
            } else {
                value = obj.getBigDecimal("entryentity.attaamt");
            }
            this.calActitityCost(resourcePriceObj, activityTimeMap, value, elementId, subElementId, listCost, processEntryRow2, actEntryRow, resourceType, workCenterId, materialId, auxptyId);
        }
    }

    private void calActitityCost(DynamicObject resourcePriceObj, Map<String, BigDecimal> activityTimeMap, BigDecimal resourceQty, long elementId, long subElementId, List<CalculationNodeSubElement> listCost, CostProcessRouteDyo.processEntryRow processEntryRow2, CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow, String resourceType, Long workCenterId, Long materialId, Long auxptyId) {
        String processStage = actEntryRow.getProcessStage();
        if ("001".equals(resourcePriceObj.getString("calcbasis").trim())) {
            long resourceId = actEntryRow.getActResource();
            long activityId = actEntryRow.getActivity();
            BigDecimal minuteValue = TimeConverter.convertPriceByConversionFactor(resourcePriceObj.getLong("resourceunit.id"), 9L, resourceQty);
            this.write2Log(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u7684\u8f6c\u6362\u6210\u672c\u5355\u4f4d\u5206\u949f\u7684\u5355\u4ef7\uff1a%s", (String)"ProcessRouteCost_12", (String)"macc-cad-algox", (Object[])new Object[0]), minuteValue), new Boolean[0]);
            for (Map.Entry<String, BigDecimal> activityTime : activityTimeMap.entrySet()) {
                String[] activityIdAndResourceId;
                if (CadEmptyUtils.isEmpty(activityTime.getKey()) || (activityIdAndResourceId = activityTime.getKey().split("@")).length < 2) continue;
                long resourceIdInMap = Long.parseLong(activityIdAndResourceId[1]);
                long activityIdInMap = Long.parseLong(activityIdAndResourceId[0]);
                if (resourceIdInMap != resourceId || activityIdInMap != activityId) continue;
                BigDecimal totalTime = activityTime.getValue();
                BigDecimal resourceCost = totalTime.multiply(minuteValue).setScale(this.standCostCalcParam.getPriceprecision(), 4);
                CalculationNodeSubElement subElement = new CalculationNodeSubElement();
                subElement.setResourceId(resourcePriceObj.getLong("resource.id"));
                subElement.setResourceType(resourceType);
                subElement.setElement(elementId);
                subElement.setSubElement(subElementId);
                subElement.setQty(totalTime);
                subElement.setPrice(minuteValue);
                subElement.setCost(resourceCost);
                subElement.setActivityId(Long.parseLong(activityIdAndResourceId[0]));
                subElement.setProcessStage(processStage);
                subElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
                this.setResourceInfo(subElement, workCenterId, materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
                listCost.add(subElement);
                this.write2Log(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6d3b\u52a8\u6210\u672c\u56e0\u5b50\u2014>\u6d3b\u52a8\uff1a%1$s\u6210\u672c\u8981\u7d20\uff1a%2$s\u6210\u672c\u5b50\u8981\u7d20\uff1a%3$s\u5355\u4ef7\uff1a%4$s\u6570\u91cf\uff1a%5$s", (String)"ProcessRouteCost_24", (String)"macc-cad-algox", (Object[])new Object[0]), activityTime.getKey(), elementId, subElementId, minuteValue, totalTime), new Boolean[0]);
            }
        } else {
            CalculationNodeSubElement subElement = new CalculationNodeSubElement();
            subElement.setResourceId(resourcePriceObj.getLong("resource.id"));
            subElement.setResourceType(resourceType);
            subElement.setElement(elementId);
            subElement.setSubElement(subElementId);
            subElement.setQty(BigDecimal.ONE);
            subElement.setPrice(resourceQty);
            subElement.setCost(resourceQty);
            subElement.setProcessStage(processStage);
            subElement.setCalcbasis(resourcePriceObj.getString("calcbasis").trim());
            this.setResourceInfo(subElement, workCenterId, materialId, auxptyId, processEntryRow2.getOperation(), processEntryRow2.getOperationDesc(), processEntryRow2.getParent(), processEntryRow2.getOperationNo());
            listCost.add(subElement);
            this.write2Log(String.format(ResManager.loadKDString((String)"\u6309\u6279\u6b21\u6216\u7269\u6599\u8ba1\u7b97\u6d3b\u52a8\u6210\u672c\u56e0\u5b50\u2014>\u6210\u672c\u8981\u7d20\uff1a%1$s\u6210\u672c\u5b50\u8981\u7d20\uff1a%2$s\u5355\u4ef7\uff1a%3$s\u6570\u91cf\uff1a%4$s", (String)"ProcessRouteCost_25", (String)"macc-cad-algox", (Object[])new Object[0]), elementId, subElementId, resourceQty, 1), new Boolean[0]);
        }
    }

    private Map<String, BigDecimal> calcOperationTime(List<CostProcessRouteDyo.processEntryRow.ActEntryRow> actEntryRows, boolean includePrepareTime) {
        HashMap<String, BigDecimal> activityTimeMap = new HashMap<String, BigDecimal>(16);
        for (CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow : actEntryRows) {
            long activeId = actEntryRow.getActivity();
            long actResourceId = actEntryRow.getActResource();
            String key = activeId + "@" + actResourceId;
            BigDecimal ts = activityTimeMap.containsKey(key) ? (BigDecimal)activityTimeMap.get(key) : BigDecimal.ZERO;
            BigDecimal minuteQty = TimeConverter.convertHourByConversionFactor(actEntryRow.getActivityUnit(), 9L, actEntryRow.getBaseQty());
            if ("C".equals(actEntryRow.getProcessStage())) {
                ts = ts.add(minuteQty);
            } else if (includePrepareTime) {
                ts = ts.add(minuteQty);
            }
            activityTimeMap.put(key, ts);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u6d3b\u52a8\u5de5\u65f6\u6570\u636e\u4e2a\u6570\uff1a%s", (String)"ProcessRouteCost_15", (String)"macc-cad-algox", (Object[])new Object[0]), activityTimeMap.size()), new Boolean[0]);
        return activityTimeMap;
    }

    public DynamicObject[] getProcessRoute(Long costTypeId, Set<Object> routerIds) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("router", "in", routerIds);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] processRoute = BusinessDataServiceHelper.load((String)"cad_routersetting", (String)"materialentry.keycol,materialentry.material,materialentry.auxpty,router.id,considerpreparetime,routertype", (QFilter[])new QFilter[]{filter}, null);
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u827a\u8def\u7ebf%s\u4e2a\u3002", (String)"ProcessRouteCost_26", (String)"macc-cad-algox", (Object[])new Object[0]), processRoute.length), new Boolean[0]);
        return processRoute;
    }

    private DynamicObject findResourcePrice(Long workCenterId, Long resourceId, Map<String, DynamicObject> resourceIdAndObjMap) {
        DynamicObject resourceObj = null;
        if (CadEmptyUtils.isEmpty(resourceIdAndObjMap)) {
            return resourceObj;
        }
        resourceObj = resourceIdAndObjMap.get("1@" + workCenterId + "@" + resourceId);
        if (resourceObj == null) {
            resourceObj = resourceIdAndObjMap.get("1@0@" + resourceId);
        }
        return resourceObj;
    }

    private List<DynamicObject> findAttachCostListByResource(long recId, Map<Long, List<DynamicObject>> resourceRateIdAndAttachCostMap) {
        List<DynamicObject> attachCostList = resourceRateIdAndAttachCostMap.get(recId);
        if (!CadEmptyUtils.isEmpty(attachCostList)) {
            return attachCostList;
        }
        return new ArrayList<DynamicObject>(10);
    }

    public Map<Long, Map<Long, List<DynamicObject>>> getResourceRateIdAndAttachCostMap() {
        HashMap<Long, Map<Long, List<DynamicObject>>> resourceRateIdAndAttachCostMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(16);
        QFilter filter = new QFilter("id", "in", this.standCostCalcParam.getInSourceObjIds());
        QFilter outFilter = new QFilter("id", "in", this.standCostCalcParam.getOutSourceObjIds());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter typeFilter = new QFilter("subelement.type", "in", this.resourceAndOutSourcingProcess);
        QFilter attFilter = new QFilter("entryentity.attaelement.id", "is not null", null);
        DynamicObjectCollection priceList = QueryServiceHelper.query((String)"cad_resourcerate", (String)"id,costtype,resource.id,calcbasis,entryentity.attaelement.id,entryentity.attasubelement.id,entryentity.attaamt,entryentity.attaqty", (QFilter[])new QFilter[]{filter, statusFilter, typeFilter, attFilter});
        DynamicObjectCollection outPriceList = QueryServiceHelper.query((String)"cad_resourceout", (String)"id,costtype,resource.id,calcbasis,entryentity.attaelement.id,entryentity.attasubelement.id,entryentity.attaamt,entryentity.attaqty", (QFilter[])new QFilter[]{outFilter, statusFilter, typeFilter, attFilter});
        logger.info("\u81ea\u5236\u8d44\u6e90-\u4ef7\u76ee\u8868id\uff1a{}\uff0c\u9644\u52a0\u5236\u9020\u8d39\u7528{}\u4e2a\u3002", this.standCostCalcParam.getInSourceObjIds(), (Object)priceList.size());
        logger.info("\u5916\u534f\u8d44\u6e90-\u4ef7\u76ee\u8868id\uff1a{}\uff0c\u9644\u52a0\u5236\u9020\u8d39\u7528{}\u4e2a\u3002", this.standCostCalcParam.getOutSourceObjIds(), (Object)outPriceList.size());
        priceList.addAll((Collection)outPriceList);
        for (DynamicObject resourcePriceObj : priceList) {
            Long id = resourcePriceObj.getLong("id");
            Map costTypeAttrResourceMap = resourceRateIdAndAttachCostMap.computeIfAbsent(resourcePriceObj.getLong("costtype"), p -> new HashMap());
            costTypeAttrResourceMap.computeIfAbsent(id, p -> new ArrayList()).add(resourcePriceObj);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u9644\u52a0\u5236\u9020\u8d39\u7528%s\u4e2a", (String)"ProcessRouteCost_27", (String)"macc-cad-algox", (Object[])new Object[0]), priceList.size()), new Boolean[0]);
        return resourceRateIdAndAttachCostMap;
    }

    public Map<Long, Map<String, DynamicObject>> getResourceAndObjMap() {
        HashMap<Long, Map<String, DynamicObject>> resourceAndObjMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        QFilter filter = new QFilter("id", "in", this.standCostCalcParam.getInSourceObjIds());
        DynamicObjectCollection resourceObjs = StdCalculateHelper.getInResourceObjs(filter.toArray());
        for (DynamicObject resourcePriceObj : resourceObjs) {
            Long workCenterId = resourcePriceObj.get("workcenter.id") == null ? 0L : resourcePriceObj.getLong("workcenter.id");
            Long resourceId = resourcePriceObj.getLong("resource.id");
            Long costtype = resourcePriceObj.getLong("costtype");
            String key = "1@" + workCenterId + "@" + resourceId;
            Map map = resourceAndObjMap.computeIfAbsent(costtype, p -> new HashMap());
            if (map.containsKey(key)) continue;
            map.put(key, resourcePriceObj);
            if (!this.standCostCalcParam.getMnHsCostTypeMap().containsKey(costtype)) {
                this.standCostCalcParam.getResourcePriceRuleMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, PriceRuleConstants.SELFRES_STDCOST_ID);
            } else {
                this.standCostCalcParam.getResourcePriceRuleMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, resourcePriceObj.getLong("pricerule"));
            }
            this.standCostCalcParam.getResourcePriceIdMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, resourcePriceObj.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u6570\u636e\u4e2a\u6570\uff1a%s", (String)"ProcessRouteCost_31", (String)"macc-cad-algox", (Object[])new Object[0]), resourceObjs.size()), new Boolean[0]);
        return resourceAndObjMap;
    }

    public Map<Long, Map<String, List<DynamicObject>>> getOutResourceAndObjMap() {
        HashMap<Long, Map<String, List<DynamicObject>>> resourceAndObjMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        QFilter filter = new QFilter("id", "in", this.standCostCalcParam.getOutSourceObjIds());
        DynamicObjectCollection resourceObjs = StdCalculateHelper.getOutResourceObjs(filter.toArray());
        for (DynamicObject resourcePriceObj : resourceObjs) {
            Long routeId = resourcePriceObj.get("route.id") == null ? 0L : resourcePriceObj.getLong("route.id");
            String processSeq = resourcePriceObj.getString("processseq");
            String operationNo = resourcePriceObj.getString("operationno");
            Long resourceId = resourcePriceObj.getLong("resource.id");
            Long costtype = resourcePriceObj.getLong("costtype");
            String key = "2@" + routeId + "@" + processSeq + "@" + operationNo + "@" + resourceId;
            Map map = resourceAndObjMap.computeIfAbsent(costtype, p -> new HashMap());
            map.computeIfAbsent(routeId + "@" + processSeq + "@" + operationNo, p -> new ArrayList()).add(resourcePriceObj);
            if (!this.standCostCalcParam.getMnHsCostTypeMap().containsKey(costtype)) {
                this.standCostCalcParam.getResourcePriceRuleMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, PriceRuleConstants.OUTRES_STDCOST_ID);
            } else {
                this.standCostCalcParam.getResourcePriceRuleMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, resourcePriceObj.getLong("pricerule"));
            }
            this.standCostCalcParam.getResourcePriceIdMap().computeIfAbsent(costtype, p -> new HashMap()).put(key, resourcePriceObj.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u6570\u636e\u4e2a\u6570\uff1a%s", (String)"ProcessRouteCost_32", (String)"macc-cad-algox", (Object[])new Object[0]), resourceObjs.size()), new Boolean[0]);
        return resourceAndObjMap;
    }

    private void saveProcessRouteCosts(Long processRouteId, List<CalculationNodeSubElement> listCost) {
        Lists.partition(listCost, (int)1000).forEach(list -> {
            ArrayList<DynamicObject> processRouteCosts = new ArrayList<DynamicObject>(10);
            for (CalculationNodeSubElement subElement : list) {
                DynamicObject processRouteCost = BusinessDataServiceHelper.newDynamicObject((String)"cad_calprocessroutecost");
                processRouteCost.set("costtype", (Object)this.standCostCalcParam.getCostTypeId());
                processRouteCost.set("router", (Object)processRouteId);
                processRouteCost.set("resource", (Object)subElement.getResourceId());
                processRouteCost.set("resourcetype", (Object)subElement.getResourceType());
                processRouteCost.set("element", (Object)subElement.getElement());
                processRouteCost.set("subelement", (Object)subElement.getSubElement());
                processRouteCost.set("qty", (Object)subElement.getQty());
                processRouteCost.set("price", (Object)subElement.getPrice());
                processRouteCost.set("cost", (Object)subElement.getCost());
                processRouteCost.set("activity", (Object)subElement.getActivityId());
                processRouteCost.set("calcbasis", (Object)subElement.getCalcbasis());
                processRouteCost.set("billstatus", (Object)"A");
                processRouteCost.set("task", (Object)this.standCostCalcParam.getTaskId());
                processRouteCost.set("creator", (Object)RequestContext.get().getCurrUserId());
                processRouteCost.set("workcenter", (Object)subElement.getResWorkCenterId());
                processRouteCost.set("operation", (Object)subElement.getOperationId());
                processRouteCost.set("operationdesc", (Object)subElement.getOperationDesc());
                processRouteCost.set("material", (Object)subElement.getResMaterialId());
                processRouteCost.set("auxpty", (Object)subElement.getResMaterialAuxptyId());
                processRouteCost.set("createtime", (Object)new Date());
                processRouteCost.set("processstage", (Object)subElement.getProcessStage());
                processRouteCost.set("processSeq", (Object)subElement.getProcessSeq());
                processRouteCost.set("operationno", (Object)subElement.getOperationNo());
                processRouteCosts.add(processRouteCost);
            }
            SaveServiceHelper.save((DynamicObject[])processRouteCosts.toArray(new DynamicObject[0]));
        });
    }

    private void write2Log(String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u8d39\u6210\u672c", (String)"ProcessRouteCost_20", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    public void setProcessRouteCost(Map<String, List<CalculationNodeSubElement>> processRouteCost) {
        this.processRouteCost = processRouteCost;
    }
}

