/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ResourceRateImportActualFunction
extends GroupReduceFunction {
    public RowMeta rowMeta;
    public Long costType;
    public List<String> existRes;

    public ResourceRateImportActualFunction(RowMeta rowMeta, Long costType, List<String> existRes) {
        this.rowMeta = rowMeta;
        this.costType = costType;
        this.existRes = existRes;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashSet<Long> periods = new HashSet<Long>(10);
        RowX rowX = null;
        for (RowX row : rows) {
            if (rowX == null) {
                rowX = row;
            }
            periods.add(row.getLong(this.rowMeta.getFieldIndex("period")));
            totalAmount = totalAmount.add(row.getBigDecimal(this.rowMeta.getFieldIndex("actualrate")));
        }
        if (rowX == null) {
            return;
        }
        Long workCenterId = rowX.getLong(this.rowMeta.getFieldIndex("workcenter"));
        Long resourceId = rowX.getLong(this.rowMeta.getFieldIndex("resource"));
        String resStr = workCenterId + "@" + resourceId;
        if (this.existRes.contains(resStr)) {
            return;
        }
        BigDecimal actualRate = totalAmount.divide(new BigDecimal(periods.size()), 10, 4);
        RowX colRow = new RowX(6);
        colRow.set(0, (Object)rowX.getLong(this.rowMeta.getFieldIndex("resource")));
        colRow.set(1, (Object)rowX.getLong(this.rowMeta.getFieldIndex("currency")));
        colRow.set(2, (Object)rowX.getLong(this.rowMeta.getFieldIndex("workcenter")));
        colRow.set(3, (Object)rowX.getLong(this.rowMeta.getFieldIndex("element")));
        colRow.set(4, (Object)rowX.getLong(this.rowMeta.getFieldIndex("subelement")));
        colRow.set(5, (Object)actualRate);
        collector.collect(colRow);
        this.existRes.add(resStr);
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(new Field[]{new Field("resource", (DataType)DataType.LongType), new Field("currency", (DataType)DataType.LongType), new Field("workcenter", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("actualrate", (DataType)DataType.BigDecimalType)});
    }
}

