/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.DateUtils;

public class ResourceRateImportFunction
extends GroupReduceFunction {
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});
    public RowMeta rowMeta;
    public Long costType;
    public List<String> existRes;

    public ResourceRateImportFunction(RowMeta rowMeta, Long costType, List<String> existRes) {
        this.rowMeta = rowMeta;
        this.costType = costType;
        this.existRes = existRes;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashSet<Long> periods = new HashSet<Long>(10);
        RowX rowX = null;
        for (RowX row : rows) {
            if (rowX == null) {
                rowX = row;
            }
            periods.add(row.getLong(this.rowMeta.getFieldIndex("period")));
            totalAmount = totalAmount.add(row.getBigDecimal(this.rowMeta.getFieldIndex("actualrate")));
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        BigDecimal actualRate = totalAmount.divide(new BigDecimal(periods.size()), 10, 4);
        if (rowX != null) {
            this.instanceResourceBill(rowX, actualRate);
        }
    }

    private void instanceResourceBill(RowX row, BigDecimal actualRate) {
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        Long workCenterId = row.getLong(this.rowMeta.getFieldIndex("workcenter"));
        Long resourceId = row.getLong(this.rowMeta.getFieldIndex("resource"));
        String resStr = workCenterId + "@" + resourceId;
        if (this.existRes.contains(resStr)) {
            return;
        }
        boolean isExistBill = this.invalidateBill(row, date, userId);
        DynamicObject resource = BusinessDataServiceHelper.newDynamicObject((String)"cad_resourcerate");
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourcerate", (DynamicObject)resource, (String)RequestContext.get().getLoginOrg(), (int)1);
        resource.set("costtype", (Object)this.costType);
        if (batchNumber != null && batchNumber.length > 0) {
            resource.set("billno", (Object)batchNumber[0]);
        } else {
            resource.set("billno", (Object)ID.genStringId());
        }
        Date effectdate = DateUtils.getDayStartTime((Date)date);
        resource.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        resource.set("datasrc", (Object)"rate");
        resource.set("effectdate", (Object)(isExistBill ? effectdate : DateUtils.getDefaultEffectDate()));
        resource.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        resource.set("workcenter", (Object)workCenterId);
        resource.set("resource", (Object)resourceId);
        resource.set("element", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
        resource.set("subelement", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
        resource.set("calcbasis", (Object)"001");
        resource.set("resourceunit", (Object)9L);
        resource.set("qty", (Object)actualRate);
        resource.set("pricerule", (Object)row.getLong(this.rowMeta.getFieldIndex("calcruleid")));
        resource.set("billstatus", (Object)"C");
        resource.set("createtime", (Object)date);
        resource.set("modifytime", (Object)date);
        resource.set("auditdate", (Object)date);
        resource.set("creator", (Object)userId);
        resource.set("creator_id", (Object)userId);
        resource.set("modifier", (Object)userId);
        resource.set("modifier_id", (Object)userId);
        resource.set("auditor", (Object)userId);
        resource.set("auditor_id", (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resource});
        this.existRes.add(resStr);
    }

    private boolean invalidateBill(RowX row, Date date, Long userId) {
        DynamicObject[] load;
        QFilter filter = new QFilter("costtype", "=", (Object)this.costType);
        filter.and("effectdate", "<=", (Object)date);
        filter.and("expdate", ">", (Object)date);
        filter.and("workcenter", "=", (Object)row.getLong(this.rowMeta.getFieldIndex("workcenter")));
        filter.and("pricerule", "=", (Object)row.getLong(this.rowMeta.getFieldIndex("calcruleid")));
        filter.and("resource", "=", (Object)row.getLong(this.rowMeta.getFieldIndex("resource")));
        filter.and("element", "=", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
        filter.and("subelement", "=", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
        Date expdate = DateUtils.getDayStartTime((Date)date);
        for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"modifier,modifytime,expdate", (QFilter[])new QFilter[]{filter})) {
            object.set("modifier", (Object)userId);
            object.set("modifier_id", (Object)userId);
            object.set("modifytime", (Object)date);
            object.set("expdate", (Object)expdate);
            SaveServiceHelper.update((DynamicObject)object);
        }
        return load != null && load.length > 0;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

