/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class ResourceRateImportMfgFunction
extends GroupReduceFunction {
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});
    public RowMeta rowMeta;
    public Long costType;

    public ResourceRateImportMfgFunction(RowMeta rowMeta, Long costType) {
        this.rowMeta = rowMeta;
        this.costType = costType;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashSet<Long> periods = new HashSet<Long>(10);
        RowX rowX = null;
        for (RowX row : rows) {
            if (rowX == null) {
                rowX = row;
            }
            periods.add(row.getLong(this.rowMeta.getFieldIndex("period")));
            totalAmount = totalAmount.add(row.getBigDecimal(this.rowMeta.getFieldIndex("actualrate")));
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        BigDecimal actualRate = totalAmount.divide(new BigDecimal(periods.size()), 10, 4);
        if (rowX != null) {
            this.updateResourceBill(rowX, actualRate, rowX.getLong(this.rowMeta.getFieldIndex("calcruleid")));
        }
    }

    private void updateResourceBill(RowX row, BigDecimal actualRate, long calcRuleId) {
        Long resourceId = row.getLong(this.rowMeta.getFieldIndex("resource"));
        Long workCenterId = row.getLong(this.rowMeta.getFieldIndex("workcenter"));
        QFilter filter = new QFilter("costtype", "=", (Object)this.costType);
        filter.and("resource", "=", (Object)resourceId);
        filter.and("workcenter", "=", (Object)workCenterId);
        filter.and("pricerule", "=", (Object)calcRuleId);
        filter.and("expdate", "=", (Object)DateUtils.getDeFaultExpDate());
        Object[] resRates = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"id,entryentity.attaelement,entryentity.attasubelement,entryentity.attaqty", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((Object[])resRates)) {
            return;
        }
        for (Object resRate : resRates) {
            DynamicObjectCollection entryEntity = resRate.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryEntity.addNew();
            entry.set("attaelement", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
            entry.set("attasubelement", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
            entry.set("attaqty", (Object)actualRate);
        }
        SaveServiceHelper.save((DynamicObject[])resRates);
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }
}

