/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;

public class SaveStdCalcResultFunction
extends GroupReduceFunction {
    private int pricePrecision;
    private RowMeta rowMeta;

    public SaveStdCalcResultFunction(RowMeta rowMeta, int pricePrecision) {
        this.pricePrecision = pricePrecision;
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int idIndex = this.rowMeta.getFieldIndex("id");
        int resourceIndex = this.rowMeta.getFieldIndex("resource1");
        int elementIndex = this.rowMeta.getFieldIndex("element1");
        int subelementIndex = this.rowMeta.getFieldIndex("subelement1");
        int qtyIndex = this.rowMeta.getFieldIndex("qty1");
        int priceIndex = this.rowMeta.getFieldIndex("price1");
        int stdpriceIndex = this.rowMeta.getFieldIndex("stdprice1");
        int submaterialIndex = this.rowMeta.getFieldIndex("submaterial1");
        int submatversIndex = this.rowMeta.getFieldIndex("submatvers1");
        int subauxpropertyIndex = this.rowMeta.getFieldIndex("subauxproperty1");
        int sublotIndex = this.rowMeta.getFieldIndex("sublot1");
        int subconfiguredcodeIndex = this.rowMeta.getFieldIndex("subconfiguredcode1");
        int subtracknumberIndex = this.rowMeta.getFieldIndex("subtracknumber1");
        int subprojectIndex = this.rowMeta.getFieldIndex("subproject1");
        int subkeycolIndex = this.rowMeta.getFieldIndex("subkeycol1");
        int subkeycolidIndex = this.rowMeta.getFieldIndex("subkeycolid1");
        int operationIndex = this.rowMeta.getFieldIndex("operation1");
        int operationdescIndex = this.rowMeta.getFieldIndex("operationdesc1");
        int workcenterIndex = this.rowMeta.getFieldIndex("workcenter1");
        int activityIndex = this.rowMeta.getFieldIndex("activity1");
        int calcbasisIndex = this.rowMeta.getFieldIndex("calcbasis1");
        int resourcetypeIndex = this.rowMeta.getFieldIndex("resourcetype1");
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype1");
        int priceruleIndex = this.rowMeta.getFieldIndex("pricerule1");
        int priceidIndex = this.rowMeta.getFieldIndex("priceid1");
        for (RowX rowX : iter) {
            BigDecimal qty = rowX.getBigDecimal(qtyIndex);
            BigDecimal stdPrice = rowX.getBigDecimal(stdpriceIndex);
            rowX.set(priceIndex, (Object)stdPrice.divide(qty, this.pricePrecision, 4));
            targetRows.add(rowX);
        }
        long[] entryIds = ID.genLongIds((int)targetRows.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(200);
        int count = 0;
        for (RowX targetRow : targetRows) {
            Object[] object = new Object[]{targetRow.getLong(idIndex), entryIds[count], targetRow.getLong(resourceIndex), targetRow.getLong(elementIndex), targetRow.getLong(subelementIndex), targetRow.getBigDecimal(qtyIndex), targetRow.getBigDecimal(priceIndex), targetRow.getBigDecimal(stdpriceIndex), targetRow.getLong(submaterialIndex), targetRow.getLong(submatversIndex), targetRow.getLong(subauxpropertyIndex), targetRow.getString(sublotIndex), targetRow.getLong(subconfiguredcodeIndex), targetRow.getLong(subtracknumberIndex), targetRow.getLong(subprojectIndex), targetRow.getString(subkeycolIndex), targetRow.getLong(subkeycolidIndex), targetRow.getLong(operationIndex), targetRow.getString(operationdescIndex), targetRow.getLong(workcenterIndex), targetRow.getLong(activityIndex), targetRow.getString(calcbasisIndex), targetRow.getString(resourcetypeIndex), targetRow.getString(datatypeIndex), targetRow.getLong(priceruleIndex), targetRow.getLong(priceidIndex)};
            ++count;
            params.add(object);
            this.savePartDatas(params);
        }
        try (TXHandle tx = TX.requiresNew();){
            String sql = "INSERT INTO t_cad_calcsimularsentry (fid, fentryid, fresourceid, felementid, fsubelementid, fqty, fprice, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, foperationid, foperationdesc, fworkcenterid, factivityid, fcalcbasis, fresourcetype, fdatatype, fpriceruleid, fpriceid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void savePartDatas(List<Object[]> params) {
        if (params.size() > 5000) {
            try (TXHandle tx = TX.requiresNew();){
                String sql = "INSERT INTO t_cad_calcsimularsentry (fid, fentryid, fresourceid, felementid, fsubelementid, fqty, fprice, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, foperationid, foperationdesc, fworkcenterid, factivityid, fcalcbasis, fresourcetype, fdatatype, fpriceruleid, fpriceid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, params);
            }
            params.clear();
        }
    }
}

