/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class SaveTrackStdCalcResultFunction
extends GroupReduceFunction {
    private Long costTypeId;
    private Date calcDate;
    private int pricePrecision;
    private RowMeta rowMeta;

    public SaveTrackStdCalcResultFunction(RowMeta rowMeta, Long costTypeId, int pricePrecision, Date calcDate) {
        this.costTypeId = costTypeId;
        this.calcDate = calcDate;
        this.pricePrecision = pricePrecision;
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iter, Collector collector) {
        String sql2;
        Throwable throwable;
        ShardingHintContext ctx;
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int pidIndex = this.rowMeta.getFieldIndex("pid");
        int idIndex = this.rowMeta.getFieldIndex("id");
        int entrymaterialIndex = this.rowMeta.getFieldIndex("entrymaterial1");
        int entrymatversIndex = this.rowMeta.getFieldIndex("entrymatvers1");
        int entryauxpropertyIndex = this.rowMeta.getFieldIndex("entryauxproperty1");
        int entryconfiguredcodeIndex = this.rowMeta.getFieldIndex("entryconfiguredcode1");
        int entrytracknumberIndex = this.rowMeta.getFieldIndex("entrytracknumber1");
        int entryprojectIndex = this.rowMeta.getFieldIndex("entryproject1");
        int entrylotIndex = this.rowMeta.getFieldIndex("entrylot1");
        int entrykeycolIndex = this.rowMeta.getFieldIndex("entrykeycol1");
        int entrykeycolidIndex = this.rowMeta.getFieldIndex("entrykeycolid1");
        int entrybomidIndex = this.rowMeta.getFieldIndex("entrybomid1");
        int entryprocessrouteidIndex = this.rowMeta.getFieldIndex("entryprocessrouteid1");
        int entryrootnodeIndex = this.rowMeta.getFieldIndex("entryrootnode1");
        int entrytreepathIndex = this.rowMeta.getFieldIndex("entrytreepath1");
        int entryisleafIndex = this.rowMeta.getFieldIndex("entryisleaf1");
        int entryismaindataIndex = this.rowMeta.getFieldIndex("entryismaindata1");
        int entryiscalccurlevelIndex = this.rowMeta.getFieldIndex("entryiscalccurlevel1");
        int entrylevelIndex = this.rowMeta.getFieldIndex("entrylevel1");
        int entrymaterialattrIndex = this.rowMeta.getFieldIndex("entrymaterialattr1");
        int entrystdqtyIndex = this.rowMeta.getFieldIndex("entrystdqty1");
        int resourceIndex = this.rowMeta.getFieldIndex("resource1");
        int elementIndex = this.rowMeta.getFieldIndex("element1");
        int subelementIndex = this.rowMeta.getFieldIndex("subelement1");
        int qtyIndex = this.rowMeta.getFieldIndex("qty1");
        int priceIndex = this.rowMeta.getFieldIndex("price1");
        int stdpriceIndex = this.rowMeta.getFieldIndex("stdprice1");
        int submaterialIndex = this.rowMeta.getFieldIndex("submaterial1");
        int submatversIndex = this.rowMeta.getFieldIndex("submatvers1");
        int subauxpropertyIndex = this.rowMeta.getFieldIndex("subauxproperty1");
        int sublotIndex = this.rowMeta.getFieldIndex("sublot1");
        int subconfiguredcodeIndex = this.rowMeta.getFieldIndex("subconfiguredcode1");
        int subtracknumberIndex = this.rowMeta.getFieldIndex("subtracknumber1");
        int subprojectIndex = this.rowMeta.getFieldIndex("subproject1");
        int subkeycolIndex = this.rowMeta.getFieldIndex("subkeycol1");
        int subkeycolidIndex = this.rowMeta.getFieldIndex("subkeycolid1");
        int operationIndex = this.rowMeta.getFieldIndex("operation1");
        int operationdescIndex = this.rowMeta.getFieldIndex("operationdesc1");
        int workcenterIndex = this.rowMeta.getFieldIndex("workcenter1");
        int activityIndex = this.rowMeta.getFieldIndex("activity1");
        int calcbasisIndex = this.rowMeta.getFieldIndex("calcbasis1");
        int resourcetypeIndex = this.rowMeta.getFieldIndex("resourcetype1");
        int datatypeIndex = this.rowMeta.getFieldIndex("datatype1");
        int priceruleIndex = this.rowMeta.getFieldIndex("pricerule1");
        int priceidIndex = this.rowMeta.getFieldIndex("priceid1");
        int processseqIndex = this.rowMeta.getFieldIndex("processseq1");
        int operationnoIndex = this.rowMeta.getFieldIndex("operationno1");
        int notSaveSubLevelResult = CadBgParamUtils.getCadParamForInt((String)"notSaveSubLevelResult", (int)1);
        for (RowX rowX : iter) {
            BigDecimal qty = rowX.getBigDecimal(qtyIndex);
            BigDecimal stdPrice = rowX.getBigDecimal(stdpriceIndex);
            rowX.set(priceIndex, (Object)this.divide(stdPrice, qty, this.pricePrecision));
            targetRows.add(rowX);
        }
        long[] entryIds = ID.genLongIds((int)targetRows.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(200);
        ArrayList<Object[]> subParams = new ArrayList<Object[]>(200);
        int count = 0;
        HashSet existIds = Sets.newHashSetWithExpectedSize((int)16);
        for (RowX targetRow : targetRows) {
            Object[] object = new Object[21];
            Object[] subObject = new Object[28];
            object[0] = targetRow.getLong(pidIndex);
            object[1] = targetRow.getLong(idIndex);
            object[2] = targetRow.getLong(entrymaterialIndex);
            object[3] = targetRow.getLong(entrymatversIndex);
            object[4] = targetRow.getLong(entryauxpropertyIndex);
            object[5] = targetRow.getLong(entryconfiguredcodeIndex);
            object[6] = targetRow.getLong(entrytracknumberIndex);
            object[7] = targetRow.getLong(entryprojectIndex);
            object[8] = targetRow.getString(entrylotIndex);
            object[9] = targetRow.getString(entrykeycolIndex);
            object[10] = targetRow.getLong(entrykeycolidIndex);
            object[11] = targetRow.getLong(entrybomidIndex);
            object[12] = targetRow.getLong(entryprocessrouteidIndex);
            object[13] = targetRow.getString(entryrootnodeIndex);
            object[14] = targetRow.getString(entrytreepathIndex);
            object[15] = targetRow.getString(entryisleafIndex);
            object[16] = targetRow.getLong(entryismaindataIndex);
            object[17] = targetRow.getInteger(entryiscalccurlevelIndex);
            object[18] = targetRow.getInteger(entrylevelIndex);
            object[19] = targetRow.getString(entrymaterialattrIndex);
            object[20] = targetRow.getBigDecimal(entrystdqtyIndex);
            if (notSaveSubLevelResult == 1) {
                if (targetRow.getInteger(entrylevelIndex) != 0) continue;
                if (!(existIds.contains(targetRow.getLong(idIndex)) || !targetRow.getString(entryrootnodeIndex).equals(String.valueOf(targetRow.getLong(entrybomidIndex))) && "D".equals(targetRow.getString(entrymaterialattrIndex)))) {
                    params.add(object);
                    existIds.add(targetRow.getLong(idIndex));
                }
            } else if (!existIds.contains(targetRow.getLong(idIndex))) {
                params.add(object);
                existIds.add(targetRow.getLong(idIndex));
            }
            subObject[0] = targetRow.getLong(idIndex);
            subObject[1] = entryIds[count];
            subObject[2] = targetRow.getLong(resourceIndex);
            subObject[3] = targetRow.getLong(elementIndex);
            subObject[4] = targetRow.getLong(subelementIndex);
            subObject[5] = targetRow.getBigDecimal(qtyIndex);
            subObject[6] = targetRow.getBigDecimal(priceIndex);
            subObject[7] = targetRow.getBigDecimal(stdpriceIndex);
            subObject[8] = targetRow.getLong(submaterialIndex);
            subObject[9] = targetRow.getLong(submatversIndex);
            subObject[10] = targetRow.getLong(subauxpropertyIndex);
            subObject[11] = targetRow.getString(sublotIndex);
            subObject[12] = targetRow.getLong(subconfiguredcodeIndex);
            subObject[13] = targetRow.getLong(subtracknumberIndex);
            subObject[14] = targetRow.getLong(subprojectIndex);
            subObject[15] = targetRow.getString(subkeycolIndex);
            subObject[16] = targetRow.getLong(subkeycolidIndex);
            subObject[17] = targetRow.getLong(operationIndex);
            subObject[18] = targetRow.getString(operationdescIndex);
            subObject[19] = targetRow.getLong(workcenterIndex);
            subObject[20] = targetRow.getLong(activityIndex);
            subObject[21] = targetRow.getString(calcbasisIndex);
            subObject[22] = targetRow.getString(resourcetypeIndex);
            subObject[23] = targetRow.getString(datatypeIndex);
            subObject[24] = targetRow.getLong(priceruleIndex);
            subObject[25] = targetRow.getLong(priceidIndex);
            subObject[26] = targetRow.getString(processseqIndex);
            subObject[27] = targetRow.getString(operationnoIndex);
            ++count;
            subParams.add(subObject);
            this.savePartDatas(params, subParams);
        }
        if (!params.isEmpty()) {
            ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)this.costTypeId), new HintCondition("fcalcdate", "=", (Object)this.calcDate)});
            throwable = null;
            try {
                sql2 = "INSERT INTO t_cad_trackcalcentry (fid, fentryid, fentrymaterialid, fentrymatvers, fentryauxproperty, fentryconfiguredcodeid, fentrytracknumberid, fentryprojectid, fentrylot, fentrykeycol, fentrykeycolid, fentrybomid, fentryprocessrouteid, fentryrootnode, fentrytreepath, fentryisleaf, fentryismaindata, fentryiscalccurlevel, fentrylevel, fentrymaterialattr, fentrystdqty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql2, params);
            }
            catch (Throwable sql2) {
                throwable = sql2;
                throw sql2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql2) {
                            throwable.addSuppressed(sql2);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        if (!subParams.isEmpty()) {
            ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)this.costTypeId), new HintCondition("fcalcdate", "=", (Object)this.calcDate)});
            throwable = null;
            try {
                sql2 = "INSERT INTO t_cad_trackcalcsubentry (fentryid, fdetailid, fresourceid, felementid, fsubelementid, fqty, fprice, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, foperationid, foperationdesc, fworkcenterid, factivityid, fcalcbasis, fresourcetype, fdatatype, fpriceruleid, fpriceid, fprocessseq, foperationno) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql2, subParams);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
    }

    private BigDecimal divide(BigDecimal value1, BigDecimal value2, int precision) {
        if (value1 == null) {
            value1 = BigDecimal.ZERO;
        }
        if (value2 == null) {
            value2 = BigDecimal.ZERO;
        }
        if (value2.compareTo(BigDecimal.ZERO) == 0) {
            return value2;
        }
        return value1.divide(value2, precision, 4);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void savePartDatas(List<Object[]> params, List<Object[]> subParams) {
        String sql2;
        Throwable throwable;
        ShardingHintContext ctx;
        if (params.size() > 5000) {
            ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)this.costTypeId), new HintCondition("fcalcdate", "=", (Object)this.calcDate)});
            throwable = null;
            try {
                sql2 = "INSERT INTO t_cad_trackcalcentry (fid, fentryid, fentrymaterialid, fentrymatvers, fentryauxproperty, fentryconfiguredcodeid, fentrytracknumberid, fentryprojectid, fentrylot, fentrykeycol, fentrykeycolid, fentrybomid, fentryprocessrouteid, fentryrootnode, fentrytreepath, fentryisleaf, fentryismaindata, fentryiscalccurlevel, fentrylevel, fentrymaterialattr, fentrystdqty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql2, params);
                params.clear();
            }
            catch (Throwable sql2) {
                throwable = sql2;
                throw sql2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql2) {
                            throwable.addSuppressed(sql2);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        if (subParams.size() > 5000) {
            ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)this.costTypeId), new HintCondition("fcalcdate", "=", (Object)this.calcDate)});
            throwable = null;
            try {
                sql2 = "INSERT INTO t_cad_trackcalcsubentry (fentryid, fdetailid, fresourceid, felementid, fsubelementid, fqty, fprice, fstdprice, fsubmaterialid, fsubmatvers, fsubauxproperty, fsublot, fsubconfiguredcodeid, fsubtracknumberid, fsubprojectid, fsubkeycol, fsubkeycolid, foperationid, foperationdesc, fworkcenterid, factivityid, fcalcbasis, fresourcetype, fdatatype, fpriceruleid, fpriceid, fprocessseq, foperationno) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql2, subParams);
                subParams.clear();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
    }
}

