/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.algox.Data.CalculationNode;
import kd.macc.cad.algox.Data.CalculationNodeSubElement;
import kd.macc.cad.algox.Data.CalculationTree;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.calc.helper.CalcPriceHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.function.NumberUtils;
import kd.macc.cad.algox.function.ProcessRouteCost;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class StandCostCalculate {
    private static final Log logger = LogFactory.getLog(StandCostCalculate.class);
    private static final BigDecimal THOUSAND = new BigDecimal(100);
    public static final int CALC_SCALE = 10;
    private CalcStandCostCalcParam standCostCalcParam = null;
    private CalculationTree tree = null;
    private ProcessRouteCost processRouteCost = null;
    private Map<String, List<DynamicObject>> matKeycolOutPriceMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<DynamicObject>> matKeycolPurPriceMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<String, List<CalculationNodeSubElement>> byMatKeycolByProdPriceObjMap = new HashMap<String, List<CalculationNodeSubElement>>(16);
    private Map<String, List<CalculationNodeSubElement>> mainMatKeycolByProdPurPriceObjMap = new HashMap<String, List<CalculationNodeSubElement>>(16);
    private Map<String, BigDecimal> mainMaterilAndQty = new HashMap<String, BigDecimal>(16);
    private Map<Long, String> subElementTypeMap = new HashMap<Long, String>(16);
    private Map<Long, DynamicObject> itemMap = null;
    private Map<Long, Long[]> materialSubElementMap = null;
    private long commonElement = 0L;
    private long commonSubElement = 0L;
    private Map<Long, Long> subElement2ElementMap = null;
    private Boolean consiPrepareProcessSatge = Boolean.FALSE;

    public ProcessRouteCost getProcessRouteCost() {
        return this.processRouteCost;
    }

    public void setProcessRouteCost(ProcessRouteCost processRouteCost) {
        this.processRouteCost = processRouteCost;
    }

    public CalcStandCostCalcParam getStandCostCalcParam() {
        return this.standCostCalcParam;
    }

    public void setStandCostCalcParam(CalcStandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public void setTree(CalculationTree tree) {
        this.tree = tree;
        if (this.getStandCostCalcParam().isDebug()) {
            logger.info("\u8ba1\u7b97BOM\u6811=======");
            tree.toLog();
        }
    }

    public CalculationTree getTree() {
        return this.tree;
    }

    public void calculate() {
        this.getSubItemList();
        this.getItemList();
        this.calcUnitQty();
        Long startTime = TimeServiceHelper.now().getTime();
        this.sumCalculate();
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            this.write2LogNew(ResManager.loadKDString((String)"\u5355\u4e2aBOM\u6811\u5377\u7b97", (String)"StandCostCalculate_25", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
    }

    private void sumCalculate() {
        Map<String, String> actualKeycolMap;
        Long startTime = TimeServiceHelper.now().getTime();
        this.byMatKeycolByProdPriceObjMap = this.getByMatKeycolByProdPriceObjMap();
        this.mainMatKeycolByProdPurPriceObjMap = this.getMatKeycolAndByProdPurPriceObjMap();
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            this.write2LogNew(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u827a\u8def\u7ebf\u6210\u672c", (String)"StandCostCalculate_26", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
        CalculationNode root = this.tree.getRoot();
        ArrayList<String> purMaterialKeyCols = new ArrayList<String>(10);
        ArrayList<String> selfMaterialKeyCols = new ArrayList<String>(10);
        HashSet<Long> materialIds = new HashSet<Long>(10);
        this.getPurMaterialKeyCols(root, purMaterialKeyCols, selfMaterialKeyCols, materialIds);
        this.prepareProcessRouterCost(selfMaterialKeyCols);
        this.materialSubElementMap = this.getSubItemList(materialIds, this.standCostCalcParam.getCostTypeId());
        startTime = TimeServiceHelper.now().getTime();
        purMaterialKeyCols.removeAll(this.standCostCalcParam.getCustomSuppliedMaterials());
        if ("sca".equals(this.standCostCalcParam.getAppNum())) {
            actualKeycolMap = CalcPriceHelper.getActualKeycolMap(this.standCostCalcParam.getCostTypeId(), purMaterialKeyCols);
            this.matKeycolPurPriceMap = this.getMatKeycolPurPriceMapForDimension(purMaterialKeyCols, actualKeycolMap);
            purMaterialKeyCols.removeAll(this.matKeycolPurPriceMap.keySet());
            this.matKeycolPurPriceMap.putAll(this.getMatKeycolPurMatCostInfoForDimension(purMaterialKeyCols, this.standCostCalcParam.getPurMatCostInfoMap(), actualKeycolMap));
        } else {
            this.matKeycolPurPriceMap = this.getMatKeycolPurPriceMap(purMaterialKeyCols);
            purMaterialKeyCols.removeAll(this.matKeycolPurPriceMap.keySet());
            this.matKeycolPurPriceMap.putAll(this.getMatKeycolPurPriceMapByMatCostInfo(purMaterialKeyCols, this.standCostCalcParam.getPurMatCostInfoMap()));
        }
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            this.write2LogNew(ResManager.loadKDString((String)"\u83b7\u53d6\u5916\u8d2d\u4ef7", (String)"StandCostCalculate_27", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
        startTime = TimeServiceHelper.now().getTime();
        selfMaterialKeyCols.removeAll(this.standCostCalcParam.getCustomSuppliedMaterials());
        selfMaterialKeyCols.removeAll(this.standCostCalcParam.getVirtualMaterials());
        if ("sca".equals(this.standCostCalcParam.getAppNum())) {
            actualKeycolMap = CalcPriceHelper.getActualKeycolMap(this.standCostCalcParam.getCostTypeId(), selfMaterialKeyCols);
            this.matKeycolOutPriceMap = this.getMatKeycolOutPriceMapForDimension(selfMaterialKeyCols, actualKeycolMap);
        } else {
            this.matKeycolOutPriceMap = this.getMatKeycolOutPriceMap(selfMaterialKeyCols);
        }
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            this.write2LogNew(ResManager.loadKDString((String)"\u83b7\u53d6\u59d4\u5916\u4ef7", (String)"StandCostCalculate_28", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
        this.consiPrepareProcessSatge = CadBgParamUtils.getCadBgParamForString((String)"consiPrepareProcessSatge", (String)"0").equals("1") ? Boolean.TRUE : Boolean.FALSE;
        startTime = TimeServiceHelper.now().getTime();
        this.sumOneNode(root);
        if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
            this.write2LogNew(ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"StandCostCalculate_29", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97BOM\u6811%s", (String)"StandCostCalculate_0", (String)"macc-cad-algox", (Object[])new Object[0]), this.tree.getRoot().getBomTreeRootId()), new Boolean[0]);
    }

    private void getPurMaterialKeyCols(CalculationNode node, List<String> purMaterials, List<String> selfMaterialKeyCols, Set<Long> materialIds) {
        if (node.isLeaf()) {
            purMaterials.add(node.getMaterial().getKeycol());
        } else {
            selfMaterialKeyCols.add(node.getMaterial().getKeycol());
        }
        materialIds.add(node.getMaterial().getMaterialId());
        if (!node.getSubNodes().isEmpty()) {
            for (CalculationNode subNode : node.getSubNodes()) {
                this.getPurMaterialKeyCols(subNode, purMaterials, selfMaterialKeyCols, materialIds);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sumOneNode(CalculationNode node) {
        if (node.isCalculated()) {
            return;
        }
        node.getSubElementList().clear();
        this.calcMaterialCost(node);
        if (!node.getSubNodes().isEmpty()) {
            for (CalculationNode calculationNode : node.getSubNodes()) {
                this.sumOneNode(calculationNode);
            }
            HashMap<String, CalculationNodeSubElement> mergeMap = new HashMap<String, CalculationNodeSubElement>();
            for (CalculationNode calculationNode : node.getSubNodes()) {
                this.mergeSubItems(mergeMap, calculationNode, calculationNode.getUnitQty());
                HashMap<String, Map> directLevelMap = new HashMap<String, Map>(16);
                CalculationNode calculationNode2 = this.reCalcCost(calculationNode);
                for (CalculationNodeSubElement calculationNodeSubElement : calculationNode2.getSubElementList()) {
                    if ((calculationNodeSubElement.getType() != 1 || calculationNode.getSubNodes().isEmpty()) && (calculationNodeSubElement.getType() != 2 || !calculationNode.getSubNodes().isEmpty())) continue;
                    CalculationNodeSubElement subElement1 = calculationNodeSubElement.copy();
                    subElement1.setMaterial(calculationNode.getMaterial());
                    subElement1.setType(4);
                    subElement1.setQty(this.calcQty(calculationNodeSubElement.getProcessStage(), calculationNode.getUnitQty()));
                    if (this.mainMaterilAndQty.containsKey(calculationNode.getMaterial().getKeycol())) {
                        subElement1.setPrice(calculationNodeSubElement.getPrice().multiply(this.mainMaterilAndQty.get(calculationNode.getMaterial().getKeycol())).setScale(this.standCostCalcParam.getPriceprecision(), 4));
                    } else {
                        subElement1.setPrice(calculationNodeSubElement.getPrice().setScale(this.standCostCalcParam.getPriceprecision(), 4));
                    }
                    subElement1.setCost(subElement1.getPrice().multiply(subElement1.getQty()).setScale(this.standCostCalcParam.getPriceprecision(), 4));
                    if (this.subElementTypeMap.get(subElement1.getSubElement()) == null) continue;
                    directLevelMap.computeIfAbsent(this.subElementTypeMap.get(subElement1.getSubElement()), p -> new HashMap()).computeIfAbsent(subElement1.getMaterial(), p -> new ArrayList()).add(subElement1);
                }
                if (directLevelMap.get("002") == null) {
                    for (Map.Entry entry : directLevelMap.entrySet()) {
                        Map value = (Map)entry.getValue();
                        Collection values = value.values();
                        values.forEach(p -> node.getSubElementList().addAll((Collection<CalculationNodeSubElement>)p));
                    }
                    continue;
                }
                for (Map.Entry entry : directLevelMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map subElementValues = (Map)entry.getValue();
                    if ("002".equals(key) && directLevelMap.containsKey("001")) {
                        Map subElementForMatMap = (Map)directLevelMap.get("001");
                        Map subElementForMatFeeMap = (Map)directLevelMap.get("002");
                        for (Map.Entry subElementForMat : subElementForMatMap.entrySet()) {
                            Material matKey = (Material)subElementForMat.getKey();
                            List subElementForFeeList = (List)subElementForMatFeeMap.get(matKey);
                            if (subElementForFeeList == null) continue;
                            CalculationNodeSubElement value = (CalculationNodeSubElement)((List)subElementForMat.getValue()).get(0);
                            for (CalculationNodeSubElement subElementForFee : subElementForFeeList) {
                                value.setCost(value.getCost().add(subElementForFee.getCost()));
                            }
                            BigDecimal qty = value.getQty();
                            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                                value.setPrice(value.getCost().divide(qty, this.standCostCalcParam.getPriceprecision(), 4));
                            }
                            subElementForMatMap.put(matKey, Collections.singletonList(value));
                        }
                        continue;
                    }
                    Collection values = subElementValues.values();
                    values.forEach(subElement -> node.getSubElementList().addAll((Collection<CalculationNodeSubElement>)subElement));
                }
            }
            node.getSubElementList().addAll(mergeMap.values());
        }
        BigDecimal cost = BigDecimal.ZERO;
        if (!node.isLeaf()) {
            for (CalculationNodeSubElement subElement3 : node.getSubElementList()) {
                if (subElement3.getType() != 2 && subElement3.getType() != 4) continue;
                cost = cost.add(subElement3.getCost());
            }
        } else if (node.getSubElementList() != null && node.getSubElementList().size() > 0) {
            void var4_8;
            boolean bl = false;
            while (var4_8 < node.getSubElementList().size()) {
                cost = cost.add(node.getSubElementList().get((int)var4_8).getPrice());
                ++var4_8;
            }
        } else {
            cost = BigDecimal.ZERO;
        }
        CalculationNodeSubElement calculationNodeSubElement = new CalculationNodeSubElement();
        calculationNodeSubElement.setType(1);
        calculationNodeSubElement.setQty(BigDecimal.ONE);
        calculationNodeSubElement.setPrice(cost);
        calculationNodeSubElement.setCost(cost);
        this.setSubElement(calculationNodeSubElement, node.getMaterial());
        node.getSubElementList().add(calculationNodeSubElement);
        node.setCalculated(true);
        this.deductCost(node.getMaterial().getKeycol(), node.getSubElementList(), this.standCostCalcParam.getMainAndCoByProductWithOutBomMap());
        this.write2Log(String.format(ResManager.loadKDString((String)"\u5377\u7b97BOM\u8282\u70b9%s", (String)"StandCostCalculate_1", (String)"macc-cad-algox", (Object[])new Object[0]), node.getBomTreePath()), new Boolean[0]);
    }

    private BigDecimal calcQty(String processStage, BigDecimal qty) {
        if (this.consiPrepareProcessSatge.booleanValue() && "B".equals(processStage)) {
            return BigDecimal.ONE;
        }
        return qty;
    }

    private CalculationNode reCalcCost(CalculationNode subNode) {
        BigDecimal unitQty = subNode.getUnitQty();
        BigDecimal cost = BigDecimal.ZERO;
        if (!this.consiPrepareProcessSatge.booleanValue()) {
            return subNode;
        }
        if (!this.isExistPrepareStage(subNode).booleanValue()) {
            return subNode;
        }
        CalculationNode copyNode = subNode.copy();
        for (CalculationNodeSubElement subElement : copyNode.getSubElementList()) {
            if (subElement.getType() != 2 && subElement.getType() != 3) continue;
            if ("B".equals(subElement.getProcessStage())) {
                cost = cost.add(subElement.getCost());
                continue;
            }
            cost = cost.add(subElement.getCost().multiply(unitQty));
        }
        for (CalculationNodeSubElement subElement : copyNode.getSubElementList()) {
            if (subElement.getType() != 1) continue;
            cost = cost.divide(unitQty, this.standCostCalcParam.getPriceprecision(), 4);
            subElement.setPrice(cost);
            subElement.setCost(cost);
        }
        return copyNode;
    }

    private Boolean isExistPrepareStage(CalculationNode subNode) {
        if (subNode == null) {
            return Boolean.FALSE;
        }
        for (CalculationNodeSubElement subElement : subNode.getSubElementList()) {
            if (subElement.getType() != 2 || !"B".equals(subElement.getProcessStage())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void deductCost(String materialKeycol, List<CalculationNodeSubElement> curCalculationNodeSubElement, Map<String, Map<String, BigDecimal>> mainAndCoByProductMap) {
        if (CadEmptyUtils.isEmpty(materialKeycol)) {
            return;
        }
        Map<String, List<String>> coByProductWithBomCost = this.standCostCalcParam.getMainAndCoByProductWithBomMap();
        if (!CadEmptyUtils.isEmpty(coByProductWithBomCost) && coByProductWithBomCost.containsKey(materialKeycol)) {
            List<String> byProductKcs = coByProductWithBomCost.get(materialKeycol);
            for (String byProductKc : byProductKcs) {
                List<CalculationNodeSubElement> calculationNodeSubElementsForByCoProduct = this.byMatKeycolByProdPriceObjMap.get(byProductKc);
                if (CadEmptyUtils.isEmpty(calculationNodeSubElementsForByCoProduct)) continue;
                for (CalculationNodeSubElement nodeSubElement : calculationNodeSubElementsForByCoProduct) {
                    CalculationNodeSubElement tmp = nodeSubElement.copy();
                    tmp.setQty(BigDecimal.ZERO.subtract(tmp.getQty()));
                    tmp.setCost(BigDecimal.ZERO.subtract(tmp.getCost()));
                    curCalculationNodeSubElement.add(tmp);
                }
            }
        }
        if (this.mainMatKeycolByProdPurPriceObjMap.containsKey(materialKeycol)) {
            List<CalculationNodeSubElement> calculationNodeSubElements = this.mainMatKeycolByProdPurPriceObjMap.get(materialKeycol);
            Map<String, Map<String, BigDecimal>> byProductsMainMatMap = this.standCostCalcParam.getMainAndCoByProductWithPurPriceMap();
            Map<String, BigDecimal> byProductInfo = byProductsMainMatMap.get(materialKeycol);
            for (CalculationNodeSubElement nodeSubElement : calculationNodeSubElements) {
                String keycol = nodeSubElement.getMaterial().getKeycol();
                BigDecimal qty = byProductInfo.get(keycol);
                BigDecimal price = nodeSubElement.getCost();
                BigDecimal cost = price.multiply(qty).setScale(this.standCostCalcParam.getPriceprecision(), 4);
                CalculationNodeSubElement tmp = nodeSubElement.copy();
                tmp.setQty(BigDecimal.ZERO.subtract(qty));
                tmp.setPrice(price);
                tmp.setCost(BigDecimal.ZERO.subtract(cost));
                curCalculationNodeSubElement.add(tmp);
            }
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (CalculationNodeSubElement calculationNodeSubElement : curCalculationNodeSubElement) {
            if (calculationNodeSubElement.getType() != 2 && calculationNodeSubElement.getType() != 4) continue;
            sum = sum.add(calculationNodeSubElement.getCost());
        }
        for (CalculationNodeSubElement calculationNodeSubElement : curCalculationNodeSubElement) {
            if (calculationNodeSubElement.getType() != 1) continue;
            calculationNodeSubElement.setPrice(sum);
            calculationNodeSubElement.setCost(sum);
            break;
        }
        if (!CadEmptyUtils.isEmpty(mainAndCoByProductMap) && mainAndCoByProductMap.containsKey(materialKeycol)) {
            for (CalculationNodeSubElement calculationNodeSubElement : curCalculationNodeSubElement) {
                BigDecimal qtyRate = this.getQtyRate(materialKeycol, mainAndCoByProductMap);
                calculationNodeSubElement.setQty(calculationNodeSubElement.getQty().multiply(qtyRate).setScale(this.standCostCalcParam.getPriceprecision(), 4));
                calculationNodeSubElement.setCost(calculationNodeSubElement.getQty().multiply(calculationNodeSubElement.getPrice()).setScale(this.standCostCalcParam.getPriceprecision(), 4));
                if (calculationNodeSubElement.getType() != 1) continue;
                this.mainMaterilAndQty.put(materialKeycol, calculationNodeSubElement.getQty());
            }
        }
    }

    private BigDecimal getQtyRate(String materialKeycol, Map<String, Map<String, BigDecimal>> mainAndCoByProductMap) {
        if (CadEmptyUtils.isEmpty(materialKeycol) || CadEmptyUtils.isEmpty(mainAndCoByProductMap)) {
            return BigDecimal.ONE;
        }
        Map<String, BigDecimal> coByProductMap = mainAndCoByProductMap.get(materialKeycol);
        if (CadEmptyUtils.isEmpty(coByProductMap)) {
            return BigDecimal.ONE;
        }
        BigDecimal mutipleQty = BigDecimal.ONE;
        for (Map.Entry<String, BigDecimal> coByProduct : coByProductMap.entrySet()) {
            BigDecimal cqty = coByProduct.getValue();
            mutipleQty = mutipleQty.multiply(cqty);
        }
        BigDecimal totalCount = mutipleQty;
        for (Map.Entry<String, BigDecimal> coByProduct : coByProductMap.entrySet()) {
            BigDecimal byProductQty = coByProduct.getValue();
            BigDecimal cqty = BigDecimal.ONE.divide(byProductQty, 10, 4);
            totalCount = totalCount.add(mutipleQty.multiply(cqty));
        }
        return mutipleQty.divide(totalCount, 10, 4);
    }

    private void setSubElement(CalculationNodeSubElement subElement, Material material) {
        Long[] data = this.materialSubElementMap.get(material.getMaterialId());
        if (data == null) {
            subElement.setElement(this.commonElement);
            subElement.setSubElement(this.commonSubElement);
        } else {
            if (data[0] != null) {
                subElement.setElement(data[0]);
            }
            if (data[1] != null) {
                subElement.setSubElement(data[1]);
            }
        }
    }

    private void mergeSubItems(Map<String, CalculationNodeSubElement> mergeMap, CalculationNode subNode, BigDecimal unitQty) {
        List<CalculationNodeSubElement> subElementList = subNode.getSubElementList();
        for (CalculationNodeSubElement subElement : subElementList) {
            if (subElement.getType() != 3 && subElement.getType() != 2) continue;
            CalculationNodeSubElement subElement1 = subElement.copy();
            subElement1.setType(3);
            subElement1.setQty(subElement1.getQty().multiply(this.calcQty(subElement.getProcessStage(), unitQty)));
            subElement1.setCost(subElement1.getCost().multiply(this.calcQty(subElement.getProcessStage(), unitQty)).setScale(this.standCostCalcParam.getPriceprecision(), 4));
            String key = String.valueOf(subElement1.getSubElement());
            if (subElement1.getMaterial() != null) {
                key = key + "@" + subElement1.getMaterial().toString();
            }
            if (subElement1.getResourceId() != 0L) {
                key = this.consiPrepareProcessSatge == false ? key + "@" + subElement1.getResourceId() + "@" + subElement1.getCalcbasis() : key + "@" + subElement1.getResourceId() + "@" + subElement1.getCalcbasis() + "@" + subElement1.getProcessStage();
            }
            if (mergeMap.containsKey(key)) {
                CalculationNodeSubElement subElement2 = mergeMap.get(key);
                subElement2.setQty(subElement1.getQty().add(subElement2.getQty()));
                subElement2.setCost(subElement1.getCost().add(subElement2.getCost()));
                continue;
            }
            if (!this.consiPrepareProcessSatge.booleanValue()) {
                subElement1.setActivityId(0L);
                subElement1.setProcessSeq("");
                subElement1.setOperationNo("");
                subElement1.setOperationId(0L);
                subElement1.setOperationDesc("");
                subElement1.setOperationDesc("");
                subElement1.setResWorkCenterId(0L);
            } else if (!"B".equals(subElement1.getProcessStage())) {
                subElement1.setActivityId(0L);
                subElement1.setProcessSeq("");
                subElement1.setOperationNo("");
                subElement1.setOperationId(0L);
                subElement1.setOperationDesc("");
                subElement1.setOperationDesc("");
                subElement1.setResWorkCenterId(0L);
            }
            mergeMap.put(key, subElement1);
        }
    }

    private void calcMaterialCost(CalculationNode node) {
        block7: {
            block5: {
                block6: {
                    if (node.getBomId() == 0L && node.getExpandBomId() == 0L && !this.standCostCalcParam.isTrackCalc().booleanValue() || node.getMaterial().isPurPrice()) break block5;
                    logger.info("\u5de5\u827a\u8def\u7ebf\u8ba1\u7b97\uff0c\u5f53\u524d\u8282\u70b9keycol\uff1a{}\uff0c\u7236\u8282\u70b9bomid\uff1a{}\uff0c\u865a\u62df\u4ef6\uff1a{}\u3002", new Object[]{node.getMaterial().getKeycol(), node.getParentBomId(), this.standCostCalcParam.getVirtualMaterials()});
                    if (node.getParentBomId() != 0L && this.standCostCalcParam.getVirtualMaterials().contains(node.getMaterial().getKeycol())) {
                        logger.info("\u865a\u62df\u4ef6\uff1a{}\uff0c\u4e0d\u8ba1\u7b97\u5de5\u827a\u8def\u7ebf\u3002", (Object)node.getMaterial().getKeycol());
                        return;
                    }
                    String routeKey = this.processRouteCost.findProcessRoute(node.getMaterial().getKeycol());
                    List<CalculationNodeSubElement> routeCostList = this.processRouteCost.findProcessRouteCostNew(routeKey);
                    if (routeCostList != null) {
                        for (CalculationNodeSubElement subElement : routeCostList) {
                            CalculationNodeSubElement subElement1 = subElement.copy();
                            subElement1.setType(2);
                            node.getSubElementList().add(subElement1);
                        }
                    }
                    if (node.getMaterial().isEnableoutsource()) break block6;
                    this.partMaterialCost(node);
                    break block7;
                }
                this.partMaterialCost(node);
                List<DynamicObject> priceObjs = this.findProdPriceByMaterial(node.getMaterial());
                if (priceObjs == null || CadEmptyUtils.isEmpty(priceObjs)) break block7;
                this.calcOneSubItemPrice(priceObjs.get(0), node, BigDecimal.ONE, priceObjs.get(0).getBigDecimal("bat"), Boolean.TRUE, Boolean.FALSE);
                for (DynamicObject priceObj : priceObjs) {
                    this.calcOneSubItemPrice(priceObj, node, BigDecimal.ONE, priceObj.getBigDecimal("bat"), Boolean.TRUE, Boolean.TRUE);
                }
                break block7;
            }
            List<DynamicObject> priceObjs = this.findPurPriceByMaterial(node.getMaterial());
            for (DynamicObject entryObj : priceObjs) {
                this.calcOneSubItemPrice(entryObj, node, BigDecimal.ONE, BigDecimal.ONE, Boolean.FALSE, Boolean.FALSE);
            }
        }
    }

    private void partMaterialCost(CalculationNode node) {
        long bomId = node.getBomId() != 0L ? node.getBomId() : node.getExpandBomId();
        DynamicObject objSetting = this.tree.getBomSetting(bomId);
        if (objSetting == null) {
            this.write2Log(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230BOM\u201c%s\u201d\u7684\u6210\u672cBOM\u8bbe\u7f6e\u4fe1\u606f\u3002", (String)"StandCostCalculate_2", (String)"macc-cad-algox", (Object[])new Object[0]), bomId), new Boolean[0]);
            return;
        }
        if (objSetting.getLong("chargedefsubelement.id") == 0L) {
            this.write2Log(String.format(ResManager.loadKDString((String)"BOM\u201c%s\u201d\u7684\u6210\u672cBOM\u8bbe\u7f6e\u4fe1\u606f\u6ca1\u6709\u8bbe\u7f6e\u201c\u7269\u6599\u8d39\u7528\u9ed8\u8ba4\u5b50\u8981\u7d20\u201d\u4fe1\u606f\u3002", (String)"StandCostCalculate_3", (String)"macc-cad-algox", (Object[])new Object[0]), bomId), new Boolean[0]);
            return;
        }
        if (objSetting.getBigDecimal("chargestdrate") == null) {
            this.write2Log(String.format(ResManager.loadKDString((String)"BOM\u201c%s\u201d\u7684\u6210\u672cBOM\u8bbe\u7f6e\u4fe1\u606f\u6ca1\u6709\u8bbe\u7f6e\u201c\u7269\u6599\u8d39\u7528\u6807\u51c6\u8d39\u7387\u201d\u4fe1\u606f\u3002", (String)"StandCostCalculate_4", (String)"macc-cad-algox", (Object[])new Object[0]), bomId), new Boolean[0]);
            return;
        }
        long subElementId = objSetting.getLong("chargedefsubelement.id");
        if (!this.subElement2ElementMap.containsKey(subElementId)) {
            this.write2Log(String.format(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u6ca1\u6709\u627e\u5230\u5b50\u8981\u7d20\u201c%s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u8981\u7d20\u3002", (String)"StandCostCalculate_5", (String)"macc-cad-algox", (Object[])new Object[0]), subElementId), new Boolean[0]);
            return;
        }
        long elmentId = this.subElement2ElementMap.get(subElementId);
        BigDecimal defRate = objSetting.getBigDecimal("chargestdrate");
        BigDecimal cost = BigDecimal.ZERO;
        for (CalculationNode subNode : node.getSubNodes()) {
            if (!subNode.isLeaf()) continue;
            List<DynamicObject> priceObjs = this.findPurPriceByMaterial(subNode.getMaterial());
            for (DynamicObject entryObj : priceObjs) {
                if (entryObj == null) continue;
                cost = cost.add(entryObj.getBigDecimal("price").multiply(subNode.getUnitQty()).setScale(this.standCostCalcParam.getPriceprecision(), 4));
            }
        }
        cost = cost.multiply(defRate).divide(THOUSAND, this.standCostCalcParam.getPriceprecision(), 4);
        CalculationNodeSubElement subElement = new CalculationNodeSubElement();
        subElement.setElement(elmentId);
        subElement.setSubElement(subElementId);
        if (subElementId == objSetting.getLong("chargedefsubelement.id")) {
            subElement.setMaterial(node.getMaterial());
        }
        subElement.setQty(BigDecimal.ONE);
        subElement.setPrice(cost);
        subElement.setCost(cost);
        subElement.setType(2);
        node.getSubElementList().add(subElement);
    }

    private void calcOneSubItemPrice(DynamicObject entryObj, CalculationNode node, BigDecimal unitQty, BigDecimal batch, Boolean isOutSource, Boolean isAdditional) {
        DynamicObject elementObj;
        BigDecimal price = BigDecimal.ZERO;
        CalculationNodeSubElement subElement = new CalculationNodeSubElement();
        if (isAdditional.booleanValue()) {
            long extSubElementId = entryObj.getLong("extsubelementId");
            if (CadEmptyUtils.isEmpty(extSubElementId)) {
                return;
            }
            long extElementId = entryObj.getLong("extelementId");
            price = entryObj.getBigDecimal("amount");
            subElement.setElement(extElementId);
            subElement.setSubElement(extSubElementId);
        } else if (entryObj != null) {
            price = NumberUtils.divide(entryObj.getBigDecimal("price"), batch.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : batch, this.standCostCalcParam.getBizLogger(), ResManager.loadKDString((String)"\u4ef7\u683c\u6279\u91cf\u4e3a0", (String)"StandCostCalculate_6", (String)"macc-cad-algox", (Object[])new Object[0]), 10);
            subElement.setElement(entryObj.getLong("elementId"));
            subElement.setSubElement(entryObj.getLong("subelementId"));
        } else {
            this.setSubElement(subElement, node.getMaterial());
        }
        BigDecimal cost = unitQty.multiply(price).setScale(this.standCostCalcParam.getPriceprecision(), 4);
        subElement.setQty(unitQty);
        subElement.setPrice(price);
        subElement.setCost(cost);
        subElement.setType(2);
        if (isOutSource.booleanValue()) {
            subElement.setMaterial(node.getMaterial());
        }
        if ((elementObj = this.itemMap.get(subElement.getElement())) != null && node.isLeaf()) {
            subElement.setMaterial(node.getMaterial());
        }
        node.getSubElementList().add(subElement);
    }

    private void calcUnitQty() {
        DynamicObject bomRuleSettingObj = StdCalculateHelper.getBomRuleSettingObj(this.standCostCalcParam.getBomRuleSetting());
        for (CalculationNode node : this.tree.getNodeList()) {
            if (node.getParentBomId() == 0L) continue;
            DynamicObject objSetting = this.tree.getBomSetting(node.getParentBomId());
            boolean isLossRate = false;
            String lossRateFormula = "1";
            boolean isYield = false;
            if (objSetting != null) {
                isLossRate = objSetting.getBoolean("considersubmaterialloss");
                lossRateFormula = objSetting.getString("lossrateformula");
                isYield = objSetting.getBoolean("consideryieldrate");
            }
            if (this.standCostCalcParam.isStartBomRuleCalc().booleanValue() && bomRuleSettingObj != null) {
                isLossRate = bomRuleSettingObj.getBoolean("considersubmaterialloss");
                lossRateFormula = bomRuleSettingObj.getString("lossrateformula");
                isYield = bomRuleSettingObj.getBoolean("consideryieldrate");
            }
            BigDecimal z = node.getQtynumerator();
            BigDecimal m = node.getQtydenominator();
            BigDecimal unitQty = NumberUtils.divide(z, m, this.standCostCalcParam.getBizLogger(), String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7269\u6599\u201c%2$s\u201d\u5b50\u9879\u7684\u5206\u6bcd\u4e3a0\u3002", (String)"StandCostCalculate_21", (String)"macc-cad-algox", (Object[])new Object[0]), node.getParentBomId(), node.getMaterial().getMaterialId()), 10);
            if (isLossRate) {
                if ("A".equals(node.getQtytype())) {
                    unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(node.getScraprate()), 10, 4) : unitQty.multiply(BigDecimal.ONE.add(node.getScraprate())).setScale(10, 4);
                } else if ("B".equals(node.getQtytype())) {
                    unitQty = unitQty.add(node.getFixscrap());
                } else if ("C".equals(node.getQtytype())) {
                    unitQty = unitQty.add(node.getFixscrap());
                }
            }
            if (isYield) {
                unitQty = unitQty.divide(node.getYieldrate(), 10, 4);
            }
            node.setUnitQty(unitQty);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97BOM\u5355\u4f4d\u8017\u7528\u91cf,\u8282\u70b9\u6570%s", (String)"StandCostCalculate_8", (String)"macc-cad-algox", (Object[])new Object[0]), this.tree.getNodeList().size()), new Boolean[0]);
    }

    public BigDecimal ladderedQty(CalculationNode node, boolean isLossRate, String lossRateFormula) {
        QFilter filter = new QFilter("id", "=", (Object)node.getParentBomId());
        filter.and("entry.entrymaterial.masterid", "=", (Object)node.getMaterial().getMaterialId());
        filter.and("entry.qtyentry.qtyentryvaliddate", "<=", (Object)this.standCostCalcParam.getCalcDate());
        filter.and("entry.qtyentry.qtyentryinvaliddate", ">=", (Object)this.standCostCalcParam.getCalcDate());
        DynamicObjectCollection ladderedQtyCol = QueryServiceHelper.query((String)"kd.macc.cad.algox.function.getSubItemList", (String)"cad_costbom", (String)"entry.entrymaterial.masterid,entry.qtyentry.qtyentryqtynumerator,entry.qtyentry.qtyentryqtydenominator,entry.qtyentry.qtyentryfixscrap,entry.qtyentry.qtyentryscraprate,entry.qtyentry.qtyentryisstepfix", (QFilter[])new QFilter[]{filter}, (String)"entry.qtyentry.qtyentrybatchstartqty");
        if (ladderedQtyCol.size() == 0) {
            return node.getUnitQty();
        }
        DynamicObject ladderedQtyObj = (DynamicObject)ladderedQtyCol.get(0);
        BigDecimal z = ladderedQtyObj.getBigDecimal("entry.qtyentry.qtyentryqtynumerator");
        BigDecimal m = ladderedQtyObj.getBigDecimal("entry.qtyentry.qtyentryqtydenominator");
        BigDecimal unitQty = NumberUtils.divide(z, m, this.standCostCalcParam.getBizLogger(), String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7269\u6599\u201c%2$s\u201d\u5b50\u9879\u9636\u68af\u7528\u91cf\u7684\u5206\u6bcd\u4e3a0\u3002", (String)"StandCostCalculate_19", (String)"macc-cad-algox", (Object[])new Object[0]), node.getParentBomId(), node.getMaterial().getMaterialId()), 10);
        if (ladderedQtyObj.getBoolean("entry.qtyentry.qtyentryisstepfix")) {
            unitQty = unitQty.add(ladderedQtyObj.getBigDecimal("entry.qtyentry.qtyentryfixscrap")).setScale(10, 4);
        } else {
            BigDecimal scrapRate = ladderedQtyObj.getBigDecimal("entry.qtyentry.qtyentryscraprate");
            unitQty = "2".equals(lossRateFormula) ? unitQty.divide(BigDecimal.ONE.subtract(scrapRate), 10, 4) : unitQty.multiply(scrapRate.add(BigDecimal.ONE)).setScale(10, 4);
        }
        return unitQty;
    }

    public Map<Long, Long[]> getSubItemList(Set<Long> materialId, Long costtypeId) {
        List orgIds = CostTypeHelper.getOrgByCostType((Long)costtypeId);
        if (CadEmptyUtils.isEmpty(orgIds)) {
            logger.info("\u6839\u636e\u6210\u672c\u7c7b\u578b\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\uff1a{}", (Object)costtypeId);
            return null;
        }
        Map matSubEleMap = ElementHelper.getDefSubEles((Long)((Long)orgIds.get(0)), materialId);
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u5b50\u8981\u7d20\u4fe1\u606f%s\u4e2a\u3002", (String)"StandCostCalculate_11", (String)"macc-cad-algox", (Object[])new Object[0]), matSubEleMap.size()), new Boolean[0]);
        return matSubEleMap;
    }

    public void getSubItemList() {
        QFilter filter = new QFilter("id", "=", (Object)this.standCostCalcParam.getCostTypeId());
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection costTypeCol = QueryServiceHelper.query((String)"kd.macc.cad.algox.function.getSubItemList", (String)"cad_costtype", (String)"elementtype.id", (QFilter[])new QFilter[]{filter}, null);
        if (costTypeCol.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"StandCostCalculate_10", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        long elementTypeId = ((DynamicObject)costTypeCol.get(0)).getLong("elementtype.id");
        filter = new QFilter("elementtype.id", "=", (Object)elementTypeId);
        QFilter enableFilter = new QFilter("subelement.enable", "=", (Object)true);
        DynamicObjectCollection item2SubElement = QueryServiceHelper.query((String)"kd.macc.cad.algox.function.getSubItemList", (String)"cad_elementdetail", (String)"element.id,subelement.id,subelement.defaultvalue,subelement.type", (QFilter[])new QFilter[]{filter, enableFilter}, null);
        this.subElement2ElementMap = new HashMap<Long, Long>();
        for (DynamicObject obj : item2SubElement) {
            this.subElement2ElementMap.put(obj.getLong("subelement.id"), obj.getLong("element.id"));
            this.subElementTypeMap.put(obj.getLong("subelement.id"), obj.getString("subelement.type"));
            if (!obj.getBoolean("subelement.defaultvalue") || !"001".equals(obj.getString("subelement.type"))) continue;
            this.commonSubElement = obj.getLong("subelement.id");
            this.commonElement = obj.getLong("element.id");
        }
    }

    private void getItemList() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection items = QueryServiceHelper.query((String)"kd.macc.cad.algox.function.getItemList", (String)"cad_element", (String)"id,type", (QFilter[])new QFilter[]{filter}, null);
        this.itemMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject itemObj : items) {
            this.itemMap.put(itemObj.getLong("id"), itemObj);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u672c\u8981\u7d20%s\u4e2a\u3002", (String)"StandCostCalculate_12", (String)"macc-cad-algox", (Object[])new Object[0]), this.itemMap.size()), new Boolean[0]);
    }

    private List<DynamicObject> findProdPriceByMaterial(Material material) {
        String keycol = material.getKeycol();
        List<DynamicObject> priceList = this.matKeycolOutPriceMap.get(keycol);
        if (CadEmptyUtils.isEmpty(priceList)) {
            return null;
        }
        return priceList;
    }

    private List<DynamicObject> findPurPriceByMaterial(Material material) {
        ArrayList<DynamicObject> subItems = new ArrayList<DynamicObject>();
        String keycol = material.getKeycol();
        List<DynamicObject> priceList = this.matKeycolPurPriceMap.get(keycol);
        if (CadEmptyUtils.isEmpty(priceList)) {
            subItems.add(null);
            return subItems;
        }
        return priceList;
    }

    private void write2Log(String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("\u5377\u7b97\uff08BOM\u6811\uff09:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"StandCostCalculate_15", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    private void write2LogNew(String desc, long startTime, long endTime, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("\u5377\u7b97\uff08BOM\u6811\uff09:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfoNew(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"StandCostCalculate_15", (String)"macc-cad-algox", (Object[])new Object[0]), desc, startTime, endTime);
        }
    }

    public Map<String, List<DynamicObject>> getMatKeycolOutPriceMap(List<String> outSourceMaterialKeyCols) {
        ArrayList<Long> costTypeIds = new ArrayList<Long>(2);
        costTypeIds.add(this.standCostCalcParam.getCostTypeId());
        costTypeIds.add(this.standCostCalcParam.getHsCostTypeId());
        List<Long> outPriceIds = StdCalculateHelper.getOutPriceIds(costTypeIds, outSourceMaterialKeyCols, this.standCostCalcParam.getCalcDate());
        outPriceIds.retainAll(this.standCostCalcParam.getOutPriceObjIds());
        QFilter filter = new QFilter("id", "in", outPriceIds);
        filter.and(new QFilter("keycol", "in", outSourceMaterialKeyCols));
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getOutPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
            long costtype = priceObj.getLong("costtype");
            if (this.standCostCalcParam.getHsCostTypeId().equals(costtype)) {
                this.standCostCalcParam.getMaterialPriceRuleMap().put(keycol, PriceRuleConstants.OUTPRI_STDCOST_ID);
            } else {
                this.standCostCalcParam.getMaterialPriceRuleMap().put(keycol, priceObj.getLong("pricerule"));
            }
            this.standCostCalcParam.getMaterialPriceIdMap().put(keycol, priceObj.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4ea7\u54c1\u59d4\u5916\u4ef7\u76ee\u8868%s\u4e2a\u3002", (String)"StandCostCalculate_30", (String)"macc-cad-algox", (Object[])new Object[0]), outPriceObjs.size()), new Boolean[0]);
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolOutPriceMapForDimension(List<String> outMaterialKeyCols, Map<String, String> actualKeycolMap) {
        Map<String, List<DynamicObject>> matKeycolActualOutPriceMap = this.getMatKeycolActualOutPriceMap(actualKeycolMap);
        HashMap<String, List<DynamicObject>> outPriceMap = new HashMap<String, List<DynamicObject>>(16);
        int count = 0;
        for (String outMaterialKeyCol : outMaterialKeyCols) {
            String actualKeycol;
            List<DynamicObject> dynamicObjects;
            if (!actualKeycolMap.containsKey(outMaterialKeyCol) || outPriceMap.containsKey(outMaterialKeyCol) || CadEmptyUtils.isEmpty(dynamicObjects = matKeycolActualOutPriceMap.get(actualKeycol = actualKeycolMap.get(outMaterialKeyCol)))) continue;
            DynamicObject dynamicObject = dynamicObjects.get(0);
            outPriceMap.computeIfAbsent(outMaterialKeyCol, p -> new ArrayList()).addAll(dynamicObjects);
            this.standCostCalcParam.getMaterialPriceRuleMap().put(outMaterialKeyCol, dynamicObject.getLong("pricerule"));
            this.standCostCalcParam.getMaterialPriceIdMap().put(outMaterialKeyCol, dynamicObject.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4ea7\u54c1\u59d4\u5916\u4ef7\u76ee\u8868%s\u4e2a\u3002", (String)"StandCostCalculate_30", (String)"macc-cad-algox", (Object[])new Object[0]), ++count), new Boolean[0]);
        return outPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolActualOutPriceMap(Map<String, String> actualKeycolMap) {
        HashMap<String, List<DynamicObject>> outPriceMap = new HashMap<String, List<DynamicObject>>(16);
        if (CadEmptyUtils.isEmpty(actualKeycolMap)) {
            return outPriceMap;
        }
        ArrayList<Long> costTypeIds = new ArrayList<Long>(2);
        costTypeIds.add(this.standCostCalcParam.getCostTypeId());
        costTypeIds.add(this.standCostCalcParam.getHsCostTypeId());
        ArrayList<String> keycols = new ArrayList<String>(10);
        keycols.addAll(actualKeycolMap.values());
        List<Long> outPriceIds = StdCalculateHelper.getOutPriceIds(costTypeIds, keycols, this.standCostCalcParam.getCalcDate());
        outPriceIds.retainAll(this.standCostCalcParam.getOutPriceObjIds());
        QFilter filter = new QFilter("id", "in", outPriceIds);
        filter.and(new QFilter("keycol", "in", actualKeycolMap.values()));
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getOutPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            outPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
        }
        return outPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolPurPriceMap(List<String> purMaterialKeyCols) {
        ArrayList<Long> costTypeIds = new ArrayList<Long>(2);
        costTypeIds.add(this.standCostCalcParam.getCostTypeId());
        costTypeIds.add(this.standCostCalcParam.getHsCostTypeId());
        List<Long> purPriceIds = StdCalculateHelper.getPurPriceIds(costTypeIds, purMaterialKeyCols, this.standCostCalcParam.getCalcDate());
        purPriceIds.retainAll(this.standCostCalcParam.getPruPriceObjIds());
        QFilter filter = new QFilter("id", "in", purPriceIds);
        filter.and(new QFilter("keycol", "in", purMaterialKeyCols));
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getPurPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
            this.standCostCalcParam.getMaterialPriceRuleMap().put(keycol, priceObj.getLong("pricerule"));
            this.standCostCalcParam.getMaterialPriceIdMap().put(keycol, priceObj.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868%s\u4e2a\u3002", (String)"StandCostCalculate_22", (String)"macc-cad-algox", (Object[])new Object[0]), outPriceObjs.size()), new Boolean[0]);
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolPurPriceMapForDimension(List<String> purMaterialKeyCols, Map<String, String> actualKeycolMap) {
        Map<String, List<DynamicObject>> matKeycolActualPurPriceMap = this.getMatKeycolActualPurPriceMap(actualKeycolMap);
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        int count = 0;
        for (String purMaterialKeyCol : purMaterialKeyCols) {
            List<DynamicObject> dynamicObjects;
            if (!actualKeycolMap.containsKey(purMaterialKeyCol)) continue;
            String actualKeycol = actualKeycolMap.get(purMaterialKeyCol);
            if (purPriceMap.containsKey(purMaterialKeyCol) || CadEmptyUtils.isEmpty(dynamicObjects = matKeycolActualPurPriceMap.get(actualKeycol))) continue;
            DynamicObject dynamicObject = dynamicObjects.get(0);
            purPriceMap.computeIfAbsent(purMaterialKeyCol, p -> new ArrayList()).addAll(dynamicObjects);
            this.standCostCalcParam.getMaterialPriceRuleMap().put(purMaterialKeyCol, dynamicObject.getLong("pricerule"));
            this.standCostCalcParam.getMaterialPriceIdMap().put(purMaterialKeyCol, dynamicObject.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868%s\u4e2a\u3002", (String)"StandCostCalculate_22", (String)"macc-cad-algox", (Object[])new Object[0]), ++count), new Boolean[0]);
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolActualPurPriceMap(Map<String, String> actualKeycolMap) {
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        if (CadEmptyUtils.isEmpty(actualKeycolMap)) {
            return purPriceMap;
        }
        ArrayList<Long> costTypeIds = new ArrayList<Long>(2);
        costTypeIds.add(this.standCostCalcParam.getCostTypeId());
        ArrayList<String> keycols = new ArrayList<String>(10);
        keycols.addAll(actualKeycolMap.values());
        List<Long> purPriceIds = StdCalculateHelper.getPurPriceIds(costTypeIds, keycols, this.standCostCalcParam.getCalcDate());
        purPriceIds.retainAll(this.standCostCalcParam.getPruPriceObjIds());
        QFilter filter = new QFilter("id", "in", purPriceIds);
        filter.and(new QFilter("keycol", "in", actualKeycolMap.values()));
        DynamicObjectCollection outPriceObjs = StdCalculateHelper.getPurPriceObjs(filter.toArray());
        for (DynamicObject priceObj : outPriceObjs) {
            String keycol = priceObj.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(priceObj);
        }
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolPurPriceMapByMatCostInfo(List<String> purMaterialKeyCols, Map<String, Long> purMatCostInfoMap) {
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        if (CadEmptyUtils.isEmpty(purMatCostInfoMap)) {
            return purPriceMap;
        }
        List<Long> matCostIds = StdCalculateHelper.getMatCostIds(this.standCostCalcParam.getHsCostTypeId(), purMaterialKeyCols, this.standCostCalcParam.getCalcDate());
        matCostIds.retainAll(purMatCostInfoMap.values());
        QFilter filter = new QFilter("id", "in", matCostIds);
        filter.and(new QFilter("keycol", "in", purMaterialKeyCols));
        DynamicObjectCollection matCostInfoObjs = StdCalculateHelper.getMatCostInfoObjs(filter.toArray());
        for (DynamicObject matCostInfo : matCostInfoObjs) {
            String keycol = matCostInfo.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(matCostInfo);
            this.standCostCalcParam.getMaterialPriceRuleMap().put(keycol, PriceRuleConstants.PUR_STDCOST_ID);
            this.standCostCalcParam.getMaterialPriceIdMap().put(keycol, matCostInfo.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u6210\u672c\u4fe1\u606f%s\u4e2a\u3002", (String)"StandCostCalculate_31", (String)"macc-cad-algox", (Object[])new Object[0]), matCostInfoObjs.size()), new Boolean[0]);
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolPurMatCostInfoForDimension(List<String> purMaterialKeyCols, Map<String, Long> purMatCostInfoMap, Map<String, String> actualKeycolMap) {
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        if (CadEmptyUtils.isEmpty(purMatCostInfoMap)) {
            return purPriceMap;
        }
        Map<String, List<DynamicObject>> matKeycolPurPriceMapByMatCostInfo = this.getMatKeycolPurPriceMapByMatCostInfo(actualKeycolMap, purMatCostInfoMap);
        for (String purMaterialKeyCol : purMaterialKeyCols) {
            List<DynamicObject> dynamicObjects;
            if (!actualKeycolMap.containsKey(purMaterialKeyCol)) continue;
            String actualKeycol = actualKeycolMap.get(purMaterialKeyCol);
            if (purPriceMap.containsKey(purMaterialKeyCol) || CadEmptyUtils.isEmpty(dynamicObjects = matKeycolPurPriceMapByMatCostInfo.get(actualKeycol))) continue;
            DynamicObject dynamicObject = dynamicObjects.get(0);
            purPriceMap.computeIfAbsent(purMaterialKeyCol, p -> new ArrayList()).addAll(dynamicObjects);
            this.standCostCalcParam.getMaterialPriceRuleMap().put(purMaterialKeyCol, PriceRuleConstants.PUR_STDCOST_ID);
            this.standCostCalcParam.getMaterialPriceIdMap().put(purMaterialKeyCol, dynamicObject.getLong("id"));
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7269\u6599\u6210\u672c\u4fe1\u606f%s\u4e2a\u3002", (String)"StandCostCalculate_31", (String)"macc-cad-algox", (Object[])new Object[0]), matKeycolPurPriceMapByMatCostInfo.size()), new Boolean[0]);
        return purPriceMap;
    }

    public Map<String, List<DynamicObject>> getMatKeycolPurPriceMapByMatCostInfo(Map<String, String> actualKeycolMap, Map<String, Long> purMatCostInfoMap) {
        HashMap<String, List<DynamicObject>> purPriceMap = new HashMap<String, List<DynamicObject>>(16);
        if (CadEmptyUtils.isEmpty(purMatCostInfoMap)) {
            return purPriceMap;
        }
        ArrayList<String> keycols = new ArrayList<String>(10);
        keycols.addAll(actualKeycolMap.values());
        List<Long> matCostIds = StdCalculateHelper.getMatCostIds(this.standCostCalcParam.getHsCostTypeId(), keycols, this.standCostCalcParam.getCalcDate());
        matCostIds.retainAll(purMatCostInfoMap.values());
        QFilter filter = new QFilter("id", "in", matCostIds);
        filter.and(new QFilter("keycol", "in", actualKeycolMap.values()));
        DynamicObjectCollection matCostInfoObjs = StdCalculateHelper.getMatCostInfoObjs(filter.toArray());
        for (DynamicObject matCostInfo : matCostInfoObjs) {
            String keycol = matCostInfo.getString("keycol");
            purPriceMap.computeIfAbsent(keycol, p -> new ArrayList()).add(matCostInfo);
        }
        return purPriceMap;
    }

    public Map<String, List<CalculationNodeSubElement>> getByMatKeycolByProdPriceObjMap() {
        HashMap<String, List<CalculationNodeSubElement>> map = new HashMap<String, List<CalculationNodeSubElement>>(16);
        if (CadEmptyUtils.isEmpty(this.standCostCalcParam.getCoByProductWithBom())) {
            return map;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)this.standCostCalcParam.getCostTypeId());
        filter.and(new QFilter("task", "=", (Object)this.standCostCalcParam.getTaskId()));
        filter.and(new QFilter("keycol", "in", this.standCostCalcParam.getCoByProductWithBom()));
        filter.and(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"}));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"keycol,entryentity.resource resource,entryentity.element element,entryentity.subelement subelement,entryentity.qty qty,entryentity.price price,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.sublot sublot,entryentity.subconfiguredcode subconfiguredcode,entryentity.subtracknumber subtracknumber,entryentity.subproject subproject,entryentity.subkeycol subkeycol,entryentity.subkeycolid subkeycolid,entryentity.activity activity,entryentity.datatype datatype,entryentity.calcbasis calcbasis", (QFilter[])filter.toArray());
        for (DynamicObject result : results) {
            CalculationNodeSubElement calculationNodeSubElement = new CalculationNodeSubElement();
            Material material = new Material();
            material.setMaterialId(result.getLong("submaterial"));
            material.setMaterialVer(result.getLong("submatvers"));
            material.setAffectPrice(true);
            material.setIsuseauxpty(true);
            material.setMaterialAuxPropId(result.getLong("subauxproperty"));
            material.setConfiguredcode(result.getLong("subconfiguredcode"));
            material.setTracknumber(result.getLong("subtracknumber"));
            material.setProject(result.getLong("subproject"));
            material.setLot(result.getString("sublot"));
            material.setKeycol();
            calculationNodeSubElement.setMaterial(material);
            calculationNodeSubElement.setElement(result.getLong("element"));
            calculationNodeSubElement.setSubElement(result.getLong("subelement"));
            calculationNodeSubElement.setResourceId(result.getLong("resource"));
            calculationNodeSubElement.setQty(result.getBigDecimal("qty"));
            calculationNodeSubElement.setPrice(result.getBigDecimal("price"));
            calculationNodeSubElement.setCost(result.getBigDecimal("stdprice"));
            calculationNodeSubElement.setActivityId(result.getLong("activity"));
            calculationNodeSubElement.setType(Integer.parseInt(result.getString("datatype")));
            calculationNodeSubElement.setCalcbasis(result.getString("calcbasis"));
            map.computeIfAbsent(result.getString("keycol"), p -> new ArrayList()).add(calculationNodeSubElement);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6709BOM\u8bbe\u7f6e\u7684\u8054\u526f\u4ea7\u54c1\u7684\u6210\u672c%s\u4e2a\u3002", (String)"StandCostCalculate_23", (String)"macc-cad-algox", (Object[])new Object[0]), map.keySet()), new Boolean[0]);
        return map;
    }

    public Map<String, List<CalculationNodeSubElement>> getMatKeycolAndByProdPurPriceObjMap() {
        HashMap<String, List<CalculationNodeSubElement>> map = new HashMap<String, List<CalculationNodeSubElement>>(16);
        if (CadEmptyUtils.isEmpty(this.standCostCalcParam.getMainAndCoByProductWithPurPriceMap())) {
            return map;
        }
        Map<String, Map<String, BigDecimal>> mainAndCoByProductWithPurPriceMap = this.standCostCalcParam.getMainAndCoByProductWithPurPriceMap();
        HashSet<String> byProducts = new HashSet<String>(10);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithPurPriceMap.entrySet()) {
            Map<String, BigDecimal> value = entry.getValue();
            byProducts.addAll(value.keySet());
        }
        int calcPurPriceBatchSize = CadBgParamUtils.getCadParamForInt((String)"calcPurPriceBatchSize", (int)200000);
        DynamicObjectCollection purResults = new DynamicObjectCollection();
        for (List pruPriceObjIds : Lists.partition(this.standCostCalcParam.getPruPriceObjIds(), (int)calcPurPriceBatchSize)) {
            QFilter filter = new QFilter("id", "in", (Object)pruPriceObjIds);
            filter.and(new QFilter("keycol", "in", byProducts));
            DynamicObjectCollection purResultObjs = QueryServiceHelper.query((String)"cad_purprices", (String)"keycol,0L resource,entryentity.element element,entryentity.subelement subelement,1L qty,entryentity.price price,entryentity.price stdprice,material submaterial,matversion submatvers,auxpty subauxproperty,lot sublot,configuredcode subconfiguredcode,tracknumber subtracknumber,project subproject,keycol subkeycol,keycolid subkeycolid,0L activity,' ' datatype,' ' calcbasis", (QFilter[])filter.toArray());
            if (CadEmptyUtils.isEmpty(purResultObjs)) continue;
            purResults.addAll((Collection)purResultObjs);
        }
        HashMap<String, List> purPriceObjMap = new HashMap<String, List>(16);
        for (DynamicObject purPrice : purResults) {
            String keycol = purPrice.getString("keycol");
            purPriceObjMap.computeIfAbsent(keycol, p -> new ArrayList()).add(purPrice);
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : mainAndCoByProductWithPurPriceMap.entrySet()) {
            String key = entry.getKey();
            Map<String, BigDecimal> values = entry.getValue();
            for (Map.Entry<String, BigDecimal> value : values.entrySet()) {
                String purkey = value.getKey();
                List results = (List)purPriceObjMap.get(purkey);
                if (CadEmptyUtils.isEmpty(results)) continue;
                for (DynamicObject result : results) {
                    CalculationNodeSubElement calculationNodeSubElement = new CalculationNodeSubElement();
                    Material material = new Material();
                    material.setMaterialId(result.getLong("submaterial"));
                    material.setMaterialVer(result.getLong("submatvers"));
                    material.setAffectPrice(true);
                    material.setIsuseauxpty(true);
                    material.setMaterialAuxPropId(result.getLong("subauxproperty"));
                    material.setConfiguredcode(result.getLong("subconfiguredcode"));
                    material.setTracknumber(result.getLong("subtracknumber"));
                    material.setProject(result.getLong("subproject"));
                    material.setLot(result.getString("sublot"));
                    material.setKeycol();
                    calculationNodeSubElement.setMaterial(material);
                    calculationNodeSubElement.setElement(result.getLong("element"));
                    calculationNodeSubElement.setSubElement(result.getLong("subelement"));
                    calculationNodeSubElement.setResourceId(result.getLong("resource"));
                    calculationNodeSubElement.setQty(result.getBigDecimal("qty"));
                    calculationNodeSubElement.setPrice(result.getBigDecimal("price"));
                    calculationNodeSubElement.setCost(result.getBigDecimal("stdprice"));
                    calculationNodeSubElement.setActivityId(result.getLong("activity"));
                    calculationNodeSubElement.setType(2);
                    calculationNodeSubElement.setCalcbasis(result.getString("calcbasis"));
                    map.computeIfAbsent(key, p -> new ArrayList()).add(calculationNodeSubElement);
                }
            }
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4ece\u5916\u8d2d\u53d6\u4ef7\u7684\u526f\u4ea7\u54c1\u7684\u6210\u672c%s\u4e2a\u3002", (String)"StandCostCalculate_24", (String)"macc-cad-algox", (Object[])new Object[0]), map.keySet()), new Boolean[0]);
        return map;
    }

    private Set<Long> getTreeAllMatIds() {
        return this.getTree().getNodeList().stream().map(item -> item.getMaterial().getMaterialId()).collect(Collectors.toSet());
    }

    private Set<String> getTreeAllMats() {
        return this.getTree().getNodeList().stream().map(item -> item.getMaterial().getKeycol()).collect(Collectors.toSet());
    }

    private void prepareProcessRouterCost(List<String> selfMaterialKeyCols) {
        ArrayList<Long> processRouteIds = new ArrayList<Long>(10);
        for (String mat : selfMaterialKeyCols) {
            String processRouteKey = this.processRouteCost.findProcessRoute(mat);
            Object[] split = processRouteKey.split("@");
            if (CadEmptyUtils.isEmpty(split)) continue;
            processRouteIds.add(Long.valueOf((String)split[0]));
        }
        if (CadEmptyUtils.isEmpty(processRouteIds)) {
            return;
        }
        String selectFields = "router,resource,element,subelement,qty,price,cost,processstage,activity,calcbasis,resourcetype,workcenter,operation,operationdesc,material,auxpty,processseq,operationno";
        QFilter processRouteIdFilter = new QFilter("router", "in", processRouteIds);
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)this.standCostCalcParam.getCostTypeId());
        costTypeFilter.and(new QFilter("task", "=", (Object)this.standCostCalcParam.getTaskId()));
        DataSet rows = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.function.StandCostCalculate.prepareProcessRouterCost", (String)"cad_calprocessroutecost", (String)selectFields, (QFilter[])new QFilter[]{costTypeFilter, processRouteIdFilter}, null);
        HashMap<String, List<CalculationNodeSubElement>> routerIdAndNodeMap = new HashMap<String, List<CalculationNodeSubElement>>(16);
        for (Row row : rows) {
            Long routerId = row.getLong("router");
            Long resourceId = row.getLong("resource");
            Long elementId = row.getLong("element");
            Long subElementId = row.getLong("subelement");
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal price = row.getBigDecimal("price");
            BigDecimal cost = row.getBigDecimal("cost");
            Long activityId = row.getLong("activity");
            String calcBasis = row.getString("calcbasis");
            String resourceType = row.getString("resourcetype");
            CalculationNodeSubElement calculationNodeSubElement = new CalculationNodeSubElement();
            calculationNodeSubElement.setResourceId(resourceId);
            calculationNodeSubElement.setElement(elementId);
            calculationNodeSubElement.setSubElement(subElementId);
            calculationNodeSubElement.setQty(qty);
            calculationNodeSubElement.setPrice(price);
            calculationNodeSubElement.setCost(cost);
            calculationNodeSubElement.setActivityId(activityId);
            calculationNodeSubElement.setCalcbasis(calcBasis);
            calculationNodeSubElement.setResourceType(resourceType);
            calculationNodeSubElement.setResWorkCenterId(row.getLong("workcenter"));
            calculationNodeSubElement.setOperationId(row.getLong("operation"));
            calculationNodeSubElement.setOperationDesc(row.getString("operationdesc"));
            calculationNodeSubElement.setResMaterialId(row.getLong("material"));
            calculationNodeSubElement.setResMaterialAuxptyId(row.getLong("auxpty"));
            calculationNodeSubElement.setProcessStage(row.getString("processstage"));
            calculationNodeSubElement.setProcessSeq(row.getString("processseq"));
            calculationNodeSubElement.setOperationNo(row.getString("operationno"));
            String key = routerId + "@" + calculationNodeSubElement.getResMaterialId() + "@" + calculationNodeSubElement.getResMaterialAuxptyId();
            ArrayList<CalculationNodeSubElement> subElements = (ArrayList<CalculationNodeSubElement>)routerIdAndNodeMap.get(key);
            if (subElements == null) {
                subElements = new ArrayList<CalculationNodeSubElement>(10);
                routerIdAndNodeMap.put(key, subElements);
            }
            subElements.add(calculationNodeSubElement);
        }
        this.processRouteCost.setProcessRouteCost(routerIdAndNodeMap);
    }
}

