/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.Data.CalculationNode;
import kd.macc.cad.algox.Data.CalculationNodeSubElement;
import kd.macc.cad.algox.Data.CalculationTree;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.function.CalculationTreeInitial;
import kd.macc.cad.algox.function.ProcessRouteCost;
import kd.macc.cad.algox.function.StandCostCalculate;
import kd.macc.cad.algox.input.CalcStandCostCalcParam;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;

public class StandCostCalculationFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -6582277222787152940L;
    private static final Log logger = LogFactory.getLog(StandCostCalculationFunction.class);
    private int writeToDBBatch = 500;
    private CalcStandCostCalcParam standCostCalcParam = null;
    private OutputType outputType;
    private int bomTreeCount = 1;
    private ProcessRouteCost processRouteCost = null;
    private Map<Long, Set<Long>> partBomInTrees = null;
    private Map<String, BigDecimal> pathStdQty = new HashMap<String, BigDecimal>(16);

    public Map<Long, Set<Long>> getPartBomInTrees() {
        return this.partBomInTrees;
    }

    public void setPartBomInTrees(Map<Long, Set<Long>> partBomInTrees) {
        this.partBomInTrees = partBomInTrees;
    }

    public ProcessRouteCost getProcessRouteCost() {
        return this.processRouteCost;
    }

    public void setProcessRouteCost(ProcessRouteCost processRouteCost) {
        this.processRouteCost = processRouteCost;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public CalcStandCostCalcParam getStandCostCalcParam() {
        return this.standCostCalcParam;
    }

    public void setStandCostCalcParam(CalcStandCostCalcParam standCostCalcParam) {
        this.standCostCalcParam = standCostCalcParam;
    }

    public int getWriteToDBBatch() {
        return this.writeToDBBatch;
    }

    public void setWriteToDBBatch(int writeToDBBatch) {
        this.writeToDBBatch = writeToDBBatch;
    }

    public int getBomTreeCount() {
        return this.bomTreeCount;
    }

    public void setBomTreeCount(int bomTreeCount) {
        this.bomTreeCount = bomTreeCount;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try {
            this.calculateOneTree(iterable, collector);
        }
        catch (Exception exp) {
            if (this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
                this.standCostCalcParam.getBizLogger().writeError(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"StandCostCalculationFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]), exp);
            }
            throw exp;
        }
    }

    public void calculateOneTree(Iterable<RowX> iterable, Collector collector) {
        CalculationTreeInitial treeInitial = new CalculationTreeInitial();
        treeInitial.setStandCostCalcParam(this.standCostCalcParam);
        CalculationTree tree = treeInitial.init(iterable);
        if (tree == null) {
            logger.info("\u4e0d\u5b58\u5728\u8ba1\u7b97\u7684BOM\u6811");
            return;
        }
        if (!this.standCostCalcParam.isTrackCalc().booleanValue() && this.isCalc(this.standCostCalcParam.getCostTypeId(), tree.getRoot().getMaterial().getKeycol(), this.standCostCalcParam.getTaskId()).booleanValue()) {
            return;
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316bom\u6811\u3010%1$s\u3011\u8282\u70b9\u6570\u3010%2$s\u3011", (String)"StandCostCalculationFunction_8", (String)"macc-cad-algox", (Object[])new Object[0]), tree.getRoot().getBomTreeRootId(), tree.getNodeList().size()), new Boolean[0]);
        StandCostCalculate calculate = new StandCostCalculate();
        calculate.setStandCostCalcParam(this.standCostCalcParam);
        calculate.setTree(tree);
        calculate.setProcessRouteCost(this.processRouteCost);
        calculate.calculate();
        long bomTreeRootId = tree.getRoot().getBomTreeRootId();
        if (this.outputType == OutputType.ToDB) {
            logger.info("\u8f93\u51fa\u5230DB");
            if (this.standCostCalcParam.isTrackCalc().booleanValue()) {
                long startTime = TimeServiceHelper.now().getTime();
                this.writeToDbForTracknum(calculate.getTree());
                this.write2LogNew(ResManager.loadKDString((String)"\u5377\u7b97\u7ed3\u679c\u8f93\u51fa\u5230DB", (String)"StandCostCalculationFunction_11", (String)"macc-cad-algox", (Object[])new Object[0]), startTime, TimeServiceHelper.now().getTime(), Boolean.TRUE);
            } else {
                this.newWriteToDb(calculate.getTree());
            }
            this.write2Log(String.format(ResManager.loadKDString((String)"BOM\u6811\u201c%s\u201d\u8f93\u51fa\u5230DB\u3002", (String)"StandCostCalculationFunction_2", (String)"macc-cad-algox", (Object[])new Object[0]), bomTreeRootId), new Boolean[0]);
            this.writeFinishData(tree, collector);
        } else {
            logger.info("\u8f93\u51facollector");
            this.writeToCollector(calculate.getTree(), collector);
            this.write2Log(String.format(ResManager.loadKDString((String)"bom\u6811\u3010%s\u3011,collector", (String)"StandCostCalculationFunction_3", (String)"macc-cad-algox", (Object[])new Object[0]), bomTreeRootId), new Boolean[0]);
        }
        this.write2Log(String.format(ResManager.loadKDString((String)"BOM\u6811\u201c%s\u201d\u5377\u7b97\u5b8c\u6210\u3002", (String)"StandCostCalculationFunction_4", (String)"macc-cad-algox", (Object[])new Object[0]), bomTreeRootId), Boolean.TRUE);
    }

    private Boolean isCalc(Long costType, String keycol, Long taskId) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("task", "=", (Object)taskId));
        filter.and(new QFilter("keycol", "=", (Object)keycol));
        filter.and(new QFilter("ismaindata", "=", (Object)1));
        return QueryServiceHelper.exists((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{filter});
    }

    private void writeFinishData(CalculationTree tree, Collector collector) {
        Object[] values = new Object[this.getResultRowMeta().getFieldCount()];
        values[0] = 999999L;
        values[22] = tree.getRoot().getBomTreeRootId();
        collector.collect(new RowX(values));
    }

    public RowMeta getResultRowMeta() {
        return CalculationNode.getRowMeta();
    }

    private void writeToDb(CalculationTree dataSet) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        int count = this.writeNode2Db(dataSet.getRoot(), dynamicObjects, Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        this.write2Log(String.format(ResManager.loadKDString((String)"BOM\u6811\u201c%1$s\u201d\u8f93\u51fa\u5230DB\uff0c\u8bb0\u5f55\u6570%2$s\u4e2a\u3002", (String)"StandCostCalculationFunction_9", (String)"macc-cad-algox", (Object[])new Object[0]), dataSet.getRoot().getBomTreeRootId(), count), new Boolean[0]);
    }

    private void newWriteToDb(CalculationTree dataSet) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        int count = this.writeNode2Db(dataSet.getRoot(), dynamicObjects, Boolean.FALSE);
        if (!dynamicObjects.isEmpty()) {
            this.dealResult(dynamicObjects);
        }
    }

    private void dealResult(List<DynamicObject> dynamicObjects) {
        ArrayList<Map<String, List<DynamicObject>>> keyColDyoMapList = new ArrayList<Map<String, List<DynamicObject>>>(10);
        for (DynamicObject dyo : dynamicObjects) {
            String key;
            Map<String, List<DynamicObject>> existKeyColDyoMap;
            Map<String, List<DynamicObject>> keyColDyoMap = this.getCurKeyColDyoMap(keyColDyoMapList, this.getWriteToDBBatch());
            if (!keyColDyoMapList.contains(keyColDyoMap)) {
                keyColDyoMapList.add(keyColDyoMap);
            }
            if ((existKeyColDyoMap = this.getExistKeyColDyoMap(keyColDyoMapList, key = dyo.getString("keycol"))) == null) {
                List list = keyColDyoMap.computeIfAbsent(key, k -> Lists.newArrayListWithCapacity((int)16));
                list.add(dyo);
                continue;
            }
            List<DynamicObject> existList = existKeyColDyoMap.get(key);
            existList.add(dyo);
        }
        Map<Object, Object> calcRecordDyoMap = new HashMap(16);
        if (this.standCostCalcParam.isSaveRecord().booleanValue()) {
            calcRecordDyoMap = this.getCalcRecord(dynamicObjects, this.standCostCalcParam);
        }
        dynamicObjects.clear();
        Iterator iterator = keyColDyoMapList.iterator();
        while (iterator.hasNext()) {
            QFilter recordFilter;
            Map subKeyColDyoMap = (Map)iterator.next();
            QFilter filter = new QFilter("costtype", "=", (Object)this.standCostCalcParam.getCostTypeId());
            filter.and(new QFilter("keycol", "in", subKeyColDyoMap.keySet()));
            filter.and(new QFilter("ismaindata", "=", (Object)1));
            filter.and(new QFilter("task", "=", (Object)this.standCostCalcParam.getTaskId()));
            if (this.standCostCalcParam.isSaveRecord().booleanValue()) {
                recordFilter = new QFilter("calcrecord.name", "=", (Object)this.standCostCalcParam.getRecordName());
                filter.and(recordFilter);
            } else {
                recordFilter = new QFilter("calcrecord", "is null", null);
                recordFilter.or(new QFilter("calcrecord", "<=", (Object)0L));
                filter.and(recordFilter);
            }
            DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)"id,task,ismaindata,iscalccurlevel,costtype,material,keycol,keycolid,entryentity.resource,entryentity.subelement,entryentity.stdprice,entryentity.submaterial,entryentity.datatype,entryentity.subkeycol,entryentity.subkeycolid,entryentity.activity,entryentity.priceid,treeentry.subcosttype,treeentry.subroot,treeentry.subtreepath,treeentry.subcalcdate", (QFilter[])filter.toArray());
            HashMap existDyoMap = Maps.newHashMapWithExpectedSize((int)64);
            for (DynamicObject dyo : dyos) {
                existDyoMap.put(dyo.getString("keycol"), dyo);
            }
            ArrayList addObjs = Lists.newArrayListWithCapacity((int)64);
            ArrayList updateObjs = Lists.newArrayListWithCapacity((int)64);
            ArrayList faildObjs = Lists.newArrayListWithCapacity((int)64);
            for (Map.Entry entry : subKeyColDyoMap.entrySet()) {
                DynamicObject record;
                DynamicObject newObj;
                String keycol = (String)entry.getKey();
                List listValue = (List)entry.getValue();
                DynamicObject exists = (DynamicObject)existDyoMap.get(keycol);
                if (exists == null) {
                    newObj = this.generateNewObjs(listValue);
                    if (calcRecordDyoMap.get(keycol) != null) {
                        record = (DynamicObject)calcRecordDyoMap.get(keycol);
                        newObj.set("calcrecord", (Object)record.getLong("id"));
                    }
                    addObjs.add(newObj);
                    if (addObjs.size() > 1000) {
                        this.saveResultObjs(addObjs);
                    }
                    existDyoMap.put(keycol, newObj);
                    continue;
                }
                newObj = (DynamicObject)listValue.get(0);
                if (this.isSameCost(newObj, exists)) {
                    this.generateNewTreepath(listValue, exists);
                    updateObjs.add(exists);
                    if (updateObjs.size() <= 1000) continue;
                    this.updateResultObjs(updateObjs);
                    continue;
                }
                newObj = this.generateNewObjs(listValue);
                if (calcRecordDyoMap.get(keycol) != null) {
                    record = (DynamicObject)calcRecordDyoMap.get(keycol);
                    newObj.set("calcrecord", (Object)record.getLong("id"));
                }
                addObjs.add(newObj);
                if (addObjs.size() > 1000) {
                    this.saveResultObjs(addObjs);
                }
                exists.set("ismaindata", (Object)0);
                faildObjs.add(exists);
                if (faildObjs.size() <= 1000) continue;
                this.saveResultObjs(faildObjs);
            }
            if (!addObjs.isEmpty()) {
                this.saveResultObjs(addObjs);
            }
            if (!updateObjs.isEmpty()) {
                this.updateResultObjs(updateObjs);
            }
            if (!faildObjs.isEmpty()) {
                this.saveResultObjs(faildObjs);
            }
            iterator.remove();
        }
        SaveServiceHelper.save((DynamicObject[])calcRecordDyoMap.values().toArray(new DynamicObject[0]));
    }

    private void saveResultObjs(List<DynamicObject> objs) {
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("\u5377\u7b97\u7ed3\u679c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
        objs.clear();
    }

    private void updateResultObjs(List<DynamicObject> objs) {
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.update((DynamicObject[])objs.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.error("\u5377\u7b97\u7ed3\u679c\u66f4\u65b0\u5931\u8d25", (Throwable)e);
        }
        objs.clear();
    }

    private void writeToDbForTracknum(CalculationTree dataSet) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        this.writeNode2Db(dataSet.getRoot(), dynamicObjects, Boolean.TRUE);
        HashMap<String, List> nodeDyoMap = new HashMap<String, List>(16);
        ArrayList<String> rootNodeList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String rootNode;
            String[] split;
            String treepath = dynamicObject.getString("treepath");
            if (CadEmptyUtils.isEmpty(treepath) || (split = treepath.split("@")).length == 1 && dynamicObjects.size() > 1 || CadEmptyUtils.isEmpty(rootNode = split[0])) continue;
            rootNodeList.add(rootNode);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            String rootNode = dynamicObject.getString("rootnode");
            if (CadEmptyUtils.isEmpty(rootNode) || !rootNodeList.contains(rootNode)) continue;
            nodeDyoMap.computeIfAbsent(rootNode, p -> new ArrayList()).add(dynamicObject);
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(200);
        for (Map.Entry dyo : nodeDyoMap.entrySet()) {
            String node = (String)dyo.getKey();
            List resDyos = (List)dyo.getValue();
            if (CadEmptyUtils.isEmpty(resDyos)) continue;
            DynamicObject mainDyo = null;
            for (DynamicObject resDyo : resDyos) {
                String treepath = resDyo.getString("treepath");
                if (!node.equals(treepath)) continue;
                mainDyo = resDyo;
                break;
            }
            if (mainDyo == null) continue;
            Map<String, Set<Long>> matConfigCodeTrackNumMap = this.standCostCalcParam.getMatConfigCodeTrackNumMap();
            ArrayList<String> existTrackNumKc = new ArrayList<String>(10);
            for (Map.Entry entry : matConfigCodeTrackNumMap.entrySet()) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                if (CadEmptyUtils.isEmpty(value)) continue;
                existTrackNumKc.add(key);
            }
            if (!this.standCostCalcParam.getKeycols().contains(mainDyo.getString("keycol")) || !existTrackNumKc.contains(mainDyo.getString("keycol"))) continue;
            DynamicObject trackStdCalcResult = BusinessDataServiceHelper.newDynamicObject((String)"cad_trackstdcalcresult");
            trackStdCalcResult.set("calcdate", mainDyo.get("calcdate"));
            trackStdCalcResult.set("costtype", mainDyo.get("costtype"));
            trackStdCalcResult.set("task", mainDyo.get("task"));
            trackStdCalcResult.set("material", mainDyo.get("material"));
            trackStdCalcResult.set("auxproperty", mainDyo.get("auxproperty"));
            trackStdCalcResult.set("matvers", mainDyo.get("matvers"));
            trackStdCalcResult.set("project", mainDyo.get("project"));
            trackStdCalcResult.set("tracknumber", mainDyo.get("tracknumber"));
            trackStdCalcResult.set("configuredcode", mainDyo.get("configuredcode"));
            trackStdCalcResult.set("lot", mainDyo.get("lot"));
            trackStdCalcResult.set("keycol", mainDyo.get("keycol"));
            trackStdCalcResult.set("keycolid", mainDyo.get("keycolid"));
            trackStdCalcResult.set("bomid", mainDyo.get("bom"));
            trackStdCalcResult.set("processrouteid", mainDyo.get("processroute"));
            trackStdCalcResult.set("rootnode", mainDyo.get("rootnode"));
            trackStdCalcResult.set("treepath", mainDyo.get("treepath"));
            trackStdCalcResult.set("isleaf", mainDyo.get("isleaf"));
            trackStdCalcResult.set("ismaindata", (Object)1);
            trackStdCalcResult.set("iscalccurlevel", mainDyo.get("iscalccurlevel"));
            trackStdCalcResult.set("priceplan", mainDyo.get("priceplan"));
            DynamicObjectCollection dynamicObjectCollection = trackStdCalcResult.getDynamicObjectCollection("origentryentity");
            ArrayList<String> existTreePath = new ArrayList<String>(10);
            for (DynamicObject resDyo : resDyos) {
                String treepath = resDyo.getString("treepath");
                if (existTreePath.contains(treepath)) continue;
                existTreePath.add(treepath);
                DynamicObject row = dynamicObjectCollection.addNew();
                row.set("origentrymaterial", resDyo.get("material"));
                row.set("origentryauxproperty", resDyo.get("auxproperty"));
                row.set("origentrymatvers", resDyo.get("matvers"));
                row.set("origentryproject", resDyo.get("project"));
                row.set("origentrytracknumber", resDyo.get("tracknumber"));
                row.set("origentryconfiguredcode", resDyo.get("configuredcode"));
                row.set("origentrylot", resDyo.get("lot"));
                row.set("origentrykeycol", resDyo.get("keycol"));
                row.set("origentrykeycolid", resDyo.get("keycolid"));
                row.set("origentrybomid", resDyo.get("bom"));
                row.set("origentryprocessrouteid", resDyo.get("processroute"));
                row.set("origentryrootnode", resDyo.get("rootnode"));
                row.set("origentrytreepath", resDyo.get("treepath"));
                row.set("origentryisleaf", resDyo.get("isleaf"));
                row.set("origentryismaindata", (Object)1);
                row.set("origentrymaterialattr", resDyo.get("materialattr"));
                row.set("origentrystdqty", (Object)(this.pathStdQty.get(resDyo.getString("treepath")) == null ? BigDecimal.ONE : this.pathStdQty.get(resDyo.getString("treepath"))));
                String[] split = treepath.split("@");
                row.set("origentrylevel", (Object)(split.length - 1));
                DynamicObjectCollection subEntryEntity = row.getDynamicObjectCollection("origsubentryentity");
                DynamicObjectCollection entryEntityDyos = resDyo.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryEntityDyo : entryEntityDyos) {
                    DynamicObject subRow = subEntryEntity.addNew();
                    subRow.set("origresource", entryEntityDyo.get("resource"));
                    subRow.set("origelement", entryEntityDyo.get("element"));
                    subRow.set("origsubelement", entryEntityDyo.get("subelement"));
                    subRow.set("origqty", entryEntityDyo.get("qty"));
                    subRow.set("origprice", entryEntityDyo.get("price"));
                    subRow.set("origstdprice", entryEntityDyo.get("stdprice"));
                    subRow.set("origdatatype", entryEntityDyo.get("datatype"));
                    subRow.set("origactivity", entryEntityDyo.get("activity"));
                    subRow.set("origcalcbasis", entryEntityDyo.get("calcbasis"));
                    subRow.set("origsubmaterial", entryEntityDyo.get("submaterial"));
                    subRow.set("origsubmatvers", entryEntityDyo.get("submatvers"));
                    subRow.set("origsubauxproperty", entryEntityDyo.get("subauxproperty"));
                    subRow.set("origsubproject", entryEntityDyo.get("subproject"));
                    subRow.set("origsubtracknumber", entryEntityDyo.get("subtracknumber"));
                    subRow.set("origsubconfiguredcode", entryEntityDyo.get("subconfiguredcode"));
                    subRow.set("origsublot", entryEntityDyo.get("sublot"));
                    subRow.set("origsubkeycol", entryEntityDyo.get("subkeycol"));
                    subRow.set("origsubkeycolid", entryEntityDyo.get("subkeycolid"));
                    subRow.set("origresourcetype", entryEntityDyo.get("resourcetype"));
                    subRow.set("origpricerule", entryEntityDyo.get("pricerule"));
                    subRow.set("origpriceid", entryEntityDyo.get("priceid"));
                    subRow.set("origoperation", entryEntityDyo.get("operation"));
                    subRow.set("origoperationdesc", entryEntityDyo.get("operationdesc"));
                    subRow.set("origworkcenter", entryEntityDyo.get("workcenter"));
                    subRow.set("origprocessseq", entryEntityDyo.get("processseq"));
                    subRow.set("origoperationno", entryEntityDyo.get("operationno"));
                }
            }
            resultList.add(trackStdCalcResult);
        }
        SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
    }

    private boolean isSameCost(DynamicObject newObj, DynamicObject exists) {
        DynamicObjectCollection newEntryColl = newObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection existsEntryColl = exists.getDynamicObjectCollection("entryentity");
        if (newEntryColl.size() != existsEntryColl.size()) {
            return false;
        }
        HashMap<String, BigDecimal> newMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> existsMap = new HashMap<String, BigDecimal>(16);
        for (int i = 0; i < newEntryColl.size(); ++i) {
            DynamicObject newEntry = (DynamicObject)newEntryColl.get(i);
            DynamicObject existsEntry = (DynamicObject)existsEntryColl.get(i);
            String newKey = newEntry.getString("datatype") + "@" + newEntry.getLong("resource") + "@" + newEntry.getLong("subelement") + "@" + newEntry.getLong("submaterial") + "@" + newEntry.getString("subkeycol") + "@" + newEntry.getLong("activity") + "@" + newEntry.getLong("priceid");
            String existsKey = existsEntry.getString("datatype") + "@" + existsEntry.getLong("resource.id") + "@" + existsEntry.getLong("subelement.id") + "@" + existsEntry.getLong("submaterial.id") + "@" + existsEntry.getString("subkeycol") + "@" + existsEntry.getLong("activity.id") + "@" + newEntry.getLong("priceid");
            BigDecimal newDecimal = newEntry.getBigDecimal("stdprice").setScale(10, 4);
            BigDecimal existsDecimal = existsEntry.getBigDecimal("stdprice");
            newMap.put(newKey, newDecimal);
            existsMap.put(existsKey, existsDecimal);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            String key = (String)entry.getKey();
            BigDecimal newDecimal = (BigDecimal)entry.getValue();
            if (existsMap.get(key) == null) {
                return false;
            }
            if (newDecimal.compareTo((BigDecimal)existsMap.get(key)) == 0) continue;
            return false;
        }
        return true;
    }

    private DynamicObject generateNewObjs(List<DynamicObject> listValue) {
        DynamicObject newObj = listValue.get(0);
        this.generateNewTreepath(listValue, newObj);
        return newObj;
    }

    private void generateNewTreepath(List<DynamicObject> listValue, DynamicObject dyno) {
        dyno.set("task", (Object)this.standCostCalcParam.getTaskId());
        dyno.set("ismaindata", (Object)1);
        dyno.set("iscalccurlevel", dyno.get("iscalccurlevel"));
        DynamicObjectCollection treeEntry = dyno.getDynamicObjectCollection("treeentry");
        for (DynamicObject dynamicObject : listValue) {
            DynamicObject entryObj = treeEntry.addNew();
            entryObj.set("subcosttype", dynamicObject.get("costtype"));
            entryObj.set("subroot", dynamicObject.get("rootnode"));
            entryObj.set("subtreepath", dynamicObject.get("treepath"));
            entryObj.set("subcalcdate", dynamicObject.get("calcdate"));
        }
    }

    private int writeNode2Db(CalculationNode node, List<DynamicObject> dynamicObjects, Boolean isSaveLeaf) {
        String processRoute;
        if (node.isLeaf() && !isSaveLeaf.booleanValue()) {
            return 0;
        }
        if (!CadEmptyUtils.isEmpty(this.standCostCalcParam.getDefaultConfigKeycols())) {
            if (!this.standCostCalcParam.getDefaultConfigKeycols().contains(node.getMaterial().getKeycol())) {
                int count = 0;
                for (CalculationNode node1 : node.getSubNodes()) {
                    count += this.writeNode2Db(node1, dynamicObjects, isSaveLeaf);
                }
                return count;
            }
        } else if (this.standCostCalcParam.isCalcCurLevel() && !this.standCostCalcParam.getKeycols().contains(node.getMaterial().getKeycol()) && !this.standCostCalcParam.getCoByMaterialKeycols().contains(node.getMaterial().getKeycol())) {
            int count = 0;
            for (CalculationNode node1 : node.getSubNodes()) {
                count += this.writeNode2Db(node1, dynamicObjects, isSaveLeaf);
            }
            return count;
        }
        if (!this.pathStdQty.containsKey(node.getBomTreePath())) {
            this.pathStdQty.put(node.getBomTreePath(), node.getStdQty());
        }
        DynamicObject resultObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_calcsimulationresult");
        resultObj.set("calcdate", (Object)this.standCostCalcParam.getCalcDate());
        resultObj.set("costtype", (Object)this.standCostCalcParam.getCostTypeId());
        resultObj.set("task", (Object)this.standCostCalcParam.getTaskId());
        resultObj.set("level", (Object)node.getLevel());
        resultObj.set("material", (Object)node.getMaterial().getMaterialId());
        resultObj.set("auxproperty", (Object)node.getMaterial().getMaterialAuxPropId());
        resultObj.set("matvers", (Object)node.getMaterial().getMaterialVer());
        resultObj.set("project", (Object)node.getMaterial().getProject());
        resultObj.set("tracknumber", (Object)node.getMaterial().getTracknumber());
        resultObj.set("configuredcode", (Object)node.getMaterial().getConfiguredcode());
        resultObj.set("lot", (Object)node.getMaterial().getLot());
        resultObj.set("materialattr", (Object)node.getMaterial().getMaterialAttr());
        resultObj.set("priceplan", (Object)this.standCostCalcParam.getPriceRuleScheme());
        Keycol calcKey = CalcKeyHelper.getCalcKey((DynamicObject)resultObj, (boolean)true);
        resultObj.set("keycol", (Object)calcKey.getKeycol());
        resultObj.set("keycolid", (Object)calcKey.getId());
        resultObj.set("bom", (Object)(node.getBomId() == 0L ? node.getExpandBomId() : node.getBomId()));
        Long route = 0L;
        String string = processRoute = node.getMaterial() == null ? "" : this.processRouteCost.findProcessRoute(node.getMaterial().getKeycol());
        if (!CadEmptyUtils.isEmpty(processRoute)) {
            String[] split = processRoute.split("@");
            route = Long.parseLong(split[0]);
        }
        resultObj.set("processroute", (Object)route);
        resultObj.set("rootnode", (Object)node.getBomTreeRootId());
        resultObj.set("treepath", (Object)node.getBomTreePath());
        resultObj.set("isleaf", (Object)(node.isLeaf() ? "1" : "0"));
        resultObj.set("ispubmat", (Object)(node.isPart() ? 1 : 0));
        if (this.standCostCalcParam.isCalcCurLevel()) {
            resultObj.set("iscalccurlevel", (Object)1);
        }
        DynamicObjectCollection entry = resultObj.getDynamicObjectCollection("entryentity");
        BigDecimal subImteTotal = BigDecimal.ZERO;
        BigDecimal subSumTotal = BigDecimal.ZERO;
        int maxIndex = 0;
        BigDecimal maxStdPrice = BigDecimal.ZERO;
        Map<String, Long> materialPriceRuleMap = this.standCostCalcParam.getMaterialPriceRuleMap();
        Map<String, Long> materialPriceIdMap = this.standCostCalcParam.getMaterialPriceIdMap();
        Map<Long, Map<String, Long>> costTypeResourcePriceRuleMap = this.standCostCalcParam.getResourcePriceRuleMap();
        Map<Long, Map<String, Long>> mcostTypeResourcePriceIdMap = this.standCostCalcParam.getResourcePriceIdMap();
        Map<String, Long> resourcePriceRuleMap = costTypeResourcePriceRuleMap.get(this.standCostCalcParam.getCostTypeId());
        Map<String, Long> resourcePriceIdMap = mcostTypeResourcePriceIdMap.get(this.standCostCalcParam.getCostTypeId());
        for (CalculationNodeSubElement subElement : node.getSubElementList()) {
            DynamicObject entryObj = entry.addNew();
            entryObj.set("resource", (Object)subElement.getResourceId());
            entryObj.set("element", (Object)subElement.getElement());
            entryObj.set("subelement", (Object)subElement.getSubElement());
            entryObj.set("qty", (Object)subElement.getQty());
            entryObj.set("price", (Object)subElement.getPrice());
            entryObj.set("stdprice", (Object)subElement.getCost());
            entryObj.set("datatype", (Object)subElement.getType());
            entryObj.set("activity", (Object)subElement.getActivityId());
            entryObj.set("calcbasis", (Object)subElement.getCalcbasis());
            entryObj.set("resourcetype", (Object)subElement.getResourceType());
            entryObj.set("operation", (Object)subElement.getOperationId());
            entryObj.set("operationdesc", (Object)subElement.getOperationDesc());
            entryObj.set("workcenter", (Object)subElement.getResWorkCenterId());
            entryObj.set("processseq", (Object)subElement.getProcessSeq());
            entryObj.set("operationno", (Object)subElement.getOperationNo());
            if (subElement.getMaterial() != null) {
                entryObj.set("submaterial", (Object)subElement.getMaterial().getMaterialId());
                entryObj.set("submatvers", (Object)subElement.getMaterial().getMaterialVer());
                entryObj.set("subauxproperty", (Object)subElement.getMaterial().getMaterialAuxPropId());
                entryObj.set("subproject", (Object)subElement.getMaterial().getProject());
                entryObj.set("subtracknumber", (Object)subElement.getMaterial().getTracknumber());
                entryObj.set("subconfiguredcode", (Object)subElement.getMaterial().getConfiguredcode());
                entryObj.set("sublot", (Object)subElement.getMaterial().getLot());
                Keycol subCalcKey = CalcKeyHelper.getCalcKey((DynamicObject)entryObj, (boolean)false);
                entryObj.set("subkeycol", (Object)subCalcKey.getKeycol());
                entryObj.set("subkeycolid", (Object)subCalcKey.getId());
                if (materialPriceRuleMap.containsKey(subCalcKey.getKeycol())) {
                    entryObj.set("pricerule", (Object)materialPriceRuleMap.get(subCalcKey.getKeycol()));
                }
                if (materialPriceIdMap.containsKey(subCalcKey.getKeycol())) {
                    entryObj.set("priceid", (Object)materialPriceIdMap.get(subCalcKey.getKeycol()));
                }
            } else {
                String key = "";
                if ("1".equals(subElement.getResourceType())) {
                    key = "1@" + subElement.getResWorkCenterId() + "@" + subElement.getResourceId();
                    if (resourcePriceRuleMap != null && !resourcePriceRuleMap.containsKey(key)) {
                        key = "1@0@" + subElement.getResourceId();
                    }
                } else if ("2".equals(subElement.getResourceType())) {
                    key = "2@" + route + "@" + subElement.getProcessSeq() + "@" + subElement.getOperationNo() + "@" + subElement.getResourceId();
                }
                if (resourcePriceRuleMap != null && resourcePriceRuleMap.containsKey(key)) {
                    entryObj.set("pricerule", (Object)resourcePriceRuleMap.get(key));
                }
                if (resourcePriceIdMap != null && resourcePriceIdMap.containsKey(key)) {
                    entryObj.set("priceid", (Object)resourcePriceIdMap.get(key));
                }
            }
            if (4 == subElement.getType()) {
                subSumTotal = subSumTotal.add(subElement.getCost());
            }
            if (3 == subElement.getType()) {
                subImteTotal = subImteTotal.add(subElement.getCost());
            }
            if (maxStdPrice.compareTo(subElement.getCost()) >= 0 || 3 != subElement.getType()) continue;
            maxStdPrice = subElement.getCost();
            maxIndex = entry.size() - 1;
        }
        if (subImteTotal.compareTo(subSumTotal) != 0) {
            DynamicObject needAdjDiff = (DynamicObject)entry.get(maxIndex);
            BigDecimal diffAmt = subSumTotal.subtract(subImteTotal);
            BigDecimal qty = needAdjDiff.getBigDecimal("qty");
            BigDecimal stdPrice = needAdjDiff.getBigDecimal("stdprice").add(diffAmt);
            if (stdPrice.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(BigDecimal.ZERO) != 0) {
                needAdjDiff.set("stdprice", (Object)stdPrice);
                needAdjDiff.set("price", (Object)stdPrice.divide(qty, this.standCostCalcParam.getPriceprecision(), 4));
            }
        }
        dynamicObjects.add(resultObj);
        if (!this.standCostCalcParam.isTrackCalc().booleanValue() && dynamicObjects.size() > this.getWriteToDBBatch()) {
            this.dealResult(dynamicObjects);
            dynamicObjects.clear();
        }
        int count = node.getSubElementList().size();
        for (CalculationNode node1 : node.getSubNodes()) {
            count += this.writeNode2Db(node1, dynamicObjects, isSaveLeaf);
        }
        return count;
    }

    private Map<String, DynamicObject> getCalcRecord(List<DynamicObject> dyos, CalcStandCostCalcParam standCostCalcParam) {
        Object[] oldCalcRecords;
        HashMap<String, DynamicObject> calcRecordDyoMap = new HashMap<String, DynamicObject>(16);
        if (CadEmptyUtils.isEmpty(dyos)) {
            return calcRecordDyoMap;
        }
        HashSet<String> keycols = new HashSet<String>(200);
        dyos.forEach(p -> keycols.add(p.getString("keycol")));
        QFilter filter = new QFilter("costtype", "=", (Object)standCostCalcParam.getCostTypeId());
        QFilter kcFilter = new QFilter("keycol", "in", keycols);
        DataSet calcRecordDataSet = QueryServiceHelper.queryDataSet((String)"getCalcRecord", (String)"cad_stdcalcrecord", (String)"keycol,name", (QFilter[])new QFilter[]{filter, kcFilter}, null).distinct();
        calcRecordDataSet = calcRecordDataSet.groupBy(new String[]{"keycol"}).countDistinct(new String[]{"name"}, "count").finish();
        calcRecordDataSet = calcRecordDataSet.filter("count >= " + standCostCalcParam.getRecordCount() + "");
        keycols.clear();
        while (calcRecordDataSet.hasNext()) {
            Row row = calcRecordDataSet.next();
            keycols.add(row.getString("keycol"));
        }
        HashMap<String, Object> keyColRecordMap = new HashMap<String, Object>(16);
        if (standCostCalcParam.isAutoReplaceRecord().booleanValue() && !CadEmptyUtils.isEmpty(keycols) && !CadEmptyUtils.isEmpty(oldCalcRecords = BusinessDataServiceHelper.load((String)"cad_stdcalcrecord", (String)"id,number,name,costtype,createtime,creator,material,keycol", (QFilter[])new QFilter[]{filter, kcFilter = new QFilter("keycol", "in", keycols)}, (String)"createtime asc"))) {
            for (Object oldCalcRecord : oldCalcRecords) {
                String key = oldCalcRecord.getString("keycol");
                keyColRecordMap.putIfAbsent(key, oldCalcRecord);
            }
        }
        ArrayList<Long> recordIds = new ArrayList<Long>(10);
        for (Map.Entry entry : keyColRecordMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            long id = value.getLong("id");
            recordIds.add(id);
        }
        for (DynamicObject dyo : dyos) {
            String key = dyo.getString("keycol");
            DynamicObject dynamicObject = (DynamicObject)calcRecordDyoMap.get(key);
            if (dynamicObject != null) continue;
            DynamicObject record = StdCalculateHelper.generateStdCalcRecord(dyo, standCostCalcParam.getCostTypeId(), standCostCalcParam.getRecordName(), standCostCalcParam.getCalcDate());
            calcRecordDyoMap.put(key, record);
        }
        if (!CadEmptyUtils.isEmpty(recordIds)) {
            QFilter idFilter = new QFilter("id", "in", recordIds);
            QFilter reckFilter = new QFilter("calcrecord", "in", recordIds);
            DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{reckFilter});
            DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{idFilter});
        }
        return calcRecordDyoMap;
    }

    private void writeToCollector(CalculationTree tree, Collector collector) {
        if (this.partBomInTrees != null && this.partBomInTrees.containsKey(tree.getRoot().getBomTreeRootId())) {
            int count = 0;
            for (long treeRootId : this.partBomInTrees.get(tree.getRoot().getBomTreeRootId())) {
                count += this.writeNodeToCollector(tree.getRoot(), treeRootId, collector);
            }
            this.write2Log(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u5230Colletor,\u590d\u5236\u5230%1$s\u9897\u6811\uff0c\u8bb0\u5f55\u6570%2$s", (String)"StandCostCalculationFunction_10", (String)"macc-cad-algox", (Object[])new Object[0]), this.partBomInTrees.size(), count), new Boolean[0]);
        }
    }

    private int writeNodeToCollector(CalculationNode node, long treeRootId, Collector collector) {
        node.setBomTreeRootId(treeRootId);
        node.setNodeType(20);
        this.write2DebugLog(node.toDebugLog());
        int count = 0;
        for (RowX rowX : node.toRowX()) {
            collector.collect(rowX);
            ++count;
        }
        for (CalculationNode subNode : node.getSubNodes()) {
            count += this.writeNodeToCollector(subNode, treeRootId, collector);
        }
        return count;
    }

    private void write2Log(String desc, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("BOM\u5c55\u5f00:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfo(ResManager.loadKDString((String)"BOM\u5c55\u5f00", (String)"StandCostCalculationFunction_7", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    private void write2LogNew(String desc, long startTime, long endTime, Boolean ... isWriteToDb) {
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.FALSE)) {
            logger.info(String.format("\u5377\u7b97\uff08BOM\u6811\uff09:%s", desc));
        }
        if (isWriteToDb.length == 1 && isWriteToDb[0].equals(Boolean.TRUE) && this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeInfoNew(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"StandCostCalculationFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]), desc, startTime, endTime);
        }
    }

    private void write2DebugLog(String desc) {
        if (this.standCostCalcParam != null && this.standCostCalcParam.getBizLogger() != null) {
            this.standCostCalcParam.getBizLogger().writeDebug(ResManager.loadKDString((String)"\u5377\u7b97\uff08BOM\u6811\uff09", (String)"StandCostCalculationFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]), desc);
        }
    }

    private Map<String, List<DynamicObject>> getExistKeyColDyoMap(List<Map<String, List<DynamicObject>>> keyColDyoMapList, String key) {
        if (CadEmptyUtils.isEmpty(keyColDyoMapList)) {
            return null;
        }
        for (Map<String, List<DynamicObject>> map : keyColDyoMapList) {
            if (!map.containsKey(key)) continue;
            return map;
        }
        return null;
    }

    private Map<String, List<DynamicObject>> getCurKeyColDyoMap(List<Map<String, List<DynamicObject>>> keyColDyoMapList, int size) {
        if (CadEmptyUtils.isEmpty(keyColDyoMapList)) {
            return new HashMap<String, List<DynamicObject>>(200);
        }
        for (Map<String, List<DynamicObject>> map : keyColDyoMapList) {
            if (map.size() >= size) continue;
            return map;
        }
        return new HashMap<String, List<DynamicObject>>(200);
    }

    public static enum OutputType {
        ToCollector,
        ToDB;

    }
}

