/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.alloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.helper.CadDebugHelper;
import kd.macc.cad.algox.mfgfee.helper.DebugInfoMsgHandler;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocReportHelper;
import kd.macc.cad.algox.mfgfee.pojo.AssistAllocParaEntry;
import kd.macc.cad.algox.utils.CadDataSetXLogUtil;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import net.sf.json.JSONObject;

public class AssitProdAlloc {
    private static final Log logger = LogFactory.getLog(AssitProdAlloc.class);
    private static final String insert_assistProdSubentry_sql = "INSERT INTO t_cad_auxpcomsubentry (FEntryId,FDetailId,FSeq,fsubcostcenterid,fsubexpenseitemid,fsubcostdriverid,fsubbaseunit,fsubqty,fsubinqty,fsuboutqty,fsubamt,fsubinamt,fsuboutamt) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String insert_plassistProdSubentry_sql = "INSERT INTO t_cad_plauxpcomsubentry (FEntryId,FDetailId,FSeq,fsubcostcenterid,fsubexpenseitemid,fsubcostdriverid,fsubbaseunit,fsubqty,fsubinqty,fsuboutqty,fsubamt,fsubinamt,fsuboutamt) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String update_assistProdEntry_sql = "update t_cad_auxpcomentry set fcostdriverqty=?,factualrate=?,factualinrate=?,factualoutrate=?,fallocsum=? where fentryId=?";
    private static final String update_plassistProdEntry_sql = "update t_cad_plauxpcomentry set fcostdriverqty=?,factualrate=?,factualinrate=?,factualoutrate=?,fallocsum=? where fentryId=?";
    private static final String insert_assistProdParSubentry_sql = "INSERT INTO t_cad_auxpparsubentry (FEntryId,FDetailId,FSeq,fparsubcostcenterid,fparsubexpenseitemid,fparsubcostdriverid,fparsubbaseunit,fparsubqty,fparsubinqty,fparsuboutqty,fparsubamt,fparsubinamt,fparsuboutamt,fcomsubentryid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String insert_plassistProdParSubentry_sql = "INSERT INTO t_cad_plauxpparsubentry (FEntryId,FDetailId,FSeq,fparsubcostcenterid,fparsubexpenseitemid,fparsubcostdriverid,fparsubbaseunit,fparsubqty,fparsubinqty,fparsuboutqty,fparsubamt,fparsubinamt,fparsuboutamt,fcomsubentryid) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String update_assistProdParEntry_sql = "update t_cad_auxpparentry set fparcostdriverqty=?,fparactualrate=?,fparactualinrate=?,fparactualoutrate=?,fparallocsum=? where fentryId=?";
    private static final String update_plassistProdParEntry_sql = "update t_cad_plauxpparentry set fparcostdriverqty=?,fparactualrate=?,fparactualinrate=?,fparactualoutrate=?,fparallocsum=? where fentryId=?";
    private List<Object[]> entrys = new ArrayList<Object[]>();
    private List<Object[]> subentrys = new ArrayList<Object[]>();
    private List<Object[]> parentrys = new ArrayList<Object[]>();
    private List<Object[]> parsubentrys = new ArrayList<Object[]>();
    private int amtprecision = 10;
    private Date startDate;
    private String complexDiyNestTips;
    private Long allocUser;
    private Set<Long> idSet = new HashSet<Long>(128);
    private Set<Long> entryIdSet = new HashSet<Long>(128);
    private Set<Long> parEntryIdSet = new HashSet<Long>(128);
    private Map<Long, List<AssistAllocParaEntry>> comToParaMap = new HashMap<Long, List<AssistAllocParaEntry>>(128);

    public String doAssitProdAlloc(List<Long> ids, String appNum, boolean planData, Long planschemeId) {
        String result;
        String entityType = planData ? "cad_planauxprodalloc" : "cad_auxprodalloc";
        if (CadEmptyUtils.isEmpty(ids)) {
            return AllocResultEnum.Failure.getResult();
        }
        long start = System.currentTimeMillis();
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityType, (String)"id,org,manuorg,costaccount,period,currency.amtprecision amtprecision,allocmethod,publicaux", (QFilter[])idfilter.toArray());
        long orgId = ((DynamicObject)bills.get(0)).getLong("org");
        boolean enableMulFactory = MfgfeeAllocHelper.isEnableMulFactory(orgId);
        this.amtprecision = ((DynamicObject)bills.get(0)).getInt("amtprecision");
        this.allocUser = RequestContext.get().getCurrUserId();
        this.startDate = new Date();
        HashMap<Long, List> manuorgAndBillMap = new HashMap<Long, List>(8);
        for (DynamicObject bill : bills) {
            manuorgAndBillMap.computeIfAbsent(bill.getLong("manuorg"), s -> new ArrayList()).add(bill.getLong("id"));
        }
        String reportParamStr = this.buildReportParamStr(ids, entityType);
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        Long reportId = MfgfeeAllocReportHelper.initAllocReport(reportParamStr, appNum, planschemeId);
        DataSet stdAndValue = this.getStdAndValue(reportParamStr, enableMulFactory, appNum, reportId, planData, planschemeId);
        try {
            if (enableMulFactory) {
                for (List value : manuorgAndBillMap.values()) {
                    this.allocMethod(value, reportParamStr, reportId, stdAndValue.copy(), planData);
                }
            } else {
                this.allocMethod(ids, reportParamStr, reportId, stdAndValue, planData);
            }
        }
        catch (Exception e) {
            logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"AssitProdAlloc_0", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AssitProdAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            return MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
        }
        logger.info(String.format("\u3010\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5206\u914d\u5e76\u6784\u9020sql\u751f\u6210\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        if (this.subentrys.size() == 0 && this.entrys.size() == 0 && this.parsubentrys.size() == 0 && this.parentrys.size() == 0) {
            return AllocResultEnum.Failure.getResult();
        }
        try {
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d:\u5f00\u59cb\u6267\u884c\u65e5\u5fd7\u63d2\u5165,\u5171" + this.entrys.size() + "\u6761");
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plauxpcomsubentry where fentryid in " + MfgfeeAllocHelper.setToSql(this.entryIdSet)));
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_auxpcomsubentry where fentryid in " + MfgfeeAllocHelper.setToSql(this.entryIdSet)));
            }
            if (this.subentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plassistProdSubentry_sql, this.subentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_assistProdSubentry_sql, this.subentrys);
                }
            }
            if (this.entrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_plassistProdEntry_sql, this.entrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_assistProdEntry_sql, this.entrys);
                }
            }
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plauxpparsubentry where fentryid in " + MfgfeeAllocHelper.setToSql(this.parEntryIdSet)));
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_auxpparsubentry where fentryid in " + MfgfeeAllocHelper.setToSql(this.parEntryIdSet)));
            }
            if (this.parsubentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plassistProdParSubentry_sql, this.parsubentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_assistProdParSubentry_sql, this.parsubentrys);
                }
            }
            if (this.parentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_plassistProdParEntry_sql, this.parentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_assistProdParEntry_sql, this.parentrys);
                }
            }
            Object[] date = new Object[]{this.allocUser, this.startDate};
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_planauxprodalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_auxprodalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            }
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d:\u7ed3\u675f\u65e5\u5fd7\u63d2\u5165");
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "1");
        }
        catch (Exception e) {
            logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u6267\u884csql\u5931\u8d25", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"AssitProdAlloc_0", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AssitProdAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
        }
        logger.info(String.format("\u3010\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u6267\u884csql\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        return result;
    }

    private void allocMethod(List<Long> ids, String reportParamStr, Long reportId, DataSet stdAndValue, boolean planData) {
        String algoKey = "kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc allocMethod()";
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        String allocmethod = reportParamJs.getString("allocmethod");
        boolean publicaux = reportParamJs.getBoolean("publicaux");
        QFilter idfilter = new QFilter("id", "in", ids);
        DataSet assistProdBill = this.getAssistProAllocData(idfilter, stdAndValue, reportParamStr, reportId);
        if (assistProdBill == null || assistProdBill.isEmpty()) {
            MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            return;
        }
        this.buildCompAndParaMap(algoKey, idfilter, planData);
        if (publicaux || "direct".equals(allocmethod)) {
            this.doPublicOrDirectAlloc(publicaux, assistProdBill);
        }
        if (!publicaux && "algebra".equals(allocmethod)) {
            this.doAlgebraAlloc(assistProdBill);
        }
        if (!publicaux && "mutual".equals(allocmethod)) {
            this.doMutualAlloc(assistProdBill);
        }
        for (Object[] comp : this.entrys) {
            List<AssistAllocParaEntry> assistAllocParaEntries = this.comToParaMap.get((Long)comp[5]);
            if (CadEmptyUtils.isEmpty(assistAllocParaEntries)) continue;
            int count = 0;
            BigDecimal totalAllocRatio = BigDecimal.ZERO;
            BigDecimal totalAllocRatioToIn = BigDecimal.ZERO;
            BigDecimal totalAllocRatioToOut = BigDecimal.ZERO;
            BigDecimal totalAllocAmt = BigDecimal.ZERO;
            for (AssistAllocParaEntry assistAllocParaEntry : assistAllocParaEntries) {
                Object[] parentry;
                BigDecimal allocAmt;
                BigDecimal allocRatio;
                Long parEntryId = assistAllocParaEntry.getEntryId();
                this.parEntryIdSet.add(parEntryId);
                BigDecimal ratio = assistAllocParaEntry.getRatio();
                if (count == assistAllocParaEntries.size() - 1) {
                    allocRatio = ((BigDecimal)comp[1]).subtract(totalAllocRatio);
                    BigDecimal allocRatioToIn = ((BigDecimal)comp[2]).subtract(totalAllocRatioToIn);
                    BigDecimal allocRatioToOut = ((BigDecimal)comp[3]).subtract(totalAllocRatioToOut);
                    allocAmt = ((BigDecimal)comp[4]).subtract(totalAllocAmt);
                    parentry = new Object[]{comp[0], allocRatio, allocRatioToIn, allocRatioToOut, allocAmt, parEntryId};
                    this.parentrys.add(parentry);
                    continue;
                }
                ++count;
                allocRatio = ((BigDecimal)comp[1]).multiply(ratio).setScale(10, 4);
                BigDecimal allocRatioIn = ((BigDecimal)comp[2]).multiply(ratio).setScale(10, 4);
                BigDecimal allocRatioOut = ((BigDecimal)comp[3]).multiply(ratio).setScale(10, 4);
                allocAmt = ((BigDecimal)comp[4]).multiply(ratio).setScale(this.amtprecision, 4);
                totalAllocRatio = totalAllocRatio.add(allocRatio);
                totalAllocRatioToIn = totalAllocRatioToIn.add(allocRatioIn);
                totalAllocRatioToOut = totalAllocRatioToOut.add(allocRatioOut);
                totalAllocAmt = totalAllocAmt.add(allocAmt);
                parentry = new Object[]{comp[0], allocRatio, allocRatioIn, allocRatioOut, allocAmt, parEntryId};
                this.parentrys.add(parentry);
            }
        }
    }

    private String buildReportParamStr(List<Long> ids, String entityType) {
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)entityType, (String)"org,costaccount,manuorg,period,currency,currency.amtprecision amtprecision,allocmethod,publicaux", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long manuorgId = onebill.getLong("manuorg");
        long periodId = onebill.getLong("period");
        long costAccountId = onebill.getLong("costaccount");
        long currencyId = onebill.getLong("currency");
        String allocmethod = onebill.getString("allocmethod");
        boolean publicaux = onebill.getBoolean("publicaux");
        JSONObject reportParamJs = new JSONObject();
        reportParamJs.put((Object)"entitytype", (Object)entityType);
        if ("cad_planauxprodalloc".equals(entityType)) {
            reportParamJs.put((Object)"taskname", (Object)"6");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('1'));
        } else {
            reportParamJs.put((Object)"taskname", (Object)"2");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('0'));
        }
        reportParamJs.put((Object)"org", (Object)orgId);
        reportParamJs.put((Object)"manuorg", (Object)manuorgId);
        reportParamJs.put((Object)"costaccount", (Object)costAccountId);
        reportParamJs.put((Object)"period", (Object)periodId);
        reportParamJs.put((Object)"currency", (Object)currencyId);
        reportParamJs.put((Object)"starttime", (Object)this.startDate.getTime());
        reportParamJs.put((Object)"status", (Object)"4");
        reportParamJs.put((Object)"executor", (Object)this.allocUser);
        reportParamJs.put((Object)"allocmethod", (Object)allocmethod);
        reportParamJs.put((Object)"publicaux", (Object)publicaux);
        reportParamJs.put((Object)"detailInfo", (Object)"");
        return reportParamJs.toString();
    }

    private void buildCompAndParaMap(String algoKey, QFilter idfilter, boolean plandata) {
        String entityType = "cad_auxprodalloc";
        if (plandata) {
            entityType = "cad_planauxprodalloc";
        }
        DataSet assitProdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityType, (String)"id,comentity.id as entryid,comentity.expenseitem as expenseitem,comentity.allocamount as allocamount,parallelentity.id as parentryid,parallelentity.seq as seq,parallelentity.parexpenseitem as parexpenseitem,parallelentity.parallocamount parallocamount", (QFilter[])idfilter.toArray(), (String)"comentity.id,parallelentity.parallocamount");
        for (Row row : assitProdDs) {
            BigDecimal ratio = AssitProdAlloc.divide(row.getBigDecimal("parallocamount"), row.getBigDecimal("allocamount"), 10, 4);
            AssistAllocParaEntry assistAllocParaEntry = new AssistAllocParaEntry();
            assistAllocParaEntry.setId(row.getLong("id"));
            assistAllocParaEntry.setEntryId(row.getLong("parentryid"));
            assistAllocParaEntry.setSeq(row.getInteger("seq"));
            assistAllocParaEntry.setParExpenseItem(row.getLong("parexpenseitem"));
            assistAllocParaEntry.setParAllocAmount(row.getBigDecimal("parallocamount"));
            assistAllocParaEntry.setParAllocSum(row.getBigDecimal("parallocamount"));
            assistAllocParaEntry.setRatio(ratio);
            this.comToParaMap.computeIfAbsent(row.getLong("entryid"), s -> new ArrayList()).add(assistAllocParaEntry);
        }
    }

    private DataSet getAssistProAllocData(QFilter idfilter, DataSet stdAndValue, String reportParamStr, Long reportId) {
        String algoKey = "kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc allocMethod()";
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        String entityType = reportParamJs.getString("entitytype");
        int reportSeq = 0;
        DataSet assistProdBill = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityType, (String)"id,manuorg,costcenter,costcenter.name costcentername,comentity.id entryid,comentity.expenseitem expenseitem,comentity.expenseitem.name as expenseitemname,comentity.expenseitem.number as expenseitemnumber,comentity.costdriver costdriver,comentity.baseunit as baseunit,comentity.allocamount as allocamount", (QFilter[])idfilter.toArray(), null);
        assistProdBill = assistProdBill.join(stdAndValue, JoinType.LEFT).on("costcenter", "costcenter").on("expenseitem", "expenseitem").on("costdriver", "costdriver").on("manuorg", "manuorg").select(assistProdBill.getRowMeta().getFieldNames(), new String[]{"benefcostcenter", "orgduty", "value"}).finish();
        DataSet benefcostcenter_is_null = assistProdBill.copy().filter("benefcostcenter is null");
        String fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"AssitProdAlloc_2", (String)"macc-cad-algox", (Object[])new Object[0]);
        String fcheckdetail = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"AssitProdAlloc_3", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
        reportParamJs.put((Object)"allocresult", (Object)"1");
        reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"AssitProdAlloc_4", (String)"macc-cad-algox", (Object[])new Object[0]));
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), benefcostcenter_is_null);
        fcheckitem = ResManager.loadKDString((String)"\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"AssitProdAlloc_5", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)this.complexDiyNestTips);
        if (StringUtils.isNotEmpty((CharSequence)this.complexDiyNestTips)) {
            reportParamJs.put((Object)"allocresult", (Object)"2");
        } else {
            reportParamJs.put((Object)"allocresult", (Object)"1");
        }
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
        assistProdBill = assistProdBill.filter("benefcostcenter is not null");
        if (assistProdBill.isEmpty()) {
            MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            return null;
        }
        DataSet totalnotprod = assistProdBill.copy().executeSql("select manuorg,costcenter,expenseitem,sum(value) totalvalue group by manuorg,costcenter,expenseitem");
        assistProdBill = assistProdBill.join(totalnotprod, JoinType.INNER).on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(assistProdBill.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
        DataSet totalValueEuqalsZero = assistProdBill.copy().filter("totalvalue=0");
        fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0", (String)"AssitProdAlloc_6", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
        reportParamJs.put((Object)"allocresult", (Object)"1");
        reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002\u5982\u4fee\u6539\u5206\u914d\u6807\u51c6\uff0c\u9700\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002", (String)"AssitProdAlloc_7", (String)"macc-cad-algox", (Object[])new Object[0]));
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), totalValueEuqalsZero);
        assistProdBill = assistProdBill.filter("totalvalue!=0 and value!=0");
        assistProdBill = assistProdBill.addField("allocamount*value/totalvalue", "allocamt");
        assistProdBill = assistProdBill.orderBy(new String[]{"id", "entryid", "value"});
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d===\u5206\u914d\u91d1\u989d\u6210\u529f,\u6570\u636edataset\u5904\u7406\u5b8c\u6210\u3002");
        return assistProdBill;
    }

    private DataSet getStdAndValue(String reportParamStr, boolean enableMulFactory, String appNum, Long reportId, boolean planData, Long planschemeId) {
        DataSet diyResult;
        String algoKey = "kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc doAssitProdAlloc()";
        DebugInfoMsgHandler msgHandler = new DebugInfoMsgHandler(reportId);
        String entityType = planData ? "cad_planauxprodalloc" : "cad_auxprodalloc";
        String debugString = CadDebugHelper.getDebugKeyword(entityType);
        String debugColName = "";
        String debugColVal = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)debugString)) {
                String[] ss = debugString.split("=");
                debugColName = ss[0];
                debugColVal = ss[1];
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        long orgId = reportParamJs.getLong("org");
        long periodId = reportParamJs.getLong("period");
        long costAccountId = reportParamJs.getLong("costaccount");
        String allocmethod = reportParamJs.getString("allocmethod");
        boolean publicaux = reportParamJs.getBoolean("publicaux");
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        mfgfeeAllocHelper.setSaveCalcReport(false);
        DataSet assitProdStd = mfgfeeAllocHelper.getAssitPrdStd(orgId, appNum);
        CadDataSetXLogUtil.logDataSet(assitProdStd, debugColName, debugColVal, ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u6807\u51c6", (String)"AssitProdAlloc_21", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        HashSet<Long> costDriverIds = new HashSet<Long>();
        for (Row row : assitProdStd.copy()) {
            costDriverIds.add(row.getLong("costdriver"));
        }
        DataSet stdValueNotDiy = mfgfeeAllocHelper.getStdValueNotDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId);
        CadDataSetXLogUtil.logDataSet(stdValueNotDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_19", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        DataSet stdValueDiy = mfgfeeAllocHelper.getStdValueDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId);
        stdValueDiy = stdValueDiy.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter,unit");
        stdValueDiy = stdValueDiy.select("costdriver,org,manuorg,costcenter,benefcostcenter,value,unit");
        CadDataSetXLogUtil.logDataSet(stdValueDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_20", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        this.complexDiyNestTips = "";
        try {
            DataSet complexNotDiyDs;
            DataSet complexDs = mfgfeeAllocHelper.getComplexValueDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), "COSTCENTER", enableMulFactory, planData, planschemeId);
            if (complexDs != null) {
                CadDataSetXLogUtil.logDataSet(complexDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_22", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                complexDs = complexDs.addField("0", "unit");
                stdValueDiy = DataSetUtils.union((DataSet)complexDs, (DataSet)stdValueDiy);
            }
            if ((complexNotDiyDs = mfgfeeAllocHelper.getComplexValueNotDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), enableMulFactory, planData, planschemeId)) != null) {
                CadDataSetXLogUtil.logDataSet(complexNotDiyDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_23", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                complexNotDiyDs = complexNotDiyDs.addField("0", "unit");
                stdValueNotDiy = DataSetUtils.union((DataSet)complexNotDiyDs, (DataSet)stdValueNotDiy);
            }
        }
        catch (Exception e) {
            logger.error("\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c", (Throwable)e);
            this.complexDiyNestTips = e.getMessage();
        }
        stdValueDiy = stdValueDiy.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter,unit");
        stdValueDiy = stdValueDiy.select("costdriver,org,manuorg,costcenter,benefcostcenter,value,unit");
        CadDataSetXLogUtil.logDataSet(stdValueDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_20", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        stdValueNotDiy = stdValueNotDiy.executeSql("select costdriver,org,manuorg,costcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,unit");
        stdValueNotDiy = stdValueNotDiy.select("costdriver,org,manuorg,costcenter,value,unit");
        CadDataSetXLogUtil.logDataSet(stdValueNotDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u672c\u52a8\u56e0", (String)"AssitProdAlloc_19", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        if (enableMulFactory) {
            stdValueNotDiy = assitProdStd.join(stdValueNotDiy, JoinType.LEFT).on("costdriver", "costdriver").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver"}, new String[]{"costcenter as benefcostcenter", "value", "unit"}).finish();
            diyResult = assitProdStd.join(stdValueDiy, JoinType.LEFT).on("costdriver", "costdriver").on("costcenter", "costcenter").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver"}, new String[]{"benefcostcenter", "value", "unit"}).finish();
        } else {
            stdValueNotDiy = assitProdStd.join(stdValueNotDiy, JoinType.LEFT).on("costdriver", "costdriver").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver"}, new String[]{"costcenter as benefcostcenter", "value", "unit"}).finish();
            diyResult = assitProdStd.join(stdValueDiy, JoinType.LEFT).on("costdriver", "costdriver").on("costcenter", "costcenter").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver"}, new String[]{"benefcostcenter", "value", "unit"}).finish();
        }
        DataSet stdAndValue = stdValueNotDiy.union(diyResult);
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        DataSet assitCostcenter = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_costcenter", (String)"id benefcostcenter,accountorg,orgduty", (QFilter[])accorgfilter.toArray(), null);
        stdAndValue = stdAndValue.join(assitCostcenter, JoinType.LEFT).on("benefcostcenter", "benefcostcenter").select(stdAndValue.getRowMeta().getFieldNames(), new String[]{"orgduty"}).finish();
        if (!publicaux && "direct".equals(allocmethod)) {
            stdAndValue = stdAndValue.filter("orgduty != 5");
        }
        CadDataSetXLogUtil.logDataSet(stdAndValue, debugColName, debugColVal, ResManager.loadKDString((String)"\u53c2\u4e0e\u5206\u914d\u6570\u636e", (String)"AssitProdAlloc_24", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        DataSet stdValueDiy_costcenter_is_null = stdValueDiy.filter("costcenter is null or costcenter =0");
        DataSet value_is_null = stdAndValue.filter("value is null").groupBy(stdAndValue.getRowMeta().getFieldNames()).finish();
        DataSet value_is_not_null = stdAndValue.filter("value is not null");
        HashSet<Long> allocCostcenters = new HashSet<Long>(16);
        for (Row row : value_is_not_null.copy()) {
            allocCostcenters.add(row.getLong("costcenter"));
        }
        value_is_null = value_is_null.filter("costcenter not in " + MfgfeeAllocHelper.setToSql(allocCostcenters));
        value_is_null = value_is_null.leftJoin(stdValueDiy_costcenter_is_null).on("costdriver", "costdriver").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "unit", "orgduty"}, new String[]{"benefcostcenter", "value"}).finish().select(value_is_not_null.getRowMeta().getFieldNames());
        return value_is_null.union(value_is_not_null).filter("value is not null");
    }

    private void doPublicOrDirectAlloc(boolean publicaux, DataSet assistProdBill) {
        long flagEntryId = -1L;
        ArrayList<Row> curList = new ArrayList<Row>(10);
        for (Row row : assistProdBill) {
            long entryid = row.getLong("entryid");
            if (flagEntryId == -1L) {
                flagEntryId = entryid;
                curList.add(row);
                continue;
            }
            if (flagEntryId == entryid) {
                curList.add(row);
                continue;
            }
            flagEntryId = entryid;
            this.dealCurList(curList, publicaux);
            curList.clear();
            curList.add(row);
        }
        this.dealCurList(curList, publicaux);
    }

    private void doMutualAlloc(DataSet assistProdBill) {
        int i;
        DataSet costcenters = assistProdBill.copy().groupBy(new String[]{"id", "costcenter"}).finish();
        ArrayList<Long> costcenterList = new ArrayList<Long>(10);
        HashMap<Long, Row> costCenterMap = new HashMap<Long, Row>(16);
        for (Row row : costcenters) {
            costcenterList.add(row.getLong("costcenter"));
        }
        HashMap<Long, Map<Long, BigDecimal>> billExpRatioMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        int size = costcenterList.size();
        BigDecimal[][] coef = new BigDecimal[size][size];
        BigDecimal[] amtArray = new BigDecimal[size];
        BigDecimal[] valueArray = new BigDecimal[size];
        Boolean[] isFillFlag = new Boolean[size];
        for (int i2 = 0; i2 < size; ++i2) {
            amtArray[i2] = BigDecimal.ZERO;
            valueArray[i2] = BigDecimal.ZERO;
            isFillFlag[i2] = false;
            for (int j = 0; j < size; ++j) {
                coef[i2][j] = BigDecimal.ZERO;
            }
        }
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d===\u4ea4\u4e92\u5206\u914d\u6cd5\u53c2\u6570\u5143\u6570" + size);
        for (Row row : assistProdBill.copy()) {
            Long costcenterId = row.getLong("costcenter");
            Long benefcostcenterId = row.getLong("benefcostcenter");
            costCenterMap.computeIfAbsent(costcenterId, k -> row);
            BigDecimal allocamount = row.getBigDecimal("allocamount");
            BigDecimal totalvalue = row.getBigDecimal("totalvalue");
            int x = costcenterList.indexOf(costcenterId);
            int y = costcenterList.indexOf(benefcostcenterId);
            if (x == -1) continue;
            if (!isFillFlag[x].booleanValue()) {
                amtArray[x] = allocamount;
                valueArray[x] = totalvalue;
                isFillFlag[x] = true;
            }
            if (y == -1) continue;
            coef[x][y] = row.getBigDecimal("value");
        }
        BigDecimal[] toIn = new BigDecimal[size];
        BigDecimal[] toOut = new BigDecimal[size];
        BigDecimal[] assistTotal = new BigDecimal[size];
        for (i = 0; i < size; ++i) {
            toIn[i] = AssitProdAlloc.divide(amtArray[i], valueArray[i], 10, 4);
        }
        for (i = 0; i < size; ++i) {
            BigDecimal toAdd = BigDecimal.ZERO;
            BigDecimal toSubtract = BigDecimal.ZERO;
            BigDecimal assistQty = BigDecimal.ZERO;
            HashMap expRatioMap = new HashMap(16);
            for (int j = 0; j < size; ++j) {
                assistQty = assistQty.add(coef[i][j]);
                if (j == i) continue;
                BigDecimal useOther = coef[j][i].multiply(toIn[j]).setScale(this.amtprecision, 4);
                if (useOther != null && useOther.compareTo(BigDecimal.ZERO) != 0) {
                    toAdd = toAdd.add(useOther);
                    expRatioMap.put(costcenterList.get(j), useOther);
                }
                toSubtract = toSubtract.add(coef[i][j].multiply(toIn[i]).setScale(this.amtprecision, 4));
            }
            expRatioMap.put(costcenterList.get(i), amtArray[i].subtract(toSubtract));
            billExpRatioMap.put((Long)costcenterList.get(i), expRatioMap);
            BigDecimal numerator = amtArray[i].add(toAdd).subtract(toSubtract);
            BigDecimal denominator = valueArray[i].subtract(assistQty);
            assistTotal[i] = numerator;
            if (denominator.compareTo(BigDecimal.ZERO) == 0) {
                toOut[i] = BigDecimal.ZERO;
                logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d===\u4ea4\u4e92\u5206\u914d,\u8ba1\u7b97\u5bf9\u5916\u5206\u914d\u8d39\u7387\u65f6\u5206\u6bcd\u4e3a0,costcenterId" + costcenterList.get(i));
                continue;
            }
            toOut[i] = AssitProdAlloc.divide(numerator, denominator, 10, 4);
        }
        StringBuilder coefBuilfer = new StringBuilder(ResManager.loadKDString((String)"\u4ea4\u4e92\u5206\u914d\u53c2\u6570\u4e8c\u7ef4\u6570\u7ec4\uff1a", (String)"AssitProdAlloc_8", (String)"macc-cad-algox", (Object[])new Object[0]));
        StringBuilder toInBuilfer = new StringBuilder(ResManager.loadKDString((String)"\u4ea4\u4e92\u5206\u914d\u5bf9\u5185\u8d39\u7387\uff1a", (String)"AssitProdAlloc_9", (String)"macc-cad-algox", (Object[])new Object[0]));
        StringBuilder toOutBuilfer = new StringBuilder(ResManager.loadKDString((String)"\u4ea4\u4e92\u5206\u914d\u5bf9\u5916\u8d39\u7387\uff1a", (String)"AssitProdAlloc_10", (String)"macc-cad-algox", (Object[])new Object[0]));
        for (int i3 = 0; i3 < size; ++i3) {
            coefBuilfer.append(ResManager.loadKDString((String)"\u7b2c", (String)"AssitProdAlloc_11", (String)"macc-cad-algox", (Object[])new Object[0])).append(i3).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"AssitProdAlloc_12", (String)"macc-cad-algox", (Object[])new Object[0]));
            for (int j = 0; j < size; ++j) {
                coefBuilfer.append(coef[i3][j]).append('\u3001');
            }
            coefBuilfer.append("\n");
            toInBuilfer.append(toIn[i3]).append('\u3001');
            toOutBuilfer.append(toOut[i3]).append('\u3001');
        }
        logger.info(coefBuilfer.toString());
        logger.info(toInBuilfer.toString());
        logger.info(toOutBuilfer.toString());
        long flagid = -1L;
        ArrayList<Row> algebraList = new ArrayList<Row>(10);
        for (Row row : assistProdBill) {
            long billid = row.getLong("id");
            if (flagid == -1L) {
                flagid = billid;
                algebraList.add(row);
                continue;
            }
            if (flagid == billid) {
                algebraList.add(row);
                continue;
            }
            flagid = billid;
            this.dealMutualList(algebraList, costcenterList, coef, toIn, toOut, assistTotal, costCenterMap, billExpRatioMap);
            algebraList.clear();
            algebraList.add(row);
        }
        this.dealMutualList(algebraList, costcenterList, coef, toIn, toOut, assistTotal, costCenterMap, billExpRatioMap);
    }

    private void doAlgebraAlloc(DataSet assistProdBill) {
        DataSet costcenters = assistProdBill.copy().groupBy(new String[]{"id", "costcenter"}).finish();
        ArrayList<Long> costcenterList = new ArrayList<Long>(10);
        for (Row row : costcenters) {
            costcenterList.add(row.getLong("costcenter"));
        }
        int size = costcenterList.size();
        BigDecimal[][] coef = new BigDecimal[size][size];
        BigDecimal[][] coef_copy = new BigDecimal[size][size];
        BigDecimal[] b = new BigDecimal[size];
        BigDecimal[] b_copy = new BigDecimal[size];
        Boolean[] isFillFlag = new Boolean[size];
        BigDecimal[] actAllocAmt = new BigDecimal[size];
        HashMap<Long, Row> costcenterInfoMap = new HashMap<Long, Row>(16);
        for (int i = 0; i < size; ++i) {
            b[i] = BigDecimal.ZERO;
            isFillFlag[i] = false;
            for (int j = 0; j < size; ++j) {
                coef[i][j] = BigDecimal.ZERO;
            }
        }
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d===\u4ee3\u6570\u5206\u914d\u6cd5\u65b9\u7a0b\u5143\u6570" + size);
        for (Row row : assistProdBill.copy()) {
            Long costcenterId = row.getLong("costcenter");
            Long benefcostcenterId = row.getLong("benefcostcenter");
            costcenterInfoMap.computeIfAbsent(costcenterId, v -> row);
            BigDecimal totalvalue = row.getBigDecimal("totalvalue");
            BigDecimal allocamount = row.getBigDecimal("allocamount");
            int x = costcenterList.indexOf(costcenterId);
            int y = costcenterList.indexOf(benefcostcenterId);
            if (x == -1) continue;
            if (!isFillFlag[x].booleanValue()) {
                coef[x][x] = totalvalue.negate();
                b[x] = allocamount.negate();
                isFillFlag[x] = true;
            }
            if (y == x) {
                coef[x][y] = coef[x][y].add(row.getBigDecimal("value"));
                continue;
            }
            if (y == -1) continue;
            coef[y][x] = row.getBigDecimal("value");
        }
        b_copy = Arrays.copyOf(b, size);
        for (int i = 0; i < size; ++i) {
            coef_copy[i] = Arrays.copyOf(coef[i], size);
        }
        BigDecimal[] resolve = this.resolve(coef_copy, b_copy);
        StringBuilder coefBuilfer = new StringBuilder(ResManager.loadKDString((String)"\u4ee3\u6570\u5206\u914d\u53c2\u6570\u4e8c\u7ef4\u6570\u7ec4\uff1a", (String)"AssitProdAlloc_13", (String)"macc-cad-algox", (Object[])new Object[0]));
        StringBuilder resloveBuilfer = new StringBuilder(ResManager.loadKDString((String)"\u4ee3\u6570\u5206\u914d\u8d39\u7387\u7ed3\u679c\uff1a", (String)"AssitProdAlloc_14", (String)"macc-cad-algox", (Object[])new Object[0]));
        for (int i = 0; i < size; ++i) {
            coefBuilfer.append(ResManager.loadKDString((String)"\u7b2c", (String)"AssitProdAlloc_11", (String)"macc-cad-algox", (Object[])new Object[0])).append(i).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"AssitProdAlloc_12", (String)"macc-cad-algox", (Object[])new Object[0]));
            for (int j = 0; j < size; ++j) {
                coefBuilfer.append(coef[i][j]).append('\u3001');
            }
            coefBuilfer.append("\n");
            resloveBuilfer.append(resolve[i]).append('\u3001');
        }
        logger.info(((Object)costcenterList).toString());
        logger.info(coefBuilfer.toString());
        logger.info(resloveBuilfer.toString());
        HashMap<Long, Map<Long, BigDecimal>> billExpenRatioMap = new HashMap<Long, Map<Long, BigDecimal>>(8);
        for (int i = 0; i < size; ++i) {
            BigDecimal collAmt;
            HashMap<Long, BigDecimal> expenRatioMap = new HashMap<Long, BigDecimal>(8);
            BigDecimal actAmt = collAmt = b[i].negate().setScale(this.amtprecision, 4);
            for (int j = 0; j < size; ++j) {
                if (j == i) continue;
                BigDecimal addAmt = coef[i][j].multiply(resolve[j]).setScale(this.amtprecision, 4);
                BigDecimal addRes = expenRatioMap.computeIfAbsent((Long)costcenterList.get(j), v -> BigDecimal.ZERO).add(addAmt);
                expenRatioMap.put((Long)costcenterList.get(j), addRes);
                actAmt = actAmt.add(addAmt);
                BigDecimal subAmt = coef[j][i].multiply(resolve[i]).setScale(this.amtprecision, 4);
                collAmt = collAmt.subtract(subAmt);
                actAmt = actAmt.subtract(subAmt);
            }
            expenRatioMap.put((Long)costcenterList.get(i), collAmt);
            billExpenRatioMap.put((Long)costcenterList.get(i), (Map<Long, BigDecimal>)expenRatioMap);
            actAllocAmt[i] = actAmt;
        }
        long flagid = -1L;
        Row maxRow = null;
        ArrayList<Row> algebraList = new ArrayList<Row>(10);
        for (Row row : assistProdBill) {
            long billid = row.getLong("id");
            if (flagid == -1L) {
                flagid = billid;
                if (row.getLong("orgduty") != 5L) {
                    maxRow = row;
                    continue;
                }
                algebraList.add(row);
                continue;
            }
            if (flagid == billid) {
                if (row.getLong("orgduty") != 5L) {
                    if (maxRow == null) {
                        maxRow = row;
                        continue;
                    }
                    if (row.getBigDecimal("value").compareTo(maxRow.getBigDecimal("value")) > 0) {
                        algebraList.add(maxRow);
                        maxRow = row;
                        continue;
                    }
                    algebraList.add(row);
                    continue;
                }
                algebraList.add(row);
                continue;
            }
            flagid = billid;
            if (maxRow != null) {
                algebraList.add(maxRow);
            }
            this.dealAlgebraList(algebraList, costcenterList, coef, resolve, actAllocAmt, costcenterInfoMap, billExpenRatioMap);
            algebraList.clear();
            if (row.getLong("orgduty") != 5L) {
                maxRow = row;
                continue;
            }
            maxRow = null;
            algebraList.add(row);
        }
        if (maxRow != null) {
            algebraList.add(maxRow);
        }
        this.dealAlgebraList(algebraList, costcenterList, coef, resolve, actAllocAmt, costcenterInfoMap, billExpenRatioMap);
    }

    private void dealCurList(List<Row> curList, Boolean publicaux) {
        if (CadEmptyUtils.isEmpty(curList)) {
            return;
        }
        int size = curList.size();
        BigDecimal allocSum = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> parEntrySumAmt = new HashMap<Long, BigDecimal>(128);
        int seq = 0;
        int parSeq = 0;
        for (Row row : curList) {
            if (seq == curList.size() - 1) {
                this.idSet.add(row.getLong("id"));
                this.entryIdSet.add(row.getLong("entryid"));
                BigDecimal totalamt = row.getBigDecimal("allocamount");
                BigDecimal lastamount = totalamt.subtract(allocSum);
                BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
                Object[] subentry = new Object[]{row.getLong("entryid"), MfgfeeAllocHelper.getId(), seq++, row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), value, BigDecimal.ZERO, BigDecimal.ZERO, lastamount, BigDecimal.ZERO, BigDecimal.ZERO};
                this.subentrys.add(subentry);
                this.buildParSubEntry(parSeq++, row, lastamount, subentry, true, parEntrySumAmt, true, row.getBigDecimal("allocamount"));
                BigDecimal totalValue = row.getBigDecimal("totalvalue").setScale(10, 4);
                BigDecimal ratio = publicaux != false ? BigDecimal.ZERO : AssitProdAlloc.divide(row.getBigDecimal("allocamount"), row.getBigDecimal("totalvalue"), 10, 4);
                Object[] entry = new Object[]{totalValue, ratio, BigDecimal.ZERO, BigDecimal.ZERO, totalamt, row.getLong("entryid")};
                this.entrys.add(entry);
                continue;
            }
            BigDecimal allocvalue = row.getBigDecimal("value").setScale(10, 4);
            BigDecimal allocamt = row.getBigDecimal("allocamt").setScale(this.amtprecision, 4);
            allocSum = allocSum.add(allocamt);
            Object[] subentry = new Object[]{row.getLong("entryid"), MfgfeeAllocHelper.getId(), seq++, row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), allocvalue, BigDecimal.ZERO, BigDecimal.ZERO, allocamt, BigDecimal.ZERO, BigDecimal.ZERO};
            this.subentrys.add(subentry);
            this.buildParSubEntry(parSeq++, row, allocamt, subentry, false, parEntrySumAmt, true, row.getBigDecimal("allocamount"));
        }
    }

    private void dealAlgebraList(List<Row> algebraList, List<Long> assistCenterList, BigDecimal[][] coef, BigDecimal[] resolve, BigDecimal[] actAllocAmt, Map<Long, Row> costcenterInfoMap, Map<Long, Map<Long, BigDecimal>> billExpenRatioMap) {
        if (CadEmptyUtils.isEmpty(algebraList)) {
            return;
        }
        int seq = 0;
        int parSeq = 0;
        Long entryid = algebraList.get(0).getLong("entryid");
        Long costcenter = algebraList.get(0).getLong("costcenter");
        int index = assistCenterList.indexOf(costcenter);
        this.idSet.add(algebraList.get(0).getLong("id"));
        this.entryIdSet.add(entryid);
        BigDecimal totalValue = algebraList.get(0).getBigDecimal("totalvalue").setScale(10, 4);
        Object[] entry = new Object[]{totalValue, resolve[index], BigDecimal.ZERO, BigDecimal.ZERO, actAllocAmt[index], entryid};
        this.entrys.add(entry);
        HashMap<String, BigDecimal> parEntrySumAmtIn = new HashMap<String, BigDecimal>(128);
        HashMap<String, BigDecimal> parEntrySumAmtOut = new HashMap<String, BigDecimal>(128);
        List<AssistAllocParaEntry> assistAllocParaEntries = this.comToParaMap.get(entryid);
        for (AssistAllocParaEntry assistAllocParaEntry : assistAllocParaEntries) {
            String sumAmtInMapKey = costcenter + "#" + assistAllocParaEntry.getParExpenseItem();
            parEntrySumAmtIn.put(sumAmtInMapKey, assistAllocParaEntry.getParAllocAmount());
        }
        Map<Long, BigDecimal> expenRatioMap = billExpenRatioMap.get(costcenter);
        HashMap<Long, BigDecimal> expenAllocAmt = new HashMap<Long, BigDecimal>(16);
        for (int i = 0; i < assistCenterList.size(); ++i) {
            if (i == index) continue;
            Row costcenterRow = costcenterInfoMap.get(assistCenterList.get(i));
            BigDecimal qty = coef[index][i].setScale(10, 4);
            if (qty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal subInAmt = expenRatioMap.get(assistCenterList.get(i));
            Object[] subentry = new SqlParameter[]{new SqlParameter("FEntryId", -5, (Object)entryid), new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fsubcostcenterid", -5, (Object)costcenter), new SqlParameter("fsubexpenseitemid", -5, (Object)costcenterRow.getLong("expenseitem")), new SqlParameter("fsubcostdriverid", -5, (Object)costcenterRow.getLong("costdriver")), new SqlParameter("fsubbaseunit", -5, (Object)costcenterRow.getLong("baseunit")), new SqlParameter("fsubqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinqty", 3, (Object)qty), new SqlParameter("fsuboutqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinamt", 3, (Object)subInAmt), new SqlParameter("fsuboutamt", 3, (Object)BigDecimal.ZERO)};
            this.subentrys.add(subentry);
            parSeq = this.buildAlgebraParSubEntry(parSeq, costcenterRow.getLong("entryid"), assistCenterList.get(i), subInAmt, true, subentry, false, parEntrySumAmtIn, parEntrySumAmtOut);
        }
        int tempCount = 0;
        for (Row row : algebraList) {
            Object[] subentry;
            Long targetEntryId;
            Long targetExpenseitem;
            Long costCenterKey;
            Long benefcostcenter = row.getLong("benefcostcenter");
            BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
            BigDecimal subamt = value.multiply(resolve[index]).setScale(this.amtprecision, 4);
            if (tempCount++ == algebraList.size() - 1) {
                if (assistCenterList.contains(benefcostcenter)) {
                    DynamicObject costcenterDO = BusinessDataServiceHelper.loadSingle((Object)costcenter, (String)"bos_costcenter", (String)"name");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6ca1\u6709\u53ef\u4ee5\u5206\u914d\u8d39\u7528\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"AssitProdAlloc_18", (String)"macc-cad-algox", (Object[])new Object[0]), costcenterDO.getString("name")));
                }
                for (Map.Entry<Long, BigDecimal> expenRatioEntry : expenRatioMap.entrySet()) {
                    costCenterKey = expenRatioEntry.getKey();
                    targetExpenseitem = costcenterInfoMap.get(costCenterKey).getLong("expenseitem");
                    targetEntryId = costcenterInfoMap.get(costCenterKey).getLong("entryid");
                    BigDecimal allocAmt = expenAllocAmt.computeIfAbsent(costCenterKey, v -> BigDecimal.ZERO);
                    BigDecimal adjustAmt = expenRatioEntry.getValue().subtract(allocAmt);
                    subentry = new SqlParameter[]{new SqlParameter("FEntryId", -5, (Object)row.getLong("entryid")), new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fsubcostcenterid", -5, (Object)benefcostcenter), new SqlParameter("fsubexpenseitemid", -5, (Object)targetExpenseitem), new SqlParameter("fsubcostdriverid", -5, (Object)row.getLong("costdriver")), new SqlParameter("fsubbaseunit", -5, (Object)row.getLong("baseunit")), new SqlParameter("fsubqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsuboutqty", 3, (Object)value), new SqlParameter("fsubamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsuboutamt", 3, (Object)adjustAmt)};
                    this.subentrys.add(subentry);
                    parSeq = this.buildAlgebraParSubEntry(parSeq, targetEntryId, costCenterKey, adjustAmt, false, subentry, true, parEntrySumAmtIn, parEntrySumAmtOut);
                }
                continue;
            }
            if (assistCenterList.contains(benefcostcenter)) {
                if (costcenter.equals(benefcostcenter)) {
                    subamt = BigDecimal.ZERO;
                }
                Object[] subentry2 = new SqlParameter[]{new SqlParameter("FEntryId", -5, (Object)row.getLong("entryid")), new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fsubcostcenterid", -5, (Object)benefcostcenter), new SqlParameter("fsubexpenseitemid", -5, (Object)row.getLong("expenseitem")), new SqlParameter("fsubcostdriverid", -5, (Object)row.getLong("costdriver")), new SqlParameter("fsubbaseunit", -5, (Object)row.getLong("baseunit")), new SqlParameter("fsubqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinqty", 3, (Object)value), new SqlParameter("fsuboutqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinamt", 3, (Object)subamt.negate()), new SqlParameter("fsuboutamt", 3, (Object)BigDecimal.ZERO)};
                this.subentrys.add(subentry2);
                parSeq = this.buildAlgebraParSubEntry(parSeq, entryid, costcenter, subamt.negate(), true, subentry2, false, parEntrySumAmtIn, parEntrySumAmtOut);
                continue;
            }
            for (Map.Entry<Long, BigDecimal> expenRatioEntry : expenRatioMap.entrySet()) {
                costCenterKey = expenRatioEntry.getKey();
                targetExpenseitem = costcenterInfoMap.get(costCenterKey).getLong("expenseitem");
                targetEntryId = costcenterInfoMap.get(costCenterKey).getLong("entryid");
                BigDecimal ratio = AssitProdAlloc.divide(expenRatioEntry.getValue(), actAllocAmt[index], 10, 4);
                BigDecimal actAmt = subamt.multiply(ratio).setScale(this.amtprecision, 4);
                subentry = new SqlParameter[]{new SqlParameter("FEntryId", -5, (Object)row.getLong("entryid")), new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fsubcostcenterid", -5, (Object)benefcostcenter), new SqlParameter("fsubexpenseitemid", -5, (Object)targetExpenseitem), new SqlParameter("fsubcostdriverid", -5, (Object)row.getLong("costdriver")), new SqlParameter("fsubbaseunit", -5, (Object)row.getLong("baseunit")), new SqlParameter("fsubqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinqty", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsuboutqty", 3, (Object)value), new SqlParameter("fsubamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsubinamt", 3, (Object)BigDecimal.ZERO), new SqlParameter("fsuboutamt", 3, (Object)actAmt)};
                this.subentrys.add(subentry);
                BigDecimal alllocAmt = expenAllocAmt.computeIfAbsent(costCenterKey, v -> BigDecimal.ZERO).add(actAmt);
                expenAllocAmt.put(costCenterKey, alllocAmt);
                parSeq = this.buildAlgebraParSubEntry(parSeq, targetEntryId, costCenterKey, actAmt, false, subentry, false, parEntrySumAmtIn, parEntrySumAmtOut);
            }
        }
    }

    private void dealMutualList(List<Row> algebraList, List<Long> assistCenterList, BigDecimal[][] coef, BigDecimal[] toIn, BigDecimal[] toOut, BigDecimal[] adjustTotal, Map<Long, Row> costCenterMap, Map<Long, Map<Long, BigDecimal>> billExpRatioMap) {
        Object[] subentry;
        if (CadEmptyUtils.isEmpty(algebraList)) {
            return;
        }
        BigDecimal totalAmt = algebraList.get(0).getBigDecimal("allocamount");
        BigDecimal totalAllocAmt = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> expenAllocAmt = new HashMap<Long, BigDecimal>(16);
        Row adjustRow = null;
        int seq = 1;
        int parSeq = 1;
        Long entryid = algebraList.get(0).getLong("entryid");
        Long costcenter = algebraList.get(0).getLong("costcenter");
        String expenseitem = algebraList.get(0).getString("expenseitem");
        this.idSet.add(algebraList.get(0).getLong("id"));
        this.entryIdSet.add(entryid);
        int index = assistCenterList.indexOf(costcenter);
        if (index == -1) {
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d+++ \u4ea4\u4e92\u5206\u914d\u751f\u6210\u5b50\u5206\u5f55\u9519\u8bef,costcenterId:" + costcenter);
            return;
        }
        Map<Long, BigDecimal> expRatioMap = billExpRatioMap.get(costcenter);
        HashMap<String, BigDecimal> parEntrySumAmtIn = new HashMap<String, BigDecimal>(128);
        HashMap<String, BigDecimal> parEntrySumAmtOut = new HashMap<String, BigDecimal>(128);
        List<AssistAllocParaEntry> assistAllocParaEntries = this.comToParaMap.get(entryid);
        for (AssistAllocParaEntry assistAllocParaEntry : assistAllocParaEntries) {
            String sumAmtInMapKey = costcenter + "#" + assistAllocParaEntry.getParExpenseItem();
            parEntrySumAmtIn.put(sumAmtInMapKey, assistAllocParaEntry.getParAllocAmount());
        }
        for (int i = 0; i < assistCenterList.size(); ++i) {
            if (i == index || coef[i][index].compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal bigDecimal = coef[i][index];
            BigDecimal subamt = bigDecimal.multiply(toIn[i]).setScale(this.amtprecision, 4);
            totalAmt = totalAmt.add(subamt);
            Long benefcosrcenterId = assistCenterList.get(i);
            Row row = costCenterMap.get(benefcosrcenterId);
            if (row == null) {
                logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d+++ \u4ea4\u4e92\u5206\u914d\u5904\u7406\u5176\u4ed6\u6210\u672c\u4e2d\u5fc3\u5b50\u5206\u5f55\u65f6,\u672a\u627e\u5230\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3Map\u4fe1\u606f");
                continue;
            }
            subentry = new Object[]{entryid, MfgfeeAllocHelper.getId(), seq++, costcenter, row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), BigDecimal.ZERO, bigDecimal, BigDecimal.ZERO, BigDecimal.ZERO, subamt, BigDecimal.ZERO};
            this.subentrys.add(subentry);
            parSeq = this.buildMutualParSubEntry(parSeq, row.getLong("entryid"), row.getLong("costcenter"), subamt, true, subentry, false, parEntrySumAmtIn, parEntrySumAmtOut);
        }
        for (Row row : algebraList) {
            BigDecimal curExpenAllocAmt;
            BigDecimal value;
            BigDecimal ratio;
            Long targetExpenitem;
            Long costcenterKey;
            Long benefcostcenter = row.getLong("benefcostcenter");
            if (assistCenterList.contains(benefcostcenter)) {
                Iterator<Map.Entry<Long, BigDecimal>> value2 = row.getBigDecimal("value").setScale(10, 4);
                BigDecimal subamt = ((BigDecimal)((Object)value2)).multiply(toIn[index]).setScale(this.amtprecision, 4);
                if (costcenter.equals(benefcostcenter)) {
                    subamt = BigDecimal.ZERO;
                }
                subamt = subamt.negate();
                totalAmt = totalAmt.add(subamt);
                subentry = new Object[]{entryid, MfgfeeAllocHelper.getId(), seq++, benefcostcenter, row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), BigDecimal.ZERO, value2, BigDecimal.ZERO, BigDecimal.ZERO, subamt, BigDecimal.ZERO};
                this.subentrys.add(subentry);
                parSeq = this.buildMutualParSubEntry(parSeq, entryid, costcenter, subamt, true, subentry, false, parEntrySumAmtIn, parEntrySumAmtOut);
                continue;
            }
            if (adjustRow == null) {
                adjustRow = row;
                continue;
            }
            if (adjustRow.getBigDecimal("value").compareTo(row.getBigDecimal("value")) < 0) {
                for (Map.Entry<Long, BigDecimal> expRatioEntry : expRatioMap.entrySet()) {
                    costcenterKey = expRatioEntry.getKey();
                    targetExpenitem = costCenterMap.get(costcenterKey).getLong("expenseitem");
                    ratio = AssitProdAlloc.divide(expRatioEntry.getValue(), adjustTotal[index], 10, 4);
                    value = adjustRow.getBigDecimal("value").setScale(10, 4);
                    BigDecimal subamt = value.multiply(toOut[index]).multiply(ratio).setScale(this.amtprecision, 4);
                    totalAllocAmt = totalAllocAmt.add(subamt);
                    curExpenAllocAmt = expenAllocAmt.computeIfAbsent(costcenterKey, s -> BigDecimal.ZERO);
                    curExpenAllocAmt = curExpenAllocAmt.add(subamt);
                    expenAllocAmt.put(costcenterKey, curExpenAllocAmt);
                    Object[] subentry2 = new Object[]{entryid, MfgfeeAllocHelper.getId(), seq++, adjustRow.getLong("benefcostcenter"), targetExpenitem, adjustRow.getLong("costdriver"), adjustRow.getLong("baseunit"), BigDecimal.ZERO, BigDecimal.ZERO, value, BigDecimal.ZERO, BigDecimal.ZERO, subamt};
                    this.subentrys.add(subentry2);
                    parSeq = this.buildMutualParSubEntry(parSeq, costCenterMap.get(costcenterKey).getLong("entryid"), costcenterKey, subamt, false, subentry2, false, parEntrySumAmtIn, parEntrySumAmtOut);
                }
                adjustRow = row;
                continue;
            }
            for (Map.Entry<Long, BigDecimal> expRatioEntry : expRatioMap.entrySet()) {
                costcenterKey = expRatioEntry.getKey();
                targetExpenitem = costCenterMap.get(costcenterKey).getLong("expenseitem");
                ratio = AssitProdAlloc.divide(expRatioEntry.getValue(), adjustTotal[index], 10, 4);
                value = row.getBigDecimal("value").setScale(10, 4);
                BigDecimal subAmtOut = value.multiply(toOut[index]).multiply(ratio).setScale(this.amtprecision, 4);
                totalAllocAmt = totalAllocAmt.add(subAmtOut);
                curExpenAllocAmt = expenAllocAmt.computeIfAbsent(costcenterKey, s -> BigDecimal.ZERO);
                curExpenAllocAmt = curExpenAllocAmt.add(subAmtOut);
                expenAllocAmt.put(costcenterKey, curExpenAllocAmt);
                Object[] subentry2 = new Object[]{entryid, MfgfeeAllocHelper.getId(), seq++, benefcostcenter, targetExpenitem, row.getLong("costdriver"), row.getLong("baseunit"), BigDecimal.ZERO, BigDecimal.ZERO, value, BigDecimal.ZERO, BigDecimal.ZERO, subAmtOut};
                this.subentrys.add(subentry2);
                parSeq = this.buildMutualParSubEntry(parSeq, costCenterMap.get(costcenterKey).getLong("entryid"), costcenterKey, subAmtOut, false, subentry2, false, parEntrySumAmtIn, parEntrySumAmtOut);
            }
        }
        if (adjustRow == null) {
            logger.info("\u6ca1\u6709\u975e\u8f85\u52a9\u7684\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3");
        } else {
            for (Map.Entry entry : expRatioMap.entrySet()) {
                Long costcenterKey = (Long)entry.getKey();
                Long targetExpenitem = costCenterMap.get(costcenterKey).getLong("expenseitem");
                BigDecimal value = adjustRow.getBigDecimal("value").setScale(10, 4);
                BigDecimal curExpenAllocAmt = expenAllocAmt.get(costcenterKey) == null ? BigDecimal.ZERO : (BigDecimal)expenAllocAmt.get(costcenterKey);
                BigDecimal subamt = ((BigDecimal)entry.getValue()).subtract(curExpenAllocAmt);
                totalAllocAmt = totalAllocAmt.add(subamt);
                Object[] subentry3 = new Object[]{entryid, MfgfeeAllocHelper.getId(), seq++, adjustRow.getLong("benefcostcenter"), costCenterMap.get(costcenterKey).getLong("expenseitem"), adjustRow.getLong("costdriver"), adjustRow.getLong("baseunit"), BigDecimal.ZERO, BigDecimal.ZERO, value, BigDecimal.ZERO, BigDecimal.ZERO, subamt};
                this.subentrys.add(subentry3);
                parSeq = this.buildMutualParSubEntry(parSeq, costCenterMap.get(costcenterKey).getLong("entryid"), costcenterKey, subamt, false, subentry3, true, parEntrySumAmtIn, parEntrySumAmtOut);
            }
        }
        BigDecimal totalvalue = algebraList.get(0).getBigDecimal("totalvalue").setScale(10, 4);
        Object[] objectArray = new Object[]{totalvalue, BigDecimal.ZERO, toIn[index], toOut[index], totalAmt, entryid};
        this.entrys.add(objectArray);
    }

    private void buildParSubEntry(int parSeq, Row row, BigDecimal allocAmt, Object[] subentry, Boolean isLastRow, Map<Long, BigDecimal> parEntrySumAmt, Boolean isDirect, BigDecimal totalAllocAmt) {
        List<AssistAllocParaEntry> parEntrys = this.comToParaMap.get(row.getLong("entryid"));
        if (CadEmptyUtils.isEmpty(parEntrys)) {
            return;
        }
        BigDecimal allocAmtSum = BigDecimal.ZERO;
        int count = 0;
        for (AssistAllocParaEntry parEntry : parEntrys) {
            Object[] parentry;
            BigDecimal parAllocAmt;
            Long parEntryId = parEntry.getEntryId();
            Long parExpen = parEntry.getParExpenseItem();
            BigDecimal parRatio = parEntry.getRatio();
            if (count == parEntrys.size() - 1) {
                parAllocAmt = allocAmt.subtract(allocAmtSum);
                parentry = new Object[subentry.length + 1];
                BigDecimal sumForAdjust = parEntrySumAmt.computeIfAbsent(parEntryId, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmt.put(parEntryId, sumForAdjust);
                System.arraycopy(subentry, 0, parentry, 0, subentry.length);
                parentry[0] = parEntryId;
                parentry[1] = MfgfeeAllocHelper.getId();
                parentry[2] = parSeq++;
                parentry[4] = parExpen;
                parentry[10] = parAllocAmt;
                parentry[13] = subentry[1];
                this.parsubentrys.add(parentry);
                continue;
            }
            ++count;
            parAllocAmt = allocAmt.multiply(parRatio).setScale(this.amtprecision, 4);
            if (isLastRow.booleanValue()) {
                BigDecimal parAllocAmtTotal;
                BigDecimal bigDecimal = parAllocAmtTotal = parEntrySumAmt.get(parEntryId) == null ? BigDecimal.ZERO : parEntrySumAmt.get(parEntryId);
                if (isDirect.booleanValue()) {
                    parAllocAmt = parEntry.getParAllocSum().subtract(parAllocAmtTotal);
                } else {
                    BigDecimal parEntryAmt = totalAllocAmt.multiply(parRatio).setScale(this.amtprecision, 4);
                    parAllocAmt = parEntryAmt.subtract(parAllocAmtTotal);
                }
            } else {
                BigDecimal sumForAdjust = parEntrySumAmt.computeIfAbsent(parEntryId, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmt.put(parEntryId, sumForAdjust);
            }
            allocAmtSum = allocAmtSum.add(parAllocAmt);
            parentry = new Object[subentry.length + 1];
            System.arraycopy(subentry, 0, parentry, 0, subentry.length);
            parentry[0] = parEntryId;
            parentry[1] = MfgfeeAllocHelper.getId();
            parentry[2] = parSeq++;
            parentry[4] = parExpen;
            parentry[10] = parAllocAmt;
            parentry[13] = subentry[1];
            this.parsubentrys.add(parentry);
        }
    }

    private int buildMutualParSubEntry(int parSeq, Long entryId, Long costcenterKey, BigDecimal allocAmt, Boolean isToInAmt, Object[] subentry, Boolean isLastRow, Map<String, BigDecimal> parEntrySumAmtIn, Map<String, BigDecimal> parEntrySumAmtOut) {
        List<AssistAllocParaEntry> parEntrys = this.comToParaMap.get(entryId);
        if (CadEmptyUtils.isEmpty(parEntrys)) {
            return parSeq;
        }
        long entryIdForParEntryId = (Long)subentry[0];
        String compExpen = String.valueOf(subentry[4]);
        List<AssistAllocParaEntry> parEntrysForParEntryId = this.comToParaMap.get(entryIdForParEntryId);
        BigDecimal allocAmtSum = BigDecimal.ZERO;
        int count = 0;
        int seqq = parEntrysForParEntryId.get(0).getSeq();
        Long smallParEntryId = parEntrysForParEntryId.get(0).getEntryId();
        for (AssistAllocParaEntry parEntry : parEntrysForParEntryId) {
            if (parEntry.getSeq() >= seqq) continue;
            seqq = parEntry.getSeq();
            smallParEntryId = parEntry.getEntryId();
        }
        for (AssistAllocParaEntry parEntry : parEntrys) {
            BigDecimal sumForAdjust;
            Object[] parentry;
            BigDecimal parAllocAmt;
            Long parEntryId = parEntry.getEntryId();
            Long parExpen = parEntry.getParExpenseItem();
            String parEntrySumAmtKey = costcenterKey + "#" + parExpen;
            BigDecimal parRatio = parEntry.getRatio();
            if (count == parEntrys.size() - 1) {
                BigDecimal sumForAdjust2;
                parAllocAmt = allocAmt.subtract(allocAmtSum);
                parentry = new Object[subentry.length + 1];
                if (isToInAmt.booleanValue()) {
                    sumForAdjust2 = parEntrySumAmtIn.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                    parEntrySumAmtIn.put(parEntrySumAmtKey, sumForAdjust2);
                } else {
                    sumForAdjust2 = parEntrySumAmtOut.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                    parEntrySumAmtOut.put(parEntrySumAmtKey, sumForAdjust2);
                }
                System.arraycopy(subentry, 0, parentry, 0, subentry.length);
                parentry[0] = smallParEntryId;
                parentry[1] = MfgfeeAllocHelper.getId();
                parentry[2] = parSeq++;
                parentry[4] = parExpen;
                parentry[11] = isToInAmt != false ? parAllocAmt : BigDecimal.ZERO;
                parentry[12] = isToInAmt != false ? BigDecimal.ZERO : parAllocAmt;
                parentry[13] = subentry[1];
                this.parsubentrys.add(parentry);
                continue;
            }
            ++count;
            parAllocAmt = allocAmt.multiply(parRatio).setScale(this.amtprecision, 4);
            if (isLastRow.booleanValue()) {
                BigDecimal totalAmtIn = parEntrySumAmtIn.get(parEntrySumAmtKey) == null ? BigDecimal.ZERO : parEntrySumAmtIn.get(parEntrySumAmtKey);
                BigDecimal allocAmtOut = parEntrySumAmtOut.get(parEntrySumAmtKey) == null ? BigDecimal.ZERO : parEntrySumAmtOut.get(parEntrySumAmtKey);
                parAllocAmt = totalAmtIn.subtract(allocAmtOut);
            }
            if (isToInAmt.booleanValue()) {
                sumForAdjust = parEntrySumAmtIn.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmtIn.put(parEntrySumAmtKey, sumForAdjust);
            } else {
                sumForAdjust = parEntrySumAmtOut.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmtOut.put(parEntrySumAmtKey, sumForAdjust);
            }
            allocAmtSum = allocAmtSum.add(parAllocAmt);
            parentry = new Object[subentry.length + 1];
            System.arraycopy(subentry, 0, parentry, 0, subentry.length);
            parentry[0] = smallParEntryId;
            parentry[1] = MfgfeeAllocHelper.getId();
            parentry[2] = parSeq++;
            parentry[4] = parExpen;
            parentry[11] = isToInAmt != false ? parAllocAmt : BigDecimal.ZERO;
            parentry[12] = isToInAmt != false ? BigDecimal.ZERO : parAllocAmt;
            parentry[13] = subentry[1];
            this.parsubentrys.add(parentry);
        }
        return parSeq;
    }

    private int buildAlgebraParSubEntry(int parSeq, Long entryId, Long costcenterKey, BigDecimal compAllocAmt, Boolean isToInAmt, Object[] subentry, Boolean isLastRow, Map<String, BigDecimal> parEntrySumAmtIn, Map<String, BigDecimal> parEntrySumAmtOut) {
        List<AssistAllocParaEntry> parEntrys = this.comToParaMap.get(entryId);
        if (CadEmptyUtils.isEmpty(parEntrys)) {
            return parSeq;
        }
        long entryIdForParEntryId = (Long)((SqlParameter)subentry[0]).getValue();
        List<AssistAllocParaEntry> parEntrysForParEntryId = this.comToParaMap.get(entryIdForParEntryId);
        BigDecimal allocAmtSum = BigDecimal.ZERO;
        int count = 0;
        int tempSeq = parEntrysForParEntryId.get(0).getSeq();
        Long smallParEntryId = parEntrysForParEntryId.get(0).getEntryId();
        for (AssistAllocParaEntry parEntry : parEntrysForParEntryId) {
            if (parEntry.getSeq() >= tempSeq) continue;
            tempSeq = parEntry.getSeq();
            smallParEntryId = parEntry.getEntryId();
        }
        for (AssistAllocParaEntry parEntry : parEntrys) {
            BigDecimal sumForAdjust;
            Object[] parentry;
            BigDecimal parAllocAmt;
            Long parExpen = parEntry.getParExpenseItem();
            String parEntrySumAmtKey = costcenterKey + "#" + parExpen;
            BigDecimal parRatio = parEntry.getRatio();
            if (count == parEntrys.size() - 1) {
                BigDecimal sumForAdjust2;
                parAllocAmt = compAllocAmt.subtract(allocAmtSum);
                parentry = new Object[subentry.length + 1];
                if (isToInAmt.booleanValue()) {
                    sumForAdjust2 = parEntrySumAmtIn.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                    parEntrySumAmtIn.put(parEntrySumAmtKey, sumForAdjust2);
                } else {
                    sumForAdjust2 = parEntrySumAmtOut.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                    parEntrySumAmtOut.put(parEntrySumAmtKey, sumForAdjust2);
                }
                System.arraycopy(subentry, 0, parentry, 0, subentry.length);
                parentry[0] = new SqlParameter("FEntryId", -5, (Object)smallParEntryId);
                parentry[1] = new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId());
                parentry[2] = new SqlParameter("FSeq", -5, (Object)parSeq++);
                parentry[4] = new SqlParameter("fsubexpenseitemid", -5, (Object)parExpen);
                parentry[11] = new SqlParameter("fsubinamt", 3, (Object)(isToInAmt != false ? parAllocAmt : BigDecimal.ZERO));
                parentry[12] = new SqlParameter("fsuboutamt", 3, (Object)(isToInAmt != false ? BigDecimal.ZERO : parAllocAmt));
                parentry[13] = new SqlParameter("fcomsubentryid", -5, ((SqlParameter)subentry[1]).getValue());
                this.parsubentrys.add(parentry);
                continue;
            }
            ++count;
            parAllocAmt = compAllocAmt.multiply(parRatio).setScale(this.amtprecision, 4);
            if (isLastRow.booleanValue()) {
                BigDecimal totalAmtIn = parEntrySumAmtIn.get(parEntrySumAmtKey) == null ? BigDecimal.ZERO : parEntrySumAmtIn.get(parEntrySumAmtKey);
                BigDecimal allocAmtOut = parEntrySumAmtOut.get(parEntrySumAmtKey) == null ? BigDecimal.ZERO : parEntrySumAmtOut.get(parEntrySumAmtKey);
                parAllocAmt = totalAmtIn.subtract(allocAmtOut);
            }
            if (isToInAmt.booleanValue()) {
                sumForAdjust = parEntrySumAmtIn.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmtIn.put(parEntrySumAmtKey, sumForAdjust);
            } else {
                sumForAdjust = parEntrySumAmtOut.computeIfAbsent(parEntrySumAmtKey, s -> BigDecimal.ZERO).add(parAllocAmt);
                parEntrySumAmtOut.put(parEntrySumAmtKey, sumForAdjust);
            }
            allocAmtSum = allocAmtSum.add(parAllocAmt);
            parentry = new Object[subentry.length + 1];
            System.arraycopy(subentry, 0, parentry, 0, subentry.length);
            parentry[0] = new SqlParameter("FEntryId", -5, (Object)smallParEntryId);
            parentry[1] = new SqlParameter("FDetailId", -5, (Object)MfgfeeAllocHelper.getId());
            parentry[2] = new SqlParameter("FSeq", -5, (Object)parSeq++);
            parentry[4] = new SqlParameter("fsubexpenseitemid", -5, (Object)parExpen);
            parentry[11] = new SqlParameter("fsubinamt", 3, (Object)(isToInAmt != false ? parAllocAmt : BigDecimal.ZERO));
            parentry[12] = new SqlParameter("fsuboutamt", 3, (Object)(isToInAmt != false ? BigDecimal.ZERO : parAllocAmt));
            parentry[13] = new SqlParameter("fcomsubentryid", -5, ((SqlParameter)subentry[1]).getValue());
            this.parsubentrys.add(parentry);
        }
        return parSeq;
    }

    private BigDecimal[] resolve(BigDecimal[][] coef, BigDecimal[] b) {
        int n = coef.length;
        int[] shift = new int[n];
        for (int i = 0; i < n; ++i) {
            shift[i] = i;
        }
        for (int rows = 0; rows < n; ++rows) {
            int i;
            BigDecimal rightLowMax = BigDecimal.ZERO;
            int pickedRow = 0;
            int pickedColumn = 0;
            for (i = rows; i < n; ++i) {
                for (int j = rows; j < n; ++j) {
                    if (rightLowMax.compareTo(coef[i][j].abs()) >= 0) continue;
                    rightLowMax = coef[i][j].abs();
                    pickedRow = i;
                    pickedColumn = j;
                }
            }
            if (pickedColumn != rows) {
                for (i = 0; i < n; ++i) {
                    AssitProdAlloc.swap(coef, i, rows, i, pickedColumn);
                }
                AssitProdAlloc.swap(shift, rows, pickedColumn);
            }
            if (pickedRow != rows) {
                for (int j = rows; j < n; ++j) {
                    AssitProdAlloc.swap(coef, rows, j, pickedRow, j);
                }
                AssitProdAlloc.swap(b, rows, pickedRow);
            }
            for (int subrows = 0; subrows < n; ++subrows) {
                if (subrows == rows) continue;
                if (BigDecimal.ZERO.compareTo(coef[rows][rows]) == 0) {
                    String errorStr = ResManager.loadKDString((String)"\u4e3b\u5143\u7cfb\u6570\u4e3a\u96f6,\u65b9\u7a0b\u7ec4\u65e0\u89e3\u3002", (String)"AssitProdAlloc_15", (String)"macc-cad-algox", (Object[])new Object[0]);
                    throw new KDBizException(errorStr);
                }
                BigDecimal m = AssitProdAlloc.divide(coef[subrows][rows], coef[rows][rows], 16, 4);
                for (int rowsRight = rows; rowsRight < n; ++rowsRight) {
                    coef[subrows][rowsRight] = coef[subrows][rowsRight].subtract(coef[rows][rowsRight].multiply(m));
                }
                b[subrows] = b[subrows].subtract(b[rows].multiply(m));
            }
        }
        BigDecimal[] x = new BigDecimal[n];
        for (int rows = 0; rows < n; ++rows) {
            for (int i = 0; i < n; ++i) {
                if (shift[i] != rows) continue;
                x[shift[i]] = BigDecimal.ZERO.compareTo(coef[i][i]) == 0 ? BigDecimal.ZERO : AssitProdAlloc.divide(b[i], coef[i][i], 16, 4);
            }
        }
        return x;
    }

    private static void swap(BigDecimal[] a, int x, int y) {
        BigDecimal tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    private static void swap(int[] a, int x, int y) {
        int tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    private static void swap(BigDecimal[][] a, int x1, int y1, int x2, int y2) {
        BigDecimal tmp = a[x1][y1];
        a[x1][y1] = a[x2][y2];
        a[x2][y2] = tmp;
    }

    private static BigDecimal divide(BigDecimal a, BigDecimal b, int scale, int roundModel) {
        if (BigDecimal.ZERO.equals(b)) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, roundModel);
    }
}

