/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.alloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc;
import kd.macc.cad.algox.mfgfee.helper.CadDebugHelper;
import kd.macc.cad.algox.mfgfee.helper.DebugInfoMsgHandler;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocReportHelper;
import kd.macc.cad.algox.utils.CadDataSetXLogUtil;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import net.sf.json.JSONObject;

public class BasicProdAlloc {
    private static final Log logger = LogFactory.getLog(AssitProdAlloc.class);
    private int amtprecision = 10;
    private Date startDate;
    private Long allocUser;
    private static final String update_basic_bill_sql = "update t_cad_basicalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in %s";
    private static final String update_plbasic_bill_sql = "update t_cad_planbasicalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in %s";
    private static final String insert_basic_entry_sql = "insert into t_cad_basicallocentry(fid,fseq,fentryid,fentrycostcenterid,fentryexpenseitemid,fentrycostdriverid,fentrybaseunitid,fentryqty,fentryamount) values(?,?,?,?,?,?,?,?,?)";
    private static final String insert_plbasic_entry_sql = "insert into t_cad_plbasicallocentry(fid,fseq,fentryid,fentrycostcenterid,fentryexpenseitemid,fentrycostdriverid,fentrybaseunitid,fentryqty,fentryamount) values(?,?,?,?,?,?,?,?,?)";
    private static final String insert_basic_comsubentry_sql = "insert into t_cad_basicpcomsubentry(fentryid,fseq,fdetailid,fsubcostcenterid,fcomsubexpenseitemid,fcomsubcostdriverid,fsubbaseunitid,fsubqty,fsubamt) values(?,?,?,?,?,?,?,?,?)";
    private static final String insert_plbasic_comsubentry_sql = "insert into t_cad_plbasicpcomsubentry(fentryid,fseq,fdetailid,fsubcostcenterid,fcomsubexpenseitemid,fcomsubcostdriverid,fsubbaseunitid,fsubqty,fsubamt) values(?,?,?,?,?,?,?,?,?)";
    private static final String update_basic_comentry_sql = "update t_cad_basicpcomentry set fcostdriverqty=?,fallocsum=? where fentryid=?";
    private static final String update_plbasic_comentry_sql = "update t_cad_plbasicpcomentry set fcostdriverqty=?,fallocsum=? where fentryid=?";
    private static final String insert_basic_parsubentry_sql = "insert into t_cad_basicpparsubentry(fentryid,fseq,fdetailid,fparsubcostcenterid,fparsubexpenseitemid,fparsubcostdriverid,fparsubbaseunitid,fparsubqty,fparsubamt) values(?,?,?,?,?,?,?,?,?)";
    private static final String insert_plbasic_parsubentry_sql = "insert into t_cad_plbasicpparsubentry(fentryid,fseq,fdetailid,fparsubcostcenterid,fparsubexpenseitemid,fparsubcostdriverid,fparsubbaseunitid,fparsubqty,fparsubamt) values(?,?,?,?,?,?,?,?,?)";
    private static final String update_basic_parentry_sql = "update t_cad_basicpparentry set fparcostdriverqty=?,fparallocsum=? where fentryid=?";
    private static final String update_plbasic_parentry_sql = "update t_cad_plbasicpparentry set fparcostdriverqty=?,fparallocsum=? where fentryid=?";
    private List<Object[]> billentrys = new ArrayList<Object[]>(10);
    private List<Object[]> comsubentrys = new ArrayList<Object[]>(10);
    private List<Object[]> comentrys = new ArrayList<Object[]>(10);
    private List<Object[]> parsubentrys = new ArrayList<Object[]>(10);
    private List<Object[]> parentrys = new ArrayList<Object[]>(10);
    private Map<Long, Long> parEntryIdAndParExpen = new HashMap<Long, Long>(256);
    private Set<Long> idSet = new HashSet<Long>(128);
    private Set<Long> comEntryIdSet = new HashSet<Long>(128);
    private Set<Long> parEntryIdSet = new HashSet<Long>(128);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doBasicAlloc(List<Long> ids, String appNum, boolean planData, Long planschemeId) {
        String result;
        String algoKey = "kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc doBasicAlloc()";
        String entityType = planData ? "cad_planbasicalloc" : "cad_basicalloc";
        String debugString = CadDebugHelper.getDebugKeyword(entityType);
        String debugColName = "";
        String debugColVal = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)debugString)) {
                String[] ss = debugString.split("=");
                debugColName = ss[0];
                debugColVal = ss[1];
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        long start = System.currentTimeMillis();
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)entityType, (String)"org,costaccount,period,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long costAccountId = onebill.getLong("costaccount");
        long periodId = onebill.getLong("period");
        boolean enableMulFactory = MfgfeeAllocHelper.isEnableMulFactory(orgId);
        this.amtprecision = onebill.getInt("amtprecision");
        this.allocUser = Long.parseLong(RequestContext.get().getUserId());
        this.startDate = new Date();
        int reportSeq = 0;
        String reportParamStr = this.buildReportParamStr(ids, entityType);
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        Long reportId = MfgfeeAllocReportHelper.initAllocReport(reportParamStr, appNum, planschemeId);
        DebugInfoMsgHandler msgHandler = new DebugInfoMsgHandler(reportId);
        try {
            DataSet resultData;
            ArrayList<QFilter> basicBillFilters = new ArrayList<QFilter>();
            basicBillFilters.add(idfilter);
            basicBillFilters.add(new QFilter("srcbilltype", "=", (Object)"A"));
            DataSet basicProdBill = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityType, (String)"id,manuorg,costcenter,costcenter.name as costcentername,srcbilltype,amount,expenseitem,expenseitem.name expenseitemname,expenseitem.number expenseitemnumber,costdriver,costdriver.name costdrivername", (QFilter[])basicBillFilters.toArray(new QFilter[0]), null);
            basicProdBill = basicProdBill.addNullField("entryid").addNullField("baseunit").select("id,manuorg,costcenter,costcentername,srcbilltype,entryid,expenseitem,expenseitemname,expenseitemnumber,amount allocamount,baseunit,'bill' as type");
            basicBillFilters.clear();
            basicBillFilters.add(idfilter);
            basicBillFilters.add(new QFilter("srcbilltype", "=", (Object)"B"));
            DataSet basicProdBillSrcAssitCom = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityType, (String)"id,manuorg,costcenter,costcenter.name as costcentername,srcbilltype,comentity.id entryid,comentity.comexpenseitem as expenseitem,comentity.comexpenseitem.name as expenseitemname,expenseitem.number expenseitemnumber,comentity.comcostdriver costdriver,comentity.comcostdriver.name costdrivername,comentity.allocamount allocamount,comentity.baseunit baseunit", (QFilter[])basicBillFilters.toArray(new QFilter[0]), null);
            basicProdBillSrcAssitCom = basicProdBillSrcAssitCom.select("id,manuorg,costcenter,costcentername,srcbilltype,entryid,expenseitem,expenseitemname,expenseitemnumber,allocamount,baseunit,'com' as type");
            DataSet basicProdBillSrcAssitPar = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityType, (String)"id,manuorg,costcenter,costcenter.name as costcentername,srcbilltype,parallelentity.id entryid,parallelentity.comparexpitem as expenseitem,parallelentity.parexpenseitem as parexpenseitem,parallelentity.comparexpitem.name as expenseitemname,parallelentity.comparexpitem.number as expenseitemnumber,parallelentity.parallocamount allocamount,parallelentity.parbaseunit baseunit", (QFilter[])basicBillFilters.toArray(new QFilter[0]), null);
            for (Row row : basicProdBillSrcAssitPar.copy()) {
                this.parEntryIdAndParExpen.put(row.getLong("entryid"), row.getLong("parexpenseitem"));
            }
            basicProdBillSrcAssitPar = basicProdBillSrcAssitPar.select("id,manuorg,costcenter,costcentername,srcbilltype,entryid,expenseitem,expenseitemname,expenseitemnumber,allocamount,baseunit,'par' as type");
            DataSet basicProdBillSrcAssit = basicProdBill.union(new DataSet[]{basicProdBillSrcAssitCom, basicProdBillSrcAssitPar});
            CadDataSetXLogUtil.logDataSet(basicProdBillSrcAssit, debugColName, debugColVal, ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355", (String)"BasicProdAlloc_12", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            basicProdBillSrcAssitCom.close();
            MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
            mfgfeeAllocHelper.setSaveCalcReport(false);
            DataSet mulStandOnCostCenter = mfgfeeAllocHelper.getMulStandOnCostCenter(orgId, periodId, appNum);
            String checkItem = ResManager.loadKDString((String)"\u540c\u4e00\u6210\u672c\u4e2d\u5fc3\u4e0b\u7ef4\u62a4\u4e86\u591a\u4e2a\u5206\u914d\u6807\u51c6", (String)"BasicProdAlloc_0", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)checkItem);
            reportParamJs.put((Object)"checkdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BasicProdAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]));
            if (!mulStandOnCostCenter.isEmpty()) {
                reportParamJs.put((Object)"allocresult", (Object)"2");
                MfgfeeAllocReportHelper.writeReportEntryForMulStand(reportId, reportParamJs.toString(), mulStandOnCostCenter);
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, AllocResultEnum.Failure.getResult());
                return AllocResultEnum.Failure.getResult();
            }
            reportParamJs.put((Object)"allocresult", (Object)"1");
            MfgfeeAllocReportHelper.writeReportEntryForMulStand(reportId, reportParamJs.toString(), null);
            DataSet baseProdStd = mfgfeeAllocHelper.getBaseProdStd(orgId, appNum, periodId);
            HashSet<Long> costDriverIds = new HashSet<Long>(16);
            for (Row row : baseProdStd.copy()) {
                costDriverIds.add(row.getLong("costdriver"));
            }
            CadDataSetXLogUtil.logDataSet(baseProdStd, debugColName, debugColVal, ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u6807\u51c6", (String)"BasicProdAlloc_13", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            boolean isNewAllocType = MfgfeeAllocHelper.isNewAllocType();
            DataSet stdValueNotDiy = mfgfeeAllocHelper.getStdValueNotDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId);
            DataSet stdValueDiy = isNewAllocType ? mfgfeeAllocHelper.getStdValueDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId) : mfgfeeAllocHelper.getStdValueDiy(orgId, costAccountId, periodId, appNum, null, planData, planschemeId);
            String complexDiyNestTips = "";
            try {
                DataSet complexNotDiyDs;
                DataSet complexDs = mfgfeeAllocHelper.getComplexValueDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), "COSTCENTER", enableMulFactory, planData, planschemeId);
                if (complexDs != null) {
                    CadDataSetXLogUtil.logDataSet(complexDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"BasicProdAlloc_16", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                    complexDs = complexDs.addField("0", "unit");
                    stdValueDiy = DataSetUtils.union((DataSet)complexDs, (DataSet)stdValueDiy);
                }
                if ((complexNotDiyDs = mfgfeeAllocHelper.getComplexValueNotDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), enableMulFactory, planData, planschemeId)) != null) {
                    CadDataSetXLogUtil.logDataSet(complexNotDiyDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"BasicProdAlloc_17", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                    complexNotDiyDs = complexNotDiyDs.addField("0", "unit");
                    stdValueNotDiy = DataSetUtils.union((DataSet)complexNotDiyDs, (DataSet)stdValueNotDiy);
                }
            }
            catch (Exception e) {
                logger.error("\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c", (Throwable)e);
                complexDiyNestTips = e.getMessage();
            }
            stdValueDiy = stdValueDiy.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter,unit");
            stdValueDiy = stdValueDiy.select("costdriver,org,manuorg,costcenter,benefcostcenter,value,unit");
            CadDataSetXLogUtil.logDataSet(stdValueDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0", (String)"BasicProdAlloc_15", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            stdValueNotDiy = stdValueNotDiy.executeSql("select costdriver,org,manuorg,costcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,unit");
            stdValueNotDiy = stdValueNotDiy.select("costdriver,org,manuorg,costcenter,value,unit");
            CadDataSetXLogUtil.logDataSet(stdValueNotDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u672c\u52a8\u56e0", (String)"BasicProdAlloc_14", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            stdValueNotDiy = baseProdStd.join(stdValueNotDiy, JoinType.LEFT).on("costdriver", "costdriver").on("benefcostcenter", "costcenter").select(new String[]{"manuorg", "costcenter", "execondition", "expenseitem", "costdriver", "unit"}, new String[]{"costcenter as benefcostcenter", "value"}).finish();
            DataSet diyResult = baseProdStd.join(stdValueDiy.copy(), JoinType.LEFT).on("costdriver", "costdriver").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"manuorg", "costcenter", "execondition", "expenseitem", "costdriver", "unit"}, new String[]{"benefcostcenter", "value"}).finish();
            DataSet stdAndValue = stdValueNotDiy.union(diyResult);
            DataSet stdValueDiy_costcenter_is_null = stdValueDiy.filter("costcenter is null or costcenter = 0");
            DataSet value_is_null = stdAndValue.filter("value is null").groupBy(new String[]{"manuorg", "costcenter", "execondition", "expenseitem", "costdriver", "benefcostcenter", "value"}).finish().addField("0L", "unit");
            DataSet value_is_not_null = stdAndValue.filter("value is not null");
            HashSet<Long> allocCostcenters = new HashSet<Long>(16);
            for (Row row : value_is_not_null.copy()) {
                allocCostcenters.add(row.getLong("costcenter"));
            }
            value_is_null = value_is_null.filter("costcenter not in " + MfgfeeAllocHelper.setToSql(allocCostcenters));
            value_is_null = value_is_null.leftJoin(stdValueDiy_costcenter_is_null).on("costdriver", "costdriver").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "execondition", "expenseitem", "costdriver", "unit"}, new String[]{"benefcostcenter", "value"}).finish().select(value_is_not_null.getRowMeta().getFieldNames());
            stdAndValue = value_is_not_null.union(value_is_null).filter("value is not null");
            stdValueDiy.close();
            stdValueNotDiy.close();
            HashSet<Long> hasInputCostCenterSet = new HashSet<Long>(128);
            DataSet hasIputCostCenter = mfgfeeAllocHelper.getHasInputCostenter(orgId, periodId, appNum);
            for (Row row : hasIputCostCenter) {
                hasInputCostCenterSet.add(row.getLong("costcenter"));
            }
            HashSet<Long> hasWipCompleteCenterSet = new HashSet<Long>(128);
            DataSet hasWipCompleteCenter = mfgfeeAllocHelper.getHasWipCompleteCenter(orgId, periodId, appNum);
            for (Row row : hasWipCompleteCenter) {
                hasWipCompleteCenterSet.add(row.getLong("costcenter"));
            }
            HashSet<Long> chooseNoInputCostCenterSet = new HashSet<Long>(16);
            DataSet chooseNoInputCostenter = mfgfeeAllocHelper.getChooseNoInputCostenter(orgId, periodId);
            for (Row row : chooseNoInputCostenter) {
                chooseNoInputCostCenterSet.add(row.getLong("costcenter"));
            }
            HashSet<Long> chooseNoComCostCenterSet = new HashSet<Long>(16);
            DataSet chooseNoComCostCenter = mfgfeeAllocHelper.chooseNoComCostCenterSet(orgId, periodId);
            for (Row row : chooseNoComCostCenter) {
                chooseNoComCostCenterSet.add(row.getLong("costcenter"));
            }
            DataSet noExeConditionDs = stdAndValue.filter("execondition == '' or execondition is null");
            DataSet hasExeConditionDs = stdAndValue.filter("(execondition =='NO_WORK' and costcenter not in" + MfgfeeAllocHelper.setToSql(hasInputCostCenterSet) + ")or (execondition =='NO_COM' and costcenter not in" + MfgfeeAllocHelper.setToSql(hasWipCompleteCenterSet) + ")");
            stdAndValue = noExeConditionDs.union(hasExeConditionDs);
            chooseNoInputCostCenterSet.removeAll(hasInputCostCenterSet);
            stdAndValue = stdAndValue.filter("benefcostcenter not in" + MfgfeeAllocHelper.setToSql(chooseNoInputCostCenterSet));
            chooseNoComCostCenterSet.removeAll(hasWipCompleteCenterSet);
            stdAndValue = stdAndValue.filter("benefcostcenter not in" + MfgfeeAllocHelper.setToSql(chooseNoComCostCenterSet));
            CadDataSetXLogUtil.logDataSet(stdAndValue, debugColName, debugColVal, ResManager.loadKDString((String)"\u53c2\u4e0e\u5206\u914d\u6570\u636e", (String)"BasicProdAlloc_18", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            basicProdBillSrcAssit = basicProdBillSrcAssit.join(stdAndValue.copy(), JoinType.LEFT).on("costcenter", "costcenter").on("expenseitem", "expenseitem").on("manuorg", "manuorg").select(basicProdBillSrcAssit.getRowMeta().getFieldNames(), new String[]{"unit", "costdriver", "benefcostcenter", "value"}).finish();
            DataSet benefcostcenter_is_null = basicProdBillSrcAssit.copy().filter("benefcostcenter is null");
            String fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"BasicProdAlloc_2", (String)"macc-cad-algox", (Object[])new Object[0]);
            String fcheckdetail = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BasicProdAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
            reportParamJs.put((Object)"allocresult", (Object)"1");
            reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"BasicProdAlloc_3", (String)"macc-cad-algox", (Object[])new Object[0]));
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), benefcostcenter_is_null);
            basicProdBillSrcAssit = basicProdBillSrcAssit.filter("value is not null");
            DataSet basicBillTotal = basicProdBillSrcAssit.executeSql("select id,entryid,sum(value) totalvalue group by id,entryid");
            basicProdBillSrcAssit = basicProdBillSrcAssit.join(basicBillTotal, JoinType.INNER).on("id", "id").on("entryid", "entryid").select(basicProdBillSrcAssit.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
            DataSet totalValueEuqalsZero = basicProdBillSrcAssit.copy().filter("totalvalue=0");
            fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002", (String)"BasicProdAlloc_4", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
            reportParamJs.put((Object)"allocresult", (Object)"1");
            reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002\u5982\u4fee\u6539\u5206\u914d\u6807\u51c6\uff0c\u9700\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002", (String)"BasicProdAlloc_5", (String)"macc-cad-algox", (Object[])new Object[0]));
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), totalValueEuqalsZero);
            basicProdBillSrcAssit = basicProdBillSrcAssit.filter("totalvalue!=0");
            basicProdBillSrcAssit = basicProdBillSrcAssit.select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,unit baseunit,benefcostcenter,value,totalvalue,allocamount*value/totalvalue as allocamt,concat('',cast(costcenter as String),'@',cast(benefcostcenter as String)) as path");
            if (basicProdBillSrcAssit.isEmpty()) {
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
                return AllocResultEnum.Failure.getResult();
            }
            ArrayList<DataSet> result2 = new ArrayList<DataSet>();
            DataSet firstCollect = basicProdBillSrcAssit.copy().filter("costcenter=benefcostcenter");
            basicProdBillSrcAssit = basicProdBillSrcAssit.filter("costcenter!=benefcostcenter");
            if (!(firstCollect = firstCollect.select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt")).isEmpty()) {
                result2.add(firstCollect);
            }
            fcheckitem = ResManager.loadKDString((String)"\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"BasicProdAlloc_6", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)complexDiyNestTips);
            if (StringUtils.isNotEmpty((CharSequence)complexDiyNestTips)) {
                reportParamJs.put((Object)"allocresult", (Object)"2");
            } else {
                reportParamJs.put((Object)"allocresult", (Object)"1");
            }
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            fcheckitem = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5b58\u5728\u5faa\u73af\u5206\u914d", (String)"BasicProdAlloc_7", (String)"macc-cad-algox", (Object[])new Object[0]);
            stdAndValue = stdAndValue.filter("value!=0");
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
            reportParamJs.put((Object)"allocresult", (Object)"1");
            reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u5b58\u5728\u5faa\u73af\u5206\u914d\u3002", (String)"BasicProdAlloc_8", (String)"macc-cad-algox", (Object[])new Object[0]));
            if (!this.allocRecurrence(basicProdBillSrcAssit, stdAndValue, result2, 1, reportId, reportParamJs.toString()).booleanValue()) {
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
                return AllocResultEnum.Failure.getResult();
            }
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            if (CadEmptyUtils.isEmpty(result2)) {
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
                return AllocResultEnum.Failure.getResult();
            }
            if (result2.size() == 1) {
                resultData = (DataSet)result2.get(0);
            } else {
                resultData = (DataSet)result2.get(0);
                result2.remove(0);
                resultData = resultData.union(result2.toArray(new DataSet[0]));
            }
            resultData = resultData.filter("value!=0");
            resultData = resultData.groupBy(new String[]{"id", "manuorg", "costcenter", "costcentername", "srcbilltype", "type", "entryid", "expenseitem", "expenseitemname", "expenseitemnumber", "costdriver", "allocamount", "baseunit", "benefcostcenter"}).sum("value").sum("allocamt").finish();
            DataSet resultDataTotal = resultData.executeSql("select id,entryid,sum(value) totalvalue group by id,entryid");
            resultData = resultData.join(resultDataTotal, JoinType.INNER).on("id", "id").on("entryid", "entryid").select(resultData.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
            resultData = resultData.orderBy(new String[]{"id", "entryid", "value"});
            DataSet srcbilltype_A = resultData.filter("type='bill'");
            DataSet srcbilltype_B = resultData.filter("type='com'");
            DataSet srcbilltype_C = resultData.filter("type='par'");
            this.createBillListTypeA(srcbilltype_A);
            this.createBillListTypeB(srcbilltype_B);
            this.createBillListtypeC(srcbilltype_C);
        }
        catch (Exception e) {
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"BasicProdAlloc_9", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BasicProdAlloc_10", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            return AllocResultEnum.Failure.getResult();
        }
        logger.info(String.format("\u3010\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u5206\u914d\u5e76\u6784\u9020sql\u751f\u6210\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        try (TXHandle tx = TX.required();){
            logger.info("\u57fa\u672c\u751f\u4ea7\u5206\u914d:\u5f00\u59cb\u6267\u884c\u65e5\u5fd7\u63d2\u5165");
            Object[] date = new Object[]{Long.parseLong(RequestContext.get().getUserId()), new Date()};
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plbasicallocentry where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)));
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plbasicpcomsubentry where fentryId in " + MfgfeeAllocHelper.setToSql(this.comEntryIdSet)));
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plbasicpparsubentry where fentryId in " + MfgfeeAllocHelper.setToSql(this.parEntryIdSet)));
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_basicallocentry where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)));
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_basicpcomsubentry where fentryId in " + MfgfeeAllocHelper.setToSql(this.comEntryIdSet)));
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_basicpparsubentry where fentryId in " + MfgfeeAllocHelper.setToSql(this.parEntryIdSet)));
            }
            if (this.billentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plbasic_entry_sql, this.billentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_basic_entry_sql, this.billentrys);
                }
            }
            if (this.comsubentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plbasic_comsubentry_sql, this.comsubentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_basic_comsubentry_sql, this.comsubentrys);
                }
            }
            if (this.comentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_plbasic_comentry_sql, this.comentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_basic_comentry_sql, this.comentrys);
                }
            }
            if (this.parsubentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plbasic_parsubentry_sql, this.parsubentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_basic_parsubentry_sql, this.parsubentrys);
                }
            }
            if (this.parentrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_plbasic_parentry_sql, this.parentrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_basic_parentry_sql, this.parentrys);
                }
            }
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)String.format(update_plbasic_bill_sql, MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)String.format(update_basic_bill_sql, MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            }
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "1");
            logger.info("\u57fa\u672c\u751f\u4ea7\u5206\u914d:\u7ed3\u675f\u65e5\u5fd7\u63d2\u5165");
        }
        logger.info(String.format("\u3010\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u6267\u884csql\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        return result;
    }

    private void createBillListtypeC(DataSet srcbilltype_C) {
        ArrayList<Row> curList = new ArrayList<Row>(10);
        long flagEntryId = -1L;
        for (Row row : srcbilltype_C) {
            if (flagEntryId == -1L) {
                flagEntryId = row.getLong("entryid");
                curList.add(row);
                continue;
            }
            if (row.getLong("entryid").equals(flagEntryId)) {
                curList.add(row);
                continue;
            }
            this.dealTypeCList(curList);
            curList.clear();
            curList.add(row);
            flagEntryId = row.getLong("entryid");
        }
        this.dealTypeCList(curList);
    }

    private void createBillListTypeB(DataSet srcbilltype_B) {
        ArrayList<Row> curList = new ArrayList<Row>(10);
        long flagEntryId = -1L;
        for (Row row : srcbilltype_B) {
            if (flagEntryId == -1L) {
                flagEntryId = row.getLong("entryid");
                curList.add(row);
                continue;
            }
            if (row.getLong("entryid").equals(flagEntryId)) {
                curList.add(row);
                continue;
            }
            this.dealTypeBList(curList);
            curList.clear();
            curList.add(row);
            flagEntryId = row.getLong("entryid");
        }
        this.dealTypeBList(curList);
    }

    private void createBillListTypeA(DataSet srcbilltype_A) {
        ArrayList<Row> curList = new ArrayList<Row>(10);
        long flagId = -1L;
        for (Row row : srcbilltype_A) {
            if (flagId == -1L) {
                flagId = row.getLong("id");
                curList.add(row);
                continue;
            }
            if (row.getLong("id").equals(flagId)) {
                curList.add(row);
                continue;
            }
            this.dealTypeAList(curList);
            curList.clear();
            curList.add(row);
            flagId = row.getLong("id");
        }
        this.dealTypeAList(curList);
    }

    private String buildReportParamStr(List<Long> ids, String entityType) {
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)entityType, (String)"org,costaccount,manuorg,period,currency,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long manuorgId = onebill.getLong("manuorg");
        long periodId = onebill.getLong("period");
        long costAccountId = onebill.getLong("costaccount");
        long currencyId = onebill.getLong("currency");
        JSONObject reportParamJs = new JSONObject();
        reportParamJs.put((Object)"taskname", (Object)"3");
        if ("cad_planbasicalloc".equals(entityType)) {
            reportParamJs.put((Object)"taskname", (Object)"7");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('1'));
        } else {
            reportParamJs.put((Object)"taskname", (Object)"3");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('0'));
        }
        reportParamJs.put((Object)"org", (Object)orgId);
        reportParamJs.put((Object)"manuorg", (Object)manuorgId);
        reportParamJs.put((Object)"costaccount", (Object)costAccountId);
        reportParamJs.put((Object)"period", (Object)periodId);
        reportParamJs.put((Object)"currency", (Object)currencyId);
        reportParamJs.put((Object)"starttime", (Object)this.startDate.getTime());
        reportParamJs.put((Object)"status", (Object)"4");
        reportParamJs.put((Object)"executor", (Object)this.allocUser);
        reportParamJs.put((Object)"detailInfo", (Object)"");
        return reportParamJs.toString();
    }

    private Boolean allocRecurrence(DataSet lastResult, DataSet stdAndValue, List<DataSet> result, int size, Long reportId, String reportParamStr) {
        if (size > 20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u914d\u6b21\u6570>20\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5faa\u73af\u5206\u914d\u3002", (String)"BasicProdAlloc_11", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        lastResult = lastResult.join(stdAndValue.copy(), JoinType.LEFT).on("benefcostcenter", "costcenter").on("expenseitem", "expenseitem").select(lastResult.getRowMeta().getFieldNames(), new String[]{"unit", "benefcostcenter curbenefcostcenter", "value curvalue"}).finish();
        DataSet toCollect = lastResult.filter("unit is null").select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt");
        DataSet toAlloc = lastResult.filter("unit is not null");
        DataSet toAllocValueTotal = toAlloc.copy().executeSql("select id,manuorg,costcenter,entryid,expenseitem,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt,sum(curvalue) curtotalvalue group by id,manuorg,costcenter,entryid,expenseitem,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt");
        toAlloc = toAlloc.join(toAllocValueTotal, JoinType.INNER).on("id", "id").on("entryid", "entryid").on("expenseitem", "expenseitem").on("costdriver", "costdriver").on("benefcostcenter", "benefcostcenter").select(toAlloc.getRowMeta().getFieldNames(), new String[]{"curtotalvalue"}).finish();
        toAlloc = toAlloc.select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt,unit,curbenefcostcenter,value*curvalue/curtotalvalue as curvalue,curtotalvalue,allocamt*curvalue/curtotalvalue curallocamt,path");
        DataSet allocSelf = toAlloc.filter("benefcostcenter=curbenefcostcenter").select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,curbenefcostcenter benefcostcenter,curvalue value,curtotalvalue totalvalue,curallocamt allocamt");
        DataSet judge = (toAlloc = toAlloc.filter("benefcostcenter!=curbenefcostcenter")).copy().filter("path like concat('%',cast(curbenefcostcenter as String),'%')");
        if (!judge.isEmpty()) {
            MfgfeeAllocReportHelper.writeReportEntry_BasicALloc(reportId, reportParamStr, judge);
            return false;
        }
        lastResult.close();
        if (toAlloc.isEmpty()) {
            result.add(toCollect);
            result.add(allocSelf);
            return true;
        }
        toAlloc = toAlloc.select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,benefcostcenter,value,totalvalue,allocamt,unit,curbenefcostcenter,curvalue,curtotalvalue,curallocamt,concat(path,'@',cast(curbenefcostcenter as String)) path");
        toAlloc = toAlloc.select("id,manuorg,costcenter,costcentername,srcbilltype,type,entryid,expenseitem,expenseitemname,expenseitemnumber,costdriver,allocamount,baseunit,curbenefcostcenter benefcostcenter,curvalue value,curtotalvalue totalvalue,curallocamt allocamt,path");
        result.add(toCollect);
        result.add(allocSelf);
        return this.allocRecurrence(toAlloc, stdAndValue, result, ++size, reportId, reportParamStr);
    }

    private void dealTypeAList(List<Row> curList) {
        int seq = 0;
        BigDecimal allocSum = BigDecimal.ZERO;
        for (Row row : curList) {
            BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
            if (seq == curList.size() - 1) {
                BigDecimal allocTotal = row.getBigDecimal("allocamount");
                BigDecimal allocamt = allocTotal.subtract(allocSum);
                Object[] entry = new Object[]{row.getLong("id"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
                this.idSet.add(row.getLong("id"));
                this.billentrys.add(entry);
                continue;
            }
            BigDecimal allocamt = row.getBigDecimal("allocamt").setScale(this.amtprecision, 4);
            allocSum = allocSum.add(allocamt);
            Object[] entry = new Object[]{row.getLong("id"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
            this.idSet.add(row.getLong("id"));
            this.billentrys.add(entry);
        }
    }

    private void dealTypeBList(List<Row> curList) {
        int seq = 0;
        BigDecimal allocSum = BigDecimal.ZERO;
        for (Row row : curList) {
            BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
            if (seq == curList.size() - 1) {
                BigDecimal allocTotal = row.getBigDecimal("allocamount");
                BigDecimal allocamt = allocTotal.subtract(allocSum);
                BigDecimal totalvalue = row.getBigDecimal("totalvalue").setScale(10, 4);
                Object[] comsubentry = new Object[]{row.getLong("entryid"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
                this.idSet.add(row.getLong("id"));
                this.comEntryIdSet.add(row.getLong("entryid"));
                this.comsubentrys.add(comsubentry);
                Object[] comentry = new Object[]{totalvalue, allocTotal, row.getLong("entryid")};
                this.comentrys.add(comentry);
                continue;
            }
            BigDecimal allocamt = row.getBigDecimal("allocamt").setScale(this.amtprecision, 4);
            allocSum = allocSum.add(allocamt);
            Object[] comsubentry = new Object[]{row.getLong("entryid"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), row.getLong("expenseitem"), row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
            this.idSet.add(row.getLong("id"));
            this.comEntryIdSet.add(row.getLong("entryid"));
            this.comsubentrys.add(comsubentry);
        }
    }

    private void dealTypeCList(List<Row> curList) {
        int seq = 0;
        BigDecimal allocSum = BigDecimal.ZERO;
        for (Row row : curList) {
            BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
            if (seq == curList.size() - 1) {
                BigDecimal allocTotal = row.getBigDecimal("allocamount");
                BigDecimal allocamt = allocTotal.subtract(allocSum);
                Long expenseitem = this.parEntryIdAndParExpen.get(row.getLong("entryid"));
                Object[] parsubentry = new Object[]{row.getLong("entryid"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), expenseitem == null ? Long.valueOf(0L) : expenseitem, row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
                this.idSet.add(row.getLong("id"));
                this.parEntryIdSet.add(row.getLong("entryid"));
                this.parsubentrys.add(parsubentry);
                BigDecimal totalvalue = row.getBigDecimal("totalvalue");
                Object[] comentry = new Object[]{totalvalue, allocTotal, row.getLong("entryid")};
                this.parentrys.add(comentry);
                continue;
            }
            BigDecimal allocamt = row.getBigDecimal("allocamt").setScale(this.amtprecision, 4);
            allocSum = allocSum.add(allocamt);
            Long expenseitem = this.parEntryIdAndParExpen.get(row.getLong("entryid"));
            Object[] parsubentry = new Object[]{row.getLong("entryid"), seq++, MfgfeeAllocHelper.getId(), row.getLong("benefcostcenter"), expenseitem == null ? Long.valueOf(0L) : expenseitem, row.getLong("costdriver"), row.getLong("baseunit"), value, allocamt};
            this.idSet.add(row.getLong("id"));
            this.parEntryIdSet.add(row.getLong("entryid"));
            this.parsubentrys.add(parsubentry);
        }
    }
}

