/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.alloc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.function.InnerAllocDimFunction;
import kd.macc.cad.algox.mfgfee.helper.CadDebugHelper;
import kd.macc.cad.algox.mfgfee.helper.DebugInfoMsgHandler;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocReportHelper;
import kd.macc.cad.algox.utils.CadDataSetXLogUtil;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.FormulaUtil;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.utils.DataSetUtils;
import net.sf.json.JSONObject;

public class InnerAlloc {
    private Log logger = LogFactory.getLog(InnerAlloc.class);
    private static final String insert_innerAllocEntry_sql = "INSERT INTO t_cad_mfgfeealloccoentry (FId,FEntryId,FSeq,fmaterialid,fcostobjectid,fallocamt,fallocvalue,fauxptyid,foutsourcetype) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String insert_allocCalReport_sql = "INSERT INTO t_cad_alloccalcreport (fid,forgid,fcostaccountid,fmanuorgid,fperiodid,fcostcenterid,fallocbillno,fcostdriverid,fbaseunitid,falloctime,fappnum) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String insert_allocCalReportEntry_sql = "INSERT INTO t_cad_alloccreportentry (fid,FEntryId,FSeq,fcostobjectid,fbizbillid,fbilltypenum,fbillnumber,fallocvalue,fcalcresult) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String update_InnerAllocBill_sql = "update t_cad_mfgfeeallocco set fcostdriverqty=?,factualrate=?,fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid = ?";
    private static final String COSTOBJECT_DIM_PRE = "costobject";
    private List<Object[]> entryParams = new ArrayList<Object[]>();
    private List<Object[]> billParams = new ArrayList<Object[]>();
    private List<Object[]> reportBillParams = new ArrayList<Object[]>();
    private List<Object[]> reportEntryParams = new ArrayList<Object[]>();
    private Set<Long> idSet = new HashSet<Long>(128);
    private int amtprecision = 10;
    private Long allocUser = 0L;
    private Date allocDate;

    public String doInnerAlloc(List<Long> ids, String appNum) {
        String result;
        String algokey = "kd.macc.cad.algox.mfgfee.alloc.NotProdAlloc doInnerAlloc()";
        if (CadEmptyUtils.isEmpty(ids)) {
            return AllocResultEnum.Failure.getResult();
        }
        String debugString = CadDebugHelper.getDebugKeyword("cad_mfgfeeallocco");
        String debugColName = "";
        String debugColVal = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)debugString)) {
                String[] ss = debugString.split("=");
                debugColName = ss[0];
                debugColVal = ss[1];
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        long start = System.currentTimeMillis();
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)"cad_mfgfeeallocco", (String)"org,costaccount,period,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long costAccountId = onebill.getLong("costaccount");
        long periodId = onebill.getLong("period");
        boolean enableMulFactory = MfgfeeAllocHelper.isEnableMulFactory(orgId);
        this.amtprecision = onebill.getInt("amtprecision");
        this.allocDate = new Date();
        this.allocUser = Long.parseLong(RequestContext.get().getUserId());
        String reportParamStr = this.buildReportParamStr(ids);
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        Long reportId = MfgfeeAllocReportHelper.initAllocReport(reportParamStr, appNum, 0L);
        DebugInfoMsgHandler msgHandler = new DebugInfoMsgHandler(reportId);
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        mfgfeeAllocHelper.setSaveCalcReport(true);
        Boolean isDisableAllocCalcReport = mfgfeeAllocHelper.isDisableAllocCalcReport(appNum);
        try {
            HashSet allocDimSet = new HashSet(6);
            DataSet innnerStd = mfgfeeAllocHelper.getCostObjectStd(orgId, appNum);
            HashSet<Long> costDriverIds = new HashSet<Long>(16);
            HashMap<String, String> allocDimMap = new HashMap<String, String>(8);
            StringBuilder allocDimStr = new StringBuilder();
            innnerStd.forEach(s -> {
                costDriverIds.add(s.getLong("costdriver"));
                String allocDim = s.getString("allocdim");
                if (!CadEmptyUtils.isEmpty(allocDim)) {
                    String[] split = allocDim.split(",");
                    if (split != null && split.length > 1) {
                        for (String arr : split) {
                            if (CadEmptyUtils.isEmpty(arr) || !allocDimSet.add(arr)) continue;
                            allocDimStr.append(arr).append(",");
                        }
                    }
                    allocDimMap.put(s.getLong("costcenter") + "@" + s.getLong("costdriver"), allocDim);
                }
            });
            DataSet stdAndValue = mfgfeeAllocHelper.getCostObjectStdData(orgId, costAccountId, periodId, appNum, costDriverIds);
            CadDataSetXLogUtil.logDataSet(stdAndValue, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u52a8\u56e0", (String)"InnerAlloc_8", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            String complexDiyNestTips = "";
            try {
                DataSet complexDs = mfgfeeAllocHelper.getComplexValueDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), "COSTOBJECT", enableMulFactory, false, 0L);
                if (complexDs != null) {
                    complexDs = complexDs.select("costdriver,0L as id,'' as billno,org,manuorg,costcenter,costobject,material,value,'' as billtypenum,0 as unit");
                    CadDataSetXLogUtil.logDataSet(complexDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u590d\u5408\u6210\u672c\u52a8\u56e0\u8d39\u7528\u5206\u914d\u6807\u51c6", (String)"InnerAlloc_10", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                    stdAndValue = stdAndValue.union(complexDs);
                }
            }
            catch (Exception e) {
                this.logger.error("\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c", (Throwable)e);
                complexDiyNestTips = e.getMessage();
            }
            DataSet innerAllocBill = QueryServiceHelper.queryDataSet((String)algokey, (String)"cad_mfgfeeallocco", (String)(allocDimStr + "id,billno,manuorg,benefcostcenter,benefcostcenter.name as benefcostcentername,productgroup,productgroup.grouptype grouptype,costdriver,costdriver.name as costdrivername,amount,baseunit"), (QFilter[])idfilter.toArray(), null);
            CadDataSetXLogUtil.logDataSet(innerAllocBill, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355", (String)"InnerAlloc_11", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            if (this.isContainMtfStockDriver(costDriverIds)) {
                HashSet costObjectIds = new HashSet(256);
                stdAndValue.copy().forEach(s -> costObjectIds.add(s.getLong(COSTOBJECT_DIM_PRE)));
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    QFilter idQFilter = new QFilter("id", "in", costObjectIds);
                    DataSet costObjectMatDs = QueryServiceHelper.queryDataSet((String)"getcostobjectmat", (String)"cad_costobject", (String)"id,material", (QFilter[])idQFilter.toArray(), null);
                    stdAndValue = stdAndValue.removeFields(new String[]{"material"});
                    stdAndValue = stdAndValue.join(costObjectMatDs, JoinType.INNER).on(COSTOBJECT_DIM_PRE, "id").select(stdAndValue.getRowMeta().getFieldNames(), new String[]{"material"}).finish();
                }
            }
            DataSet sourceStdAndValue = stdAndValue.copy().select("costdriver,id,billno,org,manuorg,costcenter,costobject,billtypenum,value");
            stdAndValue = enableMulFactory ? stdAndValue.groupBy(new String[]{"costdriver", "org", "manuorg", "costcenter", COSTOBJECT_DIM_PRE, "material", "unit"}).sum("value").finish() : stdAndValue.groupBy(new String[]{"costdriver", "org", "costcenter", COSTOBJECT_DIM_PRE, "material", "unit"}).sum("value").finish();
            CadDataSetXLogUtil.logDataSet(stdAndValue, debugColName, debugColVal, ResManager.loadKDString((String)"\u5206\u7ec4\u540e\u7684\u5206\u914d\u6807\u51c6", (String)"InnerAlloc_12", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            DataSet pgDs = null;
            DynamicObjectCollection productGroups = QueryServiceHelper.query((String)"cad_mfgfeeallocco", (String)"productgroup", (QFilter[])new QFilter[]{idfilter, new QFilter("productgroup", "!=", (Object)0)});
            if (productGroups != null && !productGroups.isEmpty()) {
                HashSet<Long> pgIds = new HashSet<Long>(productGroups.size());
                for (DynamicObject productGroup : productGroups) {
                    pgIds.add(productGroup.getLong("productgroup"));
                }
                if (!pgIds.isEmpty()) {
                    QFilter pgIdQf = new QFilter("id", "in", pgIds);
                    QFilter groupTypeQf = new QFilter("grouptype", "=", (Object)"3");
                    pgDs = QueryServiceHelper.queryDataSet((String)"doInnerAlloc.queryPg", (String)"cad_productintogroup", (String)"id productgroup,entryentity.material material,entryentity.auxpty auxpty,'1' hint", (QFilter[])new QFilter[]{pgIdQf, groupTypeQf}, (String)"id desc");
                }
            }
            innerAllocBill = enableMulFactory ? innerAllocBill.join(stdAndValue.copy(), JoinType.LEFT).on("benefcostcenter", "costcenter").on("costdriver", "costdriver").on("manuorg", "manuorg").select(innerAllocBill.getRowMeta().getFieldNames(), new String[]{"unit", COSTOBJECT_DIM_PRE, "material", "value"}).finish() : innerAllocBill.join(stdAndValue.copy(), JoinType.LEFT).on("benefcostcenter", "costcenter").on("costdriver", "costdriver").select(innerAllocBill.getRowMeta().getFieldNames(), new String[]{"unit", COSTOBJECT_DIM_PRE, "material", "value"}).finish();
            HashSet<Long> costObjectIds = new HashSet<Long>(256);
            for (Row row : stdAndValue) {
                costObjectIds.add(row.getLong(COSTOBJECT_DIM_PRE));
            }
            QFilter qfCostObjectId = new QFilter("id", "in", costObjectIds);
            DataSet costObjectData = QueryServiceHelper.queryDataSet((String)"macc-innerAlloc", (String)"cad_costobject", (String)(allocDimStr + "id,producttype,isoutsource,material,auxpty"), (QFilter[])qfCostObjectId.toArray(), null);
            ArrayList costObjectFields = Lists.newArrayList((Object[])new String[]{"producttype", "isoutsource", "auxpty"});
            allocDimSet.forEach(s -> costObjectFields.add(s + " as " + COSTOBJECT_DIM_PRE + s));
            innerAllocBill = innerAllocBill.leftJoin(costObjectData).on(COSTOBJECT_DIM_PRE, "id").select(innerAllocBill.getRowMeta().getFieldNames(), costObjectFields.toArray(new String[0])).finish();
            if (!CadEmptyUtils.isEmpty(allocDimSet)) {
                JobSession session = AlgoX.createSession((String)"InnerAlloc.doInnerAlloc");
                DataSetInput processingAllocInput = new DataSetInput(innerAllocBill);
                DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
                InnerAllocDimFunction function = new InnerAllocDimFunction(innerAllocBill.getRowMeta(), allocDimMap);
                DataSetX mainDataSet = dataSetX.groupBy(new String[]{"benefcostcenter", "costdriver"}).reduceGroup((GroupReduceFunction)function);
                DataSetOutput dataSetOutput = new DataSetOutput(innerAllocBill.getRowMeta());
                String resultId = dataSetOutput.getId();
                mainDataSet.output((Output)dataSetOutput);
                session.commit(60, TimeUnit.MINUTES);
                innerAllocBill = session.readDataSet(resultId);
            }
            CadDataSetXLogUtil.logDataSet(innerAllocBill, debugColName, debugColVal, ResManager.loadKDString((String)"\u53c2\u4e0e\u5206\u914d\u6570\u636e", (String)"InnerAlloc_13", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            int reportSeq = 0;
            DataSet noncostobject = innerAllocBill.copy().filter("costobject is null");
            String fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"InnerAlloc_0", (String)"macc-cad-algox", (Object[])new Object[0]);
            String fcheckdetail = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"InnerAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
            reportParamJs.put((Object)"allocresult", (Object)"1");
            reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"InnerAlloc_2", (String)"macc-cad-algox", (Object[])new Object[0]));
            MfgfeeAllocReportHelper.writeInnerAllocReportEntry(reportId, reportParamJs.toString(), noncostobject);
            innerAllocBill = innerAllocBill.filter("costobject is not null and producttype = 'C'");
            if (innerAllocBill.isEmpty()) {
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
                return AllocResultEnum.Failure.getResult();
            }
            if (pgDs != null && !pgDs.isEmpty()) {
                innerAllocBill = innerAllocBill.leftJoin(pgDs).on("productgroup", "productgroup").on("material", "material").on("auxpty", "auxpty").select(innerAllocBill.getRowMeta().getFieldNames(), new String[]{"hint"}).finish();
                innerAllocBill = innerAllocBill.filter("hint='1' and productgroup!=0L and grouptype=='3' or productgroup=0L or productgroup!=0L and grouptype!='3'");
                CadDataSetXLogUtil.logDataSet(innerAllocBill, debugColName, debugColVal, ResManager.loadKDString((String)"\u5173\u8054\u4ea7\u54c1\u7ec4\u540e\u6700\u7ec8\u5206\u914d\u6570\u636e", (String)"InnerAlloc_14", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
            }
            DataSet totalnotprod = innerAllocBill.copy().executeSql("select id,benefcostcenter,costdriver,sum(value) totalvalue group by id,benefcostcenter,costdriver");
            innerAllocBill = innerAllocBill.join(totalnotprod, JoinType.INNER).on("id", "id").select(innerAllocBill.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
            DataSet totalValueEuqalsZero = innerAllocBill.copy().filter("totalvalue=0");
            fcheckitem = ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002", (String)"InnerAlloc_3", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
            reportParamJs.put((Object)"allocresult", (Object)"1");
            reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002\u5982\u4fee\u6539\u5206\u914d\u6807\u51c6\uff0c\u9700\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"InnerAlloc_4", (String)"macc-cad-algox", (Object[])new Object[0]));
            MfgfeeAllocReportHelper.writeInnerAllocReportEntry(reportId, reportParamJs.toString(), totalValueEuqalsZero);
            fcheckitem = ResManager.loadKDString((String)"\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"InnerAlloc_5", (String)"macc-cad-algox", (Object[])new Object[0]);
            reportParamJs.put((Object)"seq", (Object)(++reportSeq));
            reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
            reportParamJs.put((Object)"checkdetail", (Object)complexDiyNestTips);
            if (StringUtils.isNotEmpty((CharSequence)complexDiyNestTips)) {
                reportParamJs.put((Object)"allocresult", (Object)"2");
            } else {
                reportParamJs.put((Object)"allocresult", (Object)"1");
            }
            MfgfeeAllocReportHelper.writeInnerAllocReportEntry(reportId, reportParamJs.toString(), null);
            innerAllocBill = innerAllocBill.filter("totalvalue!=0 and value!=0");
            innerAllocBill = innerAllocBill.addField("amount*value/totalvalue", "allocamount");
            if (innerAllocBill.isEmpty()) {
                MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
                return AllocResultEnum.Failure.getResult();
            }
            innerAllocBill = innerAllocBill.orderBy(new String[]{"id", "benefcostcenter", "costdriver", "value"});
            ArrayList<Row> curList = new ArrayList<Row>(10);
            long flagId = -1L;
            for (Row row : innerAllocBill.copy()) {
                if (flagId == -1L) {
                    flagId = row.getLong("id");
                    curList.add(row);
                    continue;
                }
                if (row.getLong("id").equals(flagId)) {
                    curList.add(row);
                    continue;
                }
                this.dealCurList(curList, orgId, costAccountId, periodId, appNum, isDisableAllocCalcReport);
                curList.clear();
                curList.add(row);
                flagId = row.getLong("id");
            }
            this.dealCurList(curList, orgId, costAccountId, periodId, appNum, isDisableAllocCalcReport);
            if (isDisableAllocCalcReport.booleanValue()) {
                DataSet innerReportDs = enableMulFactory ? sourceStdAndValue.join(innerAllocBill, JoinType.LEFT).on("manuorg", "manuorg").on("costcenter", "benefcostcenter").on("costdriver", "costdriver").on(COSTOBJECT_DIM_PRE, COSTOBJECT_DIM_PRE).select(sourceStdAndValue.getRowMeta().getFieldNames(), new String[]{"id as innerallocid"}).finish() : sourceStdAndValue.join(innerAllocBill, JoinType.LEFT).on("costcenter", "benefcostcenter").on("costdriver", "costdriver").on(COSTOBJECT_DIM_PRE, COSTOBJECT_DIM_PRE).select(sourceStdAndValue.getRowMeta().getFieldNames(), new String[]{"id as innerallocid"}).finish();
                innerReportDs = innerReportDs.filter("innerallocid is not null and innerallocid != 0");
                DataSet simpleDs = innerReportDs.filter("id is not null and id != 0").addField("''", "calcresult");
                DataSet formulaDs = innerReportDs.filter("id is null or id == 0");
                QFilter queryQFilter = new QFilter("org", "=", (Object)orgId);
                queryQFilter.and("costaccount", "=", (Object)costAccountId);
                queryQFilter.and("period", "=", (Object)periodId);
                queryQFilter.and("appnum", "=", (Object)appNum);
                queryQFilter.and("iscalcdata", "=", (Object)Boolean.TRUE);
                DataSet allocCalcReportRow = QueryServiceHelper.queryDataSet((String)"queryalloccalcreport", (String)"cad_alloccalcreport", (String)"costaccount,manuorg,entryentity.benefcostcenter as costcenter,costdriver,entryentity.costobject costobject,entryentity.bizbillid bizbillid,entryentity.seq seq,entryentity.billtypenum billtypenum,entryentity.billnumber billnumber,entryentity.allocvalue allocvalue,entryentity.calcresult calcresult", (QFilter[])queryQFilter.toArray(), null);
                formulaDs = formulaDs.join(allocCalcReportRow, JoinType.INNER).on("costcenter", "costcenter").on("costdriver", "costdriver").on(COSTOBJECT_DIM_PRE, COSTOBJECT_DIM_PRE).select(new String[]{"manuorg", "costcenter", "innerallocid"}, new String[]{COSTOBJECT_DIM_PRE, "bizbillid as id", "billtypenum", "billnumber as billno", "allocvalue as value", "calcresult", "seq"}).finish().distinct();
                DataSet totalDealReportDs = DataSetUtils.union((DataSet)formulaDs, (DataSet)simpleDs.addNullField("seq")).orderBy(new String[]{"innerallocid", "manuorg", "costcenter", COSTOBJECT_DIM_PRE, "seq"});
                int reportEntrySeq = 0;
                long flagInnerAllocId = -1L;
                while (totalDealReportDs.hasNext()) {
                    Row row = totalDealReportDs.next();
                    long innerAllocId = row.getLong("innerallocid");
                    if (flagInnerAllocId == innerAllocId) {
                        ++reportEntrySeq;
                    } else {
                        reportEntrySeq = 0;
                        flagInnerAllocId = innerAllocId;
                    }
                    this.reportEntryParams.add(new SqlParameter[]{new SqlParameter("fid", -5, (Object)innerAllocId), new SqlParameter("FEntryId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)reportEntrySeq), new SqlParameter("fcostobjectid", -5, (Object)(row.getLong(COSTOBJECT_DIM_PRE) == null ? Long.valueOf(0L) : row.getLong(COSTOBJECT_DIM_PRE))), new SqlParameter("fbizbillid", -5, (Object)(row.getLong("id") == null ? Long.valueOf(0L) : row.getLong("id"))), new SqlParameter("fbilltypenum", 12, (Object)(row.getString("billtypenum") == null ? " " : row.getString("billtypenum"))), new SqlParameter("fbillnumber", 12, (Object)(row.getString("billno") == null ? " " : row.getString("billno"))), new SqlParameter("fallocvalue", 3, (Object)(row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value"))), new SqlParameter("fcalcresult", 12, (Object)(row.getString("calcresult") == null ? " " : row.getString("calcresult")))});
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5931\u8d25\uff1a", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"InnerAlloc_6", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"InnerAlloc_7", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeInnerAllocReportEntry(reportId, reportParamJs.toString(), null);
            MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            return AllocResultEnum.Failure.getResult();
        }
        this.logger.info(String.format("\u3010\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d-\u5206\u914d\u5e76\u6784\u9020sql\u751f\u6210\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        try {
            this.logger.info("\u4e2d\u5fc3\u5185\u5206\u914d:\u5f00\u59cb\u6267\u884c\u65e5\u5fd7\u63d2\u5165\uff0c\u5171 {} \u6761", (Object)this.billParams.size());
            String idSqlSet = MfgfeeAllocHelper.setToSql(this.idSet);
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_mfgfeealloccoentry where fid in " + idSqlSet));
            if (isDisableAllocCalcReport.booleanValue()) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_alloccreportentry where fid in " + idSqlSet));
            }
            if (this.entryParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_innerAllocEntry_sql, this.entryParams);
            }
            if (this.billParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)update_InnerAllocBill_sql, this.billParams);
            }
            if (this.reportBillParams.size() > 0 && isDisableAllocCalcReport.booleanValue()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_allocCalReport_sql, this.reportBillParams);
            }
            if (this.reportEntryParams.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_allocCalReportEntry_sql, this.reportEntryParams);
            }
            this.logger.info("\u4e2d\u5fc3\u5185\u5206\u914d:\u7ed3\u675f\u65e5\u5fd7\u63d2\u5165");
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "1");
        }
        catch (Exception e) {
            this.logger.error("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5931\u8d25", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"InnerAlloc_6", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"InnerAlloc_7", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeInnerAllocReportEntry(reportId, reportParamJs.toString(), null);
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
        }
        this.logger.info(String.format("\u3010\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d-\u6267\u884csql\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        return result;
    }

    private boolean isContainMtfStockDriver(Set<Long> costDriverIds) {
        if (costDriverIds.contains(CostDriverIdConstant.MFT_STOCK_SCA) || costDriverIds.contains(CostDriverIdConstant.MFT_STOCK_ACA)) {
            return true;
        }
        QFilter qFilter = new QFilter("id", "in", costDriverIds);
        qFilter.and("iscomplexcd", "=", (Object)Boolean.TRUE);
        DataSet costCenterComplexDriverDs = QueryServiceHelper.queryDataSet((String)"getcostdriver", (String)"cad_costdriver", (String)"id,formula,number,name,costtype", (QFilter[])qFilter.toArray(), null);
        for (Row row : costCenterComplexDriverDs) {
            String formula = row.getString("formula");
            String currentNumber = row.getString("number");
            String currentName = row.getString("name");
            long complexDriverId = row.getLong("id");
            try {
                formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, complexDriverId);
            }
            catch (KDBizException e) {
                this.logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
                throw e;
            }
            if (!formula.contains(String.valueOf(CostDriverIdConstant.MFT_STOCK_SCA)) && !formula.contains(String.valueOf(CostDriverIdConstant.MFT_STOCK_ACA))) continue;
            return true;
        }
        return false;
    }

    private void dealCurList(List<Row> curList, long orgId, long costAccountId, long periodId, String appNum, Boolean isDisableAllocCalcReport) {
        Long id = curList.get(0).getLong("id");
        this.idSet.add(id);
        int seq = 0;
        BigDecimal allocSum = BigDecimal.ZERO;
        for (Row row : curList) {
            BigDecimal allocAmt;
            BigDecimal value = row.getBigDecimal("value").setScale(10, 4);
            BigDecimal totalvalue = row.getBigDecimal("totalvalue").setScale(10, 4);
            String outsourcetype = "";
            if (row.getBoolean("isoutsource").booleanValue()) {
                outsourcetype = "C";
            }
            if (seq == curList.size() - 1) {
                allocAmt = row.getBigDecimal("amount").subtract(allocSum);
                this.entryParams.add(new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("FEntryId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fmaterialid", -5, (Object)row.getLong("material")), new SqlParameter("fcostobjectid", -5, (Object)row.getLong(COSTOBJECT_DIM_PRE)), new SqlParameter("fallocamt", 3, (Object)allocAmt), new SqlParameter("fallocvalue", 3, (Object)value), new SqlParameter("fauxptyid", -5, (Object)row.getLong("auxpty")), new SqlParameter("foutsourcetype", -9, (Object)outsourcetype)});
                BigDecimal ratio = row.getBigDecimal("amount").divide(totalvalue, new MathContext(10, RoundingMode.HALF_UP));
                this.billParams.add(new SqlParameter[]{new SqlParameter("fcostdriverqty", 3, (Object)totalvalue), new SqlParameter("factualrate", 3, (Object)ratio), new SqlParameter("fallocorid", -5, (Object)this.allocUser), new SqlParameter("falloctime", 91, (Object)this.allocDate), new SqlParameter("fid", -5, (Object)id)});
                if (!isDisableAllocCalcReport.booleanValue()) continue;
                this.reportBillParams.add(new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("forgid", -5, (Object)orgId), new SqlParameter("fcostaccountid", -5, (Object)costAccountId), new SqlParameter("fmanuorgid", -5, (Object)row.getLong("manuorg")), new SqlParameter("fperiodid", -5, (Object)periodId), new SqlParameter("fcostcenterid", -5, (Object)row.getLong("benefcostcenter")), new SqlParameter("fallocbillno", 12, (Object)row.getString("billno")), new SqlParameter("fcostdriverid", -5, (Object)row.getLong("costdriver")), new SqlParameter("fbaseunitid", -5, (Object)row.getLong("baseunit")), new SqlParameter("falloctime", 91, (Object)this.allocDate), new SqlParameter("fappnum", 12, (Object)appNum)});
                continue;
            }
            allocAmt = row.getBigDecimal("allocamount").setScale(this.amtprecision, 4);
            allocSum = allocSum.add(allocAmt);
            this.entryParams.add(new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("FEntryId", -5, (Object)MfgfeeAllocHelper.getId()), new SqlParameter("FSeq", -5, (Object)seq++), new SqlParameter("fmaterialid", -5, (Object)row.getLong("material")), new SqlParameter("fcostobjectid", -5, (Object)row.getLong(COSTOBJECT_DIM_PRE)), new SqlParameter("fallocamt", 3, (Object)allocAmt), new SqlParameter("fallocvalue", 3, (Object)value), new SqlParameter("fauxptyid", -5, (Object)row.getLong("auxpty")), new SqlParameter("foutsourcetype", -9, (Object)outsourcetype)});
        }
    }

    private String buildReportParamStr(List<Long> ids) {
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)"cad_mfgfeeallocco", (String)"org,costaccount,manuorg,period,currency,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long manuorgId = onebill.getLong("manuorg");
        long periodId = onebill.getLong("period");
        long costAccountId = onebill.getLong("costaccount");
        long currencyId = onebill.getLong("currency");
        JSONObject reportParamJs = new JSONObject();
        reportParamJs.put((Object)"taskname", (Object)"4");
        reportParamJs.put((Object)"org", (Object)orgId);
        reportParamJs.put((Object)"manuorg", (Object)manuorgId);
        reportParamJs.put((Object)"costaccount", (Object)costAccountId);
        reportParamJs.put((Object)"period", (Object)periodId);
        reportParamJs.put((Object)"currency", (Object)currencyId);
        reportParamJs.put((Object)"starttime", (Object)this.allocDate.getTime());
        reportParamJs.put((Object)"status", (Object)"4");
        reportParamJs.put((Object)"executor", (Object)this.allocUser);
        reportParamJs.put((Object)"detailInfo", (Object)"");
        return reportParamJs.toString();
    }
}

