/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.alloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.helper.CadDebugHelper;
import kd.macc.cad.algox.mfgfee.helper.DebugInfoMsgHandler;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocReportHelper;
import kd.macc.cad.algox.utils.CadDataSetXLogUtil;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import net.sf.json.JSONObject;

public class NotProdAlloc {
    private Log logger = LogFactory.getLog(NotProdAlloc.class);
    private static final String insert_notprdentry_sql = "INSERT INTO t_cad_nonprodallocentry (FId,FEntryId,FSeq,fbenefcostcenterid,fallocamt,fallocvalue) VALUES (?,?,?,?,?,?)";
    private static final String insert_plannotprdentry_sql = "INSERT INTO t_cad_plnonprodentry (FId,FEntryId,FSeq,fbenefcostcenterid,fallocamt,fallocvalue) VALUES (?,?,?,?,?,?)";
    private List<Object[]> entrys = new ArrayList<Object[]>();
    private List<Object[]> bills = new ArrayList<Object[]>();
    private Set<Long> idSet = new HashSet<Long>(128);
    private int amtprecision = 10;
    private Date startDate;
    private Long allocUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doNotProdAlloc(String entityType, List<Long> ids, String appNum, boolean planData, Long planschemeId) {
        String result;
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObjectCollection allocBills = QueryServiceHelper.query((String)entityType, (String)"id,org,costaccount,manuorg,period,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        if (CadEmptyUtils.isEmpty(allocBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5206\u914d\u7684\u5355\u636e\u3002", (String)"NotProdAlloc_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        long start = System.currentTimeMillis();
        this.startDate = new Date();
        this.allocUser = Long.parseLong(RequestContext.get().getUserId());
        this.amtprecision = ((DynamicObject)allocBills.get(0)).getInt("amtprecision");
        long orgId = ((DynamicObject)allocBills.get(0)).getLong("org");
        long periodId = ((DynamicObject)allocBills.get(0)).getLong("period");
        this.logger.info("\u975e\u751f\u4ea7\u5206\u914d org:" + orgId + ",period:" + periodId);
        String reportParamStr = this.buildReportParamStr(entityType, ids);
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        Long reportId = MfgfeeAllocReportHelper.initAllocReport(reportParamStr, appNum, planschemeId);
        try {
            if (!this.allocMethod(reportParamStr, reportId, ids, appNum, planData, planschemeId)) {
                return MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            }
        }
        catch (Exception e) {
            this.logger.error("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5931\u8d25\uff1a", (Throwable)e);
            reportParamJs.put((Object)"seq", (Object)99);
            reportParamJs.put((Object)"checkitem", (Object)ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef", (String)"NotProdAlloc_1", (String)"macc-cad-algox", (Object[])new Object[0]));
            String errorMessage = e.getMessage() == null ? ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"NotProdAlloc_2", (String)"macc-cad-algox", (Object[])new Object[0]) : e.getMessage();
            reportParamJs.put((Object)"checkdetail", (Object)(errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage));
            reportParamJs.put((Object)"allocresult", (Object)"2");
            MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
            MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "3");
            return AllocResultEnum.Failure.getResult();
        }
        this.logger.info(String.format("\u3010\u975e\u751f\u4ea7\u5206\u914d-\u5206\u914d\u5e76\u6784\u9020sql\u751f\u6210\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        try (TXHandle tx = TX.required();){
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_plnonprodentry where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)));
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_cad_nonprodallocentry where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)));
            }
            if (this.entrys.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_plannotprdentry_sql, this.entrys);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)insert_notprdentry_sql, this.entrys);
                }
            }
            if (this.bills.size() > 0) {
                if (planData) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_cad_plannonprodalloc set fcostdriverid=?,fbaseunitid=? where fid =?", this.bills);
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_cad_nonprodalloc set fcostdriverid=?,fbaseunitid=? where fid =?", this.bills);
                }
            }
            Object[] date = new Object[]{this.allocUser, this.startDate};
            if (planData) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_plannonprodalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_nonprodalloc set fallocstatus='1',falloctype='1',fallocorid=?,falloctime=? where fid in " + MfgfeeAllocHelper.setToSql(this.idSet)), (Object[])date);
            }
            result = MfgfeeAllocReportHelper.writeReport(reportId, reportParamStr, "1");
        }
        this.logger.info(String.format("\u3010\u975e\u751f\u4ea7\u5206\u914d-\u6267\u884csql\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        return result;
    }

    private boolean allocMethod(String reportParamStr, Long reportId, List<Long> ids, String appNum, boolean planData, Long planschemeId) {
        DataSet diyResult;
        String algokey = "kd.macc.cad.algox.mfgfee.alloc.NotProdAlloc doNotProdAlloc()";
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        long orgId = reportParamJs.getLong("org");
        long costAccountId = reportParamJs.getLong("costaccount");
        long periodId = reportParamJs.getLong("period");
        String entityType = reportParamJs.getString("entitytype");
        boolean enableMulFactory = MfgfeeAllocHelper.isEnableMulFactory(orgId);
        DebugInfoMsgHandler msgHandler = new DebugInfoMsgHandler(reportId);
        String debugString = CadDebugHelper.getDebugKeyword(entityType);
        String debugColName = "";
        String debugColVal = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)debugString)) {
                String[] ss = debugString.split("=");
                debugColName = ss[0];
                debugColVal = ss[1];
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        mfgfeeAllocHelper.setSaveCalcReport(false);
        DataSet notProdStd = mfgfeeAllocHelper.getNotProdStd(orgId, appNum, periodId);
        CadDataSetXLogUtil.logDataSet(notProdStd, debugColName, debugColVal, ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u6807\u51c6", (String)"NotProdAlloc_12", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        HashSet<Long> costDriverIds = new HashSet<Long>();
        HashSet allocDimSet = new HashSet(6);
        StringBuilder allocDimStr = new StringBuilder();
        notProdStd.copy().forEach(s -> {
            String[] split;
            costDriverIds.add(s.getLong("costdriver"));
            String allocDim = s.getString("allocdim");
            if (!CadEmptyUtils.isEmpty(allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
                for (String arr : split) {
                    if (CadEmptyUtils.isEmpty(arr) || !allocDimSet.add(arr)) continue;
                    allocDimStr.append(arr).append(",");
                }
            }
        });
        DataSet stdValueNotDiy = mfgfeeAllocHelper.getStdValueNotDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId);
        DataSet stdValueDiy = mfgfeeAllocHelper.getStdValueDiy(orgId, costAccountId, periodId, appNum, costDriverIds, planData, planschemeId);
        String complexDiyNestTips = "";
        try {
            DataSet complexNotDiyDs;
            DataSet complexDs = mfgfeeAllocHelper.getComplexValueDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), "COSTCENTER", enableMulFactory, planData, planschemeId);
            if (complexDs != null) {
                CadDataSetXLogUtil.logDataSet(complexDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"NotProdAlloc_13", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                complexDs = complexDs.addField("0", "unit");
                stdValueDiy = DataSetUtils.union((DataSet)complexDs, (DataSet)stdValueDiy);
            }
            if ((complexNotDiyDs = mfgfeeAllocHelper.getComplexValueNotDiy(orgId, costAccountId, periodId, appNum, new ArrayList<Long>(costDriverIds), enableMulFactory, planData, planschemeId)) != null) {
                CadDataSetXLogUtil.logDataSet(complexNotDiyDs, debugColName, debugColVal, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ea7\u590d\u5408\u6210\u672c\u52a8\u56e0", (String)"NotProdAlloc_14", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
                complexNotDiyDs = complexNotDiyDs.addField("0", "unit");
                stdValueNotDiy = DataSetUtils.union((DataSet)complexNotDiyDs, (DataSet)stdValueNotDiy);
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c", (Throwable)e);
            complexDiyNestTips = ResManager.loadKDString((String)"\u83b7\u53d6\u590d\u5408\u6210\u672c\u52a8\u56e0\u5206\u914d\u6807\u51c6\u503c\u5931\u8d25\u3002", (String)"NotProdAlloc_9", (String)"macc-cad-algox", (Object[])new Object[0]);
        }
        stdValueDiy = stdValueDiy.executeSql("select costdriver,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,benefcostcenter,unit");
        stdValueDiy = stdValueDiy.select("costdriver,org,manuorg,costcenter,benefcostcenter,value,unit");
        CadDataSetXLogUtil.logDataSet(stdValueDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0", (String)"NotProdAlloc_11", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        stdValueNotDiy = stdValueNotDiy.executeSql("select costdriver,org,manuorg,costcenter,unit,sum(value) value group by costdriver,org,manuorg,costcenter,unit");
        stdValueNotDiy = stdValueNotDiy.select("costdriver,org,manuorg,costcenter,value,unit");
        CadDataSetXLogUtil.logDataSet(stdValueNotDiy, debugColName, debugColVal, ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u672c\u52a8\u56e0", (String)"NotProdAlloc_10", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        DataSet notprodbill = QueryServiceHelper.queryDataSet((String)algokey, (String)entityType, (String)(allocDimStr + "id,org,manuorg,costcenter,costcenter.name costcentername,expenseitem,expenseitem.name expenseitemname,expenseitem.number expenseitemnumber,amount"), (QFilter[])idfilter.toArray(), null);
        CadDataSetXLogUtil.logDataSet(notprodbill, debugColName, debugColVal, ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355", (String)"NotProdAlloc_15", (String)"macc-cad-algox", (Object[])new Object[0]), msgHandler);
        if (enableMulFactory) {
            stdValueNotDiy = notProdStd.join(stdValueNotDiy, JoinType.INNER).on("costdriver", "costdriver").on("benefcostcenter", "costcenter").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "benefcostcenter"}, new String[]{"value", "unit"}).finish();
            diyResult = notProdStd.join(stdValueDiy, JoinType.INNER).on("costdriver", "costdriver").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").on("manuorg", "manuorg").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "benefcostcenter"}, new String[]{"value", "unit"}).finish();
        } else {
            stdValueNotDiy = notProdStd.join(stdValueNotDiy, JoinType.INNER).on("costdriver", "costdriver").on("benefcostcenter", "costcenter").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "benefcostcenter"}, new String[]{"value", "unit"}).finish();
            diyResult = notProdStd.join(stdValueDiy, JoinType.INNER).on("costdriver", "costdriver").on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "benefcostcenter"}, new String[]{"value", "unit"}).finish();
        }
        DataSet stdAndValue = stdValueNotDiy.union(diyResult);
        DataSet stdValueDiy_costcenter_is_null = stdValueDiy.filter("costcenter is null or costcenter = 0");
        DataSet value_is_null = stdAndValue.filter("value is null").groupBy(stdAndValue.getRowMeta().getFieldNames()).finish();
        DataSet value_is_not_null = stdAndValue.filter("value is not null");
        HashSet<Long> allocCostcenters = new HashSet<Long>(16);
        for (Row row : value_is_not_null.copy()) {
            allocCostcenters.add(row.getLong("costcenter"));
        }
        value_is_null = value_is_null.filter("costcenter not in " + MfgfeeAllocHelper.setToSql(allocCostcenters));
        value_is_null = value_is_null.leftJoin(stdValueDiy_costcenter_is_null).on("costdriver", "costdriver").on("manuorg", "manuorg").on("benefcostcenter", "benefcostcenter").select(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "unit", "benefcostcenter"}, new String[]{"value"}).finish().select(value_is_not_null.getRowMeta().getFieldNames());
        stdAndValue = value_is_not_null.union(value_is_null).filter("value is not null");
        stdAndValue = stdAndValue.groupBy(new String[]{"manuorg", "costcenter", "expenseitem", "costdriver", "unit", "benefcostcenter"}).sum("value").finish();
        notprodbill = notprodbill.join(stdAndValue, JoinType.LEFT).on("costcenter", "costcenter").on("expenseitem", "expenseitem").on("manuorg", "manuorg").select(notprodbill.getRowMeta().getFieldNames(), new String[]{"costdriver", "unit", "benefcostcenter", "value"}).finish();
        DataSet withoutStandard = notprodbill.copy().filter("costdriver is null");
        int reportSeq = 0;
        String fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"NotProdAlloc_3", (String)"macc-cad-algox", (Object[])new Object[0]);
        String fcheckdetail = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"NotProdAlloc_4", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
        reportParamJs.put((Object)"allocresult", (Object)"1");
        reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6/\u5206\u914d\u6807\u51c6\u503c", (String)"NotProdAlloc_5", (String)"macc-cad-algox", (Object[])new Object[0]));
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), withoutStandard);
        fcheckitem = ResManager.loadKDString((String)"\u590d\u5408\u6210\u672c\u52a8\u56e0\u65e0\u6cd5\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"NotProdAlloc_6", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)complexDiyNestTips);
        if (StringUtils.isNotEmpty((CharSequence)complexDiyNestTips)) {
            reportParamJs.put((Object)"allocresult", (Object)"2");
        } else {
            reportParamJs.put((Object)"allocresult", (Object)"1");
        }
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), null);
        notprodbill = notprodbill.filter("costdriver is not null");
        if (notprodbill.isEmpty()) {
            return false;
        }
        DataSet totalnotprod = notprodbill.copy().executeSql("select manuorg,costcenter,expenseitem," + allocDimStr + "sum(value) totalvalue group by " + allocDimStr + "manuorg,costcenter,expenseitem");
        JoinDataSet billJoinDataSet = notprodbill.join(totalnotprod, JoinType.INNER).on("costcenter", "costcenter").on("expenseitem", "expenseitem").on("manuorg", "manuorg");
        for (String allocDim : allocDimSet) {
            billJoinDataSet = billJoinDataSet.on(allocDim, allocDim);
        }
        notprodbill = billJoinDataSet.select(notprodbill.getRowMeta().getFieldNames(), new String[]{"totalvalue"}).finish();
        DataSet totalValueEuqalsZero = notprodbill.copy().filter("totalvalue=0");
        fcheckitem = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002", (String)"NotProdAlloc_7", (String)"macc-cad-algox", (Object[])new Object[0]);
        reportParamJs.put((Object)"seq", (Object)(++reportSeq));
        reportParamJs.put((Object)"checkitem", (Object)fcheckitem);
        reportParamJs.put((Object)"checkdetail", (Object)fcheckdetail);
        reportParamJs.put((Object)"allocresult", (Object)"1");
        reportParamJs.put((Object)"detailInfo", (Object)ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u503c\u5408\u8ba1\u4e3a0\u3002\u5982\u4fee\u6539\u5206\u914d\u6807\u51c6\uff0c\u9700\u91cd\u65b0\u5f15\u5165\u6570\u636e\u3002", (String)"NotProdAlloc_8", (String)"macc-cad-algox", (Object[])new Object[0]));
        MfgfeeAllocReportHelper.writeReportEntry(reportId, reportParamJs.toString(), totalValueEuqalsZero);
        notprodbill = notprodbill.filter("totalvalue!=0 and value!=0");
        if (notprodbill.isEmpty()) {
            return false;
        }
        notprodbill = notprodbill.addField("amount*value/totalvalue", "allocamount");
        notprodbill = notprodbill.orderBy(new String[]{"id", "costcenter", "expenseitem", "value"});
        this.logger.info("\u975e\u751f\u4ea7\u5206\u914d\uff0c\u5206\u914d\u6570\u636edataset\u5904\u7406\u5b8c\u6210\u3002");
        this.createCurList(notprodbill);
        return true;
    }

    private void createCurList(DataSet notprodbill) {
        ArrayList<Row> curList = new ArrayList<Row>(10);
        long flagId = -1L;
        for (Row row : notprodbill) {
            if (flagId == -1L) {
                flagId = row.getLong("id");
                curList.add(row);
                continue;
            }
            if (row.getLong("id").equals(flagId)) {
                curList.add(row);
                continue;
            }
            this.dealCurList(curList);
            curList.clear();
            curList.add(row);
            flagId = row.getLong("id");
        }
        this.dealCurList(curList);
    }

    private String buildReportParamStr(String entityType, List<Long> ids) {
        QFilter idfilter = new QFilter("id", "in", ids);
        DynamicObject onebill = QueryServiceHelper.queryOne((String)entityType, (String)"org,costaccount,manuorg,period,currency,currency.amtprecision amtprecision", (QFilter[])idfilter.toArray());
        long orgId = onebill.getLong("org");
        long manuorgId = onebill.getLong("manuorg");
        long periodId = onebill.getLong("period");
        long costAccountId = onebill.getLong("costaccount");
        long currencyId = onebill.getLong("currency");
        JSONObject reportParamJs = new JSONObject();
        if ("cad_plannonprodalloc".equals(entityType)) {
            reportParamJs.put((Object)"taskname", (Object)"5");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('1'));
        } else {
            reportParamJs.put((Object)"taskname", (Object)"1");
            reportParamJs.put((Object)"isplandata", (Object)Character.valueOf('0'));
        }
        reportParamJs.put((Object)"entitytype", (Object)entityType);
        reportParamJs.put((Object)"org", (Object)orgId);
        reportParamJs.put((Object)"manuorg", (Object)manuorgId);
        reportParamJs.put((Object)"costaccount", (Object)costAccountId);
        reportParamJs.put((Object)"period", (Object)periodId);
        reportParamJs.put((Object)"currency", (Object)currencyId);
        reportParamJs.put((Object)"starttime", (Object)this.startDate.getTime());
        reportParamJs.put((Object)"status", (Object)"4");
        reportParamJs.put((Object)"executor", (Object)this.allocUser);
        reportParamJs.put((Object)"detailInfo", (Object)"");
        return reportParamJs.toString();
    }

    private void dealCurList(List<Row> curList) {
        if (CadEmptyUtils.isEmpty(curList)) {
            return;
        }
        int seq = 0;
        BigDecimal alloctotal = BigDecimal.ZERO;
        for (Row row : curList) {
            Object[] entry;
            BigDecimal unit;
            if (seq == curList.size() - 1) {
                BigDecimal lastamount = row.getBigDecimal("amount").subtract(alloctotal).setScale(this.amtprecision, 4);
                unit = row.getBigDecimal("value").setScale(10, 4);
                entry = new Object[]{row.getLong("id"), MfgfeeAllocHelper.getId(), seq++, row.getLong("benefcostcenter"), lastamount, unit};
                this.entrys.add(entry);
                Object[] bill = new Object[]{row.getLong("costdriver"), row.getLong("unit"), row.getLong("id")};
                this.bills.add(bill);
                this.idSet.add(row.getLong("id"));
                continue;
            }
            BigDecimal allocamount = row.getBigDecimal("allocamount").setScale(this.amtprecision, 4);
            unit = row.getBigDecimal("value").setScale(10, 4);
            alloctotal = alloctotal.add(allocamount);
            entry = new Object[]{row.getLong("id"), MfgfeeAllocHelper.getId(), seq++, row.getLong("benefcostcenter"), allocamount, unit};
            this.entrys.add(entry);
        }
    }
}

