/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InnerAllocDimFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String COSTOBJECT_DIM_PRE = "costobject";
    private RowMeta rowMeta;
    private Map<String, String> paramMap;

    public InnerAllocDimFunction(RowMeta rowMeta, Map<String, String> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        for (RowX row : rows) {
            String[] split;
            Long costCenter = row.getLong(this.rowMeta.getFieldIndex("benefcostcenter"));
            Long costDriver = row.getLong(this.rowMeta.getFieldIndex("costdriver"));
            String allocDim = this.paramMap.get(costCenter + "@" + costDriver);
            boolean isSameAllocDim = true;
            if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
                for (String arr : split) {
                    if (CadEmptyUtils.isEmpty((String)arr)) continue;
                    Object innerBillDim = row.get(this.rowMeta.getFieldIndex(arr));
                    Object costObjectDim = row.get(this.rowMeta.getFieldIndex(COSTOBJECT_DIM_PRE + arr));
                    if (innerBillDim == null || CadEmptyUtils.isEmpty((String)String.valueOf(innerBillDim)) || innerBillDim.equals(costObjectDim)) continue;
                    isSameAllocDim = false;
                    break;
                }
            }
            if (!isSameAllocDim) continue;
            collector.collect(row);
        }
    }
}

