/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.utils.DatSetXUtils;

public class MfgAuxReportColSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;
    private String sumTitle = null;
    private int seq = 999;

    public MfgAuxReportColSumFunction(RowMeta rowMeta, String sumTitle, int seq) {
        this.rowMeta = rowMeta;
        this.sumTitle = sumTitle;
        this.seq = seq;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, new String[]{"periodorder asc", "manuorgnumber asc", "costcenternumber asc"}, this.rowMeta);
        RowX targetRow = null;
        Row row = null;
        int[] sumCols = new int[]{this.rowMeta.getFieldIndex("allocamount"), this.rowMeta.getFieldIndex("costdriverqty"), this.rowMeta.getFieldIndex("allocsum"), this.rowMeta.getFieldIndex("subinqty"), this.rowMeta.getFieldIndex("subinamt"), this.rowMeta.getFieldIndex("suboutqty"), this.rowMeta.getFieldIndex("suboutamt")};
        while (ds.hasNext()) {
            row = ds.next();
            if (targetRow == null) {
                targetRow = new RowX(row.size());
                for (int i = 0; i < row.size(); ++i) {
                    targetRow.set(i, row.get(i));
                }
                continue;
            }
            for (int index = 0; index < sumCols.length; ++index) {
                targetRow.set(sumCols[index], (Object)this.addData(targetRow.getBigDecimal(sumCols[index]), row.getBigDecimal(sumCols[index])));
            }
        }
        int costcenternumberIndex = this.rowMeta.getFieldIndex("costcenternumber");
        int expenseitemnumberIndex = this.rowMeta.getFieldIndex("expenseitemnumber");
        int subcostcenternumberIndex = this.rowMeta.getFieldIndex("subcostcenternumber");
        int manuorgnumberIndex = this.rowMeta.getFieldIndex("manuorgnumber");
        int periodorderIndex = this.rowMeta.getFieldIndex("periodorder");
        int seqIndex = this.rowMeta.getFieldIndex("seq");
        int expenseitemIndex = this.rowMeta.getFieldIndex("expenseitem");
        int baseunitIndex = this.rowMeta.getFieldIndex("baseunit");
        int subbaseunitIndex = this.rowMeta.getFieldIndex("subbaseunit");
        if (targetRow != null && row != null) {
            targetRow.set(costcenternumberIndex, (Object)row.getString(costcenternumberIndex));
            targetRow.set(expenseitemnumberIndex, (Object)row.getString(expenseitemnumberIndex));
            targetRow.set(subcostcenternumberIndex, (Object)row.getString(subcostcenternumberIndex));
            targetRow.set(periodorderIndex, (Object)row.getLong(periodorderIndex));
            targetRow.set(manuorgnumberIndex, (Object)row.getString(manuorgnumberIndex));
            targetRow.set(seqIndex, (Object)this.seq);
            targetRow.set(expenseitemIndex, (Object)this.sumTitle);
            targetRow.set(baseunitIndex, (Object)0L);
            targetRow.set(subbaseunitIndex, (Object)0L);
            collector.collect(targetRow);
        }
    }

    private BigDecimal addData(BigDecimal a, BigDecimal b) {
        BigDecimal sum = BigDecimal.ZERO;
        if (a != null) {
            sum = sum.add(a);
        }
        if (b != null) {
            sum = sum.add(b);
        }
        return sum;
    }
}

