/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.algox.utils.DatSetXUtils;

public class MfgCsReportDealBenefDataFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, new String[]{"benefcostcenternumber asc", "elementnumber asc", "subelementnumber asc"}, this.sourceRowMeta);
        int seq = 0;
        ArrayList<RowX> colRows = new ArrayList<RowX>(16);
        boolean isShowMain = true;
        BigDecimal allocAmt = BigDecimal.ZERO;
        boolean confirm = false;
        while (ds.hasNext()) {
            Row row = ds.next();
            colRows.add(this.transferRow(row, isShowMain, seq));
            isShowMain = false;
            ++seq;
            allocAmt = allocAmt.add(this.getZeroValue(row, "allocamt"));
            if (!"2".equals(row.getString("allocstatus"))) continue;
            confirm = true;
        }
        if (!confirm) {
            ((RowX)colRows.get(0)).set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)this.getZeroValue((RowX)colRows.get(0), "collectamt").subtract(allocAmt));
        }
        this.addSumRow(colRows, seq);
        for (int i = 0; i < colRows.size(); ++i) {
            collector.collect((RowX)colRows.get(i));
        }
    }

    private RowX transferRow(Row row, boolean isShowMain, int seq) {
        RowX targetRow = new RowX(this.sourceRowMeta.getFieldCount());
        targetRow.set(this.sourceRowMeta.getFieldIndex("org"), row.get(this.sourceRowMeta.getFieldIndex("org")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("account"), row.get(this.sourceRowMeta.getFieldIndex("account")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("costdriver"), row.get(this.sourceRowMeta.getFieldIndex("costdriver")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("period"), row.get(this.sourceRowMeta.getFieldIndex("period")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorg"), row.get(this.sourceRowMeta.getFieldIndex("manuorg")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("costcenter"), row.get(this.sourceRowMeta.getFieldIndex("costcenter")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("costcenternumber"), row.get(this.sourceRowMeta.getFieldIndex("costcenternumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("costcentername"), row.get(this.sourceRowMeta.getFieldIndex("costcentername")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("baseunit"), row.get(this.sourceRowMeta.getFieldIndex("baseunit")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocstatus"), row.get(this.sourceRowMeta.getFieldIndex("allocstatus")));
        if (isShowMain) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitem"), row.get(this.sourceRowMeta.getFieldIndex("expenseitem")));
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemnumber")));
            targetRow.set(this.sourceRowMeta.getFieldIndex("collectamt"), row.get(this.sourceRowMeta.getFieldIndex("collectamt")));
        } else {
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitem"), row.get(this.sourceRowMeta.getFieldIndex("expenseitem")));
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemnumber")));
            this.setRowVal(targetRow, null, "collectamt", true);
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorgnumber"), row.get(this.sourceRowMeta.getFieldIndex("manuorgnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("benefcostcenter"), row.get(this.sourceRowMeta.getFieldIndex("benefcostcenter")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("benefcostcenternumber"), row.get(this.sourceRowMeta.getFieldIndex("benefcostcenternumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitem"), row.get(this.sourceRowMeta.getFieldIndex("targetexpenseitem")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocamt"), row.get(this.sourceRowMeta.getFieldIndex("allocamt")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("qty"), row.get(this.sourceRowMeta.getFieldIndex("qty")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("periodOrder"), row.get(this.sourceRowMeta.getFieldIndex("periodOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemOrder"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("seq"), (Object)seq);
        return targetRow;
    }

    private void addSumRow(List<RowX> colRows, int seq) {
        BigDecimal collectamt = BigDecimal.ZERO;
        BigDecimal allocamt = BigDecimal.ZERO;
        String allocStatus = "";
        for (RowX row : colRows) {
            collectamt = collectamt.add(this.getZeroValue(row, "collectamt"));
            allocamt = allocamt.add(this.getZeroValue(row, "allocamt"));
            allocStatus = row.getString(this.sourceRowMeta.getFieldIndex("allocstatus"));
        }
        RowX targetRow = new RowX(this.sourceRowMeta.getFieldCount());
        this.setRowVal(targetRow, null, "period", true);
        this.setRowVal(targetRow, null, "manuorg", true);
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorgnumber"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("manuorgnumber")));
        this.setRowVal(targetRow, null, "expenseitem", true);
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MfgCsReportDealBenefDataFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        this.setRowVal(targetRow, null, "targetexpenseitem", true);
        this.setRowVal(targetRow, null, "targetexpenseitemnumber", true);
        targetRow.set(this.sourceRowMeta.getFieldIndex("collectamt"), (Object)collectamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocamt"), (Object)allocamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocstatus"), (Object)allocStatus);
        if (!"2".equals(allocStatus)) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)collectamt.subtract(allocamt));
        } else {
            targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)BigDecimal.ZERO);
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("periodOrder"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("periodOrder")));
        int index = this.getSourceRowMeta().getFieldIndex("costcenternumber", false);
        if (index >= 0) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("costcenternumber"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("costcenternumber")));
        } else {
            targetRow.set(this.sourceRowMeta.getFieldIndex("costcenternumber"), (Object)"");
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemOrder"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("expenseitemOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("seq"), (Object)seq);
        colRows.add(targetRow);
    }

    private void setRowVal(RowX targetRow, Row sourceRow, String fieldName, boolean isDefaultVal) {
        int index = this.getSourceRowMeta().getFieldIndex(fieldName, false);
        if (index >= 0) {
            if (!isDefaultVal) {
                targetRow.set(index, sourceRow.get(this.sourceRowMeta.getFieldIndex(fieldName)));
            } else {
                DataType dataType = this.getSourceRowMeta().getDataType(index);
                if (DataType.LongType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0L);
                } else if (DataType.StringType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)" ");
                } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)BigDecimal.ZERO);
                } else if (DataType.IntegerType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0);
                }
            }
        }
    }

    private BigDecimal getZeroValue(Row row, String allocAmt) {
        BigDecimal amt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(allocAmt));
        if (amt == null) {
            return BigDecimal.ZERO;
        }
        return amt;
    }

    private BigDecimal getZeroValue(RowX row, String allocAmt) {
        BigDecimal amt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(allocAmt));
        if (amt == null) {
            return BigDecimal.ZERO;
        }
        return amt;
    }
}

