/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.algox.utils.DatSetXUtils;

public class MfgCsReportDealDataFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private boolean isSum = false;
    private boolean centerSum = false;
    private String[] orderBys = new String[]{"expenseitemnumber asc"};

    public MfgCsReportDealDataFunction() {
    }

    public MfgCsReportDealDataFunction(boolean isSum, boolean centerSum) {
        this.isSum = isSum;
        this.centerSum = centerSum;
    }

    public MfgCsReportDealDataFunction(boolean isSum, String[] orderBys, boolean centerSum) {
        this.isSum = isSum;
        this.orderBys = orderBys;
        this.centerSum = centerSum;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, this.orderBys, this.sourceRowMeta);
        int seq = 0;
        ArrayList<RowX> colRows = new ArrayList<RowX>(16);
        boolean isShowMain = true;
        BigDecimal sum = BigDecimal.ZERO;
        while (ds.hasNext()) {
            Row row = ds.next();
            if (this.isSum) {
                sum = sum.add(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("allocamt")));
            }
            colRows.add(this.transferRow(row, isShowMain, seq));
            isShowMain = false;
            ++seq;
        }
        if (this.isSum) {
            ((RowX)colRows.get(0)).set(this.sourceRowMeta.getFieldIndex("allocamt"), (Object)sum);
        }
        this.addSumRow(colRows, seq);
        for (int i = 0; i < colRows.size(); ++i) {
            collector.collect((RowX)colRows.get(i));
        }
    }

    private RowX transferRow(Row row, boolean isShowMain, int seq) {
        RowX targetRow = new RowX(this.sourceRowMeta.getFieldCount());
        targetRow.set(this.sourceRowMeta.getFieldIndex("org"), row.get(this.sourceRowMeta.getFieldIndex("org")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("account"), row.get(this.sourceRowMeta.getFieldIndex("account")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("costdriver"), row.get(this.sourceRowMeta.getFieldIndex("costdriver")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("period"), row.get(this.sourceRowMeta.getFieldIndex("period")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorg"), row.get(this.sourceRowMeta.getFieldIndex("manuorg")));
        this.setRowVal(targetRow, row, "costcenter");
        this.setRowVal(targetRow, row, "costcenternumber");
        this.setRowVal(targetRow, row, "costcentername");
        targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("collectamt")).subtract(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("allocamt"))));
        if (isShowMain) {
            this.setRowVal(targetRow, row, "benefcostcenter");
            this.setRowVal(targetRow, row, "benefcostcenternumber");
            targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitem"), row.get(this.sourceRowMeta.getFieldIndex("targetexpenseitem")));
            targetRow.set(this.sourceRowMeta.getFieldIndex("allocamt"), row.get(this.sourceRowMeta.getFieldIndex("allocamt")));
        } else {
            this.setRowVal(targetRow, null, "benefcostcenter", true);
            this.setRowVal(targetRow, null, "benefcostcenternumber", true);
            this.setRowVal(targetRow, null, "targetexpenseitem", true);
            this.setRowVal(targetRow, null, "allocamt", true);
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitem"), row.get(this.sourceRowMeta.getFieldIndex("expenseitem")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("collectamt"), row.get(this.sourceRowMeta.getFieldIndex("collectamt")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("qty"), row.get(this.sourceRowMeta.getFieldIndex("qty")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorgnumber"), row.get(this.sourceRowMeta.getFieldIndex("manuorgnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("periodOrder"), row.get(this.sourceRowMeta.getFieldIndex("periodOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemOrder"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("seq"), (Object)seq);
        return targetRow;
    }

    private void setRowVal(RowX targetRow, Row sourceRow, String fieldName) {
        this.setRowVal(targetRow, sourceRow, fieldName, false);
    }

    private void setRowVal(RowX targetRow, Row sourceRow, String fieldName, boolean isDefaultVal) {
        int index = this.getSourceRowMeta().getFieldIndex(fieldName, false);
        if (index >= 0) {
            if (!isDefaultVal) {
                targetRow.set(index, sourceRow.get(this.sourceRowMeta.getFieldIndex(fieldName)));
            } else {
                DataType dataType = this.getSourceRowMeta().getDataType(index);
                if (DataType.LongType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0L);
                } else if (DataType.StringType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)" ");
                } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)BigDecimal.ZERO);
                } else if (DataType.IntegerType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0);
                }
            }
        }
    }

    private void addSumRow(List<RowX> colRows, int seq) {
        BigDecimal collectamt = BigDecimal.ZERO;
        BigDecimal allocamt = BigDecimal.ZERO;
        for (RowX row : colRows) {
            collectamt = collectamt.add(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("collectamt")));
            allocamt = allocamt.add(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("allocamt")));
        }
        RowX targetRow = new RowX(this.sourceRowMeta.getFieldCount());
        this.setRowVal(targetRow, null, "period", true);
        this.setRowVal(targetRow, null, "manuorg", true);
        this.setRowVal(targetRow, null, "costcenter", true);
        this.setRowVal(targetRow, null, "expenseitem", true);
        if (this.centerSum) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("costcentername"), (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MfgCsReportDealDataFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        } else {
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MfgCsReportDealDataFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        }
        this.setRowVal(targetRow, null, "benefcostcenter", true);
        this.setRowVal(targetRow, null, "benefcostcenternumber", true);
        this.setRowVal(targetRow, null, "targetexpenseitem", true);
        targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("collectamt"), (Object)collectamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocamt"), (Object)allocamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)collectamt.subtract(allocamt));
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorgnumber"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("manuorgnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("periodOrder"), colRows.get(0).get(this.sourceRowMeta.getFieldIndex("periodOrder")));
        int costcenterIndex = this.getSourceRowMeta().getFieldIndex("costcenternumber", false);
        if (costcenterIndex >= 0) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("costcenternumber"), colRows.get(colRows.size() - 1).get(this.sourceRowMeta.getFieldIndex("costcenternumber")));
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemOrder"), colRows.get(colRows.size() - 1).get(this.sourceRowMeta.getFieldIndex("expenseitemOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("seq"), (Object)seq);
        colRows.add(targetRow);
    }
}

