/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.algox.utils.DatSetXUtils;

public class MfgCsReportDealPeriodSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private int seq;
    private boolean centerSum = false;
    private String sumtip = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MfgCsReportDealPeriodSumFunction_0", (String)"macc-cad-algox", (Object[])new Object[0]);
    private String[] orderbys = new String[]{"periodOrder asc", "manuorgnumber asc", "costcenternumber asc", "elementnumber asc", "subelementnumber asc", "expenseitemOrder asc"};

    public MfgCsReportDealPeriodSumFunction(String sumtip, int seq) {
        this.sumtip = sumtip;
        this.seq = seq;
    }

    public MfgCsReportDealPeriodSumFunction(String sumtip, int seq, String[] orderbys) {
        this.sumtip = sumtip;
        this.seq = seq;
        this.orderbys = orderbys;
    }

    public MfgCsReportDealPeriodSumFunction(String sumtip, int seq, String[] orderbys, boolean centerSum) {
        this.sumtip = sumtip;
        this.seq = seq;
        this.orderbys = orderbys;
        this.centerSum = centerSum;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        boolean containsUnAbsortField = this.isContainsUnAbsortField();
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, this.orderbys, this.sourceRowMeta);
        Row row = null;
        BigDecimal collectamt = BigDecimal.ZERO;
        BigDecimal allocamt = BigDecimal.ZERO;
        BigDecimal unAbsortAmt = BigDecimal.ZERO;
        while (ds.hasNext()) {
            row = ds.next();
            collectamt = collectamt.add(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("collectamt")));
            allocamt = allocamt.add(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("allocamt")));
            if (!containsUnAbsortField) continue;
            BigDecimal amt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("unabsorbeddiff")) == null ? BigDecimal.ZERO : row.getBigDecimal(this.sourceRowMeta.getFieldIndex("unabsorbeddiff"));
            unAbsortAmt = unAbsortAmt.add(amt);
        }
        if (row == null) {
            return;
        }
        RowX targetRow = new RowX(this.sourceRowMeta.getFieldCount());
        this.setRowVal(targetRow, null, "period", true);
        this.setRowVal(targetRow, null, "manuorg", true);
        this.setRowVal(targetRow, null, "expenseitem", true);
        this.setRowVal(targetRow, null, "targetexpenseitem", true);
        targetRow.set(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber"), row.get(this.sourceRowMeta.getFieldIndex("targetexpenseitemnumber")));
        if (this.centerSum) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("costcentername"), (Object)this.sumtip);
        } else {
            targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemnumber"), (Object)this.sumtip);
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("collectamt"), (Object)collectamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocamt"), (Object)allocamt);
        targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)collectamt.subtract(allocamt));
        if (containsUnAbsortField) {
            targetRow.set(this.sourceRowMeta.getFieldIndex("unabsorbeddiff"), (Object)unAbsortAmt);
            if (BigDecimal.ZERO.compareTo(unAbsortAmt) != 0) {
                targetRow.set(this.sourceRowMeta.getFieldIndex("unallocamt"), (Object)collectamt);
            }
        }
        targetRow.set(this.sourceRowMeta.getFieldIndex("periodOrder"), row.get(this.sourceRowMeta.getFieldIndex("periodOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("manuorgnumber"), row.get(this.sourceRowMeta.getFieldIndex("manuorgnumber")));
        this.setRowVal(targetRow, row, "costcenternumber", false);
        targetRow.set(this.sourceRowMeta.getFieldIndex("expenseitemOrder"), row.get(this.sourceRowMeta.getFieldIndex("expenseitemOrder")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("elementnumber"), row.get(this.sourceRowMeta.getFieldIndex("elementnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("subelementnumber"), row.get(this.sourceRowMeta.getFieldIndex("subelementnumber")));
        targetRow.set(this.sourceRowMeta.getFieldIndex("seq"), (Object)this.seq);
        targetRow.set(this.sourceRowMeta.getFieldIndex("allocstatus"), (Object)row.getString("allocstatus"));
        collector.collect(targetRow);
    }

    private void setRowVal(RowX targetRow, Row sourceRow, String fieldName, boolean isDefaultVal) {
        int index = this.getSourceRowMeta().getFieldIndex(fieldName, false);
        if (index >= 0) {
            if (!isDefaultVal) {
                targetRow.set(index, sourceRow.get(this.sourceRowMeta.getFieldIndex(fieldName)));
            } else {
                DataType dataType = this.getSourceRowMeta().getDataType(index);
                if (DataType.LongType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0L);
                } else if (DataType.StringType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)" ");
                } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)BigDecimal.ZERO);
                } else if (DataType.IntegerType.equals((Object)dataType)) {
                    targetRow.set(index, (Object)0);
                }
            }
        }
    }

    private boolean isContainsUnAbsortField() {
        String[] fieldNames;
        for (String fieldName : fieldNames = this.getSourceRowMeta().getFieldNames()) {
            if (!"unabsorbeddiff".equals(fieldName)) continue;
            return true;
        }
        return false;
    }
}

