/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MfgFeeAuxProdImporterFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MfgFeeAuxProdImporterFunction.class);
    private static final String MFG_REFER_UPDATE_SQL = "update %s set freferidentity=? where fid = ?";
    private RowMeta rowMeta = null;
    private Map<String, Object> paramMap = null;
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});

    public MfgFeeAuxProdImporterFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        String entityType = this.paramMap.get("entitytype").toString();
        BigDecimal sum = BigDecimal.ZERO;
        HashSet<Long> colids = new HashSet<Long>(16);
        HashSet<Long> nonPids = new HashSet<Long>(16);
        RowX row1 = null;
        HashMap<Long, BigDecimal> expenseitemAmtMap = new HashMap<Long, BigDecimal>(16);
        DynamicObject dynObj = null;
        for (RowX row : rows) {
            if (row1 == null) {
                row1 = row;
            }
            if ("feebill".equals(row.getString(this.rowMeta.getFieldIndex("type")))) {
                colids.add(row.getLong(this.rowMeta.getFieldIndex("id")));
            } else {
                nonPids.add(row.getLong(this.rowMeta.getFieldIndex("id")));
            }
            BigDecimal totalamount = row.getBigDecimal(this.rowMeta.getFieldIndex("totalamount"));
            sum = sum.add(totalamount);
            Long expenseitem = row.getLong(this.rowMeta.getFieldIndex("expenseitem"));
            BigDecimal exAmt = expenseitemAmtMap.computeIfAbsent(expenseitem, t -> BigDecimal.ZERO);
            expenseitemAmtMap.put(expenseitem, exAmt.add(totalamount));
        }
        if (BigDecimal.ZERO.compareTo(sum) == 0 && "cad_planauxprodalloc".equals(entityType)) {
            this.updateMfgFeeBillReferIndentity(colids, "cad_mfgfeebill");
            return;
        }
        if (row1 == null) {
            return;
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        dynObj = this.getDynObjFromRow(row1, sum, colids, nonPids, expenseitemAmtMap, entityType);
        LOG.info(String.format("\u6210\u672c\u4e2d\u5fc3\uff1a%1$s,\u5f52\u96c6\u91d1\u989d\uff1a%2$s", row1.getLong(this.rowMeta.getFieldIndex("costcenter")), sum));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    protected void updateMfgFeeBillReferIndentity(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("freferidentity", 1, (Object)Character.valueOf('1')), new SqlParameter("fid", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(MFG_REFER_UPDATE_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    private DynamicObject getDynObjFromRow(RowX row, BigDecimal amount, Set<Long> colids, Set<Long> nonPids, Map<Long, BigDecimal> expenseitemAmtMap, String entityType) {
        DynamicObject obj;
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long orgId = row.getLong(this.rowMeta.getFieldIndex("org"));
        DynamicObject auxProdAllocDyn = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)entityType, (DynamicObject)auxProdAllocDyn, (String)orgId.toString(), (int)1);
        if (batchNumber != null && batchNumber.length > 0) {
            auxProdAllocDyn.set("billno", (Object)batchNumber[0]);
        } else {
            auxProdAllocDyn.set("billno", (Object)ID.genStringId());
        }
        auxProdAllocDyn.set("org", (Object)orgId);
        auxProdAllocDyn.set("costaccount", (Object)row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        auxProdAllocDyn.set("manuorg", (Object)row.getLong(this.rowMeta.getFieldIndex("manuorg")));
        auxProdAllocDyn.set("period", (Object)row.getLong(this.rowMeta.getFieldIndex("period")));
        auxProdAllocDyn.set("costcenter", (Object)row.getLong(this.rowMeta.getFieldIndex("costcenter")));
        auxProdAllocDyn.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        auxProdAllocDyn.set("allocmold", (Object)"B");
        auxProdAllocDyn.set("planscheme", this.paramMap.get("planscheme"));
        String allocmethod = row.getString(this.rowMeta.getFieldIndex("allocmethod"));
        if (StringUtils.isEmpty((CharSequence)allocmethod)) {
            allocmethod = "direct";
        }
        if ("true".equals(this.paramMap.get("publicaux").toString())) {
            allocmethod = "";
        }
        auxProdAllocDyn.set("allocmethod", (Object)allocmethod);
        DynamicObjectCollection srcbillentry = auxProdAllocDyn.getDynamicObjectCollection("srcbillentry");
        int i = 0;
        for (Long id : colids) {
            obj = srcbillentry.addNew();
            obj.set("seq", (Object)(++i));
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"A");
        }
        for (Long id : nonPids) {
            obj = srcbillentry.addNew();
            obj.set("seq", (Object)(++i));
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"B");
        }
        Long expenseitem = row.getLong(this.rowMeta.getFieldIndex("expenseitemstd"));
        Long costdriver = row.getLong(this.rowMeta.getFieldIndex("costdriver"));
        Long unit = row.getLong(this.rowMeta.getFieldIndex("unit"));
        DynamicObjectCollection comentity = auxProdAllocDyn.getDynamicObjectCollection("comentity");
        DynamicObject comentitySub = comentity.addNew();
        comentitySub.set("seq", (Object)1);
        comentitySub.set("expenseitem", (Object)expenseitem);
        comentitySub.set("costdriver", (Object)costdriver);
        comentitySub.set("baseunit", (Object)unit);
        comentitySub.set("allocamount", (Object)amount);
        DynamicObjectCollection parallelentity = auxProdAllocDyn.getDynamicObjectCollection("parallelentity");
        i = 0;
        Long mainId = ID.genLongId();
        for (Map.Entry<Long, BigDecimal> entry : expenseitemAmtMap.entrySet()) {
            DynamicObject parallelentitySub = parallelentity.addNew();
            if ("mutual".equals(allocmethod) || "algebra".equals(allocmethod)) {
                if (i == 0) {
                    parallelentitySub.set("id", (Object)mainId);
                } else {
                    parallelentitySub.set("pid", (Object)mainId);
                }
            }
            parallelentitySub.set("seq", (Object)(++i));
            parallelentitySub.set("parexpenseitem", (Object)entry.getKey());
            parallelentitySub.set("parcostdriver", (Object)costdriver);
            parallelentitySub.set("parbaseunit", (Object)unit);
            parallelentitySub.set("parallocamount", (Object)entry.getValue());
        }
        auxProdAllocDyn.set("publicaux", this.paramMap.get("publicaux"));
        auxProdAllocDyn.set("billstatus", (Object)"A");
        auxProdAllocDyn.set("allocstatus", (Object)"0");
        auxProdAllocDyn.set("createtime", (Object)date);
        auxProdAllocDyn.set("creator_id", (Object)userId);
        auxProdAllocDyn.set("appnum", this.paramMap.get("appnum"));
        return auxProdAllocDyn;
    }
}

