/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class MfgFeeInnerCostcenterImporterFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MfgFeeInnerCostcenterImporterFunction.class);
    private static final String MFG_REFER_UPDATE_SQL = "update %s set freferidentity=? where fid = ?";
    private RowMeta rowMeta = null;
    private Map<String, Object> paramMap = null;
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});

    public MfgFeeInnerCostcenterImporterFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        BigDecimal sum = BigDecimal.ZERO;
        HashSet<Long> colids = new HashSet<Long>(16);
        RowX row1 = null;
        ArrayList<Object[]> expArrList = new ArrayList<Object[]>();
        HashMap<String, BigDecimal> expAmtMap = new HashMap<String, BigDecimal>();
        DynamicObject dynObj = null;
        for (RowX row : rows) {
            if (row1 == null) {
                row1 = row;
            }
            Object[] expArr = new Object[4];
            String type = row.getString(this.rowMeta.getFieldIndex("type"));
            Long id = row.getLong(this.rowMeta.getFieldIndex("id"));
            Long expenseitem = row.getLong(this.rowMeta.getFieldIndex("expenseitem"));
            BigDecimal totalamount = row.getBigDecimal(this.rowMeta.getFieldIndex("totalamount"));
            String colSrcType = null;
            colSrcType = "feebill".equals(type) ? "A" : ("nonprod".equals(type) ? "C" : ("aux".equals(type) ? "D" : "E"));
            String key = String.format("%s@%s", colSrcType, expenseitem);
            if (expAmtMap.containsKey(key)) {
                expAmtMap.put(key, ((BigDecimal)expAmtMap.get(key)).add(totalamount));
            } else {
                expAmtMap.put(key, totalamount);
            }
            switch (type) {
                case "feebill": {
                    colids.add(id);
                    expArr[2] = "A";
                    break;
                }
                case "nonprod": {
                    expArr[2] = "B";
                    break;
                }
                case "aux": {
                    expArr[2] = "C";
                    break;
                }
                default: {
                    expArr[2] = StringUtils.equals((String)type, (String)"basic") ? "D" : "E";
                }
            }
            expArr[0] = expenseitem;
            expArr[1] = totalamount;
            expArr[3] = id;
            sum = sum.add(totalamount);
            expArrList.add(expArr);
        }
        if (BigDecimal.ZERO.compareTo(sum) == 0) {
            this.updateMfgFeeBillReferIndentity(colids, "cad_mfgfeebill");
            return;
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        dynObj = this.getDynObjFromRow(row1, sum, expArrList, expAmtMap);
        if (row1 != null) {
            LOG.info(String.format("\u6210\u672c\u4e2d\u5fc3\uff1a%1$s,\u5f52\u96c6\u91d1\u989d\uff1a%2$s", row1.getLong(this.rowMeta.getFieldIndex("costcenter")), sum));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    protected void updateMfgFeeBillReferIndentity(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("freferidentity", 1, (Object)Character.valueOf('1')), new SqlParameter("fid", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(MFG_REFER_UPDATE_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    private DynamicObject getDynObjFromRow(RowX row, BigDecimal amount, List<Object[]> expArrList, Map<String, BigDecimal> expAmtMap) {
        boolean isMergeBill;
        String[] split;
        Long orgId;
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject innerCSDyn = BusinessDataServiceHelper.newDynamicObject((String)"cad_mfgfeeallocco");
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_mfgfeeallocco", (DynamicObject)innerCSDyn, (String)(orgId = row.getLong(this.rowMeta.getFieldIndex("org"))).toString(), (int)1);
        if (batchNumber != null && batchNumber.length > 0) {
            innerCSDyn.set("billno", (Object)batchNumber[0]);
        } else {
            innerCSDyn.set("billno", (Object)ID.genStringId());
        }
        innerCSDyn.set("org", (Object)orgId);
        innerCSDyn.set("costaccount", (Object)row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        innerCSDyn.set("manuorg", (Object)row.getLong(this.rowMeta.getFieldIndex("manuorg")));
        innerCSDyn.set("period", (Object)row.getLong(this.rowMeta.getFieldIndex("period")));
        innerCSDyn.set("allocmold", (Object)"D");
        innerCSDyn.set("productgroup", (Object)row.getLong(this.rowMeta.getFieldIndex("productgroup")));
        innerCSDyn.set("benefcostcenter", (Object)row.getLong(this.rowMeta.getFieldIndex("costcenter")));
        innerCSDyn.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        innerCSDyn.set("costdriver", (Object)row.getLong(this.rowMeta.getFieldIndex("costdriver")));
        innerCSDyn.set("element", (Object)row.getLong(this.rowMeta.getFieldIndex("element")));
        innerCSDyn.set("subelement", (Object)row.getLong(this.rowMeta.getFieldIndex("subelement")));
        String allocDim = row.getString(this.rowMeta.getFieldIndex("allocdim"));
        if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
            for (String string : split) {
                if (CadEmptyUtils.isEmpty((String)string)) continue;
                innerCSDyn.set(string, row.get(this.rowMeta.getFieldIndex(string)));
            }
        }
        if (!(isMergeBill = ((Boolean)this.paramMap.get("isMergeBill")).booleanValue())) {
            innerCSDyn.set("allocexpenseitem", (Object)row.getLong(this.rowMeta.getFieldIndex("expenseitem")));
        }
        innerCSDyn.set("amount", (Object)amount);
        int i = 0;
        DynamicObjectCollection comexpentry = innerCSDyn.getDynamicObjectCollection("comexpentry");
        i = 0;
        for (Map.Entry<String, BigDecimal> entry : expAmtMap.entrySet()) {
            DynamicObject obj = comexpentry.addNew();
            String key = entry.getKey();
            String[] vals = key.split("@");
            obj.set("seq", (Object)(++i));
            obj.set("srcexpenseitem", (Object)Long.valueOf(vals[1]));
            obj.set("srcamt", (Object)entry.getValue());
            obj.set("colsrctype", (Object)vals[0]);
        }
        DynamicObjectCollection srcexpentry = innerCSDyn.getDynamicObjectCollection("srcexpentry");
        i = 0;
        for (Object[] expArr : expArrList) {
            DynamicObject dynObj = srcexpentry.addNew();
            dynObj.set("seq", (Object)(++i));
            dynObj.set("expenseitem", expArr[0]);
            dynObj.set("colamt", expArr[1]);
            dynObj.set("srctype", expArr[2]);
            dynObj.set("expbillid", expArr[3]);
        }
        Long l = row.getLong(this.rowMeta.getFieldIndex("costobject"));
        Long materialId = row.getLong(this.rowMeta.getFieldIndex("material"));
        if (l != null && l > 0L) {
            DynamicObjectCollection entryentity = innerCSDyn.getDynamicObjectCollection("entryentity");
            DynamicObject obj = entryentity.addNew();
            obj.set("seq", (Object)1);
            obj.set("material", (Object)materialId);
            obj.set("costobject", (Object)l);
            obj.set("allocamt", (Object)amount);
            String outSourceType = row.getString(this.rowMeta.getFieldIndex("outsourcetype"));
            if (StringUtils.isBlank((String)outSourceType)) {
                Boolean isOutSource = row.getBoolean(this.rowMeta.getFieldIndex("isoutsource"));
                if (isOutSource.booleanValue()) {
                    obj.set("outsourcetype", (Object)"C");
                }
            } else {
                obj.set("outsourcetype", (Object)outSourceType);
            }
            innerCSDyn.set("billstatus", (Object)"A");
            innerCSDyn.set("allocstatus", (Object)"1");
            innerCSDyn.set("createtime", (Object)date);
            innerCSDyn.set("creator_id", (Object)userId);
            innerCSDyn.set("alloctype", (Object)"1");
            innerCSDyn.set("allocor", (Object)userId);
            innerCSDyn.set("alloctime", (Object)date);
            innerCSDyn.set("auditor", (Object)userId);
            innerCSDyn.set("auditdate", (Object)date);
            innerCSDyn.set("directalloc", (Object)true);
            innerCSDyn.set("costdriver", (Object)0L);
        } else {
            innerCSDyn.set("billstatus", (Object)"A");
            innerCSDyn.set("allocstatus", (Object)"0");
            innerCSDyn.set("createtime", (Object)date);
            innerCSDyn.set("creator_id", (Object)userId);
        }
        innerCSDyn.set("appnum", this.paramMap.get("appnum"));
        return innerCSDyn;
    }
}

