/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeNonProdImporterFunction
extends GroupReduceFunction {
    private static final Log LOG = LogFactory.getLog(MfgFeeNonProdImporterFunction.class);
    private static final String MFG_REFER_UPDATE_SQL = "update %s set freferidentity=? where fid = ?";
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;
    private Map<String, Object> paramMap = null;
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("row", (DataType)DataType.IntegerType)});

    public MfgFeeNonProdImporterFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        String entityType = this.paramMap.get("entitytype").toString();
        BigDecimal sum = BigDecimal.ZERO;
        HashSet<Long> colids = new HashSet<Long>(16);
        RowX row1 = null;
        DynamicObject dynObj = null;
        for (RowX row : rows) {
            if (row1 == null) {
                row1 = row;
            }
            colids.add(row.getLong(this.rowMeta.getFieldIndex("id")));
            sum = sum.add(row.getBigDecimal(this.rowMeta.getFieldIndex("totalamount")));
        }
        if (BigDecimal.ZERO.compareTo(sum) == 0) {
            if (!"cad_plannonprodalloc".equals(entityType)) {
                this.updateMfgFeeBillReferIndentity(colids, "cad_mfgfeebill");
            }
            return;
        }
        if (row1 == null) {
            return;
        }
        RowX colRow = new RowX(1);
        colRow.set(0, (Object)1);
        collector.collect(colRow);
        dynObj = this.getDynObjFromRow(row1, sum, colids, entityType);
        LOG.info(String.format("\u6210\u672c\u4e2d\u5fc3\uff1a%1$s,\u5f52\u96c6\u91d1\u989d\uff1a%2$s", row1.getLong(this.rowMeta.getFieldIndex("costcenter")), sum));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    protected void updateMfgFeeBillReferIndentity(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("freferidentity", 1, (Object)Character.valueOf('1')), new SqlParameter("fid", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(MFG_REFER_UPDATE_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    private DynamicObject getDynObjFromRow(RowX row, BigDecimal amount, Set<Long> colids, String entityType) {
        String[] split;
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long orgId = row.getLong(this.rowMeta.getFieldIndex("org"));
        DynamicObject nonProdAllocDyn = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)entityType, (DynamicObject)nonProdAllocDyn, (String)orgId.toString(), (int)1);
        if (batchNumber != null && batchNumber.length > 0) {
            nonProdAllocDyn.set("billno", (Object)batchNumber[0]);
        } else {
            nonProdAllocDyn.set("billno", (Object)ID.genStringId());
        }
        nonProdAllocDyn.set("org", (Object)orgId);
        nonProdAllocDyn.set("costaccount", (Object)row.getLong(this.rowMeta.getFieldIndex("costaccount")));
        nonProdAllocDyn.set("manuorg", (Object)row.getLong(this.rowMeta.getFieldIndex("manuorg")));
        nonProdAllocDyn.set("period", (Object)row.getLong(this.rowMeta.getFieldIndex("period")));
        nonProdAllocDyn.set("costcenter", (Object)row.getLong(this.rowMeta.getFieldIndex("costcenter")));
        nonProdAllocDyn.set("currency", (Object)row.getLong(this.rowMeta.getFieldIndex("currency")));
        nonProdAllocDyn.set("expenseitem", (Object)row.getLong(this.rowMeta.getFieldIndex("expenseitem")));
        nonProdAllocDyn.set("allocmold", (Object)"A");
        nonProdAllocDyn.set("amount", (Object)amount);
        nonProdAllocDyn.set("costdriver", (Object)row.getLong(this.rowMeta.getFieldIndex("costdriver")));
        nonProdAllocDyn.set("baseunit", (Object)row.getLong(this.rowMeta.getFieldIndex("unit")));
        String allocDim = row.getString(this.rowMeta.getFieldIndex("allocdim"));
        if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
            for (String arr : split) {
                if (CadEmptyUtils.isEmpty((String)arr)) continue;
                nonProdAllocDyn.set(arr, row.get(this.rowMeta.getFieldIndex(arr)));
            }
        }
        DynamicObjectCollection srcbillentry = nonProdAllocDyn.getDynamicObjectCollection("srcbillentry");
        int i = 0;
        for (Long id : colids) {
            DynamicObject obj = srcbillentry.addNew();
            obj.set("seq", (Object)i++);
            obj.set("srcbill", (Object)id);
            obj.set("type", (Object)"A");
        }
        nonProdAllocDyn.set("billstatus", (Object)"A");
        nonProdAllocDyn.set("allocstatus", (Object)"0");
        nonProdAllocDyn.set("createtime", (Object)date);
        nonProdAllocDyn.set("creator_id", (Object)userId);
        nonProdAllocDyn.set("appnum", this.paramMap.get("appnum"));
        nonProdAllocDyn.set("planscheme", this.paramMap.get("planscheme"));
        return nonProdAllocDyn;
    }
}

