/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.macc.cad.algox.constants.CommonConstant;
import kd.macc.cad.algox.mfgfee.helper.WipCostCheckService;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.FormulaUtil;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;

public class MfgfeeAllocHelper {
    private static final Log logger = LogFactory.getLog(MfgfeeAllocHelper.class);
    private static Boolean saveCalcReport = false;

    public DataSet getStdValueNotDiy(Long orgId, Long costaccountId, Long periodId, String appId, Set<Long> costDriverIds, boolean planData, Long planschemeId) {
        if ("aca".equals(appId)) {
            return this.getAcaStdValueTypeOne(orgId, costaccountId, periodId, costDriverIds);
        }
        if ("sca".equals(appId)) {
            return this.getScaStdValueTypeOne(orgId, costaccountId, periodId, costDriverIds, planData, planschemeId);
        }
        return this.getEcaStdValueTypeOne(orgId, periodId);
    }

    private DataSet getEcaStdValueTypeOne(Long orgId, Long periodId) {
        String appId = "eca";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        DataSet resource = this.getResourceUse(appId, orgFilter, bookDateFilter, baseFilter, null, 0L, periodId, false, 0L);
        resource = resource.select("costdriver,org,manuorg,costcenter,value,0 as unit");
        return resource;
    }

    private DataSet getScaStdValueTypeOne(Long orgId, Long costaccountId, Long periodId, Set<Long> costDriverIds, boolean planData, Long planschemeId) {
        String appId = "sca";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter datefilter = this.getDatefilter(periodId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appId);
        boolean isNewAllocType = MfgfeeAllocHelper.isNewAllocType();
        if (isNewAllocType) {
            DataSet resource = this.getResourceUse(appId, orgfilter, bookDateFilter, basefilter, new ArrayList<Long>(costDriverIds), costaccountId, periodId, planData, planschemeId);
            resource = resource.select("costdriver,org,manuorg,costcenter,value,unit");
            DataSet allDs = null;
            DataSet allHour = null;
            if (CadEmptyUtils.isEmpty(costDriverIds)) {
                return resource;
            }
            for (Long costDriverId : costDriverIds) {
                switch (String.valueOf(costDriverId)) {
                    case "844089614712364032": {
                        DataSet finishInput = this.getFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, finishInput);
                        break;
                    }
                    case "1620330732428060672": {
                        DataSet reworkFinishInput = this.getIsreworkFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, reworkFinishInput);
                        break;
                    }
                    case "844089614712364033": {
                        DataSet outFinishInput = this.getOutFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outFinishInput);
                        break;
                    }
                    case "844090490004888583": {
                        DataSet assistFinishInput = this.getAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, assistFinishInput);
                        break;
                    }
                    case "844090490004888585": {
                        DataSet reWoAssistFinishInput = this.getReWoAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, reWoAssistFinishInput);
                        break;
                    }
                    case "844090490004888584": {
                        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outAssistFinishInput);
                        break;
                    }
                    case "844089929922698240": {
                        DataSet plannedOutput = this.getPlannedOutputOnCostCenter(accorgfilter, datefilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, plannedOutput);
                        break;
                    }
                    case "1919774047680688128": {
                        DataSet mfgStock = this.getMftStockOnCostCenter(orgfilter, datefilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, mfgStock);
                        break;
                    }
                    case "844090213742861312": {
                        DataSet onProduct = this.getOnProductOnCostCenter(accorgfilter, datefilter, basefilter, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, onProduct);
                        break;
                    }
                    case "1028144987130497024": {
                        if (allHour == null) {
                            allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet machineHour = this.getMachineHourOnCostCenter(allHour, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, machineHour);
                        break;
                    }
                    case "1028146107680647168": {
                        if (allHour == null) {
                            allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet humanHour = this.getHumanHourOnCostCenter(allHour, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, humanHour);
                        break;
                    }
                    case "1028146107680647169": {
                        if (allHour == null) {
                            allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet outHumanHour = this.getOutHumanHourOnCostCenter(allHour, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outHumanHour);
                        break;
                    }
                    case "1028146107680647170": {
                        if (allHour == null) {
                            allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet actualHour = this.getActualHourOnCostCenter(allHour, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, actualHour);
                        break;
                    }
                    case "1028146107680647171": {
                        if (allHour == null) {
                            allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet outActualHour = this.getOutActualHourOnCostCenter(allHour, appId);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outActualHour);
                        break;
                    }
                }
            }
            if (allDs != null) {
                allDs = allDs.addField("0", "unit");
                resource = resource.union(allDs);
            }
            return resource;
        }
        DataSet finishInput = this.getFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet outFinishInput = this.getOutFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet assistFinishInput = this.getAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet reWoAssistFinishInput = this.getReWoAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        ArrayList<DataSet> unionList = new ArrayList<DataSet>(10);
        this.addDataSet(unionList, outFinishInput);
        this.addDataSet(unionList, assistFinishInput);
        this.addDataSet(unionList, reWoAssistFinishInput);
        this.addDataSet(unionList, outAssistFinishInput);
        finishInput = finishInput.union(unionList.toArray(new DataSet[0]));
        DataSet plannedOutput = this.getPlannedOutputOnCostCenter(accorgfilter, datefilter, basefilter, appId);
        DataSet mftStock = this.getMftStockOnCostCenter(orgfilter, datefilter, basefilter, appId);
        DataSet onProduct = this.getOnProductOnCostCenter(accorgfilter, datefilter, basefilter, appId);
        DataSet allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
        DataSet machineHour = this.getMachineHourOnCostCenter(allHour, appId);
        DataSet humanHour = this.getHumanHourOnCostCenter(allHour, appId);
        DataSet outHumanHour = this.getOutHumanHourOnCostCenter(allHour, appId);
        humanHour = humanHour.union(outHumanHour);
        DataSet actualHour = this.getActualHourOnCostCenter(allHour, appId);
        DataSet outActualHour = this.getOutActualHourOnCostCenter(allHour, appId);
        actualHour = actualHour.union(outActualHour);
        DataSet reworkFinishInput = this.getIsreworkFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet resource = this.getResourceUse(appId, orgfilter, bookDateFilter, basefilter, null, costaccountId, periodId, false, 0L);
        resource = resource.select("costdriver,org,manuorg,costcenter,value,unit");
        ArrayList<DataSet> inputList = new ArrayList<DataSet>(10);
        this.addDataSet(inputList, reworkFinishInput);
        this.addDataSet(inputList, plannedOutput);
        this.addDataSet(inputList, mftStock);
        this.addDataSet(inputList, onProduct);
        this.addDataSet(inputList, machineHour);
        this.addDataSet(inputList, humanHour);
        this.addDataSet(inputList, actualHour);
        finishInput = finishInput.union(inputList.toArray(new DataSet[0])).addField("0", "unit");
        finishInput = finishInput.union(resource);
        return finishInput;
    }

    private static DataSet unionDs(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 == null) {
            return dataSet2;
        }
        if (dataSet2 == null) {
            return dataSet1;
        }
        DataSet result = dataSet1.union(dataSet2);
        return result;
    }

    private DataSet getActualHourOnCostCenter(DataSet allHour, String appId) {
        DataSet actualHour = allHour.filter("isoutsource = false");
        actualHour = actualHour.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        actualHour = MfgfeeAllocHelper.isSCA(appId) ? actualHour.select(CommonConstant.ACTUAL_HOUR_SCA + " as costdriver,org,manuorg,costcenter,value") : actualHour.select(CommonConstant.ACTUAL_HOUR_ACA + " as costdriver,org,manuorg,costcenter,value");
        return actualHour;
    }

    private DataSet getOutActualHourOnCostCenter(DataSet allHour, String appId) {
        DataSet outActualHour = allHour.filter("isoutsource = true");
        outActualHour = outActualHour.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        outActualHour = MfgfeeAllocHelper.isSCA(appId) ? outActualHour.select(CommonConstant.OUT_ACTUAL_HOUR_SCA + " as costdriver,org,manuorg,costcenter,value") : outActualHour.select(CommonConstant.OUT_ACTUAL_HOUR_ACA + " as costdriver,org,manuorg,costcenter,value");
        return outActualHour;
    }

    private DataSet getAllHourOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getAllHourOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        DataSet allHour = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)"resource,org,manuorg,costcenter,entryentity.workhour as workhour,entryentity.costobject.isoutsource isoutsource, entryentity.facthour as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        allHour = allHour.select("resource,org,manuorg,costcenter,workhour,isoutsource,case when workhour=10 then value*60 when workhour=8 then value/60 else value end value");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter seq = new QFilter("resourcesentryentity.seq", "=", (Object)1);
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_resources", (String)"id,resourcesentryentity.itemclasstype AS resType", (QFilter[])new QFilter[]{status, seq}, null);
        allHour = allHour.join(resourceDataSet, JoinType.INNER).on("resource", "id").select(allHour.getRowMeta().getFieldNames(), new String[]{"resType"}).finish();
        return allHour;
    }

    private DataSet getMachineHourOnCostCenter(DataSet allHour, String appId) {
        DataSet machineHour = allHour.filter("resType in ('mpdm_equipment','mpdm_toolsresource','mpdm_toolequip','mpdm_mould')");
        machineHour = machineHour.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        machineHour = MfgfeeAllocHelper.isSCA(appId) ? machineHour.select(CommonConstant.MACHINE_HOUR_SCA + " as costdriver,org,manuorg,costcenter,value") : machineHour.select(CommonConstant.MACHINE_HOUR_ACA + " as costdriver,org,manuorg,costcenter,value");
        return machineHour;
    }

    private DataSet getHumanHourOnCostCenter(DataSet allHour, String appId) {
        DataSet humanHour = allHour.filter("resType = 'mpdm_manuperson' and isoutsource = false");
        humanHour = humanHour.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        humanHour = MfgfeeAllocHelper.isSCA(appId) ? humanHour.select(CommonConstant.HUMAN_HOUR_SCA + " as costdriver,org,manuorg,costcenter,value") : humanHour.select(CommonConstant.HUMAN_HOUR_ACA + " as costdriver,org,manuorg,costcenter,value");
        return humanHour;
    }

    private DataSet getOutHumanHourOnCostCenter(DataSet allHour, String appId) {
        DataSet outHumanHour = allHour.filter("resType = 'mpdm_manuperson' and isoutsource = true");
        outHumanHour = outHumanHour.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        outHumanHour = MfgfeeAllocHelper.isSCA(appId) ? outHumanHour.select(CommonConstant.OUT_HUMAN_HOUR_SCA + " as costdriver,org,manuorg,costcenter,value") : outHumanHour.select(CommonConstant.OUT_HUMAN_HOUR_ACA + " as costdriver,org,manuorg,costcenter,value");
        return outHumanHour;
    }

    private DataSet getOnProductOnCostCenter(QFilter accorgfilter, QFilter datefilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getOnProductOnCostCenter";
        filters.add(accorgfilter);
        filters.add(datefilter);
        filters.add(basefilter);
        filters.add(new QFilter("costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5728\u4ea7\u54c1\u6570\u91cf" + ((Object)filters).toString());
        DataSet onProduct = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"accountorg as org,manuorg,costcenter,wipqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        onProduct = onProduct.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        onProduct = MfgfeeAllocHelper.isSCA(appId) ? onProduct.select(CommonConstant.ON_PRODUCT_SCA + " costdriver,org,manuorg,costcenter,value") : onProduct.select(CommonConstant.ON_PRODUCT_ACA + " costdriver,org,manuorg,costcenter,value");
        return onProduct;
    }

    private DataSet getPlannedOutputOnCostCenter(QFilter accorgfilter, QFilter datefilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getPlannedOutputOnCostCenter";
        filters.add(accorgfilter);
        filters.add(datefilter);
        filters.add(basefilter);
        logger.info("+++++\u8ba1\u5212\u751f\u4ea7\u6570\u91cf" + ((Object)filters).toString());
        filters.add(new QFilter("costobject.producttype", "=", (Object)Character.valueOf('C')));
        DataSet plannedOutput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"accountorg as org,manuorg,costcenter,qty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        plannedOutput = plannedOutput.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        plannedOutput = MfgfeeAllocHelper.isSCA(appId) ? plannedOutput.select(CommonConstant.PLAN_OUTPUT_SCA + " as costdriver,org,manuorg,costcenter,value") : plannedOutput.select(CommonConstant.PLAN_OUTPUT_ACA + " as costdriver,org,manuorg,costcenter,value");
        return plannedOutput;
    }

    public DataSet getMftStockOnCostCenter(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appNum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        DataSet mftStockBillInfo = QueryServiceHelper.queryDataSet((String)"getProBillInfo", (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,entryentity.costobject.probill as probill,entryentity.costobject.isoutsource as isoutsource", (QFilter[])filters.toArray(new QFilter[0]), null).distinct();
        HashSet pomBillIds = new HashSet(1024);
        HashSet omBillIds = new HashSet(1024);
        mftStockBillInfo.copy().forEach(s -> {
            if (s.getBoolean("isoutsource").booleanValue()) {
                omBillIds.add(s.getLong("probill"));
            } else {
                pomBillIds.add(s.getLong("probill"));
            }
        });
        DataSet assemblyDataSet = null;
        if (!CadEmptyUtils.isEmpty(pomBillIds)) {
            QFilter orderEntryQf = new QFilter("orderentryid", "in", pomBillIds);
            assemblyDataSet = QueryServiceHelper.queryDataSet((String)"getmftStock", (String)"pom_mftstock", (String)"stockentry.demandqty AS value,orderentryid", (QFilter[])new QFilter[]{orderEntryQf}, null);
        }
        if (!CadEmptyUtils.isEmpty(omBillIds)) {
            QFilter omOrderEntryQf = new QFilter("orderentryid", "in", omBillIds);
            DataSet omAssemblyDataSet = QueryServiceHelper.queryDataSet((String)"getommftStock", (String)"om_mftstock", (String)"stockentry.demandqty AS value,orderentryid", (QFilter[])new QFilter[]{omOrderEntryQf}, null);
            assemblyDataSet = assemblyDataSet == null ? omAssemblyDataSet : DataSetUtils.union((DataSet)assemblyDataSet, (DataSet)omAssemblyDataSet);
        }
        if (assemblyDataSet == null) {
            return null;
        }
        mftStockBillInfo = mftStockBillInfo.join(assemblyDataSet, JoinType.INNER).on("probill", "orderentryid").select(new String[]{"org", "manuorg", "costcenter"}, new String[]{"value"}).finish();
        mftStockBillInfo = mftStockBillInfo.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        mftStockBillInfo = MfgfeeAllocHelper.isSCA(appNum) ? mftStockBillInfo.select(CostDriverIdConstant.MFT_STOCK_SCA + " costdriver,org,manuorg,costcenter,value") : mftStockBillInfo.select(CostDriverIdConstant.MFT_STOCK_ACA + " costdriver,org,manuorg,costcenter,value");
        return mftStockBillInfo;
    }

    public DataSet getFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getFinishInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        finishInput = finishInput.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        finishInput = MfgfeeAllocHelper.isSCA(appId) ? finishInput.select(CommonConstant.FINISH_INPUT_SCA + " as costdriver,org,manuorg,costcenter,value") : finishInput.select(CommonConstant.FINISH_INPUT_ACA + " as costdriver,org,manuorg,costcenter,value");
        return finishInput;
    }

    public DataSet getIsreworkFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getIsreworkFinishInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        filters.add(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("\u8fd4\u5de5\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\uff08\u6210\u672c\u4e2d\u5fc3\uff09\u67e5\u8be2\u6761\u4ef6\uff1a" + ((Object)filters).toString());
        DataSet isreworkFinishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        isreworkFinishInput = isreworkFinishInput.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        isreworkFinishInput = MfgfeeAllocHelper.isSCA(appId) ? isreworkFinishInput.select(CommonConstant.ISREWORK_FINISH_VALUE_SCA + " as costdriver,org,manuorg,costcenter,value") : isreworkFinishInput.select(CommonConstant.ISREWORK_FINISH_VALUE_ACA + " as costdriver,org,manuorg,costcenter,value");
        return isreworkFinishInput;
    }

    public DataSet getOutFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getOutFinishInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        logger.info("+++++\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        DataSet outFinishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        outFinishInput = outFinishInput.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        outFinishInput = MfgfeeAllocHelper.isSCA(appId) ? outFinishInput.select(CommonConstant.OUT_FINISH_INPUT_SCA + " as costdriver,org,manuorg,costcenter,value") : outFinishInput.select(CommonConstant.OUT_FINISH_INPUT_ACA + " as costdriver,org,manuorg,costcenter,value");
        return outFinishInput;
    }

    public DataSet getOutAssistFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getReWorkAssFinInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet joinData = finishInput.join(finiBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.OUT_ASSIST_FINISH_INPUT + " as costdriver,org,manuorg,costcenter,value");
        return joinData;
    }

    public DataSet getReWoAssistFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getReWoAssistFinishInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        filters.add(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet outBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(new DataSet[]{prodBillData, outBillData});
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.RE_ASSIST_FINISH_INPUT + " as costdriver,org,manuorg,costcenter,value");
        return joinData;
    }

    public DataSet getAssistFinishInputOnCostCenter(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getAssistFinishInputOnCostCenter";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(prodBillData);
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.ASSIST_FINISH_INPUT + " as costdriver,org,manuorg,costcenter,value");
        return joinData;
    }

    public DataSet getEndInProduceQtyOnCostCenter(Long orgId, Long costaccountId, Long periodId) {
        DataSet endOnProduct = new WipCostCheckService().loadWipCostCheckDataSet(orgId, 0L, costaccountId, null, periodId);
        endOnProduct = endOnProduct.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("endproducting").finish();
        return endOnProduct.select(CommonConstant.END_IN_PRODUCE + " as costdriver,org,manuorg,costcenter,endproducting value");
    }

    public DataSet getEquivalentOnCostCenter(Long orgId, Long costaccountId, Long periodId) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQF = new QFilter("period", "=", (Object)periodId);
        DataSet equivalentData = QueryServiceHelper.queryDataSet((String)"", (String)"aca_equivalent", (String)"org,manuorg,costaccount,entryentity.costcenter costcenter,entryentity.costobject costobject,entryentity.material material,entryentity.totalvalen value", (QFilter[])new QFilter[]{orgQF, costaccountQF, periodQF}, null);
        equivalentData = equivalentData.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("value").finish();
        return equivalentData.select(CommonConstant.EQUIVALENT + " as costdriver,org,manuorg,costcenter,value");
    }

    public static boolean isSCA(String appId) {
        return "sca".equals(appId);
    }

    private DataSet getAcaStdValueTypeOne(Long orgId, Long costaccountId, Long periodId, Set<Long> costDriverIds) {
        String appId = "aca";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter datefilter = this.getDatefilter(periodId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appId);
        DataSet finishInput = this.getFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet outFinishInput = this.getOutFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet assistFinishInput = this.getAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet reWoAssistFinishInput = this.getReWoAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        ArrayList<DataSet> inputList = new ArrayList<DataSet>(10);
        this.addDataSet(inputList, outFinishInput);
        this.addDataSet(inputList, assistFinishInput);
        this.addDataSet(inputList, reWoAssistFinishInput);
        this.addDataSet(inputList, outAssistFinishInput);
        finishInput = finishInput.union(inputList.toArray(new DataSet[0]));
        DataSet plannedOutput = this.getPlannedOutputOnCostCenter(accorgfilter, datefilter, basefilter, appId);
        DataSet mftStock = this.getMftStockOnCostCenter(orgfilter, datefilter, basefilter, appId);
        DataSet onProduct = this.getOnProductOnCostCenter(accorgfilter, datefilter, basefilter, appId);
        DataSet allHour = this.getAllHourOnCostCenter(orgfilter, bookDateFilter, basefilter);
        DataSet machineHour = this.getMachineHourOnCostCenter(allHour, appId);
        DataSet humanHour = this.getHumanHourOnCostCenter(allHour, appId);
        DataSet outHumanHour = this.getOutHumanHourOnCostCenter(allHour, appId);
        humanHour = humanHour.union(outHumanHour);
        DataSet actualHour = this.getActualHourOnCostCenter(allHour, appId);
        DataSet outActualHour = this.getOutActualHourOnCostCenter(allHour, appId);
        actualHour = actualHour.union(outActualHour);
        DataSet isreworkFinishInput = this.getIsreworkFinishInputOnCostCenter(orgfilter, bookDateFilter, basefilter, appId);
        DataSet endOnProduct = this.getEndInProduceQtyOnCostCenter(orgId, costaccountId, periodId);
        DataSet equivalent = this.getEquivalentOnCostCenter(orgId, costaccountId, periodId);
        DataSet resource = this.getResourceUse(appId, orgfilter, bookDateFilter, basefilter, null, costaccountId, periodId, false, 0L);
        resource = resource.select("costdriver,org,manuorg,costcenter,value,unit");
        ArrayList<DataSet> unionList = new ArrayList<DataSet>(10);
        this.addDataSet(unionList, isreworkFinishInput);
        this.addDataSet(unionList, plannedOutput);
        this.addDataSet(unionList, mftStock);
        this.addDataSet(unionList, onProduct);
        this.addDataSet(unionList, machineHour);
        this.addDataSet(unionList, humanHour);
        this.addDataSet(unionList, actualHour);
        this.addDataSet(unionList, endOnProduct);
        this.addDataSet(unionList, equivalent);
        finishInput = finishInput.union(unionList.toArray(new DataSet[0])).addField("0", "unit");
        finishInput = this.union(finishInput, resource);
        DataSet joinAndSecOnCostObject = this.getJoinAndSecOnCostObject(orgId, orgfilter, bookDateFilter, basefilter, costDriverIds);
        if (joinAndSecOnCostObject != null) {
            joinAndSecOnCostObject = joinAndSecOnCostObject.groupBy(new String[]{"costdriver", "org", "manuorg", "costcenter"}).sum("value").finish();
            joinAndSecOnCostObject = joinAndSecOnCostObject.addField("0", "unit");
            finishInput = this.union(finishInput, joinAndSecOnCostObject);
        }
        return finishInput;
    }

    private void addDataSet(List<DataSet> unionList, DataSet ds) {
        if (ds != null) {
            unionList.add(ds);
        }
    }

    public DataSet getOnProductOnCostObject(QFilter accorgFilter, QFilter dateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getOnProduct";
        filters.add(accorgFilter);
        filters.add(dateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5728\u4ea7\u54c1\u6570\u91cf" + ((Object)filters).toString());
        DataSet onProduct = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"id,billno,accountorg org,manuorg,costcenter,costobject,wipqty value,costobject.material material,costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        onProduct = onProduct.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        onProduct = MfgfeeAllocHelper.isSCA(appId) ? onProduct.select(CommonConstant.ON_PRODUCT_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_plannedoutputbill' as billtypenum") : onProduct.select(CommonConstant.ON_PRODUCT_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_plannedoutputbill' as billtypenum");
        return onProduct;
    }

    public DataSet getPlannedOutputOnCostObject(QFilter accorgFilter, QFilter dateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getPlannedOutputDs";
        filters.add(accorgFilter);
        filters.add(dateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u8ba1\u5212\u751f\u4ea7\u6570\u91cf" + ((Object)filters).toString());
        DataSet plannedOutput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"id,billno,accountorg org,manuorg,costcenter,costobject,qty value,costobject.material material,costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        plannedOutput = plannedOutput.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        plannedOutput = MfgfeeAllocHelper.isSCA(appId) ? plannedOutput.select(CommonConstant.PLAN_OUTPUT_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_plannedoutputbill' as billtypenum") : plannedOutput.select(CommonConstant.PLAN_OUTPUT_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_plannedoutputbill' as billtypenum");
        return plannedOutput;
    }

    public DataSet getFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getFinishInputDs";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty value,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        finishInput = finishInput.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        finishInput = MfgfeeAllocHelper.isSCA(appId) ? finishInput.select(CommonConstant.FINISH_INPUT_SCA + " as costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum") : finishInput.select(CommonConstant.FINISH_INPUT_ACA + " as costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return finishInput;
    }

    public DataSet getOutFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getOutFinishInputOnCostObject";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("+++++\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u6570\u91cf" + ((Object)filters).toString());
        DataSet outFinishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty value,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        outFinishInput = outFinishInput.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        outFinishInput = MfgfeeAllocHelper.isSCA(appId) ? outFinishInput.select(CommonConstant.OUT_FINISH_INPUT_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum") : outFinishInput.select(CommonConstant.OUT_FINISH_INPUT_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return outFinishInput;
    }

    public DataSet getIsreworkFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.#getIsreworkFinishInputOnCostObject";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        logger.info("\u8fd4\u5de5\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\uff08\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff09\u67e5\u8be2\u6761\u4ef6\uff1a" + ((Object)filters).toString());
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty value,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        finishInput = finishInput.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        finishInput = MfgfeeAllocHelper.isSCA(appId) ? finishInput.select(CommonConstant.ISREWORK_FINISH_VALUE_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum") : finishInput.select(CommonConstant.ISREWORK_FINISH_VALUE_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return finishInput;
    }

    public DataSet getOutAssistFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getOutFinishInputOnCostObject";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet joinData = finishInput.join(finiBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.OUT_ASSIST_FINISH_INPUT + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return joinData;
    }

    public DataSet getAssistFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getOutFinishInputOnCostObject";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(prodBillData);
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.ASSIST_FINISH_INPUT + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return joinData;
    }

    public DataSet getReWorkAssistFinishInputOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#getOutFinishInputOnCostObject";
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("entryentity.costobject.producttype", "=", (Object)Character.valueOf('C')));
        DataSet finishInput = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty,sourcebillentry", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> finishBillEntryIds = new HashSet<Long>(16);
        for (Row row : finishInput.copy()) {
            finishBillEntryIds.add(row.getLong("sourcebillentry"));
        }
        DataSet finiBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_mftmanuinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet prodBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_productinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet outBillData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)"billentry.id entryId,billentry.qtyunit2nd value", (QFilter[])new QFilter("billentry.id", "in", finishBillEntryIds).toArray(), null);
        DataSet srcBillData = finiBillData.union(new DataSet[]{prodBillData, outBillData});
        DataSet joinData = finishInput.join(srcBillData, JoinType.INNER).on("sourcebillentry", "entryId").select(finishInput.getRowMeta().getFieldNames(), new String[]{"value"}).finish();
        joinData = joinData.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        joinData = joinData.select(CommonConstant.RE_ASSIST_FINISH_INPUT + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
        return joinData;
    }

    public DataSet getEndInProduceQtyOnCostObject(Long orgId, Long costaccountId, Long periodId) {
        DataSet endOnProduct = new WipCostCheckService().loadWipCostCheckDataSet(orgId, 0L, costaccountId, null, periodId);
        endOnProduct = endOnProduct.groupBy(new String[]{"org", "manuorg", "costcenter", "costobject", "material"}).sum("endproducting").finish();
        return endOnProduct.select(CommonConstant.END_IN_PRODUCE + " as costdriver,-2L as id,'' as billno,org,manuorg,costcenter,costobject,material,endproducting value,'aca_wipcostcheck' as billtypenum");
    }

    public DataSet getEquivalentOnCostObject(Long orgId, Long costaccountId, Long periodId) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQF = new QFilter("period", "=", (Object)periodId);
        DataSet equivalentData = QueryServiceHelper.queryDataSet((String)"", (String)"aca_equivalent", (String)"id,billno,org,manuorg,costaccount,entryentity.costcenter costcenter,entryentity.costobject costobject,entryentity.material material,entryentity.totalvalen value", (QFilter[])new QFilter[]{orgQF, costaccountQF, periodQF}, null);
        equivalentData = equivalentData.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        return equivalentData.select(CommonConstant.EQUIVALENT + " as costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'aca_equivalent' as billtypenum");
    }

    public DataSet getStdValueDiy(Long orgId, Long costAccountId, Long periodId, String appId, Set<Long> costDriverId, boolean planData, Long planschemeId) {
        DataSet diyCostDriverDs;
        DataSet workQtyDs;
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter appnum = new QFilter("appnum", "=", (Object)appId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and(appnum);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#stdValueDiy";
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("costdriver.isrelatedwork", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        if (!CadEmptyUtils.isEmpty(costDriverId)) {
            filters.add(new QFilter("costdriver.id", "in", costDriverId));
        }
        if (planData) {
            filters.add(appnum);
            filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
            filters.add(new QFilter("period", "=", (Object)periodId));
            filters.add(new QFilter("planscheme", "=", (Object)planschemeId));
            workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"cad_planwork", (String)"costdriver,id, billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,baseunit as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
            workQtyDs = workQtyDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) as value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'cad_planwork'", "billtypenum");
        } else {
            filters.add(basefilter);
            filters.add(this.getDatefilter(periodId));
            workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"sca_workqtycollec", (String)"costdriver,id, billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,baseunit as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
            workQtyDs = workQtyDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) as value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'sca_workqtycollec'", "billtypenum");
        }
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("appnum", "=", (Object)appId));
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTCENTER"));
        filters.add(new QFilter("costdriver.isrelatedwork", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        if (!CadEmptyUtils.isEmpty(costDriverId)) {
            filters.add(new QFilter("costdriver.id", "in", costDriverId));
        }
        if (planData) {
            filters.add(new QFilter("period", "=", (Object)periodId));
            filters.add(new QFilter("planscheme", "=", (Object)planschemeId));
            diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plancostdriver", (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,0 as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
            diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'cad_plancostdriver'", "billtypenum");
        } else {
            filters.add(new QFilter("effectperiod", "!=", (Object)0L));
            filters.add(this.getEffectDateFilter(periodId));
            diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,0 as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
            diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'sca_diycostdriver'", "billtypenum");
        }
        workQtyDs = workQtyDs.union(diyCostDriverDs);
        workQtyDs = workQtyDs.select("costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,value,billtypenum,unit");
        return workQtyDs;
    }

    public DataSet getPlanStdValueDiy(Long orgId, Long costAccountId, Long periodId, String appId, Set<Long> costDriverId, Long planschemeId) {
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper#stdValueDiy";
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("period", "=", (Object)periodId));
        filters.add(basefilter);
        filters.add(new QFilter("costdriver.isrelatedwork", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("planscheme", "=", (Object)planschemeId));
        if (!CadEmptyUtils.isEmpty(costDriverId)) {
            filters.add(new QFilter("costdriver.id", "in", costDriverId));
        }
        DataSet workQtyDs = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"cad_planwork", (String)"costdriver,id, billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,baseunit as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        workQtyDs = workQtyDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) as value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'sca_workqtycollec'", "billtypenum");
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("appnum", "=", (Object)appId));
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTCENTER"));
        filters.add(new QFilter("costdriver.isrelatedwork", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("period", "=", (Object)periodId));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(new QFilter("planscheme", "=", (Object)planschemeId));
        filters.add(this.getEffectDateFilter(periodId));
        if (!CadEmptyUtils.isEmpty(costDriverId)) {
            filters.add(new QFilter("costdriver.id", "in", costDriverId));
        }
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plancostdriver", (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.benefcostcenter as benefcostcenter,0 as unit,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,unit").addField("'sca_diycostdriver'", "billtypenum");
        workQtyDs = workQtyDs.union(diyCostDriverDs);
        workQtyDs = workQtyDs.select("costdriver,id,billno,org,manuorg,costcenter,benefcostcenter,value,billtypenum,unit");
        return workQtyDs;
    }

    public DataSet getNotProdStd(Long orgId, String appNum, Long periodId) {
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper getNotProdStd()";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("allocmold", "=", (Object)"A");
        orgfilter.and("billstatus", "=", (Object)"C");
        orgfilter.and("appnum", "=", (Object)appNum);
        String selectFields = "org,manuorg,costcenter,allocmold,expenseitem,costdriver,unit,benefcostcenter,allocdim";
        DataSet notprodstd = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcenter.name,costcentergroup,issender,isexpense,isbeneficiary,allocmold,entryentity.expenseitem as expenseitem,allocdim,entryentity.subelement subelement,entryentity.costdriver as costdriver,entryentity.costdriver.unit as unit,entryentity.subentryentity.benefcostcenter as benefcostcenter,entryentity.subentryentity.centergroup as centergroup", (QFilter[])orgfilter.toArray(), null);
        DataSet costCenterExpense = notprodstd.filter("issender = true and isexpense = true and isbeneficiary = true").select(selectFields);
        DataSet costCenterExpenseBenGroup = notprodstd.filter("issender = true and isexpense = true and isbeneficiary = false").select("org,manuorg,costcenter,allocmold,expenseitem,allocdim,costdriver,unit,centergroup");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        costCenterExpenseBenGroup = costCenterExpenseBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterExpenseBenGroup);
        DataSet costCenterGroupExpense = notprodstd.filter("issender = false and isexpense = true and isbeneficiary = true").select("org,manuorg,costcentergroup,allocmold,expenseitem,allocdim,costdriver,unit,benefcostcenter");
        costCenterGroupExpense = costCenterGroupExpense.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpense.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpense);
        DataSet costCenterGroupExpenseBenGroup = notprodstd.filter("issender = false and isexpense = true and isbeneficiary = false").select("org,manuorg,costcentergroup,allocmold,expenseitem,allocdim,costdriver,unit,centergroup");
        costCenterGroupExpenseBenGroup = costCenterGroupExpenseBenGroup.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterGroupExpenseBenGroup = costCenterGroupExpenseBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterGroupExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpenseBenGroup);
        DataSet costCenterSubElement = notprodstd.filter("issender = true and isexpense = false and isbeneficiary = true").select("org,manuorg,costcenter,allocmold,subelement,allocdim,costdriver,unit,benefcostcenter");
        DataSet costCenterSubElementBenGroup = notprodstd.filter("issender = true and isexpense = false and isbeneficiary = false").select("org,manuorg,costcenter,allocmold,subelement,allocdim,costdriver,unit,centergroup");
        costCenterSubElementBenGroup = costCenterSubElementBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterSubElementBenGroup);
        DataSet costCenterGroupSubElement = notprodstd.filter("issender = false and isexpense = false and isbeneficiary = true").select("org,manuorg,costcentergroup,allocmold,subelement,allocdim,costdriver,unit,benefcostcenter");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        DataSet costCenterGroupSubElementBenGroup = notprodstd.filter("issender = false and isexpense = false and isbeneficiary = false").select("org,manuorg,costcentergroup,allocmold,subelement,allocdim,costdriver,unit,centergroup");
        costCenterGroupSubElementBenGroup = costCenterGroupSubElementBenGroup.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterGroupSubElementBenGroup = costCenterGroupSubElementBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterGroupSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElementBenGroup);
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)(algoKey + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])orgFilter.toArray(), null);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).filter("expenseitem is not null and expenseitem != 0");
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        DataSet costcenter = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_costcenter", (String)"id as benefcostcenter,name,accountorg,orgduty", (QFilter[])accorgfilter.toArray(), null);
        DataSet notprodstd1 = costCenterExpense.filter("benefcostcenter is null or benefcostcenter=0").removeFields(new String[]{"benefcostcenter"});
        costCenterExpense = costCenterExpense.filter("benefcostcenter is not null and benefcostcenter!=0");
        notprodstd1 = notprodstd1.join(costcenter, JoinType.INNER).on("org", "accountorg").select(notprodstd1.getRowMeta().getFieldNames(), new String[]{"benefcostcenter"}).finish();
        notprodstd1 = notprodstd1.select(costCenterExpense.getRowMeta().getFieldNames());
        costCenterExpense = costCenterExpense.union(notprodstd1).distinct();
        return costCenterExpense;
    }

    public DataSet getAssitPrdStd(Long orgId, String appNum) {
        String algoKey = "MfgfeeAllocHelper#getAssitPrdStd";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("allocmold", "=", (Object)"B");
        orgfilter.and("billstatus", "=", (Object)"C");
        orgfilter.and("appnum", "=", (Object)appNum);
        String selectFields = "org,manuorg,costcenter,allocmold,expenseitem,costdriver,unit";
        DataSet assistPrdStd = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,allocmold,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.unit unit", (QFilter[])orgfilter.toArray(), null);
        DataSet costCenterExpense = assistPrdStd.filter("issender = true and isexpense = true").select(selectFields);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DataSet costCenterSubElement = assistPrdStd.filter("issender = true and isexpense = false").select("org,manuorg,costcenter,allocmold,subelement,costdriver,unit");
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)(algoKey + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])orgFilter.toArray(), null);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).distinct();
        DataSet assitPrdStdDs = costCenterExpense.filter("expenseitem is not null and expenseitem != 0");
        return assitPrdStdDs;
    }

    private DataSet union(DataSet ds1, DataSet ds2) {
        ds2 = ds2.select(ds1.getRowMeta().getFieldNames());
        return ds1.union(ds2);
    }

    public DataSet getMulStandOnCostCenter(Long orgId, Long periodId, String appNum) {
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper.getMulStandOnCostCenter";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("allocmold", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appNum);
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcenter.number number,costcenter.name name,costcentergroup,issender,billno", (QFilter[])new QFilter[]{orgFilter, filter}, null);
        DataSet costCenterDs = allocStdDs.filter("issender = true").select("org,manuorg,costcenter,number,name,billno as costCenterBill");
        DataSet costCenterGroupDs = allocStdDs.filter("issender = false").select("org,manuorg,costcentergroup,billno as costCenterGroupBill");
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        costCenterGroupDs = costCenterGroupDs.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupDs.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        DataSet mulStandDs = costCenterDs.join(costCenterGroupDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").select(costCenterDs.getRowMeta().getFieldNames(), new String[]{"costcentergroup", "costCenterGroupBill"}).finish().filter("costcenter is not null and costcenter != 0");
        return mulStandDs;
    }

    private DataSet getCostCenterGroupDs(Long orgId, Long periodId) {
        Date endDate;
        Map periodEndDate;
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper.getCostCenterGroupDs";
        Date date = new Date();
        if (!CadEmptyUtils.isEmpty(periodId) && (periodEndDate = PeriodHelper.getEndDateByPeriod(Collections.singleton(periodId))) != null && (endDate = (Date)periodEndDate.get(periodId)) != null) {
            date = DateUtils.getDayEndTime((Date)endDate);
        }
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and("enable", "=", (Object)Boolean.TRUE);
        DataSet costCenterGroup = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costcentergroup", (String)"id,entryentity.costcenter costcenter", (QFilter[])new QFilter[]{orgFilter, dateFilter, statusFilter}, null);
        return costCenterGroup;
    }

    public DataSet getBaseProdStd(Long orgId, String appnum, Long periodId) {
        Date endDate;
        Map periodEndDate;
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper getNotProdStd()";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("allocmold", "=", (Object)"C");
        orgfilter.and("billstatus", "=", (Object)"C");
        orgfilter.and("appnum", "=", (Object)appnum);
        String selectFields = "org,manuorg,costcenter,allocmold,execondition,expenseitem,costdriver,unit,benefcostcenter";
        DataSet baseprodstd = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,isbeneficiary,allocmold,execondition,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.unit unit,entryentity.subentryentity.benefcostcenter benefcostcenter,entryentity.subentryentity.centergroup as centergroup", (QFilter[])orgfilter.toArray(), null);
        DataSet costCenterExpense = baseprodstd.filter("issender = true and isexpense = true and isbeneficiary = true").select(selectFields);
        DataSet costCenterExpenseBenGroup = baseprodstd.filter("issender = true and isexpense = true and isbeneficiary = false").select("org,manuorg,costcenter,allocmold,execondition,expenseitem,costdriver,unit,centergroup");
        Date date = new Date();
        if (!CadEmptyUtils.isEmpty(periodId) && (periodEndDate = PeriodHelper.getEndDateByPeriod(Collections.singleton(periodId))) != null && (endDate = (Date)periodEndDate.get(periodId)) != null) {
            date = DateUtils.getDayEndTime((Date)endDate);
        }
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DataSet costCenterGroup = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costcentergroup", (String)"id,entryentity.costcenter costcenter,entryentity.costcenter.orgduty orgduty", (QFilter[])new QFilter[]{orgFilter, dateFilter, statusFilter}, null);
        DataSet basicCostCenterGroup = costCenterGroup.filter("orgduty = 4");
        costCenterExpenseBenGroup = costCenterExpenseBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterExpenseBenGroup);
        DataSet costCenterGroupExpense = baseprodstd.filter("issender = false and isexpense = true and isbeneficiary = true").select("org,manuorg,costcentergroup,allocmold,execondition,expenseitem,costdriver,unit,benefcostcenter");
        costCenterGroupExpense = costCenterGroupExpense.leftJoin(basicCostCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpense.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpense);
        DataSet costCenterGroupExpenseBenGroup = baseprodstd.filter("issender = false and isexpense = true and isbeneficiary = false").select("org,manuorg,costcentergroup,allocmold,execondition,expenseitem,costdriver,unit,centergroup");
        costCenterGroupExpenseBenGroup = costCenterGroupExpenseBenGroup.leftJoin(basicCostCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterGroupExpenseBenGroup = costCenterGroupExpenseBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterGroupExpenseBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpenseBenGroup);
        DataSet costCenterSubElement = baseprodstd.filter("issender = true and isexpense = false and isbeneficiary = true").select("org,manuorg,costcenter,allocmold,execondition,subelement,costdriver,unit,benefcostcenter");
        DataSet costCenterSubElementBenGroup = baseprodstd.filter("issender = true and isexpense = false and isbeneficiary = false").select("org,manuorg,costcenter,allocmold,execondition,subelement,costdriver,unit,centergroup");
        costCenterSubElementBenGroup = costCenterSubElementBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterSubElementBenGroup);
        DataSet costCenterGroupSubElement = baseprodstd.filter("issender = false and isexpense = false and isbeneficiary = true").select("org,manuorg,costcentergroup,allocmold,execondition,subelement,costdriver,unit,benefcostcenter");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(basicCostCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        DataSet costCenterGroupSubElementBenGroup = baseprodstd.filter("issender = false and isexpense = false and isbeneficiary = false").select("org,manuorg,costcentergroup,allocmold,execondition,subelement,costdriver,unit,centergroup");
        costCenterGroupSubElementBenGroup = costCenterGroupSubElementBenGroup.leftJoin(basicCostCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterGroupSubElementBenGroup = costCenterGroupSubElementBenGroup.leftJoin(costCenterGroup).on("centergroup", "id").select(costCenterGroupSubElementBenGroup.getRowMeta().getFieldNames(), new String[]{"costcenter as benefcostcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElementBenGroup);
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)(algoKey + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])orgFilter.toArray(), null);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).filter("expenseitem is not null and expenseitem != 0");
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        DataSet costcenter = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_costcenter", (String)"id benefcostcenter,accountorg,orgduty", (QFilter[])accorgfilter.toArray(), null);
        DataSet baseprodstd1 = costCenterExpense.filter("benefcostcenter is null or benefcostcenter=0").removeFields(new String[]{"benefcostcenter"});
        costCenterExpense = costCenterExpense.filter("benefcostcenter is not null and benefcostcenter!=0");
        baseprodstd1 = baseprodstd1.join(costcenter, JoinType.INNER).on("org", "accountorg").select(baseprodstd1.getRowMeta().getFieldNames(), new String[]{"benefcostcenter", "orgduty"}).finish();
        costCenterExpense = costCenterExpense.select("org,manuorg,costcenter,allocmold,execondition,expenseitem,costdriver,unit,benefcostcenter,4L as orgduty");
        baseprodstd1 = baseprodstd1.select("org,manuorg,costcenter,allocmold,execondition,expenseitem,costdriver,unit,benefcostcenter,orgduty");
        costCenterExpense = costCenterExpense.union(baseprodstd1).distinct();
        return costCenterExpense;
    }

    public DataSet getCostObjectStd(Long orgId, String appNum) {
        String algoKey = "MfgfeeAllocHelper getCostObjectStd()";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("appnum", "=", (Object)appNum);
        orgfilter.and("billstatus", "=", (Object)"C");
        DataSet costObjectStd = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_overheadallotcost", (String)"costcenter,entryentity.costdriver costdriver,allocdim", (QFilter[])orgfilter.toArray(), null);
        return costObjectStd;
    }

    public DataSet getCostObjectStdData(Long orgId, Long costAccountId, Long periodId, String appNum, Set<Long> costDriverIds) {
        if ("aca".equals(appNum)) {
            return this.getAcaCostObjectStdValue(orgId, costAccountId, periodId, costDriverIds);
        }
        if ("sca".equals(appNum)) {
            return this.getScaCostObjectStdValue(orgId, costAccountId, periodId, costDriverIds);
        }
        return this.getEcaCostObjectStdValue(orgId, costAccountId, periodId);
    }

    private DataSet getEcaCostObjectStdValue(Long orgId, Long costAccountId, Long periodId) {
        String appNum = "eca";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appNum);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper stdValueDiy()";
        filters.clear();
        filters.add(orgFilter);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTOBJECT"));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("effectperiod", "!=", (Object)0L));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(this.getEffectDateFilter(periodId));
        filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"costdriver,id,billno,org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.material as material,entryentity.entryqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material");
        diyCostDriverDs = diyCostDriverDs.addField("0", "unit").addField("'sca_diycostdriver'", "billtypenum");
        DataSet resource = this.getCOResourceUse(appNum, orgFilter, bookDateFilter, baseFilter, null, costAccountId, periodId, false, 0L);
        diyCostDriverDs = DataSetUtils.union((DataSet)diyCostDriverDs, (DataSet)resource);
        return diyCostDriverDs;
    }

    private DataSet getScaCostObjectStdValue(Long orgId, Long costAccountId, Long periodId, Set<Long> costDriverIds) {
        boolean isNewAllocType = MfgfeeAllocHelper.isNewAllocType();
        String appNum = "sca";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter datefilter = this.getDatefilter(periodId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appNum);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper stdValueDiy()";
        if (isNewAllocType) {
            DataSet allDs = null;
            DataSet resource = this.getCOResourceUse(appNum, orgfilter, bookDateFilter, basefilter, costDriverIds, costAccountId, periodId, false, 0L);
            if (CadEmptyUtils.isEmpty(costDriverIds)) {
                return resource;
            }
            resource = resource.select("costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,billtypenum");
            DataSet humanAndMachineHour = null;
            block32: for (Long costDriverId : costDriverIds) {
                switch (String.valueOf(costDriverId)) {
                    case "844089614712364032": {
                        DataSet finishInput = this.getFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, finishInput);
                        continue block32;
                    }
                    case "1620330732428060672": {
                        DataSet reworkFinishInput = this.getIsreworkFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, reworkFinishInput);
                        continue block32;
                    }
                    case "844089614712364033": {
                        DataSet outFinishInput = this.getOutFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outFinishInput);
                        continue block32;
                    }
                    case "844090490004888583": {
                        DataSet assistFinishInput = this.getAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, assistFinishInput);
                        continue block32;
                    }
                    case "844090490004888585": {
                        DataSet reWorkAssistFinishInput = this.getReWorkAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, reWorkAssistFinishInput);
                        continue block32;
                    }
                    case "844090490004888584": {
                        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outAssistFinishInput);
                        continue block32;
                    }
                    case "844089929922698240": {
                        DataSet plannedOutput = this.getPlannedOutputOnCostObject(accorgfilter, datefilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, plannedOutput);
                        continue block32;
                    }
                    case "1919774047680688128": {
                        DataSet mftStock = this.getMftStockOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, mftStock);
                        continue block32;
                    }
                    case "844090213742861312": {
                        DataSet onProduct = this.getOnProductOnCostObject(accorgfilter, datefilter, basefilter, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, onProduct);
                        continue block32;
                    }
                    case "1028144987130497024": {
                        if (humanAndMachineHour == null) {
                            humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet machineHour = this.getMachineHourOnCostObject(humanAndMachineHour, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, machineHour);
                        continue block32;
                    }
                    case "1028146107680647168": {
                        if (humanAndMachineHour == null) {
                            humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet humanHour = this.getHumanHourOnCostObject(humanAndMachineHour, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, humanHour);
                        continue block32;
                    }
                    case "1028146107680647169": {
                        if (humanAndMachineHour == null) {
                            humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet outHumanHour = this.getOutHumanHourOnCostObject(humanAndMachineHour, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outHumanHour);
                        continue block32;
                    }
                    case "1028146107680647170": {
                        if (humanAndMachineHour == null) {
                            humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet actualHour = this.getActualHourOnCostObject(humanAndMachineHour, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, actualHour);
                        continue block32;
                    }
                    case "1028146107680647171": {
                        if (humanAndMachineHour == null) {
                            humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
                        }
                        DataSet outActualHour = this.getOutActualHourOnCostObject(humanAndMachineHour, appNum);
                        allDs = MfgfeeAllocHelper.unionDs(allDs, outActualHour);
                        continue block32;
                    }
                }
                filters.clear();
                filters.add(orgfilter);
                filters.add(new QFilter("appnum", "=", (Object)appNum));
                filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTOBJECT"));
                filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
                filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                filters.add(new QFilter("costdriver", "=", (Object)costDriverId));
                filters.add(this.getEffectDateFilter(periodId));
                filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
                DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"id,billno,costdriver,org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.material as material,entryentity.entryqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material");
                diyCostDriverDs = diyCostDriverDs.addField("'sca_diycostdriver'", "billtypenum");
                allDs = MfgfeeAllocHelper.unionDs(allDs, diyCostDriverDs);
            }
            if (allDs != null) {
                resource = DataSetUtils.union(allDs, (DataSet)resource);
            }
            resource = resource.addField("0", "unit");
            return resource;
        }
        DataSet finishInput = this.getFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet outFinishInput = this.getOutFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet assistFinishInput = this.getAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet reWorkAssistFinishInput = this.getReWorkAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        ArrayList<DataSet> unionList = new ArrayList<DataSet>(10);
        this.addDataSet(unionList, outFinishInput);
        this.addDataSet(unionList, assistFinishInput);
        this.addDataSet(unionList, outAssistFinishInput);
        this.addDataSet(unionList, reWorkAssistFinishInput);
        finishInput = finishInput.union(unionList.toArray(new DataSet[0]));
        DataSet plannedOutput = this.getPlannedOutputOnCostObject(accorgfilter, datefilter, basefilter, appNum);
        DataSet mftStock = this.getMftStockOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet onProduct = this.getOnProductOnCostObject(accorgfilter, datefilter, basefilter, appNum);
        DataSet humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
        DataSet machineHour = this.getMachineHourOnCostObject(humanAndMachineHour, appNum);
        DataSet humanHour = this.getHumanHourOnCostObject(humanAndMachineHour, appNum);
        DataSet outHumanHour = this.getOutHumanHourOnCostObject(humanAndMachineHour, appNum);
        humanHour = humanHour.union(outHumanHour);
        DataSet actualHour = this.getActualHourOnCostObject(humanAndMachineHour, appNum);
        DataSet outActualHour = this.getOutActualHourOnCostObject(humanAndMachineHour, appNum);
        actualHour = actualHour.union(outActualHour);
        DataSet reworkFinishInput = this.getIsreworkFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTOBJECT"));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("effectperiod", "!=", (Object)0L));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(this.getEffectDateFilter(periodId));
        filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"id,billno,costdriver,org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.material as material,entryentity.entryqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material").addField("'sca_diycostdriver'", "billtypenum");
        ArrayList<DataSet> inputList = new ArrayList<DataSet>(10);
        this.addDataSet(inputList, reworkFinishInput);
        this.addDataSet(inputList, plannedOutput);
        this.addDataSet(inputList, mftStock);
        this.addDataSet(inputList, onProduct);
        this.addDataSet(inputList, machineHour);
        this.addDataSet(inputList, humanHour);
        this.addDataSet(inputList, actualHour);
        this.addDataSet(inputList, diyCostDriverDs);
        finishInput = finishInput.union(inputList.toArray(new DataSet[0])).addField("0", "unit");
        DataSet resource = this.getCOResourceUse(appNum, orgfilter, bookDateFilter, basefilter, null, costAccountId, periodId, false, 0L);
        finishInput = DataSetUtils.union((DataSet)finishInput, (DataSet)resource);
        return finishInput;
    }

    public DataSet getMftStockOnCostObject(QFilter orgFilter, QFilter bookDateFilter, QFilter baseFilter, String appNum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(orgFilter);
        filters.add(bookDateFilter);
        filters.add(baseFilter);
        DataSet mftStockBillInfo = QueryServiceHelper.queryDataSet((String)"getProBillInfo", (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,entryentity.costobject costobject,entryentity.costobject.probill as probill,entryentity.costobject.isoutsource as isoutsource", (QFilter[])filters.toArray(new QFilter[0]), null).distinct();
        HashSet pomBillIds = new HashSet(1024);
        HashSet omBillIds = new HashSet(1024);
        mftStockBillInfo.copy().forEach(s -> {
            if (s.getBoolean("isoutsource").booleanValue()) {
                omBillIds.add(s.getLong("probill"));
            } else {
                pomBillIds.add(s.getLong("probill"));
            }
        });
        DataSet assemblyDataSet = null;
        if (!CadEmptyUtils.isEmpty(pomBillIds)) {
            QFilter orderEntryQf = new QFilter("orderentryid", "in", pomBillIds);
            assemblyDataSet = QueryServiceHelper.queryDataSet((String)"getmftStock", (String)"pom_mftstock", (String)"id,billno,stockentry.materialid.masterid as material,stockentry.demandqty AS value,orderentryid,'pom_mftstock' as billtypenum", (QFilter[])new QFilter[]{orderEntryQf}, null);
        }
        if (!CadEmptyUtils.isEmpty(omBillIds)) {
            QFilter omOrderEntryQf = new QFilter("orderentryid", "in", omBillIds);
            DataSet omAssemblyDataSet = QueryServiceHelper.queryDataSet((String)"getommftStock", (String)"om_mftstock", (String)"id,billno,stockentry.materialid.masterid as material,stockentry.demandqty AS value, orderentryid,'om_mftstock' as billtypenum", (QFilter[])new QFilter[]{omOrderEntryQf}, null);
            assemblyDataSet = assemblyDataSet == null ? omAssemblyDataSet : DataSetUtils.union((DataSet)assemblyDataSet, (DataSet)omAssemblyDataSet);
        }
        if (assemblyDataSet == null) {
            return null;
        }
        mftStockBillInfo = mftStockBillInfo.join(assemblyDataSet, JoinType.INNER).on("probill", "orderentryid").select(new String[]{"org", "manuorg", "costcenter", "costobject"}, new String[]{"id", "billno", "material", "value", "billtypenum"}).finish();
        mftStockBillInfo = MfgfeeAllocHelper.isSCA(appNum) ? mftStockBillInfo.select(CostDriverIdConstant.MFT_STOCK_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,billtypenum") : mftStockBillInfo.select(CostDriverIdConstant.MFT_STOCK_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,billtypenum");
        return mftStockBillInfo;
    }

    public DataSet getActualHourOnCostObject(DataSet humanAndMachineHour, String appId) {
        DataSet actualHour = humanAndMachineHour.filter("isoutsource = false");
        actualHour = actualHour.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        actualHour = MfgfeeAllocHelper.isSCA(appId) ? actualHour.select(CommonConstant.ACTUAL_HOUR_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum") : actualHour.select(CommonConstant.ACTUAL_HOUR_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
        return actualHour;
    }

    public DataSet getOutActualHourOnCostObject(DataSet humanAndMachineHour, String appId) {
        DataSet outActualHour = humanAndMachineHour.filter("isoutsource = true");
        outActualHour = outActualHour.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        outActualHour = MfgfeeAllocHelper.isSCA(appId) ? outActualHour.select(CommonConstant.OUT_ACTUAL_HOUR_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum") : outActualHour.select(CommonConstant.OUT_ACTUAL_HOUR_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
        return outActualHour;
    }

    public DataSet getHumanHourOnCostObject(DataSet humanAndMachineHour, String appId) {
        DataSet humanHour = humanAndMachineHour.filter("resType = 'mpdm_manuperson' and isoutsource = false");
        humanHour = humanHour.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        humanHour = MfgfeeAllocHelper.isSCA(appId) ? humanHour.select(CommonConstant.HUMAN_HOUR_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum") : humanHour.select(CommonConstant.HUMAN_HOUR_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
        return humanHour;
    }

    public DataSet getOutHumanHourOnCostObject(DataSet humanAndMachineHour, String appId) {
        DataSet outHumanHour = humanAndMachineHour.filter("resType = 'mpdm_manuperson' and isoutsource = true");
        outHumanHour = outHumanHour.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        outHumanHour = MfgfeeAllocHelper.isSCA(appId) ? outHumanHour.select(CommonConstant.OUT_HUMAN_HOUR_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum") : outHumanHour.select(CommonConstant.OUT_HUMAN_HOUR_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
        return outHumanHour;
    }

    public DataSet getMachineHourOnCostObject(DataSet humanAndMachineHour, String appId) {
        DataSet machineHour = humanAndMachineHour.filter("resType in ('mpdm_equipment','mpdm_toolsresource','mpdm_toolequip','mpdm_mould')");
        machineHour = machineHour.groupBy(new String[]{"id", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
        machineHour = MfgfeeAllocHelper.isSCA(appId) ? machineHour.select(CommonConstant.MACHINE_HOUR_SCA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum") : machineHour.select(CommonConstant.MACHINE_HOUR_ACA + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
        return machineHour;
    }

    public DataSet getAllHourOnCostObject(QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper.getAllHourOnCostObject";
        filters.add(orgfilter);
        filters.add(bookDateFilter);
        filters.add(basefilter);
        DataSet allHour = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)"id,billno,resource,org,manuorg,costcenter,entryentity.costobject costobject,entryentity.workhour workhour,entryentity.facthour value,entryentity.costobject.material material,entryentity.costobject.isoutsource isoutsource,entryentity.costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
        allHour = allHour.select("id,billno,resource,org,manuorg,costcenter,costobject,workhour,case when workhour=10 then value*60 when workhour=8 then value/60 else value end value,material,isoutsource,auxpty");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter seq = new QFilter("resourcesentryentity.seq", "=", (Object)1);
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_resources", (String)"id,resourcesentryentity.itemclasstype AS resType", (QFilter[])new QFilter[]{status, seq}, null);
        allHour = allHour.join(resourceDataSet, JoinType.INNER).on("resource", "id").select(allHour.getRowMeta().getFieldNames(), new String[]{"resType"}).finish();
        return allHour.addField("'sca_resourceuse'", "billtypenum");
    }

    public DataSet getCOResourceUse(String appNum, QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, Set<Long> costDriverIds, Long costaccountId, Long periodId, boolean planData, Long planSchemeId) {
        DataSet resourceData;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String algoKey = "macc.cad.MfgfeeAllocHelper.getCOResourceUse";
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("islinkresource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("iscomplexcd", "=", (Object)Boolean.FALSE));
        if (!CadEmptyUtils.isEmpty(costDriverIds)) {
            filters.add(new QFilter("id", "in", costDriverIds));
        }
        DataSet resourceDriver = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id,matchpattern,resource.fbasedataid resource,resourcetype,matchreport", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet resource = resourceDriver.filter("matchpattern = 'resource'").select("id,resource,matchreport");
        DataSet resourcetype = resourceDriver.filter("matchpattern = 'resourcetype'").select("id,resource,resourcetype,matchreport");
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        RowMeta rowMeta = resourcetype.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourcetype) {
            String[] split;
            String resourcetype1 = row.getString("resourcetype");
            for (String str : split = resourcetype1.split(",")) {
                if (CadEmptyUtils.isEmpty(str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[rowMeta.getFieldIndex((String)"resourcetype")] = str;
                datasetlist.add(rowData);
            }
        }
        resourcetype = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("id,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,matchreport");
        DataSet resoureAndType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,resourcesentryentity.itemclasstype resourcetype", null, null);
        resourcetype = resourcetype.join(resoureAndType, JoinType.INNER).on("resourcetype", "resourcetype").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid"}).finish();
        resourcetype = resourcetype.groupBy(new String[]{"id", "resourceid", "matchreport"}).finish().select("id,resourceid resource,matchreport");
        filters.clear();
        filters.add(orgfilter);
        if (planData) {
            filters.add(new QFilter("planscheme", "=", (Object)planSchemeId));
            filters.add(new QFilter("costaccount", "=", (Object)costaccountId));
            filters.add(new QFilter("period", "=", (Object)periodId));
            resourceData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planresource", (String)"id as resourceid,billno,org,manuorg,costcenter,resource,resource.resourcesentryentity.itemclasstype as resourcetype,resourceunit,qty,0 as costobject,0 as material", (QFilter[])filters.toArray(new QFilter[0]), null);
            resource = resource.join(resourceData, JoinType.INNER).on("resource", "resource").select(resource.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "org", "manuorg", "costcenter", "costobject", "material", "resourceunit", "qty"}).finish();
            resourcetype = resourcetype.join(resourceData, JoinType.INNER).on("resource", "resource").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "org", "manuorg", "costcenter", "costobject", "material", "resourceunit", "qty"}).finish();
            resource = resource.union(resourcetype).select("id,resourceid,billno,resource,matchreport,org,manuorg,costcenter,costobject,material,resourceunit,case when resourceunit=10 then qty*60 when resourceunit=8 then qty/60 else qty end qty");
            resource = resource.select("id as costdriver,resourceid,billno,org,manuorg,costcenter,costobject,material,resourceunit as unit,qty as value");
            resource = resource.groupBy(new String[]{"costdriver", "resourceid", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
            resource = resource.select("costdriver,resourceid as id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum,0 as unit");
        } else {
            filters.add(bookDateFilter);
            filters.add(basefilter);
            resourceData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)"id as resourceid,billno,org,manuorg,costcenter,resource,resource.resourcesentryentity.itemclasstype as resourcetype,entryentity.workhour as workhour,entryentity.facthour as facthour,entryentity.factuse as factuse,entryentity.costobject as costobject,entryentity.material as material", (QFilter[])filters.toArray(new QFilter[0]), null);
            resource = resource.join(resourceData, JoinType.INNER).on("resource", "resource").select(resource.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "workhour", "org", "manuorg", "costcenter", "costobject", "material", "facthour", "factuse"}).finish();
            resourcetype = resourcetype.join(resourceData, JoinType.INNER).on("resource", "resource").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "workhour", "org", "manuorg", "costcenter", "costobject", "material", "facthour", "factuse"}).finish();
            resource = resource.union(resourcetype).select("id,resourceid,billno,resource,matchreport,org,manuorg,costcenter,costobject,material,workhour,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour,factuse");
            resource = resource.select("id as costdriver,resourceid,billno,org,manuorg,costcenter,costobject,material,workhour as unit,case when matchreport='total' then facthour else factuse end value");
            resource = resource.groupBy(new String[]{"costdriver", "resourceid", "billno", "org", "manuorg", "costcenter", "costobject", "material"}).sum("value").finish();
            resource = resource.select("costdriver,resourceid as id,billno,org,manuorg,costcenter,costobject,material,value,'sca_resourceuse' as billtypenum,0 as unit");
        }
        return resource;
    }

    private DataSet getAcaCostObjectStdValue(Long orgId, Long costAccountId, Long periodId, Set<Long> costDriverIds) {
        String appNum = "aca";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        QFilter accorgfilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter datefilter = this.getDatefilter(periodId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appNum);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String algoKey = "MfgfeeAllocHelper stdValueDiy()";
        DataSet finishInput = this.getFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet outFinishInput = this.getOutFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet assistFinishInput = this.getAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet outAssistFinishInput = this.getOutAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet reWorkAssistFinishInput = this.getReWorkAssistFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        ArrayList<DataSet> unionList = new ArrayList<DataSet>(10);
        this.addDataSet(unionList, outFinishInput);
        this.addDataSet(unionList, assistFinishInput);
        this.addDataSet(unionList, outAssistFinishInput);
        this.addDataSet(unionList, reWorkAssistFinishInput);
        finishInput = finishInput.union(unionList.toArray(new DataSet[0]));
        DataSet plannedOutput = this.getPlannedOutputOnCostObject(accorgfilter, datefilter, basefilter, appNum);
        DataSet mftStock = this.getMftStockOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        DataSet onProduct = this.getOnProductOnCostObject(accorgfilter, datefilter, basefilter, appNum);
        DataSet humanAndMachineHour = this.getAllHourOnCostObject(orgfilter, bookDateFilter, basefilter);
        DataSet machineHour = this.getMachineHourOnCostObject(humanAndMachineHour, appNum);
        DataSet humanHour = this.getHumanHourOnCostObject(humanAndMachineHour, appNum);
        DataSet outHumanHour = this.getOutHumanHourOnCostObject(humanAndMachineHour, appNum);
        humanHour = humanHour.union(outHumanHour);
        DataSet actualHour = this.getActualHourOnCostObject(humanAndMachineHour, appNum);
        DataSet outActualHour = this.getOutActualHourOnCostObject(humanAndMachineHour, appNum);
        actualHour = actualHour.union(outActualHour);
        DataSet isreworkFinishInput = this.getIsreworkFinishInputOnCostObject(orgfilter, bookDateFilter, basefilter, appNum);
        filters.clear();
        filters.add(orgfilter);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costdriver.allocclass", "=", (Object)"COSTOBJECT"));
        filters.add(new QFilter("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("effectperiod", "!=", (Object)0L));
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(this.getEffectDateFilter(periodId));
        filters.add(new QFilter("costdriver.islinkresource", "=", (Object)Boolean.FALSE));
        DataSet diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diycostdriver", (String)"id,billno,costdriver,org,manuorg,costcenter,entryentity.costobject as costobject,entryentity.costobject.material as material,entryentity.entryqty value", (QFilter[])filters.toArray(new QFilter[0]), null);
        diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material").addField("'sca_diycostdriver'", "billtypenum");
        DataSet resource = this.getCOResourceUse(appNum, orgfilter, bookDateFilter, basefilter, null, costAccountId, periodId, false, 0L);
        DataSet endInProduceQtyOnCostObject = this.getEndInProduceQtyOnCostObject(orgId, costAccountId, periodId);
        DataSet equivalentOnCostObject = this.getEquivalentOnCostObject(orgId, costAccountId, periodId);
        ArrayList<DataSet> inputList = new ArrayList<DataSet>(10);
        this.addDataSet(inputList, isreworkFinishInput);
        this.addDataSet(inputList, plannedOutput);
        this.addDataSet(inputList, mftStock);
        this.addDataSet(inputList, onProduct);
        this.addDataSet(inputList, machineHour);
        this.addDataSet(inputList, humanHour);
        this.addDataSet(inputList, actualHour);
        this.addDataSet(inputList, diyCostDriverDs);
        this.addDataSet(inputList, endInProduceQtyOnCostObject);
        this.addDataSet(inputList, equivalentOnCostObject);
        finishInput = finishInput.union(inputList.toArray(new DataSet[0])).addField("0", "unit");
        finishInput = DataSetUtils.union((DataSet)finishInput, (DataSet)resource);
        DataSet joinAndSecDs = this.getJoinAndSecOnCostObject(orgId, orgfilter, bookDateFilter, basefilter, costDriverIds);
        if (joinAndSecDs != null) {
            joinAndSecDs = joinAndSecDs.addField("0", "unit");
            finishInput = DataSetUtils.union((DataSet)finishInput, (DataSet)joinAndSecDs);
        }
        return finishInput;
    }

    public DataSet getJoinAndSecOnCostObject(Long orgId, QFilter orgfilter, QFilter bookDateFilter, QFilter basefilter, Set<Long> costDriverIds) {
        DataSet finalFinishInput = null;
        QFilter qFilter = new QFilter("id", "in", costDriverIds);
        qFilter.and("srccostdriver", "!=", (Object)0L);
        DataSet costDriverInfo = QueryServiceHelper.queryDataSet((String)"getCostDriverInfo", (String)"cad_costdriver", (String)"id,isjoin,isweight,issecond,srccostdriver", (QFilter[])qFilter.toArray(), null);
        if (!costDriverInfo.isEmpty()) {
            QFilter pgFilter = new QFilter("org", "=", (Object)orgId);
            pgFilter.and("grouptype", "=", (Object)"1");
            pgFilter.and("status", "=", (Object)"C");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(orgfilter);
            filters.add(bookDateFilter);
            filters.add(basefilter);
            filters.add(new QFilter("entryentity.costobject.isoutsource", "=", (Object)Boolean.FALSE));
            DataSet allFinishInput = QueryServiceHelper.queryDataSet((String)"getFactOutBill", (String)"cad_factnedoutputbill", (String)"id,billno,org,manuorg,costcenter,completeqty value,entryentity.costobject joincostobject,entryentity.costobject.material joinmaterial,entryentity.costobject.weight weight,entryentity.costobject.producttype producttype,entryentity.costobject.productgroup productgroup,entryentity.costobject.srcbillnumber srcbillnumber,entryentity.costobject.auxpty auxpty", (QFilter[])filters.toArray(new QFilter[0]), null);
            DataSet groupDs = allFinishInput.copy().select("productgroup").distinct();
            HashSet groupIds = new HashSet(128);
            groupDs.forEach(s -> groupIds.add(s.getLong("productgroup")));
            groupIds.remove(0L);
            QFilter mainQFilter = new QFilter("productgroup", "in", groupIds);
            mainQFilter.and("producttype", "=", (Object)"C");
            mainQFilter.and("isoutsource", "=", (Object)Boolean.FALSE);
            DataSet mainCostObjectDs = QueryServiceHelper.queryDataSet((String)"getMainCostObject", (String)"cad_costobject", (String)"id,costcenter,material,productgroup,weight,srcbillnumber", (QFilter[])mainQFilter.toArray(), null);
            DataSet mainFinishInput = allFinishInput.filter("producttype == 'C'").addField("joincostobject", "costobject").addField("joinmaterial", "material");
            allFinishInput = allFinishInput.join(mainCostObjectDs, JoinType.INNER).on("costcenter", "costcenter").on("srcbillnumber", "srcbillnumber").on("productgroup", "productgroup").select(allFinishInput.getRowMeta().getFieldNames(), new String[]{"id as costobject", "material", "weight as mainweight"}).finish();
            DataSet joinFinishInput = allFinishInput.filter("producttype == 'A'");
            joinFinishInput = joinFinishInput.addField("mainweight / weight", "allocweight");
            joinFinishInput = joinFinishInput.addField("allocweight * value", "allocvalue");
            DataSet secFinishInput = allFinishInput.filter("producttype == 'B'");
            for (Row row : costDriverInfo) {
                DataSet tempDs;
                long srcCostDriver = row.getLong("srccostdriver");
                long costDriverId = row.getLong("id");
                if (CommonConstant.FINISH_INPUT_ACA != srcCostDriver) continue;
                boolean isJoin = row.getBoolean("isjoin");
                boolean isWeight = row.getBoolean("isweight");
                boolean isSecond = row.getBoolean("issecond");
                if (isSecond) {
                    tempDs = secFinishInput.select(costDriverId + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
                    finalFinishInput = finalFinishInput == null ? tempDs : finalFinishInput.union(tempDs);
                }
                if (isJoin) {
                    tempDs = isWeight ? joinFinishInput.select(costDriverId + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,allocvalue as value,'cad_factnedoutputbill' as billtypenum") : joinFinishInput.select(costDriverId + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
                    finalFinishInput = finalFinishInput == null ? tempDs : finalFinishInput.union(tempDs);
                }
                if (mainFinishInput == null) continue;
                mainFinishInput = mainFinishInput.select(costDriverId + " costdriver,id,billno,org,manuorg,costcenter,costobject,material,value,'cad_factnedoutputbill' as billtypenum");
                finalFinishInput = MfgfeeAllocHelper.unionDs(finalFinishInput, mainFinishInput);
            }
        }
        return finalFinishInput;
    }

    private DataSet getResourceUse(String appId, QFilter orgfilter, QFilter bookDatefilter, QFilter basefilter, List<Long> costDriverId, Long costaccountId, Long periodId, boolean planData, Long planschemeId) {
        DataSet resourceData;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String algoKey = "MfgfeeAllocHelper.getResourceUse";
        filters.add(new QFilter("appnum", "=", (Object)appId));
        filters.add(new QFilter("islinkresource", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("iscomplexcd", "=", (Object)Boolean.FALSE));
        if (!CadEmptyUtils.isEmpty(costDriverId)) {
            filters.add(new QFilter("id", "in", costDriverId));
        }
        DataSet resourceDriver = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id,matchpattern,resource.fbasedataid resource,resourcetype,matchreport", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet resource = resourceDriver.filter("matchpattern = 'resource'").select("id,resource,matchreport");
        DataSet resourcetype = resourceDriver.filter("matchpattern = 'resourcetype'").select("id,resource,resourcetype,matchreport");
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        RowMeta rowMeta = resourcetype.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourcetype) {
            String[] split;
            String resourcetype1 = row.getString("resourcetype");
            for (String str : split = resourcetype1.split(",")) {
                if (CadEmptyUtils.isEmpty(str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[rowMeta.getFieldIndex((String)"resourcetype")] = str;
                datasetlist.add(rowData);
            }
        }
        resourcetype = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("id,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,matchreport");
        DataSet resoureAndType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,resourcesentryentity.itemclasstype resourcetype", null, null);
        resourcetype = resourcetype.join(resoureAndType, JoinType.INNER).on("resourcetype", "resourcetype").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid"}).finish();
        resourcetype = resourcetype.groupBy(new String[]{"id", "resourceid", "matchreport"}).finish().select("id,resourceid resource,matchreport");
        filters.clear();
        if (planData) {
            filters.add(new QFilter("costaccount", "=", (Object)costaccountId));
            filters.add(new QFilter("period", "=", (Object)periodId));
            filters.add(new QFilter("planscheme", "=", (Object)planschemeId));
            resourceData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planresource", (String)"org,id as resourceid,billno,manuorg,costcenter,resource,case when resourceunit=10 then qty*60 when resourceunit=8 then qty/60 else qty end value", (QFilter[])filters.toArray(new QFilter[0]), null);
            resourceData = resourceData.select("org,resourceid,billno,manuorg,costcenter,resource,value");
            resource = resource.join(resourceData, JoinType.INNER).on("resource", "resource").select(resource.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "org", "manuorg", "costcenter", "value"}).finish();
            resourcetype = resourcetype.join(resourceData, JoinType.INNER).on("resource", "resource").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "org", "manuorg", "costcenter", "value"}).finish();
            resource = resource.union(resourcetype).select("id as costdriver,org,resourceid,billno,manuorg,costcenter,value");
            resource = resource.groupBy(new String[]{"costdriver", "org", "manuorg", "costcenter", "resourceid", "billno"}).sum("value").finish();
            resource = resource.select("costdriver,resourceid as id,billno,org,manuorg,costcenter,value,'cad_planresource' as billtypenum,0 as unit");
        } else {
            filters.add(orgfilter);
            filters.add(bookDatefilter);
            resourceData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)"org,id as resourceid,billno,manuorg,costcenter,resource,resource.resourcesentryentity.itemclasstype as resourcetype,entryentity.workhour as workhour,entryentity.facthour as facthour,entryentity.factuse as factuse,entryentity.costobject as costobject", (QFilter[])filters.toArray(new QFilter[0]), null);
            resourceData = resourceData.select("org,resourceid,billno,manuorg,costcenter,resource,resourcetype,workhour,facthour,factuse,costobject");
            resource = resource.join(resourceData, JoinType.INNER).on("resource", "resource").select(resource.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "workhour", "org", "manuorg", "costcenter", "facthour", "factuse"}).finish();
            resourcetype = resourcetype.join(resourceData, JoinType.INNER).on("resource", "resource").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid", "billno", "workhour", "org", "manuorg", "costcenter", "facthour", "factuse"}).finish();
            resource = resource.union(resourcetype).select("id,resourceid,billno,resource,matchreport,org,manuorg,costcenter,workhour as unit,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour,factuse");
            resource = resource.select("id as costdriver,org,resourceid,billno,manuorg,costcenter,unit,case when matchreport='total' then facthour else factuse end value");
            resource = resource.groupBy(new String[]{"costdriver", "org", "manuorg", "costcenter", "resourceid", "billno"}).sum("value").finish();
            resource = resource.select("costdriver,resourceid as id,billno,org,manuorg,costcenter,value,'sca_resourceuse' as billtypenum,0 as unit");
        }
        return resource;
    }

    public DataSet getHasInputCostenter(Long orgId, Long periodId, String appnum) {
        String algokey = "MfgfeeAllocHelper.getHasInputCostenter";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter datefilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appnum);
        basefilter.and("entryentity.facthour", "!=", (Object)0L);
        DataSet resourceCollect = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_resourceuse", (String)"org,manuorg,costcenter", (QFilter[])new QFilter[]{orgFilter, datefilter, basefilter}, null);
        resourceCollect = resourceCollect.groupBy(new String[]{"org", "manuorg", "costcenter"}).finish();
        return resourceCollect;
    }

    public DataSet getHasWipCompleteCenter(Long orgId, Long periodId, String appNum) {
        String algoKey = "MfgfeeAllocHelper.getHasWipCompleteCenter";
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = this.getBookDateFilter(periodId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appNum);
        DataSet factDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty", (QFilter[])new QFilter[]{filter, dateFilter}, null);
        factDs = factDs.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("completeqty").finish();
        factDs = factDs.filter("completeqty !=0");
        return factDs;
    }

    public DataSet getChooseNoInputCostenter(Long orgId, Long periodId) {
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper.getChooseNoInputCostenter";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("allocmold", "=", (Object)"C");
        orgfilter.and("billstatus", "=", (Object)"C");
        orgfilter.and("execondition", "=", (Object)"NO_WORK");
        QFilter isSenderFilter = new QFilter("issender", "=", (Object)Boolean.TRUE);
        DataSet noInputCostenter = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"costcenter", (QFilter[])new QFilter[]{orgfilter, isSenderFilter}, null);
        QFilter isNotSenderFilter = new QFilter("issender", "=", (Object)Boolean.FALSE);
        DataSet noInputCostenterGroup = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"costcentergroup", (QFilter[])new QFilter[]{orgfilter, isNotSenderFilter}, null);
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        noInputCostenterGroup = noInputCostenterGroup.leftJoin(costCenterGroup).on("costcentergroup", "id").select(new String[]{"costcenter"}).finish();
        noInputCostenter = noInputCostenter.union(noInputCostenterGroup);
        return noInputCostenter;
    }

    public DataSet chooseNoComCostCenterSet(long orgId, long periodId) {
        String algoKey = "kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper.getChooseNoInputCostenter";
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        orgfilter.and("allocmold", "=", (Object)"C");
        orgfilter.and("billstatus", "=", (Object)"C");
        orgfilter.and("execondition", "=", (Object)"NO_COM");
        QFilter isSenderFilter = new QFilter("issender", "=", (Object)Boolean.TRUE);
        DataSet noInputCostenter = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"costcenter", (QFilter[])new QFilter[]{orgfilter, isSenderFilter}, null);
        QFilter isNotSenderFilter = new QFilter("issender", "=", (Object)Boolean.FALSE);
        DataSet noInputCostenterGroup = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"costcentergroup", (QFilter[])new QFilter[]{orgfilter, isNotSenderFilter}, null);
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        noInputCostenterGroup = noInputCostenterGroup.leftJoin(costCenterGroup).on("costcentergroup", "id").select(new String[]{"costcenter"}).finish();
        noInputCostenter = noInputCostenter.union(noInputCostenterGroup);
        return noInputCostenter;
    }

    public static boolean isEnableMulFactory(Long calOrgId) {
        if (calOrgId == null) {
            return false;
        }
        Boolean multiFactoryAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"multifactoryaccount");
        if (multiFactoryAccount == null) {
            return false;
        }
        return multiFactoryAccount;
    }

    public static String setToSql(Set<Long> ids) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return "(-1)";
        }
        StringBuilder sql = new StringBuilder();
        sql.append('(');
        for (Long id : ids) {
            sql.append(id).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        return sql.toString();
    }

    private QFilter getDatefilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    private QFilter getEffectDateFilter(Long periodId) {
        Date date = MfgfeeAllocHelper.getEndDateByPeriod(periodId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private static Date getEndDateByPeriod(Long periodId) {
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])qFilter.toArray());
        if (period == null) {
            return new Date();
        }
        return period.getDate("enddate");
    }

    public QFilter getBookDateFilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    public static Long getId() {
        return ID.genLongId();
    }

    public DataSet getStdValueNotDiyByIds(List<Long> costDriverId, Long orgId, Long periodId, String appId, Long costaccountId, boolean planData, Long planschemeId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookDateFilter = this.getBookDateFilter(periodId);
        QFilter baseFilter = new QFilter("billstatus", "=", (Object)"C");
        baseFilter.and("appnum", "=", (Object)appId);
        DataSet resource = this.getResourceUse(appId, orgFilter, bookDateFilter, baseFilter, costDriverId, costaccountId, periodId, planData, planschemeId);
        resource = resource.select("costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,value,billtypenum");
        return resource;
    }

    public DataSet getComplexValueNotDiy(Long orgId, Long costAccountId, Long periodId, String appId, List<Long> costDriverIds, boolean enableMulFactory, boolean planData, Long planschemeId) throws KDBizException {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter idFilter = new QFilter("id", "in", costDriverIds);
        QFilter baseFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        baseFilter.and("appnum", "=", (Object)appId);
        filters.add(idFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("iscomplexcd", "=", (Object)Boolean.TRUE));
        String algoKey = "MfgfeeAllocHelper#getComplexValueNotDiy";
        DataSet costCenterComplexDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id,formula,number,name,costtype", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet complexDriverDs = null;
        for (Row row : costCenterComplexDriverDs) {
            String formula = row.getString("formula");
            String currentNumber = row.getString("number");
            String currentName = row.getString("name");
            long complexDriverId = row.getLong("id");
            try {
                formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, complexDriverId);
            }
            catch (KDBizException e) {
                logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
                throw e;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (formula.contains(String.valueOf(CostDriverIdConstant.STANDARD_COST_ACA))) {
                paramMap.put("simulCostTypeId", row.getLong("costtype"));
            }
            logger.info("formula is:{}", (Object)formula);
            List<String> suffixList = FormulaUtil.analyticFormula(formula);
            DataSet opResultDs = null;
            if (!CadEmptyUtils.isEmpty(suffixList)) {
                logger.info("suffixList is:{}", (Object)suffixList.toString());
                long start = System.currentTimeMillis();
                HashSet<Long> costDriverIdSet = new HashSet<Long>(16);
                for (String suffix : suffixList) {
                    if (!MfgfeeAllocHelper.isInteger(suffix)) continue;
                    costDriverIdSet.add(Long.parseLong(suffix));
                }
                QFilter driverFilter = new QFilter("id", "in", costDriverIdSet);
                QFilter qFilter = new QFilter("allocclass", "=", (Object)"COSTOBJECT");
                boolean isExistCostObject = QueryServiceHelper.exists((String)"cad_costdriver", (QFilter[])new QFilter[]{driverFilter, qFilter});
                if (isExistCostObject) {
                    opResultDs = FormulaUtil.doCalculateOnCostObject(complexDriverId, suffixList, orgId, costAccountId, periodId, appId, enableMulFactory, planData, planschemeId);
                    if (opResultDs != null) {
                        opResultDs = enableMulFactory ? opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,manuorg,costcenter,sum(value) as value group by org,manuorg,costcenter") : opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,0 as manuorg,costcenter,sum(value) as value group by org,costcenter");
                    }
                } else {
                    DynamicObjectCollection drivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id, islinkresource", (QFilter[])driverFilter.toArray());
                    boolean isAllLinkresource = true;
                    for (DynamicObject driverObject : drivers) {
                        if (driverObject.getBoolean("islinkresource")) continue;
                        isAllLinkresource = false;
                        break;
                    }
                    if (isAllLinkresource) {
                        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
                        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                        QFilter billFilter = new QFilter("billstatus", "=", (Object)"C");
                        billFilter.and("appnum", "=", (Object)appId);
                        QFilter bookDateFilter = this.getBookDateFilter(periodId);
                        DataSet costObjectResourceUse = mfgfeeAllocHelper.getCOResourceUse(appId, orgFilter, bookDateFilter, billFilter, costDriverIdSet, costAccountId, periodId, planData, planschemeId);
                        costObjectResourceUse = costObjectResourceUse.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costobject,material,sum(value) value group by costdriver,id,billno,org,manuorg,costcenter,costobject,material");
                        costObjectResourceUse = costObjectResourceUse.executeSql("select costdriver,id,billno,org,manuorg,costcenter,costcenter as benefcostcenter,costobject,material,value,'sca_resourceuse' as billtypenum");
                        paramMap.put("exp", suffixList);
                        paramMap.put("material", new ArrayList());
                        paramMap.put("materialGroup", new ArrayList());
                        paramMap.put("orgId", orgId);
                        paramMap.put("costAccountId", costAccountId);
                        paramMap.put("periodId", periodId);
                        paramMap.put("appId", appId);
                        paramMap.put("enableMulFactory", enableMulFactory);
                        paramMap.put("costObjectId", costDriverIdSet);
                        paramMap.put("isDisableAllocCalcReport", false);
                        if (costObjectResourceUse != null && !costObjectResourceUse.isEmpty() && (opResultDs = FormulaUtil.startCostObjectCalculate(paramMap, costObjectResourceUse, null, false)) != null) {
                            opResultDs = enableMulFactory ? opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,manuorg,costcenter,sum(value) as value group by org,manuorg,costcenter") : opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,0 as manuorg,costcenter,sum(value) as value group by org,costcenter");
                        }
                    }
                }
                logger.info(String.format("getComplexValueNotDiy\u590d\u5408\u6210\u672c\u52a8\u56e0:%s \u8ba1\u7b97\u8017\u65f6:%s \u6beb\u79d2", complexDriverId, System.currentTimeMillis() - start));
            }
            if (complexDriverDs == null) {
                complexDriverDs = opResultDs;
                continue;
            }
            if (complexDriverDs == null || opResultDs == null) continue;
            complexDriverDs = complexDriverDs.union(opResultDs);
        }
        return complexDriverDs;
    }

    public DataSet getComplexValueDiy(Long orgId, Long costAccountId, Long periodId, String appId, List<Long> costDriverIds, String allocClass, boolean enableMulFactory, boolean planData, Long planschemeId) throws KDBizException {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter idFilter = new QFilter("id", "in", costDriverIds);
        QFilter baseFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        baseFilter.and("appnum", "=", (Object)appId);
        filters.add(idFilter);
        filters.add(baseFilter);
        filters.add(new QFilter("iscomplexcd", "=", (Object)Boolean.TRUE));
        String algoKey = "MfgfeeAllocHelper#getComplexValueDiy";
        DataSet costCenterComplexDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id,formula,number,name", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet complexDriverDs = null;
        for (Row row : costCenterComplexDriverDs) {
            String formula = row.getString("formula");
            String currentNumber = row.getString("number");
            String currentName = row.getString("name");
            long complexDriverId = row.getLong("id");
            try {
                formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, complexDriverId);
            }
            catch (KDBizException e) {
                logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
                throw e;
            }
            logger.info("formula is:{}", (Object)formula);
            List<String> suffixList = FormulaUtil.analyticFormula(formula);
            DataSet opResultDs = null;
            if (!CadEmptyUtils.isEmpty(suffixList)) {
                logger.info("suffixList is:{}", (Object)suffixList.toString());
                long start = System.currentTimeMillis();
                if (allocClass.equals("COSTCENTER")) {
                    HashSet<Long> costDriverIdSet = new HashSet<Long>(16);
                    for (String suffix : suffixList) {
                        if (!MfgfeeAllocHelper.isInteger(suffix)) continue;
                        costDriverIdSet.add(Long.parseLong(suffix));
                    }
                    QFilter qFilter = new QFilter("id", "in", costDriverIdSet);
                    qFilter.and("allocclass", "=", (Object)"COSTOBJECT");
                    boolean isExistCostObject = QueryServiceHelper.exists((String)"cad_costdriver", (QFilter[])qFilter.toArray());
                    if (!isExistCostObject && (opResultDs = FormulaUtil.doCalculateOnCostCenter(suffixList, orgId, costAccountId, periodId, appId, enableMulFactory, planData, planschemeId)) != null) {
                        opResultDs = enableMulFactory ? opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,manuorg,costcenter,benefcostcenter,value") : opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,0 as manuorg,costcenter,benefcostcenter,value");
                    }
                } else if (allocClass.equals("COSTOBJECT") && (opResultDs = FormulaUtil.doCalculateOnCostObject(complexDriverId, suffixList, orgId, costAccountId, periodId, appId, enableMulFactory, planData, planschemeId)) != null) {
                    opResultDs = enableMulFactory ? opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,manuorg,costcenter,costobject,material,value") : opResultDs.executeSql("select " + complexDriverId + " as costdriver,org,0 as manuorg,costcenter,costobject,material,value");
                }
                logger.info(String.format("\u590d\u5408\u6210\u672c\u52a8\u56e0:%s \u8ba1\u7b97\u8017\u65f6:%s \u6beb\u79d2", complexDriverId, System.currentTimeMillis() - start));
            }
            if (complexDriverDs == null) {
                complexDriverDs = opResultDs;
                continue;
            }
            if (complexDriverDs == null || opResultDs == null) continue;
            complexDriverDs = complexDriverDs.union(opResultDs);
        }
        return complexDriverDs;
    }

    public DataSet getCostdriverStdVal(Long orgId, Long costAccountId, Long periodId, String appId, List<Long> costDriverIds, boolean enableMulFactory) {
        DataSet resultDs;
        logger.info("\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u5f00\u59cb\uff1a{}", costDriverIds);
        QFilter filter = new QFilter("id", "in", costDriverIds);
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and("appnum", "=", (Object)appId);
        String algoKey = "MfgfeeAllocHelper#getComplexValueDiy";
        DataSet costCenterComplexDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id,iscomplexcd,allocclass", (QFilter[])filter.toArray(), null);
        if (costCenterComplexDriverDs.isEmpty()) {
            return null;
        }
        ArrayList<Long> comCCCostdriverIds = new ArrayList<Long>(10);
        ArrayList<Long> comCBCostdriverIds = new ArrayList<Long>(10);
        ArrayList<DataSet> resultDsList = new ArrayList<DataSet>(10);
        for (Row row : costCenterComplexDriverDs) {
            String allocclass = row.getString("allocclass");
            Long costdriverId = row.getLong("id");
            Boolean iscomplexcd = row.getBoolean("iscomplexcd");
            if (iscomplexcd != null && iscomplexcd.booleanValue()) {
                if ("COSTCENTER".equals(allocclass)) {
                    comCCCostdriverIds.add(costdriverId);
                    continue;
                }
                comCBCostdriverIds.add(costdriverId);
                continue;
            }
            Object resultDs2 = FormulaUtil.getCostdriverStdValOnCostObject(costdriverId, orgId, costAccountId, periodId, appId, enableMulFactory);
            if ("COSTCENTER".equals(allocclass) && resultDs2 != null) {
                resultDs2 = resultDs2.select("costdriver,benefcostcenter as costcenter,value,org");
            }
            if (resultDs2 == null) continue;
            resultDsList.add((DataSet)resultDs2);
        }
        if (!CadEmptyUtils.isEmpty(comCCCostdriverIds)) {
            DataSet complexNotDiyDs;
            resultDs = this.getComplexValueDiy(orgId, costAccountId, periodId, appId, comCCCostdriverIds, "COSTCENTER", enableMulFactory, false, 0L);
            if (resultDs != null) {
                resultDsList.add(resultDs);
            }
            if ((complexNotDiyDs = this.getComplexValueNotDiy(orgId, costAccountId, periodId, appId, comCCCostdriverIds, enableMulFactory, false, 0L)) != null) {
                resultDsList.add(complexNotDiyDs);
            }
        }
        if (!CadEmptyUtils.isEmpty(comCBCostdriverIds) && (resultDs = this.getComplexValueDiy(orgId, costAccountId, periodId, appId, comCBCostdriverIds, "COSTOBJECT", enableMulFactory, false, 0L)) != null) {
            resultDsList.add(resultDs);
        }
        DataSet unionDs = null;
        ArrayList<DataSet> resultDsList1 = new ArrayList<DataSet>(10);
        for (DataSet resultDs3 : resultDsList) {
            if (resultDs3.getRowMeta().getFieldIndex("costobject", false) < 0) {
                resultDs3 = resultDs3.addField("0L", "costobject");
            }
            resultDs3 = resultDs3.select("costdriver,costobject,costcenter,value");
            resultDsList1.add(resultDs3);
        }
        resultDsList = resultDsList1;
        logger.info("\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u83b7\u53d6\u5206\u914d\u6807\u51c6\u503c\u67e5\u8be2\u7ed3\u675f\uff1a{}", (Object)resultDsList.size());
        if (resultDsList.isEmpty()) {
            return null;
        }
        if (resultDsList.size() == 1) {
            unionDs = (DataSet)resultDsList.get(0);
        } else {
            unionDs = (DataSet)resultDsList.get(0);
            resultDsList.remove(0);
            unionDs = unionDs.union(resultDsList.toArray(new DataSet[0]));
        }
        DataSet ds = unionDs.groupBy(new String[]{"costdriver", "costobject", "costcenter"}).sum("value").finish();
        DataSet copyDs = ds.copy();
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : copyDs) {
            Long costobjectId = row.getLong("costobject");
            if (CadEmptyUtils.isEmpty(costobjectId)) continue;
            costobjectIds.add(costobjectId);
        }
        if (!costobjectIds.isEmpty()) {
            QFilter cbfilter = new QFilter("id", "in", (Object)costobjectIds);
            DataSet cbDs = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"id,costcenter benecostcenter", (QFilter[])cbfilter.toArray(), null);
            ds = ds.leftJoin(cbDs).on("costobject", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"benecostcenter"}).finish();
            ds = ds.select("costdriver,costobject,value,case when benecostcenter is not null then benecostcenter else costcenter end costcenter");
        }
        return ds;
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public Boolean isDisableAllocCalcReport(String appId) {
        if (this.getSaveCalcReport().booleanValue()) {
            QFilter filter = new QFilter("key", "=", (Object)"disableAllocCalcReport");
            DynamicObject param = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
            if (param == null) {
                if ("sca".equals(appId)) {
                    return false;
                }
                return true;
            }
            return param.getBoolean("value");
        }
        return false;
    }

    public static boolean isNewAllocType() {
        String newAllocType = CadBgParamUtils.getCadBgParamForString((String)"newAllocType", (String)"1");
        return "1".equals(newAllocType);
    }

    public Boolean getSaveCalcReport() {
        return saveCalcReport;
    }

    public void setSaveCalcReport(Boolean saveCalcReport) {
        MfgfeeAllocHelper.saveCalcReport = saveCalcReport;
    }
}

