/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import net.sf.json.JSONObject;

public class MfgfeeAllocReportHelper {
    private static final Log logger = LogFactory.getLog(MfgfeeAllocReportHelper.class);

    public static Long initAllocReport(String reportParamStr, String appnum, Long planschemeId) {
        DynamicObject allocReport = BusinessDataServiceHelper.newDynamicObject((String)"cad_allocreport");
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        long costaccount = reportParamJs.getLong("costaccount");
        boolean enableMulFactory = MfgfeeAllocHelper.isEnableMulFactory(costaccount);
        long id = DB.genGlobalLongId();
        allocReport.set("id", (Object)id);
        allocReport.set("taskname", (Object)reportParamJs.getString("taskname"));
        allocReport.set("org", (Object)reportParamJs.getLong("org"));
        allocReport.set("costaccount", (Object)costaccount);
        if (enableMulFactory) {
            allocReport.set("manuorg", (Object)reportParamJs.getLong("manuorg"));
        } else {
            allocReport.set("manuorg", (Object)0L);
        }
        allocReport.set("period", (Object)reportParamJs.getLong("period"));
        allocReport.set("currency", (Object)reportParamJs.getLong("currency"));
        allocReport.set("starttime", (Object)new Date(reportParamJs.getLong("starttime")));
        allocReport.set("status", (Object)"4");
        allocReport.set("reporttype", (Object)ResManager.loadKDString((String)"\u5206\u914d\u62a5\u544a", (String)"MfgfeeAllocReportHelper_0", (String)"macc-cad-algox", (Object[])new Object[0]));
        allocReport.set("executor", (Object)reportParamJs.getLong("executor"));
        allocReport.set("appnum", (Object)appnum);
        allocReport.set("planscheme", (Object)planschemeId);
        if (reportParamJs.has("isplandata")) {
            allocReport.set("isplandata", (Object)reportParamJs.getString("isplandata"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocReport});
        return id;
    }

    public static void writeReportEntry(Long reportId, String reportParamStr, DataSet withoutStandard) {
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        boolean isEmpty = withoutStandard == null || withoutStandard.isEmpty();
        long entryId = MfgfeeAllocHelper.getId();
        int reportSeq = reportParamJs.getInt("seq");
        String fcheckitem = reportParamJs.getString("checkitem");
        String fallocresult = reportParamJs.getString("allocresult");
        String fcheckdetail = reportParamJs.getString("checkdetail");
        String detailInfo = reportParamJs.getString("detailInfo");
        if (!"2".equals(fallocresult)) {
            fallocresult = isEmpty ? "1" : "2";
            fcheckdetail = isEmpty ? " " : fcheckdetail;
        }
        Object[] reportEntry = new Object[]{reportId, entryId, reportSeq, fcheckitem, fallocresult, fcheckdetail};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportentry(fid,fentryid,fseq,fcheckitem,fallocresult,fcheckdetail) values(?,?,?,?,?,?)", (Object[])reportEntry);
        if (isEmpty) {
            return;
        }
        Object[] reportDetail = new Object[]{entryId, reportParamJs.getLong("org"), reportParamJs.getLong("costaccount"), reportParamJs.getLong("period"), 0L, 0L, new Date(reportParamJs.getLong("starttime")), fcheckitem};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportdetail(fid,forgid,fcostaccountid,fperiodid,fmanuorgid,fcostcenterid,fstarttime,fcheckitemdesc) values(?,?,?,?,?,?,?,?)", (Object[])reportDetail);
        ArrayList<Object[]> detailEntrys = new ArrayList<Object[]>();
        int detailSeq = 0;
        DataSet group = withoutStandard.groupBy(new String[]{"costcenter", "costcentername", "expenseitem", "expenseitemname", "expenseitemnumber"}).finish();
        for (Row row : group) {
            StringBuilder sb = new StringBuilder();
            sb.append('\u3010').append(row.getString("costcentername")).append('\u3011').append(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u76ee", (String)"MfgfeeAllocReportHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]));
            sb.append('\u3010').append(row.getString("expenseitemnumber")).append('/').append(row.getString("expenseitemname")).append('\u3011').append(detailInfo);
            Object[] detailEntry = new Object[]{entryId, MfgfeeAllocHelper.getId(), detailSeq++, row.getLong("costcenter"), sb.toString()};
            detailEntrys.add(detailEntry);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_alloreptdetailentry(fid,fentryid,fseq,fsubcostcenternum,fcheckdetail) values (?,?,?,?,?)", detailEntrys);
    }

    public static void writeInnerAllocReportEntry(Long reportId, String reportParamStr, DataSet withoutStandard) {
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        boolean isEmpty = withoutStandard == null || withoutStandard.isEmpty();
        long entryId = MfgfeeAllocHelper.getId();
        int reportSeq = reportParamJs.getInt("seq");
        String fcheckitem = reportParamJs.getString("checkitem");
        String fallocresult = reportParamJs.getString("allocresult");
        String fcheckdetail = reportParamJs.getString("checkdetail");
        String detailInfo = reportParamJs.getString("detailInfo");
        if (!"2".equals(fallocresult)) {
            fallocresult = isEmpty ? "1" : "2";
            fcheckdetail = isEmpty ? " " : fcheckdetail;
        }
        Object[] reportEntry = new Object[]{reportId, entryId, reportSeq, fcheckitem, fallocresult, fcheckdetail};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportentry(fid,fentryid,fseq,fcheckitem,fallocresult,fcheckdetail) values(?,?,?,?,?,?)", (Object[])reportEntry);
        if (isEmpty) {
            return;
        }
        Object[] reportDetail = new Object[]{entryId, reportParamJs.getLong("org"), reportParamJs.getLong("costaccount"), reportParamJs.getLong("period"), 0L, 0L, new Date(reportParamJs.getLong("starttime")), fcheckitem};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportdetail(fid,forgid,fcostaccountid,fperiodid,fmanuorgid,fcostcenterid,fstarttime,fcheckitemdesc) values(?,?,?,?,?,?,?,?)", (Object[])reportDetail);
        ArrayList<Object[]> detailEntrys = new ArrayList<Object[]>();
        int detailSeq = 0;
        DataSet group = withoutStandard.groupBy(new String[]{"benefcostcenter", "benefcostcentername", "costdrivername"}).finish();
        for (Row row : group) {
            StringBuilder sb = new StringBuilder();
            sb.append('\u3010').append(row.getString("benefcostcentername")).append('\u3011').append(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6", (String)"MfgfeeAllocReportHelper_2", (String)"macc-cad-algox", (Object[])new Object[0]));
            sb.append('\u3010').append(row.getString("costdrivername")).append('\u3011').append(detailInfo);
            Object[] detailEntry = new Object[]{entryId, MfgfeeAllocHelper.getId(), detailSeq++, row.getLong("benefcostcenter"), sb.toString()};
            detailEntrys.add(detailEntry);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_alloreptdetailentry(fid,fentryid,fseq,fsubcostcenternum,fcheckdetail) values (?,?,?,?,?)", detailEntrys);
    }

    public static String writeReport(Long reportId, String reportParamStr, String result) {
        long useTime;
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        long startTime = reportParamJs.getLong("starttime");
        long endTime = new Date().getTime();
        long l = useTime = (endTime - startTime) / 1000L == 0L ? 1L : (endTime - startTime) / 1000L;
        if (AllocResultEnum.Failure.getResult().equals(result)) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_allocreport set fstatus = " + result + ",fusetime=" + useTime + " where fid = " + reportId));
            return result;
        }
        DynamicObjectCollection reportEntrys = QueryServiceHelper.query((String)"cad_allocreport", (String)"entryentity.allocresult allocresult", (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        result = AllocResultEnum.ALLSUCCESS.getResult();
        for (DynamicObject reportEntry : reportEntrys) {
            String allocresult = reportEntry.getString("allocresult");
            if (!"2".equals(allocresult)) continue;
            result = AllocResultEnum.PartSUCCESS.getResult();
        }
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cad_allocreport set fstatus = " + result + ",fusetime=" + useTime + " where fid = " + reportId));
        return result;
    }

    public static void writeReportEntryForMulStand(Long reportId, String reportParamStr, DataSet mulStandOnCostCenter) {
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        boolean isEmpty = mulStandOnCostCenter == null || mulStandOnCostCenter.isEmpty();
        long entryId = DB.genLongId((String)"t_cad_allocreportentry");
        int reportSeq = reportParamJs.getInt("seq");
        long org = reportParamJs.getLong("org");
        String fcheckitem = reportParamJs.getString("checkitem");
        String fallocresult = reportParamJs.getString("allocresult");
        String fcheckdetail = reportParamJs.getString("checkdetail");
        if (!"2".equals(fallocresult)) {
            fallocresult = isEmpty ? "1" : "2";
            fcheckdetail = isEmpty ? " " : fcheckdetail;
        }
        Object[] reportEntry = new Object[]{reportId, entryId, reportSeq, fcheckitem, fallocresult, fcheckdetail};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportentry(fid,fentryid,fseq,fcheckitem,fallocresult,fcheckdetail) values(?,?,?,?,?,?)", (Object[])reportEntry);
        if (isEmpty) {
            return;
        }
        Object[] reportDetail = new Object[]{entryId, org, reportParamJs.getLong("costaccount"), reportParamJs.getLong("period"), 0L, 0L, new Date(reportParamJs.getLong("starttime")), fcheckitem};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportdetail(fid,forgid,fcostaccountid,fperiodid,fmanuorgid,fcostcenterid,fstarttime,fcheckitemdesc) values(?,?,?,?,?,?,?,?)", (Object[])reportDetail);
        ArrayList<Object[]> detailEntrys = new ArrayList<Object[]>();
        int detailSeq = 0;
        for (Row row : mulStandOnCostCenter) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a", (String)"MfgfeeAllocReportHelper_3", (String)"macc-cad-algox", (Object[])new Object[0])).append(row.getString("costCenterBill")).append(" -> ").append(row.getString("costCenterGroupBill"));
            Object[] detailEntry = new Object[]{entryId, MfgfeeAllocHelper.getId(), detailSeq++, row.getLong("costcenter"), sb.toString()};
            detailEntrys.add(detailEntry);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_alloreptdetailentry(fid,fentryid,fseq,fsubcostcenternum,fcheckdetail) values (?,?,?,?,?)", detailEntrys);
    }

    public static void writeReportEntry_BasicALloc(Long reportId, String reportParamStr, DataSet withoutStandard) {
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        boolean isEmpty = withoutStandard == null || withoutStandard.isEmpty();
        long entryId = MfgfeeAllocHelper.getId();
        int reportSeq = reportParamJs.getInt("seq");
        long org = reportParamJs.getLong("org");
        String fcheckitem = reportParamJs.getString("checkitem");
        String fallocresult = reportParamJs.getString("allocresult");
        String fcheckdetail = reportParamJs.getString("checkdetail");
        String detailInfo = reportParamJs.getString("detailInfo");
        if (!"2".equals(fallocresult)) {
            fallocresult = isEmpty ? "1" : "2";
            fcheckdetail = isEmpty ? " " : fcheckdetail;
        }
        Object[] reportEntry = new Object[]{reportId, entryId, reportSeq, fcheckitem, fallocresult, fcheckdetail};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportentry(fid,fentryid,fseq,fcheckitem,fallocresult,fcheckdetail) values(?,?,?,?,?,?)", (Object[])reportEntry);
        if (isEmpty) {
            return;
        }
        Object[] reportDetail = new Object[]{entryId, org, reportParamJs.getLong("costaccount"), reportParamJs.getLong("period"), 0L, 0L, new Date(reportParamJs.getLong("starttime")), fcheckitem};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportdetail(fid,forgid,fcostaccountid,fperiodid,fmanuorgid,fcostcenterid,fstarttime,fcheckitemdesc) values(?,?,?,?,?,?,?,?)", (Object[])reportDetail);
        ArrayList<Object[]> detailEntrys = new ArrayList<Object[]>();
        HashMap<Long, String> costCenterMap = new HashMap<Long, String>(128);
        DynamicObjectCollection costCenterDO = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter("accountorg", "=", (Object)org).toArray());
        for (DynamicObject costcenter : costCenterDO) {
            costCenterMap.put(costcenter.getLong("id"), costcenter.getString("name"));
        }
        int detailSeq = 0;
        DataSet group = withoutStandard.groupBy(new String[]{"costcenter", "costcentername", "expenseitemname", "expenseitemnumber", "path", "curbenefcostcenter"}).finish();
        for (Row row : group) {
            String[] paths = row.getString("path").split("@");
            StringBuilder sb = new StringBuilder();
            sb.append('\u3010').append(row.getString("costcentername")).append('\u3011');
            sb.append('\u3010').append(row.getString("expenseitemnumber")).append('/').append(row.getString("expenseitemname")).append('\u3011');
            for (String path : paths) {
                sb.append("->").append((String)costCenterMap.get(Long.parseLong(path)));
            }
            sb.append("->").append((String)costCenterMap.get(row.getLong("curbenefcostcenter")));
            Object[] detailEntry = new Object[]{entryId, MfgfeeAllocHelper.getId(), detailSeq++, row.getLong("costcenter"), sb.toString()};
            detailEntrys.add(detailEntry);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_alloreptdetailentry(fid,fentryid,fseq,fsubcostcenternum,fcheckdetail) values (?,?,?,?,?)", detailEntrys);
    }

    public static void writeReportEntry_BasicAllocTips(Long reportId, String reportParamStr, DataSet withoutStandard) {
        JSONObject reportParamJs = JSONObject.fromObject((Object)reportParamStr);
        boolean isEmpty = withoutStandard == null || withoutStandard.isEmpty();
        long entryId = DB.genLongId((String)"t_cad_allocreportentry");
        int reportSeq = reportParamJs.getInt("seq");
        String fcheckitem = reportParamJs.getString("checkitem");
        String fallocresult = reportParamJs.getString("allocresult");
        String fcheckdetail = reportParamJs.getString("checkdetail");
        String detailInfo = reportParamJs.getString("detailInfo");
        if (!"2".equals(fallocresult)) {
            fallocresult = isEmpty ? "1" : "2";
            fcheckdetail = isEmpty ? " " : fcheckdetail;
        }
        Object[] reportEntry = new Object[]{reportId, entryId, reportSeq, fcheckitem, fallocresult, fcheckdetail};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportentry(fid,fentryid,fseq,fcheckitem,fallocresult,fcheckdetail) values(?,?,?,?,?,?)", (Object[])reportEntry);
        if (isEmpty) {
            return;
        }
        Object[] reportDetail = new Object[]{entryId, reportParamJs.getLong("org"), reportParamJs.getLong("costaccount"), reportParamJs.getLong("period"), 0L, 0L, new Date(reportParamJs.getLong("starttime")), fcheckitem};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_allocreportdetail(fid,forgid,fcostaccountid,fperiodid,fmanuorgid,fcostcenterid,fstarttime,fcheckitemdesc) values(?,?,?,?,?,?,?,?)", (Object[])reportDetail);
        ArrayList<Object[]> detailEntrys = new ArrayList<Object[]>();
        int detailSeq = 0;
        DataSet group = withoutStandard.groupBy(new String[]{"benefcostcenter", "expenseitem", "expenseitemname", "expenseitemnumber"}).finish();
        DynamicObjectCollection costCenterDOs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter("accountorg", "=", (Object)reportParamJs.getLong("org")).toArray());
        HashMap<Long, String> costCenterAndName = new HashMap<Long, String>(256);
        for (DynamicObject costCenterDO : costCenterDOs) {
            costCenterAndName.put(costCenterDO.getLong("id"), costCenterDO.getString("name"));
        }
        for (Row row : group) {
            StringBuilder sb = new StringBuilder();
            String benefcostcenter = (String)costCenterAndName.get(row.getLong("benefcostcenter"));
            sb.append('\u3010').append(benefcostcenter == null ? "" : benefcostcenter).append('\u3011').append(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u76ee", (String)"MfgfeeAllocReportHelper_1", (String)"macc-cad-algox", (Object[])new Object[0]));
            sb.append('\u3010').append(row.getString("expenseitemnumber")).append('/').append(row.getString("expenseitemname")).append('\u3011').append(detailInfo);
            Object[] detailEntry = new Object[]{entryId, MfgfeeAllocHelper.getId(), detailSeq++, row.getLong("benefcostcenter"), sb.toString()};
            detailEntrys.add(detailEntry);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"insert into t_cad_alloreptdetailentry(fid,fentryid,fseq,fsubcostcenternum,fcheckdetail) values (?,?,?,?,?)", detailEntrys);
    }
}

