/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.mfgfee.importer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.algox.function.AuxProdToBasicProdBillImportFun;
import kd.macc.cad.algox.function.NonProAndPoolToBasImpFunction;
import kd.macc.cad.algox.mfgfee.function.MfgFeeAuxProdImporterFunction;
import kd.macc.cad.algox.mfgfee.function.MfgFeeInnerCostcenterImporterFunction;
import kd.macc.cad.algox.mfgfee.function.MfgFeeNonProdImporterFunction;
import kd.macc.cad.common.utils.CadBgParamUtils;

public class MfgFeeImportAlgoxService {
    private static final Log LOG = LogFactory.getLog(MfgFeeImportAlgoxService.class);
    private static final String ALGOX_KEY_PRE = "MfgAllocImport";
    private static String[] groupByFields = new String[]{"id", "org", "costaccount", "manuorg", "period", "costcenter", "subelement", "expenseitem", "productgroup", "costdriver", "costobject", "outsourcetype"};

    public int nonProdImportCalc(DataSet ds, Map<String, Object> paramMap) {
        DataSetX mainDs;
        JobSession session = AlgoX.createSession((String)"MfgAllocImport-nonProd");
        DataSetInput processingAllocInput = new DataSetInput(ds);
        DataSetX processingAllocDx = session.fromInput((Input)processingAllocInput);
        MfgFeeNonProdImporterFunction func = new MfgFeeNonProdImporterFunction(ds.getRowMeta(), paramMap);
        String mergeNonProdImport = CadBgParamUtils.getCadBgParamForString((String)"mergeNonProdImport", (String)"1");
        if ("1".equals(mergeNonProdImport)) {
            ArrayList fieldLists = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem"});
            fieldLists.addAll((Set)paramMap.get("allocDim"));
            mainDs = processingAllocDx.groupBy(fieldLists.toArray(new String[0])).reduceGroup((GroupReduceFunction)func);
        } else {
            mainDs = processingAllocDx.groupBy(new String[]{"id", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem"}).reduceGroup((GroupReduceFunction)func);
        }
        DataSetOutput resultSet = new DataSetOutput(MfgFeeNonProdImporterFunction.targetRowMeta);
        String resultId = resultSet.getId();
        mainDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId).count("row", false);
    }

    public int auxProdImportCalc(DataSet ds, Map<String, Object> paramMap) {
        long time = System.currentTimeMillis();
        JobSession session = AlgoX.createSession((String)"MfgAllocImport-auxProd");
        DataSetInput processingAllocInput = new DataSetInput(ds);
        DataSetX processingAllocDx = session.fromInput((Input)processingAllocInput);
        MfgFeeAuxProdImporterFunction func = new MfgFeeAuxProdImporterFunction(ds.getRowMeta(), paramMap);
        DataSetX mainDs = processingAllocDx.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter"}).reduceGroup((GroupReduceFunction)func);
        DataSetOutput resultSet = new DataSetOutput(MfgFeeAuxProdImporterFunction.targetRowMeta);
        String resultId = resultSet.getId();
        mainDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        LOG.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5f15\u5165algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return session.readDataSet(resultId).count("row", false);
    }

    public int basProdFroNonProAndPooImp(DataSet dataSet, Map<String, Object> paramMap) {
        JobSession session = AlgoX.createSession((String)"MfgAllocImport-basicFromNotAux");
        DataSetInput processingAllocInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        NonProAndPoolToBasImpFunction function = new NonProAndPoolToBasImpFunction(dataSet.getRowMeta(), paramMap);
        ArrayList fieldLists = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "productgroup"});
        fieldLists.addAll((Set)paramMap.get("allocDim"));
        DataSetX mainDataSet = dataSetX.groupBy(fieldLists.toArray(new String[0])).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(NonProAndPoolToBasImpFunction.targetRowMeta);
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId).count("row", false);
    }

    public int basicProFroAuxProImp(DataSet dataSet, Map<String, Object> paramMap) {
        JobSession session = AlgoX.createSession((String)"MfgAllocImport-basicFromAux");
        DataSetInput processingAllocInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)processingAllocInput);
        AuxProdToBasicProdBillImportFun function = new AuxProdToBasicProdBillImportFun(dataSet.getRowMeta(), paramMap);
        DataSetX mainDataSet = dataSetX.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "benefcostcenter"}).reduceGroup((GroupReduceFunction)function);
        DataSetOutput dataSetOutput = new DataSetOutput(AuxProdToBasicProdBillImportFun.targetRowMeta);
        String resultId = dataSetOutput.getId();
        mainDataSet.output((Output)dataSetOutput);
        session.commit(60, TimeUnit.MINUTES);
        return session.readDataSet(resultId).count("row", false);
    }

    public int innerCostCenterBillImport(DataSet ds, Map<String, Object> paramMap) {
        DataSetX mainDs;
        JobSession session = AlgoX.createSession((String)"MfgAllocImport-innerCostCenter");
        DataSetInput processingAllocInput = new DataSetInput(ds);
        DataSetX processingAllocDx = session.fromInput((Input)processingAllocInput);
        MfgFeeInnerCostcenterImporterFunction func = new MfgFeeInnerCostcenterImporterFunction(ds.getRowMeta(), paramMap);
        boolean isMergeBill = (Boolean)paramMap.get("isMergeBill");
        if (isMergeBill) {
            ArrayList mergeGroupByFields = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "subelement", "productgroup", "costdriver", "costobject", "outsourcetype"});
            Set allocDimSet = (Set)paramMap.get("allocDim");
            mergeGroupByFields.addAll(allocDimSet);
            mainDs = processingAllocDx.groupBy(mergeGroupByFields.toArray(new String[0])).reduceGroup((GroupReduceFunction)func);
        } else {
            mainDs = processingAllocDx.groupBy(groupByFields).reduceGroup((GroupReduceFunction)func);
        }
        DataSetOutput resultSet = new DataSetOutput(MfgFeeInnerCostcenterImporterFunction.targetRowMeta);
        String resultId = resultSet.getId();
        mainDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId).count("row", false);
    }
}

