/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.algox.constants.BalanceQueryParam;
import kd.macc.cad.algox.constants.MfgFeeBillLogarithmParam;
import kd.macc.cad.algox.report.function.MfgAmountDealFunction;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.DatSetXUtils;
import kd.macc.cad.algox.utils.DataSetUtils;

public class MfgFeeBillLogarithmQueryAlgoxService {
    private static final Log LOGGER = LogFactory.getLog(MfgFeeBillLogarithmQueryAlgoxService.class);
    private String[] LEFT_CLOUMN_S = new String[]{"accountorg", "accountnumber", "biztotalamount"};
    private String[] RIGHT_CLOUMN_T = new String[]{"bizaccountorg AS accountorg", "account as mfgaccount", "costcenter", "expenseitem", "totalamount"};
    private String[] ALL_CLOUMN = new String[]{"accountnumber", "accountnumber as mfgaccount", "biztotalamount", "costcenter", "expenseitem", "totalamount"};

    protected String getAlgoKey(String methodName) {
        return "mfgthm_" + methodName;
    }

    public DataSet getQueryDataSet(MfgFeeBillLogarithmParam mfgParam) {
        long time = System.currentTimeMillis();
        String srcSys = mfgParam.getSrcsys();
        DataSet dataSet = null;
        if (srcSys.contains("A")) {
            LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2-\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u603b\u8d26\u5f00\u59cb\uff01");
            dataSet = this.queryGLData(mfgParam);
            DataSet glAccountDs = dataSet.select("accountnumber,biztotalamount").distinct();
            DataSet smallGlTotalDs = glAccountDs.groupBy(new String[]{"accountnumber"}).sum("biztotalamount").finish();
            DataSet glToTalDs = glAccountDs.groupBy().sum("biztotalamount").finish().addField("'total'", "type");
            DataSet mfgToTalDs = dataSet.groupBy().sum("totalamount").finish().addField("'total'", "type");
            DataSet smallMfgToTalDs = dataSet.groupBy(new String[]{"mfgaccount"}).sum("totalamount").finish().addField("'small'", "type");
            DataSet dataSetLeft = smallGlTotalDs.leftJoin(smallMfgToTalDs).on("accountnumber", "mfgaccount").select(new String[]{"accountnumber", "biztotalamount"}, new String[]{"mfgaccount"}).finish();
            DataSet dataSetRight = smallGlTotalDs.rightJoin(smallMfgToTalDs).on("accountnumber", "mfgaccount").select(new String[]{"accountnumber"}, new String[]{"mfgaccount", "totalamount"}).finish();
            DataSet dataSetInner = smallGlTotalDs.join(smallMfgToTalDs, JoinType.INNER).on("accountnumber", "mfgaccount").select(new String[]{"accountnumber", "biztotalamount", "totalamount"}).finish();
            dataSetLeft = dataSetLeft.filter("(mfgaccount is null or mfgaccount = 0) and (accountnumber is not null and accountnumber != 0)");
            dataSetLeft = dataSetLeft.addField("0 - biztotalamount", "diffamount");
            dataSetRight = dataSetRight.filter("(accountnumber is null or accountnumber = 0) and (mfgaccount is not null and mfgaccount != 0)");
            dataSetRight = dataSetRight.addField("totalamount - 0", "diffamount");
            dataSetInner = dataSetInner.addField("totalamount - biztotalamount", "diffamount");
            dataSetInner = dataSetInner.union(dataSetLeft).union(dataSetRight);
            dataSetInner = dataSetInner.addField("'1'", "periodname").addField("0", "linetype");
            dataSetInner = dataSetInner.addNullField(new String[]{"accountorg", "period", "costcenter", "localamt", "expenseitem", "costaccountfield", "mfgcurrency"});
            DataSet totalDs = mfgToTalDs.join(glToTalDs).on("type", "type").select(new String[]{"totalamount"}, new String[]{"biztotalamount"}).finish();
            totalDs = totalDs.addFields(new String[]{"1", "'2'", "totalamount - biztotalamount"}, new String[]{"linetype", "periodname", "diffamount"});
            totalDs = totalDs.addNullField(new String[]{"accountorg", "period", "accountnumber", "mfgaccount", "costcenter", "localamt", "expenseitem", "costaccountfield", "mfgcurrency"});
            dataSet = dataSet.addField("'0'", "periodname").addField("0", "linetype");
            dataSet = DataSetUtils.union(totalDs, dataSet);
            dataSet = DataSetUtils.union(dataSetInner, dataSet);
            dataSet = dataSet.orderBy(new String[]{"linetype", "accountnumber", "periodname asc", "costcenter"});
            LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2-\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u603b\u8d26\u7ed3\u675f\uff01");
        }
        if (srcSys.contains("B")) {
            LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2-\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u5e94\u4ed8\u5f00\u59cb\uff01");
            DataSet dataApSet = this.queryAPData(mfgParam);
            dataSet = dataSet == null ? dataApSet : DataSetUtils.union(dataSet, dataApSet);
            LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2-\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u5e94\u4ed8\u7ed3\u675f\uff01");
        }
        LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        LOGGER.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f\uff01");
        return dataSet;
    }

    private DataSet queryAPData(MfgFeeBillLogarithmParam mfgParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DataSet fiApDataSet = this.queryApDataSet(mfgParam, "fi", paramMap);
        DataSet busApDataSet = this.queryApDataSet(mfgParam, "bus", paramMap);
        DataSet apDataSet = DataSetUtils.union(fiApDataSet.copy(), busApDataSet.copy());
        DataSet preBusApDataSet = this.queryApDataSet(mfgParam, "", paramMap);
        Long orgId = mfgParam.getOrg().getLong("id");
        DataSet omMftOrderDataSet = this.queryOmMftOrder(orgId, apDataSet);
        DataSet preMfgDataSet = this.getTarAPDataSet(mfgParam, new String[]{"AP_BUS"}, "<");
        DataSet resultApDataSet = this.resultDataDeal(fiApDataSet, busApDataSet, preBusApDataSet, omMftOrderDataSet, preMfgDataSet);
        String[] srcbilltype = new String[]{"AP_BUS", "AP_FI"};
        DataSet tDataSet = this.getTarAPDataSet(mfgParam, srcbilltype, "=").groupBy(new String[]{"accountorg", "costcenter", "srcbillnumber", "srcbillrow", "expenseitem", "srcbilltype", "calexpenseitem"}).sum("totalamount").groupConcat("billno").finish();
        DataSet leftDs = resultApDataSet.leftJoin(tDataSet).on("srcbillnumber", "srcbillnumber").on("srcbillrow", "srcbillrow").on("srcbilltype", "srcbilltype").select(new String[]{"accountorg", "bizexpenseitem", "localamt", "srcbilltype"}, new String[]{"costcenter", "billno", "expenseitem", "totalamount", "calexpenseitem"}).finish().filter("billno is null or (bizexpenseitem = 0 and calexpenseitem = 0 and localamt != totalamount) or (bizexpenseitem > 0 and calexpenseitem > 0 and (bizexpenseitem != calexpenseitem or localamt != totalamount))");
        DataSet rightDs = resultApDataSet.rightJoin(tDataSet).on("srcbillnumber", "srcbillnumber").on("srcbillrow", "srcbillrow").on("srcbilltype", "srcbilltype").select(new String[]{"bizexpenseitem", "localamt"}, new String[]{"accountorg", "expenseitem", "costcenter", "billno", "totalamount", "srcbilltype", "calexpenseitem"}).finish().filter("localamt is null or (bizexpenseitem = 0 and calexpenseitem = 0 and localamt != totalamount) or (bizexpenseitem > 0 and calexpenseitem > 0 and (bizexpenseitem != calexpenseitem or localamt != totalamount))");
        DataSet resultDataSet = DataSetUtils.union(leftDs, rightDs).groupBy(new String[]{"accountorg", "localamt", "costcenter", "bizexpenseitem", "expenseitem", "billno", "totalamount", "srcbilltype", "calexpenseitem"}).finish().orderBy(new String[]{"costcenter"});
        return resultDataSet.select("accountorg, " + mfgParam.getMulPeriod().getPkValue() + " AS period, 0 AS accountnumber,0 AS biztotalamount, localamt , costcenter, bizexpenseitem, expenseitem, billno, " + mfgParam.getCostAccount().getPkValue() + " AS costaccountfield, totalamount," + mfgParam.getCurrency().getPkValue() + " AS mfgcurrency").orderBy(new String[]{"billno asc"});
    }

    private DataSet resultDataDeal(DataSet fiApDataSet, DataSet busApDataSet, DataSet preBusApDataSet, DataSet omMftOrderDataSet, DataSet preMfgDataSet) {
        JobSession session = AlgoX.createSession((String)"mfgthm_resultDataDeal");
        DataSetX omMftOrderDs = session.fromInput((Input)new DataSetInput(omMftOrderDataSet));
        DataSetX fiApInputDs = session.fromInput((Input)new DataSetInput(fiApDataSet));
        DataSetX fiApDs = fiApInputDs.groupBy(new String[]{"accountorg", "bizexpenseitem", "corebillno", "corebillentryseq", "srcbilltype"}).sum("localamt");
        JoinDataSetX fiApResultDs = fiApDs.join(omMftOrderDs).on("corebillno", "orderbillno").on("corebillentryseq", "orderentryseq").select(new String[]{"accountorg", "bizexpenseitem", "corebillno", "corebillentryseq", "srcbilltype", "localamt"}, new String[]{"srcbillnumber", "srcbillrow"});
        DataSetX busApInputDs = session.fromInput((Input)new DataSetInput(busApDataSet));
        DataSetX busApDs = busApInputDs.groupBy(new String[]{"accountorg", "bizexpenseitem", "corebillno", "corebillentryseq", "srcbilltype"}).sum("localamt").filter("localamt != 0");
        JoinDataSetX busApResultDs = busApDs.join(omMftOrderDs).on("corebillno", "orderbillno").on("corebillentryseq", "orderentryseq").select(fiApDs.getRowMeta().getFieldNames(), new String[]{"srcbillnumber", "srcbillrow"});
        DataSetX preBusApInputDs = session.fromInput((Input)new DataSetInput(preBusApDataSet));
        DataSetX preBusApDs = preBusApInputDs.groupBy(new String[]{"accountorg", "bizexpenseitem", "corebillno", "corebillentryseq"}).sum("prebizamount");
        busApResultDs = busApResultDs.leftJoin(preBusApDs).on("bizexpenseitem", "bizexpenseitem").on("corebillno", "corebillno").on("corebillentryseq", "corebillentryseq").select(busApResultDs.getRowMeta().getFieldNames(), new String[]{"prebizamount"});
        DataSetX preMfgDs = session.fromInput((Input)new DataSetInput(preMfgDataSet));
        preMfgDs = preMfgDs.groupBy(new String[]{"costobject", "srcbillnumber", "srcbillrow", "expenseitem"}).sum("totalamount");
        JoinDataSetX busDs = busApResultDs.leftJoin(preMfgDs).on("srcbillnumber", "srcbillnumber").on("srcbillrow", "srcbillrow").select(busApResultDs.getRowMeta().getFieldNames(), new String[]{"totalamount"});
        DataSetX busResultDs = busDs.map((MapFunction)new MfgAmountDealFunction());
        DataSetX allApDs = DatSetXUtils.union((DataSetX)fiApResultDs, busResultDs);
        DataSetOutput resultSet = new DataSetOutput(allApDs.getRowMeta());
        String resultId = resultSet.getId();
        allApDs.output((Output)resultSet);
        try {
            session.commit(60, TimeUnit.MINUTES);
        }
        catch (CommitTimeoutException e) {
            throw e;
        }
        catch (RunningTimeoutException e) {
            throw e;
        }
        return session.readDataSet(resultId);
    }

    private DataSet queryApDataSet(MfgFeeBillLogarithmParam mfgParam, String type, Map<String, Object> paramMap) {
        String algoKey = this.getAlgoKey("queryApDataSet");
        QFilter generalFilter = new QFilter("billstatus", "=", (Object)"C");
        Long orgId = mfgParam.getOrg().getLong("id");
        generalFilter.and("org", "=", (Object)orgId);
        generalFilter.and("biztype.domain", "=", (Object)"5");
        DynamicObject curPeriod = mfgParam.getMulPeriod();
        Date beginDate = curPeriod.getDate("begindate");
        Date endDate = curPeriod.getDate("enddate");
        QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)beginDate);
        bookDateFilter.and("bookdate", "<=", (Object)endDate);
        String apFields = "";
        DataSet dataSet = null;
        if ("fi".equals(type)) {
            apFields = "org as accountorg, detailentry.expenseitem as bizexpenseitem,detailentry.e_amountbase as localamt, detailentry.corebillno as corebillno, detailentry.corebillentryseq as corebillentryseq, 'AP_FI' as srcbilltype,exratedate,exratetable";
            dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ap_finapbill", (String)apFields, (QFilter[])new QFilter[]{generalFilter, bookDateFilter}, null).select("accountorg,bizexpenseitem,localamt,corebillno,cast(corebillentryseq as String) corebillentryseq,srcbilltype,exratedate,exratetable");
        } else if ("bus".equals(type)) {
            apFields = "org as accountorg, entry.e_expenseitem as bizexpenseitem, entry.e_localamt as localamt, entry.e_corebillno as corebillno, entry.e_corebillentryseq as corebillentryseq, 'AP_BUS' srcbilltype,exratedate,exratetable";
            dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ap_busbill", (String)apFields, (QFilter[])new QFilter[]{generalFilter, bookDateFilter}, null).select("accountorg,bizexpenseitem,localamt,corebillno,cast(corebillentryseq as String) corebillentryseq,srcbilltype,exratedate,exratetable");
        } else {
            QFilter preBookDateFilter = new QFilter("bookdate", "<", (Object)beginDate);
            String apPreFields = "org as accountorg, entry.e_expenseitem as bizexpenseitem, entry.e_localamt as prebizamount, entry.e_corebillno as corebillno, entry.e_corebillentryseq as corebillentryseq,exratedate,exratetable";
            dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ap_busbill", (String)apPreFields, (QFilter[])new QFilter[]{generalFilter, preBookDateFilter}, null).select("accountorg,bizexpenseitem,prebizamount,corebillno,cast(corebillentryseq as String) corebillentryseq,exratedate,exratetable");
        }
        if (!mfgParam.getIsApExchangeRate().booleanValue()) {
            return dataSet;
        }
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] dataFields = rowMeta.getFields();
        DynamicObject currency = mfgParam.getCurrency();
        Long currencyId = currency.getLong("id");
        Long apBasecurrency = mfgParam.getApBasecurrency();
        for (Row row : dataSet) {
            Map exchangeRateByRules;
            Date exrateDate = row.getDate("exratedate");
            Long exrateTable = row.getLong("exratetable");
            String rateKey = exrateTable + "@" + exrateDate.toString();
            if (paramMap.containsKey(rateKey)) {
                exchangeRateByRules = (Map)paramMap.get(rateKey);
            } else {
                exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)apBasecurrency, (Long)currencyId, (Long)exrateTable, (Date)exrateDate);
                paramMap.put(rateKey, exchangeRateByRules);
            }
            LOGGER.info("\u53d6\u5230\u6c47\u7387\u8ba1\u7b97\u65b9\u5f0f,\u6c47\u7387==>{},\u6c47\u7387key==>{}", (Object)exchangeRateByRules, (Object)rateKey);
            Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
            BigDecimal rate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
            Object[] rowData = new Object[dataFields.length];
            for (int i = 0; i < dataFields.length; ++i) {
                String name = dataFields[i].getName();
                Object val = row.get(name);
                if ("localamt".equals(name)) {
                    BigDecimal localamt = row.getBigDecimal("localamt");
                    if (rate != null && rate.compareTo(BigDecimal.ZERO) != 0) {
                        localamt = quoteType != false ? localamt.divide(rate).setScale(10, RoundingMode.HALF_UP) : localamt.multiply(rate).setScale(10, RoundingMode.HALF_UP);
                    }
                    val = localamt;
                }
                if ("prebizamount".equals(name)) {
                    BigDecimal prebizamount = row.getBigDecimal("prebizamount");
                    if (rate != null && rate.compareTo(BigDecimal.ZERO) != 0) {
                        prebizamount = quoteType != false ? prebizamount.divide(rate).setScale(10, RoundingMode.HALF_UP) : prebizamount.multiply(rate).setScale(10, RoundingMode.HALF_UP);
                    }
                    val = prebizamount;
                }
                rowData[i] = val;
            }
            datasetlist.add(rowData);
        }
        return Algo.create((String)"ap").createDataSet(datasetlist.iterator(), rowMeta);
    }

    private DataSet queryOmMftOrder(Long orgId, DataSet apDataSet) {
        HashSet<String> srcNumbers = new HashSet<String>(50);
        HashSet<String> seqs = new HashSet<String>(50);
        for (Row next : apDataSet) {
            srcNumbers.add(next.getString("corebillno"));
            seqs.add(next.getString("corebillentryseq"));
        }
        QFilter outFilter = new QFilter("treeentryentity.orderbillno", "in", srcNumbers);
        outFilter.and("treeentryentity.orderentryseq", "in", seqs);
        outFilter.and("billstatus", "=", (Object)"C");
        String fields = "treeentryentity.orderbillno as orderbillno, treeentryentity.orderentryseq as orderentryseq, treeentryentity.seq as srcbillrow, billno AS srcbillnumber";
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("queryOmMftOrder"), (String)"om_mftorder", (String)fields, (QFilter[])new QFilter[]{outFilter}, null);
    }

    private DataSet getTarAPDataSet(MfgFeeBillLogarithmParam mfgParam, String[] srcbilltype, String periodFilterStr) {
        String fields = "org AS accountorg, billno, impschid, srcbilltype,costobject, costobject.srcbillnumber AS srcbillnumber, costobject.srcbillrow AS srcbillrow, costcenter, costaccount, totalamount,expenseitem";
        QFilter qfFilter = new QFilter("org", "=", (Object)mfgParam.getOrg().getLong("id"));
        QFilter periodFilter = new QFilter("period", periodFilterStr, (Object)mfgParam.getMulPeriod().getLong("id"));
        QFilter actFilter = new QFilter("costaccount", "=", (Object)mfgParam.getCostAccount().getLong("id"));
        QFilter currencyFilter = new QFilter("currency", "=", (Object)mfgParam.getCurrency().getLong("id"));
        QFilter typeFilter = new QFilter("srcbilltype", "in", (Object)srcbilltype);
        QFilter appFilter = new QFilter("appnum", "=", (Object)mfgParam.getAppnum());
        QFilter srcBizSysFilter = new QFilter("srcbizsys.number", "=", (Object)"ap");
        QFilter srcBillFilter = new QFilter("srcbill", "=", (Object)"ap_process");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getTarAPDataSet"), (String)"cad_mfgfeebill", (String)fields, (QFilter[])new QFilter[]{qfFilter, periodFilter, actFilter, currencyFilter, typeFilter, appFilter}, null);
        DataSet impDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getTarAPDataSet"), (String)"sca_mfgfeeimpsch", (String)"id, billno AS impbillno", (QFilter[])new QFilter[]{qfFilter, actFilter, srcBizSysFilter, appFilter, srcBillFilter}, null).select("cast(id as String) impid, impbillno");
        dataSet = dataSet.leftJoin(impDataSet).on("impschid", "impid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"impbillno"}).finish().select("accountorg,billno,srcbilltype,costobject,srcbillnumber,srcbillrow,costcenter,costaccount,totalamount,expenseitem,case when impbillno is null then expenseitem else 0L end as calexpenseitem");
        return dataSet;
    }

    private DataSet queryGLData(MfgFeeBillLogarithmParam mfgParam) {
        DataSet sDataSet = this.getSrcDataSet(mfgParam);
        sDataSet = sDataSet.groupBy(new String[]{"accountorg", "accountnumber"}).sum("biztotalamount").finish();
        DataSet tDataSet = this.getTarDataSet(mfgParam);
        tDataSet = tDataSet.groupBy(new String[]{"bizaccountorg", "costcenter", "bizperiod", "account", "expenseitem", "mfgcurrency"}).sum("totalamount").finish();
        DataSet dataSetLeft = sDataSet.leftJoin(tDataSet).on("accountnumber", "account").select(this.LEFT_CLOUMN_S, new String[]{"account as collectaccount"}).finish();
        DataSet dataSetRight = sDataSet.rightJoin(tDataSet).on("accountnumber", "account").select(new String[]{"accountnumber as bizaccountnumber"}, this.RIGHT_CLOUMN_T).finish();
        DataSet dataSetInner = sDataSet.join(tDataSet, JoinType.INNER).on("accountnumber", "account").select(this.ALL_CLOUMN).finish();
        dataSetLeft = dataSetLeft.filter("collectaccount is null or collectaccount = 0").addNullField(new String[]{"mfgaccount", "costcenter", "expenseitem", "totalamount"});
        dataSetLeft = dataSetLeft.removeFields(new String[]{"collectaccount"});
        dataSetLeft = dataSetLeft.addField("0 - biztotalamount", "diffamount");
        dataSetRight = dataSetRight.filter("bizaccountnumber is null or bizaccountnumber = 0").addNullField(new String[]{"accountnumber", "biztotalamount"});
        dataSetRight = dataSetRight.removeFields(new String[]{"bizaccountnumber"});
        dataSetRight = dataSetRight.addField("totalamount - 0", "diffamount");
        DataSet groupInnerDs = dataSetInner.groupBy(new String[]{"accountnumber"}).sum("totalamount").finish();
        dataSetInner = dataSetInner.leftJoin(groupInnerDs).on("accountnumber", "accountnumber").select(dataSetInner.getRowMeta().getFieldNames(), new String[]{"totalamount as sumtotalamount"}).finish();
        dataSetInner = dataSetInner.addField("sumtotalamount - biztotalamount", "diffamount");
        dataSetInner = dataSetInner.removeFields(new String[]{"sumtotalamount"});
        DataSet dataSetAll = DataSetUtils.union(dataSetLeft, dataSetRight);
        dataSetAll = DataSetUtils.union(dataSetInner, dataSetAll);
        dataSetAll = dataSetAll.select(mfgParam.getOrg().getPkValue() + " AS accountorg, " + mfgParam.getMulPeriod().getPkValue() + " AS period, accountnumber, biztotalamount,mfgaccount,costcenter,0 AS localamt,expenseitem," + mfgParam.getCostAccount().getPkValue() + " AS costaccountfield,totalamount,diffamount," + mfgParam.getCurrency().getPkValue() + " AS mfgcurrency").distinct();
        if (mfgParam.getOnlyShowDiff().booleanValue()) {
            dataSetAll = dataSetAll.filter("diffamount is null or diffamount != 0");
        }
        return dataSetAll.orderBy(new String[]{"accountnumber", "costcenter"});
    }

    private DataSet getTarDataSet(MfgFeeBillLogarithmParam mfgParam) {
        String fields = "org AS bizaccountorg,costcenter,costaccount,period AS bizperiod,account,expenseitem,totalamount,currency AS mfgcurrency,voucherentry";
        QFilter filter = new QFilter("org", "=", mfgParam.getOrg().getPkValue());
        filter.and(new QFilter("period", "=", mfgParam.getMulPeriod().getPkValue()));
        filter.and(new QFilter("costaccount", "=", mfgParam.getCostAccount().getPkValue()));
        filter.and(new QFilter("account", "in", mfgParam.getAccountViewIds()));
        filter.and(new QFilter("sourcetype", "in", (Object)new String[]{"SYS", "sys", "CONFIG"}));
        filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"VOUCHER", "gl_voucher", ""}));
        filter.and(new QFilter("appnum", "=", (Object)mfgParam.getAppnum()));
        if (!CadEmptyUtils.isEmpty(mfgParam.getMulCostCenterIds())) {
            filter.and("costcenter", "in", mfgParam.getMulCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(mfgParam.getMulExpenseItemIds())) {
            filter.and("expenseitem", "in", mfgParam.getMulExpenseItemIds());
        }
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getTarDataSet"), (String)"cad_mfgfeebill", (String)fields, (QFilter[])new QFilter[]{filter}, null);
    }

    private List<Field> getField(String costcentStr, String bizexpenseitemStr) {
        ArrayList<Field> field = new ArrayList<Field>(33);
        field.add(new Field("org", (DataType)DataType.LongType));
        field.add(new Field("period", (DataType)DataType.LongType));
        field.add(new Field("account", (DataType)DataType.LongType));
        if (!CadEmptyUtils.isEmpty(costcentStr)) {
            field.add(new Field(costcentStr, (DataType)DataType.LongType));
        }
        if (!CadEmptyUtils.isEmpty(bizexpenseitemStr)) {
            field.add(new Field(bizexpenseitemStr, (DataType)DataType.LongType));
        }
        field.add(new Field("currency", (DataType)DataType.LongType));
        field.add(new Field("measureunit", (DataType)DataType.LongType));
        field.add(new Field("endlocal", (DataType)DataType.BigDecimalType));
        field.add(new Field("beginlocal", (DataType)DataType.BigDecimalType));
        return field;
    }

    private DataSet getSrcDataSet(MfgFeeBillLogarithmParam mfgParam) {
        Map<String, Object> exchangeRateByRules;
        String data = this.getGlData(mfgParam);
        ArrayList dataList = SerializationUtils.fromJsonStringToList((String)data, Map.class);
        if (dataList == null) {
            dataList = new ArrayList();
        }
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        String costcentStr = mfgParam.getCostcentStr();
        String bizexpenseitemStr = mfgParam.getBizexpenseitemStr();
        for (Map map : dataList) {
            ArrayList temp = new ArrayList();
            temp.add(map.get("org"));
            temp.add(map.get("period"));
            temp.add(map.get("account"));
            if (!CadEmptyUtils.isEmpty(costcentStr)) {
                temp.add(map.get(costcentStr));
            }
            if (!CadEmptyUtils.isEmpty(bizexpenseitemStr)) {
                temp.add(map.get(bizexpenseitemStr));
            }
            temp.add(map.get("currency"));
            temp.add(map.get("measureunit"));
            temp.add(map.get("endlocal"));
            temp.add(map.get("beginlocal"));
            datasetlist.add(temp.toArray());
        }
        StringBuilder selectFields = new StringBuilder("org As accountorg,period,account AS accountnumber,currency,measureunit,endlocal-beginlocal AS biztotalamount");
        StringBuilder sbFields = new StringBuilder("accountorg,period,accountnumber,biztotalamount");
        StringBuilder otherFields = new StringBuilder("accountorg,period,accountnumber");
        if (!CadEmptyUtils.isEmpty(costcentStr)) {
            selectFields.append(",").append(costcentStr);
            sbFields.append(",").append(costcentStr).append(" AS bizcostcenter");
            otherFields.append(",").append("bizcostcenter");
        } else {
            sbFields.append(",").append(0).append(" bizcostcenter");
            otherFields.append(",").append("bizcostcenter");
        }
        if (!CadEmptyUtils.isEmpty(bizexpenseitemStr)) {
            selectFields.append(",").append(bizexpenseitemStr);
            sbFields.append(",").append(bizexpenseitemStr).append(" AS bizexpenseitem");
            otherFields.append(",").append("bizexpenseitem");
        } else {
            sbFields.append(",").append(0).append(" bizexpenseitem");
            otherFields.append(",").append("bizexpenseitem");
        }
        DataSet dataSetTemp = Algo.create((String)"mn").createDataSet(datasetlist.iterator(), new RowMeta(this.getField(costcentStr, bizexpenseitemStr).toArray(new Field[0]))).select(selectFields.toString());
        QFilter assgrpFilter = this.getAssgrpFilter(mfgParam);
        DataSet dataSet = dataSetTemp.filter(assgrpFilter.toString()).select(sbFields.toString());
        if (mfgParam.getIsExchangeRate().booleanValue() && !CadEmptyUtils.isEmpty(exchangeRateByRules = mfgParam.getExchangeRateMap())) {
            Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
            BigDecimal rate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
            BigDecimal amountValue = BigDecimal.ONE;
            if (rate != null && rate.compareTo(BigDecimal.ZERO) != 0) {
                amountValue = quoteType != false ? amountValue.divide(rate).setScale(10, RoundingMode.HALF_UP) : amountValue.multiply(rate).setScale(10, RoundingMode.HALF_UP);
            }
            otherFields.append(",").append("biztotalamount * ").append(amountValue).append(" AS biztotalamount");
            dataSet = dataSet.select(otherFields.toString());
        }
        return dataSet;
    }

    private QFilter getAssgrpFilter(MfgFeeBillLogarithmParam mfgParam) {
        Map<String, HashSet> flexMap;
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (mfgParam.getFlexMap() != null && mfgParam.getFlexMap().size() > 0 && (flexMap = mfgParam.getFlexMap()) != null && flexMap.size() > 0) {
            for (Map.Entry<String, HashSet> setEntry : flexMap.entrySet()) {
                if (setEntry.getValue() == null || setEntry.getValue().size() <= 0) continue;
                filter.and(new QFilter(setEntry.getKey(), "in", (Object)setEntry.getValue()));
            }
        }
        return filter;
    }

    private String getGlData(MfgFeeBillLogarithmParam mfgParam) {
        BalanceQueryParam params = new BalanceQueryParam();
        params.setOrgId((Long)mfgParam.getOrg().getPkValue());
        params.setCurrencyId((Long)mfgParam.getCurrency().getPkValue());
        if (mfgParam.getIsExchangeRate().booleanValue()) {
            params.setCurrencyId(mfgParam.getBasecurrency());
        }
        params.setPeriodId((Long)mfgParam.getMulPeriod().getPkValue());
        params.setBookTypeId(mfgParam.getBooksTypeId());
        params.setSubstractPL(true);
        params.isSubstractPL();
        params.isSpecialAccount();
        Set<Long> accountViewIds = mfgParam.getAccountViewIds();
        Map<String, HashSet> flexMap = mfgParam.getFlexMap();
        ArrayList<Map<String, Long>> subList = new ArrayList<Map<String, Long>>(accountViewIds.size());
        HashMap tempMap = new HashMap(16);
        List<String> accountFlex = mfgParam.getAccountFlex();
        HashSet<String> keySet = new HashSet<String>();
        for (Long accountId : accountViewIds) {
            tempMap.clear();
            subList.clear();
            for (String key : flexMap.keySet()) {
                if (!accountFlex.contains(key)) continue;
                keySet.add(key);
                tempMap.put(key, null);
            }
            subList.add(tempMap);
            params.setAccountAssgrp(accountId, subList);
        }
        mfgParam.setKeySet(keySet);
        List<String> selectors = params.getSelector();
        List<String> groupBys = params.getGroupBy();
        groupBys.add("org");
        groupBys.add("period");
        groupBys.add("account");
        groupBys.add("currency");
        groupBys.add("measureunit");
        selectors.add("org");
        selectors.add("period");
        selectors.add("account");
        selectors.add("currency");
        selectors.add("measureunit");
        selectors.add("endlocal");
        selectors.add("beginlocal");
        for (String str : keySet) {
            groupBys.add(str);
            selectors.add(str);
        }
        String jsonData = SerializationUtils.toJsonString((Object)params);
        String data = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{jsonData});
        return data;
    }
}

