/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.algox.report.function;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.utils.BigDecimalUtil;

public class MfgBillDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;

    public MfgBillDealFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        Iterator<RowX> it = rows.iterator();
        BigDecimal allTotalAmount = BigDecimal.ZERO;
        StringBuilder billnos = new StringBuilder();
        int amountCol = this.rowMeta.getFieldIndex("totalamount");
        int billnoCol = this.rowMeta.getFieldIndex("billno");
        RowX targetRow = null;
        while (it.hasNext()) {
            RowX row = it.next();
            if (targetRow == null) {
                targetRow = new RowX(row.size());
                for (int i = 0; i < row.size(); ++i) {
                    targetRow.set(i, row.get(i));
                }
            }
            BigDecimal totalAmount = BigDecimalUtil.getOrZero(row.getBigDecimal(amountCol));
            allTotalAmount = allTotalAmount.add(totalAmount);
            String billno = row.getString(billnoCol);
            if (billnos.length() == 0) {
                billnos.append(billno);
            }
            billnos.append(billno).append(",");
        }
        if (targetRow != null) {
            targetRow.set(amountCol, (Object)allTotalAmount);
            targetRow.set(billnoCol, (Object)billnos.toString());
            collector.collect(targetRow);
        }
    }
}

